{Keyboard handling unit.                                                     }
{v1.0.1 (c) 05.11.1997 by Flying/Digital Reality                             }
Unit Keyboard;

Interface

Type
  TControlKeys = set of char;

Const
  kb_Space  = #32;
  kb_Enter  = #13;
  kb_Esc    = #27;
  kb_Left   = #75;
  kb_Right  = #77;
  kb_Up     = #72;
  kb_Down   = #80;
  kb_Ins    = #82;
  kb_Home   = #71;
  kb_PgUp   = #73;
  kb_Del    = #83;
  kb_End    = #79;
  kb_PgDn   = #81;
  kb_BSpace = #08;
  kb_Tab    = #09;

  ControlKeys : TControlKeys =
    [kb_Space,kb_Enter,kb_Left,kb_Right,kb_Up,kb_Down,
     kb_Ins,kb_Home,kb_PgUp,kb_Del,kb_End,kb_PgDn,
     kb_BSpace,kb_Tab];

Function  KeyPressed : Boolean;
Function  EscPressed : Boolean;
Procedure EmptyKeyBuffer;
Function  RightShift: Boolean;
Function  LeftShift: Boolean;
Function  Control: Boolean;
Function  Alt: Boolean;
Function  ScrollLock: Boolean;
Function  NumLock: Boolean;
Function  CapsLock: Boolean;
Function  Insert: Boolean;
Function  ReadKey:char;

Implementation

Uses Dos;

Var
  OneMoreKey:boolean;
  LastKey:char;

Function ShiftState: Byte;
Var Regs: Registers;
Begin
  Regs.Ah:=2;
  Intr($16, Regs);
  ShiftState:=Regs.Al;
End;

Function RightShift: Boolean;
Begin
  RightShift:=(ShiftState and 1)<>0;
End;

Function LeftShift: Boolean;
Begin
  LeftShift:=(ShiftState and 2)<>0;
End;

Function Control: Boolean;
Begin
  Control:=(ShiftState and 4)<>0;
End;

Function Alt: Boolean;
Begin
  Alt:=(ShiftState and 8)<>0;
End;

Function ScrollLock: Boolean;
Begin
  ScrollLock:=(ShiftState and 16)<>0;
End;

Function NumLock: Boolean;
Begin
  NumLock:=(ShiftState and 32)<>0;
End;

Function CapsLock: Boolean;
Begin
  CapsLock:=(ShiftState and 64)<>0;
End;

Function Insert: Boolean;
Begin
  Insert:=(ShiftState and 128)<>0;
End;

Function EscPressed : boolean;
var
  result:byte;
begin
  asm
    mov ah,1
    int 16h
    mov al,0
    jz @no_esc
    mov ah,al
    int 16h
    xor al,al
    cmp ah,1
    jnz @no_esc
    mov al,$ff
@no_esc:
    mov result,al
  end;
  EscPressed:=result=$ff;
end;

Function Keypressed:boolean;
var
  result:byte;
begin
  asm
    mov ah,1
    int 16h
    mov al,0
    jz @nokey
    mov al,$ff
@nokey:
    mov result,al
  end;
  Keypressed:=result=$ff;
end;

Procedure EmptyKeyBuffer;
begin
{$IFDEF DPMI}
  while KeyPressed do
    ReadKey;
{$ELSE}
  MemW[$0000:$041C] := MemW[$0000:$041A];
{$ENDIF}
end;

Function ReadKey:char;
var
  K:word;
  T:byte;
begin
  if OneMoreKey then
  begin
    ReadKey:=LastKey;
    OneMoreKey:=false;
    exit;
  end;
  asm
    mov  ah,10h
    int  16h
    mov  K,ax
  end;
  If ((K and $FF)=0) or ((K and $FF)=$E0) then
    begin
      ReadKey:=#00{chr(Lo(K))};
      OneMoreKey:=true;
      LastKey:=chr(Hi(K));
    end
  else
    begin
      ReadKey:=chr(Lo(K));
      OneMoreKey:=false;
    end
end;

BEGIN
END.
