Program Binary_Hobeta_Converter;

Uses
  Dos,
  Speccy,
  CLParser,
  ExitUnit;

Var
  P:PathStr;
  D:DirStr;
  N:NameStr;
  E:ExtStr;
  FName:string;
  outFName:string;
  fi,fo:file;
  Buf:pointer;
  Hob:THobetaInfo;
  Hdr:THobetaHeader;
  fsize:longint;
  w:word;
  s:string;
  Ext:string;
  isImprove:boolean;
  useLength:boolean;
  StartExist:boolean;

Procedure InitMem;
begin
  GetMem(Buf,$FFF8);
  InitCLParser;
  FName:='';
  outFName:='';
  useLength:=false;
  with Hob do
  begin
    Name:='';
    Ext:=#00;
    Start:=0;
    Length:=0;
  end;
  StartExist:=false;
  Ext:='';
  isImprove:=false;
end;

Procedure DoneMem;far;
begin
  DoneCLParser;
  FreeMem(Buf,$FFF8);
end;

BEGIN
  InitMem;
  DoneMemProc:=DoneMem;
  if CLParam^.GetParamCount=0 then
  begin
    writeln('Binary <-> Hobeta converter.');
    writeln('v3.11 (c) 27.12.1999 by Flying/Digital Reality');
    writeln;
    writeln('Usage: BIN_HOB <Filename> [Output Filename] [Parameters]');
    writeln('If this file is Hobeta file - it will be converted into');
    writeln('binary file, else it will be converted into Hobeta file');
    writeln;
    writeln('Parameters: /|-<key>[:<value>]');
    writeln(' I - Improve checksum into corrupted Hobeta file');
    writeln;
    writeln('Binary->Hobeta specific parameters:');
    writeln(' N - set TR-DOS name');
    writeln(' E - set TR-DOS extension');
    writeln(' S - set Start parameter value');
    writeln;
    writeln('Hobeta->Binary specific parameters:');
    writeln(' L - Use Length parameter instead of Sectors Quantity');
    writeln(' E - Set MS-DOS file extension');
    writeln;
    halt(exit_Ok);
  end;
  with CLParam^ do
  begin
    if isParamExist(1) and not isKey(1) then
      GetStringParamNum(1,FName);
    if isParamExist(2) and not isKey(2) then
      GetStringParamNum(2,outFName);
    if isKeyExist('I') then
      isImprove:=true;
  end;
  if isImprove then
    begin
{Improving corrupted Hobeta file}
      write('Improving corrupted Hobeta file...');
      Assign(fi,FName);
{$I-}
      reset(fi,1);
{$I+}
      if IOResult<>exit_Ok then
      begin
        ErrorMessage:=FName;
        halt(exit_ErrorOpenFile);
      end;
      {Read Hobeta header}
      BlockRead(fi,Hdr,HobetaHeaderSize);
      {Improve it}
      HobetaHeader2Info(Hdr,Hob);
      HobetaInfo2Header(Hob,Hdr);
      {Write new header into file}
      Seek(fi,0);
      BlockWrite(fi,Hdr,HobetaHeaderSize);
      {Re-read it to be able to view Hobeta header info}
      Seek(fi,0);
      BlockRead(fi,Hdr,HobetaHeaderSize);
      HobetaHeader2Info(Hdr,Hob);
      close(fi);
    end
  else
    if GetHobetaInfo(FName,Hob) then
{Converting Hobeta->Binary}
      begin
        with CLParam^ do
        begin
          if isKeyExist('L') then
            useLength:=true;
          if isKeyExist('E') then
            GetStringParamKey('E',Ext);
        end;
        write('Converting Hobeta->Binary...');
        Assign(fi,FName);
{$I-}
        reset(fi,1);
{$I+}
        if IOResult<>exit_Ok then
        begin
          ErrorMessage:=FName;
          halt(exit_ErrorOpenFile);
        end;
        fsize:=FileSize(fi)-HobetaHeaderSize;
        w:=fsize and $FFFF;
        BlockRead(fi,Hdr,HobetaHeaderSize);
        if useLength then
        begin
          HobetaHeader2Info(Hdr,Hob);
          w:=Hob.Length;
        end;
        if outFName='' then
        begin
          FSplit(FName,D,N,E);
          if Ext<>'' then
            outFName:=D+N+'.'+Ext
          else
            outFName:=D+N+'._'+Hob.Ext+'_';
        end;
        Assign(fo,outFName);
{$I-}
        rewrite(fo,1);
{$I+}
        if IOResult<>exit_Ok then
        begin
          ErrorMessage:=outFName;
          halt(exit_ErrorOpenFile);
        end;
        BlockRead(fi,Buf^,w);
        BlockWrite(fo,Buf^,w);
        close(fi);
        close(fo);
      end
    else
{Converting Binary->Hobeta}
      begin
        with CLParam^ do
        begin
          if isKeyExist('N') then
          begin
            GetStringParamKey('N',s);
            if length(s)>8 then
              s:=Copy(s,1,8);
            while length(s)<8 do s:=s+' ';
            Hob.Name:=Copy(s,1,8);
          end;
          if isKeyExist('E') then
          begin
            GetStringParamKey('E',s);
            if length(s)>0 then
              Hob.Ext:=s[1];
          end;
          if isKeyExist('S') then
          begin
            GetWordParamKey('S',Hob.Start);
            StartExist:=true;
          end;
        end;
        write('Converting Binary->Hobeta...');
        Assign(fi,FName);
{$I-}
        reset(fi,1);
{$I+}
        if IOResult<>exit_Ok then
        begin
          ErrorMessage:=FName;
          halt(exit_ErrorOpenFile);
        end;
        fsize:=FileSize(fi);
        if fsize>$FFF8 then
        begin
          ErrorMessage:='File too long!';
          halt(exit_CustomError);
        end;
        w:=fsize and $FFFF;
        BlockRead(fi,Buf^,w);
        with Hob do
        begin
          FSplit(FName,D,N,E);
          if Name='' then
            Name:=N;
          if byte(Ext)=0 then
            Ext:='C';
          if not StartExist then
            Start:=0;
          Length:=w;
        end;
        P:=D+N+'.$'+Hob.Ext;
        WriteHobetaFile(P,Hob,Buf,w);
      end;
  writeln(' Done');
  if isImprove then
  begin
    writeln;
    writeln('Hobeta header data:');
    writeln('Filename : ',Hob.Name);
    writeln('Extension: ',Hob.Ext);
    writeln('Start    : ',Hob.Start);
    writeln('Length   : ',Hob.Length);
    writeln('Sectors  : ',Hob.QSectors);
  end;
END.
