.CPU 686
.BITS 32
.FPU
.ENTRYPOINT

.EXTERNAL GetTickCount "GetTickCount"
.EXTERNAL ExitProcess

.EXTERNAL CreateWindowExA
.EXTERNAL ChangeDisplaySettingsA
.EXTERNAL GetDC
.EXTERNAL ShowCursor
.EXTERNAL PeekMessageA

.EXTERNAL ChoosePixelFormat
.EXTERNAL SetPixelFormat
.EXTERNAL SwapBuffers

.EXTERNAL wglCreateContext
.EXTERNAL wglMakeCurrent
.EXTERNAL glBegin
.EXTERNAL glClearColor
.EXTERNAL glClear
.EXTERNAL glColor3f
.EXTERNAL glEnd
.EXTERNAL glFrustum
.EXTERNAL glLoadIdentity
.EXTERNAL glMatrixMode
.EXTERNAL glRotatef
.EXTERNAL glTranslatef
.EXTERNAL glVertex3f

.SECTION(".code",CNT_CODE|MEM_READ|MEM_EXECUTE){
 .PUBLIC _WinMainCRTStartup
 _WinMainCRTStartup:
  invlab Init
  mainloop:
   invlab PeekMessageA,dword offset message,byte 0,byte 0,byte 0,byte 1
   cmp dword ptr [message+8],27
   je done
    invlab GetTickCount
    sub eax,edi
    invlab Render
    invlab SwapBuffers,esi
   jmp mainloop
   done:
 invlab ExitProcess,byte 0
}

.SECTION(".code2",CNT_CODE|MEM_READ|MEM_EXECUTE){
 .PUBLIC Init
 Init:
  invlab CreateWindowExA,byte 8,dword offset wclass,byte 0,dword 0x90880000,byte 0,byte 0,dword 640,dword 480,byte 0,byte 0,byte 0,byte 0
  invlab GetDC,eax
  mov esi,eax
  invlab ChangeDisplaySettingsA,dword offset dmscreensettings,byte 4
  invlab ShowCursor,byte 0
  invlab ChoosePixelFormat,esi,dword offset pixelformatdescriptor
  invlab SetPixelFormat,esi,eax,dword offset pixelformatdescriptor
  invlab wglCreateContext,esi
  invlab wglMakeCurrent,esi,eax
  invlab GetTickCount
  mov edi,eax
 ret
}

.SECTION(".code3",CNT_CODE|MEM_READ|MEM_EXECUTE){
 .PUBLIC Render
 Render:
  push edi
  push esi
   shr eax,byte 1
   mov dword ptr [tmptime],eax
   fild dword ptr [tmptime]
   fstp dword ptr [tmptime]
   invlab glClearColor,byte 0,float 1.0,byte 0,byte 0
   invlab glClear,dword 0x4100
   invlab glMatrixMode,dword 0x1701
   invlab glLoadIdentity
   invlab glFrustum,split double -0.01,split double 0.01,split double -0.0075,split double 0.0075,split double 0.01,split double 1000.0
   invlab glMatrixMode,dword 0x1700
   invlab glLoadIdentity
   invlab glTranslatef,byte 0,byte 0,float -1.75
   invlab glRotatef,float [tmptime],byte 0,float 1.0,float 1.0
   invlab glBegin,byte 4
    invlab glColor3f,float 1.0,byte 0,byte 0
    invlab glVertex3f,byte 0,float 0.5,byte 0
    invlab glColor3f,byte 0,float 1.0,byte 0
    invlab glVertex3f,float -0.5,float -0.5,byte 0
    invlab glColor3f,byte 0,byte 0,float 1.0
    invlab glVertex3f,float 0.5,float -0.5,byte 0
   invlab glEnd
  pop esi
  pop edi
 ret
}

.SECTION(".data",CNT_DATA|MEM_READ|MEM_WRITE){
 wclass: dstr "EDIT\0"
}

.SECTION(".data2",CNT_DATA|MEM_READ|MEM_WRITE){
 pixelformatdescriptor:
  db 40,0,1,0,37,0,0,0,0,32
  resb 13
  db 16
  resb 16

 dmscreensettings:
  resb 36
  dd 0x9c,0x1c0000
  resb 60
  dd 32,640,480
}

.SECTION(".bss",CNT_BSS|MEM_READ|MEM_WRITE){
 tmptime: resd 1
 message: resb 32
}
