int 
  all = $0000
  res = start
  nmi = VB
end

	org $8000

colourRegister = $0000
char           = $0002
flag           = $0004
joyreg1        = $0006
joyreg2        = $0007
xpos           = $0008
ypos           = $0009
flip           = $000a
vert           = $000b
start
	sei             ; disable interrupts
	phk             ; push current bank on stack
	plb             ; pop it off the stack and make it the current programming bank
	clc
	xce             ; native 16-bit mode
	
	sep #$30        ; make X, Y, A all 8-bits
	lda #$8F        ; screen off, full brightness
	sta $2100       ; brightness & screen enable register
	stz $2101       ; sprite register (size & address in VRAM)
	stz $2102       ; sprite registers (address of sprite memory [OAM])
	stz $2103       ; sprite registers (address of sprite memory [OAM])
	stz $2105       ; graphic mode register
	stz $2106       ; mosaic register
	stz $2107       ; plane 0 map VRAM location
	stz $2108       ; plane 1 map VRAM location
	stz $2109       ; plane 2 map VRAM location
	stz $210A       ; plane 3 map VRAM location
	stz $210B       ; plane 0&1 Tile data location
	stz $210C       ; plane 2&3 Tile data location
	stz $210D       ; plane 0 scroll x (first 8 bits)
	stz $210D       ; plane 0 scroll x (last 3 bits)
	stz $210E       ; plane 0 scroll y (first 8 bits)
	stz $210E       ; plane 0 scroll y (last 3 bits)
	stz $210F       ; plane 1 scroll x (first 8 bits)
	stz $210F       ; plane 1 scroll x (last 3 bits)
	stz $2110       ; plane 1 scroll y (first 8 bits)
	stz $2110       ; plane 1 scroll y (last 3 bits)
	stz $2111       ; plane 2 scroll x (first 8 bits)
	stz $2111       ; plane 2 scroll x (last 3 bits)
	stz $2112       ; plane 2 scroll y (first 8 bits)
	stz $2112       ; plane 2 scroll y (last 3 bits)
	stz $2113       ; plane 3 scroll x (first 8 bits)
	stz $2113       ; plane 3 scroll x (last 3 bits)
	stz $2114       ; plane 3 scroll y (first 8 bits)
	stz $2114       ; plane 3 scroll y (last 3 bits)
	lda #$80        ; increase VRAM address after writing to $2119
	sta $2115       ; VRAM address increment register
	stz $2116       ; VRAM address low
	stz $2117       ; VRAM address high
	stz $211A       ; initial mode 7 setting register
	stz $211B       ; mode 7 matrix parameter A register (low)
	lda #$01
	sta $211B       ; mode 7 matrix parameter A register (high)
	stz $211C       ; mode 7 matrix parameter B register (low)
	stz $211C       ; mode 7 matrix parameter B register (high)
	stz $211D       ; mode 7 matrix parameter C register (low)
	stz $211D       ; mode 7 matrix parameter C register (high)
	stz $211E       ; mode 7 matrix parameter D register (low)
	sta $211E       ; mode 7 matrix parameter D register (high)
	stz $211F       ; mode 7 center position X register (low)
	stz $211F       ; mode 7 center position X register (high)
	stz $2120       ; mode 7 center position Y register (low)
	stz $2120       ; mode 7 center position Y register (high)
	stz $2121       ; color number register ($00-$ff)
	stz $2123       ; bg1 & bg2 window mask setting register
	stz $2124       ; bg3 & bg4 window mask setting register
	stz $2125       ; obj & color window mask setting register
	stz $2126       ; window 1 left position register
	stz $2127       ; window 2 left position register
	stz $2128       ; window 3 left position register
	stz $2129       ; window 4 left position register
	stz $212A       ; bg1, bg2, bg3, bg4 window logic register
	stz $212B       ; obj, color window logic register (or, and, xor, xnor)
	sta $212C       ; main screen designation (planes, sprites enable)
	stz $212D       ; sub screen designation
	stz $212E       ; window mask for main screen
	stz $212F       ; window mask for sub screen
	lda #$30
	sta $2130       ; color addition & screen addition init setting
	stz $2131       ; add/sub sub designation for screen, sprite, color
	lda #$E0
	sta $2132       ; color data for addition/subtraction
	stz $2133       ; screen setting (interlace x,y/enable SFX data)
	stz $4200       ; enable v-blank, interrupt, joypad register
	lda #$FF
	sta $4201       ; programmable I/O port
	stz $4202       ; multiplicand A
	stz $4203       ; multiplier B
	stz $4204       ; multiplier C
	stz $4205       ; multiplicand C
	stz $4206       ; divisor B
	stz $4207       ; horizontal count timer
	stz $4208       ; horizontal count timer MSB
	stz $4209       ; vertical count timer
	stz $420A       ; vertical count timer MSB
	stz $420B       ; general DMA enable (bits 0-7)
	stz $420C       ; horizontal DMA (HDMA) enable (bits 0-7)
	stz $420D       ; access cycle designation (slow/fast rom)

	rep #$30        ; A, X, Y 16-bits
	sep #$20        ; A 8-bits

	lda #$01        ; mode 7
	sta $2105
	lda #$11        ; enable plane 0 and sprites
	sta $212c
	lda #$62  ;1E
	sta $2101       ; sprite sizes and adddress

	stz char
	stz flag
	stz flip
	stz vert
	stz.w joyreg1 
	lda.b #$70
	sta.b xpos
	sta.b ypos
	lda.b #128
	sta colourRegister
	ldx.v #$0000

setColour
	lda colourRegister
	sta $2121       ; set colour register to update
	clc
	adc #$01
	sta colourRegister

	lda imageData,x ; get low byte of colour
	inx.v
	sta $2122
	lda imageData,x ; get high byte of colour
	inx.v
	sta $2122

	cpx.v #32    ; done all 256 colours?
	bne setColour
	
	ldx.v #$0000    ; set VRAM pointer to $0000
	stx $2116

	ldx.v #$0200    ; offset from end of colour data
copyData
	lda #$00        ; get tile name
	inx.v
	sta $2118
	lda #$00        ; get tile data
	inx.v
	sta $2119
	cpx.v #$4200    ; all data copied?
	bne copyData
	
	ldx.v #$0000
	stx $2102

copyInitialSprite
	lda initialSpriteData,x
	inx.v
	sta $2104
	lda initialSpriteData,x
	inx.v
	sta $2104
	cpx.v #$0220
	bne copyInitialSprite

	ldx.v #$4000
	stx $2116

	ldx.v #$0000
copyFontData
	lda fontData,x  ; sprite data
	inx.v
	sta $2118
	lda fontData,x
	inx.v
	sta $2119
	cpx.v #1024 ;#$1000    ; all data copied?
	bne copyFontData
	
	lda #$00
	sta $2107
	lda #$01
	sta $210b
	
	lda #$81
	sta $4200
	cli 
	lda #$0F        ; enable screen, full brightness
	sta $2100

mainLoop
	wai
	lda.b joyreg2
	bit #$01
	beq left
	inc xpos
	bra ml
left    bit #$02
	beq down
	dec xpos
	bra ml
down    bit #$04
	beq up
	inc ypos
	bra ml
up      bit #$08
	beq ml
	dec ypos
	inc.b vert 

ml      jmp mainLoop   
	
VB      sep #$20        ; A 8-bits
	ldx.v #$0000      ; copy out sprite data
	stx $2102

copySprite
	clc
	lda.b xpos          ; x position
	sta $2104
	lda.b ypos          ; y position
	sta $2104
	lda.b char          ; character
	sta $2104
	stz $2104
	
	rep #$30          ; A, X, Y 16-bits
	sep #$20          ; A 8-bits

	inc.b flag
	lda.b flag
	cmp.b #7
	bne ret
	stz flag
	lda.b char
	inc
	inc
	cmp #16
	bne skipit
	lda.b #0
skipit  sta.b char
ret     lda $4212
	bit #$01
	bne ret
	ldx.v $4218
	stx.v joyreg1
	rti
	rts

imageData
	bin snes.col

initialSpriteData
	bin sprite.dat
pad
fontData
	bin snes.til

