


;**********************************************
;**********************************************
;**********************************************

Square_32x32:
;		a faster square function
;	given a 32-bit number, (ABCDEFGH)^2 = AB^2 + CD^2 + EF^2 + GH^2
;				+ 2(ABCD + ABEF +ABGH +CDEF +CDGH +EFGH)

;	phx
;	phy


	bbr7	<multpart1+3,.no_flip_squ1	;Is the 1st value negative?
						;flip the result...
	lda	<multpart1
	eor	#$FF
	add	#$01
	sta	<multpart1
	lda	<multpart1+1
	eor	#$FF
	adc	#$00
	sta	<multpart1+1
	lda	<multpart1+2
	eor	#$FF
	adc	#$00
	sta	<multpart1+2
	lda	<multpart1+3
	eor	#$FF
	adc	#$00
	sta	<multpart1+3
.no_flip_squ1:

	lda	<multpart1+3		;Highest part
    	STA <zp1     ;set zp adresses
    	STA <zp2
    	EOR #$ff
    	STA <zp3
    	STA <zp4

	ldy	<multpart1+2
 	SEC
    	LDA [zp1],y
    	SBC [zp3],y	;product lo in a
    	sta	<multresult+5
    	LDA [zp2],y
        SBC [zp4],y ;product hi
	sta	<multresult+6

	ldy	<multpart1+1
 	SEC
    	LDA [zp1],y
    	SBC [zp3],y	;product lo in a
    	sta	<multresult+4
    	LDA [zp2],y
        SBC [zp4],y ;product hi
  	add	<multresult+5
	sta	<multresult+5
	cla
    	adc	<multresult+6
	sta	<multresult+6
	cla
	adc	#$00
	sta	<multresult+7

	ldy	<multpart1
 	SEC
    	LDA [zp1],y
    	SBC [zp3],y	;product lo in a
    	sta	<multresult+3
    	LDA [zp2],y
        SBC [zp4],y ;product hi
  	add	<multresult+4
	sta	<multresult+4
	cla
    	adc	<multresult+5
	sta	<multresult+5
	cla
    	adc	<multresult+6
	sta	<multresult+6
	cla
	adc	<multresult+7
	sta	<multresult+7
;---------------------
	lda	<multpart1+2		;2nd Highest part
    	STA <zp1     ;set zp adresses
    	STA <zp2
    	EOR #$ff
    	STA <zp3
    	STA <zp4

	ldy	<multpart1+1
 	SEC
    	LDA [zp1],y
    	SBC [zp3],y	;product lo in a
	tax		;low result to X
    	LDA [zp2],y
        SBC [zp4],y ;product hi
	sax			;swap!
	add	<multresult+3
	sta	<multresult+3
	txa
	adc	<multresult+4
    	sta	<multresult+4
	cla
	adc	<multresult+5
	sta	<multresult+5
	cla
	adc	<multresult+6
	sta	<multresult+6
	cla
	adc	<multresult+7
	sta	<multresult+7

	ldy	<multpart1
	SEC
    	LDA [zp1],y
    	SBC [zp3],y	;product lo in a
	sta	<multresult+2
    	LDA [zp2],y
        SBC [zp4],y ;product hi
	add	<multresult+3
	sta	<multresult+3
	cla
	adc	<multresult+4
    	sta	<multresult+4
	cla
	adc	<multresult+5
	sta	<multresult+5
	cla
	adc	<multresult+6
	sta	<multresult+6
	cla
	adc	<multresult+7
	sta	<multresult+7


;---------------------
	lda	<multpart1+1		;2nd lowest part
    	STA <zp1     ;set zp adresses
    	STA <zp2
    	EOR #$ff
    	STA <zp3
    	STA <zp4


	ldy	<multpart1
	SEC
    	LDA [zp1],y
    	SBC [zp3],y	;product lo in a
	sta	<multresult+1
    	LDA [zp2],y
        SBC [zp4],y ;product hi
	add	<multresult+2
	sta	<multresult+2
	cla
	adc	<multresult+3
    	sta	<multresult+3
	cla
	adc	<multresult+4
    	sta	<multresult+4
	cla
	adc	<multresult+5
	sta	<multresult+5
	cla
	adc	<multresult+6
	sta	<multresult+6
	cla
	adc	<multresult+7
	sta	<multresult+7
;-----------------------------------------------
	;	Now we shift everything up by 1 place!

	asl	<multresult+1
	rol	<multresult+2
	rol	<multresult+3
	rol	<multresult+4
	rol	<multresult+5
	rol	<multresult+6
	rol	<multresult+7

;---------------------
	lda	<multpart1		;lowest part
	tay			;squared
    	STA <zp1     ;set zp adresses
    	STA <zp2
    	EOR #$ff
    	STA <zp3
    	STA <zp4

	SEC
    	LDA [zp1],y
    	SBC [zp3],y	;product lo in a
	sta	<multresult
    	LDA [zp2],y
        SBC [zp4],y ;product hi

	add	<multresult+1
	sta	<multresult+1
	cla
	adc	<multresult+2
    	sta	<multresult+2
	cla
	adc	<multresult+3
    	sta	<multresult+3
	cla
	adc	<multresult+4
    	sta	<multresult+4
	cla
	adc	<multresult+5
	sta	<multresult+5
	cla
	adc	<multresult+6
	sta	<multresult+6
	cla
	adc	<multresult+7
	sta	<multresult+7

;-------

	lda	<multpart1+3		;highest part
	tay			;squared
    	STA <zp1     ;set zp adresses
    	STA <zp2
    	EOR #$ff
    	STA <zp3
    	STA <zp4

 	SEC
    	LDA [zp1],y
    	SBC [zp3],y	;product lo in a
    	tax
    	LDA [zp2],y
        SBC [zp4],y ;product hi
	sax
	add	<multresult+6
	sta	<multresult+6
	txa
	adc	<multresult+7
    	sta	<multresult+7


	lda	<multpart1+2
	tay			;squared
    	STA <zp1     ;set zp adresses
    	STA <zp2
    	EOR #$ff
    	STA <zp3
    	STA <zp4

 	SEC
    	LDA [zp1],y
    	SBC [zp3],y	;product lo in a
	tax		;low result to X
    	LDA [zp2],y
        SBC [zp4],y ;product hi
	sax			;swap!
	add	<multresult+4
	sta	<multresult+4
	txa
	adc	<multresult+5
    	sta	<multresult+5
	cla
	adc	<multresult+6
	sta	<multresult+6
	cla
	adc	<multresult+7
	sta	<multresult+7


	lda	<multpart1+1
	tay			;squared
    	STA <zp1     ;set zp adresses
    	STA <zp2
    	EOR #$ff
    	STA <zp3
    	STA <zp4

 	SEC
    	LDA [zp1],y
    	SBC [zp3],y	;product lo in a
	tax		;low result to X
    	LDA [zp2],y
        SBC [zp4],y ;product hi
	sax			;swap!
	add	<multresult+2
	sta	<multresult+2
	txa
	adc	<multresult+3
    	sta	<multresult+3
	cla
	adc	<multresult+4
	sta	<multresult+4
	cla
	adc	<multresult+5
	sta	<multresult+5
	cla
	adc	<multresult+6
	sta	<multresult+6
	cla
	adc	<multresult+7
	sta	<multresult+7

;	ply
;	plx
	rts


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;  Multiply; only used once in this fractal program.
; A y-shift is needed, so I'll do it here to avoid -ve problems!
Multiply_Unsigned:
	rmb0	<resultsign
	jmp	no_flip_mul2	;Skip flipping, etc.

Multiply_32x32:
;	phx
;	phy

	rmb0	<resultsign

	bbr7	<multpart1+3,no_flip_mul1	;Is the 1st value negative?
	smb0	<resultsign			;flip the result...
	lda	<multpart1
	eor	#$FF
	add	#$01
	sta	<multpart1
	lda	<multpart1+1
	eor	#$FF
	adc	#$00
	sta	<multpart1+1
	lda	<multpart1+2
	eor	#$FF
	adc	#$00
	sta	<multpart1+2
	lda	<multpart1+3
	eor	#$FF
	adc	#$00
	sta	<multpart1+3
no_flip_mul1:
	bbr7	<multpart2+3,no_flip_mul2	;Is the 2nd value negative?
	lda	<resultsign			;flip the result...
	eor	#$01
	sta	<resultsign
	lda	<multpart2
	eor	#$FF
	add	#$01
	sta	<multpart2
	lda	<multpart2+1
	eor	#$FF
	adc	#$00
	sta	<multpart2+1
	lda	<multpart2+2
	eor	#$FF
	adc	#$00
	sta	<multpart2+2
	lda	<multpart2+3
	eor	#$FF
	adc	#$00
	sta	<multpart2+3
no_flip_mul2:

	lda	<multpart1+3		;Highest part
    	STA <zp1     ;set zp adresses
    	STA <zp2
    	EOR #$ff
    	STA <zp3
    	STA <zp4

	ldy	<multpart2+3
 	SEC
    	LDA [zp1],y
    	SBC [zp3],y	;product lo in a
    	sta	<multresult+6
    	LDA [zp2],y
        SBC [zp4],y ;product hi
    	sta	<multresult+7

	ldy	<multpart2+2
 	SEC
    	LDA [zp1],y
    	SBC [zp3],y	;product lo in a
    	sta	<multresult+5
    	LDA [zp2],y
        SBC [zp4],y ;product hi
    	add	<multresult+6
	sta	<multresult+6
	cla
	adc	<multresult+7
	sta	<multresult+7

	ldy	<multpart2+1
 	SEC
    	LDA [zp1],y
    	SBC [zp3],y	;product lo in a
    	sta	<multresult+4
    	LDA [zp2],y
        SBC [zp4],y ;product hi
  	add	<multresult+5
	sta	<multresult+5
	cla
    	adc	<multresult+6
	sta	<multresult+6
	cla
	adc	<multresult+7
	sta	<multresult+7

	ldy	<multpart2
 	SEC
    	LDA [zp1],y
    	SBC [zp3],y	;product lo in a
    	sta	<multresult+3
    	LDA [zp2],y
        SBC [zp4],y ;product hi
  	add	<multresult+4
	sta	<multresult+4
	cla
    	adc	<multresult+5
	sta	<multresult+5
	cla
    	adc	<multresult+6
	sta	<multresult+6
	cla
	adc	<multresult+7
	sta	<multresult+7
;---------------------
	lda	<multpart1+2		;2nd Highest part
    	STA <zp1     ;set zp adresses
    	STA <zp2
    	EOR #$ff
    	STA <zp3
    	STA <zp4

	ldy	<multpart2+3
 	SEC
    	LDA [zp1],y
    	SBC [zp3],y	;product lo in a
	tax		;low result to X
    	LDA [zp2],y
        SBC [zp4],y ;product hi
	sax			;swap!
	add	<multresult+5
	sta	<multresult+5
	txa
	adc	<multresult+6
    	sta	<multresult+6
	cla
	adc	<multresult+7
	sta	<multresult+7

	ldy	<multpart2+2
 	SEC
    	LDA [zp1],y
    	SBC [zp3],y	;product lo in a
	tax		;low result to X
    	LDA [zp2],y
        SBC [zp4],y ;product hi
	sax			;swap!
	add	<multresult+4
	sta	<multresult+4
	txa
	adc	<multresult+5
    	sta	<multresult+5
	cla
	adc	<multresult+6
	sta	<multresult+6
	cla
	adc	<multresult+7
	sta	<multresult+7

	ldy	<multpart2+1
 	SEC
    	LDA [zp1],y
    	SBC [zp3],y	;product lo in a
	tax		;low result to X
    	LDA [zp2],y
        SBC [zp4],y ;product hi
	sax			;swap!
	add	<multresult+3
	sta	<multresult+3
	txa
	adc	<multresult+4
    	sta	<multresult+4
	cla
	adc	<multresult+5
	sta	<multresult+5
	cla
	adc	<multresult+6
	sta	<multresult+6
	cla
	adc	<multresult+7
	sta	<multresult+7

	ldy	<multpart2
	SEC
    	LDA [zp1],y
    	SBC [zp3],y	;product lo in a
	sta	<multresult+2
    	LDA [zp2],y
        SBC [zp4],y ;product hi
	add	<multresult+3
	sta	<multresult+3
	cla
	adc	<multresult+4
    	sta	<multresult+4
	cla
	adc	<multresult+5
	sta	<multresult+5
	cla
	adc	<multresult+6
	sta	<multresult+6
	cla
	adc	<multresult+7
	sta	<multresult+7


;---------------------
	lda	<multpart1+1		;2nd lowest part
    	STA <zp1     ;set zp adresses
    	STA <zp2
    	EOR #$ff
    	STA <zp3
    	STA <zp4

	ldy	<multpart2+3
 	SEC
    	LDA [zp1],y
    	SBC [zp3],y	;product lo in a
	tax		;low result to X
    	LDA [zp2],y
        SBC [zp4],y ;product hi
	sax			;swap!
	add	<multresult+4
	sta	<multresult+4
	txa
	adc	<multresult+5
    	sta	<multresult+5
	cla
	adc	<multresult+6
	sta	<multresult+6
	cla
	adc	<multresult+7
	sta	<multresult+7

	ldy	<multpart2+2
 	SEC
    	LDA [zp1],y
    	SBC [zp3],y	;product lo in a
	tax		;low result to X
    	LDA [zp2],y
        SBC [zp4],y ;product hi
	sax			;swap!
	add	<multresult+3
	sta	<multresult+3
	txa
	adc	<multresult+4
    	sta	<multresult+4
	cla
	adc	<multresult+5
	sta	<multresult+5
	cla
	adc	<multresult+6
	sta	<multresult+6
	cla
	adc	<multresult+7
	sta	<multresult+7

	ldy	<multpart2+1
 	SEC
    	LDA [zp1],y
    	SBC [zp3],y	;product lo in a
	tax		;low result to X
    	LDA [zp2],y
        SBC [zp4],y ;product hi
	sax			;swap!
	add	<multresult+2
	sta	<multresult+2
	txa
	adc	<multresult+3
    	sta	<multresult+3
	cla
	adc	<multresult+4
	sta	<multresult+4
	cla
	adc	<multresult+5
	sta	<multresult+5
	cla
	adc	<multresult+6
	sta	<multresult+6
	cla
	adc	<multresult+7
	sta	<multresult+7

	ldy	<multpart2
	SEC
    	LDA [zp1],y
    	SBC [zp3],y	;product lo in a
	sta	<multresult+1
    	LDA [zp2],y
        SBC [zp4],y ;product hi
	add	<multresult+2
	sta	<multresult+2
	cla
	adc	<multresult+3
    	sta	<multresult+3
	cla
	adc	<multresult+4
    	sta	<multresult+4
	cla
	adc	<multresult+5
	sta	<multresult+5
	cla
	adc	<multresult+6
	sta	<multresult+6
	cla
	adc	<multresult+7
	sta	<multresult+7

;---------------------
	lda	<multpart1		;lowest part
    	STA <zp1     ;set zp adresses
    	STA <zp2
    	EOR #$ff
    	STA <zp3
    	STA <zp4

	ldy	<multpart2+3
 	SEC
    	LDA [zp1],y
    	SBC [zp3],y	;product lo in a
	tax		;low result to X
    	LDA [zp2],y
        SBC [zp4],y ;product hi
	sax			;swap!
	add	<multresult+3
	sta	<multresult+3
	txa
	adc	<multresult+4
    	sta	<multresult+4
	cla
	adc	<multresult+5
	sta	<multresult+5
	cla
	adc	<multresult+6
	sta	<multresult+6
	cla
	adc	<multresult+7
	sta	<multresult+7

	ldy	<multpart2+2
 	SEC
    	LDA [zp1],y
    	SBC [zp3],y	;product lo in a
	tax		;low result to X
    	LDA [zp2],y
        SBC [zp4],y ;product hi
	sax			;swap!
	add	<multresult+2
	sta	<multresult+2
	txa
	adc	<multresult+3
    	sta	<multresult+3
	cla
	adc	<multresult+4
	sta	<multresult+4
	cla
	adc	<multresult+5
	sta	<multresult+5
	cla
	adc	<multresult+6
	sta	<multresult+6
	cla
	adc	<multresult+7
	sta	<multresult+7

	ldy	<multpart2+1
 	SEC
    	LDA [zp1],y
    	SBC [zp3],y	;product lo in a
	tax		;low result to X
    	LDA [zp2],y
        SBC [zp4],y ;product hi
	sax			;swap!
	add	<multresult+1
	sta	<multresult+1
	txa
	adc	<multresult+2
    	sta	<multresult+2
	cla
	adc	<multresult+3
	sta	<multresult+3
	cla
	adc	<multresult+4
	sta	<multresult+4
	cla
	adc	<multresult+5
	sta	<multresult+5
	cla
	adc	<multresult+6
	sta	<multresult+6
	cla
	adc	<multresult+7
	sta	<multresult+7

	ldy	<multpart2
	SEC
    	LDA [zp1],y
    	SBC [zp3],y	;product lo in a
	sta	<multresult
    	LDA [zp2],y
        SBC [zp4],y ;product hi
	add	<multresult+1
	sta	<multresult+1
	cla
	adc	<multresult+2
    	sta	<multresult+2
	cla
	adc	<multresult+3
    	sta	<multresult+3
	cla
	adc	<multresult+4
    	sta	<multresult+4
	cla
	adc	<multresult+5
	sta	<multresult+5
	cla
	adc	<multresult+6
	sta	<multresult+6
	cla
	adc	<multresult+7
	sta	<multresult+7

		;The shift below is only needed for the Mand routine!
	bbs0	<restart_flag,.noshift_mid_fractal

	asl	<multresult	;Shift once!
	rol	<multresult+1
	rol	<multresult+2
	rol	<multresult+3
	rol	<multresult+4
	rol	<multresult+5
	rol	<multresult+6
	rol	<multresult+7	;In the MAND algorithm!
.noshift_mid_fractal:

	bbr0	<resultsign,.no_flip_mulres	;Now we might flip the result!

	lda	<multresult
	eor	#$FF
	add	#$01
	sta	<multresult
	lda	<multresult+1
	eor	#$FF
	adc	#$00
    	sta	<multresult+1
	lda	<multresult+2
	eor	#$FF
	adc	#$00
    	sta	<multresult+2
	lda	<multresult+3
	eor	#$FF
	adc	#$00
    	sta	<multresult+3
	lda	<multresult+4
	eor	#$FF
	adc	#$00
    	sta	<multresult+4
	lda	<multresult+5
	eor	#$FF
	adc	#$00
	sta	<multresult+5
	lda	<multresult+6
	eor	#$FF
	adc	#$00
	sta	<multresult+6
	lda	<multresult+7
	eor	#$FF
	adc	#$00
	sta	<multresult+7


.no_flip_mulres:
;	ply
;	plx
	rts

;Fast Multiplication

Multiply:
    
;    	LDY #$66    ;factor 1 in y
;  	LDA #$12    ;factor 2 in a

    	STA <zp1     ;set zp adresses
    	STA <zp2
    	EOR #$ff
    	STA <zp3
    	STA <zp4

    	SEC
    	LDA [zp1],y
    	SBC [zp3],y
    	TAX         ;product lo in x
    	LDA [zp2],y
        SBC [zp4],y ;product hi in a

        RTS

mult_init    LDX #0      ;build square tables
    	STX tab3+$fe
    	STX tab4+$fe
    	LDY #$ff

.loop1  TXA
    	LSR	a
    	CLC
    	ADC tab3+$fe,x
    	STA tab1,x
    	STA tab3+$ff,x
    	STA tab3,y
    	LDA #0
    	ADC tab4+$fe,x
    	STA tab2,x
    	STA tab4+$ff,x
    	STA tab4,y
    	DEY
    	INX
    	BNE .loop1

.loop2  TXA
    	SEC
    	ROR	a
    	CLC
    	ADC tab1+$ff,x
    	STA tab1+$100,x
    	LDA #0
    	ADC tab2+$ff,x
    	STA tab2+$100,x
    	INX
    	BNE .loop2

    	LDA #HIGH(tab1)  ;init zp addresses
    	STA <zp1+1
    	LDA #HIGH(tab2)
    	STA <zp2+1
    	LDA #HIGH(tab3)
    	STA <zp3+1
    	LDA #HIGH(tab4)
    	STA <zp4+1

    	RTS