;64 bit divide routine with 32 bit quotent
;	 INPUT: DVDQUO contains the 64-bit Dividend to be divided
;	 INPUT: DVDR0-7 contains the 32? 64? Divisor
;	OUTPUT:	DVDQUO contains the 64-bit Quotient after division.


DIVIDE:    
	phx
	phy	

	stz	<DVDR+8		;Clear the "remainder" registers
	stz	<DVDR+9
	stz	<DVDR+$a
	stz	<DVDR+$b
	stz	<DVDR+$c
	stz	<DVDR+$d
	stz	<DVDR+$e
	stz	<DVDR+$f

	ldy     #$40       ;Set bit length
DO_NXT_BIT: asl    <DVDQUO
           rol     <DVDQUO+1
           rol     <DVDQUO+2
           rol     <DVDQUO+3
           rol     <DVDQUO+4
           rol     <DVDQUO+5
           rol     <DVDQUO+6
           rol     <DVDQUO+7
           rol     <DVDR+8
           rol     <DVDR+9
           rol     <DVDR+$a
           rol     <DVDR+$b
           rol     <DVDR+$c
           rol     <DVDR+$d
           rol     <DVDR+$e
           rol     <DVDR+$f
           clx
           lda     #$08
           sta     <ADDDP
           sec
SUBT:      lda     <DVDR+8,x   ;Subtract divider from
           sbc     <DVDR,x     ; partial dividend and
           sta     <MULR,x     ; save
           inx
           dec     <ADDDP
           bne     SUBT
           bcc     NXT        ;Branch to do next bit
           inc     <DVDQUO     ; if result = or -
           ldx     #$08       ;Put subtractor result
RSULT:     lda     <MULR-1,x   ; into partial dividend
           sta     <DVDR+7,x
           dex
           bne     RSULT
NXT:       dey
           bne     DO_NXT_BIT

		ply
		plx
           rts