/* main.h */



#define MEMORY_MAP_SIZE  0x01000000
#define MEMORY_MAP_START 0x00200000


/* type of breakpoint, stored in bp_type */
#define BPNONE  0
#define BPOPCNT 1
#define BPHEX   2


/* Typedefs */
typedef unsigned char   uchar;
#ifdef __DJGPP__
typedef unsigned int   uint;
typedef unsigned short ushort;
typedef unsigned long  ulong;
#endif


void  dis900h(char *msg);
void  emu900h();

void  load_gui();
void  load_file();
void  ToBin8(char numb);
void  load_regs();
void  write_memory(long where, char what);
char  read_memory (int where);
long  smartpxl (char val);
long  str2hex(char *buf);


/* rom information */
char   *rom_name;                //filename
int    rom_length;               //length of rom-file
char   *rom_image;               //array wich contains the rom-image
uchar  *rom;                     //array wich contains the ROM



/* breakpoint variables */
char dbuf[40];
char bp_type;
long bp_opcnt;
long bp_hex;


char  *bgn[10] = { "bg.bmp" };

#define DISCOL_PC   0xFF80   //disasm PC color
#define DISCOL_DATA 0xFF80   //data bytes color
#define INACTIVE    0xBBBB   //inactive window color




/*

windows order:

1 Debug (at bottom)
2 Register
3 Information
4 tile browser
5 memory browser

*/

struct {
    short x;
    short y;
    short w; //width
    short h; //height
    short col;
    char  active;
    char  visible;
    char  locked;  //0=moveable
} dbgWnd,regWnd,gfxWnd,memWnd;





#define REFRESH_SCREEN \
    show_mouse(NULL); \
    draw_sprite(buffer,bg,0,0); \
    if (dbgWnd.visible) draw_sprite(buffer,dbgWndB,dbgWnd.x,dbgWnd.y); \
    if (regWnd.visible) draw_sprite(buffer,regWndB,regWnd.x,regWnd.y); \
    if (gfxWnd.visible) draw_sprite(buffer,gfxWndB,gfxWnd.x,gfxWnd.y); \
    if (memWnd.visible) draw_sprite(buffer,memWndB,memWnd.x,memWnd.y); \
    draw_sprite(screen,buffer,0,0); \
    show_mouse(screen); \


#define REFRESH_WND \
    if (dbgWnd.active==1) rectfill(dbgWndB,1,1,dbgWnd.w-2,10,0xFFFF); \
    else rectfill(dbgWndB,1,1,dbgWnd.w-2,10,INACTIVE); \
    sprintf(msg,"Disassembly of '%s'",rom_name); \
    textout(dbgWndB,font,msg,2,2,0); \
    if (regWnd.active==1) rectfill(regWndB,1,1,regWnd.w-2,10,0xFFFF); \
    else rectfill(regWndB,1,1,regWnd.w-2,10,INACTIVE); \
    textout(regWndB,font,"Registers",2,2,0); \
    if (gfxWnd.active==1) rectfill(gfxWndB,1,1,gfxWnd.w-2,10,0xFFFF); \
    else rectfill(gfxWndB,1,1,gfxWnd.w-2,10,INACTIVE); \
    textout(gfxWndB,font,"Tile browser",2,2,0); \
    if (memWnd.active==1) rectfill(memWndB,1,1,memWnd.w-2,10,0xFFFF); \
    else rectfill(memWndB,1,1,memWnd.w-2,10,INACTIVE); \
    textout(memWndB,font,"Memory browser",2,2,0); \


#define REFRESH_DISASM \
    rectfill(dbgWndB,1,12,dbgWnd.w-2,dbgWnd.h-2,40); \
    d=14;                                            \
    for (c=0;c<35;c++) {                             \
        sprintf(msg,"%06lX:",dPC);                   \
        if (dPC==PC) textout(dbgWndB,font,msg,13,d,0xAAAA); \
        else textout(dbgWndB,font,msg,13,d,DISCOL_PC); \
        dPCold=dPC; \
        Tmp32=(rom[dPC+3]<<24)+(rom[dPC+2]<<16)+(rom[dPC+1]<<8)+rom[dPC]; \
        Tmp16=(rom[dPC+1]<<8)+rom[dPC]; \
        switch (dPC) { \
            case 0x200000: sprintf(msg,"DB     \"%.28s\"",&rom[0x200000]); sprintf(dmsg,";Copyright"); dPCl=28; dPCh=0; break; \
            case 0x20001C: sprintf(msg,"DB     %08lXh",Tmp32); sprintf(dmsg,";Program Counter"); dPCl=4; dPCh=0; break; \
            case 0x200020: sprintf(msg,"DB     %04Xh",Tmp16); sprintf(dmsg,";Catalog (NEOP%04X%X)",Tmp16,rom[0x200023]>>4 ); dPCl=2; dPCh=0; break; \
            case 0x200022: sprintf(msg,"DB     %02Xh",rom[dPC]);           sprintf(dmsg,";Size?"); dPCl=1; dPCh=0; break; \
            case 0x200023: sprintf(msg,"DB     %02Xh",rom[dPC]);           sprintf(dmsg,";Mode (10h=ngpc)"); dPCl=1; dPCh=0; break; \
            case 0x200024: sprintf(msg,"DB     \"%.12s\"",&rom[0x200024]); sprintf(dmsg,";Game name"); dPCl=12; dPCh=0; break; \
            case 0x200030: sprintf(msg,"DB     %02Xh,%02Xh,%02Xh,%02Xh",rom[dPC],rom[dPC+1],rom[dPC+2],rom[dPC+3]); sprintf(dmsg,";"); dPCl=4; dPCh=0; break; \
            case 0x200034: sprintf(msg,"DB     %02Xh,%02Xh,%02Xh,%02Xh",rom[dPC],rom[dPC+1],rom[dPC+2],rom[dPC+3]); sprintf(dmsg,";"); dPCl=4; dPCh=0; break; \
            case 0x200038: sprintf(msg,"DB     %02Xh,%02Xh,%02Xh,%02Xh",rom[dPC],rom[dPC+1],rom[dPC+2],rom[dPC+3]); sprintf(dmsg,";"); dPCl=4; dPCh=0; break; \
            case 0x20003C: sprintf(msg,"DB     %02Xh,%02Xh,%02Xh,%02Xh",rom[dPC],rom[dPC+1],rom[dPC+2],rom[dPC+3]); sprintf(dmsg,";"); dPCl=4; dPCh=0; break; \
            default: dis900h(msg); \
        } \
        textout(dbgWndB,font,msg,80,d,-1); \
        if (dPCh) { \
            if (dPC>dPCold) { \
                dPCl=dPCl+(dPC-dPCold); \
                dPC=dPCold; \
            } \
            switch (dPCl) { \
                case 1: sprintf(dmsg,";%02X                     ",rom[dPC]); break; \
                case 2: sprintf(dmsg,";%02X %02X                  ",rom[dPC],rom[dPC+1]); break; \
                case 3: sprintf(dmsg,";%02X %02X %02X               ",rom[dPC],rom[dPC+1],rom[dPC+2]); break; \
                case 4: sprintf(dmsg,";%02X %02X %02X %02X            ",rom[dPC],rom[dPC+1],rom[dPC+2],rom[dPC+3]); break; \
                case 5: sprintf(dmsg,";%02X %02X %02X %02X %02X         ",rom[dPC],rom[dPC+1],rom[dPC+2],rom[dPC+3],rom[dPC+4]); break; \
                case 6: sprintf(dmsg,";%02X %02X %02X %02X %02X %02X      ",rom[dPC],rom[dPC+1],rom[dPC+2],rom[dPC+3],rom[dPC+4],rom[dPC+5]); break; \
                case 7: sprintf(dmsg,";%02X %02X %02X %02X %02X %02X %02X   ",rom[dPC],rom[dPC+1],rom[dPC+2],rom[dPC+3],rom[dPC+4],rom[dPC+5],rom[dPC+6]); break; \
                case 8: sprintf(dmsg,";%02X %02X %02X %02X %02X %02X %02X %02X",rom[dPC],rom[dPC+1],rom[dPC+2],rom[dPC+3],rom[dPC+4],rom[dPC+5],rom[dPC+6],rom[dPC+7]); break; \
                default: sprintf(dmsg,";%02X %02X %02X %02X %02X %02X %02X",rom[dPC],rom[dPC+1],rom[dPC+2],rom[dPC+3],rom[dPC+4],rom[dPC+5],rom[dPC+6]); \
            } \
        } \
        if (dPCl==0) dPCl=1; \
        dbgscrl[c]=dPCl; \
        dPC+=dPCl; \
        textout(dbgWndB,font,dmsg,390,d,DISCOL_DATA); \
        d+=10; \
    } \


#define REFRESH_TILES \
    rectfill(gfxWndB,1,12,gfxWnd.w-2,gfxWnd.h-2,40); \
    tmpP=gfxP;                                       \
    tileTx=1; tileTy=12;                             \
    for (tiley=0; tiley<((8*8)*2);tiley+=16) {       \
        for (tilex=0; tilex<((8*8)*2);tilex+=16) {   \
            ty=tiley;                                \
            tileTxb=tileTx;                          \
            for (tilei=0; tilei<16; tilei+=2) {      \
                b_lo=rom[tmpP+tilei];                \
                b_hi=rom[tmpP+tilei+1];              \
                rectfill(gfxWndB,tileTxb+tilex+14,tileTy+ty,tileTxb+tilex+15,tileTy+ty+1,smartpxl( b_lo&0x03)    ); \
                rectfill(gfxWndB,tileTxb+tilex+12,tileTy+ty,tileTxb+tilex+13,tileTy+ty+1,smartpxl((b_lo&0x0C)>>2)); \
                rectfill(gfxWndB,tileTxb+tilex+10,tileTy+ty,tileTxb+tilex+11,tileTy+ty+1,smartpxl((b_lo&0x30)>>4)); \
                rectfill(gfxWndB,tileTxb+tilex+ 8,tileTy+ty,tileTxb+tilex+ 9,tileTy+ty+1,smartpxl((b_lo&0xC0)>>6)); \
                rectfill(gfxWndB,tileTxb+tilex+ 6,tileTy+ty,tileTxb+tilex+ 7,tileTy+ty+1,smartpxl( b_hi&0x03)    ); \
                rectfill(gfxWndB,tileTxb+tilex+ 4,tileTy+ty,tileTxb+tilex+ 5,tileTy+ty+1,smartpxl((b_hi&0x0C)>>2)); \
                rectfill(gfxWndB,tileTxb+tilex+ 2,tileTy+ty,tileTxb+tilex+ 3,tileTy+ty+1,smartpxl((b_hi&0x30)>>4)); \
                rectfill(gfxWndB,tileTxb+tilex   ,tileTy+ty,tileTxb+tilex+ 1,tileTy+ty+1,smartpxl((b_hi&0xC0)>>6)); \
                ty+=2; \
            }          \
        tmpP+=16;      \
        }              \
    }                  \
    sprintf(msg,"offset: %06lX",gfxP);  \
    textout(gfxWndB,font,msg,3,141,-1); \


#define REFRESH_MEM \
    rectfill(memWndB,1,12,memWnd.w-2,memWnd.h-2,40); \
    d=14; mPCc=mPC; \
    for (c=0;c<20;c++) { \
        sprintf(msg,"%06lX:",mPCc); \
        textout(memWndB,font,msg,3,d,DISCOL_PC); \
        sprintf(msg,"%02X%02X%02X%02X %02X%02X%02X%02X %02X%02X%02X%02X %02X%02X%02X%02X",rom[mPCc],rom[mPCc+1],rom[mPCc+2],rom[mPCc+3],rom[mPCc+4],rom[mPCc+5],rom[mPCc+6],rom[mPCc+7],rom[mPCc+8],rom[mPCc+9],rom[mPCc+10],rom[mPCc+11],rom[mPCc+12],rom[mPCc+13],rom[mPCc+14],rom[mPCc+15]); \
        textout(memWndB,font,msg,70,d,-1); \
        mPCc+=0x10; \
        d+=10; \
    } \

#define REFRESH_REGS \
    rectfill(regWndB,1,12,regWnd.w-2,regWnd.h-2,40); \
    sprintf(msg, "0 XWA=%08lX XBC=%08lX XDE=%08lX XHL=%08lX  PC =%06lX  F  =%02X",Reg_XWA[0].DWord,Reg_XBC[0].DWord,Reg_XDE[0].DWord,Reg_XHL[0].DWord,PC,flagreg); \
    textout(regWndB,font,msg,3,14,-1); \
    sprintf(msg, "1 XWA=%08lX XBC=%08lX XDE=%08lX XHL=%08lX  SR =%04X    F' =%02X",Reg_XWA[1].DWord,Reg_XBC[1].DWord,Reg_XDE[1].DWord,Reg_XHL[1].DWord,SR,fSHADOW); \
    textout(regWndB,font,msg,3,24,-1); \
    sprintf(msg, "2 XWA=%08lX XBC=%08lX XDE=%08lX XHL=%08lX  RFP=%d       IFF=%d",Reg_XWA[2].DWord,Reg_XBC[2].DWord,Reg_XDE[2].DWord,Reg_XHL[2].DWord,rb,iff); \
    textout(regWndB,font,msg,3,34,-1); \
    sprintf(msg, "3 XWA=%08lX XBC=%08lX XDE=%08lX XHL=%08lX",Reg_XWA[3].DWord,Reg_XBC[3].DWord,Reg_XDE[3].DWord,Reg_XHL[3].DWord); \
    textout(regWndB,font,msg,3,44,-1); \
    textout(regWndB,font,"                                                       SZ-H-VNC    opcnt",3,54,-1); \
    sprintf(msg, "  XIX=%08lX XIY=%08lX XIZ=%08lX XSP=%08lX  %d%d-%d-%d%d%d    %ld",XIX,XIY,XIZ,XSP,fS,fZ,fH,fV,fN,fC,opcnt); \
    textout(regWndB,font,msg,3,64,-1); \






/* for the tile viewer */
uint   tilex,tiley,ty,tilei;
uchar  b_lo,b_hi;
ulong  gfxP,tmpP;
short  tileTx=0,tileTy=0,tileTxb=0;


/* for memory viewer */
ulong mPC,mPCc;


char dbgscrl[80];
ulong opcnt;
