/* functs.c
 */

void load_file()
 {

    FILE    *in;

    in = fopen(rom_name, "rb");
    if (in == NULL)
 {
	printf("Couldn't find %s.\n",rom_name); exit(1);
    }


    rewind(in);                //stdio.h - rewind resets filepointer
    fseek(in, 0, SEEK_END);    //sets pointer to EOF
    rom_length = ftell(in);    //returns file pointer position


    /* Allocates memory map
 */
    rom = (char *) calloc(MEMORY_MAP_SIZE,sizeof(char));
    if(rom==NULL)
 {
        fclose(in);
        printf("Couldn't allocate memory for memory map (need 0x%08X bytes).\n",MEMORY_MAP_SIZE); exit(2);
    }

    /* Copies data to memory map, start at 0x200000
 */
    fseek(in, 0, SEEK_SET);    //sets pointer to start of file
    if (!fread(rom+MEMORY_MAP_START, 1, rom_length, in)) {
        fclose(in);
        free(rom_image);
        printf("Failed to read from %s.\n",rom_name); exit(4);
    }

    fclose(in);
   
} /* void load_file() */


void ToBin8(char numb)
 {
    char cnt,a;
    int tmp;

    cnt = 128;

    for(a=0; a<8;a++)
 {
        tmp = numb - cnt;
        if (tmp >= 0)
 {
            printf("1");
            numb = tmp;
        }
 else
    	    printf("0");

        cnt = cnt / 2;
    }
} /* ToBin8(char numb) */


long str2hex(char *buf) {
    char  xxx;
    short  i=0;
    long  tmp,j,val=0;

    strupr(buf);

    j=1;
    for (i=strlen(buf)-1; i>-1; i--) {
        switch (buf[i]) {
            case 48: xxx=0; break;
            case 49: xxx=1; break;
            case 50: xxx=2; break;
            case 51: xxx=3; break;
            case 52: xxx=4; break;
            case 53: xxx=5; break;
            case 54: xxx=6; break;
            case 55: xxx=7; break;
            case 56: xxx=8; break;
            case 57: xxx=9; break;
            case 65: xxx=10; break;
            case 66: xxx=11; break;
            case 67: xxx=12; break;
            case 68: xxx=13; break;
            case 69: xxx=14; break;
            case 70: xxx=15; break;
            default: return 1; //error
        }
        tmp=xxx*j; val+=tmp; j=j*0x10;
    }
    return val;
}

char fc(char tmp) {
    /* fix character to display */
    /* parses away control chars */
    if (tmp<0x20) return 0x2E; //=.
    else return tmp;
}


void load_regs() {
    /* Initializes extended register map */
    /* current & prev reg bank must be updated when executed */

    xr32[0x00]=&Reg_XWA[0].DWord; xr32[0x01]=&Reg_XBC[0].DWord;
    xr32[0x02]=&Reg_XDE[0].DWord; xr32[0x03]=&Reg_XHL[0].DWord;
    xr32[0x04]=&Reg_XWA[1].DWord; xr32[0x05]=&Reg_XBC[1].DWord;
    xr32[0x06]=&Reg_XDE[1].DWord; xr32[0x07]=&Reg_XHL[1].DWord;
    xr32[0x08]=&Reg_XWA[2].DWord; xr32[0x09]=&Reg_XBC[2].DWord;
    xr32[0x0A]=&Reg_XDE[2].DWord; xr32[0x0B]=&Reg_XHL[2].DWord;
    xr32[0x0C]=&Reg_XWA[3].DWord; xr32[0x0D]=&Reg_XBC[3].DWord;
    xr32[0x0E]=&Reg_XDE[3].DWord; xr32[0x0F]=&Reg_XHL[3].DWord;
    xr32[0x3C]=&Reg_XIX.DWord; xr32[0x3D]=&Reg_XIY.DWord;
    xr32[0x3E]=&Reg_XIZ.DWord; xr32[0x3F]=&Reg_XSP.DWord;


    xr16[0x00]=&Reg_XWA[0].w[0]; xr16[0x01]=&Reg_XWA[0].w[1];
    xr16[0x02]=&Reg_XBC[0].w[0]; xr16[0x03]=&Reg_XBC[0].w[1];
    xr16[0x04]=&Reg_XDE[0].w[0]; xr16[0x05]=&Reg_XDE[0].w[1];
    xr16[0x06]=&Reg_XHL[0].w[0]; xr16[0x07]=&Reg_XHL[0].w[1];
    xr16[0x08]=&Reg_XWA[1].w[0]; xr16[0x09]=&Reg_XWA[1].w[1];
    xr16[0x0A]=&Reg_XBC[1].w[0]; xr16[0x0B]=&Reg_XBC[1].w[1];
    xr16[0x0C]=&Reg_XDE[1].w[0]; xr16[0x0D]=&Reg_XDE[1].w[1];
    xr16[0x0E]=&Reg_XHL[1].w[0]; xr16[0x0F]=&Reg_XHL[1].w[1];
    xr16[0x10]=&Reg_XWA[2].w[0]; xr16[0x11]=&Reg_XWA[2].w[1];
    xr16[0x12]=&Reg_XBC[2].w[0]; xr16[0x13]=&Reg_XBC[2].w[1];
    xr16[0x14]=&Reg_XDE[2].w[0]; xr16[0x15]=&Reg_XDE[2].w[1];
    xr16[0x16]=&Reg_XHL[2].w[0]; xr16[0x17]=&Reg_XHL[2].w[1];
    xr16[0x18]=&Reg_XWA[3].w[0]; xr16[0x19]=&Reg_XWA[3].w[1];
    xr16[0x1A]=&Reg_XBC[3].w[0]; xr16[0x1B]=&Reg_XBC[3].w[1];
    xr16[0x1C]=&Reg_XDE[3].w[0]; xr16[0x1D]=&Reg_XDE[3].w[1];
    xr16[0x1E]=&Reg_XHL[3].w[0]; xr16[0x1F]=&Reg_XHL[3].w[1];
    xr16[0x78]=&Reg_XIX.w[0]; xr16[0x79]=&Reg_XIX.w[1];
    xr16[0x7A]=&Reg_XIY.w[0]; xr16[0x7B]=&Reg_XIY.w[1];
    xr16[0x7C]=&Reg_XIZ.w[0]; xr16[0x7D]=&Reg_XIZ.w[1];
    xr16[0x7F]=&Reg_XSP.w[0]; xr16[0x7F]=&Reg_XSP.w[1];

    xr8[0x00]=&Reg_XWA[0].b[0]; xr8[0x01]=&Reg_XWA[0].b[1]; xr8[0x02]=&Reg_XWA[0].b[2]; xr8[0x03]=&Reg_XWA[0].b[3];
    xr8[0x04]=&Reg_XBC[0].b[0]; xr8[0x05]=&Reg_XBC[0].b[1]; xr8[0x06]=&Reg_XBC[0].b[2]; xr8[0x07]=&Reg_XBC[0].b[3];
    xr8[0x08]=&Reg_XDE[0].b[0]; xr8[0x09]=&Reg_XDE[0].b[1]; xr8[0x0A]=&Reg_XDE[0].b[2]; xr8[0x0B]=&Reg_XDE[0].b[3];
    xr8[0x0C]=&Reg_XHL[0].b[0]; xr8[0x0D]=&Reg_XHL[0].b[1]; xr8[0x0E]=&Reg_XHL[0].b[2]; xr8[0x0F]=&Reg_XHL[0].b[3];
    xr8[0x10]=&Reg_XWA[1].b[0]; xr8[0x11]=&Reg_XWA[1].b[1]; xr8[0x12]=&Reg_XWA[1].b[2]; xr8[0x13]=&Reg_XWA[1].b[3];
    xr8[0x14]=&Reg_XBC[1].b[0]; xr8[0x15]=&Reg_XBC[1].b[1]; xr8[0x16]=&Reg_XBC[1].b[2]; xr8[0x17]=&Reg_XBC[1].b[3];
    xr8[0x18]=&Reg_XDE[1].b[0]; xr8[0x19]=&Reg_XDE[1].b[1]; xr8[0x1A]=&Reg_XDE[1].b[2]; xr8[0x1B]=&Reg_XDE[1].b[3];
    xr8[0x1C]=&Reg_XHL[1].b[0]; xr8[0x1D]=&Reg_XHL[1].b[1]; xr8[0x1E]=&Reg_XHL[1].b[2]; xr8[0x1F]=&Reg_XHL[1].b[3];
    xr8[0x20]=&Reg_XWA[2].b[0]; xr8[0x21]=&Reg_XWA[2].b[1]; xr8[0x22]=&Reg_XWA[2].b[2]; xr8[0x23]=&Reg_XWA[2].b[3];
    xr8[0x24]=&Reg_XBC[2].b[0]; xr8[0x25]=&Reg_XBC[2].b[1]; xr8[0x26]=&Reg_XBC[2].b[2]; xr8[0x27]=&Reg_XBC[2].b[3];
    xr8[0x28]=&Reg_XDE[2].b[0]; xr8[0x29]=&Reg_XDE[2].b[1]; xr8[0x2A]=&Reg_XDE[2].b[2]; xr8[0x2B]=&Reg_XDE[2].b[3];
    xr8[0x2C]=&Reg_XHL[2].b[0]; xr8[0x2D]=&Reg_XHL[2].b[1]; xr8[0x2E]=&Reg_XHL[2].b[2]; xr8[0x2F]=&Reg_XHL[2].b[3];
    xr8[0x30]=&Reg_XWA[3].b[0]; xr8[0x31]=&Reg_XWA[3].b[1]; xr8[0x32]=&Reg_XWA[3].b[2]; xr8[0x33]=&Reg_XWA[3].b[3];
    xr8[0x34]=&Reg_XBC[3].b[0]; xr8[0x35]=&Reg_XBC[3].b[1]; xr8[0x36]=&Reg_XBC[3].b[2]; xr8[0x37]=&Reg_XBC[3].b[3];
    xr8[0x38]=&Reg_XDE[3].b[0]; xr8[0x39]=&Reg_XDE[3].b[1]; xr8[0x3A]=&Reg_XDE[3].b[2]; xr8[0x3B]=&Reg_XDE[3].b[3];
    xr8[0x3C]=&Reg_XHL[3].b[0]; xr8[0x3D]=&Reg_XHL[3].b[1]; xr8[0x3E]=&Reg_XHL[3].b[2]; xr8[0x3F]=&Reg_XHL[3].b[3];
    xr8[0xF0]=&Reg_XIX.b[0]; xr8[0xF1]=&Reg_XIX.b[1]; xr8[0xF2]=&Reg_XIX.b[2]; xr8[0xF3]=&Reg_XIX.b[3];
    xr8[0xF4]=&Reg_XIY.b[0]; xr8[0xF5]=&Reg_XIY.b[1]; xr8[0xF6]=&Reg_XIY.b[2]; xr8[0xF7]=&Reg_XIY.b[3];
    xr8[0xF8]=&Reg_XIZ.b[0]; xr8[0xF9]=&Reg_XIZ.b[1]; xr8[0xFA]=&Reg_XIZ.b[2]; xr8[0xFB]=&Reg_XIZ.b[3];
    xr8[0xFC]=&Reg_XSP.b[0]; xr8[0xFD]=&Reg_XSP.b[1]; xr8[0xFE]=&Reg_XSP.b[2]; xr8[0xFF]=&Reg_XSP.b[3];

    r32p[0]=&XWA; r32p[1]=&XBC;
    r32p[2]=&XDE; r32p[3]=&XHL;
    r32p[4]=&XIX; r32p[5]=&XIY;
    r32p[6]=&XIZ; r32p[7]=&XSP;
    r16p[0]=&WA; r16p[1]=&BC;
    r16p[2]=&DE; r16p[3]=&HL;
    r16p[4]=&IX; r16p[5]=&IY;
    r16p[6]=&IZ; r16p[7]=&SP;
    r8p[0]=&W; r8p[1]=&A;
    r8p[2]=&B; r8p[3]=&C;
    r8p[4]=&D; r8p[5]=&E;
    r8p[6]=&H; r8p[7]=&L;



    /* Initializes registers */
    startPC = (rom[0x20001E]<<16)+(rom[0x20001D]<<8)+rom[0x20001C];
    PC = startPC;

    XSP = 0x00000100;

    sysm=1; //static
    iff=7;
    max=1;  //static
    rb=0;   /* register bank */
    rb2=0;  //static

    fS=0;
    fZ=0;
    fB2=0;  //static
    fH=0;
    fB1=0;  //static
    fV=0;
    fN=0;
    fC=0;

    fSHADOW=0x00; //ya:)
    
    
    /* Initializes parts of memory map with some data so code execution
       works better, still needs ALOT of tuning */
       
       
    /* Hack to simulate BIOS shit */
    /* Desc: 0xFFFE000 - 0xFFFEFF holds 64 vectors to bios functions */
    /*       what I do is load all of these with a fake offset, where */
    /*       i simply place a RET instruction :-) All credits to Judge! */
    
    rom[0x00FFFD00]=0x0E; /* RET instruction */
    WRITE_L(0x00FFFE00,0x00FFFD00);
    WRITE_L(0x00FFFE04,0x00FFFD00);
    WRITE_L(0x00FFFE08,0x00FFFD00);
    WRITE_L(0x00FFFE0C,0x00FFFD00);
    WRITE_L(0x00FFFE10,0x00FFFD00);
    WRITE_L(0x00FFFE14,0x00FFFD00);
    WRITE_L(0x00FFFE18,0x00FFFD00);
    WRITE_L(0x00FFFE1C,0x00FFFD00);
    WRITE_L(0x00FFFE20,0x00FFFD00);
    WRITE_L(0x00FFFE24,0x00FFFD00);
    WRITE_L(0x00FFFE28,0x00FFFD00);
    WRITE_L(0x00FFFE2C,0x00FFFD00);
    WRITE_L(0x00FFFE30,0x00FFFD00);
    WRITE_L(0x00FFFE34,0x00FFFD00);
    WRITE_L(0x00FFFE38,0x00FFFD00);
    WRITE_L(0x00FFFE3C,0x00FFFD00);
    WRITE_L(0x00FFFE40,0x00FFFD00);
    WRITE_L(0x00FFFE44,0x00FFFD00);
    WRITE_L(0x00FFFE48,0x00FFFD00);
    WRITE_L(0x00FFFE4C,0x00FFFD00);
    WRITE_L(0x00FFFE50,0x00FFFD00);
    WRITE_L(0x00FFFE54,0x00FFFD00);
    WRITE_L(0x00FFFE58,0x00FFFD00);
    WRITE_L(0x00FFFE5C,0x00FFFD00);
    WRITE_L(0x00FFFE60,0x00FFFD00);
    WRITE_L(0x00FFFE64,0x00FFFD00);
    WRITE_L(0x00FFFE68,0x00FFFD00);
    WRITE_L(0x00FFFE6C,0x00FFFD00);
    WRITE_L(0x00FFFE70,0x00FFFD00);
    WRITE_L(0x00FFFE74,0x00FFFD00);
    WRITE_L(0x00FFFE78,0x00FFFD00);
    WRITE_L(0x00FFFE7C,0x00FFFD00);
    WRITE_L(0x00FFFE80,0x00FFFD00);
    WRITE_L(0x00FFFE84,0x00FFFD00);
    WRITE_L(0x00FFFE88,0x00FFFD00);
    WRITE_L(0x00FFFE8C,0x00FFFD00);
    WRITE_L(0x00FFFE90,0x00FFFD00);
    WRITE_L(0x00FFFE94,0x00FFFD00);
    WRITE_L(0x00FFFE98,0x00FFFD00);
    WRITE_L(0x00FFFE9C,0x00FFFD00);
    WRITE_L(0x00FFFEA0,0x00FFFD00);
    WRITE_L(0x00FFFEA4,0x00FFFD00);
    WRITE_L(0x00FFFEA8,0x00FFFD00);
    WRITE_L(0x00FFFEAC,0x00FFFD00);
    WRITE_L(0x00FFFEB0,0x00FFFD00);
    WRITE_L(0x00FFFEB4,0x00FFFD00);
    WRITE_L(0x00FFFEB8,0x00FFFD00);
    WRITE_L(0x00FFFEBC,0x00FFFD00);
    WRITE_L(0x00FFFEC0,0x00FFFD00);
    WRITE_L(0x00FFFEC4,0x00FFFD00);
    WRITE_L(0x00FFFEC8,0x00FFFD00);
    WRITE_L(0x00FFFECC,0x00FFFD00);
    WRITE_L(0x00FFFED0,0x00FFFD00);
    WRITE_L(0x00FFFED4,0x00FFFD00);
    WRITE_L(0x00FFFED8,0x00FFFD00);
    WRITE_L(0x00FFFEDC,0x00FFFD00);
    WRITE_L(0x00FFFEE0,0x00FFFD00);
    WRITE_L(0x00FFFEE4,0x00FFFD00);
    WRITE_L(0x00FFFEE8,0x00FFFD00);
    WRITE_L(0x00FFFEEC,0x00FFFD00);
    WRITE_L(0x00FFFEF0,0x00FFFD00);
    WRITE_L(0x00FFFEF4,0x00FFFD00);
    WRITE_L(0x00FFFEF8,0x00FFFD00);
    WRITE_L(0x00FFFEFC,0x00FFFD00);


    if (rom[0x200023]==0x10) {
	/* NeoGeo Pocket Color ROM */
	rom[0x006F91]=0x10;
    }
    
    rom[0x006F87]=0x01; /* Sets Language to USA */
    
    
    
}

long smartpxl (char val) {
    long x=0;
    /* val = 0-3 */
    switch (val) {
        case 0: x=0x8080; break;
        case 1: x=0xA0A0; break;
        case 2: x=0xC0C0; break;
        case 3: x=0xF0F0; break;
    }
    return x;
}
