/* e900h.c */

void emu900h() {

    int          i=0;
    uchar        tmp8=0;
    signed char  tmp8s=0;
    uint         tmp16=0;
    ulong        tmp32=0;
    char         tmpadj=0;
    uchar        byte1=0;

    uint         eTmp16=0,eTmp16b=0;
    signed int   eTmp16s=0;
    ulong        eTmp24=0;

    UPDATE_REGBANK;

    byte1 = rom[PC];
    opcode = rom[PC];
    
    tmp8s=rom[PC+1]; /* for relative jumps */

    if ((rom[PC]<0x80) || (rom[PC]>=0xF7)) {

        switch (rom[PC]) {
            case 0x00: PC++; break;

            case 0x02: PUSH_SR; PC++; break;
            case 0x03: POP_SR; UPDATE_REGBANK; PC++; break;

            case 0x05: // PC++; break;     /* HALT,  unemulated */
            case 0x06: iff=rom[PC+1]; PC+=2; break;
            case 0x07: // PC++; break;     /* RETI,  unemulated */
            case 0x08: rom[rom[PC+1]]=rom[PC+2]; PC+=3; break;
            case 0x09: XSP-=1; rom[XSP]=rom[rom[PC+1]]; PC+=2; break;
            case 0x0A: rom[rom[PC+1]]=rom[PC+3]; rom[rom[PC+1]+1]=rom[PC+2]; PC+=4; break;
            case 0x0B: XSP-=2; rom[XSP]=rom[rom[PC+1]]; rom[XSP+1]=rom[PC+2]; PC+=3; break;
            case 0x0C: rb++; UPDATE_REGBANK; PC++; break;
            case 0x0D: rb--; UPDATE_REGBANK; PC++; break;
            case 0x0E: RET; break;
            //0x0F = RETD 16bit
            case 0x10: fC=0; fH=0; fV=0; PC++; break;
            case 0x11: fC=1; fH=0; fN=0; PC++; break;
            case 0x12: if (fC==0) fC=1; else fC=0; fN=0; PC++; break;
            case 0x13: if (fZ==0) fC=1; else fC=0; fN=0; PC++; break;
            case 0x14: XSP--; rom[XSP]=A; PC++; break; /* PUSH A, correct? */
            case 0x15: A=rom[XSP]; XSP++; PC++; break; /* POP A, correct? */
            case 0x16: tmp8=flagreg; flagreg=fSHADOW; fSHADOW=tmp8; PC++; break;
            case 0x17: rb=rom[PC+1]; UPDATE_REGBANK; PC+=2; break;
            case 0x18: XSP--; rom[XSP]=flagreg; PC++; break;
            case 0x19: flagreg=rom[XSP]; XSP++; PC++; break;
            case 0x1A: JP_16; break;
            case 0x1B: JP_24; break;
            //0x1C = CALL 16bit
            case 0x1D: CALL_24; break;
            case 0x1E: CALR_16; break;

            case 0x20: LD(W,rom[PC+1]); PC+=2; break;
            case 0x21: LD(A,rom[PC+1]); PC+=2; break;
            case 0x22: LD(B,rom[PC+1]); PC+=2; break;
            case 0x23: LD(C,rom[PC+1]); PC+=2; break;
            case 0x24: LD(D,rom[PC+1]); PC+=2; break;
            case 0x25: LD(E,rom[PC+1]); PC+=2; break;
            case 0x26: LD(H,rom[PC+1]); PC+=2; break;
            case 0x27: LD(L,rom[PC+1]); PC+=2; break;
            case 0x28: PUSH_W(WA); PC++; break;
            case 0x29: PUSH_W(BC); PC++; break;
            case 0x2A: PUSH_W(DE); PC++; break;
            case 0x2B: PUSH_W(HL); PC++; break;
            case 0x2C: PUSH_W(IX); PC++; break;
            case 0x2D: PUSH_W(IY); PC++; break;
            case 0x2E: PUSH_W(IZ); PC++; break;
            case 0x2F: PUSH_W(SP); PC++; break;
            case 0x30: LD(WA,(rom[PC+2]<<8)+rom[PC+1]); PC+=3; break;
            case 0x31: LD(BC,(rom[PC+2]<<8)+rom[PC+1]); PC+=3; break;
            case 0x32: LD(DE,(rom[PC+2]<<8)+rom[PC+1]); PC+=3; break;
            case 0x33: LD(HL,(rom[PC+2]<<8)+rom[PC+1]); PC+=3; break;
            case 0x34: LD(IX,(rom[PC+2]<<8)+rom[PC+1]); PC+=3; break;
            case 0x35: LD(IY,(rom[PC+2]<<8)+rom[PC+1]); PC+=3; break;
            case 0x36: LD(IZ,(rom[PC+2]<<8)+rom[PC+1]); PC+=3; break;
            case 0x37: LD(SP,(rom[PC+2]<<8)+rom[PC+1]); PC+=3; break;
            case 0x38: PUSH_L(XWA); PC++; break;
            case 0x39: PUSH_L(XBC); PC++; break;
            case 0x3A: PUSH_L(XDE); PC++; break;
            case 0x3B: PUSH_L(XHL); PC++; break;
            case 0x3C: PUSH_L(XIX); PC++; break;
            case 0x3D: PUSH_L(XIY); PC++; break;
            case 0x3E: PUSH_L(XIZ); PC++; break;
            case 0x3F: PUSH_L(XSP); PC++; break;
            case 0x40: LD(XWA,(rom[PC+4]<<24)+(rom[PC+3]<<16)+(rom[PC+2]<<8)+rom[PC+1]); PC+=5; break;
            case 0x41: LD(XBC,(rom[PC+4]<<24)+(rom[PC+3]<<16)+(rom[PC+2]<<8)+rom[PC+1]); PC+=5; break;
            case 0x42: LD(XDE,(rom[PC+4]<<24)+(rom[PC+3]<<16)+(rom[PC+2]<<8)+rom[PC+1]); PC+=5; break;
            case 0x43: LD(XHL,(rom[PC+4]<<24)+(rom[PC+3]<<16)+(rom[PC+2]<<8)+rom[PC+1]); PC+=5; break;
            case 0x44: LD(XIX,(rom[PC+4]<<24)+(rom[PC+3]<<16)+(rom[PC+2]<<8)+rom[PC+1]); PC+=5; break;
            case 0x45: LD(XIY,(rom[PC+4]<<24)+(rom[PC+3]<<16)+(rom[PC+2]<<8)+rom[PC+1]); PC+=5; break;
            case 0x46: LD(XIZ,(rom[PC+4]<<24)+(rom[PC+3]<<16)+(rom[PC+2]<<8)+rom[PC+1]); PC+=5; break;
            case 0x47: LD(XSP,(rom[PC+4]<<24)+(rom[PC+3]<<16)+(rom[PC+2]<<8)+rom[PC+1]); PC+=5; break;
            case 0x48: POP_W(WA); PC++; break;
            case 0x49: POP_W(BC); PC++; break;
            case 0x4A: POP_W(DE); PC++; break;
            case 0x4B: POP_W(HL); PC++; break;
            case 0x4C: POP_W(IX); PC++; break;
            case 0x4D: POP_W(IY); PC++; break;
            case 0x4E: POP_W(IZ); PC++; break;
            case 0x4F: POP_W(SP); PC++; break;

            case 0x58: POP_L(XWA); PC++; break;
            case 0x59: POP_L(XBC); PC++; break;
            case 0x5A: POP_L(XDE); PC++; break;
            case 0x5B: POP_L(XHL); PC++; break;
            case 0x5C: POP_L(XIX); PC++; break;
            case 0x5D: POP_L(XIY); PC++; break;
            case 0x5E: POP_L(XIZ); PC++; break;
            case 0x5F: POP_L(XSP); PC++; break;
            case 0x60: PC+=2; break;
            case 0x61: if      ((fS^fV)==1) PC=PC+2+tmp8s; else PC+=2; break;
            case 0x62: if ((fZ|(fS^fV))==1) PC=PC+2+tmp8s; else PC+=2; break;
            case 0x63: if      ((fC|fZ)==1) PC=PC+2+tmp8s; else PC+=2; break;
            case 0x64: if           (fV==1) PC=PC+2+tmp8s; else PC+=2; break;
            case 0x65: if           (fS==1) PC=PC+2+tmp8s; else PC+=2; break;
            case 0x66: if           (fZ==1) PC=PC+2+tmp8s; else PC+=2; break;
            case 0x67: if           (fC==1) PC=PC+2+tmp8s; else PC+=2; break;
            case 0x68:                      PC=PC+2+tmp8s; break;
            case 0x69: if      ((fS^fV)==0) PC=PC+2+tmp8s; else PC+=2; break;
            case 0x6A: if ((fZ|(fS^fV))==0) PC=PC+2+tmp8s; else PC+=2; break;
            case 0x6B: if      ((fC|fZ)==0) PC=PC+2+tmp8s; else PC+=2; break;
            case 0x6C: if           (fV==0) PC=PC+2+tmp8s; else PC+=2; break;
            case 0x6D: if           (fS==0) PC=PC+2+tmp8s; else PC+=2; break;
            case 0x6E: if           (fZ==0) PC=PC+2+tmp8s; else PC+=2; break;
            case 0x6F: if           (fC==0) PC=PC+2+tmp8s; else PC+=2; break;
            case 0x70: PC+=3; break; /* JRL F, d16 */
            case 0x71: if      ((fS^fV)==1) { eTmp16s = (rom[PC+2]<<8)+rom[PC+1]; PC=PC+3+eTmp16s; } else { PC+=3; } break;
            case 0x72: if ((fZ|(fS^fV))==1) { eTmp16s = (rom[PC+2]<<8)+rom[PC+1]; PC=PC+3+eTmp16s; } else { PC+=3; } break;
            case 0x73: if      ((fC|fZ)==1) { eTmp16s = (rom[PC+2]<<8)+rom[PC+1]; PC=PC+3+eTmp16s; } else { PC+=3; } break;
            case 0x74: if           (fV==1) { eTmp16s = (rom[PC+2]<<8)+rom[PC+1]; PC=PC+3+eTmp16s; } else { PC+=3; } break;
            case 0x75: if           (fS==1) { eTmp16s = (rom[PC+2]<<8)+rom[PC+1]; PC=PC+3+eTmp16s; } else { PC+=3; } break;
            case 0x76: if           (fZ==1) { eTmp16s = (rom[PC+2]<<8)+rom[PC+1]; PC=PC+3+eTmp16s; } else { PC+=3; } break;
            case 0x77: if           (fC==1) { eTmp16s = (rom[PC+2]<<8)+rom[PC+1]; PC=PC+3+eTmp16s; } else { PC+=3; } break;
            case 0x78:                        eTmp16s = (rom[PC+2]<<8)+rom[PC+1]; PC=PC+3+eTmp16s; break;
            case 0x79: if      ((fS^fV)==0) { eTmp16s = (rom[PC+2]<<8)+rom[PC+1]; PC=PC+3+eTmp16s; } else { PC+=3; } break;
            case 0x7A: if ((fZ|(fS^fV))==0) { eTmp16s = (rom[PC+2]<<8)+rom[PC+1]; PC=PC+3+eTmp16s; } else { PC+=3; } break;
            case 0x7B: if      ((fC|fZ)==0) { eTmp16s = (rom[PC+2]<<8)+rom[PC+1]; PC=PC+3+eTmp16s; } else { PC+=3; } break;
            case 0x7C: if           (fV==0) { eTmp16s = (rom[PC+2]<<8)+rom[PC+1]; PC=PC+3+eTmp16s; } else { PC+=3; } break;
            case 0x7D: if           (fS==0) { eTmp16s = (rom[PC+2]<<8)+rom[PC+1]; PC=PC+3+eTmp16s; } else { PC+=3; } break;
            case 0x7E: if           (fZ==0) { eTmp16s = (rom[PC+2]<<8)+rom[PC+1]; PC=PC+3+eTmp16s; } else { PC+=3; } break;
            case 0x7F: if           (fC==0) { eTmp16s = (rom[PC+2]<<8)+rom[PC+1]; PC=PC+3+eTmp16s; } else { PC+=3; } break;

            //0xF7 = LDX (n),n
            case 0xF8: PC++; break;     /* SWI 0, unemulated */
            case 0xF9: PC++; break;     /* SWI 1, unemulated */
            case 0xFA: PC++; break;     /* SWI 2, unemulated */
            case 0xFB: PC++; break;     /* SWI 3, unemulated */
            case 0xFC: PC++; break;     /* SWI 4, unemulated */
            case 0xFD: PC++; break;     /* SWI 5, unemulated */
            case 0xFE: PC++; break;     /* SWI 6, unemulated */
            case 0xFF: PC++; break;     /* SWI 7, unemulated */
        }
    } /* ((rom[PC]<0x80) || (rom[PC]>=0xF7)) */


    else if ( !((madr.hi==1) && (madr.lo>=0x7)) ) { /* if NOT register instructions */
	    
        /* Extracts (mem) info and then continues with processing the instruction */
        if (madr.hi==0) {
            switch (madr.lo) {
                case 0x0: /* (XWA) */    *memadr=*r32p[madr.lo]; PC++; break;
                case 0x1: /* (XBC) */    *memadr=*r32p[madr.lo]; PC++; break;
                case 0x2: /* (XDE) */    *memadr=*r32p[madr.lo]; PC++; break;
                case 0x3: /* (XHL) */    *memadr=*r32p[madr.lo]; PC++; break;
                case 0x4: /* (XIX) */    *memadr=*r32p[madr.lo]; PC++; break;
                case 0x5: /* (XIY) */    *memadr=*r32p[madr.lo]; PC++; break;
                case 0x6: /* (XIZ) */    *memadr=*r32p[madr.lo]; PC++; break;
                case 0x7: /* (XSP) */    *memadr=*r32p[madr.lo]; PC++; break;
                case 0x8: /* (XWA+d8) */ *memadr=*r32p[madr.lo]+rom[PC+1]; PC+=2; break;
                case 0x9: /* (XBC+d8) */ *memadr=*r32p[madr.lo]+rom[PC+1]; PC+=2; break;
                case 0xA: /* (XDE+d8) */ *memadr=*r32p[madr.lo]+rom[PC+1]; PC+=2; break;
                case 0xB: /* (XHL+d8) */ *memadr=*r32p[madr.lo]+rom[PC+1]; PC+=2; break;
                case 0xC: /* (XIX+d8) */ *memadr=*r32p[madr.lo]+rom[PC+1]; PC+=2; break;
                case 0xD: /* (XIY+d8) */ *memadr=*r32p[madr.lo]+rom[PC+1]; PC+=2; break;
                case 0xE: /* (XIZ+d8) */ *memadr=*r32p[madr.lo]+rom[PC+1]; PC+=2; break;
                case 0xF: /* (XSP+d8) */ *memadr=*r32p[madr.lo]+rom[PC+1]; PC+=2; break;
            }    
        } else { /* madr.hi==1 */
            eTmp16 =(rom[PC+2]<<8)+rom[PC+1];
            eTmp16b=(rom[PC+3]<<8)+rom[PC+2];
            eTmp16s=(rom[PC+3]<<8)+rom[PC+2];
            eTmp24 =(rom[PC+3]<<16)+(rom[PC+2]<<8)+rom[PC+1];
            r32enc = rom[PC+1];

            switch (madr.lo) {
                case 0x0: /*  (#8) */ *memadr=rom[PC+1]; PC+=2; break;
                case 0x1: /* (#16) */ *memadr=eTmp16; PC+=3; break;
                case 0x2: /* (#24) */ *memadr=eTmp24; PC+=4; break;
                case 0x3: /* Multiple encodings */
                    switch (r32id) {
                        case 0: /* (r32') */    *memadr=*xr32[r32reg]; PC+=2; break;
                        case 1: /* (r32+d16) */
                            if (eTmp16s>=0x8000)
                                *memadr=*xr32[r32reg]+(0x10000-eTmp16b);
                            else
                                *memadr=*xr32[r32reg]+eTmp16b;
                            PC+=4; break;


                        case 3:
                            switch(r32reg) {
                                case 0: /* (r32+r8)  */ *memadr=*xr32[rom[PC+2]/4]+*xr8[rom[PC+3]]; PC+=4; break;
                                case 1: /* (r32+r16) */ *memadr=*xr32[rom[PC+2]/4]+*xr16[rom[PC+3]/2]; PC+=4; break;
                            }
                        } break;
		    
                case 0x4: /* (-r32) pre decrement */
                    if (r32id==0) *xr32[r32reg]-=1;
                    if (r32id==1) *xr32[r32reg]-=2;
                    if (r32id==2) *xr32[r32reg]-=4;
                    *memadr=*xr32[r32reg]; PC+=2; break;
		    
                case 0x5: /* (r32+) post increment*/
                    if (r32id==0) tmpadj=1;
                    if (r32id==1) tmpadj=2;
                    if (r32id==2) tmpadj=4;
                    *memadr=*xr32[r32reg]; PC+=2; break;                    

            }
        }

        switch (madr.type) {
            case 0: /* src.B */
                eTmp16=(rom[PC+2]<<8)+rom[PC+1];

                switch (rom[PC]) {
                    case 0x10:
                        switch (byte1) { /* LDIB (XDE+),(XHL+) & (XIX+),(XIY+) */
                            case 0x83: rom[XDE]=rom[XHL]; XDE++; XHL++; BC--; fH=0; ZERO(BC); fN=0; break;
                            case 0x85: rom[XIX]=rom[XIY]; XIX++; XIY++; BC--; fH=0; ZERO(BC); fN=0; break;
                        } PC++; break;

                    case 0x11:
                        switch (byte1) { /* LDIRB (XDE+),(XHL+) & (XIX+),(XIY+) */
                            case 0x83: while (BC>0) { rom[XDE]=rom[XHL]; XDE++; XHL++; BC--; } fH=0; fV=0; fN=0; break;
                            case 0x85: while (BC>0) { rom[XIX]=rom[XIY]; XIX++; XIY++; BC--; } fH=0; fV=0; fN=0; break;
                        } PC++; break;

                    case 0x19: rom[eTmp16]=rom[*memadr]; PC+=3; break;

                    case 0x20: W=rom[*memadr]; PC++; break;
                    case 0x21: A=rom[*memadr]; PC++; break;
                    case 0x22: B=rom[*memadr]; PC++; break;
                    case 0x23: C=rom[*memadr]; PC++; break;
                    case 0x24: D=rom[*memadr]; PC++; break;
                    case 0x25: E=rom[*memadr]; PC++; break;
                    case 0x26: H=rom[*memadr]; PC++; break;
                    case 0x27: L=rom[*memadr]; PC++; break;

                    case 0x38: ADD_B(rom[*memadr],rom[PC+1]); PC+=2; break;
                    case 0x39: ADC_B(rom[*memadr],rom[PC+1]); PC+=2; break;
                    case 0x3A: SUB_B(rom[*memadr],rom[PC+1]); PC+=2; break;
                    case 0x3B: SBC_B(rom[*memadr],rom[PC+1]); PC+=2; break;
                    case 0x3C: AND_B(rom[*memadr],rom[PC+1]); PC+=2; break;
                    case 0x3D: XOR_B(rom[*memadr],rom[PC+1]); PC+=2; break;
                    case 0x3E: OR_B(rom[*memadr],rom[PC+1]); PC+=2; break;
                    case 0x3F: CP_B(rom[*memadr],rom[PC+1]); PC+=2; break;
		    
                    case 0x60: INC_B(rom[*memadr],8); PC++; break;
                    case 0x61: INC_B(rom[*memadr],1); PC++; break;
                    case 0x62: INC_B(rom[*memadr],2); PC++; break;
                    case 0x63: INC_B(rom[*memadr],3); PC++; break;
                    case 0x64: INC_B(rom[*memadr],4); PC++; break;
                    case 0x65: INC_B(rom[*memadr],5); PC++; break;
                    case 0x66: INC_B(rom[*memadr],6); PC++; break;
                    case 0x67: INC_B(rom[*memadr],7); PC++; break;
                    case 0x68: DEC_B(rom[*memadr],8); PC++; break;
                    case 0x69: DEC_B(rom[*memadr],1); PC++; break;
                    case 0x6A: DEC_B(rom[*memadr],2); PC++; break;
                    case 0x6B: DEC_B(rom[*memadr],3); PC++; break;
                    case 0x6C: DEC_B(rom[*memadr],4); PC++; break;
                    case 0x6D: DEC_B(rom[*memadr],5); PC++; break;
                    case 0x6E: DEC_B(rom[*memadr],6); PC++; break;
                    case 0x6F: DEC_B(rom[*memadr],7); PC++; break;

                    case 0x80: ADD_B(W,rom[*memadr]); PC++; break;
                    case 0x81: ADD_B(A,rom[*memadr]); PC++; break;
                    case 0x82: ADD_B(B,rom[*memadr]); PC++; break;
                    case 0x83: ADD_B(C,rom[*memadr]); PC++; break;
                    case 0x84: ADD_B(D,rom[*memadr]); PC++; break;
                    case 0x85: ADD_B(E,rom[*memadr]); PC++; break;
                    case 0x86: ADD_B(H,rom[*memadr]); PC++; break;
                    case 0x87: ADD_B(L,rom[*memadr]); PC++; break;
                    case 0x88: ADD_B(rom[*memadr],W); PC++; break;
                    case 0x89: ADD_B(rom[*memadr],A); PC++; break;
                    case 0x8A: ADD_B(rom[*memadr],B); PC++; break;
                    case 0x8B: ADD_B(rom[*memadr],C); PC++; break;
                    case 0x8C: ADD_B(rom[*memadr],D); PC++; break;
                    case 0x8D: ADD_B(rom[*memadr],E); PC++; break;
                    case 0x8E: ADD_B(rom[*memadr],H); PC++; break;
                    case 0x8F: ADD_B(rom[*memadr],L); PC++; break;
                    case 0x90: ADC_B(W,rom[*memadr]); PC++; break;
                    case 0x91: ADC_B(A,rom[*memadr]); PC++; break;
                    case 0x92: ADC_B(B,rom[*memadr]); PC++; break;
                    case 0x93: ADC_B(C,rom[*memadr]); PC++; break;
                    case 0x94: ADC_B(D,rom[*memadr]); PC++; break;
                    case 0x95: ADC_B(E,rom[*memadr]); PC++; break;
                    case 0x96: ADC_B(H,rom[*memadr]); PC++; break;
                    case 0x97: ADC_B(L,rom[*memadr]); PC++; break;
                    case 0x98: ADC_B(rom[*memadr],W); PC++; break;
                    case 0x99: ADC_B(rom[*memadr],A); PC++; break;
                    case 0x9A: ADC_B(rom[*memadr],B); PC++; break;
                    case 0x9B: ADC_B(rom[*memadr],C); PC++; break;
                    case 0x9C: ADC_B(rom[*memadr],D); PC++; break;
                    case 0x9D: ADC_B(rom[*memadr],E); PC++; break;
                    case 0x9E: ADC_B(rom[*memadr],H); PC++; break;
                    case 0x9F: ADC_B(rom[*memadr],L); PC++; break;
                    case 0xA0: SUB_B(W,rom[*memadr]); PC++; break;
                    case 0xA1: SUB_B(A,rom[*memadr]); PC++; break;
                    case 0xA2: SUB_B(B,rom[*memadr]); PC++; break;
                    case 0xA3: SUB_B(C,rom[*memadr]); PC++; break;
                    case 0xA4: SUB_B(D,rom[*memadr]); PC++; break;
                    case 0xA5: SUB_B(E,rom[*memadr]); PC++; break;
                    case 0xA6: SUB_B(H,rom[*memadr]); PC++; break;
                    case 0xA7: SUB_B(L,rom[*memadr]); PC++; break;
                    case 0xA8: SUB_B(rom[*memadr],W); PC++; break;
                    case 0xA9: SUB_B(rom[*memadr],A); PC++; break;
                    case 0xAA: SUB_B(rom[*memadr],B); PC++; break;
                    case 0xAB: SUB_B(rom[*memadr],C); PC++; break;
                    case 0xAC: SUB_B(rom[*memadr],D); PC++; break;
                    case 0xAD: SUB_B(rom[*memadr],E); PC++; break;
                    case 0xAE: SUB_B(rom[*memadr],H); PC++; break;
                    case 0xAF: SUB_B(rom[*memadr],L); PC++; break;
                    case 0xB0: SBC_B(W,rom[*memadr]); PC++; break;
                    case 0xB1: SBC_B(A,rom[*memadr]); PC++; break;
                    case 0xB2: SBC_B(B,rom[*memadr]); PC++; break;
                    case 0xB3: SBC_B(C,rom[*memadr]); PC++; break;
                    case 0xB4: SBC_B(D,rom[*memadr]); PC++; break;
                    case 0xB5: SBC_B(E,rom[*memadr]); PC++; break;
                    case 0xB6: SBC_B(H,rom[*memadr]); PC++; break;
                    case 0xB7: SBC_B(L,rom[*memadr]); PC++; break;
                    case 0xB8: SBC_B(rom[*memadr],W); PC++; break;
                    case 0xB9: SBC_B(rom[*memadr],A); PC++; break;
                    case 0xBA: SBC_B(rom[*memadr],B); PC++; break;
                    case 0xBB: SBC_B(rom[*memadr],C); PC++; break;
                    case 0xBC: SBC_B(rom[*memadr],D); PC++; break;
                    case 0xBD: SBC_B(rom[*memadr],E); PC++; break;
                    case 0xBE: SBC_B(rom[*memadr],H); PC++; break;
                    case 0xBF: SBC_B(rom[*memadr],L); PC++; break;
                    case 0xC0: AND_B(W,rom[*memadr]); PC++; break;
                    case 0xC1: AND_B(A,rom[*memadr]); PC++; break;
                    case 0xC2: AND_B(B,rom[*memadr]); PC++; break;
                    case 0xC3: AND_B(C,rom[*memadr]); PC++; break;
                    case 0xC4: AND_B(D,rom[*memadr]); PC++; break;
                    case 0xC5: AND_B(E,rom[*memadr]); PC++; break;
                    case 0xC6: AND_B(H,rom[*memadr]); PC++; break;
                    case 0xC7: AND_B(L,rom[*memadr]); PC++; break;
                    case 0xC8: AND_B(rom[*memadr],W); PC++; break;
                    case 0xC9: AND_B(rom[*memadr],A); PC++; break;
                    case 0xCA: AND_B(rom[*memadr],B); PC++; break;
                    case 0xCB: AND_B(rom[*memadr],C); PC++; break;
                    case 0xCC: AND_B(rom[*memadr],D); PC++; break;
                    case 0xCD: AND_B(rom[*memadr],E); PC++; break;
                    case 0xCE: AND_B(rom[*memadr],H); PC++; break;
                    case 0xCF: AND_B(rom[*memadr],L); PC++; break;
                    case 0xD0: XOR_B(W,rom[*memadr]); PC++; break;
                    case 0xD1: XOR_B(A,rom[*memadr]); PC++; break;
                    case 0xD2: XOR_B(B,rom[*memadr]); PC++; break;
                    case 0xD3: XOR_B(C,rom[*memadr]); PC++; break;
                    case 0xD4: XOR_B(D,rom[*memadr]); PC++; break;
                    case 0xD5: XOR_B(E,rom[*memadr]); PC++; break;
                    case 0xD6: XOR_B(H,rom[*memadr]); PC++; break;
                    case 0xD7: XOR_B(L,rom[*memadr]); PC++; break;
                    case 0xD8: XOR_B(rom[*memadr],W); PC++; break;
                    case 0xD9: XOR_B(rom[*memadr],A); PC++; break;
                    case 0xDA: XOR_B(rom[*memadr],B); PC++; break;
                    case 0xDB: XOR_B(rom[*memadr],C); PC++; break;
                    case 0xDC: XOR_B(rom[*memadr],D); PC++; break;
                    case 0xDD: XOR_B(rom[*memadr],E); PC++; break;
                    case 0xDE: XOR_B(rom[*memadr],H); PC++; break;
                    case 0xDF: XOR_B(rom[*memadr],L); PC++; break;
                    case 0xE0: OR_B(W,rom[*memadr]); PC++; break;
                    case 0xE1: OR_B(A,rom[*memadr]); PC++; break;
                    case 0xE2: OR_B(B,rom[*memadr]); PC++; break;
                    case 0xE3: OR_B(C,rom[*memadr]); PC++; break;
                    case 0xE4: OR_B(D,rom[*memadr]); PC++; break;
                    case 0xE5: OR_B(E,rom[*memadr]); PC++; break;
                    case 0xE6: OR_B(H,rom[*memadr]); PC++; break;
                    case 0xE7: OR_B(L,rom[*memadr]); PC++; break;
                    case 0xE8: OR_B(rom[*memadr],W); PC++; break;
                    case 0xE9: OR_B(rom[*memadr],A); PC++; break;
                    case 0xEA: OR_B(rom[*memadr],B); PC++; break;
                    case 0xEB: OR_B(rom[*memadr],C); PC++; break;
                    case 0xEC: OR_B(rom[*memadr],D); PC++; break;
                    case 0xED: OR_B(rom[*memadr],E); PC++; break;
                    case 0xEE: OR_B(rom[*memadr],H); PC++; break;
                    case 0xEF: OR_B(rom[*memadr],L); PC++; break;
                    case 0xF0: CP_B(W,rom[*memadr]); PC++; break;
                    case 0xF1: CP_B(A,rom[*memadr]); PC++; break;
                    case 0xF2: CP_B(B,rom[*memadr]); PC++; break;
                    case 0xF3: CP_B(C,rom[*memadr]); PC++; break;
                    case 0xF4: CP_B(D,rom[*memadr]); PC++; break;
                    case 0xF5: CP_B(E,rom[*memadr]); PC++; break;
                    case 0xF6: CP_B(H,rom[*memadr]); PC++; break;
                    case 0xF7: CP_B(L,rom[*memadr]); PC++; break;
                    case 0xF8: CP_B(rom[*memadr],W); PC++; break;
                    case 0xF9: CP_B(rom[*memadr],A); PC++; break;
                    case 0xFA: CP_B(rom[*memadr],B); PC++; break;
                    case 0xFB: CP_B(rom[*memadr],C); PC++; break;
                    case 0xFC: CP_B(rom[*memadr],D); PC++; break;
                    case 0xFD: CP_B(rom[*memadr],E); PC++; break;
                    case 0xFE: CP_B(rom[*memadr],H); PC++; break;
                    case 0xFF: CP_B(rom[*memadr],L); PC++; break;

                } break;

            case 1: /* src.W */
                eTmp16=(rom[PC+2]<<8)+rom[PC+1];

                switch (rom[PC]) {
                    case 0x10:
                        switch (byte1) {
                            case 0x93: //LDIW   (XDE+),(XHL+)
                            case 0x95: //LDIW   (XIX+),(XIY+)
                        } break;

                    case 0x11:
                        switch (byte1) {
                            case 0x93: while (BC>0) { rom[XDE] = rom[XHL]; rom[XDE+1] = rom[XHL+1]; XDE+=2; XHL+=2; BC--; } fH=0; fV=0; fN=0; break;
                            case 0x95: while (BC>0) { rom[XIX] = rom[XIY]; rom[XIX+1] = rom[XIY+1]; XIX+=2; XIY+=2; BC--; } fH=0; fV=0; fN=0; break;
                        } PC++; break;

                    case 0x19: rom[eTmp16]=rom[*memadr]; rom[eTmp16+1]=rom[*memadr+1]; PC+=3; break;

                    case 0x20: LD_R16_MEM(WA,*memadr); PC++; break;
                    case 0x21: LD_R16_MEM(BC,*memadr); PC++; break;
                    case 0x22: LD_R16_MEM(DE,*memadr); PC++; break;
                    case 0x23: LD_R16_MEM(HL,*memadr); PC++; break;
                    case 0x24: LD_R16_MEM(IX,*memadr); PC++; break;
                    case 0x25: LD_R16_MEM(IY,*memadr); PC++; break;
                    case 0x26: LD_R16_MEM(IZ,*memadr); PC++; break;
                    case 0x27: LD_R16_MEM(SP,*memadr); PC++; break;

                    case 0x38: ADD_W(rom[*memadr],eTmp16); PC+=3; break;
                    case 0x39: ADC_W(rom[*memadr],eTmp16); PC+=3; break;
                    case 0x3A: SUB_W(rom[*memadr],eTmp16); PC+=3; break;
                    case 0x3B: SBC_W(rom[*memadr],eTmp16); PC+=3; break;
                    case 0x3C: AND_W(rom[*memadr],eTmp16); PC+=3; break;
                    case 0x3D: XOR_W(rom[*memadr],eTmp16); PC+=3; break;
                    case 0x3E: OR_W(rom[*memadr],eTmp16); PC+=3; break;
                    case 0x3F: CP_W(rom[*memadr],eTmp16); PC+=3; break;

                    case 0x60: INC_W(rom[*memadr],8); PC++; break;
                    case 0x61: INC_W(rom[*memadr],1); PC++; break;
                    case 0x62: INC_W(rom[*memadr],2); PC++; break;
                    case 0x63: INC_W(rom[*memadr],3); PC++; break;
                    case 0x64: INC_W(rom[*memadr],4); PC++; break;
                    case 0x65: INC_W(rom[*memadr],5); PC++; break;
                    case 0x66: INC_W(rom[*memadr],6); PC++; break;
                    case 0x67: INC_W(rom[*memadr],7); PC++; break;
                    case 0x68: DEC_W(rom[*memadr],8); PC++; break;
                    case 0x69: DEC_W(rom[*memadr],1); PC++; break;
                    case 0x6A: DEC_W(rom[*memadr],2); PC++; break;
                    case 0x6B: DEC_W(rom[*memadr],3); PC++; break;
                    case 0x6C: DEC_W(rom[*memadr],4); PC++; break;
                    case 0x6D: DEC_W(rom[*memadr],5); PC++; break;
                    case 0x6E: DEC_W(rom[*memadr],6); PC++; break;
                    case 0x6F: DEC_W(rom[*memadr],7); PC++; break;

                    case 0x80: ADD_W(WA,rom[*memadr]); PC++; break;
                    case 0x81: ADD_W(BC,rom[*memadr]); PC++; break;
                    case 0x82: ADD_W(DE,rom[*memadr]); PC++; break;
                    case 0x83: ADD_W(HL,rom[*memadr]); PC++; break;
                    case 0x84: ADD_W(IX,rom[*memadr]); PC++; break;
                    case 0x85: ADD_W(IY,rom[*memadr]); PC++; break;
                    case 0x86: ADD_W(IZ,rom[*memadr]); PC++; break;
                    case 0x87: ADD_W(SP,rom[*memadr]); PC++; break;
                    case 0x88: ADD_W(rom[*memadr],WA); PC++; break;
                    case 0x89: ADD_W(rom[*memadr],BC); PC++; break;
                    case 0x8A: ADD_W(rom[*memadr],DE); PC++; break;
                    case 0x8B: ADD_W(rom[*memadr],HL); PC++; break;
                    case 0x8C: ADD_W(rom[*memadr],IX); PC++; break;
                    case 0x8D: ADD_W(rom[*memadr],IY); PC++; break;
                    case 0x8E: ADD_W(rom[*memadr],IZ); PC++; break;
                    case 0x8F: ADD_W(rom[*memadr],SP); PC++; break;
                    case 0x90: ADC_W(WA,rom[*memadr]); PC++; break;
                    case 0x91: ADC_W(BC,rom[*memadr]); PC++; break;
                    case 0x92: ADC_W(DE,rom[*memadr]); PC++; break;
                    case 0x93: ADC_W(HL,rom[*memadr]); PC++; break;
                    case 0x94: ADC_W(IX,rom[*memadr]); PC++; break;
                    case 0x95: ADC_W(IY,rom[*memadr]); PC++; break;
                    case 0x96: ADC_W(IZ,rom[*memadr]); PC++; break;
                    case 0x97: ADC_W(SP,rom[*memadr]); PC++; break;
                    case 0x98: ADC_W(rom[*memadr],WA); PC++; break;
                    case 0x99: ADC_W(rom[*memadr],BC); PC++; break;
                    case 0x9A: ADC_W(rom[*memadr],DE); PC++; break;
                    case 0x9B: ADC_W(rom[*memadr],HL); PC++; break;
                    case 0x9C: ADC_W(rom[*memadr],IX); PC++; break;
                    case 0x9D: ADC_W(rom[*memadr],IY); PC++; break;
                    case 0x9E: ADC_W(rom[*memadr],IZ); PC++; break;
                    case 0x9F: ADC_W(rom[*memadr],SP); PC++; break;
                    case 0xA0: SUB_W(WA,rom[*memadr]); PC++; break;
                    case 0xA1: SUB_W(BC,rom[*memadr]); PC++; break;
                    case 0xA2: SUB_W(DE,rom[*memadr]); PC++; break;
                    case 0xA3: SUB_W(HL,rom[*memadr]); PC++; break;
                    case 0xA4: SUB_W(IX,rom[*memadr]); PC++; break;
                    case 0xA5: SUB_W(IY,rom[*memadr]); PC++; break;
                    case 0xA6: SUB_W(IZ,rom[*memadr]); PC++; break;
                    case 0xA7: SUB_W(SP,rom[*memadr]); PC++; break;
                    case 0xA8: SUB_W(rom[*memadr],WA); PC++; break;
                    case 0xA9: SUB_W(rom[*memadr],BC); PC++; break;
                    case 0xAA: SUB_W(rom[*memadr],DE); PC++; break;
                    case 0xAB: SUB_W(rom[*memadr],HL); PC++; break;
                    case 0xAC: SUB_W(rom[*memadr],IX); PC++; break;
                    case 0xAD: SUB_W(rom[*memadr],IY); PC++; break;
                    case 0xAE: SUB_W(rom[*memadr],IZ); PC++; break;
                    case 0xAF: SUB_W(rom[*memadr],SP); PC++; break;
                    case 0xB0: SBC_W(WA,rom[*memadr]); PC++; break;
                    case 0xB1: SBC_W(BC,rom[*memadr]); PC++; break;
                    case 0xB2: SBC_W(DE,rom[*memadr]); PC++; break;
                    case 0xB3: SBC_W(HL,rom[*memadr]); PC++; break;
                    case 0xB4: SBC_W(IX,rom[*memadr]); PC++; break;
                    case 0xB5: SBC_W(IY,rom[*memadr]); PC++; break;
                    case 0xB6: SBC_W(IZ,rom[*memadr]); PC++; break;
                    case 0xB7: SBC_W(SP,rom[*memadr]); PC++; break;
                    case 0xB8: SBC_W(rom[*memadr],WA); PC++; break;
                    case 0xB9: SBC_W(rom[*memadr],BC); PC++; break;
                    case 0xBA: SBC_W(rom[*memadr],DE); PC++; break;
                    case 0xBB: SBC_W(rom[*memadr],HL); PC++; break;
                    case 0xBC: SBC_W(rom[*memadr],IX); PC++; break;
                    case 0xBD: SBC_W(rom[*memadr],IY); PC++; break;
                    case 0xBE: SBC_W(rom[*memadr],IZ); PC++; break;
                    case 0xBF: SBC_W(rom[*memadr],SP); PC++; break;
                    case 0xC0: AND_W(WA,rom[*memadr]); PC++; break;
                    case 0xC1: AND_W(BC,rom[*memadr]); PC++; break;
                    case 0xC2: AND_W(DE,rom[*memadr]); PC++; break;
                    case 0xC3: AND_W(HL,rom[*memadr]); PC++; break;
                    case 0xC4: AND_W(IX,rom[*memadr]); PC++; break;
                    case 0xC5: AND_W(IY,rom[*memadr]); PC++; break;
                    case 0xC6: AND_W(IZ,rom[*memadr]); PC++; break;
                    case 0xC7: AND_W(SP,rom[*memadr]); PC++; break;
                    case 0xC8: AND_W(rom[*memadr],WA); PC++; break;
                    case 0xC9: AND_W(rom[*memadr],BC); PC++; break;
                    case 0xCA: AND_W(rom[*memadr],DE); PC++; break;
                    case 0xCB: AND_W(rom[*memadr],HL); PC++; break;
                    case 0xCC: AND_W(rom[*memadr],IX); PC++; break;
                    case 0xCD: AND_W(rom[*memadr],IY); PC++; break;
                    case 0xCE: AND_W(rom[*memadr],IZ); PC++; break;
                    case 0xCF: AND_W(rom[*memadr],SP); PC++; break;
                    case 0xD0: XOR_W(WA,rom[*memadr]); PC++; break;
                    case 0xD1: XOR_W(BC,rom[*memadr]); PC++; break;
                    case 0xD2: XOR_W(DE,rom[*memadr]); PC++; break;
                    case 0xD3: XOR_W(HL,rom[*memadr]); PC++; break;
                    case 0xD4: XOR_W(IX,rom[*memadr]); PC++; break;
                    case 0xD5: XOR_W(IY,rom[*memadr]); PC++; break;
                    case 0xD6: XOR_W(IZ,rom[*memadr]); PC++; break;
                    case 0xD7: XOR_W(SP,rom[*memadr]); PC++; break;
                    case 0xD8: XOR_W(rom[*memadr],WA); PC++; break;
                    case 0xD9: XOR_W(rom[*memadr],BC); PC++; break;
                    case 0xDA: XOR_W(rom[*memadr],DE); PC++; break;
                    case 0xDB: XOR_W(rom[*memadr],HL); PC++; break;
                    case 0xDC: XOR_W(rom[*memadr],IX); PC++; break;
                    case 0xDD: XOR_W(rom[*memadr],IY); PC++; break;
                    case 0xDE: XOR_W(rom[*memadr],IZ); PC++; break;
                    case 0xDF: XOR_W(rom[*memadr],SP); PC++; break;
                    case 0xE0: OR_W(WA,rom[*memadr]); PC++; break;
                    case 0xE1: OR_W(BC,rom[*memadr]); PC++; break;
                    case 0xE2: OR_W(DE,rom[*memadr]); PC++; break;
                    case 0xE3: OR_W(HL,rom[*memadr]); PC++; break;
                    case 0xE4: OR_W(IX,rom[*memadr]); PC++; break;
                    case 0xE5: OR_W(IY,rom[*memadr]); PC++; break;
                    case 0xE6: OR_W(IZ,rom[*memadr]); PC++; break;
                    case 0xE7: OR_W(SP,rom[*memadr]); PC++; break;
                    case 0xE8: OR_W(rom[*memadr],WA); PC++; break;
                    case 0xE9: OR_W(rom[*memadr],BC); PC++; break;
                    case 0xEA: OR_W(rom[*memadr],DE); PC++; break;
                    case 0xEB: OR_W(rom[*memadr],HL); PC++; break;
                    case 0xEC: OR_W(rom[*memadr],IX); PC++; break;
                    case 0xED: OR_W(rom[*memadr],IY); PC++; break;
                    case 0xEE: OR_W(rom[*memadr],IZ); PC++; break;
                    case 0xEF: OR_W(rom[*memadr],SP); PC++; break;
                    case 0xF0: CP_W(WA,rom[*memadr]); PC++; break;
                    case 0xF1: CP_W(BC,rom[*memadr]); PC++; break;
                    case 0xF2: CP_W(DE,rom[*memadr]); PC++; break;
                    case 0xF3: CP_W(HL,rom[*memadr]); PC++; break;
                    case 0xF4: CP_W(IX,rom[*memadr]); PC++; break;
                    case 0xF5: CP_W(IY,rom[*memadr]); PC++; break;
                    case 0xF6: CP_W(IZ,rom[*memadr]); PC++; break;
                    case 0xF7: CP_W(SP,rom[*memadr]); PC++; break;
                    case 0xF8: CP_W(rom[*memadr],WA); PC++; break;
                    case 0xF9: CP_W(rom[*memadr],BC); PC++; break;
                    case 0xFA: CP_W(rom[*memadr],DE); PC++; break;
                    case 0xFB: CP_W(rom[*memadr],HL); PC++; break;
                    case 0xFC: CP_W(rom[*memadr],IX); PC++; break;
                    case 0xFD: CP_W(rom[*memadr],IY); PC++; break;
                    case 0xFE: CP_W(rom[*memadr],IZ); PC++; break;
                    case 0xFF: CP_W(rom[*memadr],SP); PC++; break;
                } break;

            case 2: /* src.L */
                switch (rom[PC]) {
                    case 0x20: LD_R32_MEM(XWA,*memadr); PC++; break;
                    case 0x21: LD_R32_MEM(XBC,*memadr); PC++; break;
                    case 0x22: LD_R32_MEM(XDE,*memadr); PC++; break;
                    case 0x23: LD_R32_MEM(XHL,*memadr); PC++; break;
                    case 0x24: LD_R32_MEM(XIX,*memadr); PC++; break;
                    case 0x25: LD_R32_MEM(XIY,*memadr); PC++; break;
                    case 0x26: LD_R32_MEM(XIZ,*memadr); PC++; break;
                    case 0x27: LD_R32_MEM(XSP,*memadr); PC++; break;

                    case 0x80: ADD_L(XWA,rom[*memadr]); PC++; break;
                    case 0x81: ADD_L(XBC,rom[*memadr]); PC++; break;
                    case 0x82: ADD_L(XDE,rom[*memadr]); PC++; break;
                    case 0x83: ADD_L(XHL,rom[*memadr]); PC++; break;
                    case 0x84: ADD_L(XIX,rom[*memadr]); PC++; break;
                    case 0x85: ADD_L(XIY,rom[*memadr]); PC++; break;
                    case 0x86: ADD_L(XIZ,rom[*memadr]); PC++; break;
                    case 0x87: ADD_L(XSP,rom[*memadr]); PC++; break;
                    case 0x88: ADD_L(rom[*memadr],XWA); PC++; break;
                    case 0x89: ADD_L(rom[*memadr],XBC); PC++; break;
                    case 0x8A: ADD_L(rom[*memadr],XDE); PC++; break;
                    case 0x8B: ADD_L(rom[*memadr],XHL); PC++; break;
                    case 0x8C: ADD_L(rom[*memadr],XIX); PC++; break;
                    case 0x8D: ADD_L(rom[*memadr],XIY); PC++; break;
                    case 0x8E: ADD_L(rom[*memadr],XIZ); PC++; break;
                    case 0x8F: ADD_L(rom[*memadr],XSP); PC++; break;
                    case 0x90: ADC_L(XWA,rom[*memadr]); PC++; break;
                    case 0x91: ADC_L(XBC,rom[*memadr]); PC++; break;
                    case 0x92: ADC_L(XDE,rom[*memadr]); PC++; break;
                    case 0x93: ADC_L(XHL,rom[*memadr]); PC++; break;
                    case 0x94: ADC_L(XIX,rom[*memadr]); PC++; break;
                    case 0x95: ADC_L(XIY,rom[*memadr]); PC++; break;
                    case 0x96: ADC_L(XIZ,rom[*memadr]); PC++; break;
                    case 0x97: ADC_L(XSP,rom[*memadr]); PC++; break;
                    case 0x98: ADC_L(rom[*memadr],XWA); PC++; break;
                    case 0x99: ADC_L(rom[*memadr],XBC); PC++; break;
                    case 0x9A: ADC_L(rom[*memadr],XDE); PC++; break;
                    case 0x9B: ADC_L(rom[*memadr],XHL); PC++; break;
                    case 0x9C: ADC_L(rom[*memadr],XIX); PC++; break;
                    case 0x9D: ADC_L(rom[*memadr],XIY); PC++; break;
                    case 0x9E: ADC_L(rom[*memadr],XIZ); PC++; break;
                    case 0x9F: ADC_L(rom[*memadr],XSP); PC++; break;
                    case 0xA0: SUB_L(XWA,rom[*memadr]); PC++; break;
                    case 0xA1: SUB_L(XBC,rom[*memadr]); PC++; break;
                    case 0xA2: SUB_L(XDE,rom[*memadr]); PC++; break;
                    case 0xA3: SUB_L(XHL,rom[*memadr]); PC++; break;
                    case 0xA4: SUB_L(XIX,rom[*memadr]); PC++; break;
                    case 0xA5: SUB_L(XIY,rom[*memadr]); PC++; break;
                    case 0xA6: SUB_L(XIZ,rom[*memadr]); PC++; break;
                    case 0xA7: SUB_L(XSP,rom[*memadr]); PC++; break;
                    case 0xA8: SUB_L(rom[*memadr],XWA); PC++; break;
                    case 0xA9: SUB_L(rom[*memadr],XBC); PC++; break;
                    case 0xAA: SUB_L(rom[*memadr],XDE); PC++; break;
                    case 0xAB: SUB_L(rom[*memadr],XHL); PC++; break;
                    case 0xAC: SUB_L(rom[*memadr],XIX); PC++; break;
                    case 0xAD: SUB_L(rom[*memadr],XIY); PC++; break;
                    case 0xAE: SUB_L(rom[*memadr],XIZ); PC++; break;
                    case 0xAF: SUB_L(rom[*memadr],XSP); PC++; break;
                    case 0xB0: SBC_L(XWA,rom[*memadr]); PC++; break;
                    case 0xB1: SBC_L(XBC,rom[*memadr]); PC++; break;
                    case 0xB2: SBC_L(XDE,rom[*memadr]); PC++; break;
                    case 0xB3: SBC_L(XHL,rom[*memadr]); PC++; break;
                    case 0xB4: SBC_L(XIX,rom[*memadr]); PC++; break;
                    case 0xB5: SBC_L(XIY,rom[*memadr]); PC++; break;
                    case 0xB6: SBC_L(XIZ,rom[*memadr]); PC++; break;
                    case 0xB7: SBC_L(XSP,rom[*memadr]); PC++; break;
                    case 0xB8: SBC_L(rom[*memadr],XWA); PC++; break;
                    case 0xB9: SBC_L(rom[*memadr],XBC); PC++; break;
                    case 0xBA: SBC_L(rom[*memadr],XDE); PC++; break;
                    case 0xBB: SBC_L(rom[*memadr],XHL); PC++; break;
                    case 0xBC: SBC_L(rom[*memadr],XIX); PC++; break;
                    case 0xBD: SBC_L(rom[*memadr],XIY); PC++; break;
                    case 0xBE: SBC_L(rom[*memadr],XIZ); PC++; break;
                    case 0xBF: SBC_L(rom[*memadr],XSP); PC++; break;
                    case 0xC0: AND_L(XWA,rom[*memadr]); PC++; break;
                    case 0xC1: AND_L(XBC,rom[*memadr]); PC++; break;
                    case 0xC2: AND_L(XDE,rom[*memadr]); PC++; break;
                    case 0xC3: AND_L(XHL,rom[*memadr]); PC++; break;
                    case 0xC4: AND_L(XIX,rom[*memadr]); PC++; break;
                    case 0xC5: AND_L(XIY,rom[*memadr]); PC++; break;
                    case 0xC6: AND_L(XIZ,rom[*memadr]); PC++; break;
                    case 0xC7: AND_L(XSP,rom[*memadr]); PC++; break;
                    case 0xC8: AND_L(rom[*memadr],XWA); PC++; break;
                    case 0xC9: AND_L(rom[*memadr],XBC); PC++; break;
                    case 0xCA: AND_L(rom[*memadr],XDE); PC++; break;
                    case 0xCB: AND_L(rom[*memadr],XHL); PC++; break;
                    case 0xCC: AND_L(rom[*memadr],XIX); PC++; break;
                    case 0xCD: AND_L(rom[*memadr],XIY); PC++; break;
                    case 0xCE: AND_L(rom[*memadr],XIZ); PC++; break;
                    case 0xCF: AND_L(rom[*memadr],XSP); PC++; break;
                    case 0xD0: XOR_L(XWA,rom[*memadr]); PC++; break;
                    case 0xD1: XOR_L(XBC,rom[*memadr]); PC++; break;
                    case 0xD2: XOR_L(XDE,rom[*memadr]); PC++; break;
                    case 0xD3: XOR_L(XHL,rom[*memadr]); PC++; break;
                    case 0xD4: XOR_L(XIX,rom[*memadr]); PC++; break;
                    case 0xD5: XOR_L(XIY,rom[*memadr]); PC++; break;
                    case 0xD6: XOR_L(XIZ,rom[*memadr]); PC++; break;
                    case 0xD7: XOR_L(XSP,rom[*memadr]); PC++; break;
                    case 0xD8: XOR_L(rom[*memadr],XWA); PC++; break;
                    case 0xD9: XOR_L(rom[*memadr],XBC); PC++; break;
                    case 0xDA: XOR_L(rom[*memadr],XDE); PC++; break;
                    case 0xDB: XOR_L(rom[*memadr],XHL); PC++; break;
                    case 0xDC: XOR_L(rom[*memadr],XIX); PC++; break;
                    case 0xDD: XOR_L(rom[*memadr],XIY); PC++; break;
                    case 0xDE: XOR_L(rom[*memadr],XIZ); PC++; break;
                    case 0xDF: XOR_L(rom[*memadr],XSP); PC++; break;
                    case 0xE0: OR_L(XWA,rom[*memadr]); PC++; break;
                    case 0xE1: OR_L(XBC,rom[*memadr]); PC++; break;
                    case 0xE2: OR_L(XDE,rom[*memadr]); PC++; break;
                    case 0xE3: OR_L(XHL,rom[*memadr]); PC++; break;
                    case 0xE4: OR_L(XIX,rom[*memadr]); PC++; break;
                    case 0xE5: OR_L(XIY,rom[*memadr]); PC++; break;
                    case 0xE6: OR_L(XIZ,rom[*memadr]); PC++; break;
                    case 0xE7: OR_L(XSP,rom[*memadr]); PC++; break;
                    case 0xE8: OR_L(rom[*memadr],XWA); PC++; break;
                    case 0xE9: OR_L(rom[*memadr],XBC); PC++; break;
                    case 0xEA: OR_L(rom[*memadr],XDE); PC++; break;
                    case 0xEB: OR_L(rom[*memadr],XHL); PC++; break;
                    case 0xEC: OR_L(rom[*memadr],XIX); PC++; break;
                    case 0xED: OR_L(rom[*memadr],XIY); PC++; break;
                    case 0xEE: OR_L(rom[*memadr],XIZ); PC++; break;
                    case 0xEF: OR_L(rom[*memadr],XSP); PC++; break;
                    case 0xF0: CP_L(XWA,rom[*memadr]); PC++; break;
                    case 0xF1: CP_L(XBC,rom[*memadr]); PC++; break;
                    case 0xF2: CP_L(XDE,rom[*memadr]); PC++; break;
                    case 0xF3: CP_L(XHL,rom[*memadr]); PC++; break;
                    case 0xF4: CP_L(XIX,rom[*memadr]); PC++; break;
                    case 0xF5: CP_L(XIY,rom[*memadr]); PC++; break;
                    case 0xF6: CP_L(XIZ,rom[*memadr]); PC++; break;
                    case 0xF7: CP_L(XSP,rom[*memadr]); PC++; break;
                    case 0xF8: CP_L(rom[*memadr],XWA); PC++; break;
                    case 0xF9: CP_L(rom[*memadr],XBC); PC++; break;
                    case 0xFA: CP_L(rom[*memadr],XDE); PC++; break;
                    case 0xFB: CP_L(rom[*memadr],XHL); PC++; break;
                    case 0xFC: CP_L(rom[*memadr],XIX); PC++; break;
                    case 0xFD: CP_L(rom[*memadr],XIY); PC++; break;
                    case 0xFE: CP_L(rom[*memadr],XIZ); PC++; break;
                    case 0xFF: CP_L(rom[*memadr],XSP); PC++; break;
                } break;

            case 3: /* dst */
                switch (rom[PC]) {
                    case 0x00: rom[*memadr]=rom[PC+1]; PC+=2; break;

                    case 0x02: rom[*memadr]=rom[PC+1]; rom[*memadr+1] = rom[PC+2]; PC+=3; break;

                    case 0x30: XWA=*memadr; PC++; break;
                    case 0x31: XBC=*memadr; PC++; break;
                    case 0x32: XDE=*memadr; PC++; break;
                    case 0x33: XHL=*memadr; PC++; break;
                    case 0x34: XIX=*memadr; PC++; break;
                    case 0x35: XIY=*memadr; PC++; break;
                    case 0x36: XIZ=*memadr; PC++; break;
                    case 0x37: XSP=*memadr; PC++; break;

                    case 0x40: rom[*memadr]=W; PC++; break;
                    case 0x41: rom[*memadr]=A; PC++; break;
                    case 0x42: rom[*memadr]=B; PC++; break;
                    case 0x43: rom[*memadr]=C; PC++; break;
                    case 0x44: rom[*memadr]=D; PC++; break;
                    case 0x45: rom[*memadr]=E; PC++; break;
                    case 0x46: rom[*memadr]=H; PC++; break;
                    case 0x47: rom[*memadr]=L; PC++; break;

                    case 0x50: LD_MEM_R16(*memadr,WA); PC++; break;
                    case 0x51: LD_MEM_R16(*memadr,BC); PC++; break;
                    case 0x52: LD_MEM_R16(*memadr,DE); PC++; break;
                    case 0x53: LD_MEM_R16(*memadr,HL); PC++; break;
                    case 0x54: LD_MEM_R16(*memadr,IX); PC++; break;
                    case 0x55: LD_MEM_R16(*memadr,IY); PC++; break;
                    case 0x56: LD_MEM_R16(*memadr,IZ); PC++; break;
                    case 0x57: LD_MEM_R16(*memadr,SP); PC++; break;

                    case 0x60: LD_MEM_R32(*memadr,XWA); PC++; break;
                    case 0x61: LD_MEM_R32(*memadr,XBC); PC++; break;
                    case 0x62: LD_MEM_R32(*memadr,XDE); PC++; break;
                    case 0x63: LD_MEM_R32(*memadr,XHL); PC++; break;
                    case 0x64: LD_MEM_R32(*memadr,XIX); PC++; break;
                    case 0x65: LD_MEM_R32(*memadr,XIY); PC++; break;
                    case 0x66: LD_MEM_R32(*memadr,XIZ); PC++; break;
                    case 0x67: LD_MEM_R32(*memadr,XSP); PC++; break;

                    case 0xA0: rom[*memadr]=rom[*memadr]& fC; PC++; break;
                    case 0xA1: rom[*memadr]=rom[*memadr]&(fC<<1); PC++; break;
                    case 0xA2: rom[*memadr]=rom[*memadr]&(fC<<2); PC++; break;
                    case 0xA3: rom[*memadr]=rom[*memadr]&(fC<<3); PC++; break;
                    case 0xA4: rom[*memadr]=rom[*memadr]&(fC<<4); PC++; break;
                    case 0xA5: rom[*memadr]=rom[*memadr]&(fC<<5); PC++; break;
                    case 0xA6: rom[*memadr]=rom[*memadr]&(fC<<6); PC++; break;
                    case 0xA7: rom[*memadr]=rom[*memadr]&(fC<<7); PC++; break;

                    case 0xB0: rom[*memadr]=RBIT(rom[*memadr],0); PC++; break;
                    case 0xB1: rom[*memadr]=RBIT(rom[*memadr],1); PC++; break;
                    case 0xB2: rom[*memadr]=RBIT(rom[*memadr],2); PC++; break;
                    case 0xB3: rom[*memadr]=RBIT(rom[*memadr],3); PC++; break;
                    case 0xB4: rom[*memadr]=RBIT(rom[*memadr],4); PC++; break;
                    case 0xB5: rom[*memadr]=RBIT(rom[*memadr],5); PC++; break;
                    case 0xB6: rom[*memadr]=RBIT(rom[*memadr],6); PC++; break;
                    case 0xB7: rom[*memadr]=RBIT(rom[*memadr],7); PC++; break;
                    case 0xB8: rom[*memadr]=SBIT(rom[*memadr],0,0x1); PC++; break;
                    case 0xB9: rom[*memadr]=SBIT(rom[*memadr],1,0x2); PC++; break;
                    case 0xBA: rom[*memadr]=SBIT(rom[*memadr],2,0x4); PC++; break;
                    case 0xBB: rom[*memadr]=SBIT(rom[*memadr],3,0x8); PC++; break;
                    case 0xBC: rom[*memadr]=SBIT(rom[*memadr],4,0x10); PC++; break;
                    case 0xBD: rom[*memadr]=SBIT(rom[*memadr],5,0x20); PC++; break;
                    case 0xBE: rom[*memadr]=SBIT(rom[*memadr],6,0x40); PC++; break;
                    case 0xBF: rom[*memadr]=SBIT(rom[*memadr],7,0x80); PC++; break;

                    case 0xC8: BIT_MEM(*memadr,0x1); PC++; break;
                    case 0xC9: BIT_MEM(*memadr,0x2); PC++; break;
                    case 0xCA: BIT_MEM(*memadr,0x4); PC++; break;
                    case 0xCB: BIT_MEM(*memadr,0x8); PC++; break;
                    case 0xCC: BIT_MEM(*memadr,0x10); PC++; break;
                    case 0xCD: BIT_MEM(*memadr,0x20); PC++; break;
                    case 0xCE: BIT_MEM(*memadr,0x40); PC++; break;
                    case 0xCF: BIT_MEM(*memadr,0x80); PC++; break;

                    case 0xD6: if (fZ==1) PC=*memadr; else PC++; break;
                    case 0xD7: if (fC==1) PC=*memadr; else PC++; break;
                    case 0xD8: PC=*memadr; break;

                    case 0xDE: if (fZ==0) PC=*memadr; else PC++; break;
                    case 0xDF: if (fC==0) PC=*memadr; else PC++; break;

                    case 0xE6: /* CALL Z, mem */
                        if (fZ==1) {
                            JmpPC=*memadr;
                            XSP-=4;
                            TO4X8=PC+1;
                            rom[XSP]=_b0;
                            rom[XSP+1]=_b1;
                            rom[XSP+2]=_b2;
                            rom[XSP+3]=0x00;
                            PC=JmpPC;
                        } else {
                            PC++;
                        } break;                 

                    case 0xE8: JmpPC=*memadr; XSP-=4; TO4X8=PC+1; rom[XSP]=_b0;  rom[XSP+1]=_b1; rom[XSP+2]=_b2; rom[XSP+3]=0x00; PC=JmpPC; break;

                    case 0xEE: /* CALL NZ, mem */
                        if (fZ==0) {
                            JmpPC=*memadr;
                            XSP-=4;
                            TO4X8=PC+1;
                            rom[XSP]=_b0;
                            rom[XSP+1]=_b1;
                            rom[XSP+2]=_b2;
                            rom[XSP+3]=0x00;
                            PC=JmpPC;
                        } else {
                            PC++;
                        } break;                 

                    case 0xEF: /* CALL NC, mem */
                        if (fC==0) {
                            JmpPC=*memadr;
                            XSP-=4;
                            TO4X8=PC+1;
                            rom[XSP]=_b0;
                            rom[XSP+1]=_b1;
                            rom[XSP+2]=_b2;
                            rom[XSP+3]=0x00;
                            PC=JmpPC;
                        } else {
                            PC++;
                        } break;                 

                    case 0xF6: /* RET Z */
                        if (byte1==0xB0) {
                            if (fZ) {
                                PC=(rom[XSP+2]<<16)+(rom[XSP+1]<<8)+rom[XSP];
                                XSP+=4;
                            } else {
                                PC++;
                            }
                        } break;

                    case 0xF7: /* RET C */
                        if (byte1==0xB0) {
                            if (fC) { PC=(rom[XSP+2]<<16)+(rom[XSP+1]<<8)+rom[XSP]; XSP+=4; } else { PC++; }
                        } break;

                    case 0xFE: /* RET NZ */
                        if (byte1==0xB0) {
                            if (!fZ) { PC=(rom[XSP+2]<<16)+(rom[XSP+1]<<8)+rom[XSP]; XSP+=4; } else { PC++; }
                        } break;

                    case 0xFF: /* RET NC */
                        if (byte1==0xB0) {
                            if (!fC) { PC=(rom[XSP+2]<<16)+(rom[XSP+1]<<8)+rom[XSP]; XSP+=4; } else { PC++; }
                        } break;

                } break;
        }


        /* does post increment if tmpadj is nonzero    */
        /* (a post increment instr was just processed) */

        if (tmpadj)
            *xr32[r32reg]+=tmpadj;


    } /* if ( !((madr.hi==1) && (madr.lo>=0x8)) ) */

    else if ((madr.type==0) && (madr.lo==0x7)) { /* reg.B r */
        switch (rom[PC+2]) {
            case 0x03: *xr8[rom[PC+1]]=rom[PC+2]; PC+=3; break;

            case 0x1C: /* DJNZ xr8, d8 */
                tmp8s=rom[PC+3];
                if (*xr8[rom[PC+1]]!=0) {
                    *xr8[rom[PC+1]]=*xr8[rom[PC+1]]-1;
                    PC+=3+tmp8s;
                } else {
                    PC+=3;
                } break;

            case 0x80: ADD_B(W,*xr8[rom[PC+1]]); PC+=3; break;
            case 0x81: ADD_B(A,*xr8[rom[PC+1]]); PC+=3; break;
            case 0x82: ADD_B(B,*xr8[rom[PC+1]]); PC+=3; break;
            case 0x83: ADD_B(C,*xr8[rom[PC+1]]); PC+=3; break;
            case 0x84: ADD_B(D,*xr8[rom[PC+1]]); PC+=3; break;
            case 0x85: ADD_B(E,*xr8[rom[PC+1]]); PC+=3; break;
            case 0x86: ADD_B(H,*xr8[rom[PC+1]]); PC+=3; break;
            case 0x87: ADD_B(L,*xr8[rom[PC+1]]); PC+=3; break;

            case 0x88: W=*xr8[rom[PC+1]]; PC+=3; break;
            case 0x89: A=*xr8[rom[PC+1]]; PC+=3; break;
            case 0x8A: B=*xr8[rom[PC+1]]; PC+=3; break;
            case 0x8B: C=*xr8[rom[PC+1]]; PC+=3; break;
            case 0x8C: D=*xr8[rom[PC+1]]; PC+=3; break;
            case 0x8D: E=*xr8[rom[PC+1]]; PC+=3; break;
            case 0x8E: H=*xr8[rom[PC+1]]; PC+=3; break;
            case 0x8F: L=*xr8[rom[PC+1]]; PC+=3; break;

            case 0x98: *xr8[rom[PC+1]]=W; PC+=3; break;
            case 0x99: *xr8[rom[PC+1]]=A; PC+=3; break;
            case 0x9A: *xr8[rom[PC+1]]=B; PC+=3; break;
            case 0x9B: *xr8[rom[PC+1]]=C; PC+=3; break;
            case 0x9C: *xr8[rom[PC+1]]=D; PC+=3; break;
            case 0x9D: *xr8[rom[PC+1]]=E; PC+=3; break;
            case 0x9E: *xr8[rom[PC+1]]=H; PC+=3; break;
            case 0x9F: *xr8[rom[PC+1]]=L; PC+=3; break;

            case 0xA8: *xr8[rom[PC+1]]=0; PC+=3; break;
            case 0xA9: *xr8[rom[PC+1]]=1; PC+=3; break;
            case 0xAA: *xr8[rom[PC+1]]=2; PC+=3; break;
            case 0xAB: *xr8[rom[PC+1]]=3; PC+=3; break;
            case 0xAC: *xr8[rom[PC+1]]=4; PC+=3; break;
            case 0xAD: *xr8[rom[PC+1]]=5; PC+=3; break;
            case 0xAE: *xr8[rom[PC+1]]=6; PC+=3; break;
            case 0xAF: *xr8[rom[PC+1]]=7; PC+=3; break;

            case 0xC8: ADD_B(*xr8[rom[PC+1]],rom[PC+3]); PC+=4; break;

            case 0xCA: SUB_B(*xr8[rom[PC+1]],rom[PC+3]); PC+=4; break;

            case 0xCC: AND_B(*xr8[rom[PC+1]],rom[PC+3]); PC+=4; break;
            case 0xCD: XOR_B(*xr8[rom[PC+1]],rom[PC+3]); PC+=4; break;
            case 0xCE: OR_B(*xr8[rom[PC+1]],rom[PC+3]); PC+=4; break;
            case 0xCF: CP_B(*xr8[rom[PC+1]],rom[PC+3]); PC+=4; break;

            case 0xD8: CP_B(*xr8[rom[PC+1]],0); PC+=3; break;
            case 0xD9: CP_B(*xr8[rom[PC+1]],1); PC+=3; break;
            case 0xDA: CP_B(*xr8[rom[PC+1]],2); PC+=3; break;
            case 0xDB: CP_B(*xr8[rom[PC+1]],3); PC+=3; break;
            case 0xDC: CP_B(*xr8[rom[PC+1]],4); PC+=3; break;
            case 0xDD: CP_B(*xr8[rom[PC+1]],5); PC+=3; break;
            case 0xDE: CP_B(*xr8[rom[PC+1]],6); PC+=3; break;
            case 0xDF: CP_B(*xr8[rom[PC+1]],7); PC+=3; break;
            case 0xE0: OR_B(W,*xr8[rom[PC+1]]); PC+=3; break;
            case 0xE1: OR_B(A,*xr8[rom[PC+1]]); PC+=3; break;
            case 0xE2: OR_B(B,*xr8[rom[PC+1]]); PC+=3; break;
            case 0xE3: OR_B(C,*xr8[rom[PC+1]]); PC+=3; break;
            case 0xE4: OR_B(D,*xr8[rom[PC+1]]); PC+=3; break;
            case 0xE5: OR_B(E,*xr8[rom[PC+1]]); PC+=3; break;
            case 0xE6: OR_B(H,*xr8[rom[PC+1]]); PC+=3; break;
            case 0xE7: OR_B(L,*xr8[rom[PC+1]]); PC+=3; break;

            case 0xF0: CP_B(W,*xr8[rom[PC+1]]); PC+=3; break;
            case 0xF1: CP_B(A,*xr8[rom[PC+1]]); PC+=3; break;
            case 0xF2: CP_B(B,*xr8[rom[PC+1]]); PC+=3; break;
            case 0xF3: CP_B(C,*xr8[rom[PC+1]]); PC+=3; break;
            case 0xF4: CP_B(D,*xr8[rom[PC+1]]); PC+=3; break;
            case 0xF5: CP_B(E,*xr8[rom[PC+1]]); PC+=3; break;
            case 0xF6: CP_B(H,*xr8[rom[PC+1]]); PC+=3; break;
            case 0xF7: CP_B(L,*xr8[rom[PC+1]]); PC+=3; break;
            
        }
    } /* reg.B r */

    else if ((madr.type==1) && (madr.lo==0x7)) { /* reg.W r */
        switch (rom[PC+2]) {
            case 0x88: WA=*xr16[rom[PC+1]/2]; PC+=3; break;
            case 0x89: BC=*xr16[rom[PC+1]/2]; PC+=3; break;
            case 0x8A: DE=*xr16[rom[PC+1]/2]; PC+=3; break;
            case 0x8B: HL=*xr16[rom[PC+1]/2]; PC+=3; break;
            case 0x8C: IX=*xr16[rom[PC+1]/2]; PC+=3; break;
            case 0x8D: IY=*xr16[rom[PC+1]/2]; PC+=3; break;
            case 0x8E: IZ=*xr16[rom[PC+1]/2]; PC+=3; break;
            case 0x8F: SP=*xr16[rom[PC+1]/2]; PC+=3; break;

            case 0x98: *xr16[rom[PC+1]/2]=WA; PC+=3; break;
            case 0x99: *xr16[rom[PC+1]/2]=BC; PC+=3; break;
            case 0x9A: *xr16[rom[PC+1]/2]=DE; PC+=3; break;
            case 0x9B: *xr16[rom[PC+1]/2]=HL; PC+=3; break;
            case 0x9C: *xr16[rom[PC+1]/2]=IX; PC+=3; break;
            case 0x9D: *xr16[rom[PC+1]/2]=IY; PC+=3; break;
            case 0x9E: *xr16[rom[PC+1]/2]=IZ; PC+=3; break;
            case 0x9F: *xr16[rom[PC+1]/2]=SP; PC+=3; break;

            case 0xA8: *xr16[rom[PC+1]/2]=0; PC+=3; break;
            case 0xA9: *xr16[rom[PC+1]/2]=1; PC+=3; break;
            case 0xAA: *xr16[rom[PC+1]/2]=2; PC+=3; break;
            case 0xAB: *xr16[rom[PC+1]/2]=3; PC+=3; break;
            case 0xAC: *xr16[rom[PC+1]/2]=4; PC+=3; break;
            case 0xAD: *xr16[rom[PC+1]/2]=5; PC+=3; break;
            case 0xAE: *xr16[rom[PC+1]/2]=6; PC+=3; break;
            case 0xAF: *xr16[rom[PC+1]/2]=7; PC+=3; break;

            case 0xCF: CP_W(*xr16[rom[PC+1]/2],(rom[PC+3]<<8)+rom[PC+2]); PC+=5; break;

            case 0xD8: CP_W(*xr16[rom[PC+1]/2],0); PC+=3; break;
            case 0xD9: CP_W(*xr16[rom[PC+1]/2],1); PC+=3; break;
            case 0xDA: CP_W(*xr16[rom[PC+1]/2],2); PC+=3; break;
            case 0xDB: CP_W(*xr16[rom[PC+1]/2],3); PC+=3; break;
            case 0xDC: CP_W(*xr16[rom[PC+1]/2],4); PC+=3; break;
            case 0xDD: CP_W(*xr16[rom[PC+1]/2],5); PC+=3; break;
            case 0xDE: CP_W(*xr16[rom[PC+1]/2],6); PC+=3; break;
            case 0xDF: CP_W(*xr16[rom[PC+1]/2],7); PC+=3; break;

        }            

    } /* reg.W r */

    else if ((madr.type==2) && (madr.lo==0x7)) { /* reg.L r */
        switch (rom[PC+2]) {
            case 0x03: /* LD xr32, d32 */
                tmp32  = (rom[PC+6]<<24)+(rom[PC+5]<<16)+(rom[PC+4]<<8)+rom[PC+3];
                *xr32[rom[PC+1]/4]=tmp32;
                PC+=7; break;
		
            case 0x98: *xr32[rom[PC+1]/4]=XWA; PC+=3; break;
            case 0x99: *xr32[rom[PC+1]/4]=XBC; PC+=3; break;
            case 0x9A: *xr32[rom[PC+1]/4]=XDE; PC+=3; break;
            case 0x9B: *xr32[rom[PC+1]/4]=XHL; PC+=3; break;
            case 0x9C: *xr32[rom[PC+1]/4]=XIX; PC+=3; break;
            case 0x9D: *xr32[rom[PC+1]/4]=XIY; PC+=3; break;
            case 0x9E: *xr32[rom[PC+1]/4]=XIZ; PC+=3; break;
            case 0x9F: *xr32[rom[PC+1]/4]=XSP; PC+=3; break;
        }
    } /* reg.L r */

    else if (madr.type==0) { /* reg.B */
        switch(rom[PC+1]) {
            case 0x04: XSP--; rom[XSP]=*r8p[radr.reg]; PC+=2; break;
            case 0x05: *r8p[radr.reg]=rom[XSP]; XSP++; PC+=2; break;

            case 0x08: /* MUL r8, d8 */
                switch (radr.reg) {
                    case 0: tmp16=A*rom[PC+2]; WA=tmp16; break;
                    case 1: tmp16=C*rom[PC+2]; BC=tmp16; break;
                    case 2: tmp16=E*rom[PC+2]; DE=tmp16; break;
                    case 3: tmp16=L*rom[PC+2]; HL=tmp16; break;
                    case 4: tmp16=Reg_XIX.b[0]*rom[PC+2]; IX=tmp16; break;
                    case 5: tmp16=Reg_XIY.b[0]*rom[PC+2]; IY=tmp16; break;
                    case 6: tmp16=Reg_XIZ.b[0]*rom[PC+2]; IZ=tmp16; break;
                    case 7: tmp16=Reg_XSP.b[0]*rom[PC+2]; SP=tmp16; break;
                } PC+=3; break;

            case 0x1C: tmp8s=rom[PC+2]; if (*r8p[radr.reg]!=0) { *r8p[radr.reg]=*r8p[radr.reg]-1; PC+=3+tmp8s; } else {  PC+=3; } break;

            case 0x33: /* BIT #4,r8 */
                switch (rom[PC+2]) {
                    case  0: if (*r8p[radr.reg]&   0x1) fZ=0; else fZ=1; break;
                    case  1: if (*r8p[radr.reg]&   0x2) fZ=0; else fZ=1; break;
                    case  2: if (*r8p[radr.reg]&   0x4) fZ=0; else fZ=1; break;
                    case  3: if (*r8p[radr.reg]&   0x8) fZ=0; else fZ=1; break;
                    case  4: if (*r8p[radr.reg]&  0x10) fZ=0; else fZ=1; break;
                    case  5: if (*r8p[radr.reg]&  0x20) fZ=0; else fZ=1; break;
                    case  6: if (*r8p[radr.reg]&  0x40) fZ=0; else fZ=1; break;
                    case  7: if (*r8p[radr.reg]&  0x80) fZ=0; else fZ=1; break;
                } fH=1; fN=0; PC+=3; break;

            case 0x60: INC_B(*r8p[radr.reg],8); PC+=2; break;
            case 0x61: INC_B(*r8p[radr.reg],1); PC+=2; break;
            case 0x62: INC_B(*r8p[radr.reg],2); PC+=2; break;
            case 0x63: INC_B(*r8p[radr.reg],3); PC+=2; break;
            case 0x64: INC_B(*r8p[radr.reg],4); PC+=2; break;
            case 0x65: INC_B(*r8p[radr.reg],5); PC+=2; break;
            case 0x66: INC_B(*r8p[radr.reg],6); PC+=2; break;
            case 0x67: INC_B(*r8p[radr.reg],7); PC+=2; break;

            case 0x7E: if (fZ == 0) *r8p[radr.reg]=1; else *r8p[radr.reg]=0; PC+=2; break;
            case 0x7F: if (fC == 0) *r8p[radr.reg]=1; else *r8p[radr.reg]=0; PC+=2; break;
            case 0x80: ADD_B(W,*r8p[radr.reg]); PC+=2; break;
            case 0x81: ADD_B(A,*r8p[radr.reg]); PC+=2; break;
            case 0x82: ADD_B(B,*r8p[radr.reg]); PC+=2; break;
            case 0x83: ADD_B(C,*r8p[radr.reg]); PC+=2; break;
            case 0x84: ADD_B(D,*r8p[radr.reg]); PC+=2; break;
            case 0x85: ADD_B(E,*r8p[radr.reg]); PC+=2; break;
            case 0x86: ADD_B(H,*r8p[radr.reg]); PC+=2; break;
            case 0x87: ADD_B(L,*r8p[radr.reg]); PC+=2; break;
            case 0x88: W=*r8p[radr.reg]; PC+=2; break;
            case 0x89: A=*r8p[radr.reg]; PC+=2; break;
            case 0x8A: B=*r8p[radr.reg]; PC+=2; break;
            case 0x8B: C=*r8p[radr.reg]; PC+=2; break;
            case 0x8C: D=*r8p[radr.reg]; PC+=2; break;
            case 0x8D: E=*r8p[radr.reg]; PC+=2; break;
            case 0x8E: H=*r8p[radr.reg]; PC+=2; break;
            case 0x8F: L=*r8p[radr.reg]; PC+=2; break;

            case 0xA0: SUB_B(W,*r8p[radr.reg]); PC+=2; break;
            case 0xA1: SUB_B(A,*r8p[radr.reg]); PC+=2; break;
            case 0xA2: SUB_B(B,*r8p[radr.reg]); PC+=2; break;
            case 0xA3: SUB_B(C,*r8p[radr.reg]); PC+=2; break;
            case 0xA4: SUB_B(D,*r8p[radr.reg]); PC+=2; break;
            case 0xA5: SUB_B(E,*r8p[radr.reg]); PC+=2; break;
            case 0xA6: SUB_B(H,*r8p[radr.reg]); PC+=2; break;
            case 0xA7: SUB_B(L,*r8p[radr.reg]); PC+=2; break;

            case 0xC0: AND_B(W,*r8p[radr.reg]); PC+=2; break;
            case 0xC1: AND_B(A,*r8p[radr.reg]); PC+=2; break;
            case 0xC2: AND_B(B,*r8p[radr.reg]); PC+=2; break;
            case 0xC3: AND_B(C,*r8p[radr.reg]); PC+=2; break;
            case 0xC4: AND_B(D,*r8p[radr.reg]); PC+=2; break;
            case 0xC5: AND_B(E,*r8p[radr.reg]); PC+=2; break;
            case 0xC6: AND_B(H,*r8p[radr.reg]); PC+=2; break;
            case 0xC7: AND_B(L,*r8p[radr.reg]); PC+=2; break;
            case 0xC8: ADD_B(*r8p[radr.reg],rom[PC+2]); PC+=3; break;
            case 0xC9: ADC_B(*r8p[radr.reg],rom[PC+2]); PC+=3; break;
            case 0xCA: SUB_B(*r8p[radr.reg],rom[PC+2]); PC+=3; break;

            case 0xCC: AND_B(*r8p[radr.reg],rom[PC+2]); PC+=3; break;
            case 0xCD: XOR_B(*r8p[radr.reg],rom[PC+2]); PC+=3; break;
            case 0xCE: OR_B(*r8p[radr.reg],rom[PC+2]); PC+=3; break;
            case 0xCF: CP_B(*r8p[radr.reg],rom[PC+2]); PC+=3; break;
            case 0xD0: XOR_B(W,*r8p[radr.reg]); PC+=2; break;
            case 0xD1: XOR_B(A,*r8p[radr.reg]); PC+=2; break;
            case 0xD2: XOR_B(B,*r8p[radr.reg]); PC+=2; break;
            case 0xD3: XOR_B(C,*r8p[radr.reg]); PC+=2; break;
            case 0xD4: XOR_B(D,*r8p[radr.reg]); PC+=2; break;
            case 0xD5: XOR_B(E,*r8p[radr.reg]); PC+=2; break;
            case 0xD6: XOR_B(H,*r8p[radr.reg]); PC+=2; break;
            case 0xD7: XOR_B(L,*r8p[radr.reg]); PC+=2; break;
            case 0xD8: CP_B(*r8p[radr.reg],0); PC+=2; break;
            case 0xD9: CP_B(*r8p[radr.reg],1); PC+=2; break;
            case 0xDA: CP_B(*r8p[radr.reg],2); PC+=2; break;
            case 0xDB: CP_B(*r8p[radr.reg],3); PC+=2; break;
            case 0xDC: CP_B(*r8p[radr.reg],4); PC+=2; break;
            case 0xDD: CP_B(*r8p[radr.reg],5); PC+=2; break;
            case 0xDE: CP_B(*r8p[radr.reg],6); PC+=2; break;
            case 0xDF: CP_B(*r8p[radr.reg],7); PC+=2; break;
            case 0xE0: OR_B(W,*r8p[radr.reg]); PC+=2; break;
            case 0xE1: OR_B(A,*r8p[radr.reg]); PC+=2; break;
            case 0xE2: OR_B(B,*r8p[radr.reg]); PC+=2; break;
            case 0xE3: OR_B(C,*r8p[radr.reg]); PC+=2; break;
            case 0xE4: OR_B(D,*r8p[radr.reg]); PC+=2; break;
            case 0xE5: OR_B(E,*r8p[radr.reg]); PC+=2; break;
            case 0xE6: OR_B(H,*r8p[radr.reg]); PC+=2; break;
            case 0xE7: OR_B(L,*r8p[radr.reg]); PC+=2; break;

            case 0xE9: /* RRC d8, r8 */
                fC=W & 0x01; //LSB to carry
	    
                for (i=0;i<rom[PC+2];i++) {
                    *r8p[radr.reg] >>=1; /* shift right 1bit */
                }
                SIGN8(*r8p[radr.reg]);
                ZERO(*r8p[radr.reg]);
                fH=0; fN=0;
                //fV unemulated
                PC+=3; break;

            case 0xEE: /* SLL d8,r8 */
                for (i=0;i<rom[PC+2];i++) {
                    /* fix carry */

                    fC = *r8p[radr.reg] >> 7;
                    *r8p[radr.reg] <<=1; /* shift left 1bit */
                }
                SIGN8(*r8p[radr.reg]);
                ZERO(*r8p[radr.reg]);
                fH=0; fN=0;
                PC+=3; break;

            case 0xEF: /* SRL d8,r8 */
                for (i=0;i<rom[PC+2];i++) {
                    /* fix carry */
                    fC = *r8p[radr.reg] & 0xFE;
                    *r8p[radr.reg] >>=1; /* shift right 1bit */
                }
                SIGN8(*r8p[radr.reg]);
                ZERO(*r8p[radr.reg]);
                fH=0; fN=0;
                PC+=3; break;


            case 0xF0: CP_B(W,*r8p[radr.reg]); PC+=2; break;
            case 0xF1: CP_B(A,*r8p[radr.reg]); PC+=2; break;
            case 0xF2: CP_B(B,*r8p[radr.reg]); PC+=2; break;
            case 0xF3: CP_B(C,*r8p[radr.reg]); PC+=2; break;
            case 0xF4: CP_B(D,*r8p[radr.reg]); PC+=2; break;
            case 0xF5: CP_B(E,*r8p[radr.reg]); PC+=2; break;
            case 0xF6: CP_B(H,*r8p[radr.reg]); PC+=2; break;
            case 0xF7: CP_B(L,*r8p[radr.reg]); PC+=2; break;
        }
    } /* reg.B */


    else if (madr.type==1) { /* reg.W */
        tmp16 = (rom[PC+3]<<8)+rom[PC+2];

        switch (rom[PC+1]) {
            case 0x08: /* MUL r32, d16 */
                switch (radr.reg) {
                    case 0: tmp32=WA*tmp16; XWA=tmp32; break;
                    case 1: tmp32=BC*tmp16; XBC=tmp32; break;
                    case 2: tmp32=DE*tmp16; XDE=tmp32; break;
                    case 3: tmp32=HL*tmp16; XHL=tmp32; break;
                    case 4: tmp32=IX*tmp16; XWA=tmp32; break;
                    case 5: tmp32=IY*tmp16; XWA=tmp32; break;
                    case 6: tmp32=IZ*tmp16; XWA=tmp32; break;
                    case 7: tmp32=SP*tmp16; XWA=tmp32; break;
                } PC+=4; break;

            case 0x0A: /* DIV WA, d16 */
                switch (radr.reg) {
                    case 0: divtmp=div(WA,tmp16); WA=(divtmp.rem<<8)+divtmp.quot; break;
                    case 1: divtmp=div(BC,tmp16); BC=(divtmp.rem<<8)+divtmp.quot; break;
                    case 2: divtmp=div(DE,tmp16); DE=(divtmp.rem<<8)+divtmp.quot; break;
                    case 3: divtmp=div(HL,tmp16); HL=(divtmp.rem<<8)+divtmp.quot; break;
                    case 4: divtmp=div(IX,tmp16); IX=(divtmp.rem<<8)+divtmp.quot; break;
                    case 5: divtmp=div(IY,tmp16); IY=(divtmp.rem<<8)+divtmp.quot; break;
                    case 6: divtmp=div(IZ,tmp16); IZ=(divtmp.rem<<8)+divtmp.quot; break;
                    case 7: divtmp=div(SP,tmp16); SP=(divtmp.rem<<8)+divtmp.quot; break;
                }
                //V unemulated
                PC+=4; break;

            case 0x12: /* EXTZ WA */
                switch (radr.reg) {
                    case 0: W=0; break;
                    case 1: B=0; break;
                    case 2: D=0; break;
                    case 3: H=0; break;
                    case 4: Reg_XIX.Byte.hi=0; break;
                    case 5: Reg_XIY.Byte.hi=0; break;
                    case 6: Reg_XIZ.Byte.hi=0; break;
                    case 7: Reg_XSP.Byte.hi=0; break;
                } PC+=2; break;

            case 0x13: /* EXTS WA */
                switch (radr.reg) {
                    case 0: if (WA>=0x8000) W=0xFF; else W=0; break;
                    case 1: if (BC>=0x8000) B=0xFF; else B=0; break;
                    case 2: if (DE>=0x8000) D=0xFF; else D=0; break;
                    case 3: if (HL>=0x8000) H=0xFF; else H=0; break;
                    case 4: if (IX>=0x8000) Reg_XIX.Byte.hi=0xFF; else Reg_XIX.Byte.hi=0; break;
                    case 5: if (IY>=0x8000) Reg_XIY.Byte.hi=0xFF; else Reg_XIY.Byte.hi=0; break;
                    case 6: if (IZ>=0x8000) Reg_XIZ.Byte.hi=0xFF; else Reg_XIZ.Byte.hi=0; break;
                    case 7: if (SP>=0x8000) Reg_XSP.Byte.hi=0xFF; else Reg_XSP.Byte.hi=0; break;
                } PC+=2; break;

            case 0x1C: /* DJNZ WA, d8 */
                tmp8s=rom[PC+2];
                if (*r16p[radr.reg]!=0) {
                    *r16p[radr.reg]=*r16p[radr.reg]-1;
                    PC+=3+tmp8s;
                } else {
                    PC+=3;
                } break;

            case 0x2E: /* LDC CR, r16 */
                //unemulated!
                PC+=3; break;

            case 0x2F: /* LDC r16, CR */
                //unemulated!
                PC+=3; break;

            case 0x33: /* BIT #4,r16 */
                switch (rom[PC+2]) {
                    case  0: if (*r16p[radr.reg]&   0x1) fZ=0; else fZ=1; break;
                    case  1: if (*r16p[radr.reg]&   0x2) fZ=0; else fZ=1; break;
                    case  2: if (*r16p[radr.reg]&   0x4) fZ=0; else fZ=1; break;
                    case  3: if (*r16p[radr.reg]&   0x8) fZ=0; else fZ=1; break;
                    case  4: if (*r16p[radr.reg]&  0x10) fZ=0; else fZ=1; break;
                    case  5: if (*r16p[radr.reg]&  0x20) fZ=0; else fZ=1; break;
                    case  6: if (*r16p[radr.reg]&  0x40) fZ=0; else fZ=1; break;
                    case  7: if (*r16p[radr.reg]&  0x80) fZ=0; else fZ=1; break;
                    case  8: if (*r16p[radr.reg]& 0x100) fZ=0; else fZ=1; break;
                    case  9: if (*r16p[radr.reg]& 0x200) fZ=0; else fZ=1; break;
                    case 10: if (*r16p[radr.reg]& 0x400) fZ=0; else fZ=1; break;
                    case 11: if (*r16p[radr.reg]& 0x800) fZ=0; else fZ=1; break;
                    case 12: if (*r16p[radr.reg]&0x1000) fZ=0; else fZ=1; break;
                    case 13: if (*r16p[radr.reg]&0x2000) fZ=0; else fZ=1; break;
                    case 14: if (*r16p[radr.reg]&0x4000) fZ=0; else fZ=1; break;
                    case 15: if (*r16p[radr.reg]&0x8000) fZ=0; else fZ=1; break;
                } fH=1; fN=0; PC+=3; break;

            case 0x60: INC_W(*r16p[radr.reg],8); PC+=2; break;
            case 0x61: INC_W(*r16p[radr.reg],1); PC+=2; break;
            case 0x62: INC_W(*r16p[radr.reg],2); PC+=2; break;
            case 0x63: INC_W(*r16p[radr.reg],3); PC+=2; break;
            case 0x64: INC_W(*r16p[radr.reg],4); PC+=2; break;
            case 0x65: INC_W(*r16p[radr.reg],5); PC+=2; break;
            case 0x66: INC_W(*r16p[radr.reg],6); PC+=2; break;
            case 0x67: INC_W(*r16p[radr.reg],7); PC+=2; break;
            case 0x68: DEC_W(*r16p[radr.reg],8); PC+=2; break;
            case 0x69: DEC_W(*r16p[radr.reg],1); PC+=2; break;
            case 0x6A: DEC_W(*r16p[radr.reg],2); PC+=2; break;
            case 0x6B: DEC_W(*r16p[radr.reg],3); PC+=2; break;
            case 0x6C: DEC_W(*r16p[radr.reg],4); PC+=2; break;
            case 0x6D: DEC_W(*r16p[radr.reg],5); PC+=2; break;
            case 0x6E: DEC_W(*r16p[radr.reg],6); PC+=2; break;
            case 0x6F: DEC_W(*r16p[radr.reg],7); PC+=2; break;

            case 0x80: ADD_W(WA,*r16p[radr.reg]); PC+=2; break;
            case 0x81: ADD_W(BC,*r16p[radr.reg]); PC+=2; break;
            case 0x82: ADD_W(DE,*r16p[radr.reg]); PC+=2; break;
            case 0x83: ADD_W(HL,*r16p[radr.reg]); PC+=2; break;
            case 0x84: ADD_W(IX,*r16p[radr.reg]); PC+=2; break;
            case 0x85: ADD_W(IY,*r16p[radr.reg]); PC+=2; break;
            case 0x86: ADD_W(IZ,*r16p[radr.reg]); PC+=2; break;
            case 0x87: ADD_W(SP,*r16p[radr.reg]); PC+=2; break;
            case 0x88: WA=*r16p[radr.reg]; PC+=2; break;
            case 0x89: BC=*r16p[radr.reg]; PC+=2; break;
            case 0x8A: DE=*r16p[radr.reg]; PC+=2; break;
            case 0x8B: HL=*r16p[radr.reg]; PC+=2; break;
            case 0x8C: IX=*r16p[radr.reg]; PC+=2; break;
            case 0x8D: IY=*r16p[radr.reg]; PC+=2; break;
            case 0x8E: IZ=*r16p[radr.reg]; PC+=2; break;
            case 0x8F: SP=*r16p[radr.reg]; PC+=2; break;

            case 0xA0: SUB_W(WA,*r16p[radr.reg]); PC+=2; break;
            case 0xA1: SUB_W(BC,*r16p[radr.reg]); PC+=2; break;
            case 0xA2: SUB_W(DE,*r16p[radr.reg]); PC+=2; break;
            case 0xA3: SUB_W(HL,*r16p[radr.reg]); PC+=2; break;
            case 0xA4: SUB_W(IX,*r16p[radr.reg]); PC+=2; break;
            case 0xA5: SUB_W(IY,*r16p[radr.reg]); PC+=2; break;
            case 0xA6: SUB_W(IZ,*r16p[radr.reg]); PC+=2; break;
            case 0xA7: SUB_W(SP,*r16p[radr.reg]); PC+=2; break;
            case 0xA8: *r16p[radr.reg]=0; PC+=2; break;
            case 0xA9: *r16p[radr.reg]=1; PC+=2; break;
            case 0xAA: *r16p[radr.reg]=2; PC+=2; break;
            case 0xAB: *r16p[radr.reg]=3; PC+=2; break;
            case 0xAC: *r16p[radr.reg]=4; PC+=2; break;
            case 0xAD: *r16p[radr.reg]=5; PC+=2; break;
            case 0xAE: *r16p[radr.reg]=6; PC+=2; break;
            case 0xAF: *r16p[radr.reg]=7; PC+=2; break;
            case 0xB0: SBC_W(WA,*r16p[radr.reg]); PC+=2; break;
            case 0xB1: SBC_W(BC,*r16p[radr.reg]); PC+=2; break;
            case 0xB2: SBC_W(DE,*r16p[radr.reg]); PC+=2; break;
            case 0xB3: SBC_W(HL,*r16p[radr.reg]); PC+=2; break;
            case 0xB4: SBC_W(IX,*r16p[radr.reg]); PC+=2; break;
            case 0xB5: SBC_W(IY,*r16p[radr.reg]); PC+=2; break;
            case 0xB6: SBC_W(IZ,*r16p[radr.reg]); PC+=2; break;
            case 0xB7: SBC_W(SP,*r16p[radr.reg]); PC+=2; break;

            case 0xC0: AND_W(WA,*r16p[radr.reg]); PC+=2; break;
            case 0xC1: AND_W(BC,*r16p[radr.reg]); PC+=2; break;
            case 0xC2: AND_W(DE,*r16p[radr.reg]); PC+=2; break;
            case 0xC3: AND_W(HL,*r16p[radr.reg]); PC+=2; break;
            case 0xC4: AND_W(IX,*r16p[radr.reg]); PC+=2; break;
            case 0xC5: AND_W(IY,*r16p[radr.reg]); PC+=2; break;
            case 0xC6: AND_W(IZ,*r16p[radr.reg]); PC+=2; break;
            case 0xC7: AND_W(SP,*r16p[radr.reg]); PC+=2; break;
            case 0xC8: ADD_W(*r16p[radr.reg],tmp16); PC+=4; break;
            case 0xC9: ADC_W(*r16p[radr.reg],tmp16); PC+=4; break;	    
            case 0xCA: SUB_W(*r16p[radr.reg],tmp16); PC+=4; break;
            case 0xCB: SBC_W(*r16p[radr.reg],tmp16); PC+=4; break;
            case 0xCC: AND_W(*r16p[radr.reg],tmp16); PC+=4; break;
            case 0xCD: XOR_W(*r16p[radr.reg],tmp16); PC+=4; break;
            case 0xCE: OR_W(*r16p[radr.reg],tmp16); PC+=4; break;
            case 0xCF: CP_W(*r16p[radr.reg],tmp16); PC+=4; break;
            case 0xD0: XOR_W(WA,*r16p[radr.reg]); PC+=2; break;
            case 0xD1: XOR_W(BC,*r16p[radr.reg]); PC+=2; break;
            case 0xD2: XOR_W(DE,*r16p[radr.reg]); PC+=2; break;
            case 0xD3: XOR_W(HL,*r16p[radr.reg]); PC+=2; break;
            case 0xD4: XOR_W(IX,*r16p[radr.reg]); PC+=2; break;
            case 0xD5: XOR_W(IY,*r16p[radr.reg]); PC+=2; break;
            case 0xD6: XOR_W(IZ,*r16p[radr.reg]); PC+=2; break;
            case 0xD7: XOR_W(SP,*r16p[radr.reg]); PC+=2; break;
            case 0xD8: CP_W(*r16p[radr.reg],0); PC+=2; break;
            case 0xD9: CP_W(*r16p[radr.reg],1); PC+=2; break;
            case 0xDA: CP_W(*r16p[radr.reg],2); PC+=2; break;
            case 0xDB: CP_W(*r16p[radr.reg],3); PC+=2; break;
            case 0xDC: CP_W(*r16p[radr.reg],4); PC+=2; break;
            case 0xDD: CP_W(*r16p[radr.reg],5); PC+=2; break;
            case 0xDE: CP_W(*r16p[radr.reg],6); PC+=2; break;
            case 0xDF: CP_W(*r16p[radr.reg],7); PC+=2; break;

            case 0xE0: OR_W(WA,*r16p[radr.reg]); PC+=2; break;
            case 0xE1: OR_W(BC,*r16p[radr.reg]); PC+=2; break;
            case 0xE2: OR_W(DE,*r16p[radr.reg]); PC+=2; break;
            case 0xE3: OR_W(HL,*r16p[radr.reg]); PC+=2; break;
            case 0xE4: OR_W(IX,*r16p[radr.reg]); PC+=2; break;
            case 0xE5: OR_W(IY,*r16p[radr.reg]); PC+=2; break;
            case 0xE6: OR_W(IZ,*r16p[radr.reg]); PC+=2; break;
            case 0xE7: OR_W(SP,*r16p[radr.reg]); PC+=2; break;

            case 0xEE: /* SLL d8,r16 */
                for (i=0;i<rom[PC+2];i++) {
                    /* fix carry */

                    fC = *r16p[radr.reg] >> 15;
                    *r16p[radr.reg] <<=1; /* shift left 1bit */
                }
                SIGN16(*r16p[radr.reg]);
                ZERO(*r16p[radr.reg]);
                fH=0; fN=0;
                PC+=3; break;

            case 0xEF: /* SRL d8,r16 */
                for (i=0;i<rom[PC+2];i++) {
                    /* fix carry */
                    fC = *r16p[radr.reg] & 0xFFFE;
                    *r16p[radr.reg] >>=1; /* shift right 1bit */
                }
                SIGN16(*r16p[radr.reg]);
                ZERO(*r16p[radr.reg]);
                fH=0; fN=0;
                PC+=3; break;

            case 0xF0: CP_W(WA,*r16p[radr.reg]); PC+=2; break;
            case 0xF1: CP_W(BC,*r16p[radr.reg]); PC+=2; break;
            case 0xF2: CP_W(DE,*r16p[radr.reg]); PC+=2; break;
            case 0xF3: CP_W(HL,*r16p[radr.reg]); PC+=2; break;
            case 0xF4: CP_W(IX,*r16p[radr.reg]); PC+=2; break;
            case 0xF5: CP_W(IY,*r16p[radr.reg]); PC+=2; break;
            case 0xF6: CP_W(IZ,*r16p[radr.reg]); PC+=2; break;
            case 0xF7: CP_W(SP,*r16p[radr.reg]); PC+=2; break;

        }
    } /* reg.W */

    else if (madr.type==2) { /* reg.L */
        tmp32  = (rom[PC+5]<<24)+(rom[PC+4]<<16)+(rom[PC+3]<<8)+rom[PC+2];

        switch (rom[PC+1]) {
            case 0x12: *r32p[radr.reg]=*r32p[radr.reg] | 0x0000FFFF; PC+=2; break;

            case 0x60: INC_L(*r32p[radr.reg],8); PC+=2; break;
            case 0x61: INC_L(*r32p[radr.reg],1); PC+=2; break;
            case 0x62: INC_L(*r32p[radr.reg],2); PC+=2; break;
            case 0x63: INC_L(*r32p[radr.reg],3); PC+=2; break;
            case 0x64: INC_L(*r32p[radr.reg],4); PC+=2; break;
            case 0x65: INC_L(*r32p[radr.reg],5); PC+=2; break;
            case 0x66: INC_L(*r32p[radr.reg],6); PC+=2; break;
            case 0x67: INC_L(*r32p[radr.reg],7); PC+=2; break;
            case 0x68: DEC_L(*r32p[radr.reg],8); PC+=2; break;
            case 0x69: DEC_L(*r32p[radr.reg],1); PC+=2; break;
            case 0x6A: DEC_L(*r32p[radr.reg],2); PC+=2; break;
            case 0x6B: DEC_L(*r32p[radr.reg],3); PC+=2; break;
            case 0x6C: DEC_L(*r32p[radr.reg],4); PC+=2; break;
            case 0x6D: DEC_L(*r32p[radr.reg],5); PC+=2; break;
            case 0x6E: DEC_L(*r32p[radr.reg],6); PC+=2; break;
            case 0x6F: DEC_L(*r32p[radr.reg],7); PC+=2; break;

            case 0x80: ADD_L(XWA,*r32p[radr.reg]); PC+=2; break;
            case 0x81: ADD_L(XBC,*r32p[radr.reg]); PC+=2; break;
            case 0x82: ADD_L(XDE,*r32p[radr.reg]); PC+=2; break;
            case 0x83: ADD_L(XHL,*r32p[radr.reg]); PC+=2; break;
            case 0x84: ADD_L(XIX,*r32p[radr.reg]); PC+=2; break;
            case 0x85: ADD_L(XIY,*r32p[radr.reg]); PC+=2; break;
            case 0x86: ADD_L(XIZ,*r32p[radr.reg]); PC+=2; break;
            case 0x87: ADD_L(XSP,*r32p[radr.reg]); PC+=2; break;
            case 0x88: XWA=*r32p[radr.reg]; PC+=2; break;
            case 0x89: XBC=*r32p[radr.reg]; PC+=2; break;
            case 0x8A: XDE=*r32p[radr.reg]; PC+=2; break;
            case 0x8B: XHL=*r32p[radr.reg]; PC+=2; break;
            case 0x8C: XIX=*r32p[radr.reg]; PC+=2; break;
            case 0x8D: XIY=*r32p[radr.reg]; PC+=2; break;
            case 0x8E: XIZ=*r32p[radr.reg]; PC+=2; break;
            case 0x8F: XSP=*r32p[radr.reg]; PC+=2; break;

            case 0xA0: SUB_L(XWA,*r32p[radr.reg]); PC+=2; break;
            case 0xA1: SUB_L(XBC,*r32p[radr.reg]); PC+=2; break;
            case 0xA2: SUB_L(XDE,*r32p[radr.reg]); PC+=2; break;
            case 0xA3: SUB_L(XHL,*r32p[radr.reg]); PC+=2; break;
            case 0xA4: SUB_L(XIX,*r32p[radr.reg]); PC+=2; break;
            case 0xA5: SUB_L(XIY,*r32p[radr.reg]); PC+=2; break;
            case 0xA6: SUB_L(XIZ,*r32p[radr.reg]); PC+=2; break;
            case 0xA7: SUB_L(XSP,*r32p[radr.reg]); PC+=2; break;
            case 0xA8: *r32p[radr.reg]=0; PC+=2; break;
            case 0xA9: *r32p[radr.reg]=1; PC+=2; break;
            case 0xAA: *r32p[radr.reg]=2; PC+=2; break;
            case 0xAB: *r32p[radr.reg]=3; PC+=2; break;
            case 0xAC: *r32p[radr.reg]=4; PC+=2; break;
            case 0xAD: *r32p[radr.reg]=5; PC+=2; break;
            case 0xAE: *r32p[radr.reg]=6; PC+=2; break;
            case 0xAF: *r32p[radr.reg]=7; PC+=2; break;

            case 0xC8: ADD_L(*r32p[radr.reg],tmp32); PC+=6; break;

            case 0xCA: SUB_L(*r32p[radr.reg],tmp32); PC+=6; break;

            case 0xCC: AND_L(*r32p[radr.reg],tmp32); PC+=6; break;
            case 0xCD: XOR_L(*r32p[radr.reg],tmp32); PC+=6; break;
            case 0xCE: OR_L(*r32p[radr.reg],tmp32); PC+=6; break;
            case 0xCF: CP_L(*r32p[radr.reg],tmp32); PC+=6; break;
            case 0xD0: XOR_L(XWA,*r32p[radr.reg]); PC+=2; break;
            case 0xD1: XOR_L(XBC,*r32p[radr.reg]); PC+=2; break;
            case 0xD2: XOR_L(XDE,*r32p[radr.reg]); PC+=2; break;
            case 0xD3: XOR_L(XHL,*r32p[radr.reg]); PC+=2; break;
            case 0xD4: XOR_L(XIX,*r32p[radr.reg]); PC+=2; break;
            case 0xD5: XOR_L(XIY,*r32p[radr.reg]); PC+=2; break;
            case 0xD6: XOR_L(XIZ,*r32p[radr.reg]); PC+=2; break;
            case 0xD7: XOR_L(XSP,*r32p[radr.reg]); PC+=2; break;

            case 0xE0: OR_L(XWA,*r32p[radr.reg]); PC+=2; break;
            case 0xE1: OR_L(XBC,*r32p[radr.reg]); PC+=2; break;
            case 0xE2: OR_L(XDE,*r32p[radr.reg]); PC+=2; break;
            case 0xE3: OR_L(XHL,*r32p[radr.reg]); PC+=2; break;
            case 0xE4: OR_L(XIX,*r32p[radr.reg]); PC+=2; break;
            case 0xE5: OR_L(XIY,*r32p[radr.reg]); PC+=2; break;
            case 0xE6: OR_L(XIZ,*r32p[radr.reg]); PC+=2; break;
            case 0xE7: OR_L(XSP,*r32p[radr.reg]); PC+=2; break;

            case 0xEF: /* SRL #4, r32 */
                for (i=0;i<rom[PC+2];i++) {
                    /* fix carry val */
                    fC = *r32p[radr.reg] & 0xFFFFFFFE;
                    *r32p[radr.reg] >>=1; /* shift 1b */
                }
                if (*r32p[radr.reg] >= 0x80000000) fS=1; else fS=0;
                if (*r32p[radr.reg] == 0) fZ=1; else fZ=0;
                fH=0; fN=0;
                PC+=3; break;

            case 0xF0: CP_L(XWA,*r32p[radr.reg]); PC+=2; break;
            case 0xF1: CP_L(XBC,*r32p[radr.reg]); PC+=2; break;
            case 0xF2: CP_L(XDE,*r32p[radr.reg]); PC+=2; break;
            case 0xF3: CP_L(XHL,*r32p[radr.reg]); PC+=2; break;
            case 0xF4: CP_L(XIX,*r32p[radr.reg]); PC+=2; break;
            case 0xF5: CP_L(XIY,*r32p[radr.reg]); PC+=2; break;
            case 0xF6: CP_L(XIZ,*r32p[radr.reg]); PC+=2; break;
            case 0xF7: CP_L(XSP,*r32p[radr.reg]); PC+=2; break;

        }
    } /* reg.L */
}
