/*
 * This code was inspired by the Infinity Source code Marathon 2: register addresses and names were written down to paper.
 * This code was written independently from the Infinity Source and does not incorporate any portion of the original GPLv3-licensed code.
 * Therefore, it is not bound by the GPLv3 license.
 * 
 * This work is dedicated to the public domain under the Creative Commons CC0 1.0 Universal (CC0 1.0) Public Domain Dedication.
 * To view a copy of this dedication, visit http://creativecommons.org/publicdomain/zero/1.0/ or send a letter to Creative Commons, PO Box 1866, Mountain View, CA 94042, USA.
 * 
 * Disclaimer: The author has made every effort to ensure that this code was developed independently and is not a derivative work of any GPLv3-licensed code. If any part of this code is found to be in violation of GPLv3, the author will comply with the requirements of the GPLv3 license.
 *
 * By Julien Aubert (a.k.a noglin)
 */
#include <stdint.h>

/* flags for control register */ 
#define VALKYRIE_VIDEO0 0x00
#define VALKYRIE_VIDEO1 0x40
#define VALKYRIE_WINDOW 0x20
#define VALKYRIE_2X     0x02

#define VALKYRIE_BUFFER_VIDEO_ROWBYTES 1024
extern void *valkyrie_buffer_video0;
extern void *valkyrie_buffer_video1;
extern void *valkyrie_buffer_screen;

extern volatile uint8_t *valkyrie_reg_subsystem_config;
extern volatile uint8_t *valkyrie_reg_video_in_control;
extern volatile uint16_t *valkyrie_reg_video_in_x0;
extern volatile uint16_t *valkyrie_reg_video_in_y0;
extern volatile uint16_t *valkyrie_reg_video_in_width;
extern volatile uint16_t *valkyrie_reg_video_in_height;
extern volatile uint16_t *valkyrie_reg_video_in_field_x0;
extern volatile uint16_t *valkyrie_reg_video_in_field_y0;
extern volatile uint8_t *valkyrie_reg_clut_color_key;

/* this 8bpp pixel value in screen will let current video through */
extern uint8_t valkyrie_screen_video_key;

extern int valkyrie_page;

int valkyrie_available(void);
void valkyrie_init(uint8_t pixel_video_key);
void valkyrie_clear(uint16_t backbuffer_value, uint8_t screen_value);
void *valkyrie_get_video_backbuffer(void);
void valkyrie_pageflip_video(void);
void valkyrie_stop(void);
