; GBDebug V1.3
;  by Jeff Frohwein
;
; last edit 27-Oct-95
;
;Rev 1.0 - Original 26-Oct-95
;Rev 1.1 - Fixed bug in REGISTER command.
;Rev 1.2 - Removed credit screen timer. Made it
;          so person has to hit the start button.
;	   Added charcters to virtual 'keyboard'
;	   for mini-assembler support.
;Rev 1.3 - Minor cosmetic stuff. Assembler and
;          dissassembler 'kinda' work, but not
;	   solid yet.

;	I haven't had time to clean this up or
;	do a whole lot of commenting. Soon I will
;	document this code to make it more readable.

bs	.equ	8
cr	.equ	13

windulx	.equ	$c000
winduly	.equ	$c001
windlrx	.equ	$c002
windlry	.equ	$c003
curx	.equ	$c004
cury	.equ	$c005
bright	.equ	$c006
keypadx	.equ	$c007
keypady	.equ	$c008
errflg	.equ	$c009		;reports an error to calling routines
regaf	.equ	$c00a
regbc	.equ	$c00c
regde	.equ	$c00e
reghl	.equ	$c010
frmhrd	.equ	$c012		;holds default dump address 
frmhrl	.equ	$c014		;holds default unassemble address
fndloc	.equ	$c016		;holds find address
tjmp	.equ	$c018		;used to do a 'soft' jump
fnddat	.equ	$c01b		;holds find search pattern
pripr	.equ	$c023		;holds current pair for disassembly (HL)
savqq	.equ	$c025		;holds current pair for disassembly (AF)
savss	.equ	$c027		;holds current pair for disassembly (SP) 
prebsd	.equ	$c029		;holds non-zero if prefix is saved
dblpr	.equ	$c02a	
ilpsaf	.equ	$c02c
ilpsav	.equ	$c02e
inlen	.equ	$c030
inbuf	.equ	$c031

.org 0

; Set all irq vectors to do nothing.

.org 40h		; VBlank IRQ
 reti			; Do nothing
.org 48h		; LCDC Status IRQ
 reti			; Do nothing
.org 50h		; Timer Owerflow
 reti			; Do nothing
.org $0058		; Serial Transfer Completion
 reti			; Do nothing
.org $0060		; Hmm, this is a wierd on
			; Im not sure how this one works
			; Transition from high to low
			; of pin p10-p13
			; I think Its a hardware thing
 reti			; Do nothing :)
; Irqs done..

.org 100h

; GameBoy Header with correct checksum
; Done 95-08-13 by HZ/DiESEL
; Do not use this one.. Make your own.

.byte $00,$C3,$50,$01

.byte $CE,$ED,$66,$66,$CC,$0D,$00,$0B,$03,$73,$00,$83
.byte $00,$0C,$00,$0D,$00,$08,$11,$1F,$88,$89,$00,$0E,$DC,$CC,$6E,$E6
.byte $DD,$DD,$D9,$99,$BB,$BB,$67,$63,$6E,$0E,$EC,$CC,$DD,$DC,$99,$9F

.byte $BB,$B9,$33,$3E	; Standard Nintendo DO NOT CHANGE...

.byte "HEROZERO SAMPLE1"	; Cart name   16bytes
.byte 0,0,0			; Not used
.byte 0				; Cart type   ROM Only
.byte 0				; ROM Size    32k
.byte 0				; RAM Size     0k
.byte 0deh,0adh			; Maker ID    $dead=DiESEL Soft
.byte 1				; Version     =1
.byte 0dah			; Complement check (Important)
.byte 0ffh,0ffh			; Cheksum (Who cares)


start:			; This is addr $0150
 di
 ld	sp,0fff4h	; Put the stack where the GB wants it

 ld	a,0		; No IRQs at all
 ldh	(0ffh),a

 sub	a		; Misc standard init things..
 ldh	(41h),a		; LCDC Status
 ldh	(42h),a		; Screen scroll Y=0
 ldh	(43h),a		; Screen scroll X=0

 call	waitvbl		; Must be in VBL before turning the screen off.

 ld	a,00010001b	; LCD Controller = Off (No picture on screen)
			; WindowBank = $9800 (Not used)
			; Window = OFF
			; BG Chr = $8000
			; BG Bank= $9800
			; OBJ    = 8x8
			; OBJ    = Off
			; BG     = On
 ldh	(40h),a

 call	nor_col		; Normal palette
 call 	move_char	; Move the charset to $8000
 call	move_text	; Move the text to $9800


; call	waitvbl		; Must be in VBL before turning the screen On.

 ld	a,10010001b	; LCD Controller = On
 ldh	(40h),a

	ld	a,19
	ld	(inlen),a
	xor	a
	ld	(frmhrd),a
	ld	(frmhrd+1),a
	ld	(regaf),a
	ld	(regaf+1),a
	ld	(regbc),a
	ld	(regbc+1),a
	ld	(regde),a
	ld	(regde+1),a
	ld	(reghl),a
	ld	(reghl+1),a

;	call	highlight

	ld	b,1	;set window for whole screen
	ld	c,1
	ld	d,20
	ld	e,18
	call	window

;	ld	a,20
;mainly:
;	push	af
;	ld	de,0
;loop1:
;	dec	de
;	ld	a,d
;	or	e
;	jr	nz,loop1
;
;	pop	af
;	dec	a	
;	jr	nz,mainly

	call	getch		;hold startup screen
				;until all buttons released
	call	cls

	call	initkpd

	ld	b,1
	ld	c,1
	call	locate

	call	highlight

	jp	prompt
main:
	ld	a,'-'
	call	charout


skip:
	call	getch
	call	charout
	jp	skip


;* Get a Key from Input device & keep most register values *

getch:
	push	bc
	push	de
	push	hl
	call	getchns
	pop	hl
	pop	de
	pop	bc
	ret

;* Get a Key from Input device *

getchns:
getch0:
	call	getbuts
	ld	b,a
	and	$40		;is select pressed?
	jp	nz,padchar	;yes, return what keypad's pointing to

	ld	a,b
	and	$20		;is B pressed?
	ld	a,bs
	jp	nz,keyup	;yes, backspace

	ld	a,b
	and	$80		;is start pressed?
	ld	a,cr
	jp	nz,keyup	;yes

	ld	a,b
	and	0fh
	add	a,0f8h		;is down pressed?
	jp	nc,getch3	;no

	ld	a,(keypady)
	xor	3
	ld	(keypady),a
	jp	getchup

getch3:
	add	a,4		;is up pressed?
	jp	nc,getch5	;no

	ld	a,(keypady)
	xor	3
	ld	(keypady),a
	jp	getchup

getch5:
	add	a,2		;is left pressed?
	jp	nc,getch7	;no

	ld	a,(keypadx)
	cp	1		;Are we already at left column?
	jp	z,getch6	;yes

	dec	a
	ld	(keypadx),a

	jp	getchup
getch6:
	ld	a,20
	ld	(keypadx),a
	jp	getchup

getch7:
	add	a,1		;is right pressed?
	jp	nc,getch0	;no

	ld	a,(keypadx)
	cp	20		;Are we already at right column?
	jr	z,getch8	;yes

	inc	a
	ld	(keypadx),a
	jr	getchup

getch8:	ld	a,1
	ld	(keypadx),a
getchup:
	call	drawmenu
	call	keyup
	jp	getch0

padchar:
	call	keyup
	jp	xy2char

;* Convert B,C keypad character to actual value *

xy2char:
	ld	de,menu
	ld	c,1
padchar1:
	ld	b,1
padchar2:
	ld	a,(keypadx)
	cp	b
	jr	nz,padchar9
	ld	a,(keypady)
	cp	c
	jr	nz,padchar9
	ld	a,(de)
	cp	10		;was space pressed?
	jr	nz,padchar8	;no
	ld	a,' '
padchar8:
	ret
padchar9:
	inc	de
	inc	b
	ld	a,21
	cp	b
	jr	nz,padchar2
	inc	c
	jr	padchar1

; * Wait until all buttons have been
;   released and debounced *
keyup:
	push	af
keyup1:
	ld	b,255
keyup2:
	push	bc
	call	getbuts
	pop	bc
	or	a		;have all buttons been released?
	jr	nz,keyup1	;not yet

	dec	b
	jr	nz,keyup2
	pop	af
	ret

; * Get Keypad Button Status *
;  The following bits are set if pressed.
;   $80 - Start   $8 - Down
;   $40 - Select  $4 - Up
;   $20 - B       $2 - Left
;   $10 - A       $1 - Right

getbuts:
	ld	a,20h
	ld	(0ff00h),a	;turn on P15

	ld	a,(0ff00h)	;delay
	ld	a,(0ff00h)
	cpl
	and	0fh
	swap	a
	ld	b,a
	ld	a,10h
	ld	(0ff00h),a	;turn on P14
	ld	a,(0ff00h)	;delay
	ld	a,(0ff00h)
	ld	a,(0ff00h)
	ld	a,(0ff00h)
	ld	a,(0ff00h)
	ld	a,(0ff00h)
	cpl
	and	0fh
	or	b
	swap	a
	ret

; *  Initialize on screen keypad *

initkpd:
	ld	a,1
	ld	(keypadx),a
	ld	(keypady),a

	call	drawmenu

	call	highlight

	ld	b,1		;set window for all but menu
	ld	c,1
	ld	d,20
	ld	e,15
	jp	window

; * Draw Menu *

drawmenu:
	ld	a,(curx)
	ld	b,a
	ld	a,(cury)
	ld	c,a
	push	bc

	ld	b,1
	ld	c,16
	call	locate

	ld	hl,menu
	ld	c,1
drawm1:	ld	b,1
drawm2:	ldi	a,(hl)
	or	a
	jp	z,drawm4

	push	af
	call	lowlight
	ld	a,(keypadx)
	cp	b
	jr	nz,drawm3
	ld	a,(keypady)
	cp	c
	jr	nz,drawm3

	ld	d,b
	ld	e,c

	call	highlight
drawm3:
	pop	af
	call	charout
	inc	b
	ld	a,21
	cp	b
	jr	nz,drawm2
	inc	c
	jr	drawm1
drawm4:
	call	lowlight
	ld	a,' '
	call	charoutnu
	call	highlight
	pop	bc
	push	bc
	call	xy2char
	call	cmddef
	pop	bc
	ld	a,b
	ld	(curx),a
	ld	a,c
	ld	(cury),a
	ret

;* Convert Command in A to text & print at bottom of screen *

cmddef:
	push	af
	ld	b,1
	ld	c,18
	call	locate
	pop	af

	ld	bc,cmda
	cp	'A'
	jp	z,cmdd1

	ld	bc,cmdc
	cp	'C'
	jp	z,cmdd1

	ld	bc,cmdd
	cp	'D'
	jp	z,cmdd1

	ld	bc,cmdf
	cp	'F'
	jp	z,cmdd1

	ld	bc,cmdg
	cp	'G'
	jp	z,cmdd1

	ld	bc,cmdm
	cp	'M'
	jp	z,cmdd1

	ld	bc,cmdr
	cp	'R'
	jp	z,cmdd1

	ld	bc,cmds
	cp	'S'
	jp	z,cmdd1

	ld	bc,cmdu
	cp	'U'
	jp	z,cmdd1

	ld	bc,cmdx
	cp	'X'

	jp	z,cmdd1
	
	ld	bc,cmdz
cmdd1:
	jp	prntstr

cmda:
	.byte	"ASSEMBLE sa        ",0
cmdc:
	.byte	"COMPAR MEM sa,ea,da",0
cmdd:
	.byte	"DUMP [sa]          ",0
cmdf:
	.byte	"FIND sa,xx[,xx]    ",0
cmdg:
	.byte	"GO sa              ",0
cmdm:
	.byte	"MOVE sa,ea,da      ",0
cmdr:
	.byte	"REGISTERS [r]      ",0
cmds:
	.byte	"SUBSTITUTE sa      ",0
cmdu:
	.byte	"UNASSEMBLE [sa]    ",0
cmdx:
	.byte	"EXAMINE MEMORY     ",0
cmdz:
	.byte	"                   ",0
menu:
;	.byte	"ACDFGMRSUX,hl       "
;	.byte	"0123456789abcdef",0

	.byte	"AbCDeFGhijlMnopRStUX"
	.byte	10,10,10,"z0123456789,()",10,10,10,0

waitvbl:		; Wait for VBL
 ldh	a,(40h)
 add	a,a
 ret	nc

notyet:
 ldh	a,(44h)		; $ff44=LCDC Y-Pos
 cp	90h		; $90 and bigger = in VBL
 jr	nz,notyet	; Loop until it $90
 ret

white:			; All colors to transparent
 ld	a,0
 ldh	(47h),a
 ret

black			; All colors to black
 ld	a,0ffh
 ldh	($47),a
 ret

nor_col:		; Sets the colors to normal palette
 ld	a,11100100b	; grey 3=11 (Black)
			; grey 2=10 (Dark grey)
			; grey 1=01 (Light grey)
			; grey 0=00 (Transparent)
 ldh	(47h),a
 ret

: * Initialize the Character Set *

move_char:
 ld	hl,8000h
 ld	bc,charset
 ld	d,0		; Like move 1024 bytes man
 ld	e,4		; x2=1024

lp1:
 ld	a,(bc)
 ldi	(hl),a
 ldi	(hl),a
 inc	bc
 dec	d
 jp	nz,lp1
 dec	e
 jp	nz,lp1

 ld	hl,8800h	;fill second set with same
 ld	bc,charset	;at half brightness
 ld	d,0		; Like move 1024 bytes man
 ld	e,4		; x2=1024

lp2:
 ld	a,(bc)
 ld	(hl),a
 inc	hl
 ld	(hl),0
 inc	hl
 inc	bc
 dec	d
 jp	nz,lp2
 dec	e
 jp	nz,lp2
 ret

move_text:
 ld	bc,the_text
mve:
 ld	hl,9800h
 ld	d,0
 ld	e,4		; 256*4=1024=32x32=One whole GB Screen

wloop1:
 ld	a,(bc)
 ldi	(hl),a
hole1:
 ldh	a,(41h)
 and	2
 jp	nz,hole1

 inc	bc
 dec	d
 jp	nz,wloop1
 dec	e
 jp	nz,wloop1

 ret

; * Print string pointed to by BC
;   and terminated with a 0 *

prntstr:
	ld	a,(bc)
	or	a
	ret	z
	call	charout
	inc	bc
	jr	prntstr

; * Print a Space *

space:
	ld	a,' '
	jr	charout

; * Print a CR & LF *

crlf:
	ld	a,13

; * Print a Character & protect all registers *

charout:
	push	af
	push	bc
	push	de
	push	hl
	call	charoutns
	pop	hl
	pop	de
	pop	bc
	pop	af
	ret

; * Print a Character and update cursor position *

charoutns:
 cp	bs		;is it backspace?
 jp	z,charout5	;yes

 cp	cr		;is it enter?
 jr	nz,charou1	;no

 ld	a,' '
 call	charoutnu	;get rid of cursor
 call	charout2	;move cursor down a line
 jr	charou2		;display cursor
 
charou1:
 call	charoutnu
 call	curupdate
charou2:
 ld	a,'_'
 jp	charoutnu

; Update Cursor position
curupdate:
 ld	a,(windulx)
 ld	b,a
 ld	a,(windlrx)
 sub	b
 inc	a
 ld	b,a		;b = window width
 ld	a,(curx)
 cp	b		;is cursor at end of line?
 jr	z,charout2	;yes

charout1:
 inc	a
 ld	(curx),a
 ret

charout2:
 ld	a,(winduly)
 ld	b,a
 ld	a,(windlry)
 sub	b
 inc	a
 ld	b,a		;b = window width
 ld	a,(cury)
 cp	b		;is cursor on last line?
 jr	z,charout4	;yes

 ld	a,(cury)
 inc	a
 ld	(cury),a

charout3:
 xor	a
 jp	charout1

charout4:
 call	scroll
 jp	charout3

charout5:
 ld	a,(curx)
 cp	1		;are we at beginning?
 ret	z		;yes, do nothing

 push	af
 ld	a,' '
 call	charoutnu
 pop	af
 dec	a
 ld	(curx),a
 ld	a,'_'
 jp	charoutnu

;* HighLight *

highlight:
 ld	a,1
 ld	(bright),a
 ret

;* LowLight *

lowlight:
 xor	a
 ld	(bright),a
 ret

; * Print a Character *

charoutnu:
 push	af

 ld	a,(windulx)
 ld	d,a
 ld	a,(curx)
 dec	a
 add	a,d
 ld	d,a

 ld	a,(winduly)
 ld	e,a
 ld	a,(cury)
 dec	a
 add	a,e
 ld	e,a

 ld	l,e
 ld	h,0
 add	hl,hl
 add	hl,hl
 add	hl,hl
 add	hl,hl
 add	hl,hl
 ld	c,d
 ld	b,0
 add	hl,bc
 ld	bc,9800h
 add	hl,bc

 ld	a,(bright)	;bright if 1
 ld	b,a
 pop	af
 and	7fh
 dec	b
 jr	z,chnubr

 add	a,128
chnubr:
 ld	b,a

chnuloop:
 ldh	a,(41h)
 and	2
 jp	nz,chnuloop
 
 ld	(hl),b
 ret

move:
	ldi	a,(hl)
	ld	(de),a
	inc	de

; * LDIR - Just like z80 command *

ldir:
 ldh	a,(41h)
 and	2
 jp	nz,ldir
 
 ldi	a,(hl)
 ld	(de),a
 inc	de
 dec	bc
 ld	a,b
 or	c
 jp	nz,ldir
 ret

; * Position Cursor *
;  New cursor position is (b,c).
;  This position is relative to the window.
;  Possible Values are (1,1) - (20,18)

locate:
 ld	a,b
 ld	(curx),a
 ld	a,c
 ld	(cury),a
 ret

; * Clear Screen *

cls:
 ld	a,18
cls1:
 push	af
 call	scroll
 pop	af
 dec	a
 jr	nz,cls1
 ret

; * Scroll Window up *
;  Upper left coordinate of window is (windulx,winduly).
;  Lower right coordinate of window is (windlrx,windlry).
;  Possible Values are (0,0) - (19,17)

scroll:
 ld	a,(winduly)
 ld	l,a
 ld	h,0
 add	hl,hl
 add	hl,hl
 add	hl,hl
 add	hl,hl
 add	hl,hl
 ld	a,(windulx)
 ld	c,a
 ld	b,0
 add	hl,bc
 ld	bc,9800h
 add	hl,bc
 push	hl		;put UL address on stack
 ld	bc,32
 add	hl,bc		;hl=next line
 pop	bc

 ld	a,(winduly)
 ld	e,a
 ld	a,(windlry)
 sub	e
 ld	e,a	;e = window heigth in characters

scroll1:
 push	bc

 ld	a,(windulx)
 ld	d,a
 ld	a,(windlrx)
 sub	d
 inc	a
 ld	d,a	;d = window width in characters

scroll2:

scroll3:
 ldh	a,(41h)
 and	2
 jp	nz,scroll3

 ldi	a,(hl)
 ld	(bc),a
 inc	bc
 dec	d
 jp	nz,scroll2

 pop	hl

 ld	bc,32
 add	hl,bc
 push	hl
 ld	bc,32
 add	hl,bc		;hl=next line
 pop	bc

 dec	e
 jp	nz,scroll1

; Fill new line with all spaces

 ld	a,(windulx)
 ld	d,a
 ld	a,(windlrx)
 sub	d
 inc	a
 ld	d,a	;d = window width in characters

scroll4:
 ldh	a,(41h)
 and	2
 jp	nz,scroll4

 ld	a,32
 ld	(bc),a
 inc	bc
 dec	d
 jp	nz,scroll4

 ret

;Set Cursor Window
;BC = X,Y upper left of window
;DE = X,Y lower right of window

window:
	ld	a,b
	dec	a
	ld	(windulx),a
	ld	a,c
	dec	a
	ld	(winduly),a
	ld	a,d
	dec	a
	ld	(windlrx),a
	ld	a,e
	dec	a
	ld	(windlry),a
	ret

; * ex de,hl *

exdehl:	push	af
	ld	a,d		;save address
	ld	d,h
	ld	h,a
	ld	a,e
	ld	e,l
	ld	l,a
	pop	af
	ret

; * Beginning of Monitor Code *

promcl:	call	crlf
prompt:	ld	a,'-'	     ;print MONITOR prompt
	call	charout
	call	input	     ;input A LINE FROM USER
	ld	de,inbuf
	ld	a,(de)	     ;GET FIRST BYTE IN BUFFER
	inc	de
	cp	cr	     ;WAS IT A BLANK LINE ?
	jr	z,prompt     ;YES, DON'T DO ANYTHING

	cp	'A'	     ;IS IT THE ASSEMBLE command ?
	jp	nz,inpt3     ;no

	call	getdhx	     ;bc = Hex NUMBER
	jp	c,badent	;bad number entered
	ld	h,b
	ld	l,c
assan:	call	hexdbl	     ;print ASSEMBLE ADDRESS
	call	exdehl		;save address
	call	inputs
	ld	hl,inbuf     ;POINT TO input BUFFER
	ld	a,(hl)
	cp	cr	     ;IS IT AN exIT ASSEMBLE command ?
	jr	z,prompt     ;YES

	call	exdehl	     ;GET ASSEMBLE ADDRESS
	call	assem
	ld	a,(errflg)
	or	a	     ;DID IT ASSEMBLE OKAY ?
	jr	nz,assan     ;NO, DON'T incREMENT MEMORY POINTER
	inc	hl
	jr	assan

inpt3:	cp	'C'	     ;IS IT A COMPARE command ?
	jp	nz,inpt4     ;NO

	call	getdhx
	ld	h,b
	ld	l,c
	inc	de
	call	getdhx
	ld	a,c	     ;bc=bc-hl
	sub	l
	ld	c,a
	ld	a,b
	sbc	a,h
	ld	b,a
	inc	bc	     ;bc = # OF BYTES TO COMPARE
	inc	de
	push	bc
	call	getdhx
	ld	E,C	     ;de = deSTINATION COMPARE
	ld	D,B
	pop	bc
comp1:	ld	a,(de)
	cp	(hl)	     ;DOES DATA MATCH?
	jp	z,comp3	     ;YES

	call	hexdbl	     ;print 1ST ADDRESS
	ld	a,':'
	call	charout	     ;print A COLON
	ld	a,(hl)
	call	hexout	     ;print DATA
	call	space	     ;print A space & COLON & space
	ld	a,'-'
	call	charout
	call	space
	call	exdehl
	call	hexdbl	     ;print 2ND ADDRESS
	ld	a,':'
	call	charout	     ;print A COLON
	ld	a,(hl)
	call	hexout	     ;print DATA
	call	exdehl
	call	crlf
	push	hl
	call	getch
	cp	cr	     ;WAS A CR HIT ?
	jp	nz,prompt    ;YES

comp3:	inc	hl
	inc	de
	dec	bc
	ld	a,b	     ;ARE WE DONE ?
	or	c
	jp	nz,comp1     ;NOT YET
	jp	prompt

inpt4:	cp	'D'	     ;IS IT A DUMP command ?
	jp	nz,inpt5     ;NO

	ld	a,(frmhrd)  ;GET START ADDRESS IF NONE
	ld	l,a
	ld	a,(frmhrd+1)
	ld	h,a
	ld	a,(de)	     ;GET FOLLOWING DATA IF ANY
	cp	cr	     ;WERE THERE ANY OPTIONS ?
	jr	z,dump2	     ;NO
	call	getdhx	     ;bc = ADDRESS
	ld	h,b
	ld	l,c	     ;hl = START ADDRESS
dump2:	ld	a,8
dump3:	push	af
	push	bc
	call	prntln
	pop	bc
	pop	af
	dec	a
	jr	nz,dump3

	ld	a,l		;save last used address
	ld	(frmhrd),a
	ld	a,h
	ld	(frmhrd+1),a
	jp	prompt

;	push	hl
;	call	input
;	ld	hl,inbuf
;	ld	a,(hl)
;	pop	hl
;	cp	cr	     ;WAS IT A CR ?
;	jr	z,dump2	     ;YES
;	cp	' '	     ;WAS IT A space ?
;	jr	z,dump2	     ;YES
;	jp	prompt

inpt5:	cp	'F'	     ;IS IT A FIND command ?
	jp	nz,inpt6     ;NO

	ld	a,(fndloc)
	ld	l,a
	ld	a,(fndloc+1)
	ld	h,a
	ld	a,(de)
	cp	13	     ;ARE THERE PARAMETERS ?
	jr	z,find4	     ;NO

	call	getdhx
	ld	a,7Fh		;CLEAR STRING
	ld	(fnddat),a
	ld	(fnddat+1),a
	ld	(fnddat+2),a
	ld	(fnddat+3),a
	ld	(fnddat+4),a
	ld	(fnddat+5),a
	ld	(fnddat+6),a
	ld	(fnddat+7),a
	ld	h,b
	ld	l,c	     ;hl = FIND START ADDRESS
	ld	bc,fnddat
find0:	push	bc
	inc	de
	call	getshx
	ld	a,c	     ;A = DATA TO FIND
	pop	bc
	ld	(bc),a
	inc	bc
	ld	a,(de)	     ;IS THERE MORE DATA ?
	cp	cr
	jr	nz,find0     ;YES

find4:	ld	bc,fnddat
	ld	a,l
	ld	(fndloc),a
	ld	a,h
	ld	(fndloc+1),a
find1:	ld	a,(bc)
	cp	7fh	     ;HAVE ALL BYTES CHECKED OUT ?
	jr	z,find3	     ;YES

	cp	(hl)	     ;IS THERE A MATCH ?
	inc	hl
	inc	bc
	jr	z,find1	     ;YES

	dec	bc
	ld	a,(fndloc)
	ld	l,a
	ld	a,(fndloc+1)
	ld	h,a
	inc	hl
	ld	a,h	     ;ARE WE AT THE TOP OF MEMORY ?
	or	l
	jr	nz,find4     ;NO

	call	prntstr
	ld	bc,findeom
	jp	promcl
findeom:
	.byte	"++ END OF MEMORY ++",0
findml:
	.byte	"Memory Location: ",0

find3:	ld	bc,findml
	call	prntstr
	ld	a,(fndloc)
	ld	l,a
	ld	a,(fndloc+1)
	ld	h,a
	call	hexdbl	     ;print ADDRESS
	inc	hl
	ld	a,l
	ld	(fndloc),a
	ld	a,h
	ld	(fndloc+1),a
	jp	promcl

inpt6:	cp	'G'		;IS IT THE GO command ?
	jp	nz,inpih	;NO

	ld	a,0c3h
	ld	(tjmp),a
	call	getdhx	     ;GET ADDRESS TO call
	ld	a,c
	ld	(tjmp+1),a
	ld	a,b
	ld	(tjmp+2),a
	ld	de,goret1
	push	de
	ld	a,(regbc)	;get bc
	ld	c,a
	ld	a,(regbc+1)
	ld	b,a
	ld	a,(regde)	;get de
	ld	e,a
	ld	a,(regde+1)
	ld	d,a
	ld	a,(reghl)	;get hl
	ld	l,a
	ld	a,(reghl+1)
	ld	h,a
	ld	a,(regaf)
	jp	tjmp		;Execute subroutine

goret1:
	ld	(regaf),a	;save a
	ld	a,l		;save hl
	ld	(reghl),a
	ld	a,h
	ld	(reghl+1),a
	ld	a,e		;save de
	ld	(regde),a
	ld	a,d
	ld	(regde+1),a
	ld	a,c		;save bc
	ld	(regbc),a
	ld	a,b
	ld	(regbc+1),a
	jp	prompt

inpih:	cp	'H'	     ;IS IT THE HELP MENU ?
	jp	nz,inpt9     ;NO

;	call	ilprt
;	.byte	cr
;	.byte	'(A)smb-Aaddr    (I)np-Iport      (R)Map '
;	.byte	'(C)mp-Cs1,f1,s2 (J)ump-J         (S)ubst'
;	.byte	'(D)ump-Daddr    (L)ist-Laddr     (X)amin'
;	.byte	'(F)ind-Faddr,xx (M)ove-Ms1,f1,s2 (z)Fill'
;	.byte	'(G)o-Gaddr      (O)ut-Oport,data        '
;	.byte	0
	jp	prompt

inpt9:	cp	'U'	     ;IS IT A LIST command ?
	jr	nz,inp10     ;NO

	ld	a,(frmhrl)  ;GET START ADDRESS IF NONE
	ld	l,a
	ld	a,(frmhrl+1)
	ld	h,a
	ld	a,(de)	     ;GET FOLLOWING DATA IF ANY
	cp	cr	     ;WERE THERE ANY OPTIONS ?
	jr	z,list2	     ;NO

	call	getdhx	     ;bc = ADDRESS
	ld	h,b
	ld	l,c	     ;hl = START ADDRESS
list2:
	call	disasm
	ld	a,l		;save last used address
	ld	(frmhrl),a
	ld	a,h
	ld	(frmhrl+1),a
	jp	prompt

;	push	hl
;	call	input
;	ld	hl,inbuf
;	ld	a,(hl)
;	pop	hl
;	cp	cr	     ;WAS IT A CR ?
;	jr	z,list2	     ;YES
;	cp	' '	     ;WAS IT A space ?
;	jr	z,list2	     ;YES
;	jp	prompt

inp10:	cp	'M'	     ;IS IT A MOVE MEMORY command ?
	jp	nz,inp14     ;NO

	call	getdhx
	push	bc	     ;SAVE START ADDRESS
	inc	de
	call	getdhx	     ;GET LAST ADDRESS
	pop	hl
	push	hl
	ld	a,c	     ;hl=bc-hl
	sub	l
	ld	l,a
	ld	a,b
	sbc	a,h
	ld	h,a
	inc	hl	     ;hl = LENGTH OF MOVE
	push	hl
	inc	de
	call	getdhx	     ;GET deSTINTION ADDRESS
	ld	d,b
	ld	e,c
	pop	bc
	pop	hl
	call	ldir
	jp	prompt

xmap:
	.byte	"Map:R=Rom,X=Ram,?=?",cr,0

inp14:	cp	'X'	     ;IS IT A MEMORY MAP command ?
	jp	nz,inp15     ;NO

	ld	bc,xmap
	call	prntstr
	ld	hl,0
map0:	call	hexdbl
	call	space
	ld	B,8
map1:	ld	C,'X'
	ld	a,(hl)
	cpl
	ld	(hl),a
	cp	(hl)	     ;Is this ram ?
	cpl
	ld	(hl),a
	jr	z,map2	     ;YES

	ld	c,'R'
	ld	a,8	     ;THIS IS ROM OR NO MEMORY
	push	hl
	add	a,(hl)
	add	a,(hl)
	add	a,(hl)
	add	a,(hl)
	add	a,(hl)
	add	a,(hl)
	add	a,(hl)
	add	a,(hl)
	pop	hl	
	jr	nz,map2		;Rom memory

	ld	C,'?'
map2:	ld	a,c
	call	charout
	push	de	     ;hl = hl + 2048
	ld	de,2048
	add	hl,de
	pop	de
	dec	B	     ;ARE WE DONE WITH THIS ROW ?
	jr	nz,map1	     ;NOT YET
	call	crlf
	ld	a,H
	or	l	     ;ARE WE DONE ?
	jp	nz,map0	     ;NOT YET
	jp	prompt

inp15:	cp	'S'	     ;IS IT A subSTITUTE command ?
	jr	nz,inp18     ;NO

	call	getdhx
	ld	h,b
	ld	l,c
	jp	memsub

inp18:	cp	'R'	     ;IS IT A command TO exAMINE REGISTERS ?
	jp	nz,inp20     ;NO

	ld	a,(de)
	inc	de
	cp	cr		;IS IT A CHANGE REGISTER ?
	jp	z,xam20		;NO

	ld	hl,regaf
	ld	bc,4641h
	cp	c	     ;IS IT AF ?
	jr	z,xam5	     ;YES
	inc	hl
	inc	hl
	ld	bc,4342h
	cp	C	     ;IS IT bc ?
	jr	z,xam5	     ;YES
	inc	hl
	inc	hl
	ld	bc,4544h
	cp	C	     ;IS IT de ?
	jr	z,xam5	     ;YES
	inc	hl
	inc	hl
	ld	bc,4C48h
	cp	c		;IS IT hl ?
	jp	nz,badent	;no

xam5:	ld	a,(de)	     ;GET SECOND LETTER
	inc	de
	cp	b	     ;IS IT OKAY ?
	jp	nz,badent    ;NO

	ld	a,c	     ;print REGISTER
	call	charout
	ld	a,b
	call	charout

	ld	a,'='
	call	charout

	ld	e,(hl)
	inc	hl
	ld	d,(hl)
	dec	hl
	call	exdehl
	call	hexdbl	     ;print current data

	call	crlf
	ld	a,':'
	call	charout

	call	input
	ld	hl,inbuf
	ld	a,(hl)
	cp	cr	     ;WAS NOTHING ENTERED?
	jr	z,xam6

	call	exdehl	     ;hl=REGISTER STORAGE:de=DATA BUFFER
	call	getdhx	     ;bc=REGISTER VALUE
	ld	(hl),C
	inc	hl
	ld	(hl),B
xam6:	jp	prompt

regafs:
	.byte	"af=",0
regbcs:
	.byte	" bc=",0
regdes:
	.byte	"de=",0
reghls:
	.byte	" hl=",0
xam20:	ld	bc,regafs
	call	prntstr
	ld	a,(regaf)
	ld	l,a
	ld	a,(regaf+1)
	ld	h,a
	call	hexdbl

	ld	bc,regbcs
	call	prntstr
	ld	a,(regbc)
	ld	l,a
	ld	a,(regbc+1)
	ld	h,a
	call	hexdbl

	call	crlf

	ld	bc,regdes
	call	prntstr
	ld	a,(regde)
	ld	l,a
	ld	a,(regde+1)
	ld	h,a
	call	hexdbl

	ld	bc,reghls
	call	prntstr
	ld	a,(reghl)
	ld	l,a
	ld	a,(reghl+1)
	ld	h,a
	call	hexdbl

	jp	promcl

;*** the above prints this ***

;af=0000 bc=0000
;de=0000 hl=0000

inp20:	cp	'z'	     ;IS IT A FILL command ?
	jp	nz,badent    ;NO

	call	getdhx
	ld	h,b
	ld	l,c
	inc	de
	call	getdhx
	ld	a,c	     ;bc=bc-hl
	sub	l
	ld	c,a
	ld	a,b
	sbc	a,h
	ld	b,a
	inc	bc	     ;bc = # OF BYTES TO FILL
	inc	de
	push	bc
	call	getshx
	ld	d,c	     ;D = BYTE TO FILL MEMORY WITH
	pop	bc
fill0:	ld	(hl),d	     ;FILL MEMORY
	inc	hl
	dec	bc
	ld	a,b
	or	c	     ;ARE WE DONE ?
	jr	nz,fill0

	jp	prompt

badent:	ld	a,'?'
	call	charout
	jp	promcl

;*** print A LINE OF Hex AND ASCII ***

; ENTRY:    hl POINTS TO START ADDRESS
;   First, print the starting address in
;   hex, then a row of hex, then ascii.
; exIT:     hl = hl + 4
;   If at any point bc & hl are equal,
;   then errflg shall be set.

prntln:	xor	a
	ld	(errflg),A   ;RESET error FLAG
	call	hexdbl	     ;print ADDRESS
	push	de
	push	bc
	push	hl	     ;SAVE hl FOR BELOW
	call	space	     ;print A space
	ld	b,4	     ;print 8 Hex BYTES
prntl1:	ld	a,(hl)
	call	hexout		;print memory data in hex
	inc	hl		;point to next byte
	dec	b		;Are we done?
	jr	z,prntl2	;yes
	call	space		;print a space
	jr	prntl1

prntl2:	pop	hl
	pop	de
	ld	b,4	     ;print 4 ASCII BYTES
prntl3:	ld	a,(hl)
	ld	c,'.'	     ;SET deFAULT ASCII CHAR TO A PERIOD
	cp	' '	     ;IS BYTE A NON-ASCII VALUE ?
	jr	c,prntl4     ;YES, print A PERIOD INSTEAD
	cp	80h
	jr	nc,prntl4    ;IS BYTE A NON-ASCII VALUE ?
	ld	c,a	     ;VALUE IS OKAY
prntl4:	ld	a,c	     ;GET CHAR TO charout
	call	charout	     ;print ASCII BYTE
	inc	hl	     ;POINT TO NexT BYTE
	dec	b
	jr	nz,prntl3	;LOOP IF NOT YET DONE
	pop	de
	ret
;
;*** MEMORY subSTITUTE ROUTINE ***

; ENTRY:   hl POINTS TO START ADDRESS.
;    Display the address, the data that
;    is presently there, and wait for
;    user input.

memsub:
	call	hexdbl	     ;print ADDRESS
	call	space	     ;print A space
	ld	a,(hl)	     ;GET DATA AT ADDRESS
	call	hexout	     ;print DATA
	push	hl
	call	inputs	     ;getch FOR AN OPERATOR input
	pop	hl
	ld	de,inbuf
	ld	a,(de)
	cp	cr	     ;DID THE OPERATOR HIT THE ENTER KEY ?
	jp	z,prompt	;yes, exit

	call	getshx	     ;get a hex byte
	ld	(hl),c	     ;subSTITUTE BYTE
memsux:
	inc	hl
	jr	memsub

;*** print A space, THEN input A LINE FROM USER ***

inputs:	call	space

;*** input A LINE OF DATA AT inbuf ENDING WITH A CR ***

input:	ld	b,0
	ld	hl,inbuf
input0:	push	bc
	push	hl
	call	getch
	pop	hl
	pop	bc
	ld	(hl),a	     ;SAVE CHARACTER
	cp	bs	     ;IS IT A BACKspace?
	jp	z,indel	     ;YES
	cp	cr	     ;IS IT A CR?
	jr	z,input5     ;YES
	cp	' '	     ;IS IT TOO LOW?
	jr	c,input1     ;YES
	ld	a,(inlen)
	cp	b	     ;HAVE WE HIT THE LIMIT?
	jr	nz,input3    ;NO
input1:
	ld	a,7
	jr	input0
input2:
	call	cnvtlc
	call	charout
	jr	input0

input3:	ld	a,(hl)
	inc	hl
	inc	b
	jr	input2

indel:	ld	a,b
	or	a	     ;ARE THERE ANY CHARACTERS IN BUFFER ?
	jr	z,input0     ;NO, SO DON'T deLETE

	dec	b
	dec	hl
	ld	a,bs	     ;print a delete
	call	charout
	jp	input0

input5:	call	upcbuf		;convert everything to uppercase
	jp	crlf

; * Convert A to lower case *

cnvtlc:	cp	'A'
	jr	c,cnvtlx
	cp	'Z'+1
	jr	nc,cnvtlx
	add	a,32
cnvtlx:	ret

;*** print HEX NUMBER IN HL ***

hexdbl:	ld	a,h
	call	hexout
	ld	a,l

;*** print HEX NUMBER IN A ***

hexout:	push	af
	push	af
	rrca	
	rrca	
	rrca	
	rrca	
	and	15
	add	a,'0'
	cp	'9'+1
	jr	c,hex1
	add	a,7
hex1:	call	charout
	pop	af
	and	15
	add	a,'0'
	cp	'9'+1
	jr	c,hex2
	add	a,7
hex2:	call	charout
	pop	af
	ret

;*** GET A DECIMAL VALUE OF A HEX DIGIT ***
;EXIT: SET CARRY IF BAD

dval:	cp	'0'	     ;IS VALUE TO LOW ?
	ret	c	     ;YES
	cp	'9'+1	     ;IS IT A NUMBER ?
	jr	nc,dval1     ;NO
	sub	'0'
	ret

dval1:	cp	'A'	     ;IS VALUE TO LOW ?
	ret	c	     ;YES
	cp	'F'+1	     ;IS VALUE TO HIGH ?
	ccf
	ret	c	     ;YES
	sub	'A'-10
	ret

;*** GET SINGLE BYTE HEX VALUE ***
gethx:	push	af
	ld	a,(de)
	inc	de
	call	dval
	jr	c,gethxx	;DIGIT WAS BAD
	rlca
	rlca
	rlca
	rlca
	ld	c,a		;SAVE IN C
	ld	a,(de)
	inc	de
	call	dval
	jr	c,gethxx	;DIGIT WAS BAD
	add	a,c
	ld	c,a		;PUT COMPOSITE IN C
	pop	af
	or	a		;clear carry
	ret

gethxx:	pop	af
	or	a
	ccf
	ret

;*** C = HEX BYTE ***

getshx:	call	gethx
	ret

;*** BC = HEX WORD ***

getdhx:	call	gethx
	jr	c,getdhe
	ld	b,c
	call	gethx
getdhe:	ret

; * Convert everything in inbuf to uppercase *

upcbuf:	push	hl
	ld	hl,inbuf
upcbu1:	ld	a,(hl)
	cp	cr
	jp	z,upcbu3
	cp	'a'
	jr	c,upcbu2
	cp	'z'+1
	jr	nc,upcbu2
	sub	32
	ld	(hl),a
upcbu2:	inc	hl
	jr	upcbu1
upcbu3:	pop	hl
	ret

;********************************
;*	Assembly Data Table	*
;********************************

optbl:	.word	4441H,ZAD,4E41H,ZAN,4942H,ZBI,4143H,ZCA
	.word	4343H,ZCC,5043H,ZCP,4144H,ZDA,4544H,ZDE
	.word	4944H,ZDI,4A44H,ZDJ,4945H,ZEI,5845H,ZEX
	.word	4148H,ZHA,4D49H,ZIM,4E49H,ZIN,504AH,ZJP
	.word	524AH,ZJR,444CH,ZLD,454EH,ZNE,4F4EH,ZNO
	.word	524FH,ZOR,544FH,ZOT,554FH,ZOU,4F50H,ZPO
	.word	5550H,ZPU,4552H,ZRE,4C52H,ZRL,5252H,ZRR
	.word	5352H,ZRS,4253H,ZSB,4353H,ZSC,4553H,ZSE
	.word	4C53H,ZSL,5253H,ZSR,5553H,ZSU,4F58H,ZXO
	.byte	0

;************************************************
;*						*
;*		Assembler Code			*
;*						*
;************************************************

;HL points to address to which to assemble.

assem:	ld	a,l		;SAVE ASSEMBLY ADDRESS
	ld	(pripr),a
	ld	a,h
	ld	(pripr+1),a
	ld	de,optbl     ;POINT TO DATA TABLE
	ld	hl,inbuf     ;POINT TO INPUT DATA
	xor	a
	ld	(errflg),A   ;RESET error FLAG
	ld	(prebsd),A   ;RESET PREFIX FLAG
SRCH1:	ld	a,(de)	     ;ARE WE AT THE END OF THE TABLE?
	inc	de
	or	a
	jp	z,SRCH2	     ;YES
	cp	(hl)	     ;DO THEY MATCH ?
	ld	a,(de)
	inc	de
	inc	de
	inc	de
	jr	nz,SRCH1     ;NO, CHECK MORE
	inc	hl
	cp	(hl)	     ;DOES SECOND ENTRY MATCH ?
	dec	hl
	jr	nz,SRCH1     ;NO, CHECK MORE
	dec	de
	ld	a,(de)
	ld	h,A
	dec	de
	ld	a,(de)
	ld	l,A
	ld	a,0C3H
	ld	(tjmp),A
	ld	a,l
	ld	(tjmp+1),a
	ld	a,h
	ld	(tjmp+2),a
	ld	de,inbuf+2
	ld	hl,(pripr)   ;HL POINTS TO STORAGE
	ld	a,(de)
	jp	tjmp	     ;EXECUTE PROPER ROUTINE

SRCH2:	ld	a,l
	ld	(pripr),a
	ld	a,h
	ld	(pripr+1),a
	jp	error

ERRPO3:	pop	de
ERRPO2:	pop	de
errpop:	pop	de
error:	call	ilprt
	.byte	"?",cr,0
	ld	a,1
	ld	(errflg),A
	ld	a,(prebsd)   ;WAS A PREFIX SAVED ?
	or	a
	ret	z	     ;NO
	dec	hl	     ;YES, COMPHENSATE FOR IT
	ret	

;*** print A comma TO SCREEN ***

comma:	ld	a,','
	jp	charout

;*** WRITE A STRING OF CHARACTERS TO SCREEN ***

ilprt:
	ld	(ilpsaf),a
	ld	a,l
	ld	(ilpsav),a
	ld	a,h
	ld	(ilpsav+1),a
	pop	hl
;
ilprt1:	ld	a,(hl)
	or	a
	jr	z,ilprt2
	call	charout
	inc	hl
	jr	ilprt1
;
ilprt2:
	push	hl
	ld	a,(ilpsav)
	ld	l,a
	ld	a,(ilpsav+1)
	ld	h,a
	ld	a,(ilpsaf)
	ret	

;*** GET A REGISTER FROM BUFFER ***

getsr:	ld	a,(de)
	inc	de
	cp	'A'
	jr	nz,gets1
	ld	a,7
	ret	
gets1:	cp	'B'
	jr	c,gets2
	cp	'E'+1
	jr	nc,gets2
	sub	'B'
	ret	
gets2:	cp	'H'
	jr	nz,gets3
	ld	a,4
	ret	
gets3:	cp	'L'
	jr	nz,gets4
	ld	a,5
	ret	
gets4:	cp	'('
	jp	nz,errpop
	ld	a,(de)
	inc	de
	cp	'H'
	jp	nz,errpop
	ld	a,(de)
	inc	de
	cp	'L'
	jp	nz,errpop
	ld	a,(de)
	inc	de
	cp	')'
	jp	nz,errpop
	ld	a,6
	ret	

;*** GET PRIMARY PAIR ***

getdpr:	push	bc
	ld	a,(de)
	inc	de
	jp	getdx1

;*** GET VALUE OF DOUBLE ***

getdaF:	push	hl
	ld	hl,4641H
	jr	getdx0

getdsp:	push	hl
	ld	hl,5053H

getdx0:	ld	a,l
	ld	(dblpr),a
	ld	a,h
	ld	(dblpr+1),a
	pop	hl
	push	bc
	ld	a,(de)
	inc	de
	ld	bc,0043H
	cp	'B'	     ;IS IT BC ?
	jp	z,getda5     ;YES
	ld	bc,1045H
	cp	'D'	     ;IS IT DE ?
	jp	z,getda5     ;YES
	ld	B,30H	     ;46H
	push	hl
	ld	hl,dblpr+1
	ld	C,(hl)
	dec	hl
	cp	(hl)	     ;IS IT A OR S ?
	pop	hl
	jr	z,getda5     ;YES
getdx1:	ld	bc,204CH
	cp	'H'	     ;IS IT HL ?
	jr	z,getda5     ;YES
	cp	'I'	     ;IS IT A INDEX REGISTER ?
	jp	nz,ERRPO2    ;NO
	ld	a,(de)
	inc	de
	cp	'X'	     ;IS IT IX ?
	ld	C,0DDH
	jr	z,getdi4     ;NO
getda4:	cp	'Y'	     ;IS IT IY ?
	jp	nz,ERRPO2    ;NO
	ld	C,0FDH
getdi4:	ld	a,(prebsd)
	or	a	     ;HAS A PREFIX ALL READY BEEN SAVED ?
	jr	nz,getdi5    ;YES
	ld	(hl),C
	inc	hl
getdi5:	ld	a,B
	ld	(prebsd),A   ;SET PREFIX FLAG
	pop	bc
	ret	
getda5:	ld	a,(de)
	inc	de
	cp	C	     ;DOES SECOND CHARACTER MATCH ?
	jp	nz,ERRPO2    ;NO
	ld	a,B
	pop	bc
	ret	

;*** EAT A comma ***

eatcma:	ld	a,','
	jr	eatc

;*** EAT A space ***

EATSP:	ld	a,' '

;*** EAT CHARACTER IN A ***

eatc:	call	exdehl
	cp	(hl)	     ;ARE THEY THE SAME ?
eatc1:	call	exdehl
	inc	de
	ret	z	     ;YES
	pop	de	     ;GET RID OR retURN ADDRESS
	jp	error

;*** SKIP OVER CHARACTER IN A & A space ***

eatcs:	call	exdehl
	cp	(hl)	     ;ARE THEY THE SAME ?
	inc	hl
	call	exdehl
	jp	nz,error     ;NO
	call	exdehl
	ld	a,' '
	cp	(hl)	     ;IS SECOND BYTE A space ?
	jr	eatc1

;*** GET VALUE OF FLAGS ***

getcV:	push	bc
	push	hl
	ld	hl,PTFLT     ;POINT TO FLAG TABLE
	ld	B,8
getc1:	ld	a,(de)
	cp	(hl)	     ;DO THEY MATCH?
	inc	hl
	jr	z,getc3	     ;YES
getc2:	inc	hl
	dec	B	     ;HAVE WE CHECKED THEM ALL ?
	jr	nz,getc1     ;NOT YET
	pop	hl
	jp	ERRPO2
getc3:	inc	de
	ld	a,(de)
	cp	(hl)	     ;DO THEY MATCH?
	inc	de
	jr	z,getc4	     ;YES
	xor	a
	cp	(hl)	     ;DO THEY MATCH?
	dec	de
	jr	z,getc4	     ;YES
	dec	de
	jr	getc2
getc4:	ld	a,B
	dec	A
	xor	7
	rlca	
	rlca	
	rlca	
	pop	hl
	pop	bc
	ret	

ZAD:	cp	'C'	     ;IS IT ADC ?
	jr	z,ZAD1	     ;YES

	ld	a,'D'
	call	eatcs
	inc	de
	inc	de
	ld	a,(de)
	dec	de
	dec	de
	cp	','	     ;IS IT ADD HL,ss ?
	ld	a,0
	jp	nz,mathr     ;NO
	call	getdpr
	inc	de
	call	getdsp	     ;GET DOUBLE PAIR
	or	9
	ld	(hl),A
	ret	

ZAD1:	inc	de
	call	EATSP
	ld	a,(de)
	cp	'H'	     ;IS IT ADC HL,ss ?
	ld	a,8
	jp	nz,mathr     ;NO
	inc	de
	ld	a,'L'
	call	eatc
	call	eatcma
	call	getdsp	     ;GET DOUBLE PAIR
	or	4AH
	ld	(hl),0EDH
	inc	hl
	ld	(hl),A
	ret	
mathr:	
	ld	B,A
	ld	a,'A'
	call	eatc
	call	eatcma
	ld	a,(de)
	inc	de
	cp	'('	     ;IS IT A INDEX ?
	ld	a,(de)
	jr	z,mathr2     ;YES
	cp	cr	     ;IS IT A REGISTER ?
mathr0:	dec	de
	jr	z,mathr1     ;YES
	call	getshx	     ;C = SINGLE HEX
	ld	a,0C6H
	or	B
	ld	(hl),A
	inc	hl
	ld	(hl),C
	ret	
mathr1:	
	call	getsr	     ;A = SINGLE REGISTER
	or	80H
	or	B
	ld	(hl),A
	ret	
mathr2:	
	cp	'H'	     ;IS IT HL ?
	jr	z,mathr0     ;YES
	inc	de
	inc	de
	inc	de
	call	getshx	     ;C=DISPLACEMENT
	dec	de
	dec	de
	dec	de
	dec	de
	dec	de
	call	getdpr	     ;SAVE PREFIX
	ld	a,86H
	or	B
	ld	(hl),A
	inc	hl
	ld	(hl),C
	ret	
ZAN:	
	ld	a,'D'
	call	eatcs
	ld	a,20H
	jp	mathr
ZBI:	
	ld	a,'T'
	call	eatcs
	ld	a,40H
	jp	BITPS
ZCA:	
	ld	a,'L'	     ;call ADDRESS
	call	eatc
	ld	a,'L'
	call	eatcs
	inc	de
	ld	a,(de)
	inc	de
	cp	','	     ;IS IT A CONDITIONAL call ?
	ld	a,(de)
	dec	de
	dec	de
	jr	z,ZCA1	     ;YES
	cp	','	     ;IS IT A CONDITIONAL call ?
	jr	z,ZCA1	     ;YES
	call	getdhx	     ;BC = DOUBLE HEX VALUE
	ld	(hl),0CDH
	inc	hl
	ld	(hl),C
	inc	hl
	ld	(hl),B
	ret	
ZCA1:	call	getcV	     ;A = FLAG CONDITION CODE
	or	0C4H
	ld	C,A
	call	eatcma
	ld	a,C
	call	getdhx	     ;BC = DOUBLE HEX VALUE
	ld	(hl),A
	inc	hl
	ld	(hl),C
	inc	hl
	ld	(hl),B
	ret	
ZCC:	
	ld	a,'F'
	call	eatc
	ld	(hl),3FH
	ret	
ZCP:	
	cp	'L'	     ;IS IT CPL?
	jr	nz,ZCP0	     ;NO
	ld	(hl),2FH
	ret	
ZCP0:	cp	'I'	     ;IS IT CPI ?
	inc	de
	jr	nz,ZCP1	     ;NO
	ld	a,(de)
	ld	C,0B1H
	cp	'R'	     ;IS IT CPIR ?
	jr	z,ZCPX	     ;YES
	ld	C,0A1H
	cp	13	     ;IS IT CPI ?
	jp	nz,error     ;NO
ZCPX:	ld	(hl),0EDH
	inc	hl
	ld	(hl),C
	ret	
ZCP1:	cp	'D'	     ;IS IT CPD ?
	jr	nz,ZCP2	     ;NO
	ld	a,(de)
	ld	C,0B9H
	cp	'R'	     ;IS IT CPDR ?
	jr	z,ZCPX	     ;YES
	ld	C,0A9H
	cp	13	     ;IS IT CPD ?
	jp	nz,error     ;NO
	jr	ZCPX
ZCP2:	cp	' '	     ;IS IT A CP ?
	jp	nz,error     ;NO
	ld	a,38H
	jp	mathr
ZDA:	
	ld	a,'A'
	call	eatc
	ld	(hl),27H     ;DECIMAL ADJUST A
	ret	
ZDE:	
	ld	a,'C'
	call	eatcs
	ld	a,0BH
	ld	(pripr),A
	ld	B,5
DCICX:	ld	a,(de)
	inc	de
	cp	'('	     ;IS IT A INDEX ?
	ld	a,(de)
	jr	z,ZDE2	     ;YES
	cp	cr	     ;IS IT A REGISTER ?
ZDE0:	dec	de
	jr	z,ZDE1	     ;YES
	call	getdsp
	ld	B,A
	ld	a,(pripr)
	or	B
	ld	(hl),A
	ret	
ZDE1:	
	call	getsr	     ;A = SINGLE REGISTER
	rlca	
	rlca	
	rlca	
	or	B
	ld	(hl),A
	ret	
ZDE2:	
	cp	'H'	     ;IS IT HL ?
	jr	z,ZDE0	     ;YES
	inc	de
	inc	de
	inc	de
	call	getshx	     ;C=DISPLACEMENT
	dec	de
	dec	de
	dec	de
	dec	de
	dec	de
	call	getdpr	     ;SAVE PREFIX
	ld	a,30H
	or	B
	ld	(hl),A
	inc	hl
	ld	(hl),C
	ret	
ZDI:	
	ld	(hl),0F3H    ;DISABLE INTERRUPTS
	ret	
ZDJ:	
	ld	a,'N'	     ;DJNZ
	call	eatc
	ld	a,'Z'
	call	eatcs
	call	getdhx	     ;BC = DOUBLE HEX VALUE
	ld	D,10H
getrel:	
	ld	a,C	     ;BC=BC-HL
	sub	L
	ld	C,A
	ld	a,B
	sbc	a,H
	ld	B,A
	dec	bc
	dec	bc
	ld	a,C
	and	80H	     ;IS IT NEGATIVE ?
	jr	z,ZDJ1	     ;NO
	ld	a,255
ZDJ1:	cp	B	     ;IS IT OUT OF BOUNDS ?
	jp	nz,error     ;YES
	ld	(hl),D
	inc	hl
	ld	(hl),C
	ret	
ZEI:	
	ld	(hl),0FBH    ;ENABLE INTERRUPTS
	ret	
ZEX:	
	inc	de
	cp	'X'	     ;IS IT A EXX ?
	jr	nz,ZEX1	     ;NO
	ld	(hl),0D9H
	ret	
ZEX1:	cp	' '	     ;IS IT BAD ?
	jp	nz,error     ;YES
	ld	a,(de)	     ;GET REG1 1ST BYTE
	cp	'D'	     ;IS IT EX DE,HL ?
	jr	nz,ZEX2	     ;NO
	inc	de
	ld	a,'E'
	call	eatc
	call	eatcma
	ld	a,'H'
	call	eatc
	ld	a,'L'
	call	eatc
	ld	(hl),0EBH
	ret	
ZEX2:	cp	'A'	     ;IS IT EX AF,AF ?
	jr	nz,ZEX3	     ;NO
	inc	de
	ld	a,'F'
	call	eatc
	call	eatcma
	ld	a,'A'
	call	eatc
	ld	a,'F'
	call	eatc
	ld	(hl),8
	ret	
ZEX3:	ld	a,'('	     ;MUST BE A EX (SP),HL
	call	eatc
	ld	a,'S'
	call	eatc
	ld	a,'P'
	call	eatc
	ld	a,')'
	call	eatc
	call	eatcma
	call	getdpr	     ;PLACE PROPER PREFIX
	ld	(hl),0E3H
	ret	
ZHA:	
	ld	a,'L'
	call	eatc
	ld	a,'T'
	call	eatc
	ld	(hl),076H    ;HALT
	ret	
ZIM:	
	call	EATSP
	ld	a,(de)
	ld	C,46H
	cp	'0'	     ;IS IT IM 0 ?
	jr	z,ZIM1	     ;NO
	ld	C,56H
	cp	'1'	     ;IS IT IM 1 ?
	jr	z,ZIM1	     ;NO
	ld	C,5EH
	cp	'2'	     ;IS IT IM 2 ?
	jp	nz,error     ;NO
ZIM1:	ld	(hl),0EDH
	inc	hl
	ld	(hl),C
	ret	
ZIN:	
	inc	de
	cp	'I'	     ;IS IT INI ?
	jr	nz,ZIN1	     ;NO
	ld	a,(de)
	ld	C,0B2H
	cp	'R'	     ;IS IT INIR ?
	jr	z,ZINX	     ;YES
	ld	C,0A2H
	cp	13	     ;IS IT INI ?
	jp	nz,error     ;NO
ZINX:	ld	(hl),0EDH
	inc	hl
	ld	(hl),C
	ret	
ZIN1:	cp	'D'	     ;IS IT IND ?
	jr	nz,ZIN9	     ;NO
	ld	a,(de)
	ld	C,0BAH
	cp	'R'	     ;IS IT INDR ?
	jr	z,ZINX	     ;YES
	ld	C,0AAH
	cp	13	     ;IS IT IND ?
	jp	nz,error     ;NO
	jr	ZINX
ZIN9:	cp	'C'	     ;IS IT inc ?
	jr	nz,ZIN2	     ;NO
	call	EATSP
	ld	a,3
	ld	(pripr),A
	ld	B,4
	jp	DCICX
ZIN2:	dec	de
	call	EATSP	     ;MUST BE AN IN R,R
	call	getsr	     ;A = VALUE OF SINGLE REGISTER
	ld	B,A	     ;SAVE IT
	call	eatcma
	ld	a,'('
	call	eatc
	ld	a,(de)
	cp	'C'	     ;WAS 1ST LETTER IN () A C ?
	jr	nz,ZIN3	     ;NO
	inc	de
	ld	a,(de)
	dec	de
	cp	')'	     ;IS IT THE ONLY THING IN () ?
	jr	nz,ZIN3	     ;NO
	inc	de
	inc	de
	ld	a,B
	rlca	
	rlca	
	rlca	
	or	40H
	ld	(hl),0EDH
	inc	hl
	ld	(hl),A
	ret	
ZIN3:	call	getshx	     ;C = SINGLE BYTE VALUE
	ld	a,')'	     ;REGULAR INPUT
	call	eatc
	ld	a,7
	cp	B	     ;IS REGISTER 1 OKAY ?
	jp	nz,error     ;NO
	ld	(hl),0DBH
	inc	hl
	ld	(hl),C
	ret	
ZJP:	
	call	EATSP	     ;JUMP ABSOLUTE
	inc	de
	ld	a,(de)
	inc	de
	cp	','	     ;IS IT A CONDITIONAL JUMP ?
	ld	a,(de)
	dec	de
	dec	de
	jr	z,ZJP2	     ;YES
	cp	','	     ;IS IT A CONDITIONAL JUMP ?
	jr	z,ZJP2	     ;YES
	ld	a,(de)
	cp	'('	     ;IS IT A INDEXED JUMP?
	jr	z,ZJP1	     ;YES
	call	getdhx	     ;BC = DOUBLE HEX VALUE
	ld	(hl),0C3H
	inc	hl
	ld	(hl),C
	inc	hl
	ld	(hl),B
	ret	
ZJP1:	inc	de
	call	getdpr	     ;IF INDEX REGISTER, SAVE PREFIX
	ld	(hl),0E9H
	ret	
ZJP2:	call	getcV	     ;A = FLAG CONDITION CODE
	or	0C2H
	ld	C,A
	call	eatcma
	ld	a,C
	call	getdhx	     ;BC = DOUBLE HEX VALUE
	ld	(hl),A
	inc	hl
	ld	(hl),C
	inc	hl
	ld	(hl),B
	ret	
ZJR:	
	call	EATSP	     ;JUMP RELATIVE
	inc	de
	ld	a,(de)
	inc	de
	cp	','	     ;IS IT A CONDITIONAL JUMP ?
	ld	a,(de)
	dec	de
	dec	de
	jr	z,ZJR2	     ;YES
	cp	','	     ;IS IT A CONDITIONAL JUMP ?
	jr	z,ZJR2	     ;YES
	call	getdhx	     ;BC = DOUBLE HEX VALUE
	ld	D,18H
	jp	getrel
ZJR2:	call	getcV	     ;A = FLAG CONDITION CODE
	ld	C,A
	call	eatcma
	ld	a,C
	call	getdhx	     ;BC = DOUBLE HEX VALUE
	ld	D,38H
	cp	18H	     ;IS IT JR C ?
	jp	z,getrel     ;YES
	ld	D,30H
	cp	10H	     ;IS IT JR NC ?
	jp	z,getrel     ;YES
	ld	D,28H
	cp	8H	     ;IS IT JR Z ?
	jp	z,getrel     ;YES
	ld	D,20H
	or	a	     ;IS IT JR NZ ?
	jp	z,getrel     ;YES
	jp	error
ZLD:	cp	'I'	     ;IS IT LDI ?
	inc	de
	jr	nz,ZLD1	     ;NO
	ld	a,(de)
	ld	C,0B0H
	cp	'R'	     ;IS IT LDIR ?
	jr	z,ZLDX	     ;YES
	ld	C,0A0H
	cp	13	     ;IS IT LDI ?
	jp	nz,error     ;NO
ZLDX:	ld	(hl),0EDH
	inc	hl
	ld	(hl),C
	ret	
ZLD1:	cp	'D'	     ;IS IT LDD ?
	jr	nz,ZLD2	     ;NO
	ld	a,(de)
	ld	C,0B8H
	cp	'R'	     ;IS IT LDDR ?
	jr	z,ZLDX	     ;YES
	ld	C,0A8H
	cp	13	     ;IS IT LDD ?
	jp	nz,error     ;NO
	jr	ZLDX
ZLD2:	cp	' '	     ;IS IT A LD ?
	jp	nz,error     ;NO
	ld	a,(de)
	inc	de
	cp	'('	     ;IS IT LD ( ?
	jp	z,ZLD20	     ;YES
	ld	a,(de)
	cp	','	     ;IS IT LD ?, ?
	dec	de
	ld	a,(de)
	inc	de
	jr	nz,ZLD6
	ld	C,47H
	cp	'I'	     ;IS IT LD I,A ?
	jr	z,ZLD3	     ;YES
	ld	C,4FH
	cp	'R'	     ;IS IT LD R,A ?
	jr	nz,ZLD6	     ;NO
ZLD3:	call	eatcma
	ld	a,'A'
	call	eatc
ZLD4:	ld	(hl),0EDH
	inc	hl
ZLD5:	ld	(hl),C
	ret	
ZLD6:	cp	'A'	     ;IS IT LD A ?
	jp	nz,ZLD12     ;NO
	call	eatcma
	ld	a,(de)
	ld	C,57H
	cp	'I'	     ;IS IT LD A,I ?
	jr	z,ZLD4	     ;YES
	ld	C,5FH
	cp	'R'	     ;IS IT LD A,R ?
	jr	z,ZLD4	     ;YES
	cp	'('	     ;IS IT LD A,( ?
	jp	nz,ZLD9	     ;NO
	inc	de
	inc	de
	inc	de
	ld	a,(de)
	dec	de
	dec	de
	cp	')'	     ;IS IT A LD A,(??) ?
	ld	a,(de)
	jr	nz,ZLD8	     ;NO
	ld	C,10
	cp	'B'	     ;IS IT LD A,(BC) ?
	jr	z,ZLD5	     ;YES
	ld	C,26
	cp	'D'	     ;IS IT LD A,(de) ?
	jr	z,ZLD5	     ;YES
	jp	ZLD113	     ;GET LD A,(hl)
ZLD8:	
	cp	'I'	     ;IS IT LD A,(I ?
	jr	z,ZLD8H3     ;GET LD A,(IX+DD)
	call	getdhx	     ;GET A LD A,(NNNN)
	ld	(hl),3AH
	inc	hl
	ld	(hl),C
	inc	hl
	ld	(hl),B
	ret	

;*** GET LD r,(IX+DD) ***
;DE POINTS TO FIRST REGISTER

ZLD8H4:	dec	de
ZLD8H3:	dec	de
	dec	de
	dec	de
ZLD8H:	call	getsr
	rlca	
	rlca	
	rlca	
	or	46H
	ld	B,A
	inc	de
	inc	de
	call	getdpr
	inc	de
	call	getshx
	ld	(hl),B
	inc	hl
	ld	(hl),C
	ret	

;*** GET LD (IX+DD),? ***

ZLD9H6:	dec	de
	dec	de
	dec	de
	dec	de
	dec	de
	ld	a,(de)
	cp	'I'	     ;IS IT A INDEX ?
	jp	nz,error     ;NO
	call	getdpr
	inc	de
	call	getshx
	ld	B,C	     ;B = DISP
	inc	de
	inc	de
	inc	de
	inc	de
	ld	a,(de)
	dec	de
	dec	de
	cp	cr	     ;IS IT LD (I??NN?,NN ?
	jr	nz,ZLD9HI    ;NO
	call	getshx	     ;C = IMMED
	ld	(hl),36H
	inc	hl
	ld	(hl),B
	inc	hl
	ld	(hl),C
	ret	
ZLD9HI:	call	getsr	     ;A = REG
	or	70H
	ld	(hl),A
	inc	hl
	ld	(hl),C
	ret	
ZLD9:	
	inc	de
	ld	a,(de)
	cp	cr	     ;IS IT LD A,?<CR> ?
	jr	z,ZLD113     ;YES
	inc	de

;*** GET LD r,nn ***

ZLD104:	dec	de
ZLD103:	dec	de
	dec	de
	dec	de
ZLD10:	call	getsr
	rlca	
	rlca	
	rlca	
	or	6
	ld	B,A
	call	eatcma
	call	getshx
	ld	(hl),B
	inc	hl
	ld	(hl),C
	ret	

;*** GET LD r,r ***

ZLD114:	dec	de
ZLD113:	dec	de
	dec	de
ZLD111:	dec	de
ZLD11:	call	getsr
	rlca	
	rlca	
	rlca	
	ld	B,A
	call	eatcma
	call	getsr
	or	40H
	or	B
	ld	(hl),A
	ret	

ZLD12:	ld	a,(de)
	inc	de
	cp	','	     ;IS IT LD ?, ?
	jr	nz,ZLD13     ;NO
	inc	de
	ld	a,(de)
	cp	cr	     ;IS IT LD ?,?<CR> ?
	jr	z,ZLD113     ;YES
	inc	de
	ld	a,(de)
	cp	cr	     ;IS IT LD ?,??<CR> ?
	jp	z,ZLD104     ;YES
	cp	'L'	     ;IS IT LD ?,??L ?
	jp	z,ZLD114     ;YES
	jp	ZLD8H4
ZLD13:	ld	a,(de)
	inc	de
	cp	','	     ;IS IT LD ??, ?
	jp	nz,error     ;YES
	ld	a,(de)
	cp	'H'	     ;IS IT LD ??,H ?
	jr	z,ZLD14	     ;YES
	cp	'I'	     ;IS IT LD ??,I ?
	jr	nz,ZLD15     ;NO
ZLD14:	dec	de
	dec	de
	dec	de
	ld	a,'S'
	call	eatc
	ld	a,'P'
	call	eatc
	inc	de
	call	getdpr	     ;SAVE PREFIX
	ld	(hl),0F9H
	ret	
ZLD15:	cp	'('	     ;IS IT LD ??,( ?
	dec	de
	dec	de
	dec	de
	jr	z,ZLD17	     ;YES
	call	getdsp	     ;SAVE PREFIX & GET CODE
	inc	A
ZLD16:	inc	de
	call	getdhx	     ;BC = DATA
ZLD16H:	ld	(hl),A
	inc	hl
	ld	(hl),C
	inc	hl
	ld	(hl),B
	ret	
ZLD17:	ld	a,(de)
	cp	'H'	     ;IS IT H?,( ?
	jr	z,ZLD18	     ;YES
	cp	'I'	     ;IS IT I?,( ?
	jr	nz,ZLD19     ;NO
ZLD18:	call	getdpr	     ;SAVE PREFIX
	inc	de
	ld	a,2AH
	jr	ZLD16
ZLD19:	call	getdsp	     ;GET CODE
	or	4BH
	inc	de
	inc	de
	call	getdhx	     ;BC = DATA
	ld	(hl),0EDH
	inc	hl
	jr	ZLD16H
ZLD20:	inc	de
	inc	de
	inc	de
	ld	a,(de)
	inc	de
	cp	','	     ;IS IT LD (???, ?
	ld	a,(de)
	jr	nz,ZLD22     ;NO
	cp	'A'	     ;IS IT LD (??),A ?
	jr	nz,ZLD21
	dec	de
	dec	de
	dec	de
	dec	de
	ld	a,(de)
	ld	C,2
	cp	'B'	     ;IS IT LD (B?),A ?
	jp	z,ZLD5	     ;YES
	ld	C,12H
	cp	'D'	     ;IS IT LD (D?),A ?
	jp	z,ZLD5	     ;YES
	jp	ZLD111	     ;MUST BE LD (hl),A
ZLD21:	
	inc	de
	inc	de
	ld	a,(de)
	dec	de
	dec	de
	dec	de
	cp	cr	     ;IS IT LD (??),?? ?
	jp	z,ZLD104     ;YES
	jp	ZLD114
ZLD22:	
	inc	de
	ld	a,(de)
	cp	')'	     ;IS IT LD (?????) ?
	jp	z,ZLD9H6     ;YES
	cp	','	     ;IS IT LD (?????, ?
	jp	nz,error     ;NO
	dec	de
	dec	de
	dec	de
	dec	de
	dec	de
	call	getdhx	     ;BC = DOUBLE HEX
	inc	de
	inc	de
	ld	a,(de)
	cp	'A'	     ;IS IT LD (NNNN?,A ?
	ld	a,32H
	jp	z,ZLD16H     ;YES
	ld	a,(de)
	cp	'H'	     ;IS IT LD (NNNN?,H ?
	jr	z,ZLD23	     ;YES
	cp	'I'	     ;IS IT LD (NNNN?,I ?
	jr	z,ZLD23
	call	getdsp
	or	43H
	ld	(hl),0EDH
	inc	hl
	jp	ZLD16H
ZLD23:	call	getdpr	     ;SAVE PREFIX
	ld	a,22H
	jp	ZLD16H
ZNE:	
	ld	a,'G'
	call	eatc
	ld	(hl),0EDH    ;NEGATE REGISTER A
	inc	hl
	ld	(hl),44H
	ret	
ZNO:	
	ld	a,'P'	     ;NO OPERATION
	call	eatc
	ld	(hl),0
	ret	
ZOR:	
	call	EATSP
	ld	a,30H
	jp	mathr
ZOT:	
	inc	de
	ld	C,0B3H
	cp	'I'	     ;IS IT OTIR ?
	jr	z,ZOT1	     ;YES
	ld	C,0BBH
	cp	'D'	     ;IS IT OTDR ?
	jp	nz,error     ;NO
ZOT1:	ld	a,'R'
	call	eatc
	ld	(hl),0EDH
	inc	hl
	ld	(hl),C
	ret	
ZOU:	
	ld	a,'T'
	call	eatc
	ld	a,(de)
	inc	de
	ld	C,0A3H
	cp	'I'	     ;IS IT OUTI ?
	jr	z,ZOU1	     ;YES
	ld	C,0ABH
	cp	'D'	     ;IS IT OUTD ?
	jp	nz,error     ;NO
ZOU1:	ld	(hl),0EDH
	inc	hl
	ld	(hl),C
	ret	
ZPO:	
	ld	a,'P'	     ;pop
	call	eatcs
	call	getdaF	     ;GET DOUBLE PAIR
	or	0C1H
	ld	(hl),A
	ret	
ZPU:	
	ld	a,'S'	     ;push
	call	eatc
	ld	a,'H'
	call	eatcs
	call	getdaF	     ;GET DOUBLE PAIR
	or	0C5H
	ld	(hl),A
	ret	
ZRE:	
	inc	de
	cp	'T'	     ;IS IT A retURN ?
	jr	nz,ZRE4	     ;NO
	ld	a,(de)
	cp	13	     ;IS IT A NORMAL retURN ?
	jr	nz,ZRE1	     ;NO
	ld	(hl),0C9H
	ret	
ZRE1:	inc	de
	ld	C,04DH
	cp	'I'	     ;IS IT A INTERRUPT retURN ?
	jr	z,ZRE2	     ;YES
	ld	C,045H
	cp	'N'	     ;IS IT A NON-MASK INT retURN ?
	jr	nz,ZRE3	     ;NO
ZRE2:	ld	(hl),0EDH
	inc	hl
	ld	(hl),C
	ret	
ZRE3:	cp	' '	     ;IS IT A CONDITIONAL retURN ?
	jp	nz,error     ;NO
	call	getcV	     ;A = CONDITION FLAG VALUE
	or	0C0H
	ld	(hl),A
	ret	
ZRE4:	cp	'S'	     ;IS IT A RES ?
	jp	nz,error     ;NO
	inc	de
	ld	a,80H
BITPS:	
	ld	B,A
	ld	a,(de)
	inc	de
	sub	'0'
	cp	8	     ;IS IT TOO HIGH ?
	jp	nc,error     ;YES
	rlca	
	rlca	
	rlca	
	or	B
	ld	B,A
	call	eatcma
	inc	de
	ld	a,(de)
	cp	'I'	     ;IS IT A INDEX REGISTER ?
	jr	z,BITP1	     ;YES
	dec	de
	call	getsr
	or	B
	ld	(hl),0CBH
	inc	hl
	ld	(hl),A
	ret	
BITP1:	call	getdpr	     ;ADD APPROPRIATE PREFIX TO MEMORY
	ld	(hl),0CBH
	inc	hl
	inc	de
	call	getshx	     ;GET DISPLACEMENT
	ld	(hl),C
	inc	hl
	ld	a,6
	or	B
	ld	(hl),A
	ret	
ZRL:	
	inc	de
	cp	' '	     ;IS IT A RL r ?
	ld	C,10H
	jp	z,ROTATE     ;YES
	cp	'C'	     ;IS IT A RLC ?
	ld	C,0
	jr	z,ZRL1	     ;YES
	cp	'A'	     ;IS IT RLA ?
	jr	z,ZRL2	     ;YES
	cp	'D'	     ;IS IT A RLD ?
	jp	nz,error     ;NO
	ld	(hl),0EDH
	inc	hl
	ld	(hl),6FH
	ret	
ZRL1:	ld	a,(de)
	inc	de
	cp	' '	     ;IS IT A RLC r ?
	jp	z,ROTATE     ;YES
	cp	'A'	     ;IS IT rlca ?
	jp	nz,error     ;NO
	ld	(hl),07H
	ret	
ZRL2:	ld	(hl),17H
	ret	
ROTATE:	ld	B,C
	ld	a,(de)
	inc	de
	cp	'('	     ;IS IT A INDEX ?
	jr	z,ROT2	     ;YES
ROT1:	dec	de
	call	getsr	     ;A = SINGLE REGISTER
	ld	(hl),0CBH
	inc	hl
	or	B
	ld	(hl),A
	ret	
ROT2:	
	ld	a,(de)
	cp	'H'	     ;IS IT HL ?
	jr	z,ROT1	     ;YES
	inc	de
	inc	de
	inc	de
	call	getshx	     ;C=DISPLACEMENT
	dec	de
	dec	de
	dec	de
	dec	de
	dec	de
	call	getdpr	     ;SAVE PREFIX
	ld	(hl),0CBH
	inc	hl
	ld	(hl),C
	inc	hl
	ld	a,6
	or	B
	ld	(hl),A
	ret	
ZRR:	
	inc	de
	cp	' '	     ;IS IT A RR r ?
	ld	C,18H
	jp	z,ROTATE     ;YES
	cp	'C'	     ;IS IT A RRC ?
	ld	C,8H
	jr	z,ZRR1	     ;YES
	cp	'A'	     ;IS IT RRA ?
	jr	z,ZRR2	     ;YES
	cp	'D'	     ;IS IT A RRD ?
	jp	nz,error     ;NO
	ld	(hl),0EDH
	inc	hl
	ld	(hl),67H
	ret	
ZRR1:	ld	a,(de)
	inc	de
	cp	' '	     ;IS IT A RRC r ?
	jp	z,ROTATE     ;YES
	cp	'A'	     ;IS IT rrca ?
	jp	nz,error     ;NO
	ld	(hl),0FH
	ret	
ZRR2:	ld	(hl),1FH
	ret	
ZRS:	
	ld	a,'T'
	call	eatcs
	call	getshx	     ;C = SINGLE HEX BYTE
	ld	a,0C7H
	and	C	     ;IS IT A BAD VECTOR ?
	jp	nz,error     ;YES
	ld	a,0C7H
	or	C
	ld	(hl),A
	ret	
ZSB:	
	ld	a,'C'
	call	eatcs
	ld	a,(de)
	cp	'H'	     ;IS IT SBC HL,ss ?
	ld	a,18H
	jp	nz,mathr     ;NO
	inc	de
	ld	a,'L'
	call	eatc
	call	eatcma
	call	getdsp	     ;GET DOUBLE PAIR
	or	42H
	ld	(hl),0EDH
	inc	hl
	ld	(hl),A
	ret	
ZSC:	
	ld	a,'F'
	call	eatc
	ld	(hl),37H
	ret	
ZSE:	
	ld	a,'T'
	call	eatcs
	ld	a,0C0H
	jp	BITPS
ZSL:	
	ld	a,'A'	     ;SLA r
	call	eatcs
	ld	C,20H
	jp	ROTATE
ZSR:	
	cp	'A'	     ;IS IT SRA ?
	ld	C,28H
	jr	z,ZSR1	     ;YES
	cp	'L'	     ;IS IT SRL ?
	ld	C,38H
	jp	nz,error     ;NO
ZSR1:	inc	de
	call	EATSP
	jp	ROTATE
ZSU:	
	ld	a,'B'
	call	eatcs
	ld	a,10H
	jp	mathr
ZXO:	
	ld	a,'R'
	call	eatcs
	ld	a,28H
	jp	mathr

;********************************
;*	Dissassembler Code	*
;********************************

disasm:	ld	B,8
	jr	DISAS
disass:	call	crlf	     ;POINT TO NEXT BYTE
	dec	B	     ;ARE WE DONE YET ?
	ret	z	     ;YES
DISAS:	call	exdehl
	ld	hl,4C48H     ;SET DEFAULT PRIMARY PAIR
	ld	a,l
	ld	(pripr),a
	ld	a,h
	ld	(pripr+1),a
	ld	hl,PTQQT
	ld	a,l
	ld	(savqq),a
	ld	a,h
	ld	(savqq+1),a
	ld	hl,ptsst
	ld	a,l
	ld	(savss),a
	ld	a,h
	ld	(savss+1),a
	call	exdehl
	call	hexdbl	     ;print PRESENT ADDRESS
	call	space	     ;print space BEFORE MNEMONIC
FETCH:	ld	C,(hl)	     ;GET A BYTE
	inc	hl
	ld	a,C
	and	0C0H	     ;ARE 2 MS BITS LOW ?
	jp	z,TOPLOW     ;YES
	cp	040H	     ;IS IT A REGISTER TO REGISTER MOVE ?
	jp	z,REGMOV     ;YES
	cp	080H	     ;IS IT A MATH command ?
	ld	a,C
	jp	z,MATH	     ;YES
;*** TOP TWO BITS ARE HIGH ***
	cp	0CBH	     ;IS IT A PREAMBLE FOR ROTATE & BIT MANIPULATIONS ?
	jp	z,MANIP	     ;YES

TOPHG0:	and	7	     ;Is it a return ?
	jr	nz,TOPHG1    ;no

	ld	a,c
	and	0efh
	cp	0e0h		;is it a ldh ?
	jr	z,tophh0	;yes

	call	ilprt
	.byte	"ret  ",0
	ld	a,C
	call	PTFLG	     ;print APPROPRIATE FLAG
	jp	disass

tophh0:	call	ilprt
	.byte	"ldh  ",0
	inc	hl
	jp	disass

TOPHG1:	dec	A	     ;IS IT pop,ret,PCHL,OR SPHL?
	jp	nz,TOPHG5    ;NO
	ld	a,C
	and	8	     ;IS IT A pop ?
	ld	a,C
	jr	nz,TOPHG2    ;NO
	call	ilprt
	.byte	"pop  ",0
PTQQX:	call	PTQQP	     ;print APPROPRIATE REG PAIR
	jp	disass
TOPHG2:	cp	0C9H	     ;IS IT A ret ?
	jr	nz,TOPHGI    ;NO
	call	ilprt
	.byte	"ret",0
	jp	disass
TOPHGI:	cp	0D9H	     ;IS IT AN RETI ?
	jr	nz,TOPHG3    ;NO
	call	ilprt
	.byte	"reti",0
	jp	disass
TOPHG3:	cp	0E9H	     ;IS IT A PCHL ?
	jr	nz,TOPHG4    ;NO
	call	ilprt
	.byte	"jp   (",0
	call	PTDBP	     ;print PRIMARY PAIR
	jp	ENDPAR
TOPHG4:	call	ilprt
	.byte	"ld   sp,",0
	call	PTDBP	     ;print PRIMARY PAIR
	jp	disass
TOPHG5:	dec	A	     ;IS IT A CONDITIONAL JUMP ?
	jr	nz,TOPHG6    ;NO
	call	ilprt
	.byte	"jp   ",0
PTFCI:	ld	a,c
	call	PTFLG	     ;print APPROPRIATE CONDITION FLAG
	call	comma
PTDBX:	ld	E,(hl)
	inc	hl
	ld	D,(hl)
	inc	hl
	call	exdehl
	call	hexdbl
	call	exdehl
	jp	disass
TOPHG6:	dec	A	     ;IS IT A 11 XXX 011 ?
	jp	nz,TOPH13    ;NO
	ld	a,C
	rrca	
	rrca	
	rrca	
	and	7	     ;IS IT A JUMP ?
	jr	nz,TOPHG7    ;NO
	call	ilprt
	.byte	"jp   ",0
	jp	PTDBX
TOPHG7:	dec	A
	dec	A
	dec	A
	dec	A	     ;IS IT AN XTHL ?
	jr	nz,TOPH10    ;NO
	call	ilprt
	.byte	"ex   (sp),",0
	call	PTDBP	     ;print PRIMARY PAIR
	jp	disass
TOPH10:	dec	A
TOPH11:	dec	A	     ;IS IT A DI ?
	jr	nz,TOPH12    ;NO
	call	ilprt
	.byte	"di",0
	jp	disass
TOPH12:	call	ilprt
	.byte	"ei",0
	jp	disass
TOPH13:	dec	A	     ;IS IT A CONDITIONAL call ?
	jr	nz,TOPH14    ;NO
	call	ilprt
	.byte	"call ",0
	jp	PTFCI	     ;print FLAG, A comma, AND ADDRESS
TOPH14:	dec	A	     ;IS IT push OR call ?
	jr	nz,TOPH16    ;NO
	ld	a,C
	and	8	     ;IS IT A push ?
	ld	a,C
	jr	nz,TOPH15    ;NO
	call	ilprt
	.byte	"push ",0
	jp	PTQQX	     ;print APPROPRIATE REGISTER PAIR
TOPH15:	call	ilprt
	.byte	"call ",0
	jp	PTDBX	     ;print ADDRESS
TOPH16:	dec	A	     ;IS IT IMMEDIATE MATH ?
	jr	nz,TOPH17    ;NO
	ld	a,C
	jp	MATH
TOPH17:	call	ilprt	     ;IT'S A RESTART MNEMONIC
	.byte	"rst  ",0
	ld	a,C	     ;CALCULATE RESTART VECTOR
	and	38H
	call	hexout	     ;print RESTART ADDRESS
	ld	a,'h'
	call	charout	     ;print AN 'H' TO SIGNIFY IT'S HEX
	jp	disass

;*** REGISTER TO REGISTER MOVE ***

REGMOV:	ld	a,C
	cp	76H	     ;IS IT A HALT command ?
	jr	nz,REGMO1    ;NO
	call	ilprt
	.byte	"halt",0
	jp	disass
REGMO1:	call	ilprt
	.byte	"ld   ",0
	call	GTNPT	     ;print REGISTER
	ld	a,C	     ;GET ORIGINAL BYTE

;*** print A comma TO SCREEN ***

PTCREG:	call	comma

PTREGX:	call	PTREG
	jp	disass

;*** print PRIMARY PAIR (HL,IX,IY) ***

PTDBP:	push	af
	ld	a,(pripr)
	call	charout
	ld	a,(pripr+1)
	call	charout
	pop	af
	ret	

;*** GET INSTRUCTION AND print REGISTER ***

GTNPT:	ld	a,C
	rrca	
	rrca	
	rrca	

;*** print REGISTER REPRESENTED IN REGISTER A ***

PTREG:	and	7
	ld	de,PTret
	push	hl
	ld	l,A
	ld	h,0
	ADD	hl,DE
	ld	a,(hl)
	pop	hl
	call	charout
	cp	'('
	ret	NZ
	call	PTDBP	     ;print PRIMARY PAIR
	ld	a,(pripr)
	cp	'I'	     ;IS IT AN INDEX REGISTER ?
	jr	nz,PTREGH    ;NO
	ld	a,(hl)
	rlca	
	rlca	
	and	2
	ADD	a,2BH
	call	charout	     ;print A + OR - DEPENDING ON MSB OF (hl)
	ld	a,(hl)
	inc	hl
	cp	80H	     ;IS IT A NEGATIVE #
	jr	c,PTREGG     ;NO
	CPL	
	inc	A	     ;A=-A
PTREGG:	call	hexout	     ;print DISPLACEMENT
	ld	a,'h'
	call	charout
PTREGH:	call	ilprt
	.byte	")",0
	ret	
PTret:	.byte	"bcdehl(a"

;*** print FLAG FOR RELATIVE JUMP ***

PTRLG:	ld	de,PTRLT
	jr	PTDAT

;*** print DOUBLE PAIR (QQ) ***

PTQQP:	call	exdehl
	ld	hl,(savqq)
	call	exdehl
	jr	PTDAT

;*** print DOUBLE PAIR (SS) ***

ptssp:	call	exdehl
	ld	hl,ptsst
	call	exdehl
	jr	PTDAT

;*** print FLAG REPRESENTED IN REGISTER A ***

PTFLG:	ld	de,PTFLT
PTDAT:	rrca	
	rrca	
	rrca	
	and	7
	push	hl
	ld	l,A
	ld	h,0
	ADD	hl,HL
	ADD	hl,DE
	ld	a,(hl)
	call	charout
	inc	hl
	ld	a,(hl)
	pop	hl
	jp	charout

PTRLT:	.equ	$-6
PTFLT:	.equ	$+2
	.byte	0,0,"nzz",0,"ncc",0,"popep",0,"m",0
PTQQT:	.byte	"bcbcdedehlhlafaf"
ptsst:	.byte	"bcbcdedehlhlspsp"
PTQXT:	.byte	"bcbcdedeixixafaf"
PTSXT:	.byte	"bcbcdedeixixspsp"
PTQYT:	.byte	"bcbcdedeiyiyafaf"
PTSYT:	.byte	"bcbcdedeiyiyspsp"

;*** A RELATIVE JUMP (PROBABLY) ***

RELJMP:	ld	a,C
	rrca		     ;SHIFT FOR EASY USE
	rrca	
	rrca	
	or	a	     ;IS IT A NOP ?
	jr	nz,RELJM1    ;NO
	call	ilprt
	.byte	"nop",0
	jp	disass
RELJM1:	dec	A	     ;IS IT AN LD (*),SP ?
	jr	nz,RELJM2    ;NO
	call	ilprt
	.byte	"ld   (*),SP",27H,0
	jp	disass
RELJM2:	dec	A	     ;IS IT A STOP ?
	jr	nz,RELJM3    ;NO
	call	ilprt
	.byte	"stop",0
	inc	hl
	jp	RELJM4	     ;print ADDRESS
RELJM3:	call	ilprt	     ;IT'S A RELATIVE JUMP
	.byte	"jr   ",0
	ld	a,C
	call	PTRLG	     ;print THE TYPE OF JUMP
	ld	a,C
	cp	18H	     ;IS IT A UNCONDITIONAL JUMP ?
	jr	z,RELJM4     ;YES
	call	comma	     ;print A comma BETWEEN FLAG & ADDRESS
RELJM4:	ld	D,0
	ld	a,(hl)	     ;GET ADDRESS OF RELATIVE JUMP
	inc	hl
	push	hl
	cp	80H	     ;IS IT A NEGATIVE ADDRESS ?
	jr	c,RELJM5     ;NO
	ld	D,255
RELJM5:	ld	E,A
	ADD	hl,DE	     ;HL = BRANCH ADDRESS
	call	hexdbl	     ;print HEX ADDRESS
	pop	hl
	jp	disass

;*** ACCUMULATOR MATHMATICS ***

MATH:	rrca		     ;SETUP A FOR FUNCTION TYPE
	rrca	
	rrca	
	and	7
	push	hl
	ld	D,0
	ld	E,A
	ld	h,D
	ld	l,A
	ADD	hl,HL	     ;HL = A X 2
	ADD	hl,DE	     ;HL = A X 3
	ld	de,PTMHT     ;POINT TO LOOKUP TABLE
	ADD	hl,DE	     ;HL POINTS TO ENTRY
	ld	a,(hl)	     ;GET FIRST BYTE
	call	charout
	inc	hl
	ld	a,(hl)	     ;GET SECOND BYTE
	call	charout
	inc	hl
	ld	a,(hl)	     ;GET THIRD BYTE
	pop	hl
	call	charout
	call	ilprt	     ;print TWO spaceS
	.byte	"  a,",0
	ld	a,C
	and	64	     ;IS IT AN IMMEDIATE ADD ?
	jr	nz,MATH1     ;YES
	ld	a,C
	call	PTREG	     ;print APPROPRIATE REGISTER
	jp	disass
MATH1:	ld	a,(hl)
	inc	hl
	call	hexout	     ;print IMMEDIATE DATA
	jp	disass

PTMHT:	.byte	"addadcsubsbcandxoror cp "
PTRTT:	.byte	"rlcrrcrl rr slasra???srl"

;*** TOP TWO BITS OF INSTRUCTION ARE LOW ***

TOPLOW:	ld	a,c	     ;GET INSTRUCTION
	and	7	     ;IS IT A RELATIVE JUMP command ?
	jp	z,RELJMP     ;PROBABLY
	dec	A	     ;IS IT A LXI OR DAD ?
	jp	nz,TOPLO2    ;NO
	ld	a,C
	and	8	     ;IS IT THE LXI ?
	ld	a,C
	jr	z,TOPLO1     ;YES
	call	ilprt
	.byte	"add  ",0
	call	PTDBP	     ;print PRIMARY PAIR
	call	comma
	call	ptssp	     ;print DOUBLE PAIR
	jp	disass
TOPLO1:	call	ilprt
	.byte	"ld   ",0
	call	ptssp	     ;print DOUBLE PAIR
	call	comma
	ld	E,(hl)	     ;GET TWO BYTE IMMEDIATE DATA
	inc	hl
	ld	D,(hl)
	inc	hl
	call	exdehl
	call	hexdbl	     ;print IMMEDIATE DATA
	call	exdehl
	jp	disass
TOPLO2:	dec	A	     ;IS IT A DOOIE ?
	jp	nz,TOPLO7    ;NO
	call	ilprt
	.byte	"ld   ",0
	ld	a,C
	and	32	     ;IS IT AN IMMEDIATE MOVE ?
	jp	nz,TOPLO4    ;YES
	ld	a,C
	rrca	
	rrca	
	rrca	
	ld	D,A
	and	2
	ADD	a,'B'
	ld	E,A
	ld	a,D
	and	1	     ;IS IT A MOVE INTO REGISTER A ?
	ld	a,E
	jr	z,TOPLO3     ;NO
	call	ilprt
	.byte	"a,(",0
	call	charout	     ;print MS REGISTER
	inc	A
	call	charout	     ;print LS REGISTER
ENDPAR:	
	call	ilprt
	.byte	")",0
	jp	disass
TOPLO3:	call	ilprt
	.byte	"(",0
	call	charout	     ;print MS REGISTER
	inc	A
	call	charout	     ;print LS REGISTER
	call	ilprt
	.byte	"),a",0
	jp	disass
TOPLO4:	call	exdehl
	ld	hl,(pripr)
	call	exdehl
	ld	a,C
	and	16	     ;IS IT A MOVE TO HL ?
	jr	z,TOPLO5     ;YES
	ld	de,0041H
TOPLO5:	ld	a,C
	and	8	     ;IS IMMEDIATE FIRST ?
	jr	z,TOPLO6     ;YES
	ld	a,E
	call	charout	     ;print 1ST LETTER
	ld	a,D
	call	charout	     ;print 2ND LETTER
	call	ilprt
	.byte	",(",0
	ld	E,(hl)
	inc	hl
	ld	D,(hl)
	inc	hl
	call	exdehl
	call	hexdbl	     ;print IMMEDIATE VALUE
	call	exdehl
	jp	ENDPAR	     ;print ENDING PARENTHESIS
TOPLO6:	call	ilprt
	.byte	"(",0
	push	de
	ld	E,(hl)
	inc	hl
	ld	D,(hl)
	inc	hl
	call	exdehl
	call	hexdbl	     ;print IMMEDIATE VALUE
	call	exdehl
	pop	de
	call	ilprt
	.byte	"),",0
PTEDX:	ld	a,E
	call	charout	     ;print 1ST LETTER
PTDX:	ld	a,D
	call	charout	     ;print 2ND LETTER
	jp	disass
TOPLO7:	dec	A	     ;IS IT A DOUBLE PAIR inc OR DEC ?
	jr	nz,TOPL10    ;NO
	ld	a,C
	and	8	     ;IS IT A inc ?
	jr	z,TOPLO8     ;YES
	call	ilprt
	.byte	"dec  ",0
	jr	TOPLO9
TOPLO8:	call	ilprt
	.byte	"inc  ",0
TOPLO9:	ld	a,c
	call	ptssp	     ;print APPROPRIATE REGISTER PAIR
	jp	disass
TOPL10:	dec	A	     ;IS IT A REGISTER inc ?
	jr	nz,TOPL12    ;NO
	call	ilprt
	.byte	"inc  ",0
TOPL11:	ld	a,C
	rrca	
	rrca	
	rrca	
	jp	PTREGX	     ;print APPROPRIATE REGISTER & EXIT
TOPL12:	dec	A	     ;IS IT A REGISTER DEC ?
	jr	nz,TOPL13    ;NO
	call	ilprt
	.byte	"dec  ",0
	jr	TOPL11
TOPL13:	dec	A	     ;IS IT REGISTER IMMEDIATE ?
	jr	nz,TOPL14    ;NO
	call	ilprt
	.byte	"ld   ",0
	call	GTNPT	     ;print APPROPRIATE REGISTER
	call	comma
	ld	a,(hl)
	inc	hl
	call	hexout	     ;print IMMEDIATE DATA
	jp	disass
TOPL14:	ld	a,C	     ;IT'S rlca,rrca,RLA,RRA,SCF,CCF,DAA, OR CPL
	rrca	
	and	01CH
	push	hl
	ld	h,0
	ld	l,A
	ld	de,MISCAT
	ADD	hl,DE
	ld	D,4
TOPL15:	ld	a,(hl)
	inc	hl
	call	charout
	dec	D
	jr	nz,TOPL15
	pop	hl
	jp	disass
MISCAT:	.byte	"rlcarrcarla rra "
	.byte	"daa cpl scf ccf "

;*** BIT ROTATE & MANIPULATION ***

MANIP:	ld	C,(hl)	     ;GET SECONDARY MNEMONIC CODE
	inc	hl
	ld	a,(pripr)    ;DID A 'DD' PRECEDE THIS 'CB' ?
	cp	'I'
	jr	nz,MANI0     ;NO
	ld	C,(hl)	     ;GET SECONDARY MCODE
	inc	hl
	ld	a,(pripr)    ;DID A 'DD' PRECEDE THIS 'CB' ?
	cp	'I'
	jr	nz,MANI0     ;NO
	ld	C,(hl)	     ;GET SECONDARY MNEMONIC CODE
	inc	hl
MANI0:	ld	a,C
	and	0C0H	     ;IS IT A ROTATE command ?
	jp	z,MANI5	     ;YES
	cp	40H	     ;IS IT A BIT command ?
	jr	nz,MANI1     ;NO
	call	ilprt
	.byte	"bit  ",0
	jr	MANI3
MANI1:	cp	80H	     ;IS IT A RESET command ?
	jr	nz,MANI2     ;NO
	call	ilprt
	.byte	"res  ",0
	jp	MANI3
MANI2:	call	ilprt
	.byte	"set  ",0
MANI3:	ld	a,C	     ;GET # OF BITS
	rrca	
	rrca	
	rrca	
	and	7
	ADD	a,'0'	     ;MAKE IT ASCII
	call	charout	     ;print IT
	ld	a,','
	call	charout	     ;print A comma
MANI4:	ld	a,(pripr)
	cp	'I'	     ;IS IT AN INDEX ?
	ld	a,C
	jp	nz,PTREGX    ;NO, print APPROPRIATE REGISTER
	dec	hl
	dec	hl	     ;HL POINTS TO INDEX DISPLACEMENT
	call	PTREG	     ;print INDEX & DISPLACEMENT
	inc	hl
	jp	disass
MANI5:	ld	a,C
	rrca	
	rrca	
	rrca	
	and	7
	push	hl
	ld	D,0
	ld	E,A
	ld	h,D
	ld	l,A
	ADD	hl,HL	     ;HL = A X 2
	ADD	hl,DE	     ;HL = A X 3
	ld	de,PTRTT     ;POINT TO LOOKUP TABLE
	ADD	hl,DE	     ;HL POINTS TO ENTRY
	ld	a,(hl)	     ;GET FIRST BYTE
	call	charout
	inc	hl
	ld	a,(hl)	     ;GET SECOND BYTE
	call	charout
	inc	hl
	ld	a,(hl)	     ;GET THIRD BYTE
	pop	hl
	call	charout
	call	ilprt
	.byte	"  ",0
	jp	MANI4

;*** A BAD MNEMONIC HAS BEEN ENCOUNTERED (MARK IT) ***

BADDMN:	call	ilprt
	.byte	"??=  ",0
	dec	hl
	dec	hl
	ld	a,(hl)
	call	hexout	     ;print 1ST BAD VALUE
	inc	hl
	ld	a,(hl)
	call	hexout	     ;print 2ND BAD VALUE
	inc	hl
	jp	disass


charset:
 .byte 0,0,0,01fh,16,16,16,16			; upper left of box
 .byte 0,0,0,0ffh,0,0,0,0			; upper middle of box
 .byte 0,0,0,0f8h,8,8,8,8			; upper right of box
 .byte 16,16,16,16,16,16,16,16			; left middle of box
 .byte 8,8,8,8,8,8,8,8				; right middle of box
 .byte 10h,10h,10h,10h,01fh,0,0,0		; lower left of box
 .byte 0,0,0,0,0ffh,0,0,0			; lower middle of box
 .byte 8,8,8,8,0f8h,0,0,0			; lower right of box

 .byte 0ffh,0ffh,0e7h,0c3h,0c3h,0e7h,0ffh,0ffh
 .byte 0,3ch,66h,42h,42h,66h,3ch,0
 .byte 7eh,42h,42h,42h,42h,42h,42h,7eh		; space
 .byte 0fh,7,0fh,7dh,0cch,0cch
 .byte 0cch,78h,3ch,66h,66h,66h,3ch,18h,7eh,18h,3fh
 .byte 33h,3fh,30h,30h,70h,0f0h,0e0h,7fh,63h,7fh,63h
 .byte 63h,67h,0e6h,0c0h,99h,5ah,3ch,0e7h,0e7h,3ch,5ah
 .byte 99h,80h,0e0h,0f8h,0feh,0f8h,0e0h,80h,0,2,0eh
 .byte 3eh,0feh,3eh,0eh,2,0,18h,3ch,7eh,18h,18h,7eh
 .byte 3ch,18h,66h,66h,66h,66h,66h,0,66h,0,7fh,0dbh
 .byte 0dbh,7bh,1bh,1bh,1bh,0,3eh,63h,38h,6ch,6ch,38h
 .byte 0cch,78h,0,0,0,0,7eh,7eh,7eh,0,18h,3ch,7eh,18h
 .byte 7eh,3ch,18h,0ffh,18h,3ch,7eh,18h,18h,18h,18h
 .byte 0,18h,18h,18h,18h,7eh,3ch,18h,0,0,18h,0ch,0feh
 .byte 0ch,18h,0,0,0,30h,60h,0feh,60h,30h,0,0,0,0,0c0h
 .byte 0c0h,0c0h,0feh,0,0,0,24h,66h,0ffh,66h,24h,0,0
 .byte 0,18h,3ch,7eh,0ffh,0ffh,0,0,0,0ffh,0ffh,7eh,3ch
 .byte 18h,0,0,0,0,0,0,0,0,0,0,30h,78h,78h,78h,30h,0
 .byte 30h,0,6ch,6ch,6ch,0,0,0,0,0,6ch,6ch,0feh,6ch
 .byte 0feh,6ch,6ch,0,30h,7ch,0c0h,78h,0ch,0f8h,30h
 .byte 0,0,0c6h,0cch,18h,30h,66h,0c6h,0,38h,6ch,38h
 .byte 76h,0dch,0cch,76h,0,60h,60h,0c0h,0,0,0,0,0,18h
 .byte 30h,60h,60h,60h,30h,18h,0,60h,30h,18h,18h,18h
 .byte 30h,60h,0,0,66h,3ch,0ffh,3ch,66h,0,0,0,30h,30h
 .byte 0fch,30h,30h,0,0,0,0,0,0,0,30h,30h,60h,0,0,0
 .byte 0fch,0,0,0,0,0,0,0,0,0,30h,30h,0,6,0ch,18h,30h
 .byte 60h,0c0h,80h,0,7ch,0c6h,0ceh,0deh,0f6h,0e6h,7ch
 .byte 0,30h,70h,30h,30h,30h,30h,0fch,0,78h,0cch,0ch
 .byte 38h,60h,0cch,0fch,0,78h,0cch,0ch,38h,0ch,0cch
 .byte 78h,0,1ch,3ch,6ch,0cch,0feh,0ch,1eh,0,0fch,0c0h
 .byte 0f8h,0ch,0ch,0cch,78h,0,38h,60h,0c0h,0f8h,0cch
 .byte 0cch,78h,0,0fch,0cch,0ch,18h,30h,30h,30h,0,78h
 .byte 0cch,0cch,78h,0cch,0cch,78h,0,78h,0cch,0cch,7ch
 .byte 0ch,18h,70h,0,0,30h,30h,0,0,30h,30h,0,0,30h,30h
 .byte 0,0,30h,30h,60h,18h,30h,60h,0c0h,60h,30h,18h
 .byte 0,0,0,0fch,0,0,0fch,0,0,60h,30h,18h,0ch,18h,30h
 .byte 60h,0,78h,0cch,0ch,18h,30h,0,30h,0,7ch,0c6h,0deh
 .byte 0deh,0deh,0c0h,78h,0,30h,78h,0cch,0cch,0fch,0cch
 .byte 0cch,0,0fch,66h,66h,7ch,66h,66h,0fch,0,3ch,66h
 .byte 0c0h,0c0h,0c0h,66h,3ch,0,0f8h,6ch,66h,66h,66h
 .byte 6ch,0f8h,0,7eh,60h,60h,78h,60h,60h,7eh,0,7eh
 .byte 60h,60h,78h,60h,60h,60h,0,3ch,66h,0c0h,0c0h,0ceh
 .byte 66h,3eh,0,0cch,0cch,0cch,0fch,0cch,0cch,0cch
 .byte 0,78h,30h,30h,30h,30h,30h,78h,0,1eh,0ch,0ch,0ch
 .byte 0cch,0cch,78h,0,0e6h,66h,6ch,78h,6ch,66h,0e6h
 .byte 0,60h,60h,60h,60h,60h,60h,7eh,0,0c6h,0eeh,0feh
 .byte 0feh,0d6h,0c6h,0c6h,0,0c6h,0e6h,0f6h,0deh,0ceh
 .byte 0c6h,0c6h,0,38h,6ch,0c6h,0c6h,0c6h,6ch,38h,0
 .byte 0fch,66h,66h,7ch,60h,60h,0f0h,0,78h,0cch,0cch
 .byte 0cch,0dch,78h,1ch,0,0fch,66h,66h,7ch,6ch,66h
 .byte 0e6h,0,78h,0cch,0e0h,70h,1ch,0cch,78h,0,0fch
 .byte 30h,30h,30h,30h,30h,30h,0,0cch,0cch,0cch,0cch
 .byte 0cch,0cch,0fch,0,0cch,0cch,0cch,0cch,0cch,78h
 .byte 30h,0,0c6h,0c6h,0c6h,0d6h,0feh,0eeh,0c6h,0,0c6h
 .byte 0c6h,6ch,38h,38h,6ch,0c6h,0,0cch,0cch,0cch,78h
 .byte 30h,30h,78h,0,0feh,6,0ch,18h,30h,60h,0feh,0,78h
 .byte 60h,60h,60h,60h,60h,78h,0,0c0h,60h,30h,18h,0ch
 .byte 6,2,0,78h,18h,18h,18h,18h,18h,78h,0,10h,38h,6ch
 .byte 0c6h,0,0,0,0,0,0,0,0,0,0,0,0ffh,30h,30h,18h,0
 .byte 0,0,0,0,0,0,78h,0ch,7ch,0cch,76h,0,0e0h,60h,60h
 .byte 7ch,66h,66h,0dch,0,0,0,78h,0cch,0c0h,0cch,78h
 .byte 0,1ch,0ch,0ch,7ch,0cch,0cch,76h,0,0,0,78h,0cch
 .byte 0fch,0c0h,78h,0,38h,6ch,60h,0f0h,60h,60h,0f0h
 .byte 0,0,0,76h,0cch,0cch,7ch,0ch,0f8h,0e0h,60h,6ch
 .byte 76h,66h,66h,0e6h,0,30h,0,70h,30h,30h,30h,78h
 .byte 0,0ch,0,0ch,0ch,0ch,0cch,0cch,78h,0e0h,60h,66h
 .byte 6ch,78h,6ch,0e6h,0,70h,30h,30h,30h,30h,30h,78h
 .byte 0,0,0,0cch,0feh,0feh,0d6h,0c6h,0,0,0,0f8h,0cch
 .byte 0cch,0cch,0cch,0,0,0,78h,0cch,0cch,0cch,78h,0
 .byte 0,0,0dch,66h,66h,7ch,60h,0f0h,0,0,76h,0cch,0cch
 .byte 7ch,0ch,1eh,0,0,0dch,76h,66h,60h,0f0h,0,0,0,7ch
 .byte 0c0h,78h,0ch,0f8h,0,10h,30h,7ch,30h,30h,34h,18h
 .byte 0,0,0,0cch,0cch,0cch,0cch,76h,0,0,0,0cch,0cch
 .byte 0cch,78h,30h,0,0,0,0c6h,0d6h,0feh,0feh,6ch,0
 .byte 0,0,0c6h,6ch,38h,6ch,0c6h,0,0,0,0cch,0cch,0cch
 .byte 7ch,0ch,0f8h,0,0,0fch,98h,30h,64h,0fch,0,1ch
 .byte 30h,30h,0e0h,30h,30h,1ch,0,18h,18h,18h,0,18h
 .byte 18h,18h,0,0e0h,30h,30h,1ch,30h,30h,0e0h,0,76h
 .byte 0dch,0,0,0,0,0,0,0,10h,38h,6ch,0c6h,0c6h,0feh,0

down:
.byte		"                    "
.byte		"            "
the_text:
.byte		32,32,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,32,32
.byte		"            "
.byte		32,32,3
.byte		" GBDebug V1.3 "
.byte		4,32,32
.byte		"            "
.byte		32,32,5,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,32,32
.byte		"            "
.byte		"         by         "
.byte		"            "
.byte		"   Jeff Frohwein    "
.byte		"            "
.byte		"                    "
.byte		"            "
.byte		"jfrohwei@HiWAAY.net "
.byte		"            "
.byte		1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
.byte		"            "
.byte		" Special Thanks to: "
.byte		"            "
.byte		"HeroZero            "
.byte		"            "
.byte		" Example GB Code    "
.byte		"            "
.byte		"Marat Fayzullin     "
.byte		"            "
.byte		" GameBoy WWW Central"
.byte		"            "
.byte		"Dr.Pan of Anthrox   "
.byte		"            "
.byte		" Excellent GB Info  "
.byte		"            "
.byte		"                    "
.byte		"            "
.byte		"   [Press START!]   "
.byte		"            "
.byte		"                    "
.byte		"            "

.end
