program Crc;

{ Generate Complement & CRC for GameBoy Object Code }
{   by Jeff Frohwein, 26-Oct-95 }

uses Crt;

var
 comp,high,low:byte;
 s:string[10];
 Buf:array[1..32768] of byte;

function hex(b:byte):char;
 begin
  if b<10 then
   hex:=chr(ord('0')+b)
  else
   hex:=chr(ord('a')+b-10);
 end;

function hex8(b:byte):string;
 begin
  hex8:=concat(hex(b shr 4),hex(b and 15));
 end;

function hex16(w:word):string;
 begin
  hex16:=concat(hex8(w shr 8),hex8(w and 255));
 end;

procedure clear_the_buffer;
 var
  i:word;
 begin
  for i:=1 to 32768 do
   Buf[i]:=$00;
 end;

function file_exists(fname:string):boolean;
 var f:file;
 begin
  {$I-}
  assign(f,fname);
  reset(f);
  close(f);
  {$I+}
  file_exists:=(IOResult=0) and (fname<>'');
 end;

function load_and_checksum_file:Word;
 var
  loop:byte;
  f:file;
  check,Crc,NumRead,z:Word;

 begin

  if file_exists(ParamStr(1)) then
   begin

    {Load Configuration}

    Assign(f,ParamStr(1));
    Reset(f,1);
    check:=0;
    crc:=0;
    loop:=0;
    repeat
     BlockRead(f,Buf,SizeOf(Buf),NumRead);
     if loop=0 then
      begin
       high:=Buf[$14e+1];
       low:=Buf[$14f+1];
      end;
     if NumRead<>0 then
      for z:=1 to NumRead do
       begin
        if loop=0 then
         begin
          if (z>$100) and (z<$14e) then
           check:=check+Buf[z];
          if (z<>$14f) and (z<>$150) then
           crc:=crc+Buf[z];
         end
        else
         crc:=crc+Buf[z];
       end;
     inc(loop);
    until (NumRead=0);
    check:=check+25;
    comp:=lo(check);
    comp:=(comp xor 255)+1;
    high:=hi(crc);
    low:=lo(crc);
    Close(f);
   end
  else
   begin
    writeln('File ',ParamStr(1),' not found.')
   end;
  load_and_checksum_file:=crc;
 end;

procedure save_file;
 var
  f:file;
  NumWritten:Word;
 begin
  assign(f,Paramstr(2));
  Rewrite(f,1);
  Blockwrite(f,Buf,32768,NumWritten);
  Close(f);
 end;

begin
 writeln('** Checksum GameBoy Snapshots V1.1 **, Jeff Frohwein, 27-Oct-95');
 writeln;

 if length(ParamStr(2))=0 then
  writeln('Usage: crc inputfile outputfile')
 else
  begin
   clear_the_buffer;
   s:=hex16(load_and_checksum_file);
{   Buf[$14d+1]:=comp;}
   Buf[$14e+1]:=high;
   Buf[$14f+1]:=low;
   save_file;
  end;
end.
