
  opt   l+,o+,ow+,ow1-,ow2-,ow6-,d+,CHKIMM


	xref _testCPointerFromAsm
	xref _TestCFuncFromAsm
	xref SystemStartup
	xref SystemShutdown
	xref P61_Init
	xref P61_Music
	xref P61_End

	xdef _main

	xref _GfxBase

        section mycode,code             ; need not be in chipram
        include "exec/exec.i"           ; the includes!
        include "include/exec_lib.i"        ; They keep on
        include "include/graphics_lib.i"    ; Well done CBM!
        include "hardware/intbits.i"


VersionString	dc.b	0,"$VER: MyDemo 3.0 Feb 5 2012",0
		even

_main:		;startup code is complete, this is where the main code starts,  - called from startup.asm
		tst.w	d0				;is it pal
        bne		.quitOnStartup	;not pal, exit now!


		lea		$dff000,a6

        move.l	#mycopper,$80(a6)       ; bang it straight in.

		lea		Module1,a0		;the P61converted module you want to start
		moveq	#0,d0		;if CIA=1: 1=PAL,2=NTSC,0=auto (only if exec=1)
		sub.l	a1,a1		;0 if no external samples
		sub.l	a2,a2		;if crunched samples: Samplebuffer-addr
		bsr		P61_Init		;Init. Trashes all but a6, d0=0 on return if ok


.lp0
		btst    #6,$bfe001              ; make sure mouse is NOT held down when starting (avoid instant exit)
        beq.s   .lp0


        move.l   $4.w,a6
	    moveq.l  #INTB_VERTB,d0
        lea      VBlankServer(pc),a1
        jsr      _LVOAddIntServer(a6)       ;Add my interrupt to system list

.lp

;		move.w	#$0f0,d0
;		lea		$dff180,a0
;		jsr		_TestCFuncFromAsm

		btst    #6,$bfe001              ; ok.. I'll do an input
        bne.s   .lp                     ; handler next time.

        move.l   $4.w,a6
        moveq.l  #INTB_VERTB,d0		       ;Change for copper interrupt.
        lea      VBlankServer(pc),a1
        jsr      _LVORemIntServer(a6)         ;Remove my interrupt

		lea		$dff000,a6
		bsr		P61_End
.quitOnStartup
		rts


VBlankServer:
      dc.l  0,0                     ;ln_Succ,ln_Pred
      dc.b  NT_INTERRUPT,12                     ;ln_Type,ln_Pri
      dc.l  VBlankName                 ;ln_Name
      dc.l  $dff000,VBlankInterrupt             ;is_Data,is_Code
VBlankName:
      dc.b "VBlank",0
      EVEN


VBlankInterrupt:
      movem.l  d2-d7/a2-a4,-(sp)    ; all other registers can be trashed
      move.l	a1,a6			;$dff000 - coming from is_data
      bsr		P61_Music		;P61_Music. Trashes all, a6=$dff000+C at exit.
      movem.l  (sp)+,d2-d7/a2-a4

;     If you set your interrupt to priority 10 or higher then
;     a0 must point at $dff000 on exit.
	
      lea		$dff000,a0
      moveq    #0,d0                ; must set Z flag on exit!
      rts                           ;Not rte!!!





;register rules for assembler functions called from c:
;d0/d1/a0/a1: are VOLATILE: they can be trashed when passing to a func. 
;d2-d7/a2-a6: had to keep the same when coming back from a func.



	xdef _TestAsmFuncFromC
;input d2 testvariable
;output d0 testvariable+$0f0

_TestAsmFuncFromC:
	move	d2,d0
	add		#$0f0,d0
	rts



        section mydata,data_c           ;  keep data & code seperate!

mycopper        dc.w    $100,$0200      ; otherwise no display!
                dc.w    $180,$00
                dc.w    $8107,$fffe     ; wait for $8107,$fffe
                dc.w    $180
                dc.w    $f0f            ; background red
                dc.w    $d607,$fffe     ; wait for $d607,$fffe
                dc.w    $180,$ff0       ; background yellow
                dc.w    $ffff,$fffe
                dc.w    $ffff,$fffe



	SECTION MUSIC,DATA_C
Module1:
	INCBIN "dh0/assets/P61.sowhat-intro"
	END
