
*=======================================================================*
*									*
* 	VIC-20 EMULATOR FOR AMIGA					*
*	(C) 1993-1994 HKAN SUNDELL 					*
*									*
*=======================================================================*

*=======================================================================*
*	INCLUDES							*
*=======================================================================*

		include	exec/exec_lib.i
		include	exec/execbase.i
		include	exec/initializers.i
		include	exec/memory.i
		include	exec/libraries.i
		include	exec/resident.i
		include	graphics/gfxbase.i
		include	graphics/graphics_lib.i
		include intuition/intuition.i
		include	resources/cia.i
		include	resources/cia_lib.i
		include	hardware/custom.i
		include	hardware/cia.i
		include	hardware/dmabits.i
		include	hardware/intbits.i

*=======================================================================*
*	EXTERNAL REFERENCES						*
*=======================================================================*
		xref	_custom,_ciaa,_ciab

*=======================================================================*
*									*
*	CODE SECTION							*
*									*
*=======================================================================*
		section	VIC20Code_library,CODE
*-----------------------------------------------------------------------*

*=======================================================================*
*	LIBRARY STARTUP							*
*=======================================================================*
		moveq	#-1,d0
		rts

*=======================================================================*
*	RESIDENT ROMTAG STRUCTURE					*
*=======================================================================*
MYPRI		EQU	0

RomTagStruct	dc.w	RTC_MATCHWORD
		dc.l	RomTagStruct
		dc.l	EndOfLibrary
		dc.b	RTF_AUTOINIT
		dc.b	VIC20LIB_VERSION
		dc.b	NT_LIBRARY
		dc.b	MYPRI
		dc.l	LibraryName
		dc.l	LibraryIDString
		dc.l	AutoInitTable

LibraryName	VIC20LIB_NAME
LibraryIDString	VIC20LIB_IDSTRING
		VIC20LIB_COPYRIGHT

AutoInitTable	dc.l	vcb_SIZEOF
		dc.l	AutoInitVectors
		dc.l	AutoInitStructure
		dc.l	AutoInitFunction

AutoInitVectors	;***** Standard System Routines *****
		dc.l	@Open
		dc.l	@Close
		dc.l	@Expunge
		dc.l	@Null

		;****** Public Routines ******
		dc.l	@AllocEmulResource
		dc.l	@FreeEmulResource

		dc.l	-1

AutoInitStructure
		INITBYTE	LN_TYPE,NT_LIBRARY
		INITLONG	LN_NAME,LibraryName
		INITBYTE	LIB_FLAGS,LIBF_SUMUSED!LIBF_CHANGED
		INITWORD	LIB_VERSION,VIC20LIB_VERSION
		INITWORD	LIB_REVISION,VIC20LIB_REVISION
		INITLONG	LIB_IDSTRING,LibraryIDString
		dc.l	0

AutoInitFunction
		movem.l	a2/a5,-(a7)
		move.l	d0,a5
		move.l	a6,vic_SysLib(a5)
		move.l	a0,vic_SegList(a5)
		move.l	a5,_VIC20Base

		move.l	a5,d0
		movem.l	(a7)+,a2/a5
		rts

@Open		addq.w	#1,LIB_OPENCNT(a6)
		bclr	#LIBB_DELEXP,vic_Flags(a6)
		cmp.w	#1,LIB_OPENCNT(a6)
		bhi.s	.end

		clr.w	vic_EmulResourceFlag(a6)

.end		move.l	a6,d0
		rts

@Close		moveq	#$00,d0
		subq.w	#1,LIB_OPENCNT(a6)
		bne.s	.1
		bsr	@FreeEmulResource
		btst	#LIBB_DELEXP,vic_Flags(a6)
		beq.s	.1
		bsr.s	@Expunge
.1		rts

@Expunge	movem.l	d2/a5/a6,-(a7)
		move.l	a6,a5
		move.l	vic_SysLib(a5),a6
		tst.w	LIB_OPENCNT(a5)
		beq.s	.1
		bset	#LIBB_DELEXP,vic_Flags(a5)
		moveq	#$00,d0
		bra.s	.2
.1		move.l	vic_SegList(a5),d2
		move.l	a5,a1
		CALLEXEC Remove
		moveq	#$00,d0
		move.l	a5,a1
		move.w	LIB_NEGSIZE(a5),d0
		sub.l	d0,a1
		add.w	LIB_POSSIZE(a5),d0
		CALLEXEC FreeMem
		move.l	d2,d0
.2		movem.l	(a7)+,d2/a5/a6
		rts

@Null		moveq	#$00,d0
		rts

*=======================================================================*
*	MAIN ROUTINES							*
*=======================================================================*
@AllocEmulResource
		;CALLEXEC Forbid
		movem.l	d2-d7/a2-a6,-(a7)
		tst.w	vic_EmulResourceFlag(a6)
		beq.s	.LibOK
		moveq	#SID_LIBINUSE,d0
		bra.s	.Exit
.LibOK		bsr	AllocEmulMem
		tst.l	d0
		bne.s	.Exit
.MemOK		bsr	CheckCPU
		bsr	OpenLibraries
		bsr	Make6502Emulator
		bsr	MakeMMUTable
		bsr	MakeSamples
		bsr	MakeMultiColor
		bsr	MakeHiresTable
		bsr	CopyRom
		bsr	EnableRomBreak
		movem.w	Vic20Regs,d0-d7
		move.w	#$3400,d5
		move.w	#$fd22,d6
		move.w	#$00ff,d7
		movem.w	d0-d7,Vic20Regs
		move.w	#$4000,$dff09a
		lea	SaveCIAAmiga,a0
		bsr	ReadCIA
		bsr	InitCIA
		lea	SaveCIAC64,a0
		bsr	ReadCIA
		lea	SaveCIAAmiga,a0
		bsr	WriteCIA
		move.w	#$c000,$dff09a
		move.w	#1,vic_EmulResourceFlag(a6)
		moveq	#0,d0
.Exit		movem.l	(a7)+,d2-d7/a2-a6
		;CALLEXEC Permit
		rts

*-----------------------------------------------------------------------*
@FreeEmulResource
		;CALLEXEC Forbid
		movem.l	d2-d7/a2-a6,-(a7)
		tst.w	vic_EmulResourceFlag(a6)
		beq.s	.Exit
		bsr	@StopSong
		bsr	FreeEmulMem
		clr.w	vic_EmulResourceFlag(a6)
.Exit		movem.l	(a7)+,d2-d7/a2-a6
		;CALLEXEC Permit
		rts

*-----------------------------------------------------------------------*
AllocEmulMem
		ALLOC	vic_PrgMem(a6),PRGMEM_SIZE,MEMF_PUBLIC
		beq	.Error
		ALLOC	vic_MMUMem(a6),MMUMEM_SIZE,MEMF_PUBLIC
		beq.s	.Error
		ALLOC	vic_VIC20Mem(a6),VIC20MEM_SIZE,MEMF_PUBLIC
		beq.s	.Error
		ALLOC	vic_RemVideoPixels(a6),VIDEOMEM_SIZE,MEMF_PUBLIC
		beq.s	.Error
		ALLOC	vic_RemColorMatrix(a6),COLORMEM_SIZE,MEMF_PUBLIC
		beq.s	.Error
		ALLOC	vic_MultiColorTable(a6),MULTICOLORMEM_SIZE,MEMF_PUBLIC
		beq.s	.Error
		ALLOC	vic_HiresTable(a6),HIRESMEM_SIZE,MEMF_PUBLIC
		beq.s	.Error
		ALLOC	vic_RasterStack1Mem(a6),RASTER1MEM_SIZE,MEMF_PUBLIC
		beq.s	.Error
		ALLOC	vic_RasterStack2Mem(a6),RASTER2MEM_SIZE,MEMF_PUBLIC
		beq.s	.Error
		ALLOC	vic_SampleMem(a6),SAMPLEMEM_SIZE,MEMF_PUBLIC|MEMF_CHIP
		beq.s	.Error
		ALLOC	vic_Copper1Mem(a6),COPPER1MEM_SIZE,MEMF_PUBLIC|MEMF_CHIP
		beq.s	.Error
		ALLOC	vic_Copper2Mem(a6),COPPER2MEM_SIZE,MEMF_PUBLIC|MEMF_CHIP
		beq.s	.Error
		ALLOC	vic_ScreenMem(a6),SCREENMEM_SIZE,MEMF_PUBLIC|MEMF_CHIP
		beq.s	.Error
		moveq	#0,d0
		rts

.Error		bsr	FreeEmulMem
		moveq	#VIC_NOMEMORY,D0
		rts

*-----------------------------------------------------------------------*
CheckCPU	move.l	$4.w,a0
		move.w	AttnFlags(a0),psb_CPUVersion(a6)
		rts

*-----------------------------------------------------------------------*
FreeEmulMem
		FREE	vic_PrgMem(a6),PRGMEM_SIZE
		FREE	vic_MMUMem(a6),MMUMEM_SIZE
		FREE	vic_VIC20Mem(a6),VIC20MEM_SIZE
		FREE	vic_RemVideoPixels(a6),VIDEOMEM_SIZE
		FREE	vic_RemColorMatrix(a6),COLORMEM_SIZE
		FREE	vic_MultiColorTable(a6),MULTICOLORMEM_SIZE
		FREE	vic_HiresTable(a6),HIRESMEM_SIZE
		FREE	vic_RasterStack1Mem(a6),RASTER1MEM_SIZE
		FREE	vic_RasterStack2Mem(a6),RASTER2MEM_SIZE
		FREE	vic_SampleMem(a6),SAMPLEMEM_SIZE
		FREE	vic_Copper1Mem(a6),COPPER1MEM_SIZE
		FREE	vic_Copper2Mem(a6),COPPER2MEM_SIZE
		FREE	vic_ScreenMem(a6),SCREENMEM_SIZE
		rts

*=======================================================================*


_OpenVIC
	movem.l	d2-d7/a2-a6,-(a7)
	bsr	OpenLibraries
	move.l	$4.w,a6
	move.w	AttnFlags(a6),CPUVersion
	bsr	Make6502Emulator
	bsr	MakeMMUTable
	jsr	MakeSamples
	jsr	MakeMultiColor
	jsr	MakeHiresTable
	bsr	CopyRom
	bsr	EnableRomBreak
	movem.w	Vic20Regs,d0-d7
	move.w	#$3400,d5
	move.w	#$fd22,d6
	move.w	#$00ff,d7
	movem.w	d0-d7,Vic20Regs
	move.w	#$4000,$dff09a
	lea	SaveCIAAmiga,a0
	bsr	ReadCIA
	bsr	InitCIA
	lea	SaveCIAC64,a0
	bsr	ReadCIA
	lea	SaveCIAAmiga,a0
	bsr	WriteCIA
	move.w	#$c000,$dff09a
	movem.l	(a7)+,d2-d7/a2-a6
	rts

_CloseVIC
	movem.l	d2-d7/a2-a6,-(a7)
	bsr	CloseLibraries
	movem.l	(a7)+,d2-d7/a2-a6
	rts

_ContVIC
	movem.l	d2-d7/a2-a6,-(a7)
	bsr	MakeMMUTable
	bsr	MainLoop
	movem.l	(a7)+,d2-d7/a2-a6
	rts

_ResetVIC
	movem.l	d2-d7/a2-a6,-(a7)
        bsr	CopyRom
	bsr	EnableRomBreak
	bsr	MakeMMUTable
	clr.w	VideoAdress
	movem.w	Vic20Regs,d0-d7
	move.w	#$3400,d5
	move.w	#$fd22,d6
	move.w	#$00ff,d7
	movem.w	d0-d7,Vic20Regs
	move.w	#$4000,$dff09a
	lea	SaveCIAAmiga,a0
	bsr	ReadCIA
	bsr	InitCIA
	lea	SaveCIAC64,a0
	bsr	ReadCIA
	lea	SaveCIAAmiga,a0
	bsr	WriteCIA
	move.w	#$c000,$dff09a
	bsr	MainLoop
	movem.l	(a7)+,d2-d7/a2-a6
	rts

_SaveScreen
	rts

ClearVBR
	movem.l	a5-a6,-(a7)
	tst.w	CPUVersion
	beq.s	.Exit
	move.l	a7,d0
	CALLEXEC SuperState
	movec	VBR,a0
	move.l	a0,OldVBR
	sub.l	a0,a0
	movec	a0,VBR
	CALLEXEC UserState
.Exit
	movem.l	(a7)+,a5-a6
	rts

RestoreVBR
	movem.l	a5-a6,-(a7)
	tst.w	CPUVersion
	beq.s	.Exit
	move.l	a7,d0
	CALLEXEC SuperState
	move.l	OldVBR,a0
	movec	a0,VBR
	CALLEXEC UserState
.Exit
	movem.l	(a7)+,a5-a6
	rts

OpenLibraries
	move.l	a6,-(a7)
	lea	GfxName,a1
	CALLEXEC OldOpenLibrary
	move.l	d0,_GfxBase
	move.l	(a7)+,a6
	rts

CloseLibraries
	move.l	a6,-(a7)
	move.l	_GfxBase,a1
	CALLEXEC CloseLibrary
	move.l	(a7)+,a6
	rts

EnableCopperList
	movem.l	a5-a6,-(a7)
	lea	$dff000,a5
	move.l	_GfxBase,a6
	move.l	gb_copinit(a6),OldCopper1
	move.l	gb_LOFlist(a6),OldCopper2
	move.l	#CopperList,gb_copinit(a6)
	move.l	#CopperListDummy,gb_LOFlist(a6)
	move.l	#CopperListDummy,Copper2List
	clr.b	Copper2Nr
	move.l	gb_copinit(a6),$0080(a5)
	move.l	gb_LOFlist(a6),$0084(a5)
	move.w	$0002(a5),OldDMAENA
	move.w	#$002f,$0096(a5)
	move.w	#$87c0,$0096(a5)
	movem.l	(a7)+,a5-a6
	rts

DisableCopperList
	movem.l	a5-a6,-(a7)
	lea	$dff000,a5
	move.l	_GfxBase,a6
	move.l	OldCopper1,gb_copinit(a6)
	move.l	OldCopper2,gb_LOFlist(a6)
	move.w	OldDMAENA,d0
	or.w	#$8000,d0
	move.w	d0,$0096(a5)
	move.l	gb_copinit(a6),$0080(a5)
	move.l	gb_LOFlist(a6),$0084(a5)
	movem.l	(a7)+,a5-a6
	rts

CopyRom
	movem.l	d0/a0-a1,-(a7)
	lea	VIC20Mem,a0
	lea	CharRomMem,a1
	move.w	#$03ff,d0
.4
	move.l	(a1)+,(a0)+
	dbf	d0,.4
	lea	$1000(a0),a0
	lea	CartRomMem,a1
	move.w	#$07ff,d0
.1
	move.l	(a1)+,(a0)+
	dbf	d0,.1
	lea	BasicRomMem,a1
	move.w	#$07ff,d0
.2
	move.l	(a1)+,(a0)+
	dbf	d0,.2
	lea	KernalRomMem,a1
	move.w	#$07ff,d0
.3
	move.l	(a1)+,(a0)+
	dbf	d0,.3
	movem.l	(a7)+,d0/a0-a1
	rts

GetFileName
	movem.l	d0-d1/a0-a1,-(a7)
	lea	VIC20Mem,a0
	add.l	#$8000,a0
	moveq	#$00,d0
	moveq	#$00,d1
	move.b	$00b7(a0),d0
	movep.w	$00bc(a0),d1
	move.b	$00bb(a0),d1
	add.l	d1,a0
	lea	FileName,a1
	subq.w	#1,d0
	beq.s	.2
.1
	move.b	(a0)+,(a1)+
	dbf	d0,.1
.2
	clr.b	(a1)
	movem.l	(a7)+,d0-d1/a0-a1
	rts

LoadFile
	movem.l	d0-d3/a0-a1/a6,-(a7)
	lea	DosName,a1
	CALLEXEC OldOpenLibrary
	move.l	d0,_DOSBase
	lea	FileName,a0
	move.l	a0,d1
	move.l	#MODE_OLDFILE,d2
	CALLDOS	Open
	move.l	d0,FilePointer
	beq	.2
	cmp.l	#-1,d0
	beq	.2
	move.l	d0,d1
	lea	VIC20Mem+$8000,a0
	lea	$00c3(a0),a0
	move.l	a0,d2
	moveq	#$02,d3
	CALLDOS	Read
	move.l	FilePointer,d1
	lea	VIC20Mem+$8000,a0
	tst.b	$00b9(a0)
	beq.s	.1
	move.b	$00c3(a0),$00ae(a0)
	move.b	$00c4(a0),$00af(a0)
.1
	moveq	#$00,d2
	movep.w	$00af(a0),d2
	move.b	$00ae(a0),d2
	add.l	a0,d2
	move.l	a0,d3
	add.l	#$00010000,d3
	sub.l	d2,d3
	CALLDOS	Read
	add.l	d0,d2
	lea	VIC20Mem+$8000,a0
	sub.l	a0,d2
	move.b	d2,$00ae(a0)
	lsr.w	#8,d2
	move.b	d2,$00af(a0)
	move.l	FilePointer,d1
	CALLDOS	Close
.2
	move.l	_DOSBase,a1
	CALLEXEC CloseLibrary
	bsr	WaitDisk
	movem.l	(a7)+,d0-d3/a0-a1/a6
	rts

SaveFile
	movem.l	d0-d3/a0-a1/a6,-(a7)
	lea	DosName,a1
	CALLEXEC OldOpenLibrary
	move.l	d0,_DOSBase
	lea	FileName,a0
	move.l	a0,d1
	move.l	#MODE_NEWFILE,d2
	CALLDOS Open
	move.l	d0,FilePointer
	beq	.2
	cmp.l	#-1,d0
	beq	.2
	move.l	d0,d1
	lea	VIC20Mem+$8000,a0
	lea	$00c1(a0),a0
	move.l	a0,d2
	moveq	#$02,d3
	CALLDOS Write
	move.l	FilePointer,d1
	lea	VIC20Mem+$8000,a0
	moveq	#$00,d2
	movep.w	$00c2(a0),d2
	move.b	$00c1(a0),d2
	moveq	#$00,d3
	movep.w	$00af(a0),d3
	move.b	$00ae(a0),d3
	sub.w	d2,d3
	add.l	a0,d2
	CALLDOS	Write
	move.l	FilePointer,d1
	CALLDOS Close
.2
	move.l	_DOSBase,a1
	CALLEXEC CloseLibrary
	bsr	WaitDisk
	movem.l	(a7)+,d0-d3/a0-a1/a6
	rts

WaitDisk
	move.l	d0,-(a7)
	move.w	#$7fff,d0
.1
	dbf	d0,.1
	move.l	(a7)+,d0
	rts

VIC20LoadFile
	move.l	a0,-(a7)
	lea	VIC20Mem+$8000,a0
	move.b	d1,$00ae(a0)
	move.b	d2,$00af(a0)
	jsr	GetFileName(pc)
	jsr	LoadFile(pc)
	lea	VIC20Mem+$8000,a0
	moveq	#$00,d2
	moveq	#$00,d1
	move.b	$00af(a0),d2
	move.b	$00ae(a0),d1
	moveq	#$00,d0
	move.b	d0,$0090(a0)
	move.l	(a7)+,a0
	rts

VIC20SaveFile
	move.l	a0,-(a7)
	lea	VIC20Mem+$8000,a0
	move.b	d1,$00ae(a0)
	move.b	d2,$00af(a0)
	move.b	0(a0,d0.w),$00c1(a0)
	move.b	1(a0,d0.w),$00c2(a0)
	jsr	GetFileName(pc)
	jsr	SaveFile(pc)
	lea	VIC20Mem+$8000,a0
	moveq	#$00,d2
	moveq	#$00,d1
	move.b	$00af(a0),d2
	move.b	$00ae(a0),d1
	moveq	#$00,d0
	move.b	d0,$0090(a0)
	move.l	(a7)+,a0
	rts

EnableRomBreak
	lea	VIC20Mem+$8000,a0
	move.b	#$02,$FFFFFFD5(a0)
	move.b	#$60,$FFFFFFD6(a0)
	move.b	#$02,$FFFFFFD8(a0)
	move.b	#$60,$FFFFFFD9(a0)
	rts

CleanKeyboard
	move.l	#$FFFFFFFF,VIC20Keyboard
	move.l	#$FFFFFFFF,VIC20Keyboard+4
	clr.b	RightAmigaKey
	clr.b	RightAltKey
	clr.b	LeftAltKey
	lea	VIC20Mem+$1200,a0
	move.w	#$110,d1
	moveq	#-1,d0
.1	move.b	d0,(a0)+
	dbf	d1,.1
	rts

MainLoop
	jsr	InitRasterIRQ
	jsr	InitBitplanes
	bsr	SaveIRQ
	bsr	CleanKeyboard
	move.w	#$4000,$dff09a
	bsr	ClearVBR
	bsr	EnableCopperList
	jsr	InitSound
	jsr	InitColors
	lea	SaveCIAAmiga,a0
	bsr	ReadCIA
	bsr	InitIRQ
	lea	SaveCIAC64,a0
	bsr	WriteCIA
.Enter	movem.w	Vic20Regs,d0-d7
	bsr	Jump6502Routine
	move.w	#$4000,$dff09a
	jsr	StopSound
	movem.w	d0-d7,Vic20Regs
	movem.w	d0-d7,$f0000
	move.w	#$ffff,d0
	lea	$e0000,a1
	lea	VIC20Mem,a0
.1	move.b	(a0)+,(a1)+
	dbf	d0,.1
	lea	VIC20Mem+$8000,a0
	tst.b	reqPAUSE(a0)
	bne.s	.Pause
	cmp.w	#$ffd5,d6
	beq	.LoadFile
	cmp.w	#$ffd8,d6
	beq	.SaveFile
.Pause
	lea	SaveCIAC64,a0
	bsr	ReadCIA
	lea	SaveCIAAmiga,a0
	bsr	WriteCIA
	bsr	RestoreVBR
	bsr	RestoreIRQ
	bsr	DisableCopperList
	move.w	#$c000,$dff09a
	rts
.LoadFile
	movem.l	d3-d7,-(a7)
	movem.l	d0-d2,-(a7)
	lea	SaveCIAC64,a0
	bsr	ReadCIA
	lea	SaveCIAAmiga,a0
	bsr	WriteCIA
	bsr	RestoreVBR
	bsr	RestoreIRQ
	bsr	DisableCopperList
	move.w	#$c000,$dff09a
	movem.l	(a7)+,d0-d2

	bsr	VIC20LoadFile

	movem.l	(a7)+,d3-d7
	addq.w	#1,d6
	move.w	d0,d3
	clr.b	d4
	clr.b	d5
	movem.w	d0-d7,Vic20Regs
	bra	MainLoop
.SaveFile
	movem.l	d3-d7,-(a7)
	movem.l	d0-d2,-(a7)
	lea	SaveCIAC64,a0
	bsr	ReadCIA
	lea	SaveCIAAmiga,a0
	bsr	WriteCIA
	bsr	RestoreVBR
	bsr	RestoreIRQ
	move.w	#$c000,$dff09a
	movem.l	(a7)+,d0-d2

	bsr	VIC20SaveFile

	movem.l	(a7)+,d3-d7
	addq.w	#1,d6
	move.w	d0,d3
	clr.b	d4
	clr.b	d5
	movem.w	d0-d7,Vic20Regs
	bra	MainLoop

Make6502Emulator
	movem.l	d0-d7/a0-a6,-(a7)
	lea	I00(pc),a0
	lea	PrgMem+$8000,a1
	lea	InstTable1(pc),a3
	moveq	#$00,d7
.1
	lea	4(a1,d7.w),a5
	move.w	(a3)+,d4
	lea	0(a0,d4.w),a4
	move.w	(a3),d4
	sub.w	-2(a3),d4
	bsr.s	.Make
	lea	.Irq(pc),a6
	move.l	(a6),-(a5)
	move.l	4(a6),$7e(a5)
	add.l	#$00010000,a5
	move.l	(a6),(a5)
	move.l	4(a6),$7e(a5)
	add.w	#$0100,d7
	tst.w	d7
	bne.s	.1
	movem.l	(a7)+,d0-d7/a0-a6
	rts
.Make
	movem.l	a0-a6/d4-d7,-(a7)
	lea	$007e(a5),a6
	move.l	a6,a0
	lea	4(a1),a1
	move.l	#$00010000,a2
	moveq	#$00,d5			;StatusMode
	moveq	#$00,d6			;ProcessorMode
	lea	.Next68000(pc),a3
	move.w	CPUVersion,d6		;ProcessorMode
	beq.s	.M1
	lea	.Next68020(pc),a3
.M1
	tst.w	d4
	bne.s	.M2
	movem.l	(a7)+,a0-a6/d4-d7
	rts
.M2
	move.w	(a4)+,d7
	subq.w	#2,d4
	cmp.w	#hunkStatus,d7
	beq.s	.M3
	cmp.w	#hunkDecAdd,d7
	beq.s	.M4
	cmp.w	#hunkDecSub,d7
	beq.s	.M5
	cmp.w	#hunkIfStat,d7
	beq.s	.M6
	cmp.w	#hunkNextInst,d7
	beq.s	.M7
	bsr	.Write
	bra.s	.M1
.M3
	move.w	.Irq+4(pc),d7		;Set Status
	bsr	.Write2
	tst.b	d5
	beq.s	.M1
	move.l	a6,a5
	bra.s	.M1
.M4
	move.w	.DecAdd+2(pc),d7
	move.w	d7,0(a5,a2.l)
	move.w	d7,0(a6,a2.l)
	move.w	.DecAdd(pc),d7
	move.w	d7,(a5)+
	move.w	d7,(a6)+
	bra.s	.M1
.M5
	move.w	.DecSub+2(pc),d7
	move.w	d7,0(a5,a2.l)
	move.w	d7,0(a6,a2.l)
	move.w	.DecSub(pc),d7
	move.w	d7,(a5)+
	move.w	d7,(a6)+
	bra	.M1
.M6
	move.l	a0,a6
	move.l	a0,a5
	st	d5
	bra	.M1
.M7
	move.w	(a4)+,d7
	subq.w	#2,d4
	cmp.w	#hunkNextInst0,d7
	beq.s	.M8
	cmp.w	#hunkNextInst1,d7
	beq.s	.M9
	cmp.w	#hunkNextInst2,d7
	beq.s	.M10
	bra	.M1
.M8
	subq.w	#6,d4
	addq.l	#6,a4
	move.w	(a3),d7
	bsr	.Write
	move.w	2(a3),d7
	bsr	.Write
	move.w	4(a3),d7
	bsr	.Write
	move.w	6(a3),d7
	bsr	.Write
	move.w	8(a3),d7
	bsr	.Write
	bra.s	.M11
.M9
	subq.w	#6,d4
	addq.l	#6,a4
	move.w	10(a3),d7
	bsr.s	.Write
	move.w	12(a3),d7
	bsr.s	.Write
	move.w	14(a3),d7
	bsr.s	.Write
	move.w	16(a3),d7
	bsr.s	.Write
	move.w	18(a3),d7
	bsr.s	.Write
	bra.s	.M11
.M10
	subq.w	#6,d4
	addq.l	#6,a4
	move.w	(a3),d7
	bsr.s	.Write1
	move.w	2(a3),d7
	bsr.s	.Write1
	move.w	4(a3),d7
	bsr.s	.Write1
	move.w	6(a3),d7
	bsr.s	.Write1
	move.w	8(a3),d7
	bsr.s	.Write1
	move.w	10(a3),d7
	bsr.s	.Write2
	move.w	12(a3),d7
	bsr.s	.Write2
	move.w	14(a3),d7
	bsr.s	.Write2
	move.w	16(a3),d7
	bsr.s	.Write2
	move.w	18(a3),d7
	bsr.s	.Write2
.M11
	tst.b	d6
	bne	.M1
	move.l	a5,d7
	subq.l	#4,d7
	sub.l	a1,d7
	move.w	d7,-8(a5)
	move.w	d7,-8(a5,a2.l)
	move.l	a6,d7
	subq.l	#4,d7
	sub.l	a1,d7
	move.w	d7,-8(a6)
	move.w	d7,-8(a6,a2.l)
	bra	.M1
.Write
	move.w	d7,0(a5,a2.l)
	move.w	d7,0(a6,a2.l)
	move.w	d7,(a5)+
	move.w	d7,(a6)+
	rts
.Write1
	move.w	d7,0(a5,a2.l)
	move.w	d7,(a5)+
	rts
.Write2
	move.w	d7,0(a6,a2.l)
	move.w	d7,(a6)+
	rts
.Irq	rts
	nop
	move.w	d0,d3
	rts
.DecAdd	addx.b	d6,d0
	abcd.b	d6,d0
.DecSub	subx.b	d6,d0
	sbcd.b	d6,d0
.Next68000
	move.b	(a6)+,$0000(a5)
	jmp	$0000(a4)
	nop
	move.b	(a6)+,$0000(a5)
	jmp	$007E(a4)
	nop
.Next68020
	move.b	(a6)+,-(a7)
	move.w	(a7)+,d7
	clr.b	d7
	jmp	0(a4,d7.w)
	move.b	(a6)+,-(a7)
	move.w	(a7)+,d7
	clr.b	d7
	jmp	$7E(a4,d7.w)


MakeMMUTable
	lea	MMUMem,a1
	movem.l	a2-a3/d4-d7,-(a7)
	move.l	a1,a2	
	move.l	a2,a0
	move.l	#$00000000,d0
	add.l	#$00000400,a1			;0000-03FF RAM
	bsr	.Fill
	move.l	a2,a1
	add.l	#$00001000,a1
	move.w	_mem3k,d0
	bsr	.Extend
	bsr	.Fill
	move.l	a2,a1
	add.l	#$00002000,a1
	move.l	#$00000000,d0
	bsr	.Fill
	move.l	a2,a1
	add.l	#$00004000,a1
	move.w	_mem8k1,d0
	bsr	.Extend
	bsr.s	.Fill
	move.l	a2,a1
	add.l	#$00006000,a1
	move.w	_mem8k2,d0
	bsr	.Extend
	bsr.s	.Fill
	move.l	a2,a1
	add.l	#$00008000,a1
	move.w	_mem8k3,d0
	bsr	.Extend
	bsr.s	.Fill
	move.l	a2,a1
	add.l	#$00009000,a1			;8000-8FFF ROM (CHAR)
	move.l	#$01010101,d0
	bsr.s	.Fill
	bsr.s	.FixIO				;9000-9FFF I/O
	move.l	a2,a1
	add.l	#$0000c000,a1
	move.l	#$00000000,d0
	bsr.s	.Fill
	move.l	a2,a1				;C000-FFFF ROM
	add.l	#$00010000,a1
	move.l	#$01010101,d0
	bsr.s	.Fill
	movem.l	(a7)+,a2-a3/d4-d7
	rts
.Fill
	move.l	d0,(a0)+
	cmp.l	a1,a0
	bne.s	.Fill
	rts
.FixIO
	move.l	a2,a1				;9000-9100
	add.l	#$00009100,a1
.Fix1	lea	.9000(pc),a3
	movem.l	(a3)+,d4-d7
	movem.l	d4-d7,(a0)
	lea	$0010(a0),a0
	cmp.l	a0,a1
	bne.s	.Fix1
	move.l	a2,a1				;9100-9400
	add.l	#$00009400,a1
.Fix2	lea	.9100(pc),a3
	movem.l	(a3)+,d4-d7
	movem.l	d4-d7,(a0)
	lea	$0010(a0),a0
	movem.l	(a3)+,d4-d7
	movem.l	d4-d7,(a0)
	lea	$0010(a0),a0
	movem.l	(a3)+,d4-d7
	movem.l	d4-d7,(a0)
	lea	$0010(a0),a0
	movem.l	(a3)+,d4-d7
	movem.l	d4-d7,(a0)
	lea	$0010(a0),a0
	cmp.l	a0,a1
	bne.s	.Fix2
	move.l	a2,a1				;9400-9600
	add.l	#$00009600,a1
	move.l	#$00000000,d0
	bsr.s	.Fill
	move.l	a2,a1				;9600-9800
	add.l	#$00009800,a1
	move.l	#$00000000,d0
	bsr	.Fill
	move.l	a2,a1				;9800-A000
	add.l	#$0000A000,a1
	move.l	#$b0b0b0b0,d0
	bsr	.Fill
	rts
.Extend
	tst.w	d0
	beq.s	.Ext1
	clr.l	d0
	rts
.Ext1
	move.l	#$01010101,d0
	rts

.9000	dc.b	$80,$81,$82,$83,$84,$85,$86,$87	;$9000-$900F
	dc.b	$88,$89,$8a,$8b,$8c,$8d,$8e,$8f

.9100	dc.b	$b0,$b0,$b0,$b0,$b0,$b0,$b0,$b0	;$9100-$910F
	dc.b	$b0,$b0,$b0,$b0,$b0,$b0,$b0,$b0
	dc.b	$90,$91,$92,$93,$94,$95,$96,$97	;$9110-$912F
	dc.b	$98,$99,$9a,$9b,$9c,$9d,$9e,$9f
	dc.b	$a0,$a1,$a2,$a3,$a4,$a5,$a6,$a7
	dc.b	$a8,$a9,$aa,$ab,$ac,$ad,$ae,$af
	dc.b	$b0,$b0,$b0,$b0,$b0,$b0,$b0,$b0	;$9130-$913F
	dc.b	$b0,$b0,$b0,$b0,$b0,$b0,$b0,$b0

InitSaveReg
	rts

Jump6502Routine		;D0=AC,D1=XR,D2=YR,D3+D4+D5=P,D6=PC,D7=SP
	movem.l	a2-a6,-(a7)
	move.w	#$4000,$dff09a
	lea	VIC20Mem+$8000,a0	;Set A0=MemBase

	and.w	#$00ff,d7		;Set A1=SP
	or.w	#$0100,d7
	sub.l	a1,a1
	move.w	d7,a1

	lea	MMUMem,a3		;Set A3=MMUTable

	lea	PrgMem+$8004,a5		;Set A4=EmulPrgBase_IRQ
	move.l	a5,a4			;Set A5=EmulPrgBase

	move.l	#$0000ffff,d7
	and.l	d7,d6
	lea	0(a0,d6.w),a6		;Set A6=PC
	move.l	#$000000ff,d6
	and.l	d7,d5
	btst	#11,d5
	beq.s	.3
	move.l	#$00010000,a2
	add.l	a2,a4
	add.l	a2,a5
	and.l	d7,d4
	or.w	#$8000,d4
	bra.s	.4
.3	and.l	d6,d4
.4	btst	#10,d5
	bne.s	.5
	clr.b	flgIrqMastEn(a0)
	bra.s	.6
.5	st	flgIrqMastEn(a0)
.6	and.l	d7,d3
	and.l	d6,d2
	and.l	d6,d1
	and.l	d6,d0
	swap	d1
	move.w	a1,d1
	swap	d1
	lea	$dff000,a1
	st	indSaveA4(a0)
	clr.l	regSaveA4(a0)

	clr.b	reqRESET(a0)
	clr.b	reqPAUSE(a0)
	clr.b	reqQUIT(a0)
	clr.b	reqIRQ(a0)
	clr.b	reqNMI(a0)
	clr.b	reqTRAP(a0)
	st	reqInterrupt(a0)
	move.w	#$a008,$09c(a1)
	move.w	#$c000,$09a(a1)

	move.b	(a6)+,-(a7)
	move.w	(a7)+,d7
	clr.b	d7
	jsr	0(a5,d7.w)
	subq.l	#1,a6
	tst.b	reqTRAP(a0)
	bne	.TRAP
	tst.b	reqNMI(a0)
	bne	.NMI
	tst.b	reqIRQ(a0)
	bne	.IRQ
.TRAP
	swap	d1
	move.w	d1,d7				;D7=SP
	swap	d1
	and.w	#$00ff,d7

	move.l	a6,d6				;D6=PC
	sub.l	a0,d6
	movem.l	(a7)+,a2-a6
	rts
.IRQ
	st	flgIrqMastEn(a0)
	clr.b	reqIRQ(a0)
	move.l	a5,a4
	st	reqInterrupt(a0)
	move.w	a6,d7
	sub.w	a0,d7
	move.w	d7,-(a7)			;Push PC on Stack
	swap	d1
	move.b	(a7)+,0(a0,d1.w)
	subq.b	#1,d1
	move.b	d7,0(a0,d1.w)
	subq.b	#1,d1

	move.w	d5,-(a7)			;Push P on Stack
	move.b	(a7)+,d7			;B,D,I
	move.w	d5,d6
	and.w	#$0040,d6			;V
	or.w	d6,d7
	move.w	d4,d6
	and.w	#$0001,d6			;C
	or.w	d6,d7
	tst.w	d3
	bpl.s	.IRQ1
	or.w	#$0080,d7			;N
.IRQ1
	tst.b	d3
	bpl.s	.IRQ2
	or.w	#$0080,d7			;N
.IRQ2
	bne.s	.IRQ3
	or.w	#$0002,d7			;Z
.IRQ3
	and.w	#$00EF,d7			;B=0
	move.b	d7,0(a0,d1.w)
	subq.b	#1,d1
	swap	d1

	or.w	#$0400,d5			;I=1
	lea	$FFFFFFFE(a0),a6
	jsr	$4C00(a5)		;JMP xxxx
	subq.l	#1,a6
	tst.b	reqTRAP(a0)
	bne	.TRAP
	tst.b	reqNMI(a0)
	bne	.NMI
	tst.b	reqIRQ(a0)
	bne	.IRQ
	bra	.TRAP

.NMI
	move.b	(a6)+,-(a7)
	move.w	(a7)+,d7
	clr.b	d7
	jsr	0(a5,d7.w)
	subq.l	#1,a6
	move.b	(a6)+,-(a7)
	move.w	(a7)+,d7
	clr.b	d7
	jsr	0(a5,d7.w)
	subq.l	#1,a6
	move.b	(a6)+,-(a7)
	move.w	(a7)+,d7
	clr.b	d7
	jsr	0(a5,d7.w)
	subq.l	#1,a6
	move.b	(a6)+,-(a7)
	move.w	(a7)+,d7
	clr.b	d7
	jsr	0(a5,d7.w)
	subq.l	#1,a6
	move.b	(a6)+,-(a7)
	move.w	(a7)+,d7
	clr.b	d7
	jsr	0(a5,d7.w)
	subq.l	#1,a6
	move.b	(a6)+,-(a7)
	move.w	(a7)+,d7
	clr.b	d7
	jsr	0(a5,d7.w)
	subq.l	#1,a6
	move.b	(a6)+,-(a7)
	move.w	(a7)+,d7
	clr.b	d7
	jsr	0(a5,d7.w)
	subq.l	#1,a6
	move.b	(a6)+,-(a7)
	move.w	(a7)+,d7
	clr.b	d7
	jsr	0(a5,d7.w)
	subq.l	#1,a6
	move.b	(a6)+,-(a7)
	move.w	(a7)+,d7
	clr.b	d7
	jsr	0(a5,d7.w)
	subq.l	#1,a6
	move.b	(a6)+,-(a7)
	move.w	(a7)+,d7
	clr.b	d7
	jsr	0(a5,d7.w)
	subq.l	#1,a6
	clr.b	reqNMI(a0)
	move.l	a5,a4
	st	reqInterrupt(a0)
	move.w	a6,d7
	sub.w	a0,d7
	move.w	d7,-(a7)			;Push PC on Stack
	swap	d1
	move.b	(a7)+,0(a0,d1.w)
	subq.b	#1,d1
	move.b	d7,0(a0,d1.w)
	subq.b	#1,d1
	swap	d1
	PUSHP
	lea	$FFFFFFFA(a0),a6
	jsr	$4C00(a5)		;JMP xxxx
	subq.l	#1,a6
	tst.b	reqTRAP(a0)
	bne	.TRAP
	tst.b	reqNMI(a0)
	bne	.NMI
	tst.b	reqIRQ(a0)
	bne	.IRQ
	bra	.TRAP


ICheckIntFlag
		btst	#10,d5
		bne.s	.1
		tst.b	flgIrqMastEn(a0)
		beq.s	.2
		move.w	#$4000,$09a(a1)
		clr.b	flgIrqMastEn(a0)
		move.b	$FFFF912E(a0),d7
		and.b	$FFFF912D(a0),d7
		beq.s	.3
		move.w	#$8008,$09c(a1)
.3		move.w	#$c000,$09a(a1)
		jmp	(a2)
.1		st	flgIrqMastEn(a0)
.2		jmp	(a2)

IPushP
	move.w	d5,-(a7)			;Push P on Stack
	move.b	(a7)+,d7			;B,D,I
	move.w	d5,d6
	and.w	#$0040,d6			;V
	or.w	d6,d7
	move.w	d4,d6
	and.w	#$0001,d6			;C
	or.w	d6,d7
	tst.w	d3
	bpl.s	.1
	or.w	#$0080,d7			;N
.1
	tst.b	d3
	bpl.s	.2
	or.w	#$0080,d7			;N
.2
	bne.s	.3
	or.w	#$0002,d7			;Z
.3
	swap	d1
	move.b	d7,0(a0,d1.w)
	subq.b	#1,d1
	swap	d1
	jmp	(a2)

IPullP
	swap	d1
	addq.b	#1,d1
	move.b	0(a0,d1.w),d4		;Get P from Stack
	swap	d1
	move.b	d4,d3
	ext.w	d3
	not.b	d3
	and.w	#$8002,d3
	move.b	d4,-(a7)
	move.w	(a7)+,d5
	move.b	d4,d5
	and.w	#$0c40,d5		;D,I,V
	or.w	#$3000,d5		;B
	lsr.b	#1,d4
	scs	d4			;C
	jmp	(a2)

SaveIRQ
	movem.l	d0-d6,-(a7)
	move.w	$dff01c,OldIRQENA
	movem.l	$0064.W,d0-d6
	movem.l	d0-d6,IRQRegSave
	movem.l	(a7)+,d0-d6
	rts

RestoreIRQ
	movem.l	d0-d6,-(a7)
	move.w	#$7fff,$dff09a
	move.w	#$7fff,$dff09c
	movem.l	IRQRegSave,d0-d6
	movem.l	d0-d6,$0064.W
	move.w	OldIRQENA,d0
	or.w	#$8000,d0
	move.w	d0,$dff09a
	movem.l	(a7)+,d0-d6
	rts


InitIRQ
	movem.l	d0/a0,-(a7)
	move.w	#$7fff,$dff09a
	lea	LevelOneIRQ(pc),a0
	move.l	a0,$0064.W		;LEVEL 1 IRQ
	lea	LevelTwoIRQ(pc),a0
	move.l	a0,$0068.W		;LEVEL 2 IRQ
	lea	LevelThreeIRQ(pc),a0
	move.l	a0,$006c.W		;LEVEL 3 IRQ
	lea	LevelFourIRQ(pc),a0
	move.l	a0,$0070.W		;LEVEL 4 IRQ
	lea	LevelFiveIRQ(pc),a0
	move.l	a0,$0074.W		;LEVEL 5 IRQ
	lea	LevelSixIRQ(pc),a0
	move.l	a0,$0078.W		;LEVEL 6 IRQ
	lea	LevelSevenIRQ(pc),a0
	move.l	a0,$007c.W		;LEVEL 7 IRQ
	move.w	#$7fff,$dff09c
	move.w	#$e028,$dff09a	;INTENA
	movem.l	(a7)+,d0/a0
	rts

InitCIA
	movem.l	d0/a0,-(a7)
	move.b	#$00,$bfe301
	move.b	#$03,$bfe201
	move.b	#$fe,$bfe001
	st	$bfe401
	st	$bfe501
	st	$bfe601
	st	$bfe701
	move.b	#$11,$bfee01		;CIAA CRA
	move.b	#$11,$bfef01
	move.b	#$7f,$bfed01		;CIAA ICR
	move.b	#$8b,$bfed01
	tst.b	$bfed01
	move.b	#$ff,$bfd300
	move.b	#$ff,$bfd100
	move.b	#$c0,$bfd200
	st	$bfd400
	st	$bfd500
	st	$bfd600
	st	$bfd700
	move.b	#$11,$bfde00
	move.b	#$91,$bfdf00
	move.b	#$7f,$bfdd00
	move.b	#$83,$bfdd00		;ALRM
	tst.b	$bfdd00
	lea	CIAAIRQ(pc),a0
	move.b	#$00,$00(a0)
	move.b	#$1f,$01(a0)		;Enable ALRM
	move.b	#$00,$02(a0)
	move.b	#$1f,$03(a0)		;Enable SP
	lea	VIC20Mem+$8000,a0
	st.b	$FFFF9116(a0)
	st.b	$FFFF9117(a0)
	st.b	$FFFF9118(a0)
	st.b	$FFFF9119(a0)
	clr.b	$FFFF911D(a0)
	clr.b	$FFFF911E(a0)
	st.b	$FFFF9126(a0)
	st.b	$FFFF9127(a0)
	st.b	$FFFF9128(a0)
	st.b	$FFFF9129(a0)
	clr.b	$FFFF912D(a0)
	clr.b	$FFFF912E(a0)

	clr.b	$FFFF9112(a0)
	clr.b	$FFFF9113(a0)
	clr.b	$FFFF9122(a0)
	clr.b	$FFFF9123(a0)
	clr.b	$FFFF911b(a0)
	clr.b	$FFFF912b(a0)

	clr.b	flgOSReadyA1(a0)
	clr.b	flgOSReadyA2(a0)
	clr.b	flgOSReadyB1(a0)
	clr.b	flgOSReadyB2(a0)
	movem.l	(a7)+,d0/a0
	rts

ReadCIA					;Reads the CIA registers
	movem.l	d0-d4/a0-a2,-(a7)
	lea	$bfd000,a1		;CIAB Hardware address
	lea	$dff000,a2
	move.w	#$2000,d2		;EXTER
	bsr.s	ReadCIA1
	lea	$18(a0),a0
	lea	$bfe001,a1		;CIAA Hardware address
	move.w	#$0008,d2		;PORTS
	bsr.s	ReadCIA1
	movem.l	(a7)+,d0-d4/a0-a2
	rts

ReadCIA1:
	move.b	$000(a1),$0(a0)		;PRA
	move.b	$100(a1),$1(a0)		;PRB
	move.b	$200(a1),$2(a0)		;DDRA
	move.b	$300(a1),$3(a0)		;DDRB
	move.b	$e00(a1),$e(a0)		;CRA
	move.b	$f00(a1),$f(a0)		;CRB
	moveq	#$00,d4
	move.b	d4,$e00(a1)	;turn off timer a
	move.b	d4,$f00(a1)	;turn off timer b
	move.b	$400(a1),$4(a0)		;TALO
	move.b	$500(a1),$5(a0)		;TAHI
	move.b	$600(a1),$6(a0)		;TBLO
	move.b	$700(a1),$7(a0)		;TBHI
	move.b	$a00(a1),$a(a0)		;Event MSB
	move.b	$900(a1),$9(a0)		;Event 8-15
	move.b	$800(a1),$8(a0)		;Event LSB
	move.b	$c00(a1),$c(a0)		;SDR
	move.b	$d00(a1),$14(a0)	;ICR request
	move.b	#$10,$e00(a1)	;force load timer a
	move.b	#$10,$f00(a1)	;force load timer a
	move.b	$400(a1),$10(a0)	;TALO latch
	move.b	$500(a1),$11(a0)	;TAHI latch
	move.b	$600(a1),$12(a0)	;TBLO latch
	move.b	$700(a1),$13(a0)	;TBHI latch
	moveq	#$00,d1
	move.b	#$10,$d00(a1)
	move.b	d4,$a00(a1)		;Stop TOD
	or.b	#$40,$e00(a1)		;Set Serial to output
	tst.b	$d00(a1)
	move.w	d2,$9c(a2)
	move.b	#$01,$400(a1)
	move.b	d4,$500(a1)
	move.b	#$59,$e00(a1)
	moveq	#$01,d3			;TA
	bsr.s	ReadCIA2
	move.b	#$01,$600(a1)
	move.b	d4,$700(a1)
	move.b	#$19,$f00(a1)
	moveq	#$02,d3			;TB
	bsr.s	ReadCIA2
	move.b	d4,$a00(a1)
	move.b	d4,$900(a1)
	move.b	#$01,$800(a1)
	move.b	#$80,$f00(a1)
	move.b	d4,$a00(a1)
	move.b	d4,$900(a1)
	move.b	d4,$800(a1)
	move.b	d4,$f00(a1)
	move.b	d4,$a00(a1)
	move.b	d4,$900(a1)
	move.b	d4,$800(a1)
	moveq	#$04,d3			;ALRM
	bsr.s	ReadCIA2
	move.b	#$51,$e00(a1)
	move.b	$c00(a1),$c00(a1)
	moveq	#$08,d3			;SP
	bsr.s	ReadCIA2
	move.b	d1,$d(a0)		;ICR
	move.b	d4,$e00(a1)
	rts

ReadCIA2:
	move.b	$d00(a1),d0
	and.b	d3,d0
	beq.s	ReadCIA2
	and.w	d2,$1e(a2)
	beq.s	ReadCIA3
	or.b	d3,d1
ReadCIA3:
	move.b	d3,$d00(a1)
	move.w	d2,$9c(a2)
	rts

WriteCIA:				;Writes back the CIA registers
	movem.l	d0/a0-a1,-(a7)
	lea	$bfd000,a1
	bsr.s	WriteCIA1
	lea	$18(a0),a0
	lea	$bfe001,a1
	bsr.s	WriteCIA1
	movem.l	(a7)+,d0/a0-a1
	rts
WriteCIA1:
	moveq	#$00,d0
	move.b	d0,$e00(a1)
	move.b	d0,$f00(a1)
	move.b	#$0f,$d00(a1)
	tst.b	$d00(a1)
	move.b	$2(a0),$200(a1)
	move.b	$0(a0),$000(a1)
	move.b	$3(a0),$300(a1)
	move.b	$1(a0),$100(a1)
	move.b	$4(a0),$400(a1)
	move.b	$5(a0),$500(a1)
	move.b	$6(a0),$600(a1)
	move.b	$7(a0),$700(a1)
	move.b	$a(a0),$a00(a1)
	move.b	$9(a0),$900(a1)
	move.b	$8(a0),$800(a1)
	move.b	$e(a0),d0
	or.b	#$10,d0
	move.b	d0,$e00(a1)
	move.b	$f(a0),d0
	or.b	#$10,d0
	move.b	d0,$f00(a1)
	move.b	$10(a0),$400(a1)
	move.b	$11(a0),$500(a1)
	move.b	$12(a0),$600(a1)
	move.b	$13(a0),$700(a1)
	move.b	$d(a0),d0
	or.b	#$80,d0
	move.b	d0,$d00(a1)
	rts

LevelSevenIRQ:
	movem.l	d0-d2/a3/a5,-(a7)
	lea	VIC20Mem+$8000,a3
	lea	$dff000,a5
	move.w	$001c(a5),d0		;INTENAR
	btst	#14,d0
	beq.s	LevelSevenIRQExit
	and.w	$001e(a5),d0		;INTREQR
LevelSevenIRQExit:
	movem.l	(a7)+,d0-d2/a3/a5
	rte

LevelSixIRQ:
	movem.l	d0-d1/a3/a5-a6,-(a7)
	lea	VIC20Mem+$8000,a3
	lea	$dff000,a5
	move.w	$001c(a5),d0		;INTENAR
	btst	#14,d0
	beq.s	LevelSixIRQExit
	and.w	$001e(a5),d0		;INTREQR
	btst	#13,d0
	bne.s	CIABIRQ_
	btst	#14,d0
	bne.s	MasterIRQ
LevelSixIRQExit:
	movem.l	(a7)+,d0-d1/a3/a5-a6
	rte

MasterIRQ:
	move.w	#$4000,$009c(a5)	;INTREQ
	bra.s	LevelSixIRQExit

CIABIRQ_:
	lea	CIABIRQ(pc),a6
	move.b	$bfdd00,d0
	or.b	d0,(a6)			;CIAB_IRQ_REQ
	move.b	$FFFF911D(a3),d1
	and.b	$FFFF911E(a3),d1
CIABIRQ1
	move.b	(a6),d0
	and.b	$01(a6),d0		;CIAB_IRQ_ENA
	beq.s	.2
	and.b	#$fe,(a6)
	lsr.b	#1,d0			;TA
	bcs.s	CIABTimerA
	and.b	#$fd,(a6)
	lsr.b	#1,d0			;TB
	bcs	CIABTimerB
	bclr	#2,(a6)
	lsr.b	#1,d0			;ALRM
	bcs	CIABAlarm
	bclr	#3,(a6)
	lsr.b	#1,d0			;SP
	bcs	CIABSerialPort
	bclr	#4,(a6)
	lsr.b	#1,d0			;FLAG
	bcs	CIABFlag
.2
	move.b	$FFFF911D(a3),d0
	and.b	$FFFF911E(a3),d0
	beq.s	.3
	tst.b	d1
	bne.s	.3
	InvokeInterrupt
	st	reqNMI(a3)
.3
	move.w	#$2000,$009c(a5)	;INTREQ
	bra	LevelSixIRQExit

CIABTimerA:
	move.b	$FFFF911B(a3),d0
	add.b	d0,d0
	bmi.s	.1
	tst.b	flgOSReadyA1(a3)
	bne	CIABIRQ1
.1	or.b	#$40,$FFFF911D(a3)
	st	flgOSReadyA1(a3)
	tst.b	flgRasterIRQ(a3)
	bne.s	.4
.6	clr.l	rasterBeamNew(a3)
	bra.s	.2
.4	btst	#6,$FFFF911E(a3)
	beq.s	.6
	move.w	#$4000,$09a(a5)
	move.l	rasterBeamNewA1(a3),d0
	beq.s	.2
	cmp.l	rasterBeamHigh(a3),d0
	blt.s	.2
	cmp.l	rasterBeamNew(a3),d0
	bne.s	.3
	clr.l	rasterBeamNew(a3)
.3	move.w	d0,rasterBeam(a3)
	swap	d0
	cmp.w	rasterBeamHigh(a3),d0
	beq.s	.2
	move.w	d0,rasterBeamHigh(a3)
	move.b	#$08,rasterStackRdy(a3)
	move.l	rasterStack(a3),a5
	st	(a5)
	lea	$dff000,a5
	not.b	rasterStackNr(a3)
	bne.s	.5
	move.l	#RasterStack1Mem,rasterStack(a3)
	bra.s	.2
.5	move.l	#RasterStack2Mem,rasterStack(a3)
.2	
	move.w	#$c000,$09a(a5)
	clr.l	rasterBeamNewA1(a3)
	bra	CIABIRQ1

CIABTimerB:
	tst.b	flgOSReadyA2(a3)
	bne	CIABIRQ1
	or.b	#$20,$FFFF911D(a3)
	st	flgOSReadyA2(a3)
	tst.b	flgRasterIRQ(a3)
	bne.s	.4
.6	clr.l	rasterBeamNew(a3)
	bra.s	.2
.4	btst	#5,$FFFF911E(a3)
	beq.s	.6
	move.w	#$4000,$09a(a5)
	move.l	rasterBeamNewA2(a3),d0
	beq.s	.2
	cmp.l	rasterBeamHigh(a3),d0
	blt.s	.2
	cmp.l	rasterBeamNew(a3),d0
	bne.s	.3
	clr.l	rasterBeamNew(a3)
.3	move.w	d0,rasterBeam(a3)
	swap	d0
	cmp.w	rasterBeamHigh(a3),d0
	beq.s	.2
	move.w	d0,rasterBeamHigh(a3)
	move.b	#$08,rasterStackRdy(a3)
	move.l	rasterStack(a3),a5
	st	(a5)
	lea	$dff000,a5
	not.b	rasterStackNr(a3)
	bne.s	.5
	move.l	#RasterStack1Mem,rasterStack(a3)
	bra.s	.2
.5	move.l	#RasterStack2Mem,rasterStack(a3)
.2	
	move.w	#$c000,$09a(a5)
	clr.l	rasterBeamNewA2(a3)
	bra	CIABIRQ1

CIABAlarm:
	bra	CIABIRQ1

CIABSerialPort:
	bra	CIABIRQ1

CIABFlag:
	bra	CIABIRQ1

LevelFiveIRQ:
	movem.l	d0-d2/a0/a3/a5,-(a7)
	lea	VIC20Mem+$8000,a3
	lea	$dff000,a5
	move.w	$001c(a5),d0		;INTENAR
	btst	#14,d0
	beq.s	LevelFiveIRQExit
	and.w	$001e(a5),d0		;INTREQR
	btst	#11,d0
	bne.s	SerialPortFullIRQ
	btst	#12,d0
	bne.s	DiskSyncIRQ
LevelFiveIRQExit:
	movem.l	(a7)+,d0-d2/a0/a3/a5
	rte

SerialPortFullIRQ:
	move.w	#$0800,$009c(a5)	;INTREQ
	bra.s	LevelFiveIRQExit

DiskSyncIRQ:
	move.w	#$1000,$009c(a5)	;INTREQ
	bra.s	LevelFiveIRQExit

LevelFourIRQ:
	movem.l	d0/a0/a3/a5,-(a7)
	lea	VIC20Mem+$8000,a3
	lea	$dff000,a5
	move.w	$001c(a5),d0		;INTENAR
	btst	#14,d0
	beq.s	LevelFourIRQExit
	and.w	$001e(a5),d0		;INTREQR
	btst	#7,d0
	bne.s	Audio0IRQ
	btst	#8,d0
	bne.s	Audio1IRQ
	btst	#9,d0
	bne.s	Audio2IRQ
	btst	#10,d0
	bne	Audio3IRQ
LevelFourIRQExit:
	movem.l	(a7)+,d0/a0/a3/a5
	rte
Audio0IRQ
	move.w	#$0080,$009c(a5)
	bra	LevelFourIRQExit
Audio1IRQ
	move.w	#$0100,$009c(a5)
	bra	LevelFourIRQExit
Audio2IRQ
	move.w	#$0200,$009c(a5)
	bra	LevelFourIRQExit
Audio3IRQ
	move.w	#$0400,$009c(a5)
	bra	LevelFourIRQExit

LevelThreeIRQ:
	movem.l	d0-d7/a0-a3/a5-a6,-(a7)
	lea	VIC20Mem+$8000,a3
	lea	$dff000,a5
	SaveIrqPointer
	move.w	$001c(a5),d0		;INTENAR
	btst	#14,d0
	beq.s	LevelThreeIRQExit
	and.w	$001e(a5),d0		;INTREQR
	btst	#4,d0
	bne.s	CopperIRQ
	btst	#5,d0
	bne.s	VertBlankIRQ
	btst	#6,d0
	bne	BlitterFinIRQ
LevelThreeIRQExit:
	RestIrqPointer
	movem.l	(a7)+,d0-d7/a0-a3/a5-a6
	rte

CopperIRQ:
	move.w	#$0010,$009c(a5)	;INTREQ
	bra.s	LevelThreeIRQExit

VertBlankIRQ
	lea	$00c00000,a2
	bsr	ReadPaddles
	bsr	ReadJoystick
	bsr	FixBitplanes
	and.b	#$7f,$ffffdf00(a2)
	move.b	#$00,$ffffda00(a2)
	move.b	#$00,$ffffd900(a2)
	move.b	$006(a5),$ffffd800(a2)
	bsr	CheckScreenPos
	bsr	FixScreenPos
	bsr	FixRasterIRQ
	tst.w	_speedometer
	beq.s	.4
	move.w	#$0888,$180(a5)
.4	bsr	ShowScreen
.1	bsr	ShowScreen
	move.w	_speedgfx,d0
	move.w	$ffffd900(a2),d1
	move.b	$ffffd800(a2),d1
	cmp.w	d0,d1
	bls.s	.1
	tst.w	_speedometer
	beq.s	.2
	moveq	#$00,d0
	move.b	$00a(a5),d0
	add.w	#$0020,d0
	cmp.w	#$00e0,d0
	bls.s	.3
	move.w	#$00e0,d0
.3	move.w	d0,_speedgfx
	lea	ColorTable,a0
	move.b	$FFFF900F(a3),d0
	and.w	#$0007,d0
	add.w	d0,d0
	move.w	0(a0,d0.w),$180(a5)
	btst	#6,$ffffe001(a2)
	bne.s	.2
	InvokeInterrupt
	st	reqTRAP(a3)
	st	reqPAUSE(a3)
	clr.w	_speedometer
.2	move.w	#$0020,$009c(a5)	;INTREQ
	bra	LevelThreeIRQExit

BlitterFinIRQ:
	move.w	#$0040,$009c(a5)	;INTREQ
	bra	LevelThreeIRQExit

LevelTwoIRQ:
	movem.l	d0/a3/a5-a6,-(a7)
	lea	VIC20Mem+$8000,a3
	lea	$dff000,a5
	move.w	$001c(a5),d0		;INTENAR
	btst	#14,d0
	beq.s	LevelTwoIRQExit
	and.w	$001e(a5),d0		;INTREQR
	btst	#3,d0
	bne.s	CIAAIRQ_
LevelTwoIRQExit:
	movem.l	(a7)+,d0/a3/a5-a6
	rte

CIAAIRQ_:
	lea	CIAAIRQ(pc),a6
	move.b	$bfed01,d0
	or.b	d0,(a6)			;CIAB_IRQ_REQ
CIAAIRQ1
	move.b	(a6),d0
	and.b	$01(a6),d0		;CIAB_IRQ_ENA
	beq.s	.2
	and.b	#$fe,(a6)
	lsr.b	#1,d0			;TA
	bcs.s	CIAATimerA
	and.b	#$fd,(a6)
	lsr.b	#1,d0			;TB
	bcs	CIAATimerB
	bclr	#2,(a6)
	lsr.b	#1,d0			;ALRM
	bcs	CIAAAlarm
	bclr	#3,(a6)
	lsr.b	#1,d0			;SP
	bcs	CIAASerialPort
	bclr	#4,(a6)
	lsr.b	#1,d0			;FLAG
	bcs	CIAAFlag
.2
	move.b	$FFFF912E(a3),d0
	and.b	$FFFF912D(a3),d0
	beq.s	.3
	tst.b	flgIrqMastEn(a3)
	bne.s	.3
	InvokeInterrupt
	st	reqIRQ(a3)
.3	move.w	#$0008,$009c(a5)	;INTREQ
	bra	LevelTwoIRQExit

CIAATimerA
	move.b	$FFFF912B(a3),d0
	add.b	d0,d0
	bmi.s	.1
	tst.b	flgOSReadyB1(a3)
	bne	CIAAIRQ1
.1	or.b	#$40,$FFFF912D(a3)
	st	flgOSReadyB1(a3)
	tst.b	flgRasterIRQ(a3)
	bne.s	.4
.6	clr.l	rasterBeamNew(a3)
	bra.s	.2
.4	btst	#6,$FFFF912E(a3)
	beq.s	.6
	move.w	#$4000,$09a(a5)
	move.l	rasterBeamNewB1(a3),d0
	beq.s	.2
	cmp.l	rasterBeamHigh(a3),d0
	blt.s	.2
	cmp.l	rasterBeamNew(a3),d0
	bne.s	.3
	clr.l	rasterBeamNew(a3)
.3	move.w	d0,rasterBeam(a3)
	swap	d0
	cmp.w	rasterBeamHigh(a3),d0
	beq.s	.2
	move.w	d0,rasterBeamHigh(a3)
	move.b	#$08,rasterStackRdy(a3)
	move.l	rasterStack(a3),a5
	st	(a5)
	lea	$dff000,a5
	not.b	rasterStackNr(a3)
	bne.s	.5
	move.l	#RasterStack1Mem,rasterStack(a3)
	bra.s	.2
.5	move.l	#RasterStack2Mem,rasterStack(a3)
.2	
	move.w	#$c000,$09a(a5)
	clr.l	rasterBeamNewB1(a3)
	bra	CIAAIRQ1

CIAATimerB
	tst.b	flgOSReadyB2(a3)
	bne	CIAAIRQ1
	or.b	#$20,$FFFF912D(a3)
	st	flgOSReadyB2(a3)
	tst.b	flgRasterIRQ(a3)
	bne.s	.4
.6	clr.l	rasterBeamNew(a3)
	bra.s	.2
.4	btst	#5,$FFFF912E(a3)
	beq.s	.6
	move.w	#$4000,$09a(a5)
	move.l	rasterBeamNewB2(a3),d0
	beq.s	.2
	cmp.l	rasterBeamHigh(a3),d0
	blt.s	.2
	cmp.l	rasterBeamNew(a3),d0
	bne.s	.3
	clr.l	rasterBeamNew(a3)
.3	move.w	d0,rasterBeam(a3)
	swap	d0
	cmp.w	rasterBeamHigh(a3),d0
	beq.s	.2
	move.w	d0,rasterBeamHigh(a3)
	move.b	#$08,rasterStackRdy(a3)
	move.l	rasterStack(a3),a5
	st	(a5)
	lea	$dff000,a5
	not.b	rasterStackNr(a3)
	bne.s	.5
	move.l	#RasterStack1Mem,rasterStack(a3)
	bra.s	.2
.5	move.l	#RasterStack2Mem,rasterStack(a3)
.2	
	move.w	#$c000,$09a(a5)
	clr.l	rasterBeamNewB2(a3)
	bra	CIAAIRQ1

CIAAAlarm
	bra	CIAAIRQ1

CIAASerialPort
	move.l	a2,-(a7)
	lea	$c00000,a2
	move.b	$ffffec01(a2),d0
	or.b	#$40,$ffffee01(a2)	;Set Serial to output
	not.b	d0
	ror.b	#1,d0
	bsr	Keyboard
	move.b	$ffffd800(a2),d0	;Wait for at least 85 s
.1
	cmp.b	$ffffd800(a2),d0
	beq.s	.1
	move.b	$ffffd800(a2),d0
.2
	cmp.b	$ffffd800(a2),d0
	beq.s	.2

	and.b	#$bf,$ffffee01(a2)	;Set Serial to input
	move.l	(a7)+,a2
	bra	CIAAIRQ1

CIAAFlag:
	bra	CIAAIRQ1

LevelOneIRQ:
	movem.l	d0-d2/a3/a5,-(a7)
	lea	VIC20Mem+$8000,a3
	lea	$dff000,a5
	move.w	$001c(a5),d0		;INTENAR
	btst	#14,d0
	beq.s	LevelOneIRQExit
	and.w	$001e(a5),d0		;INTREQR
	btst	#0,d0
	bne.s	SerialPortEmptyIRQ
	btst	#1,d0
	bne.s	DiskBlockIRQ
	btst	#2,d0
	bne.s	SoftwareIRQ
LevelOneIRQExit:
	movem.l	(a7)+,d0-d2/a3/a5
	rte

SerialPortEmptyIRQ:
	move.w	#$0001,$009c(a5)	;INTREQ
	bra.s	LevelOneIRQExit

DiskBlockIRQ:
	move.w	#$0002,$009c(a5)	;INTREQ
	bra.s	LevelOneIRQExit

SoftwareIRQ:
	move.w	#$0004,$009c(a5)	;INTREQ
	bra.s	LevelOneIRQExit

Keyboard				;Emulates the VIC20 keyboard
	movem.l	d1/a2,-(a7)
	tst.b	d0
	bmi.s	.Key1
	and.w	#$007f,d0		;Key down
	lea	KeyboardData2,a2
	move.b	0(a2,d0.w),d1
	bmi	.Key4
	lea	KeyboardData1,a2
	move.b	0(a2,d0.w),d0
	bmi.s	.Key2
	move.b	d0,d1
	lsr.w	#4,d0
	and.w	#$0007,d1
	lea	VIC20Keyboard,a2
	bclr	d1,0(a2,d0.w)
	bsr	.EvalKey
	movem.l	(a7)+,d1/a2
	rts
.Key1					;Key up
	and.w	#$007f,d0
	lea	KeyboardData2,a2
	move.b	0(a2,d0.w),d1
	bmi	.Key6
	lea	KeyboardData1,a2
	move.b	0(a2,d0.w),d0
	bmi.s	.Key3
	move.b	d0,d1
	lsr.w	#4,d0
	and.w	#$0007,d1
	lea	VIC20Keyboard,a2
	bset	d1,0(a2,d0.w)
	bsr	.EvalKey
	movem.l	(a7)+,d1/a2
	rts
.Key2					;Special char down
	cmp.b	#$7f,d1
	beq	.Key5
	and.w	#$007f,d0
	move.w	d1,-(a7)
	move.b	d0,d1
	lsr.w	#4,d0
	and.w	#$0007,d1
	lea	VIC20Keyboard,a2
	bclr	d1,0(a2,d0.w)
	move.w	(a7)+,d1
	move.b	d1,d0
	lsr.w	#4,d0
	and.w	#$0007,d1
	bclr	d1,0(a2,d0.w)
	bsr	.EvalKey
	movem.l	(a7)+,d1/a2
	rts
.Key3					;Special char up
	cmp.b	#$7f,d1
	beq	.Key5
	and.w	#$007f,d0
	move.w	d1,-(a7)
	move.b	d0,d1
	lsr.w	#4,d0
	and.w	#$0007,d1
	lea	VIC20Keyboard,a2
	bset	d1,0(a2,d0.w)
	move.w	(a7)+,d1
	move.b	d1,d0
	lsr.w	#4,d0
	and.w	#$0007,d1
	bset	d1,0(a2,d0.w)
	bsr	.EvalKey
	movem.l	(a7)+,d1/a2
	rts
.Key4					;Restore Key
	cmp.b	#$80,d1
	bne	.Key4c
	or.b	#$02,$ffff911d(a3)
	move.w	#$a000,$09c(a5)
	movem.l	(a7)+,d1/a2
	rts
.Key4c
	cmp.b	#$81,d1
	bne.s	.Key4ca
	st	LeftAltKey
.Key4ca
	cmp.b	#$82,d1
	bne.s	.Key4cb
	st	RightAltKey
.Key4cb
	cmp.b	#$83,d1
	bne.s	.Key4cc
	st	RightAmigaKey
.Key4cc
	move.b	RightAltKey,d0
	and.b	RightAmigaKey,d0
	beq.s	.Key4cd
	InvokeInterrupt
	st	reqTRAP(a3)
	st	reqPAUSE(a3)
.Key4cd
	movem.l	(a7)+,d1/a2
	rts

.Key5					;Dead Key
	movem.l	(a7)+,d1/a2
	rts
.Key6
	cmp.b	#$81,d1
	bne.s	.Key6a
	clr.b	LeftAltKey
.Key6a
	cmp.b	#$82,d1
	bne.s	.Key6b
	clr.b	RightAltKey
.Key6b
	cmp.b	#$83,d1
	bne.s	.Key6c
	clr.b	RightAmigaKey
.Key6c
	movem.l	(a7)+,d1/a2
	rts
	
.EvalKey
	movem.l	d0/d2-d6/a3,-(a7)
	lea	$FFFF9200(a3),a3
	st	$0f(a3)			;1111
	move.b	(a2)+,d0		;1110
	move.b	d0,$0e(a3)
	move.b	(a2)+,d1		;1101
	move.b	d1,$0d(a3)
	move.b	(a2)+,d2		;1011
	move.b	d2,$0b(a3)
	move.b	(a2)+,d3		;0111
	move.b	d3,$07(a3)
	move.b	d0,d4
	move.b	d0,d5
	move.b	d0,d6
	and.b	d1,d4			;1100
	and.b	d2,d5			;1010
	and.b	d3,d6			;0110
	move.b	d4,$0c(a3)
	move.b	d5,$0a(a3)
	move.b	d5,$06(a3)
	and.b	d2,d4			;1000
	and.b	d3,d5			;0010
	and.b	d1,d6			;0100
	move.b	d4,$08(a3)
	move.b	d5,$02(a3)
	move.b	d6,$04(a3)
	and.b	d3,d4			;0000
	move.b	d4,$00(a3)
	move.b	d1,d4
	move.b	d3,d4
	and.b	d1,d4			;0101
	move.b	d4,$05(a3)
	and.b	d2,d4			;0001
	move.b	d4,$01(a3)
	and.b	d2,d3			;0011
	move.b	d3,$03(a3)
	and.b	d2,d1			;1001
	move.b	d3,$09(a3)
	lea	$10(a3),a3
	st	$f0(a3)			;1111
	move.b	(a2)+,d0		;1110
	move.b	d0,$e0(a3)
	move.b	(a2)+,d1		;1101
	move.b	d1,$d0(a3)
	move.b	(a2)+,d2		;1011
	move.b	d2,$b0(a3)
	move.b	(a2)+,d3		;0111
	move.b	d3,$70(a3)
	move.b	d0,d4
	move.b	d0,d5
	move.b	d0,d6
	and.b	d1,d4			;1100
	and.b	d2,d5			;1010
	and.b	d3,d6			;0110
	move.b	d4,$c0(a3)
	move.b	d5,$a0(a3)
	move.b	d5,$60(a3)
	and.b	d2,d4			;1000
	and.b	d3,d5			;0010
	and.b	d1,d6			;0100
	move.b	d4,$80(a3)
	move.b	d5,$20(a3)
	move.b	d6,$40(a3)
	and.b	d3,d4			;0000
	move.b	d4,$00(a3)
	move.b	d1,d4
	move.b	d3,d4
	and.b	d1,d4			;0101
	move.b	d4,$50(a3)
	and.b	d2,d4			;0001
	move.b	d4,$10(a3)
	and.b	d2,d3			;0011
	move.b	d3,$30(a3)
	and.b	d2,d1			;1001
	move.b	d3,$90(a3)
	movem.l	(a7)+,d0/d2-d6/a3
	move.w	#$9200,d1
	move.b	$ffff9120(a3),d1
	and.w	#$920f,d1
	move.b	0(a3,d1.w),d0
	move.b	$ffff9120(a3),d1
	and.w	#$92f0,d1
	and.b	$10(a3,d1.w),d0
	move.b	d0,$ffff9141(a3)
	rts

CIAAIRQ:
	dc.b	0		;Request
	dc.b	0		;Enable
CIABIRQ:
	dc.b	0		;Request
	dc.b	0		;Enable

ReadIO					;Read VIC20 I/O $9000-$9FFF
					;IN: D7=Addr, D6=IOreg, A2=RetAddr
					;OUT: D6=Data
					;USAGE; D3,D6
	add.b	d6,d6
	move.w	.JMP(pc,d6.w),d3
	jmp	.JMP(pc,d3.w)
.JMP
	dc.w	.9000-.JMP		;80
	dc.w	.9001-.JMP
	dc.w	.9002-.JMP
	dc.w	.9003-.JMP

	dc.w	.9004-.JMP		;84
	dc.w	.9005-.JMP
	dc.w	.9006-.JMP
	dc.w	.9007-.JMP

	dc.w	.9008-.JMP		;88
	dc.w	.9009-.JMP
	dc.w	.900A-.JMP
	dc.w	.900B-.JMP

	dc.w	.900C-.JMP		;8C
	dc.w	.900D-.JMP
	dc.w	.900E-.JMP
	dc.w	.900F-.JMP

	dc.w	.9110-.JMP		;90
	dc.w	.9111-.JMP
	dc.w	.9112-.JMP
	dc.w	.9113-.JMP

	dc.w	.9114-.JMP		;94
	dc.w	.9115-.JMP
	dc.w	.9116-.JMP
	dc.w	.9117-.JMP

	dc.w	.9118-.JMP		;98
	dc.w	.9119-.JMP
	dc.w	.911A-.JMP
	dc.w	.911B-.JMP

	dc.w	.911C-.JMP		;9C
	dc.w	.911D-.JMP
	dc.w	.911E-.JMP
	dc.w	.911F-.JMP

	dc.w	.9120-.JMP		;A0
	dc.w	.9121-.JMP
	dc.w	.9122-.JMP
	dc.w	.9123-.JMP

	dc.w	.9124-.JMP		;A4
	dc.w	.9125-.JMP
	dc.w	.9126-.JMP
	dc.w	.9127-.JMP

	dc.w	.9128-.JMP		;A8
	dc.w	.9129-.JMP
	dc.w	.912A-.JMP
	dc.w	.912B-.JMP

	dc.w	.912C-.JMP		;AC
	dc.w	.912D-.JMP
	dc.w	.912E-.JMP
	dc.w	.912F-.JMP

	dc.w	.9100-.JMP		;B0

.9000						;Horiz. Cent.
	move.b	$FFFF9000(a0),d6
	jmp	(a2)
.9001						;Vert. Cent.
	move.b	$FFFF9001(a0),d6
	jmp	(a2)
.9002						;Columns
	move.b	$FFFF9002(a0),d6
	jmp	(a2)
.9003						;Rows
	move.l	rasterBeamNew(a0),d6
	beq.s	.90033
	cmp.l	rasterBeamHigh(a0),d6
	beq.s	.90031
.90033	addq.w	#1,rasterBeam(a0)
	move.b	#$05,flgRasterIRQ(a0)
	cmp.w	#$0138,rasterBeam(a0)
	blt.s	.90031
	move.w	#$4000,$09a(a1)
	move.b	#$08,rasterStackRdy(a0)
	addq.w	#1,rasterBeamHigh(a0)
	clr.w	rasterBeam(a0)
	move.l	rasterStack(a0),a1
	st	(a1)
	lea	$dff000,a1
	not.b	rasterStackNr(a0)
	bne.s	.90032
	move.l	#RasterStack1Mem,rasterStack(a0)
	move.w	#$c000,$09a(a1)
	bra.s	.90031
.90032	move.l	#RasterStack2Mem,rasterStack(a0)
	move.w	#$c000,$09a(a1)
.90031	moveq	#$00,d6
	move.b	$FFFF9003(a0),d6
	move.w	rasterBeam(a0),d3
	add.b	d6,d6
	lsr.b	#1,d3
	roxr.b	#1,d6
	jmp	(a2)
.9004						;Raster beam
	move.l	rasterBeamNew(a0),d6
	beq.s	.90043
	cmp.l	rasterBeamHigh(a0),d6
	beq.s	.90041
.90043	addq.w	#1,rasterBeam(a0)
	move.b	#$05,flgRasterIRQ(a0)
	cmp.w	#$0138,rasterBeam(a0)
	blt.s	.90041
	move.w	#$4000,$09a(a1)
	move.b	#$08,rasterStackRdy(a0)
	addq.w	#1,rasterBeamHigh(a0)
	clr.w	rasterBeam(a0)
	move.l	rasterStack(a0),a1
	st	(a1)
	lea	$dff000,a1
	not.b	rasterStackNr(a0)
	bne.s	.90042
	move.l	#RasterStack1Mem,rasterStack(a0)
	move.w	#$c000,$09a(a1)
	bra.s	.90041
.90042	move.l	#RasterStack2Mem,rasterStack(a0)
	move.w	#$c000,$09a(a1)
.90041	moveq	#$00,d6
	move.w	rasterBeam(a0),d6
	lsr.w	#1,d6
	jmp	(a2)
.9005						;Video address
	move.b	$FFFF9005(a0),d6
	jmp	(a2)
.9006						;Light pen X
	move.b	$007(a1),d6
	jmp	(a2)
.9007						;Light pen Y
	move.b	$006(a1),d6
	jmp	(a2)
.9008						;Paddle X
	move.b	$FFFF9008(a0),d6
	jmp	(a2)
.9009						;Paddle Y
	move.b	$FFFF9009(a0),d6
	jmp	(a2)
.900A					
	move.b	$FFFF900A(a0),d6
	jmp	(a2)
.900B						
	move.b	$FFFF900B(a0),d6
	jmp	(a2)
.900C						
	move.b	$FFFF900C(a0),d6
	jmp	(a2)
.900D
	move.b	$FFFF900D(a0),d6
	jmp	(a2)
.900E
	move.b	$FFFF900E(a0),d6
	jmp	(a2)
.900F	
	move.b	$FFFF900F(a0),d6
	jmp	(a2)

.9100						;Includes 9100-910F,
						;9800-9FFF
	moveq	#$00,d6
	jmp	(a2)

.9110
	move.b	$FFFF9110(a0),d6	;Output reg
	move.b	$FFFF9112(a0),d3	;DDR
	and.b	d3,d6
	not.b	d3
	and.b	$FFFF9130(a0),d3	;Input reg
	or.b	d3,d6
	and.b	#$67,$FFFF911D(a0)	;Clear CB1,CB2
	jmp	(a2)
.9111
	move.b	$FFFF9111(a0),d6	;Output reg
	move.b	$FFFF9113(a0),d3	;DDR
	and.b	d3,d6
	not.b	d3
	and.b	$FFFF9131(a0),d3	;Input reg
	or.b	d3,d6
	and.b	#$7c,$FFFF911D(a0)	;Clear CA1,CA2
	jmp	(a2)
.9112
	move.b	$FFFF9112(a0),d6
	jmp	(a2)
.9113
	move.b	$FFFF9113(a0),d6
	jmp	(a2)
.9114
	move.b	$bfd400,d6
	and.b	#$3f,$FFFF911D(a0)
	jmp	(a2)
.9115
	move.b	$bfd500,d6
	jmp	(a2)
.9116
	move.b	$FFFF9116(a0),d6
	jmp	(a2)
.9117
	move.b	$FFFF9117(a0),d6
	jmp	(a2)
.9118
	move.b	$bfd600,d6
	and.b	#$5f,$FFFF911D(a0)
	jmp	(a2)
.9119
	move.b	$bfd700,d6
	jmp	(a2)
.911A
	move.b	$FFFF911A(a0),d6
	jmp	(a2)
.911B
	move.b	$FFFF911B(a0),d6
	jmp	(a2)
.911C
	move.b	$FFFF911C(a0),d6
	jmp	(a2)
.911D
	move.b	$FFFF911D(a0),d6
	move.b	$FFFF911E(a0),d3
	and.b	#$7f,d6
	and.b	d6,d3
	beq.s	.911D1
	or.b	#$80,d6
.911D1
	jmp	(a2)
.911E
	move.b	$FFFF911E(a0),d6
	or.b	#$80,d6
	jmp	(a2)
.911F
	move.b	$FFFF9111(a0),d6	;Output reg
	move.b	$FFFF9113(a0),d3	;DDR
	and.b	d3,d6
	not.b	d3
	and.b	$FFFF9131(a0),d3	;Input reg
	or.b	d3,d6
	jmp	(a2)

.9120
	move.b	$FFFF9120(a0),d6	;Output reg
	move.b	$FFFF9122(a0),d3	;DDR
	and.b	d3,d6
	not.b	d3
	and.b	$FFFF9140(a0),d3	;Input reg
	or.b	d3,d6
	and.b	#$67,$FFFF912D(a0)	;Clear CB1,CB2
	jmp	(a2)
.9121
	move.b	$FFFF9141(a0),d6
	and.b	#$7c,$FFFF912D(a0)	;Clear CA1,CA2
	jmp	(a2)
.9122
	move.b	$FFFF9122(a0),d6
	jmp	(a2)
.9123
	move.b	$FFFF9123(a0),d6
	jmp	(a2)
.9124
	move.b	$bfe401,d6
	and.b	#$3f,$FFFF912D(a0)
	jmp	(a2)
.9125
	move.b	$bfe501,d6
	jmp	(a2)
.9126
	move.b	$FFFF9126(a0),d6
	jmp	(a2)
.9127
	move.b	$FFFF9127(a0),d6
	jmp	(a2)
.9128
	move.b	$bfe601,d6
	and.b	#$5f,$FFFF912D(a0)
	jmp	(a2)
.9129
	move.b	$bfe701,d6
	jmp	(a2)
.912A
	move.b	$FFFF912A(a0),d6
	jmp	(a2)
.912B
	move.b	$FFFF912B(a0),d6
	jmp	(a2)
.912C
	move.b	$FFFF912C(a0),d6
	jmp	(a2)
.912D
	move.b	$FFFF912D(a0),d6
	move.b	$FFFF912E(a0),d3
	and.b	#$7f,d6
	and.b	d6,d3
	beq.s	.912D1
	or.b	#$80,d6
.912D1
	jmp	(a2)
.912E
	move.b	$FFFF912E(a0),d6
	or.b	#$80,d6
	jmp	(a2)
.912F
	move.b	$FFFF9141(a0),d6
	jmp	(a2)

WriteIO					;Write 64 I/O $D000-$DFFF
					;D7=IOReg,D6=Byte,A2=Addr
					;USAGE: D6,D7,A2
	add.b	d7,d7
	move.w	.JMP(pc,d7.w),d7
	jmp	.JMP(pc,d7.w)
.JMP
	dc.w	.9000-.JMP		;80
	dc.w	.9001-.JMP
	dc.w	.9002-.JMP
	dc.w	.9003-.JMP

	dc.w	.9004-.JMP		;84
	dc.w	.9005-.JMP
	dc.w	.9006-.JMP
	dc.w	.9007-.JMP

	dc.w	.9008-.JMP		;88
	dc.w	.9009-.JMP
	dc.w	.900A-.JMP
	dc.w	.900B-.JMP

	dc.w	.900C-.JMP		;8C
	dc.w	.900D-.JMP
	dc.w	.900E-.JMP
	dc.w	.900F-.JMP

	dc.w	.9110-.JMP		;90
	dc.w	.9111-.JMP
	dc.w	.9112-.JMP
	dc.w	.9113-.JMP

	dc.w	.9114-.JMP		;94
	dc.w	.9115-.JMP
	dc.w	.9116-.JMP
	dc.w	.9117-.JMP

	dc.w	.9118-.JMP		;98
	dc.w	.9119-.JMP
	dc.w	.911A-.JMP
	dc.w	.911B-.JMP

	dc.w	.911C-.JMP		;9C
	dc.w	.911D-.JMP
	dc.w	.911E-.JMP
	dc.w	.911F-.JMP

	dc.w	.9120-.JMP		;A0
	dc.w	.9121-.JMP
	dc.w	.9122-.JMP
	dc.w	.9123-.JMP

	dc.w	.9124-.JMP		;A4
	dc.w	.9125-.JMP
	dc.w	.9126-.JMP
	dc.w	.9127-.JMP

	dc.w	.9128-.JMP		;A8
	dc.w	.9129-.JMP
	dc.w	.912A-.JMP
	dc.w	.912B-.JMP

	dc.w	.912C-.JMP		;AC
	dc.w	.912D-.JMP
	dc.w	.912E-.JMP
	dc.w	.912F-.JMP

	dc.w	.9100-.JMP		;B0

.9000	move.b	d6,$FFFF9000(a0)
	and.b	#$7f,d6
	move.w	d6,OffsetHoriz
	Next_Inst
.9001	move.b	d6,$FFFF9001(a0)
	move.w	d6,OffsetVert
	Next_Inst
.9002	move.b	d6,$FFFF9002(a0)
	move.w	d6,d7
	and.w	#$007f,d7
	move.w	d7,HorizWidth
	tst.b	d6
	bmi.s	.90021
	and.w	#$1c00,VideoAdress
	Next_Inst
.90021
	or.w	#$0200,VideoAdress
	Next_Inst
.9003	move.b	d6,$FFFF9003(a0)
	move.w	d6,d7
	and.w	#$007e,d7
	lsr.w	#1,d7
	move.w	d7,VertLength
	Next_Inst
.9004	Next_Inst
.9005	move.b	d6,$FFFF9005(a0)
	btst	#3,d6
	seq	d7
	and.w	#$0020,d7
	and.w	#$0007,d6
	or.w	d6,d7
	moveq	#$0a,d6
	lsl.w	d6,d7
	move.w	d7,CharAdress
	move.b	$FFFF9005(a0),d7
	lsl.w	#4,d7
	move.b	$FFFF9002(a0),d7
	lsl.w	#2,d7
	and.w	#$1e00,d7
	move.w	d7,VideoAdress
	Next_Inst
.9006	Next_Inst
.9007	Next_Inst
.9008	Next_Inst
.9009	Next_Inst

.900A	move.b	d6,$FFFF900A(a0)
	FIXFREQ	$0a6,1
	Next_Inst
.900B	move.b	d6,$FFFF900B(a0)
	FIXFREQ	$0b6,2
	Next_Inst
.900C	move.b	d6,$FFFF900C(a0)
	FIXFREQ	$0c6,4
	Next_Inst
.900D	move.b	d6,$FFFF900D(a0)
	FIXFREQ	$0d6,8
	Next_Inst
.900E	move.b	d6,$FFFF900E(a0)
	tst.b	flgRasterIRQ(a0)
	bne.s	.900E1
.900E3	move.w	d6,d7
	and.w	#$000f,d7
	add.w	d7,d7
	lea	VolumeTable,a2
	move.w	0(a2,d7.w),d7
	move.w	d7,$0a8(a1)
	move.w	d7,$0b8(a1)
	move.w	d7,$0c8(a1)
	move.w	d7,$0d8(a1)
	and.w	#$00f0,d6
	lsr.w	#3,d6
	lea	ColorTable,a2
	move.w	0(a2,d6.w),$0184(a1)
	Next_Inst
.900E1	subq.b	#1,flgRasterIRQ(a0)
	beq.s	.900E2
	move.l	rasterStack(a0),a2
	move.w	rasterBeam(a0),(a2)+
	move.b	#$0e,(a2)+
	move.b	d6,(a2)+
	move.l	a2,rasterStack(a0)
	Next_Inst
.900E2
	move.l	#RasterStack1Mem,rasterStack(a0)
	clr.b	rasterStackNr(a0)
	clr.b	rasterStackRdy(a0)
	bra.s	.900E3

.900F	move.b	d6,$FFFF900F(a0)
	tst.b	flgRasterIRQ(a0)
	bne.s	.900F1
.900F3	move.w	d6,d7
	and.w	#$00f0,d6
	lsr.w	#3,d6
	lea	ColorTable,a2
	move.w	0(a2,d6.w),$0182(a1)
	and.w	#$0007,d7
	add.w	d7,d7
	move.w	0(a2,d7.w),$0180(a1)
	Next_Inst
.900F1	subq.b	#1,flgRasterIRQ(a0)
	beq.s	.900F2
	move.l	rasterStack(a0),a2
	move.w	rasterBeam(a0),(a2)+
	move.b	#$0f,(a2)+
	move.b	d6,(a2)+
	move.l	a2,rasterStack(a0)
	Next_Inst
.900F2
	move.l	#RasterStack1Mem,rasterStack(a0)
	clr.b	rasterStackNr(a0)
	clr.b	rasterStackRdy(a0)
	bra.s	.900F3

.9110
	move.b	d6,$FFFF9110(a0)	;Output reg
	and.b	#$67,$FFFF911D(a0)	;Clear CB1,CB2
	Next_Inst
.9111
	move.b	d6,$FFFF9111(a0)	;Output reg
	and.b	#$7c,$FFFF911D(a0)	;Clear CA1,CA2
	Next_Inst
.9112
	move.b	d6,$FFFF9112(a0)
	Next_Inst
.9113
	move.b	d6,$FFFF9113(a0)
	Next_Inst
.9114
	move.b	d6,$FFFF9117(a0)
	move.w	$FFFF9116(a0),d7
	CONVTIMER d7
	move.w	#$4000,$09a(a1)
	move.b	d7,$bfd400
	lsr.w	#8,d7
	move.b	d7,$bfd500
	move.w	#$c000,$09a(a1)
	Next_Inst
.9115
	move.b	d6,$FFFF9116(a0)
	move.w	$FFFF9116(a0),d7
	and.b	#$fe,$bfde00
	move.w	#$4000,$09a(a1)
	FIXRASTER rasterBeamNewA1
	CONVTIMER d7
	move.b	d7,$bfd400
	lsr.w	#8,d7
	move.b	d7,$bfd500
	or.b	#$11,$bfde00
	and.b	#$3f,$FFFF911D(a0)
	clr.b	flgOSReadyA1(a0)
	move.w	#$c000,$09a(a1)
	Next_Inst
.9116
	move.b	d6,$FFFF9117(a0)
	move.w	$FFFF9116(a0),d7
	CONVTIMER d7
	move.w	#$4000,$09a(a1)
	move.b	d7,$bfd400
	lsr.w	#8,d7
	move.b	d7,$bfd500
	move.w	#$c000,$09a(a1)
	Next_Inst
.9117
	move.b	d6,$FFFF9116(a0)
	move.w	$FFFF9116(a0),d7
	CONVTIMER d7
	move.w	#$4000,$09a(a1)
	move.b	d7,$bfd400
	lsr.w	#8,d7
	move.b	d7,$bfd500
	and.b	#$3f,$FFFF911D(a0)
	move.w	#$c000,$09a(a1)
	Next_Inst
.9118
	move.b	d6,$FFFF9119(a0)
	Next_Inst
.9119
	move.b	d6,$FFFF9118(a0)
	move.w	$FFFF9118(a0),d7
	and.b	#$fe,$bfdf00
	move.w	#$4000,$09a(a1)
	FIXRASTER rasterBeamNewA2
	CONVTIMER d7
	move.b	d7,$bfd600
	lsr.w	#8,d7
	move.b	d7,$bfd700
	or.b	#$11,$bfdf00
	st	$bfd600
	st	$bfd700
	and.b	#$5f,$FFFF911D(a0)
	clr.b	flgOSReadyA2(a0)
	move.w	#$c000,$09a(a1)
	Next_Inst
.911A
	move.b	d6,$FFFF911A(a0)
	Next_Inst
.911B
	move.b	d6,$FFFF911B(a0)
	Next_Inst
.911C
	Next_Inst
.911D
	not.b	d6
	and.b	#$7f,d6
	and.b	d6,$FFFF911D(a0)
	Next_Inst
.911E
	tst.b	d6
	bpl.s	.911E1
	and.b	#$7f,d6
	move.w	#$4000,$09a(a1)
	move.b	$FFFF911E(a0),d7
	or.b	d6,$FFFF911E(a0)
	and.b	$FFFF911D(a0),d7
	bne.s	.911E2
	move.b	$FFFF911D(a0),d7
	and.b	$FFFF911E(a0),d7
	beq.s	.911E2
	move.w	#$a000,$09c(a1)
.911E2	move.w	#$c000,$09a(a1)
	Next_Inst
.911E1	not.b	d6
	and.b	d6,$FFFF911E(a0)
	Next_Inst
.911F
	move.b	d6,$FFFF9111(a0)	;Output reg
	Next_Inst
.9120					
	move.b	d6,$FFFF9120(a0)	;Output reg
	move.w	#$9200,d7
	move.b	d6,d7			;Low nibble reg
	move.w	d7,a2
	and.w	#$920f,d7
	move.b	0(a0,d7.w),d6
	move.w	a2,d7
	and.w	#$92f0,d7
	and.b	$10(a0,d7.w),d6
	move.b	d6,$FFFF9141(a0)
	and.b	#$67,$FFFF912D(a0)	;Clear CB1,CB2
	Next_Inst
.9121
	move.b	d6,$FFFF9121(a0)
	and.b	#$7c,$FFFF912D(a0)	;Clear CA1,CA2
	Next_Inst
.9122
	move.b	d6,$FFFF9122(a0)
	Next_Inst
.9123
	move.b	d6,$FFFF9123(a0)
	Next_Inst
.9124
	move.b	d6,$FFFF9127(a0)
	move.w	$FFFF9126(a0),d7
	CONVTIMER d7
	move.w	#$4000,$09a(a1)
	move.b	d7,$bfe401
	lsr.w	#8,d7
	move.b	d7,$bfe501
	move.w	#$c000,$09a(a1)
	Next_Inst
.9125
	move.b	d6,$FFFF9126(a0)
	move.w	$FFFF9126(a0),d7
	and.b	#$fe,$bfee01
	move.w	#$4000,$09a(a1)
	FIXRASTER rasterBeamNewB1
	CONVTIMER d7
	move.b	d7,$bfe401
	lsr.w	#8,d7
	move.b	d7,$bfe501
	or.b	#$11,$bfee01
	and.b	#$3f,$FFFF912D(a0)
	clr.b	flgOSReadyB1(a0)
	move.w	#$c000,$09a(a1)
	Next_Inst
.9126
	move.b	d6,$FFFF9127(a0)
	move.w	$FFFF9126(a0),d7
	CONVTIMER d7
	move.w	#$4000,$09a(a1)
	move.b	d7,$bfe401
	lsr.w	#8,d7
	move.b	d7,$bfe501
	move.w	#$c000,$09a(a1)
	Next_Inst
.9127
	move.b	d6,$FFFF9126(a0)
	move.w	$FFFF9126(a0),d7
	CONVTIMER d7
	move.w	#$4000,$09a(a1)
	move.b	d7,$bfe401
	lsr.w	#8,d7
	move.b	d7,$bfe501
	and.b	#$3f,$FFFF912D(a0)
	move.w	#$c000,$09a(a1)
	Next_Inst
.9128
	move.b	d6,$FFFF9129(a0)
	Next_Inst
.9129
	move.b	d6,$FFFF9128(a0)
	move.w	$FFFF9128(a0),d7
	and.b	#$fe,$bfef01
	move.w	#$4000,$09a(a1)
	FIXRASTER rasterBeamNewB2
	CONVTIMER d7
	move.b	d7,$bfe601
	lsr.w	#8,d7
	move.b	d7,$bfe701
	or.b	#$11,$bfef01
	st	$bfe601
	st	$bfe701
	and.b	#$5f,$FFFF912D(a0)
	clr.b	flgOSReadyB2(a0)
	move.w	#$c000,$09a(a1)
	Next_Inst
.912A
	move.b	d6,$FFFF912A(a0)
	Next_Inst
.912B
	move.b	d6,$FFFF912B(a0)
	Next_Inst
.912C
	Next_Inst
.912D
	not.b	d6
	and.b	#$7f,d6
	and.b	d6,$FFFF912D(a0)
	Next_Inst
.912E
	tst.b	d6
	bpl.s	.912E1
	and.b	#$7f,d6
	or.b	d6,$FFFF912E(a0)
	move.w	#$4000,$09a(a1)
	move.b	$FFFF912E(a0),d7
	and.b	$FFFF912D(a0),d7
	beq.s	.912E2
	tst.b	flgIrqMastEn(a0)
	bne.s	.912E2
	move.w	#$8008,$09c(a1)
.912E2	move.w	#$c000,$09a(a1)
	Next_Inst
.912E1	not.b	d6
	and.b	d6,$FFFF912E(a0)
	Next_Inst
.912F
	move.b	d6,$FFFF9121(a0)	;Output reg
	Next_Inst
.9100
	Next_Inst

	SPECIO	AslIO,ASL
	SPECIO	RolIO,ROL
	SPECIO	LsrIO,LSR
	SPECIO	RorIO,ROR
	SPECIO	DecIO,DEC
	SPECIO	IncIO,INC

ReadPaddles				;A5 = CUSTOM BASE
					;A3 = VIC20MEM + $8000
	tst.w	_paddles
	bne.s	.RealPaddle
	move.w	$000a(a5),d0
	move.b	d0,d1
	sub.b	PaddleXY+1,d1
	bpl.s	.1
	neg.b	d1
	sub.b	d1,$FFFF9008(a3)
	bcc.s	.2
	clr.b	$FFFF9008(a3)
	bra.s	.2
.1	add.b	d1,$FFFF9008(a3)
	bcc.s	.2
	st	$FFFF9008(a3)
.2	move.w	d0,d1
	lsr.w	#8,d1
	sub.b	PaddleXY,d1
	bpl.s	.3
	neg.b	d1
	sub.b	d1,$FFFF9009(a3)
	bcc.s	.4
	clr.b	$FFFF9009(a3)
	bra.s	.4
.3	add.b	d1,$FFFF9009(a3)
	bcc.s	.4
	st	$FFFF9009(a3)
.4	move.w	d0,PaddleXY
	bra.s	.Exit
.RealPaddle
	move.w	$0014(a5),d0
	move.b	d0,$FFFF9008(a3)	;Paddle X
	lsr.w	#8,d0
	move.b	d0,$FFFF9009(a3)	;Paddle Y
	move.w	#$0001,$0034(a5)	;Start reading
.Exit	rts
	
ReadJoystick				;A5 = CUSTOM BASE
	move.l	d2,-(a7)		;A3 = VIC20MEM + $8000
	move.w	$000c(a5),d0		;A2 = $C00000
	move.w	d0,d1
	and.w	#$0002,d1
	seq	$FFFF9140(a3)		;Input reg
	move.w	d0,d1
	and.w	#$0200,d1
	seq	d2
	or.w	#$00ef,d2
	move.w	d0,d1
	add.w	d1,d1
	eor.w	d1,d0
	move.w	d0,d1
	and.w	#$0002,d1
	beq.s	.1
	and.w	#$0034,d2
.1	and.w	#$0200,d0
	beq.s	.2
	and.w	#$0038,d2
.2	btst	#7,$ffffe001(a2)
	bne.s	.3
	and.w	#$001c,d2
.3	move.b	$FFFF9131(a3),d1
	move.b	#$7e,d1			;Just temporary
	and.w	#$00c3,d1
	and.w	#$003c,d2
	or.w	d2,d1
	move.b	d1,$FFFF9131(a3)	;Input reg
	move.l	(a7)+,d2
	rts

FixRasterIRQ				;A5 = CUSTOM BASE
					;A3 = VIC20MEM + $8000
	movem.l	d2/a2,-(a7)
	move.l	Copper2List,$0084(a5)
	tst.b	rasterStackRdy(a3)
	beq	.12
	subq.b	#1,rasterStackRdy(a3)
	bne	.1
.12	move.l	#RasterStack1Mem,rasterStack(a3)
	clr.b	rasterStackNr(a3)
	move.l	#CopperListDummy,Copper2List
	move.b	$FFFF900E(a3),d0
	move.w	d0,d1
	and.w	#$000f,d1
	add.w	d1,d1
	lea	VolumeTable,a2
	move.w	0(a2,d1.w),d1
	move.w	d1,$0a8(a5)
	move.w	d1,$0b8(a5)
	move.w	d1,$0c8(a5)
	move.w	d1,$0d8(a5)
	and.w	#$00f0,d0
	lsr.w	#3,d0
	lea	ColorTable,a2
	move.w	0(a2,d0.w),$0184(a5)
	move.b	$FFFF900F(a3),d0
	move.w	d0,d1
	and.w	#$00f0,d0
	lsr.w	#3,d0
	move.w	0(a2,d0.w),$0182(a5)
	and.w	#$0007,d1
	add.w	d1,d1
	move.w	0(a2,d1.w),$0180(a5)
	bra	.exit
.1
	move.b	$FFFF900E(a3),d1
	and.w	#$000f,d1
	add.w	d1,d1
	lea	VolumeTable,a2
	move.w	0(a2,d1.w),d1
	move.w	d1,$0a8(a5)
	move.w	d1,$0b8(a5)
	move.w	d1,$0c8(a5)
	move.w	d1,$0d8(a5)
	move.l	d3,-(a7)
	not.b	Copper2Nr
	lea	Copper1Mem,a1
	tst.b	Copper2Nr
	bne.s	.2
	lea	Copper2Mem,a1
.2
	move.l	a1,Copper2List
	lea	ColorTable,a2
	move.b	rasterStackNr(a3),d0
	lea	RasterStack2Mem,a0
	tst.b	d0
	beq.s	.22
	lea	RasterStack1Mem,a0
.22	moveq	#$00,d0
	moveq	#$00,d2
	moveq	#$00,d3
	move.l	#$0001fffe,(a1)+
	tst.w	_interlace
	bne	.interlace
.6	move.w	(a0)+,d1
	bmi	.exit1
	move.b	(a0)+,d2
	move.b	(a0)+,d3
	cmp.w	d1,d0
	beq.s	.3
	move.w	 d1,d0
	cmp.w	#$00ff,d1
	bls.s	.4
	move.l	#$ffd9fffe,(a1)+
	bra	.10
.4	
	move.b	d1,(a1)+
	move.b	#$01,(a1)+
	move.w	#$fffe,(a1)+
.3
	cmp.b	#$0e,d2
	bne.s	.5
	and.w	#$00f0,d3
	lsr.w	#3,d3
	move.w	#$0184,(a1)+
	move.w	0(a2,d3.w),(a1)+
	bra.s	.6
.5	
	move.w	d3,d2
	and.w	#$00f0,d2
	lsr.w	#3,d2
	move.w	#$0182,(a1)+
	move.w	0(a2,d2.w),(a1)+
	and.w	#$0007,d3
	add.w	d3,d3
	move.w	#$0180,(a1)+
	move.w	0(a2,d3.w),(a1)+
	bra.s	.6
.7	move.w	(a0)+,d1
	bmi	.exit1
	move.b	(a0)+,d2
	move.b	(a0)+,d3
	cmp.w	d1,d0
	beq.s	.8
	move.w	 d1,d0
.10	move.b	d1,(a1)+
	move.b	#$01,(a1)+
	move.w	#$fffe,(a1)+
.8
	cmp.b	#$0e,d2
	bne.s	.9
	and.w	#$00f0,d3
	lsr.w	#3,d3
	move.w	#$0184,(a1)+
	move.w	0(a2,d3.w),(a1)+
	bra.s	.7
.9	
	move.w	d3,d2
	and.w	#$00f0,d2
	lsr.w	#3,d2
	move.w	#$0182,(a1)+
	move.w	0(a2,d2.w),(a1)+
	and.w	#$0007,d3
	add.w	d3,d3
	move.w	#$0180,(a1)+
	move.w	0(a2,d3.w),(a1)+
	bra.s	.7
.interlace
	move.w	(a0)+,d1
	bmi	.exit1
	move.b	(a0)+,d2
	move.b	(a0)+,d3
	cmp.w	d1,d0
	beq.s	.i1
	move.w	 d1,d0
	lsr.w	#1,d1
	bcs.s	.i0a
	tst.w	$004(a5)
	bmi.s	.i0
	addq.w	#1,d1
	bra.s	.i0
.i0a	tst.w	$004(a5)
	bpl.s	.i0
	addq.w	#1,d1
.i0	add.w	#$0040,d1
	move.b	d1,(a1)+
	move.b	#$01,(a1)+
	move.w	#$fffe,(a1)+
.i1
	cmp.b	#$0e,d2
	bne.s	.i2
	and.w	#$00f0,d3
	lsr.w	#3,d3
	move.w	#$0184,(a1)+
	move.w	0(a2,d3.w),(a1)+
	bra.s	.interlace
.i2
	move.w	d3,d2
	and.w	#$00f0,d2
	lsr.w	#3,d2
	move.w	#$0182,(a1)+
	move.w	0(a2,d2.w),(a1)+
	and.w	#$0007,d3
	add.w	d3,d3
	move.w	#$0180,(a1)+
	move.w	0(a2,d3.w),(a1)+
	bra.s	.interlace
.exit1
	move.l	#$fffffffe,(a1)+
	move.l	(a7)+,d3
	movem.l	(a7)+,d2/a2
	rts
.exit
	movem.l	(a7)+,d2/a2
	rts	

InitRasterIRQ
	movem.l	d0-d2/a0/a1/a5,-(a7)
	lea	$dff000,a5
	lea	VIC20Mem+$8000,a0
	clr.b	flgRasterIRQ(a0)
	move.l	#RasterStack1Mem,rasterStack(a0)
	lea	RasterStack1Mem,a1
	st	(a1)
	lea	RasterStack2Mem,a1
	st	(a1)
	clr.b	rasterStackNr(a0)
	clr.b	rasterStackRdy(a0)
	clr.l	rasterBeamNewA1(a0)
	clr.l	rasterBeamNewA2(a0)
	clr.l	rasterBeamNewB1(a0)
	clr.l	rasterBeamNewB2(a0)
	clr.l	rasterBeamNew(a0)
	clr.l	rasterBeamHigh(a0)
	movem.l	(a7)+,d0-d2/a0/a1/a5
	rts	

InitSound
	movem.l	d0-d7/a0-a6,-(a7)
	lea	$dff000,a5
	move.w	#$000f,$0096(a5)
	lea	SampleMem,a0
	move.l	a0,$0a0(a5)
	move.w	#$0004,$0a4(a5)
	lea	8(a0),a0
	move.l	a0,$0b0(a5)
	move.w	#$0002,$0b4(a5)
	lea	4(a0),a0
	move.l	a0,$0c0(a5)
	move.w	#$0001,$0c4(a5)
	lea	2(a0),a0
	move.l	a0,$0d0(a5)
	move.w	#$2000,$0d4(a5)
	lea	VIC20Mem+$8000,a0
	moveq	#$00,d6
	move.b	$FFFF900E(a0),d6
	and.w	#$000f,d6
	add.w	d6,d6
	lea	VolumeTable,a2
	move.w	0(a2,d6.w),d7
	move.w	d7,$0a8(a5)
	move.w	d7,$0b8(a5)
	move.w	d7,$0c8(a5)
	move.w	d7,$0d8(a5)
	move.l	a5,a1
	move.b	$FFFF900A(a0),d6
	FIXFREQ	$0a6,1
	move.b	$FFFF900B(a0),d6
	FIXFREQ	$0b6,2
	move.b	$FFFF900C(a0),d6
	FIXFREQ	$0c6,4
	move.b	$FFFF900D(a0),d6
	FIXFREQ	$0d6,8
	movem.l	(a7)+,d0-d7/a0-a6
	rts

StopSound
	movem.l	d0-d7/a0-a6,-(a7)
	lea	$dff000,a5
	move.w	#$000f,$0096(a5)
	moveq	#$00,d0
	move.l	d0,$00a8(a5)
	move.l	d0,$00b8(a5)
	move.l	d0,$00c8(a5)
	move.l	d0,$00d8(a5)
	movem.l	(a7)+,d0-d7/a0-a6
	rts

MakeSamples
	movem.l	d0-d4/a0-a1,-(a7)
	lea	SampleMem,a0			;Making Pulse Waveform
	move.l	#$80808080,(a0)+
	move.l	#$7f7f7f7f,(a0)+
	move.w	#$8080,(a0)+
	move.w	#$7f7f,(a0)+
	move.b	#$80,(a0)+
	move.b	#$7f,(a0)+
	lea	$4000(a0),a1			;Making Noise Waveform
	moveq	#$00,d0
	move.l	#$91827364,d1
	move.l	#$55647382,d2
	move.l	#$46372819,d3
.1
	add.l	d2,d1
	eor.l	d3,d1
	eor.l	d2,d3
	rol.l	d1,d2
	ror.l	d2,d3
	move.l	d1,d4
	swap	d4
	add.w	d4,d1
	add.b	d1,d0
	move.b	d0,(a0)+
	cmpa.l	a0,a1
	bne.s	.1
	movem.l	(a7)+,d0-d4/a0-a1
	rts

CheckScreenPos				;A5 = CUSTOM BASE
					;A3 = VIC20MEM + $8000
	clr.l	BitPlanesOffset
	btst	#0,$FFFF9003(a3)
	beq.s	.1
	cmp.w	#16,VertLength
	bls.s	.2
	move.w	#16,VertLength
	bra.s	.2
.1	cmp.w	#32,VertLength
	bls.s	.2
	move.w	#32,VertLength
.2
	move.w	OffsetVert,d0
	move.w	VertLength,d1
	btst	#0,$FFFF9003(a3)
	beq.s	.3
	add.w	d1,d1
.3
	lsl.w	#2,d1
	add.w	d1,d0
	cmp.w	#$0f,d0
	bhi.s	.3a
	moveq	#$10,d0
.3a	cmp.w	#$009a,d0
	bls.s	.4
	move.w	#$009a,d0
.4	move.w	d0,VerticalStop
	tst.w	_hires
	bne.s	.hires
	move.w	OffsetVert,d0
	cmp.w	#$0f,d0
	bhi.s	.5
	moveq	#$10,d1
	sub.w	d0,d1
	lsl.l	#8,d1
	move.l	d1,BitPlanesOffset
	moveq	#$10,d0
.5
	move.w	d0,VerticalStart
	cmp.w	#32,HorizWidth
	bls.s	.6
	move.w	#32,HorizWidth
.6
	move.w	OffsetHoriz,d0
	add.w	HorizWidth,d0
	cmp.w	#8,d0
	bhi.s	.6a
	moveq	#9,d0
.6a	cmp.w	#37,d0
	bls.s	.7
	moveq	#37,d0
.7
	move.w	d0,HorizontalStop
	move.w	OffsetHoriz,d0
	cmp.w	#37,d0
	bls.s	.7a
	moveq	#37,d0
.7a	cmp.w	#8,d0
	bhi.s	.8
	moveq	#9,d1
	sub.w	d0,d1
	add.l	d1,BitPlanesOffset
	moveq	#9,d0
.8
	move.w	d0,HorizontalStart
	rts
.hires
	move.w	OffsetVert,d0
	cmp.w	#$0f,d0
	bhi.s	.h5
	moveq	#$10,d1
	sub.w	d0,d1
	move.l	d1,d0			;*3
	add.l	d1,d1
	add.l	d0,d1
	lsl.l	#8,d1
	move.l	d1,BitPlanesOffset
	moveq	#$10,d0
.h5
	move.w	d0,VerticalStart
	cmp.w	#32,HorizWidth
	bls.s	.h6
	move.w	#32,HorizWidth
.h6
	move.w	OffsetHoriz,d0
	add.w	HorizWidth,d0
	cmp.w	#8,d0
	bhi.s	.h6a
	moveq	#9,d0
.h6a	cmp.w	#37,d0
	bls.s	.h7
	moveq	#37,d0
.h7
	move.w	d0,HorizontalStop
	move.w	OffsetHoriz,d0
	cmp.w	#37,d0
	bls.s	.h7a
	moveq	#37,d0
.h7a	cmp.w	#8,d0
	bhi.s	.h8
	moveq	#9,d1
	sub.w	d0,d1
	move.w	d1,d0			;*3
	add.w	d1,d1
	add.w	d0,d1
	add.l	d1,BitPlanesOffset
	moveq	#9,d0
.h8
	move.w	d0,HorizontalStart
	rts

FixScreenPos				;A5 = CUSTOM BASE
					;A3 = VIC20MEM + $8000
	movem.w	d2-d7,-(a7)
	tst.w	_interlace
	bne	.interlace
	move.w	VerticalStart,d7	;Screen start pos v
	add.w	d7,d7
	move.w	VerticalStop,d6		;Screen stop pos v
	add.w	d6,d6
	tst.w	_hires
	bne	.hires
	move.w	HorizontalStart,d5
	move.w	d5,d2
	subq.w	#3,d5
	lsl.w	#3,d5
	add.w	#$0081,d5		;Screen start pos h
	move.w	HorizontalStop,d4
	move.w	d4,d3
	sub.w	d2,d3			;Nr of bytes
	subq.w	#3,d4
	lsl.w	#3,d4
	add.w	#$0081,d4		;Screen stop pos h
	move.w	d7,d0
	lsl.w	#8,d0
	move.b	d5,d0
	move.w	d0,$008e(a5)		;DIWSTRT
	move.w	d6,d0
	lsl.w	#8,d0
	move.b	d4,d0
	move.w	d0,$0090(a5)		;DIWSTOP
	move.w	d4,d1
	and.w	#$0100,d1
	lsl.w	#5,d1
	move.w	d6,d0
	and.w	#$0700,d0
	or.w	d0,d1
	move.w	d5,d0
	and.w	#$0100,d0
	lsr.w	#3,d0
	or.w	d0,d1
	move.w	d7,d0
	and.w	#$0700,d0
	lsr.w	#8,d0
	or.w	d0,d1
	move.w	d1,$01e4(a5)		;DIWHIGH
	move.w	d5,d0
	lsr.w	#1,d0
	subq.w	#8,d0
	and.w	#$00fc,d0
	move.w	d0,d2
	move.w	d4,d0
	lsr.w	#1,d0
	subq.w	#8,d0
	subq.w	#8,d0
	and.w	#$00fc,d0
	move.w	d0,$0094(a5)		;DDFSTOP
	cmp.w	d2,d0
	bhi.s	.1
	move.w	#$002c,d2
	move.w	d2,$0094(a5)
	move.w	#$0028,d2
.1	move.w	d2,$0092(a5)		;DDFSTRT
	move.w	d5,d0
	and.w	#$0008,d0
	sne	d0
	and.w	#$0088,d0
	move.w	d0,$0102(a5)		;BPLCON1
	move.w	#$0080,d0
	sub.w	d3,d0
	move.w	d0,$0108(a5)		;BPL1MOD
	move.w	d0,$010a(a5)		;BPL2MOD
	movem.w	(a7)+,d2-d7
	rts
.interlace
	move.w	VerticalStart,d7	;Screen start pos v
	add.w	#$40,d7
	move.w	VerticalStop,d6		;Screen stop pos v
	add.w	#$40,d6
	move.w	HorizontalStart,d5
	move.w	d5,d2
	subq.w	#3,d5
	lsl.w	#3,d5
	add.w	#$0081,d5		;Screen start pos h
	move.w	HorizontalStop,d4
	move.w	d4,d3
	sub.w	d2,d3			;Nr of bytes
	subq.w	#3,d4
	lsl.w	#3,d4
	add.w	#$0081,d4		;Screen stop pos h
	move.w	d7,d0
	lsl.w	#8,d0
	move.b	d5,d0
	move.w	d0,$008e(a5)		;DIWSTRT
	move.w	d6,d0
	lsl.w	#8,d0
	move.b	d4,d0
	move.w	d0,$0090(a5)		;DIWSTOP
	move.w	d4,d1
	and.w	#$0100,d1
	lsl.w	#5,d1
	move.w	d6,d0
	and.w	#$0700,d0
	or.w	d0,d1
	move.w	d5,d0
	and.w	#$0100,d0
	lsr.w	#3,d0
	or.w	d0,d1
	move.w	d7,d0
	and.w	#$0700,d0
	lsr.w	#8,d0
	or.w	d0,d1
	move.w	d1,$01e4(a5)		;DIWHIGH
	move.w	d5,d0
	lsr.w	#1,d0
	subq.w	#8,d0
	and.w	#$00fc,d0
	move.w	d0,d2
	move.w	d4,d0
	lsr.w	#1,d0
	subq.w	#8,d0
	subq.w	#8,d0
	and.w	#$00fc,d0
	move.w	d0,$0094(a5)		;DDFSTOP
	cmp.w	d2,d0
	bhi.s	.i1
	move.w	#$002c,d2
	move.w	d2,$0094(a5)
	move.w	#$0028,d2
.i1	move.w	d2,$0092(a5)		;DDFSTRT
	move.w	d5,d0
	and.w	#$0008,d0
	sne	d0
	and.w	#$0088,d0
	move.w	d0,$0102(a5)		;BPLCON1
	move.w	#$0100,d0
	sub.w	d3,d0
	move.w	d0,$0108(a5)		;BPL1MOD
	move.w	d0,$010a(a5)		;BPL2MOD
	movem.w	(a7)+,d2-d7
	rts
.hires
	move.w	#$180,d3
	move.w	HorizontalStart,d5
	sub.w	#9,d5
	move.w	d5,d0			;*3
	add.w	d5,d5
	add.w	d0,d5
	add.w	d5,d5
	add.w	d5,d5
	add.w	#$007d,d5		;Screen start pos h
	move.w	HorizontalStop,d4
	sub.w	#9,d4
	move.w	d4,d0			;*3
	add.w	d4,d4
	add.w	d0,d4
	add.w	d4,d4
	add.w	d4,d4
	add.w	#$007d,d4		;Screen stop pos h
	cmp.w	#$01cd,d4
	bls.s	.h3
	move.w	#$01cd,d4
.h3	move.w	d7,d0
	lsl.w	#8,d0
	move.b	d5,d0
	move.w	d0,$008e(a5)		;DIWSTRT
	move.w	d6,d0
	lsl.w	#8,d0
	move.b	d4,d0
	cmp.w	#$01cd,d4
	bne.s	.h4
	move.b	#$c6,d0
.h4	move.w	d0,$0090(a5)		;DIWSTOP
	move.w	d4,d1
	and.w	#$0100,d1
	lsl.w	#5,d1
	move.w	d6,d0
	and.w	#$0700,d0
	or.w	d0,d1
	move.w	d5,d0
	and.w	#$0100,d0
	lsr.w	#3,d0
	or.w	d0,d1
	move.w	d7,d0
	and.w	#$0700,d0
	lsr.w	#8,d0
	or.w	d0,d1
	move.w	d1,$01e4(a5)		;DIWHIGH
	move.w	d5,d0
	and.w	#$1f9,d0
	moveq	#$00,d1
	sub.w	d0,d1
	lsr.w	#1,d0
	subq.w	#4,d0
	and.w	#$00fc,d0
	move.w	d0,d2			;DDFSTRT
	move.w	d5,d0
	eor.w	d4,d0
	and.w	#8,d0
	and.w	#$01f9,d4
	add.w	d4,d0
	cmp.w	#$01c9,d0
	bls.s	.h2
	move.w	#$01c9,d0
	subq.w	#8,d1
.h2	add.w	d0,d1
	lsr.w	#1,d0
	subq.w	#8,d0
	subq.w	#8,d0
	and.w	#$00fc,d0
	move.w	d0,$0094(a5)		;DDFSTOP
	cmp.w	d2,d0
	bhi.s	.h1
	move.w	#$002c,d2
	move.w	d2,$0094(a5)
	move.w	#$0028,d2
.h1	move.w	d2,$0092(a5)		;DDFSTRT
	lsr.w	#2,d1
	sub.w	d1,d3
	move.w	d5,d0
	and.w	#$0004,d0
	sne	d0
	and.w	#$0044,d0
	move.w	d0,$0102(a5)		;BPLCON1
	move.w	d3,$0108(a5)		;BPL1MOD
	move.w	d3,$010a(a5)		;BPL2MOD
	movem.w	(a7)+,d2-d7
	rts

InitBitplanes
	movem.l	d2-d3/a2,-(a7)
	lea	CopperListBitplanes,a2
	move.l	#ScreenMem,d2
	moveq	#$03,d3
	tst.w	_hires
	bne.s	.2
.1
	move.w	d2,6(a2)
	swap	d2
	move.w	d2,2(a2)
	swap	d2
	add.l	#$0020,d2
	lea	$8(a2),a2
	dbf	d3,.1
	bra.s	.3
.2
	move.w	d2,6(a2)
	swap	d2
	move.w	d2,2(a2)
	swap	d2
	add.l	#$0060,d2
	lea	$8(a2),a2
	dbf	d3,.2
.3
	movem.l	(a7)+,d2-d3/a2
	rts

FixBitplanes				;A5 = CUSTOM BASE
	movem.l	d2-d3/a2,-(a7)
	lea	CopperListBitplanes,a2
	move.l	#ScreenMem,d2
	tst.w	_hires
	bne.s	.hires
	move.w	#$4200,CopperListInterlace+2
	tst.w	_interlace
	beq.s	.1
	move.w	#$4204,CopperListInterlace+2
	tst.w	$004(a5)
	bmi.s	.1
	add.l	#$0080,d2
.1	add.l	BitPlanesOffset,d2
	moveq	#$20,d3
	move.w	d2,6(a2)
	swap	d2
	move.w	d2,2(a2)
	swap	d2
	add.l	d3,d2
	move.w	d2,6+8(a2)
	swap	d2
	move.w	d2,2+8(a2)
	swap	d2
	add.l	d3,d2
	move.w	d2,6+8*2(a2)
	swap	d2
	move.w	d2,2+8*2(a2)
	swap	d2
	add.l	d3,d2
	move.w	d2,6+8*3(a2)
	swap	d2
	move.w	d2,2+8*3(a2)
	swap	d2
	movem.l	(a7)+,d2-d3/a2
	rts
.hires
	move.w	#$c200,CopperListInterlace+2
	add.l	BitPlanesOffset,d2
	moveq	#$60,d3
	move.w	d2,6(a2)
	swap	d2
	move.w	d2,2(a2)
	swap	d2
	add.l	d3,d2
	move.w	d2,6+8(a2)
	swap	d2
	move.w	d2,2+8(a2)
	swap	d2
	add.l	d3,d2
	move.w	d2,6+8*2(a2)
	swap	d2
	move.w	d2,2+8*2(a2)
	swap	d2
	add.l	d3,d2
	move.w	d2,6+8*3(a2)
	swap	d2
	move.w	d2,2+8*3(a2)
	swap	d2
	movem.l	(a7)+,d2-d3/a2
	rts


MakeMultiColor
	movem.l	d0-d7/a0-a6,-(a7)
	lea	MultiColorTable,a0
	moveq	#$00,d2
.2	moveq	#$00,d3
.1	moveq	#$00,d4
	moveq	#$00,d5
	moveq	#$00,d6
	moveq	#$00,d7
	move.w	#$0100,d1
	move.b	d3,d1
.3
	move.b	d1,d0
	and.b	#$c0,d0
	cmp.b	#$c0,d0
	beq	.4
	cmp.b	#$80,d0
	beq	.5
	cmp.b	#$40,d0
	beq	.6
	moveq	#$01,d0
	bra	.7
.4
	moveq	#$02,d0
	bra	.7
.5
	move.b	d2,d0
	or.b	#$08,d0
	bra	.7
.6
	moveq	#$00,d0
.7	bsr	.SetColor
	add.w	d1,d1
	add.w	d1,d1
	bcc	.3
	move.b	d4,(a0)
	move.b	d5,$800(a0)
	move.b	d6,$800*2(a0)
	move.b	d7,$800*3(a0)
	addq.l	#1,a0
	addq.b	#1,d3
	bne	.1
	addq.b	#1,d2
	cmp.b	#$08,d2
	bne	.2
	movem.l	(a7)+,d0-d7/a0-a6
	rts
.SetColor
	move.w	d0,-(a7)
	bsr	.SetColor1
	move.w	(a7)+,d0
	bsr	.SetColor1
	rts
.SetColor1
	lsr.b	#1,d0
	addx.b	d4,d4
	lsr.b	#1,d0
	addx.b	d5,d5
	lsr.b	#1,d0
	addx.b	d6,d6
	lsr.b	#1,d0
	addx.b	d7,d7
	rts

MakeHiresTable
	movem.l	d0-d7/a0-a6,-(a7)
	lea	HiresTable,a0
	moveq	#$00,d0
	moveq	#$00,d1
.1	moveq	#$00,d2
	btst	#$00,d0
	bne.s	.2
	move.b	d1,d2
.2	not.b	d2
	bsr	.Write
	addq.b	#1,d1
	bne.s	.1
	lea	$0300(a0),a0
.3	moveq	#$00,d2
	btst	#$01,d0
	beq.s	.4
	move.b	d1,d2
.4	bsr	.Write
	addq.b	#1,d1
	bne.s	.3
	lea	$0300(a0),a0
.5	moveq	#$00,d2
	btst	#$02,d0
	beq.s	.6
	move.b	d1,d2
.6	bsr	.Write
	addq.b	#1,d1
	bne.s	.5
	lea	$0300(a0),a0
.7	move.b	d1,d2
	bsr	.Write
	addq.b	#1,d1
	bne.s	.7
	lea	$0300(a0),a0
	addq.b	#1,d0
	cmp	#$08,d0
	bne.s	.1
	lea	MultiColorTable,a3
	move.w	#$0000,d0
.8	lea	0(a3,d0.w),a4
.9	move.b	0(a4,d1.w),d2
	bsr	.Write
	addq.b	#1,d1
	bne.s	.9
	lea	$0800(a4),a4
	lea	$0300(a0),a0
.10	move.b	0(a4,d1.w),d2
	bsr	.Write
	addq.b	#1,d1
	bne.s	.10
	lea	$0800(a4),a4
	lea	$0300(a0),a0
.11	move.b	0(a4,d1.w),d2
	bsr	.Write
	addq.b	#1,d1
	bne.s	.11
	lea	$0800(a4),a4
	lea	$0300(a0),a0
.12	move.b	0(a4,d1.w),d2
	bsr	.Write
	addq.b	#1,d1
	bne.s	.12
	lea	$0300(a0),a0
	add.w	#$0100,d0
	cmp.w	#$0800,d0
	bne.s	.8
	movem.l	(a7)+,d0-d7/a0-a6
	rts
.Write
	moveq	#$00,d3
	moveq	#$00,d4
.Write1
	add.l	d4,d4
	add.l	d4,d4
	add.l	d4,d4
	add.b	d2,d2
	bcc.s	.Write2
	or.w	#$07,d4
.Write2
	addq.b	#1,d3
	cmp.b	#$08,d3
	bne.s	.Write1
	lea	$100(a0),a1
	lea	$200(a0),a2
	move.b	d4,0(a2,d1.w)
	lsr.w	#8,d4
	move.b	d4,0(a1,d1.w)
	swap	d4
	move.b	d4,0(a0,d1.w)
	rts

InitColors
	movem.l	d0-d7/a0-a6,-(a7)
	lea	$dff000,a5
	lea	VIC20Mem+$8000,a0
	lea	ColorTable,a2
	move.b	$FFFF900E(a0),d6
	and.w	#$00f0,d6
	lsr.w	#3,d6
	move.w	0(a2,d6.w),$0184(a5)
	move.b	$FFFF900F(a0),d6
	move.w	d6,d7
	and.w	#$00f0,d6
	lsr.w	#3,d6
	move.w	0(a2,d6.w),$0182(a5)
	and.w	#$0007,d7
	add.w	d7,d7
	move.w	0(a2,d7.w),$0180(a5)
	move.l	(a2)+,$190(a5)
	move.l	(a2)+,$194(a5)
	move.l	(a2)+,$198(a5)
	move.l	(a2)+,$19c(a5)
	movem.l	(a7)+,d0-d7/a0-a6
	rts

ShowScreen
	tst.w	HorizWidth
	bne.s	.OK
	rts
.OK	tst.w	_hires
	bne	ShowScreenHires
	movem.l	d0-d7/a0-a6,-(a7)
	lea	VIC20Mem+$8000,a5
	lea	ScreenMem,a4
	btst	#0,$FFFF9003(a5)
	bne	ShowScreen8x16
	move.w	CurrentRow,d0
	cmp.w	VertLength,d0
	blt.s	.1
	moveq	#$00,d0
	move.w	d0,CurrentRow
.1	addq.w	#1,CurrentRow
	and.w	#$001f,d0
	move.w	d0,d1
	move.w	VideoAdress,d2
	mulu	HorizWidth,d1
	add.w	d1,d2
	lea	0(a5,d2.w),a3		;Video Matrix
	move.w	CharAdress,d3
	cmp.w	#$1c00,d3
	beq	ShowScreen1C00
	lea	0(a5,d3.w),a6		;Char Adress
	and.w	#$03ff,d2
	add.w	#$9400,d2
	lea	0(a5,d2.w),a5		;Color Matrix
	lsl.w	#6,d0
	move.w	d0,d1
	add.w	d1,d1
	add.w	d1,d1
	move.w	d1,d2
	add.w	d1,d1
	add.w	d1,d1
	lea	0(a4,d1.w),a4		;Bitplane Adress
	lea	RemColorMatrix,a1
	lea	0(a1,d0.w),a1		;Remember Color
	lea	RemVideoPixels,a2
	lea	0(a2,d2.w),a2		;Remember Pixels
	moveq	#$00,d0
	move.w	(a1)+,d5
	move.l	(a2)+,d1
	move.l	(a2)+,d2
	move.b	(a5)+,d6
	moveq	#$00,d4
	move.b	(a3)+,d4
	lsl.w	#3,d4
	lea	0(a6,d4.w),a0
	move.l	(a0),d3
	move.l	4(a0),d7

	cmp.b	d5,d6
	bne.s	.CheckScrollRight
	cmp.l	d1,d3
	bne.s	.CheckScrollRight
	cmp.l	d2,d7
	bne.s	.CheckScrollRight
	addq.l	#1,a4
	bra.s	.NextChar
.CheckScrollRight
	cmp.l	(a2),d3
	bne.s	.CheckScrollUp
	cmp.l	4(a2),d7
	bne.s	.CheckScrollUp
	cmp.b	1(a1),d6
	bne.s	.CheckScrollUp
	bsr	ScrollLeft
	addq.l	#1,a4
	bra.s	.NextChar
.CheckScrollUp
	move.w	CurrentRow,d1
	cmp.w	VertLength,d1
	bge.s	.DrawAgain
	cmp.l	$f8(a2),d3
	bne.s	.DrawAgain
	cmp.l	$fc(a2),d7
	bne.s	.DrawAgain
	cmp.b	$3f(a1),d6
	bne.s	.DrawAgain
	bsr	ScrollUp
	addq.l	#1,a4
.NextChar
	addq.w	#1,d0
	cmp.w	HorizWidth,d0
	beq	.End
	move.w	(a1)+,d5
	move.l	(a2)+,d1
	move.l	(a2)+,d2
	move.b	(a5)+,d6
	moveq	#$00,d4
	move.b	(a3)+,d4
	lsl.w	#3,d4
	lea	0(a6,d4.w),a0
	move.l	(a0),d3
	move.l	4(a0),d7

	cmp.b	d5,d6
	bne.s	.DrawAgain
	cmp.l	d1,d3
	bne.s	.DrawAgain
	cmp.l	d2,d7
	bne.s	.DrawAgain
	addq.l	#1,a4
	bra.s	.NextChar
.DrawAgain
	move.l	d3,-8(a2)
	move.l	d7,-4(a2)
	move.w	d6,-2(a1)
	and.w	#$000f,d6
	add.b	d6,d6
	move.w	.JMP(pc,d6.w),d5
	jmp	.JMP(pc,d5.w)
.JMP
	dc.w	.00-.JMP
	dc.w	.01-.JMP
	dc.w	.02-.JMP
	dc.w	.03-.JMP
	dc.w	.04-.JMP
	dc.w	.05-.JMP
	dc.w	.06-.JMP
	dc.w	.07-.JMP
	dc.w	.MultiColor00-.JMP
	dc.w	.MultiColor01-.JMP
	dc.w	.MultiColor02-.JMP
	dc.w	.MultiColor03-.JMP
	dc.w	.MultiColor04-.JMP
	dc.w	.MultiColor05-.JMP
	dc.w	.MultiColor06-.JMP
	dc.w	.MultiColor07-.JMP
.00
	move.w	d0,-(a7)
	move.b	(a0)+,d0
	move.b	(a0)+,d1
	move.b	(a0)+,d2
	addq.l	#1,a0
	move.b	(a0)+,d4
	move.b	(a0)+,d5
	move.b	(a0)+,d6
	move.b	d0,$60+$80*0(a4)
	move.b	d1,$60+$80*1(a4)
	move.b	d2,$60+$80*2(a4)
	move.b	d3,$60+$80*3(a4)
	move.b	d4,$60+$80*4(a4)
	move.b	d5,$60+$80*5(a4)
	move.b	d6,$60+$80*6(a4)
	move.b	d7,$60+$80*7(a4)
	clr.b	$40+$80*0(a4)
	clr.b	$40+$80*1(a4)
	clr.b	$40+$80*2(a4)
	clr.b	$40+$80*3(a4)
	clr.b	$40+$80*4(a4)
	clr.b	$40+$80*5(a4)
	clr.b	$40+$80*6(a4)
	clr.b	$40+$80*7(a4)
	clr.b	$20+$80*0(a4)
	clr.b	$20+$80*1(a4)
	clr.b	$20+$80*2(a4)
	clr.b	$20+$80*3(a4)
	clr.b	$20+$80*4(a4)
	clr.b	$20+$80*5(a4)
	clr.b	$20+$80*6(a4)
	clr.b	$20+$80*7(a4)
	not.b	d7
	move.b	d7,$80*7(a4)
	not.b	d6
	move.b	d6,$80*6(a4)
	not.b	d5
	move.b	d5,$80*5(a4)
	not.b	d4
	move.b	d4,$80*4(a4)
	not.b	d3
	move.b	d3,$80*3(a4)
	not.b	d2
	move.b	d2,$80*2(a4)
	not.b	d1
	move.b	d1,$80*1(a4)
	not.b	d0
	move.b	d0,(a4)+
	move.w	(a7)+,d0
	bra	.NextChar
.01
	move.w	d0,-(a7)
	move.b	(a0)+,d0
	move.b	(a0)+,d1
	move.b	(a0)+,d2
	addq.l	#1,a0
	move.b	(a0)+,d4
	move.b	(a0)+,d5
	move.b	(a0)+,d6
	move.b	d0,$60+$80*0(a4)
	move.b	d1,$60+$80*1(a4)
	move.b	d2,$60+$80*2(a4)
	move.b	d3,$60+$80*3(a4)
	move.b	d4,$60+$80*4(a4)
	move.b	d5,$60+$80*5(a4)
	move.b	d6,$60+$80*6(a4)
	move.b	d7,$60+$80*7(a4)
	clr.b	$40+$80*0(a4)
	clr.b	$40+$80*1(a4)
	clr.b	$40+$80*2(a4)
	clr.b	$40+$80*3(a4)
	clr.b	$40+$80*4(a4)
	clr.b	$40+$80*5(a4)
	clr.b	$40+$80*6(a4)
	clr.b	$40+$80*7(a4)
	clr.b	$20+$80*0(a4)
	clr.b	$20+$80*1(a4)
	clr.b	$20+$80*2(a4)
	clr.b	$20+$80*3(a4)
	clr.b	$20+$80*4(a4)
	clr.b	$20+$80*5(a4)
	clr.b	$20+$80*6(a4)
	clr.b	$20+$80*7(a4)
	st	$80*7(a4)
	st	$80*6(a4)
	st	$80*5(a4)
	st	$80*4(a4)
	st	$80*3(a4)
	st	$80*2(a4)
	st	$80*1(a4)
	st	(a4)+
	move.w	(a7)+,d0
	bra	.NextChar
.02
	move.w	d0,-(a7)
	move.b	(a0)+,d0
	move.b	(a0)+,d1
	move.b	(a0)+,d2
	addq.l	#1,a0
	move.b	(a0)+,d4
	move.b	(a0)+,d5
	move.b	(a0)+,d6
	move.b	d0,$60+$80*0(a4)
	move.b	d1,$60+$80*1(a4)
	move.b	d2,$60+$80*2(a4)
	move.b	d3,$60+$80*3(a4)
	move.b	d4,$60+$80*4(a4)
	move.b	d5,$60+$80*5(a4)
	move.b	d6,$60+$80*6(a4)
	move.b	d7,$60+$80*7(a4)
	clr.b	$40+$80*0(a4)
	clr.b	$40+$80*1(a4)
	clr.b	$40+$80*2(a4)
	clr.b	$40+$80*3(a4)
	clr.b	$40+$80*4(a4)
	clr.b	$40+$80*5(a4)
	clr.b	$40+$80*6(a4)
	clr.b	$40+$80*7(a4)
	move.b	d0,$20+$80*0(a4)
	move.b	d1,$20+$80*1(a4)
	move.b	d2,$20+$80*2(a4)
	move.b	d3,$20+$80*3(a4)
	move.b	d4,$20+$80*4(a4)
	move.b	d5,$20+$80*5(a4)
	move.b	d6,$20+$80*6(a4)
	move.b	d7,$20+$80*7(a4)
	not.b	d7
	move.b	d7,$80*7(a4)
	not.b	d6
	move.b	d6,$80*6(a4)
	not.b	d5
	move.b	d5,$80*5(a4)
	not.b	d4
	move.b	d4,$80*4(a4)
	not.b	d3
	move.b	d3,$80*3(a4)
	not.b	d2
	move.b	d2,$80*2(a4)
	not.b	d1
	move.b	d1,$80*1(a4)
	not.b	d0
	move.b	d0,(a4)+
	move.w	(a7)+,d0
	bra	.NextChar
.03
	move.w	d0,-(a7)
	move.b	(a0)+,d0
	move.b	(a0)+,d1
	move.b	(a0)+,d2
	addq.l	#1,a0
	move.b	(a0)+,d4
	move.b	(a0)+,d5
	move.b	(a0)+,d6
	move.b	d0,$60+$80*0(a4)
	move.b	d1,$60+$80*1(a4)
	move.b	d2,$60+$80*2(a4)
	move.b	d3,$60+$80*3(a4)
	move.b	d4,$60+$80*4(a4)
	move.b	d5,$60+$80*5(a4)
	move.b	d6,$60+$80*6(a4)
	move.b	d7,$60+$80*7(a4)
	clr.b	$40+$80*0(a4)
	clr.b	$40+$80*1(a4)
	clr.b	$40+$80*2(a4)
	clr.b	$40+$80*3(a4)
	clr.b	$40+$80*4(a4)
	clr.b	$40+$80*5(a4)
	clr.b	$40+$80*6(a4)
	clr.b	$40+$80*7(a4)
	move.b	d0,$20+$80*0(a4)
	move.b	d1,$20+$80*1(a4)
	move.b	d2,$20+$80*2(a4)
	move.b	d3,$20+$80*3(a4)
	move.b	d4,$20+$80*4(a4)
	move.b	d5,$20+$80*5(a4)
	move.b	d6,$20+$80*6(a4)
	move.b	d7,$20+$80*7(a4)
	st	$80*7(a4)
	st	$80*6(a4)
	st	$80*5(a4)
	st	$80*4(a4)
	st	$80*3(a4)
	st	$80*2(a4)
	st	$80*1(a4)
	st	(a4)+
	move.w	(a7)+,d0
	bra	.NextChar
.04
	move.w	d0,-(a7)
	move.b	(a0)+,d0
	move.b	(a0)+,d1
	move.b	(a0)+,d2
	addq.l	#1,a0
	move.b	(a0)+,d4
	move.b	(a0)+,d5
	move.b	(a0)+,d6
	move.b	d0,$60+$80*0(a4)
	move.b	d1,$60+$80*1(a4)
	move.b	d2,$60+$80*2(a4)
	move.b	d3,$60+$80*3(a4)
	move.b	d4,$60+$80*4(a4)
	move.b	d5,$60+$80*5(a4)
	move.b	d6,$60+$80*6(a4)
	move.b	d7,$60+$80*7(a4)
	move.b	d0,$40+$80*0(a4)
	move.b	d1,$40+$80*1(a4)
	move.b	d2,$40+$80*2(a4)
	move.b	d3,$40+$80*3(a4)
	move.b	d4,$40+$80*4(a4)
	move.b	d5,$40+$80*5(a4)
	move.b	d6,$40+$80*6(a4)
	move.b	d7,$40+$80*7(a4)
	clr.b	$20+$80*0(a4)
	clr.b	$20+$80*1(a4)
	clr.b	$20+$80*2(a4)
	clr.b	$20+$80*3(a4)
	clr.b	$20+$80*4(a4)
	clr.b	$20+$80*5(a4)
	clr.b	$20+$80*6(a4)
	clr.b	$20+$80*7(a4)
	not.b	d7
	move.b	d7,$80*7(a4)
	not.b	d6
	move.b	d6,$80*6(a4)
	not.b	d5
	move.b	d5,$80*5(a4)
	not.b	d4
	move.b	d4,$80*4(a4)
	not.b	d3
	move.b	d3,$80*3(a4)
	not.b	d2
	move.b	d2,$80*2(a4)
	not.b	d1
	move.b	d1,$80*1(a4)
	not.b	d0
	move.b	d0,(a4)+
	move.w	(a7)+,d0
	bra	.NextChar
.05
	move.w	d0,-(a7)
	move.b	(a0)+,d0
	move.b	(a0)+,d1
	move.b	(a0)+,d2
	addq.l	#1,a0
	move.b	(a0)+,d4
	move.b	(a0)+,d5
	move.b	(a0)+,d6
	move.b	d0,$60+$80*0(a4)
	move.b	d1,$60+$80*1(a4)
	move.b	d2,$60+$80*2(a4)
	move.b	d3,$60+$80*3(a4)
	move.b	d4,$60+$80*4(a4)
	move.b	d5,$60+$80*5(a4)
	move.b	d6,$60+$80*6(a4)
	move.b	d7,$60+$80*7(a4)
	move.b	d0,$40+$80*0(a4)
	move.b	d1,$40+$80*1(a4)
	move.b	d2,$40+$80*2(a4)
	move.b	d3,$40+$80*3(a4)
	move.b	d4,$40+$80*4(a4)
	move.b	d5,$40+$80*5(a4)
	move.b	d6,$40+$80*6(a4)
	move.b	d7,$40+$80*7(a4)
	clr.b	$20+$80*0(a4)
	clr.b	$20+$80*1(a4)
	clr.b	$20+$80*2(a4)
	clr.b	$20+$80*3(a4)
	clr.b	$20+$80*4(a4)
	clr.b	$20+$80*5(a4)
	clr.b	$20+$80*6(a4)
	clr.b	$20+$80*7(a4)
	st	$80*7(a4)
	st	$80*6(a4)
	st	$80*5(a4)
	st	$80*4(a4)
	st	$80*3(a4)
	st	$80*2(a4)
	st	$80*1(a4)
	st	(a4)+
	move.w	(a7)+,d0
	bra	.NextChar
.06
	move.w	d0,-(a7)
	move.b	(a0)+,d0
	move.b	(a0)+,d1
	move.b	(a0)+,d2
	addq.l	#1,a0
	move.b	(a0)+,d4
	move.b	(a0)+,d5
	move.b	(a0)+,d6
	move.b	d0,$60+$80*0(a4)
	move.b	d1,$60+$80*1(a4)
	move.b	d2,$60+$80*2(a4)
	move.b	d3,$60+$80*3(a4)
	move.b	d4,$60+$80*4(a4)
	move.b	d5,$60+$80*5(a4)
	move.b	d6,$60+$80*6(a4)
	move.b	d7,$60+$80*7(a4)
	move.b	d0,$40+$80*0(a4)
	move.b	d1,$40+$80*1(a4)
	move.b	d2,$40+$80*2(a4)
	move.b	d3,$40+$80*3(a4)
	move.b	d4,$40+$80*4(a4)
	move.b	d5,$40+$80*5(a4)
	move.b	d6,$40+$80*6(a4)
	move.b	d7,$40+$80*7(a4)
	move.b	d0,$20+$80*0(a4)
	move.b	d1,$20+$80*1(a4)
	move.b	d2,$20+$80*2(a4)
	move.b	d3,$20+$80*3(a4)
	move.b	d4,$20+$80*4(a4)
	move.b	d5,$20+$80*5(a4)
	move.b	d6,$20+$80*6(a4)
	move.b	d7,$20+$80*7(a4)
	not.b	d7
	move.b	d7,$80*7(a4)
	not.b	d6
	move.b	d6,$80*6(a4)
	not.b	d5
	move.b	d5,$80*5(a4)
	not.b	d4
	move.b	d4,$80*4(a4)
	not.b	d3
	move.b	d3,$80*3(a4)
	not.b	d2
	move.b	d2,$80*2(a4)
	not.b	d1
	move.b	d1,$80*1(a4)
	not.b	d0
	move.b	d0,(a4)+
	move.w	(a7)+,d0
	bra	.NextChar
.07
	move.w	d0,-(a7)
	move.b	(a0)+,d0
	move.b	(a0)+,d1
	move.b	(a0)+,d2
	addq.l	#1,a0
	move.b	(a0)+,d4
	move.b	(a0)+,d5
	move.b	(a0)+,d6
	move.b	d0,$60+$80*0(a4)
	move.b	d1,$60+$80*1(a4)
	move.b	d2,$60+$80*2(a4)
	move.b	d3,$60+$80*3(a4)
	move.b	d4,$60+$80*4(a4)
	move.b	d5,$60+$80*5(a4)
	move.b	d6,$60+$80*6(a4)
	move.b	d7,$60+$80*7(a4)
	move.b	d0,$40+$80*0(a4)
	move.b	d1,$40+$80*1(a4)
	move.b	d2,$40+$80*2(a4)
	move.b	d3,$40+$80*3(a4)
	move.b	d4,$40+$80*4(a4)
	move.b	d5,$40+$80*5(a4)
	move.b	d6,$40+$80*6(a4)
	move.b	d7,$40+$80*7(a4)
	move.b	d0,$20+$80*0(a4)
	move.b	d1,$20+$80*1(a4)
	move.b	d2,$20+$80*2(a4)
	move.b	d3,$20+$80*3(a4)
	move.b	d4,$20+$80*4(a4)
	move.b	d5,$20+$80*5(a4)
	move.b	d6,$20+$80*6(a4)
	move.b	d7,$20+$80*7(a4)
	st	$80*7(a4)
	st	$80*6(a4)
	st	$80*5(a4)
	st	$80*4(a4)
	st	$80*3(a4)
	st	$80*2(a4)
	st	$80*1(a4)
	st	(a4)+
	move.w	(a7)+,d0
	bra	.NextChar
.MultiColor00
	movem.l	d0/a1,-(a7)
	move.w	#$0000,d6
	bra.s	.MultiColor
.MultiColor01
	movem.l	d0/a1,-(a7)
	move.w	#$0100,d6
	bra.s	.MultiColor
.MultiColor02
	movem.l	d0/a1,-(a7)
	move.w	#$0200,d6
	bra.s	.MultiColor
.MultiColor03
	movem.l	d0/a1,-(a7)
	move.w	#$0300,d6
	bra.s	.MultiColor
.MultiColor04
	movem.l	d0/a1,-(a7)
	move.w	#$0400,d6
	bra.s	.MultiColor
.MultiColor05
	movem.l	d0/a1,-(a7)
	move.w	#$0500,d6
	bra.s	.MultiColor
.MultiColor06
	movem.l	d0/a1,-(a7)
	move.w	#$0600,d6
	bra.s	.MultiColor
.MultiColor07
	movem.l	d0/a1,-(a7)
	move.w	#$0700,d6
.MultiColor
	lea	MultiColorTable,a1
	lea	0(a1,d6.w),a1
	moveq	#$00,d0
	moveq	#$00,d1
	moveq	#$00,d2
	moveq	#$00,d3
	moveq	#$00,d4
	moveq	#$00,d5
	moveq	#$00,d6
	moveq	#$00,d7
	move.b	(a0)+,d0
	move.b	(a0)+,d1
	move.b	(a0)+,d2
	move.b	(a0)+,d3
	move.b	(a0)+,d4
	move.b	(a0)+,d5
	move.b	(a0)+,d6
	move.b	(a0)+,d7
	move.b	0(a1,d0.w),(a4)
	move.b	0(a1,d1.w),$80(a4)
	move.b	0(a1,d2.w),$80*2(a4)
	move.b	0(a1,d3.w),$80*3(a4)
	move.b	0(a1,d4.w),$80*4(a4)
	move.b	0(a1,d5.w),$80*5(a4)
	move.b	0(a1,d6.w),$80*6(a4)
	move.b	0(a1,d7.w),$80*7(a4)
	lea	$800(a1),a1
	move.b	0(a1,d0.w),$20(a4)
	move.b	0(a1,d1.w),$20+$80(a4)
	move.b	0(a1,d2.w),$20+$80*2(a4)
	move.b	0(a1,d3.w),$20+$80*3(a4)
	move.b	0(a1,d4.w),$20+$80*4(a4)
	move.b	0(a1,d5.w),$20+$80*5(a4)
	move.b	0(a1,d6.w),$20+$80*6(a4)
	move.b	0(a1,d7.w),$20+$80*7(a4)
	lea	$800(a1),a1
	move.b	0(a1,d0.w),$40(a4)
	move.b	0(a1,d1.w),$40+$80(a4)
	move.b	0(a1,d2.w),$40+$80*2(a4)
	move.b	0(a1,d3.w),$40+$80*3(a4)
	move.b	0(a1,d4.w),$40+$80*4(a4)
	move.b	0(a1,d5.w),$40+$80*5(a4)
	move.b	0(a1,d6.w),$40+$80*6(a4)
	move.b	0(a1,d7.w),$40+$80*7(a4)
	lea	$800(a1),a1
	move.b	0(a1,d0.w),$60(a4)
	move.b	0(a1,d1.w),$60+$80(a4)
	move.b	0(a1,d2.w),$60+$80*2(a4)
	move.b	0(a1,d3.w),$60+$80*3(a4)
	move.b	0(a1,d4.w),$60+$80*4(a4)
	move.b	0(a1,d5.w),$60+$80*5(a4)
	move.b	0(a1,d6.w),$60+$80*6(a4)
	move.b	0(a1,d7.w),$60+$80*7(a4)
	addq.l	#1,a4
	movem.l	(a7)+,d0/a1
	bra	.NextChar
.End
	movem.l	(a7)+,d0-d7/a0-a6
	rts

ShowScreenHires
	movem.l	d0-d7/a0-a6,-(a7)
	lea	VIC20Mem+$8000,a5
	lea	ScreenMem,a4
	btst	#0,$FFFF9003(a5)
	bne	ShowScreen8x16Hires
	move.w	CurrentRow,d0
	cmp.w	VertLength,d0
	blt.s	.1
	moveq	#$00,d0
	move.w	d0,CurrentRow
.1	addq.w	#1,CurrentRow
	and.w	#$001f,d0
	move.w	d0,d1
	move.w	VideoAdress,d2
	mulu	HorizWidth,d1
	add.w	d1,d2
	lea	0(a5,d2.w),a3		;Video Matrix
	move.w	CharAdress,d3
	cmp.w	#$1c00,d3
	beq	ShowScreen1C00Hires
	lea	0(a5,d3.w),a6		;Char Adress
	and.w	#$03ff,d2
	add.w	#$9400,d2
	lea	0(a5,d2.w),a5		;Color Matrix
	lsl.w	#6,d0			;d0 = *64
	move.w	d0,d1
	add.w	d1,d1
	add.w	d1,d1
	move.w	d1,d2			;d2 = *256
	ext.l	d1
	add.l	d1,d1			;Multiply with # Bitplanes
	add.l	d1,d1			;d1 = *1024
	move.l	d1,d3
	add.l	d1,d1
	add.l	d3,d1			;d1 = *3072
	lea	0(a4,d1.l),a4		;Bitplane Adress
	lea	RemColorMatrix,a1
	lea	0(a1,d0.w),a1		;Remember Color
	lea	RemVideoPixels,a2
	lea	0(a2,d2.w),a2		;Remember Pixels
	moveq	#$00,d0
	move.w	(a1)+,d5
	move.l	(a2)+,d1
	move.l	(a2)+,d2
	move.b	(a5)+,d6
	moveq	#$00,d4
	move.b	(a3)+,d4
	lsl.w	#3,d4
	lea	0(a6,d4.w),a0
	move.l	(a0),d3
	move.l	4(a0),d7

	cmp.b	d5,d6
	bne.s	.CheckScrollRight
	cmp.l	d1,d3
	bne.s	.CheckScrollRight
	cmp.l	d2,d7
	bne.s	.CheckScrollRight
	addq.l	#3,a4
	bra.s	.NextChar
.CheckScrollRight
	cmp.l	(a2),d3
	bne.s	.CheckScrollUp
	cmp.l	4(a2),d7
	bne.s	.CheckScrollUp
	cmp.b	1(a1),d6
	bra.s	.CheckScrollUp
;	bsr	ScrollLeftHires
	addq.l	#3,a4
	bra.s	.NextChar
.CheckScrollUp
	move.w	CurrentRow,d1
	cmp.w	VertLength,d1
	bge.s	.DrawAgain
	cmp.l	$f8(a2),d3
	bne.s	.DrawAgain
	cmp.l	$fc(a2),d7
	bne.s	.DrawAgain
	cmp.b	$3f(a1),d6
	bra.s	.DrawAgain
;	bsr	ScrollUpHires
	addq.l	#3,a4
.NextChar
	addq.w	#1,d0
	cmp.w	HorizWidth,d0
	beq	.End
	move.w	(a1)+,d5
	move.l	(a2)+,d1
	move.l	(a2)+,d2
	move.b	(a5)+,d6
	moveq	#$00,d4
	move.b	(a3)+,d4
	lsl.w	#3,d4
	lea	0(a6,d4.w),a0
	move.l	(a0),d3
	move.l	4(a0),d7
	cmp.b	d5,d6
	bne.s	.DrawAgain
	cmp.l	d1,d3
	bne.s	.DrawAgain
	cmp.l	d2,d7
	bne.s	.DrawAgain
	addq.l	#3,a4
	bra.s	.NextChar
.DrawAgain
	move.l	d3,-8(a2)
	move.l	d7,-4(a2)
	move.w	d6,-2(a1)
	move.w	d0,-(a7)
	and.w	#$000f,d6
	mulu	#$0c00,d6
	move.l	d6,-(a7)
	moveq	#$00,d1
	moveq	#$00,d2
	moveq	#$00,d3
	moveq	#$00,d4
	moveq	#$00,d5
	moveq	#$00,d6	
	moveq	#$00,d7
	move.b	(a0)+,d0
	move.b	(a0)+,d1
	move.b	(a0)+,d2
	move.b	(a0)+,d3
	move.b	(a0)+,d4
	move.b	(a0)+,d5
	move.b	(a0)+,d6
	move.b	(a0)+,d7
	lea	HiresTable,a0
	add.l	(a7)+,a0
	move.b	0(a0,d0.w),$80*0*3(a4)
	move.b	0(a0,d1.w),$80*1*3(a4)
	move.b	0(a0,d2.w),$80*2*3(a4)
	move.b	0(a0,d3.w),$80*3*3(a4)
	move.b	0(a0,d4.w),$80*4*3(a4)
	move.b	0(a0,d5.w),$80*5*3(a4)
	move.b	0(a0,d6.w),$80*6*3(a4)
	move.b	0(a0,d7.w),$80*7*3(a4)
	lea	$100(a0),a0
	move.b	0(a0,d0.w),$80*0*3+1(a4)
	move.b	0(a0,d1.w),$80*1*3+1(a4)
	move.b	0(a0,d2.w),$80*2*3+1(a4)
	move.b	0(a0,d3.w),$80*3*3+1(a4)
	move.b	0(a0,d4.w),$80*4*3+1(a4)
	move.b	0(a0,d5.w),$80*5*3+1(a4)
	move.b	0(a0,d6.w),$80*6*3+1(a4)
	move.b	0(a0,d7.w),$80*7*3+1(a4)
	lea	$100(a0),a0
	move.b	0(a0,d0.w),$80*0*3+2(a4)
	move.b	0(a0,d1.w),$80*1*3+2(a4)
	move.b	0(a0,d2.w),$80*2*3+2(a4)
	move.b	0(a0,d3.w),$80*3*3+2(a4)
	move.b	0(a0,d4.w),$80*4*3+2(a4)
	move.b	0(a0,d5.w),$80*5*3+2(a4)
	move.b	0(a0,d6.w),$80*6*3+2(a4)
	move.b	0(a0,d7.w),$80*7*3+2(a4)
	lea	$100(a0),a0
	move.b	0(a0,d0.w),$20*3+$80*0*3(a4)
	move.b	0(a0,d1.w),$20*3+$80*1*3(a4)
	move.b	0(a0,d2.w),$20*3+$80*2*3(a4)
	move.b	0(a0,d3.w),$20*3+$80*3*3(a4)
	move.b	0(a0,d4.w),$20*3+$80*4*3(a4)
	move.b	0(a0,d5.w),$20*3+$80*5*3(a4)
	move.b	0(a0,d6.w),$20*3+$80*6*3(a4)
	move.b	0(a0,d7.w),$20*3+$80*7*3(a4)
	lea	$100(a0),a0
	move.b	0(a0,d0.w),$20*3+$80*0*3+1(a4)
	move.b	0(a0,d1.w),$20*3+$80*1*3+1(a4)
	move.b	0(a0,d2.w),$20*3+$80*2*3+1(a4)
	move.b	0(a0,d3.w),$20*3+$80*3*3+1(a4)
	move.b	0(a0,d4.w),$20*3+$80*4*3+1(a4)
	move.b	0(a0,d5.w),$20*3+$80*5*3+1(a4)
	move.b	0(a0,d6.w),$20*3+$80*6*3+1(a4)
	move.b	0(a0,d7.w),$20*3+$80*7*3+1(a4)
	lea	$100(a0),a0
	move.b	0(a0,d0.w),$20*3+$80*0*3+2(a4)
	move.b	0(a0,d1.w),$20*3+$80*1*3+2(a4)
	move.b	0(a0,d2.w),$20*3+$80*2*3+2(a4)
	move.b	0(a0,d3.w),$20*3+$80*3*3+2(a4)
	move.b	0(a0,d4.w),$20*3+$80*4*3+2(a4)
	move.b	0(a0,d5.w),$20*3+$80*5*3+2(a4)
	move.b	0(a0,d6.w),$20*3+$80*6*3+2(a4)
	move.b	0(a0,d7.w),$20*3+$80*7*3+2(a4)
	lea	$100(a0),a0
	move.b	0(a0,d0.w),$40*3+$80*0*3(a4)
	move.b	0(a0,d1.w),$40*3+$80*1*3(a4)
	move.b	0(a0,d2.w),$40*3+$80*2*3(a4)
	move.b	0(a0,d3.w),$40*3+$80*3*3(a4)
	move.b	0(a0,d4.w),$40*3+$80*4*3(a4)
	move.b	0(a0,d5.w),$40*3+$80*5*3(a4)
	move.b	0(a0,d6.w),$40*3+$80*6*3(a4)
	move.b	0(a0,d7.w),$40*3+$80*7*3(a4)
	lea	$100(a0),a0
	move.b	0(a0,d0.w),$40*3+$80*0*3+1(a4)
	move.b	0(a0,d1.w),$40*3+$80*1*3+1(a4)
	move.b	0(a0,d2.w),$40*3+$80*2*3+1(a4)
	move.b	0(a0,d3.w),$40*3+$80*3*3+1(a4)
	move.b	0(a0,d4.w),$40*3+$80*4*3+1(a4)
	move.b	0(a0,d5.w),$40*3+$80*5*3+1(a4)
	move.b	0(a0,d6.w),$40*3+$80*6*3+1(a4)
	move.b	0(a0,d7.w),$40*3+$80*7*3+1(a4)
	lea	$100(a0),a0
	move.b	0(a0,d0.w),$40*3+$80*0*3+2(a4)
	move.b	0(a0,d1.w),$40*3+$80*1*3+2(a4)
	move.b	0(a0,d2.w),$40*3+$80*2*3+2(a4)
	move.b	0(a0,d3.w),$40*3+$80*3*3+2(a4)
	move.b	0(a0,d4.w),$40*3+$80*4*3+2(a4)
	move.b	0(a0,d5.w),$40*3+$80*5*3+2(a4)
	move.b	0(a0,d6.w),$40*3+$80*6*3+2(a4)
	move.b	0(a0,d7.w),$40*3+$80*7*3+2(a4)
	lea	$100(a0),a0
	move.b	0(a0,d0.w),$60*3+$80*0*3(a4)
	move.b	0(a0,d1.w),$60*3+$80*1*3(a4)
	move.b	0(a0,d2.w),$60*3+$80*2*3(a4)
	move.b	0(a0,d3.w),$60*3+$80*3*3(a4)
	move.b	0(a0,d4.w),$60*3+$80*4*3(a4)
	move.b	0(a0,d5.w),$60*3+$80*5*3(a4)
	move.b	0(a0,d6.w),$60*3+$80*6*3(a4)
	move.b	0(a0,d7.w),$60*3+$80*7*3(a4)
	lea	$100(a0),a0
	move.b	0(a0,d0.w),$60*3+$80*0*3+1(a4)
	move.b	0(a0,d1.w),$60*3+$80*1*3+1(a4)
	move.b	0(a0,d2.w),$60*3+$80*2*3+1(a4)
	move.b	0(a0,d3.w),$60*3+$80*3*3+1(a4)
	move.b	0(a0,d4.w),$60*3+$80*4*3+1(a4)
	move.b	0(a0,d5.w),$60*3+$80*5*3+1(a4)
	move.b	0(a0,d6.w),$60*3+$80*6*3+1(a4)
	move.b	0(a0,d7.w),$60*3+$80*7*3+1(a4)
	lea	$100(a0),a0
	move.b	0(a0,d0.w),$60*3+$80*0*3+2(a4)
	move.b	0(a0,d1.w),$60*3+$80*1*3+2(a4)
	move.b	0(a0,d2.w),$60*3+$80*2*3+2(a4)
	move.b	0(a0,d3.w),$60*3+$80*3*3+2(a4)
	move.b	0(a0,d4.w),$60*3+$80*4*3+2(a4)
	move.b	0(a0,d5.w),$60*3+$80*5*3+2(a4)
	move.b	0(a0,d6.w),$60*3+$80*6*3+2(a4)
	move.b	0(a0,d7.w),$60*3+$80*7*3+2(a4)
	addq.l	#3,a4
	move.w	(a7)+,d0
	bra	.NextChar
.End
	movem.l	(a7)+,d0-d7/a0-a6
	rts

ShowScreen1C00
	lea	0(a5,d3.w),a6		;Char Adress
	and.w	#$03ff,d2
	add.w	#$9400,d2
	lea	0(a5,d2.w),a5		;Color Matrix
	lsl.w	#6,d0
	move.w	d0,d1
	add.w	d1,d1
	add.w	d1,d1
	move.w	d1,d2
	add.w	d1,d1
	add.w	d1,d1
	lea	0(a4,d1.w),a4		;Bitplane Adress
	lea	RemColorMatrix,a1
	lea	0(a1,d0.w),a1		;Remember Color
	lea	RemVideoPixels,a2
	lea	0(a2,d2.w),a2		;Remember Pixels
	moveq	#$00,d0
	move.w	(a1)+,d5
	move.l	(a2)+,d1
	move.l	(a2)+,d2
	move.b	(a5)+,d6
	moveq	#$00,d4
	move.b	(a3)+,d4
	bpl.s	.1
	lsl.w	#3,d4
	lea	0(a6,d4.w),a0
	sub.l	#$a000,a0
	bra.s	.2
.1	lsl.w	#3,d4
	lea	0(a6,d4.w),a0
.2	move.l	(a0),d3
	move.l	4(a0),d7
	cmp.b	d5,d6
	bne.s	.CheckScrollRight
	cmp.l	d1,d3
	bne.s	.CheckScrollRight
	cmp.l	d2,d7
	bne.s	.CheckScrollRight
	addq.l	#1,a4
	bra.s	.NextChar
.CheckScrollRight
	cmp.l	(a2),d3
	bne.s	.CheckScrollUp
	cmp.l	4(a2),d7
	bne.s	.CheckScrollUp
	cmp.b	1(a1),d6
	bne.s	.CheckScrollUp
	bsr	ScrollLeft
	addq.l	#1,a4
	bra.s	.NextChar
.CheckScrollUp
	move.w	CurrentRow,d1
	cmp.w	VertLength,d1
	bge.s	.DrawAgain
	cmp.l	$f8(a2),d3
	bne.s	.DrawAgain
	cmp.l	$fc(a2),d7
	bne.s	.DrawAgain
	cmp.b	$3f(a1),d6
	bne.s	.DrawAgain
	bsr	ScrollUp
	addq.l	#1,a4
.NextChar
	addq.w	#1,d0
	cmp.w	HorizWidth,d0
	beq	.End
	move.w	(a1)+,d5
	move.l	(a2)+,d1
	move.l	(a2)+,d2
	move.b	(a5)+,d6
	moveq	#$00,d4
	move.b	(a3)+,d4
	bpl.s	.3
	lsl.w	#3,d4
	lea	0(a6,d4.w),a0
	sub.l	#$a000,a0
	bra.s	.4
.3	lsl.w	#3,d4
	lea	0(a6,d4.w),a0
.4	move.l	(a0),d3
	move.l	4(a0),d7
	cmp.b	d5,d6
	bne.s	.DrawAgain
	cmp.l	d1,d3
	bne.s	.DrawAgain
	cmp.l	d2,d7
	bne.s	.DrawAgain
	addq.l	#1,a4
	bra.s	.NextChar
.DrawAgain
	move.l	d3,-8(a2)
	move.l	d7,-4(a2)
	move.w	d6,-2(a1)
	and.w	#$000f,d6
	add.b	d6,d6
	move.w	.JMP(pc,d6.w),d5
	jmp	.JMP(pc,d5.w)
.JMP
	dc.w	.00-.JMP
	dc.w	.01-.JMP
	dc.w	.02-.JMP
	dc.w	.03-.JMP
	dc.w	.04-.JMP
	dc.w	.05-.JMP
	dc.w	.06-.JMP
	dc.w	.07-.JMP
	dc.w	.MultiColor00-.JMP
	dc.w	.MultiColor01-.JMP
	dc.w	.MultiColor02-.JMP
	dc.w	.MultiColor03-.JMP
	dc.w	.MultiColor04-.JMP
	dc.w	.MultiColor05-.JMP
	dc.w	.MultiColor06-.JMP
	dc.w	.MultiColor07-.JMP
.00
	move.w	d0,-(a7)
	move.b	(a0)+,d0
	move.b	(a0)+,d1
	move.b	(a0)+,d2
	addq.l	#1,a0
	move.b	(a0)+,d4
	move.b	(a0)+,d5
	move.b	(a0)+,d6
	move.b	d0,$60+$80*0(a4)
	move.b	d1,$60+$80*1(a4)
	move.b	d2,$60+$80*2(a4)
	move.b	d3,$60+$80*3(a4)
	move.b	d4,$60+$80*4(a4)
	move.b	d5,$60+$80*5(a4)
	move.b	d6,$60+$80*6(a4)
	move.b	d7,$60+$80*7(a4)
	clr.b	$40+$80*0(a4)
	clr.b	$40+$80*1(a4)
	clr.b	$40+$80*2(a4)
	clr.b	$40+$80*3(a4)
	clr.b	$40+$80*4(a4)
	clr.b	$40+$80*5(a4)
	clr.b	$40+$80*6(a4)
	clr.b	$40+$80*7(a4)
	clr.b	$20+$80*0(a4)
	clr.b	$20+$80*1(a4)
	clr.b	$20+$80*2(a4)
	clr.b	$20+$80*3(a4)
	clr.b	$20+$80*4(a4)
	clr.b	$20+$80*5(a4)
	clr.b	$20+$80*6(a4)
	clr.b	$20+$80*7(a4)
	not.b	d7
	move.b	d7,$80*7(a4)
	not.b	d6
	move.b	d6,$80*6(a4)
	not.b	d5
	move.b	d5,$80*5(a4)
	not.b	d4
	move.b	d4,$80*4(a4)
	not.b	d3
	move.b	d3,$80*3(a4)
	not.b	d2
	move.b	d2,$80*2(a4)
	not.b	d1
	move.b	d1,$80*1(a4)
	not.b	d0
	move.b	d0,(a4)+
	move.w	(a7)+,d0
	bra	.NextChar
.01
	move.w	d0,-(a7)
	move.b	(a0)+,d0
	move.b	(a0)+,d1
	move.b	(a0)+,d2
	addq.l	#1,a0
	move.b	(a0)+,d4
	move.b	(a0)+,d5
	move.b	(a0)+,d6
	move.b	d0,$60+$80*0(a4)
	move.b	d1,$60+$80*1(a4)
	move.b	d2,$60+$80*2(a4)
	move.b	d3,$60+$80*3(a4)
	move.b	d4,$60+$80*4(a4)
	move.b	d5,$60+$80*5(a4)
	move.b	d6,$60+$80*6(a4)
	move.b	d7,$60+$80*7(a4)
	clr.b	$40+$80*0(a4)
	clr.b	$40+$80*1(a4)
	clr.b	$40+$80*2(a4)
	clr.b	$40+$80*3(a4)
	clr.b	$40+$80*4(a4)
	clr.b	$40+$80*5(a4)
	clr.b	$40+$80*6(a4)
	clr.b	$40+$80*7(a4)
	clr.b	$20+$80*0(a4)
	clr.b	$20+$80*1(a4)
	clr.b	$20+$80*2(a4)
	clr.b	$20+$80*3(a4)
	clr.b	$20+$80*4(a4)
	clr.b	$20+$80*5(a4)
	clr.b	$20+$80*6(a4)
	clr.b	$20+$80*7(a4)
	st	$80*7(a4)
	st	$80*6(a4)
	st	$80*5(a4)
	st	$80*4(a4)
	st	$80*3(a4)
	st	$80*2(a4)
	st	$80*1(a4)
	st	(a4)+
	move.w	(a7)+,d0
	bra	.NextChar
.02
	move.w	d0,-(a7)
	move.b	(a0)+,d0
	move.b	(a0)+,d1
	move.b	(a0)+,d2
	addq.l	#1,a0
	move.b	(a0)+,d4
	move.b	(a0)+,d5
	move.b	(a0)+,d6
	move.b	d0,$60+$80*0(a4)
	move.b	d1,$60+$80*1(a4)
	move.b	d2,$60+$80*2(a4)
	move.b	d3,$60+$80*3(a4)
	move.b	d4,$60+$80*4(a4)
	move.b	d5,$60+$80*5(a4)
	move.b	d6,$60+$80*6(a4)
	move.b	d7,$60+$80*7(a4)
	clr.b	$40+$80*0(a4)
	clr.b	$40+$80*1(a4)
	clr.b	$40+$80*2(a4)
	clr.b	$40+$80*3(a4)
	clr.b	$40+$80*4(a4)
	clr.b	$40+$80*5(a4)
	clr.b	$40+$80*6(a4)
	clr.b	$40+$80*7(a4)
	move.b	d0,$20+$80*0(a4)
	move.b	d1,$20+$80*1(a4)
	move.b	d2,$20+$80*2(a4)
	move.b	d3,$20+$80*3(a4)
	move.b	d4,$20+$80*4(a4)
	move.b	d5,$20+$80*5(a4)
	move.b	d6,$20+$80*6(a4)
	move.b	d7,$20+$80*7(a4)
	not.b	d7
	move.b	d7,$80*7(a4)
	not.b	d6
	move.b	d6,$80*6(a4)
	not.b	d5
	move.b	d5,$80*5(a4)
	not.b	d4
	move.b	d4,$80*4(a4)
	not.b	d3
	move.b	d3,$80*3(a4)
	not.b	d2
	move.b	d2,$80*2(a4)
	not.b	d1
	move.b	d1,$80*1(a4)
	not.b	d0
	move.b	d0,(a4)+
	move.w	(a7)+,d0
	bra	.NextChar
.03
	move.w	d0,-(a7)
	move.b	(a0)+,d0
	move.b	(a0)+,d1
	move.b	(a0)+,d2
	addq.l	#1,a0
	move.b	(a0)+,d4
	move.b	(a0)+,d5
	move.b	(a0)+,d6
	move.b	d0,$60+$80*0(a4)
	move.b	d1,$60+$80*1(a4)
	move.b	d2,$60+$80*2(a4)
	move.b	d3,$60+$80*3(a4)
	move.b	d4,$60+$80*4(a4)
	move.b	d5,$60+$80*5(a4)
	move.b	d6,$60+$80*6(a4)
	move.b	d7,$60+$80*7(a4)
	clr.b	$40+$80*0(a4)
	clr.b	$40+$80*1(a4)
	clr.b	$40+$80*2(a4)
	clr.b	$40+$80*3(a4)
	clr.b	$40+$80*4(a4)
	clr.b	$40+$80*5(a4)
	clr.b	$40+$80*6(a4)
	clr.b	$40+$80*7(a4)
	move.b	d0,$20+$80*0(a4)
	move.b	d1,$20+$80*1(a4)
	move.b	d2,$20+$80*2(a4)
	move.b	d3,$20+$80*3(a4)
	move.b	d4,$20+$80*4(a4)
	move.b	d5,$20+$80*5(a4)
	move.b	d6,$20+$80*6(a4)
	move.b	d7,$20+$80*7(a4)
	st	$80*7(a4)
	st	$80*6(a4)
	st	$80*5(a4)
	st	$80*4(a4)
	st	$80*3(a4)
	st	$80*2(a4)
	st	$80*1(a4)
	st	(a4)+
	move.w	(a7)+,d0
	bra	.NextChar
.04
	move.w	d0,-(a7)
	move.b	(a0)+,d0
	move.b	(a0)+,d1
	move.b	(a0)+,d2
	addq.l	#1,a0
	move.b	(a0)+,d4
	move.b	(a0)+,d5
	move.b	(a0)+,d6
	move.b	d0,$60+$80*0(a4)
	move.b	d1,$60+$80*1(a4)
	move.b	d2,$60+$80*2(a4)
	move.b	d3,$60+$80*3(a4)
	move.b	d4,$60+$80*4(a4)
	move.b	d5,$60+$80*5(a4)
	move.b	d6,$60+$80*6(a4)
	move.b	d7,$60+$80*7(a4)
	move.b	d0,$40+$80*0(a4)
	move.b	d1,$40+$80*1(a4)
	move.b	d2,$40+$80*2(a4)
	move.b	d3,$40+$80*3(a4)
	move.b	d4,$40+$80*4(a4)
	move.b	d5,$40+$80*5(a4)
	move.b	d6,$40+$80*6(a4)
	move.b	d7,$40+$80*7(a4)
	clr.b	$20+$80*0(a4)
	clr.b	$20+$80*1(a4)
	clr.b	$20+$80*2(a4)
	clr.b	$20+$80*3(a4)
	clr.b	$20+$80*4(a4)
	clr.b	$20+$80*5(a4)
	clr.b	$20+$80*6(a4)
	clr.b	$20+$80*7(a4)
	not.b	d7
	move.b	d7,$80*7(a4)
	not.b	d6
	move.b	d6,$80*6(a4)
	not.b	d5
	move.b	d5,$80*5(a4)
	not.b	d4
	move.b	d4,$80*4(a4)
	not.b	d3
	move.b	d3,$80*3(a4)
	not.b	d2
	move.b	d2,$80*2(a4)
	not.b	d1
	move.b	d1,$80*1(a4)
	not.b	d0
	move.b	d0,(a4)+
	move.w	(a7)+,d0
	bra	.NextChar
.05
	move.w	d0,-(a7)
	move.b	(a0)+,d0
	move.b	(a0)+,d1
	move.b	(a0)+,d2
	addq.l	#1,a0
	move.b	(a0)+,d4
	move.b	(a0)+,d5
	move.b	(a0)+,d6
	move.b	d0,$60+$80*0(a4)
	move.b	d1,$60+$80*1(a4)
	move.b	d2,$60+$80*2(a4)
	move.b	d3,$60+$80*3(a4)
	move.b	d4,$60+$80*4(a4)
	move.b	d5,$60+$80*5(a4)
	move.b	d6,$60+$80*6(a4)
	move.b	d7,$60+$80*7(a4)
	move.b	d0,$40+$80*0(a4)
	move.b	d1,$40+$80*1(a4)
	move.b	d2,$40+$80*2(a4)
	move.b	d3,$40+$80*3(a4)
	move.b	d4,$40+$80*4(a4)
	move.b	d5,$40+$80*5(a4)
	move.b	d6,$40+$80*6(a4)
	move.b	d7,$40+$80*7(a4)
	clr.b	$20+$80*0(a4)
	clr.b	$20+$80*1(a4)
	clr.b	$20+$80*2(a4)
	clr.b	$20+$80*3(a4)
	clr.b	$20+$80*4(a4)
	clr.b	$20+$80*5(a4)
	clr.b	$20+$80*6(a4)
	clr.b	$20+$80*7(a4)
	st	$80*7(a4)
	st	$80*6(a4)
	st	$80*5(a4)
	st	$80*4(a4)
	st	$80*3(a4)
	st	$80*2(a4)
	st	$80*1(a4)
	st	(a4)+
	move.w	(a7)+,d0
	bra	.NextChar
.06
	move.w	d0,-(a7)
	move.b	(a0)+,d0
	move.b	(a0)+,d1
	move.b	(a0)+,d2
	addq.l	#1,a0
	move.b	(a0)+,d4
	move.b	(a0)+,d5
	move.b	(a0)+,d6
	move.b	d0,$60+$80*0(a4)
	move.b	d1,$60+$80*1(a4)
	move.b	d2,$60+$80*2(a4)
	move.b	d3,$60+$80*3(a4)
	move.b	d4,$60+$80*4(a4)
	move.b	d5,$60+$80*5(a4)
	move.b	d6,$60+$80*6(a4)
	move.b	d7,$60+$80*7(a4)
	move.b	d0,$40+$80*0(a4)
	move.b	d1,$40+$80*1(a4)
	move.b	d2,$40+$80*2(a4)
	move.b	d3,$40+$80*3(a4)
	move.b	d4,$40+$80*4(a4)
	move.b	d5,$40+$80*5(a4)
	move.b	d6,$40+$80*6(a4)
	move.b	d7,$40+$80*7(a4)
	move.b	d0,$20+$80*0(a4)
	move.b	d1,$20+$80*1(a4)
	move.b	d2,$20+$80*2(a4)
	move.b	d3,$20+$80*3(a4)
	move.b	d4,$20+$80*4(a4)
	move.b	d5,$20+$80*5(a4)
	move.b	d6,$20+$80*6(a4)
	move.b	d7,$20+$80*7(a4)
	not.b	d7
	move.b	d7,$80*7(a4)
	not.b	d6
	move.b	d6,$80*6(a4)
	not.b	d5
	move.b	d5,$80*5(a4)
	not.b	d4
	move.b	d4,$80*4(a4)
	not.b	d3
	move.b	d3,$80*3(a4)
	not.b	d2
	move.b	d2,$80*2(a4)
	not.b	d1
	move.b	d1,$80*1(a4)
	not.b	d0
	move.b	d0,(a4)+
	move.w	(a7)+,d0
	bra	.NextChar
.07
	move.w	d0,-(a7)
	move.b	(a0)+,d0
	move.b	(a0)+,d1
	move.b	(a0)+,d2
	addq.l	#1,a0
	move.b	(a0)+,d4
	move.b	(a0)+,d5
	move.b	(a0)+,d6
	move.b	d0,$60+$80*0(a4)
	move.b	d1,$60+$80*1(a4)
	move.b	d2,$60+$80*2(a4)
	move.b	d3,$60+$80*3(a4)
	move.b	d4,$60+$80*4(a4)
	move.b	d5,$60+$80*5(a4)
	move.b	d6,$60+$80*6(a4)
	move.b	d7,$60+$80*7(a4)
	move.b	d0,$40+$80*0(a4)
	move.b	d1,$40+$80*1(a4)
	move.b	d2,$40+$80*2(a4)
	move.b	d3,$40+$80*3(a4)
	move.b	d4,$40+$80*4(a4)
	move.b	d5,$40+$80*5(a4)
	move.b	d6,$40+$80*6(a4)
	move.b	d7,$40+$80*7(a4)
	move.b	d0,$20+$80*0(a4)
	move.b	d1,$20+$80*1(a4)
	move.b	d2,$20+$80*2(a4)
	move.b	d3,$20+$80*3(a4)
	move.b	d4,$20+$80*4(a4)
	move.b	d5,$20+$80*5(a4)
	move.b	d6,$20+$80*6(a4)
	move.b	d7,$20+$80*7(a4)
	st	$80*7(a4)
	st	$80*6(a4)
	st	$80*5(a4)
	st	$80*4(a4)
	st	$80*3(a4)
	st	$80*2(a4)
	st	$80*1(a4)
	st	(a4)+
	move.w	(a7)+,d0
	bra	.NextChar
.MultiColor00
	movem.l	d0/a1,-(a7)
	move.w	#$0000,d6
	bra.s	.MultiColor
.MultiColor01
	movem.l	d0/a1,-(a7)
	move.w	#$0100,d6
	bra.s	.MultiColor
.MultiColor02
	movem.l	d0/a1,-(a7)
	move.w	#$0200,d6
	bra.s	.MultiColor
.MultiColor03
	movem.l	d0/a1,-(a7)
	move.w	#$0300,d6
	bra.s	.MultiColor
.MultiColor04
	movem.l	d0/a1,-(a7)
	move.w	#$0400,d6
	bra.s	.MultiColor
.MultiColor05
	movem.l	d0/a1,-(a7)
	move.w	#$0500,d6
	bra.s	.MultiColor
.MultiColor06
	movem.l	d0/a1,-(a7)
	move.w	#$0600,d6
	bra.s	.MultiColor
.MultiColor07
	movem.l	d0/a1,-(a7)
	move.w	#$0700,d6
.MultiColor
	lea	MultiColorTable,a1
	lea	0(a1,d6.w),a1
	moveq	#$00,d0
	moveq	#$00,d1
	moveq	#$00,d2
	moveq	#$00,d3
	moveq	#$00,d4
	moveq	#$00,d5
	moveq	#$00,d6
	moveq	#$00,d7
	move.b	(a0)+,d0
	move.b	(a0)+,d1
	move.b	(a0)+,d2
	move.b	(a0)+,d3
	move.b	(a0)+,d4
	move.b	(a0)+,d5
	move.b	(a0)+,d6
	move.b	(a0)+,d7
	move.b	0(a1,d0.w),(a4)
	move.b	0(a1,d1.w),$80(a4)
	move.b	0(a1,d2.w),$80*2(a4)
	move.b	0(a1,d3.w),$80*3(a4)
	move.b	0(a1,d4.w),$80*4(a4)
	move.b	0(a1,d5.w),$80*5(a4)
	move.b	0(a1,d6.w),$80*6(a4)
	move.b	0(a1,d7.w),$80*7(a4)
	lea	$800(a1),a1
	move.b	0(a1,d0.w),$20(a4)
	move.b	0(a1,d1.w),$20+$80(a4)
	move.b	0(a1,d2.w),$20+$80*2(a4)
	move.b	0(a1,d3.w),$20+$80*3(a4)
	move.b	0(a1,d4.w),$20+$80*4(a4)
	move.b	0(a1,d5.w),$20+$80*5(a4)
	move.b	0(a1,d6.w),$20+$80*6(a4)
	move.b	0(a1,d7.w),$20+$80*7(a4)
	lea	$800(a1),a1
	move.b	0(a1,d0.w),$40(a4)
	move.b	0(a1,d1.w),$40+$80(a4)
	move.b	0(a1,d2.w),$40+$80*2(a4)
	move.b	0(a1,d3.w),$40+$80*3(a4)
	move.b	0(a1,d4.w),$40+$80*4(a4)
	move.b	0(a1,d5.w),$40+$80*5(a4)
	move.b	0(a1,d6.w),$40+$80*6(a4)
	move.b	0(a1,d7.w),$40+$80*7(a4)
	lea	$800(a1),a1
	move.b	0(a1,d0.w),$60(a4)
	move.b	0(a1,d1.w),$60+$80(a4)
	move.b	0(a1,d2.w),$60+$80*2(a4)
	move.b	0(a1,d3.w),$60+$80*3(a4)
	move.b	0(a1,d4.w),$60+$80*4(a4)
	move.b	0(a1,d5.w),$60+$80*5(a4)
	move.b	0(a1,d6.w),$60+$80*6(a4)
	move.b	0(a1,d7.w),$60+$80*7(a4)
	addq.l	#1,a4
	movem.l	(a7)+,d0/a1
	bra	.NextChar
.End
	movem.l	(a7)+,d0-d7/a0-a6
	rts

ShowScreen1C00Hires
	lea	0(a5,d3.w),a6		;Char Adress
	and.w	#$03ff,d2
	add.w	#$9400,d2
	lea	0(a5,d2.w),a5		;Color Matrix
	lsl.w	#6,d0
	move.w	d0,d1
	add.w	d1,d1
	add.w	d1,d1
	move.w	d1,d2
	ext.l	d1
	add.l	d1,d1
	add.l	d1,d1
	move.l	d1,d3
	add.l	d1,d1
	add.l	d3,d1
	lea	0(a4,d1.l),a4		;Bitplane Adress
	lea	RemColorMatrix,a1
	lea	0(a1,d0.w),a1		;Remember Color
	lea	RemVideoPixels,a2
	lea	0(a2,d2.w),a2		;Remember Pixels
	moveq	#$00,d0
	move.w	(a1)+,d5
	move.l	(a2)+,d1
	move.l	(a2)+,d2
	move.b	(a5)+,d6
	moveq	#$00,d4
	move.b	(a3)+,d4
	bpl.s	.1
	lsl.w	#3,d4
	lea	0(a6,d4.w),a0
	sub.l	#$a000,a0
	bra.s	.2
.1	lsl.w	#3,d4
	lea	0(a6,d4.w),a0
.2	move.l	(a0),d3
	move.l	4(a0),d7
	cmp.b	d5,d6
	bne.s	.CheckScrollRight
	cmp.l	d1,d3
	bne.s	.CheckScrollRight
	cmp.l	d2,d7
	bne.s	.CheckScrollRight
	addq.l	#3,a4
	bra.s	.NextChar
.CheckScrollRight
	cmp.l	(a2),d3
	bne.s	.CheckScrollUp
	cmp.l	4(a2),d7
	bne.s	.CheckScrollUp
	cmp.b	1(a1),d6
	bra.s	.CheckScrollUp
;	bsr	ScrollLeftHires
	addq.l	#3,a4
	bra.s	.NextChar
.CheckScrollUp
	move.w	CurrentRow,d1
	cmp.w	VertLength,d1
	bge.s	.DrawAgain
	cmp.l	$f8(a2),d3
	bne.s	.DrawAgain
	cmp.l	$fc(a2),d7
	bne.s	.DrawAgain
	cmp.b	$3f(a1),d6
	bra.s	.DrawAgain
;	bsr	ScrollUpHires
	addq.l	#3,a4
.NextChar
	addq.w	#1,d0
	cmp.w	HorizWidth,d0
	beq	.End
	move.w	(a1)+,d5
	move.l	(a2)+,d1
	move.l	(a2)+,d2
	move.b	(a5)+,d6
	moveq	#$00,d4
	move.b	(a3)+,d4
	bpl.s	.3
	lsl.w	#3,d4
	lea	0(a6,d4.w),a0
	sub.l	#$a000,a0
	bra.s	.4
.3	lsl.w	#3,d4
	lea	0(a6,d4.w),a0
.4	move.l	(a0),d3
	move.l	4(a0),d7
	cmp.b	d5,d6
	bne.s	.DrawAgain
	cmp.l	d1,d3
	bne.s	.DrawAgain
	cmp.l	d2,d7
	bne.s	.DrawAgain
	addq.l	#3,a4
	bra.s	.NextChar
.DrawAgain
	move.l	d3,-8(a2)
	move.l	d7,-4(a2)
	move.w	d6,-2(a1)
	move.w	d0,-(a7)
	and.w	#$000f,d6
	mulu	#$0c00,d6
	move.l	d6,-(a7)
	moveq	#$00,d1
	moveq	#$00,d2
	moveq	#$00,d3
	moveq	#$00,d4
	moveq	#$00,d5
	moveq	#$00,d6	
	moveq	#$00,d7
	move.b	(a0)+,d0
	move.b	(a0)+,d1
	move.b	(a0)+,d2
	move.b	(a0)+,d3
	move.b	(a0)+,d4
	move.b	(a0)+,d5
	move.b	(a0)+,d6
	move.b	(a0)+,d7
	lea	HiresTable,a0
	add.l	(a7)+,a0
	move.b	0(a0,d0.w),$80*0*3(a4)
	move.b	0(a0,d1.w),$80*1*3(a4)
	move.b	0(a0,d2.w),$80*2*3(a4)
	move.b	0(a0,d3.w),$80*3*3(a4)
	move.b	0(a0,d4.w),$80*4*3(a4)
	move.b	0(a0,d5.w),$80*5*3(a4)
	move.b	0(a0,d6.w),$80*6*3(a4)
	move.b	0(a0,d7.w),$80*7*3(a4)
	lea	$100(a0),a0
	move.b	0(a0,d0.w),$80*0*3+1(a4)
	move.b	0(a0,d1.w),$80*1*3+1(a4)
	move.b	0(a0,d2.w),$80*2*3+1(a4)
	move.b	0(a0,d3.w),$80*3*3+1(a4)
	move.b	0(a0,d4.w),$80*4*3+1(a4)
	move.b	0(a0,d5.w),$80*5*3+1(a4)
	move.b	0(a0,d6.w),$80*6*3+1(a4)
	move.b	0(a0,d7.w),$80*7*3+1(a4)
	lea	$100(a0),a0
	move.b	0(a0,d0.w),$80*0*3+2(a4)
	move.b	0(a0,d1.w),$80*1*3+2(a4)
	move.b	0(a0,d2.w),$80*2*3+2(a4)
	move.b	0(a0,d3.w),$80*3*3+2(a4)
	move.b	0(a0,d4.w),$80*4*3+2(a4)
	move.b	0(a0,d5.w),$80*5*3+2(a4)
	move.b	0(a0,d6.w),$80*6*3+2(a4)
	move.b	0(a0,d7.w),$80*7*3+2(a4)
	lea	$100(a0),a0
	move.b	0(a0,d0.w),$20*3+$80*0*3(a4)
	move.b	0(a0,d1.w),$20*3+$80*1*3(a4)
	move.b	0(a0,d2.w),$20*3+$80*2*3(a4)
	move.b	0(a0,d3.w),$20*3+$80*3*3(a4)
	move.b	0(a0,d4.w),$20*3+$80*4*3(a4)
	move.b	0(a0,d5.w),$20*3+$80*5*3(a4)
	move.b	0(a0,d6.w),$20*3+$80*6*3(a4)
	move.b	0(a0,d7.w),$20*3+$80*7*3(a4)
	lea	$100(a0),a0
	move.b	0(a0,d0.w),$20*3+$80*0*3+1(a4)
	move.b	0(a0,d1.w),$20*3+$80*1*3+1(a4)
	move.b	0(a0,d2.w),$20*3+$80*2*3+1(a4)
	move.b	0(a0,d3.w),$20*3+$80*3*3+1(a4)
	move.b	0(a0,d4.w),$20*3+$80*4*3+1(a4)
	move.b	0(a0,d5.w),$20*3+$80*5*3+1(a4)
	move.b	0(a0,d6.w),$20*3+$80*6*3+1(a4)
	move.b	0(a0,d7.w),$20*3+$80*7*3+1(a4)
	lea	$100(a0),a0
	move.b	0(a0,d0.w),$20*3+$80*0*3+2(a4)
	move.b	0(a0,d1.w),$20*3+$80*1*3+2(a4)
	move.b	0(a0,d2.w),$20*3+$80*2*3+2(a4)
	move.b	0(a0,d3.w),$20*3+$80*3*3+2(a4)
	move.b	0(a0,d4.w),$20*3+$80*4*3+2(a4)
	move.b	0(a0,d5.w),$20*3+$80*5*3+2(a4)
	move.b	0(a0,d6.w),$20*3+$80*6*3+2(a4)
	move.b	0(a0,d7.w),$20*3+$80*7*3+2(a4)
	lea	$100(a0),a0
	move.b	0(a0,d0.w),$40*3+$80*0*3(a4)
	move.b	0(a0,d1.w),$40*3+$80*1*3(a4)
	move.b	0(a0,d2.w),$40*3+$80*2*3(a4)
	move.b	0(a0,d3.w),$40*3+$80*3*3(a4)
	move.b	0(a0,d4.w),$40*3+$80*4*3(a4)
	move.b	0(a0,d5.w),$40*3+$80*5*3(a4)
	move.b	0(a0,d6.w),$40*3+$80*6*3(a4)
	move.b	0(a0,d7.w),$40*3+$80*7*3(a4)
	lea	$100(a0),a0
	move.b	0(a0,d0.w),$40*3+$80*0*3+1(a4)
	move.b	0(a0,d1.w),$40*3+$80*1*3+1(a4)
	move.b	0(a0,d2.w),$40*3+$80*2*3+1(a4)
	move.b	0(a0,d3.w),$40*3+$80*3*3+1(a4)
	move.b	0(a0,d4.w),$40*3+$80*4*3+1(a4)
	move.b	0(a0,d5.w),$40*3+$80*5*3+1(a4)
	move.b	0(a0,d6.w),$40*3+$80*6*3+1(a4)
	move.b	0(a0,d7.w),$40*3+$80*7*3+1(a4)
	lea	$100(a0),a0
	move.b	0(a0,d0.w),$40*3+$80*0*3+2(a4)
	move.b	0(a0,d1.w),$40*3+$80*1*3+2(a4)
	move.b	0(a0,d2.w),$40*3+$80*2*3+2(a4)
	move.b	0(a0,d3.w),$40*3+$80*3*3+2(a4)
	move.b	0(a0,d4.w),$40*3+$80*4*3+2(a4)
	move.b	0(a0,d5.w),$40*3+$80*5*3+2(a4)
	move.b	0(a0,d6.w),$40*3+$80*6*3+2(a4)
	move.b	0(a0,d7.w),$40*3+$80*7*3+2(a4)
	lea	$100(a0),a0
	move.b	0(a0,d0.w),$60*3+$80*0*3(a4)
	move.b	0(a0,d1.w),$60*3+$80*1*3(a4)
	move.b	0(a0,d2.w),$60*3+$80*2*3(a4)
	move.b	0(a0,d3.w),$60*3+$80*3*3(a4)
	move.b	0(a0,d4.w),$60*3+$80*4*3(a4)
	move.b	0(a0,d5.w),$60*3+$80*5*3(a4)
	move.b	0(a0,d6.w),$60*3+$80*6*3(a4)
	move.b	0(a0,d7.w),$60*3+$80*7*3(a4)
	lea	$100(a0),a0
	move.b	0(a0,d0.w),$60*3+$80*0*3+1(a4)
	move.b	0(a0,d1.w),$60*3+$80*1*3+1(a4)
	move.b	0(a0,d2.w),$60*3+$80*2*3+1(a4)
	move.b	0(a0,d3.w),$60*3+$80*3*3+1(a4)
	move.b	0(a0,d4.w),$60*3+$80*4*3+1(a4)
	move.b	0(a0,d5.w),$60*3+$80*5*3+1(a4)
	move.b	0(a0,d6.w),$60*3+$80*6*3+1(a4)
	move.b	0(a0,d7.w),$60*3+$80*7*3+1(a4)
	lea	$100(a0),a0
	move.b	0(a0,d0.w),$60*3+$80*0*3+2(a4)
	move.b	0(a0,d1.w),$60*3+$80*1*3+2(a4)
	move.b	0(a0,d2.w),$60*3+$80*2*3+2(a4)
	move.b	0(a0,d3.w),$60*3+$80*3*3+2(a4)
	move.b	0(a0,d4.w),$60*3+$80*4*3+2(a4)
	move.b	0(a0,d5.w),$60*3+$80*5*3+2(a4)
	move.b	0(a0,d6.w),$60*3+$80*6*3+2(a4)
	move.b	0(a0,d7.w),$60*3+$80*7*3+2(a4)
	addq.l	#3,a4
	move.w	(a7)+,d0
	bra	.NextChar
.End
	movem.l	(a7)+,d0-d7/a0-a6
	rts

ShowScreen8x16
	move.w	CurrentRow,d0
	cmp.w	VertLength,d0
	blt.s	.1
	moveq	#$00,d0
	move.w	d0,CurrentRow
.1	addq.w	#1,CurrentRow
	and.w	#$001f,d0
	move.w	d0,d1
	move.w	VideoAdress,d2
	mulu	HorizWidth,d1
	add.w	d1,d2
	lea	0(a5,d2.w),a3		;Video Matrix
	move.w	CharAdress,d3
	lea	0(a5,d3.w),a6		;Char Adress
	and.w	#$03ff,d2
	add.w	#$9400,d2
	lea	0(a5,d2.w),a5		;Color Matrix
	lsl.w	#7,d0
	move.w	d0,d1
	add.w	d1,d1
	add.w	d1,d1
	move.w	d1,d2
	add.w	d1,d1
	add.w	d1,d1
	lea	0(a4,d1.w),a4		;Bitplane Adress
	lea	RemColorMatrix,a1
	lea	0(a1,d0.w),a1		;Remember Color
	lea	RemVideoPixels,a2
	lea	0(a2,d2.w),a2		;Remember Pixels
	moveq	#$00,d0
	move.b	(a5)+,d6
	moveq	#$00,d4
	move.b	(a3)+,d4
	lsl.w	#4,d4
	lea	0(a6,d4.w),a0
	move.l	(a0),d3
	move.l	4(a0),d7
	move.l	8(a0),d1
	move.l	12(a0),d2
	move.w	(a1)+,d5

	cmp.b	d5,d6
	bne.s	.CheckScrollRight
	cmp.l	(a2),d3
	bne.s	.CheckScrollRight
	cmp.l	4(a2),d7
	bne.s	.CheckScrollRight
	cmp.l	$100(a2),d1
	bne.s	.CheckScrollRight
	cmp.l	$104(a2),d2
	bne.s	.CheckScrollRight
	addq.l	#8,a2
	addq.l	#1,a4
	bra.s	.NextChar
.CheckScrollRight
	bra	.DrawAgain
	cmp.l	8(a2),d3
	bne.s	.CheckScrollUp
	cmp.l	12(a2),d7
	bne.s	.CheckScrollUp
	cmp.l	$108(a2),d1
	bne.s	.CheckScrollUp
	cmp.l	$10c(a2),d2
	bne.s	.CheckScrollUp
	cmp.b	3(a1),d6
	bra.s	.CheckScrollUp
;	bsr	ScrollLeft8x16
	addq.l	#8,a2
	addq.l	#1,a4
	bra.s	.NextChar
.CheckScrollUp
	move.w	CurrentRow,d4
	cmp.w	VertLength,d4
	bge	.DrawAgain
	cmp.l	$200(a2),d3
	bne	.DrawAgain
	cmp.l	$204(a2),d7
	bne.s	.DrawAgain
	cmp.l	$300(a2),d1
	bne.s	.DrawAgain
	cmp.l	$304(a2),d2
	bne.s	.DrawAgain
	cmp.b	$83(a1),d6
	bra.s	.DrawAgain
;	bsr	ScrollUp8x16
	addq.l	#8,a2
	addq.l	#1,a4
.NextChar
	addq.w	#1,d0
	cmp.w	HorizWidth,d0
	beq	.End
	move.b	(a5)+,d6
	moveq	#$00,d4
	move.b	(a3)+,d4
	lsl.w	#4,d4
	lea	0(a6,d4.w),a0
	move.l	(a0),d3
	move.l	4(a0),d7
	move.l	8(a0),d1
	move.l	12(a0),d2
	move.w	(a1)+,d5
	cmp.b	d5,d6
	bne.s	.DrawAgain
	cmp.l	(a2),d3
	bne.s	.DrawAgain
	cmp.l	4(a2),d7
	bne.s	.DrawAgain
	cmp.l	$100(a2),d1
	bne.s	.DrawAgain
	cmp.l	$104(a2),d2
	bne.s	.DrawAgain
	addq.l	#8,a2
	addq.l	#1,a4
	bra.s	.NextChar
.DrawAgain
	move.l	d3,(a2)+
	move.l	d7,(a2)+
	move.l	d1,$f8(a2)
	move.l	d2,$fc(a2)
	move.w	d6,-2(a1)
	move.w	d6,$3e(a1)
	move.w	d6,-(a7)
	movem.l	d1/d2,-(a7)
	and.w	#$000f,d6
	add.b	d6,d6
	move.w	.JMP(pc,d6.w),d5
	jsr	.JMP(pc,d5.w)
	lea	$03ff(a4),a4
	movem.l	(a7)+,d3/d7
	move.w	(a7)+,d6
	and.w	#$000f,d6
	add.b	d6,d6
	move.w	.JMP(pc,d6.w),d5
	jsr	.JMP(pc,d5.w)
	lea	-$0400(a4),a4
	bra	.NextChar
.JMP
	dc.w	.00-.JMP
	dc.w	.01-.JMP
	dc.w	.02-.JMP
	dc.w	.03-.JMP
	dc.w	.04-.JMP
	dc.w	.05-.JMP
	dc.w	.06-.JMP
	dc.w	.07-.JMP
	dc.w	.MultiColor00-.JMP
	dc.w	.MultiColor01-.JMP
	dc.w	.MultiColor02-.JMP
	dc.w	.MultiColor03-.JMP
	dc.w	.MultiColor04-.JMP
	dc.w	.MultiColor05-.JMP
	dc.w	.MultiColor06-.JMP
	dc.w	.MultiColor07-.JMP
.00
	move.w	d0,-(a7)
	move.b	(a0)+,d0
	move.b	(a0)+,d1
	move.b	(a0)+,d2
	addq.l	#1,a0
	move.b	(a0)+,d4
	move.b	(a0)+,d5
	move.b	(a0)+,d6
	addq.l	#1,a0
	move.b	d0,$60+$80*0(a4)
	move.b	d1,$60+$80*1(a4)
	move.b	d2,$60+$80*2(a4)
	move.b	d3,$60+$80*3(a4)
	move.b	d4,$60+$80*4(a4)
	move.b	d5,$60+$80*5(a4)
	move.b	d6,$60+$80*6(a4)
	move.b	d7,$60+$80*7(a4)
	clr.b	$40+$80*0(a4)
	clr.b	$40+$80*1(a4)
	clr.b	$40+$80*2(a4)
	clr.b	$40+$80*3(a4)
	clr.b	$40+$80*4(a4)
	clr.b	$40+$80*5(a4)
	clr.b	$40+$80*6(a4)
	clr.b	$40+$80*7(a4)
	clr.b	$20+$80*0(a4)
	clr.b	$20+$80*1(a4)
	clr.b	$20+$80*2(a4)
	clr.b	$20+$80*3(a4)
	clr.b	$20+$80*4(a4)
	clr.b	$20+$80*5(a4)
	clr.b	$20+$80*6(a4)
	clr.b	$20+$80*7(a4)
	not.b	d7
	move.b	d7,$80*7(a4)
	not.b	d6
	move.b	d6,$80*6(a4)
	not.b	d5
	move.b	d5,$80*5(a4)
	not.b	d4
	move.b	d4,$80*4(a4)
	not.b	d3
	move.b	d3,$80*3(a4)
	not.b	d2
	move.b	d2,$80*2(a4)
	not.b	d1
	move.b	d1,$80*1(a4)
	not.b	d0
	move.b	d0,(a4)+
	move.w	(a7)+,d0
	rts
.01
	move.w	d0,-(a7)
	move.b	(a0)+,d0
	move.b	(a0)+,d1
	move.b	(a0)+,d2
	addq.l	#1,a0
	move.b	(a0)+,d4
	move.b	(a0)+,d5
	move.b	(a0)+,d6
	addq.l	#1,a0
	move.b	d0,$60+$80*0(a4)
	move.b	d1,$60+$80*1(a4)
	move.b	d2,$60+$80*2(a4)
	move.b	d3,$60+$80*3(a4)
	move.b	d4,$60+$80*4(a4)
	move.b	d5,$60+$80*5(a4)
	move.b	d6,$60+$80*6(a4)
	move.b	d7,$60+$80*7(a4)
	clr.b	$40+$80*0(a4)
	clr.b	$40+$80*1(a4)
	clr.b	$40+$80*2(a4)
	clr.b	$40+$80*3(a4)
	clr.b	$40+$80*4(a4)
	clr.b	$40+$80*5(a4)
	clr.b	$40+$80*6(a4)
	clr.b	$40+$80*7(a4)
	clr.b	$20+$80*0(a4)
	clr.b	$20+$80*1(a4)
	clr.b	$20+$80*2(a4)
	clr.b	$20+$80*3(a4)
	clr.b	$20+$80*4(a4)
	clr.b	$20+$80*5(a4)
	clr.b	$20+$80*6(a4)
	clr.b	$20+$80*7(a4)
	st	$80*7(a4)
	st	$80*6(a4)
	st	$80*5(a4)
	st	$80*4(a4)
	st	$80*3(a4)
	st	$80*2(a4)
	st	$80*1(a4)
	st	(a4)+
	move.w	(a7)+,d0
	rts
.02
	move.w	d0,-(a7)
	move.b	(a0)+,d0
	move.b	(a0)+,d1
	move.b	(a0)+,d2
	addq.l	#1,a0
	move.b	(a0)+,d4
	move.b	(a0)+,d5
	move.b	(a0)+,d6
	addq.l	#1,a0
	move.b	d0,$60+$80*0(a4)
	move.b	d1,$60+$80*1(a4)
	move.b	d2,$60+$80*2(a4)
	move.b	d3,$60+$80*3(a4)
	move.b	d4,$60+$80*4(a4)
	move.b	d5,$60+$80*5(a4)
	move.b	d6,$60+$80*6(a4)
	move.b	d7,$60+$80*7(a4)
	clr.b	$40+$80*0(a4)
	clr.b	$40+$80*1(a4)
	clr.b	$40+$80*2(a4)
	clr.b	$40+$80*3(a4)
	clr.b	$40+$80*4(a4)
	clr.b	$40+$80*5(a4)
	clr.b	$40+$80*6(a4)
	clr.b	$40+$80*7(a4)
	move.b	d0,$20+$80*0(a4)
	move.b	d1,$20+$80*1(a4)
	move.b	d2,$20+$80*2(a4)
	move.b	d3,$20+$80*3(a4)
	move.b	d4,$20+$80*4(a4)
	move.b	d5,$20+$80*5(a4)
	move.b	d6,$20+$80*6(a4)
	move.b	d7,$20+$80*7(a4)
	not.b	d7
	move.b	d7,$80*7(a4)
	not.b	d6
	move.b	d6,$80*6(a4)
	not.b	d5
	move.b	d5,$80*5(a4)
	not.b	d4
	move.b	d4,$80*4(a4)
	not.b	d3
	move.b	d3,$80*3(a4)
	not.b	d2
	move.b	d2,$80*2(a4)
	not.b	d1
	move.b	d1,$80*1(a4)
	not.b	d0
	move.b	d0,(a4)+
	move.w	(a7)+,d0
	rts
.03
	move.w	d0,-(a7)
	move.b	(a0)+,d0
	move.b	(a0)+,d1
	move.b	(a0)+,d2
	addq.l	#1,a0
	move.b	(a0)+,d4
	move.b	(a0)+,d5
	move.b	(a0)+,d6
	addq.l	#1,a0
	move.b	d0,$60+$80*0(a4)
	move.b	d1,$60+$80*1(a4)
	move.b	d2,$60+$80*2(a4)
	move.b	d3,$60+$80*3(a4)
	move.b	d4,$60+$80*4(a4)
	move.b	d5,$60+$80*5(a4)
	move.b	d6,$60+$80*6(a4)
	move.b	d7,$60+$80*7(a4)
	clr.b	$40+$80*0(a4)
	clr.b	$40+$80*1(a4)
	clr.b	$40+$80*2(a4)
	clr.b	$40+$80*3(a4)
	clr.b	$40+$80*4(a4)
	clr.b	$40+$80*5(a4)
	clr.b	$40+$80*6(a4)
	clr.b	$40+$80*7(a4)
	move.b	d0,$20+$80*0(a4)
	move.b	d1,$20+$80*1(a4)
	move.b	d2,$20+$80*2(a4)
	move.b	d3,$20+$80*3(a4)
	move.b	d4,$20+$80*4(a4)
	move.b	d5,$20+$80*5(a4)
	move.b	d6,$20+$80*6(a4)
	move.b	d7,$20+$80*7(a4)
	st	$80*7(a4)
	st	$80*6(a4)
	st	$80*5(a4)
	st	$80*4(a4)
	st	$80*3(a4)
	st	$80*2(a4)
	st	$80*1(a4)
	st	(a4)+
	move.w	(a7)+,d0
	rts
.04
	move.w	d0,-(a7)
	move.b	(a0)+,d0
	move.b	(a0)+,d1
	move.b	(a0)+,d2
	addq.l	#1,a0
	move.b	(a0)+,d4
	move.b	(a0)+,d5
	move.b	(a0)+,d6
	addq.l	#1,a0
	move.b	d0,$60+$80*0(a4)
	move.b	d1,$60+$80*1(a4)
	move.b	d2,$60+$80*2(a4)
	move.b	d3,$60+$80*3(a4)
	move.b	d4,$60+$80*4(a4)
	move.b	d5,$60+$80*5(a4)
	move.b	d6,$60+$80*6(a4)
	move.b	d7,$60+$80*7(a4)
	move.b	d0,$40+$80*0(a4)
	move.b	d1,$40+$80*1(a4)
	move.b	d2,$40+$80*2(a4)
	move.b	d3,$40+$80*3(a4)
	move.b	d4,$40+$80*4(a4)
	move.b	d5,$40+$80*5(a4)
	move.b	d6,$40+$80*6(a4)
	move.b	d7,$40+$80*7(a4)
	clr.b	$20+$80*0(a4)
	clr.b	$20+$80*1(a4)
	clr.b	$20+$80*2(a4)
	clr.b	$20+$80*3(a4)
	clr.b	$20+$80*4(a4)
	clr.b	$20+$80*5(a4)
	clr.b	$20+$80*6(a4)
	clr.b	$20+$80*7(a4)
	not.b	d7
	move.b	d7,$80*7(a4)
	not.b	d6
	move.b	d6,$80*6(a4)
	not.b	d5
	move.b	d5,$80*5(a4)
	not.b	d4
	move.b	d4,$80*4(a4)
	not.b	d3
	move.b	d3,$80*3(a4)
	not.b	d2
	move.b	d2,$80*2(a4)
	not.b	d1
	move.b	d1,$80*1(a4)
	not.b	d0
	move.b	d0,(a4)+
	move.w	(a7)+,d0
	rts
.05
	move.w	d0,-(a7)
	move.b	(a0)+,d0
	move.b	(a0)+,d1
	move.b	(a0)+,d2
	addq.l	#1,a0
	move.b	(a0)+,d4
	move.b	(a0)+,d5
	move.b	(a0)+,d6
	addq.l	#1,a0
	move.b	d0,$60+$80*0(a4)
	move.b	d1,$60+$80*1(a4)
	move.b	d2,$60+$80*2(a4)
	move.b	d3,$60+$80*3(a4)
	move.b	d4,$60+$80*4(a4)
	move.b	d5,$60+$80*5(a4)
	move.b	d6,$60+$80*6(a4)
	move.b	d7,$60+$80*7(a4)
	move.b	d0,$40+$80*0(a4)
	move.b	d1,$40+$80*1(a4)
	move.b	d2,$40+$80*2(a4)
	move.b	d3,$40+$80*3(a4)
	move.b	d4,$40+$80*4(a4)
	move.b	d5,$40+$80*5(a4)
	move.b	d6,$40+$80*6(a4)
	move.b	d7,$40+$80*7(a4)
	clr.b	$20+$80*0(a4)
	clr.b	$20+$80*1(a4)
	clr.b	$20+$80*2(a4)
	clr.b	$20+$80*3(a4)
	clr.b	$20+$80*4(a4)
	clr.b	$20+$80*5(a4)
	clr.b	$20+$80*6(a4)
	clr.b	$20+$80*7(a4)
	st	$80*7(a4)
	st	$80*6(a4)
	st	$80*5(a4)
	st	$80*4(a4)
	st	$80*3(a4)
	st	$80*2(a4)
	st	$80*1(a4)
	st	(a4)+
	move.w	(a7)+,d0
	rts
.06
	move.w	d0,-(a7)
	move.b	(a0)+,d0
	move.b	(a0)+,d1
	move.b	(a0)+,d2
	addq.l	#1,a0
	move.b	(a0)+,d4
	move.b	(a0)+,d5
	move.b	(a0)+,d6
	addq.l	#1,a0
	move.b	d0,$60+$80*0(a4)
	move.b	d1,$60+$80*1(a4)
	move.b	d2,$60+$80*2(a4)
	move.b	d3,$60+$80*3(a4)
	move.b	d4,$60+$80*4(a4)
	move.b	d5,$60+$80*5(a4)
	move.b	d6,$60+$80*6(a4)
	move.b	d7,$60+$80*7(a4)
	move.b	d0,$40+$80*0(a4)
	move.b	d1,$40+$80*1(a4)
	move.b	d2,$40+$80*2(a4)
	move.b	d3,$40+$80*3(a4)
	move.b	d4,$40+$80*4(a4)
	move.b	d5,$40+$80*5(a4)
	move.b	d6,$40+$80*6(a4)
	move.b	d7,$40+$80*7(a4)
	move.b	d0,$20+$80*0(a4)
	move.b	d1,$20+$80*1(a4)
	move.b	d2,$20+$80*2(a4)
	move.b	d3,$20+$80*3(a4)
	move.b	d4,$20+$80*4(a4)
	move.b	d5,$20+$80*5(a4)
	move.b	d6,$20+$80*6(a4)
	move.b	d7,$20+$80*7(a4)
	not.b	d7
	move.b	d7,$80*7(a4)
	not.b	d6
	move.b	d6,$80*6(a4)
	not.b	d5
	move.b	d5,$80*5(a4)
	not.b	d4
	move.b	d4,$80*4(a4)
	not.b	d3
	move.b	d3,$80*3(a4)
	not.b	d2
	move.b	d2,$80*2(a4)
	not.b	d1
	move.b	d1,$80*1(a4)
	not.b	d0
	move.b	d0,(a4)+
	move.w	(a7)+,d0
	rts
.07
	move.w	d0,-(a7)
	move.b	(a0)+,d0
	move.b	(a0)+,d1
	move.b	(a0)+,d2
	addq.l	#1,a0
	move.b	(a0)+,d4
	move.b	(a0)+,d5
	move.b	(a0)+,d6
	addq.l	#1,a0
	move.b	d0,$60+$80*0(a4)
	move.b	d1,$60+$80*1(a4)
	move.b	d2,$60+$80*2(a4)
	move.b	d3,$60+$80*3(a4)
	move.b	d4,$60+$80*4(a4)
	move.b	d5,$60+$80*5(a4)
	move.b	d6,$60+$80*6(a4)
	move.b	d7,$60+$80*7(a4)
	move.b	d0,$40+$80*0(a4)
	move.b	d1,$40+$80*1(a4)
	move.b	d2,$40+$80*2(a4)
	move.b	d3,$40+$80*3(a4)
	move.b	d4,$40+$80*4(a4)
	move.b	d5,$40+$80*5(a4)
	move.b	d6,$40+$80*6(a4)
	move.b	d7,$40+$80*7(a4)
	move.b	d0,$20+$80*0(a4)
	move.b	d1,$20+$80*1(a4)
	move.b	d2,$20+$80*2(a4)
	move.b	d3,$20+$80*3(a4)
	move.b	d4,$20+$80*4(a4)
	move.b	d5,$20+$80*5(a4)
	move.b	d6,$20+$80*6(a4)
	move.b	d7,$20+$80*7(a4)
	st	$80*7(a4)
	st	$80*6(a4)
	st	$80*5(a4)
	st	$80*4(a4)
	st	$80*3(a4)
	st	$80*2(a4)
	st	$80*1(a4)
	st	(a4)+
	move.w	(a7)+,d0
	rts
.MultiColor00
	movem.l	d0/a1,-(a7)
	move.w	#$0000,d6
	bra.s	.MultiColor
.MultiColor01
	movem.l	d0/a1,-(a7)
	move.w	#$0100,d6
	bra.s	.MultiColor
.MultiColor02
	movem.l	d0/a1,-(a7)
	move.w	#$0200,d6
	bra.s	.MultiColor
.MultiColor03
	movem.l	d0/a1,-(a7)
	move.w	#$0300,d6
	bra.s	.MultiColor
.MultiColor04
	movem.l	d0/a1,-(a7)
	move.w	#$0400,d6
	bra.s	.MultiColor
.MultiColor05
	movem.l	d0/a1,-(a7)
	move.w	#$0500,d6
	bra.s	.MultiColor
.MultiColor06
	movem.l	d0/a1,-(a7)
	move.w	#$0600,d6
	bra.s	.MultiColor
.MultiColor07
	movem.l	d0/a1,-(a7)
	move.w	#$0700,d6
.MultiColor
	lea	MultiColorTable,a1
	lea	0(a1,d6.w),a1
	moveq	#$00,d0
	moveq	#$00,d1
	moveq	#$00,d2
	moveq	#$00,d3
	moveq	#$00,d4
	moveq	#$00,d5
	moveq	#$00,d6
	moveq	#$00,d7
	move.b	(a0)+,d0
	move.b	(a0)+,d1
	move.b	(a0)+,d2
	move.b	(a0)+,d3
	move.b	(a0)+,d4
	move.b	(a0)+,d5
	move.b	(a0)+,d6
	move.b	(a0)+,d7
	move.b	0(a1,d0.w),(a4)
	move.b	0(a1,d1.w),$80(a4)
	move.b	0(a1,d2.w),$80*2(a4)
	move.b	0(a1,d3.w),$80*3(a4)
	move.b	0(a1,d4.w),$80*4(a4)
	move.b	0(a1,d5.w),$80*5(a4)
	move.b	0(a1,d6.w),$80*6(a4)
	move.b	0(a1,d7.w),$80*7(a4)
	lea	$800(a1),a1
	move.b	0(a1,d0.w),$20(a4)
	move.b	0(a1,d1.w),$20+$80(a4)
	move.b	0(a1,d2.w),$20+$80*2(a4)
	move.b	0(a1,d3.w),$20+$80*3(a4)
	move.b	0(a1,d4.w),$20+$80*4(a4)
	move.b	0(a1,d5.w),$20+$80*5(a4)
	move.b	0(a1,d6.w),$20+$80*6(a4)
	move.b	0(a1,d7.w),$20+$80*7(a4)
	lea	$800(a1),a1
	move.b	0(a1,d0.w),$40(a4)
	move.b	0(a1,d1.w),$40+$80(a4)
	move.b	0(a1,d2.w),$40+$80*2(a4)
	move.b	0(a1,d3.w),$40+$80*3(a4)
	move.b	0(a1,d4.w),$40+$80*4(a4)
	move.b	0(a1,d5.w),$40+$80*5(a4)
	move.b	0(a1,d6.w),$40+$80*6(a4)
	move.b	0(a1,d7.w),$40+$80*7(a4)
	lea	$800(a1),a1
	move.b	0(a1,d0.w),$60(a4)
	move.b	0(a1,d1.w),$60+$80(a4)
	move.b	0(a1,d2.w),$60+$80*2(a4)
	move.b	0(a1,d3.w),$60+$80*3(a4)
	move.b	0(a1,d4.w),$60+$80*4(a4)
	move.b	0(a1,d5.w),$60+$80*5(a4)
	move.b	0(a1,d6.w),$60+$80*6(a4)
	move.b	0(a1,d7.w),$60+$80*7(a4)
	addq.l	#1,a4
	movem.l	(a7)+,d0/a1
	rts
.End
	movem.l	(a7)+,d0-d7/a0-a6
	rts

ShowScreen8x16Hires
	move.w	CurrentRow,d0
	cmp.w	VertLength,d0
	blt.s	.1
	moveq	#$00,d0
	move.w	d0,CurrentRow
.1	addq.w	#1,CurrentRow
	and.w	#$000f,d0
	move.w	d0,d1
	move.w	VideoAdress,d2
	mulu	HorizWidth,d1
	add.w	d1,d2
	lea	0(a5,d2.w),a3		;Video Matrix
	move.w	CharAdress,d3
	lea	0(a5,d3.w),a6		;Char Adress
	and.w	#$03ff,d2
	add.w	#$9400,d2
	lea	0(a5,d2.w),a5		;Color Matrix
	lsl.w	#7,d0
	move.w	d0,d1
	add.w	d1,d1
	add.w	d1,d1
	move.w	d1,d2
	add.w	d1,d1
	add.w	d1,d1
	ext.l	d1
	move.l	d1,d3
	add.l	d1,d1
	add.l	d3,d1
	lea	0(a4,d1.l),a4		;Bitplane Adress
	lea	RemColorMatrix,a1
	lea	0(a1,d0.w),a1		;Remember Color
	lea	RemVideoPixels,a2
	lea	0(a2,d2.w),a2		;Remember Pixels
	moveq	#$00,d0
	move.b	(a5)+,d6
	moveq	#$00,d4
	move.b	(a3)+,d4
	lsl.w	#4,d4
	lea	0(a6,d4.w),a0
	move.l	(a0),d3
	move.l	4(a0),d7
	move.l	8(a0),d1
	move.l	12(a0),d2
	move.w	(a1)+,d5

	cmp.b	d5,d6
	bne.s	.CheckScrollRight
	cmp.l	(a2),d3
	bne.s	.CheckScrollRight
	cmp.l	4(a2),d7
	bne.s	.CheckScrollRight
	cmp.l	$100(a2),d1
	bne.s	.CheckScrollRight
	cmp.l	$104(a2),d2
	bne.s	.CheckScrollRight
	addq.l	#8,a2
	addq.l	#3,a4
	bra.s	.NextChar
.CheckScrollRight
	bra	.DrawAgain
	cmp.l	8(a2),d3
	bne.s	.CheckScrollUp
	cmp.l	12(a2),d7
	bne.s	.CheckScrollUp
	cmp.l	$108(a2),d1
	bne.s	.CheckScrollUp
	cmp.l	$10c(a2),d2
	bne.s	.CheckScrollUp
	cmp.b	3(a1),d6
	bra.s	.CheckScrollUp
;	bsr	ScrollLeft8x16
	addq.l	#8,a2
	addq.l	#3,a4
	bra.s	.NextChar
.CheckScrollUp
	move.w	CurrentRow,d4
	cmp.w	VertLength,d4
	bge	.DrawAgain
	cmp.l	$200(a2),d3
	bne	.DrawAgain
	cmp.l	$204(a2),d7
	bne.s	.DrawAgain
	cmp.l	$300(a2),d1
	bne.s	.DrawAgain
	cmp.l	$304(a2),d2
	bne.s	.DrawAgain
	cmp.b	$83(a1),d6
	bra.s	.DrawAgain
;	bsr	ScrollUp8x16
	addq.l	#8,a2
	addq.l	#3,a4
.NextChar
	addq.w	#1,d0
	cmp.w	HorizWidth,d0
	beq	.End
	move.b	(a5)+,d6
	moveq	#$00,d4
	move.b	(a3)+,d4
	lsl.w	#4,d4
	lea	0(a6,d4.w),a0
	move.l	(a0),d3
	move.l	4(a0),d7
	move.l	8(a0),d1
	move.l	12(a0),d2
	move.w	(a1)+,d5
	cmp.b	d5,d6
	bne.s	.DrawAgain
	cmp.l	(a2),d3
	bne.s	.DrawAgain
	cmp.l	4(a2),d7
	bne.s	.DrawAgain
	cmp.l	$100(a2),d1
	bne.s	.DrawAgain
	cmp.l	$104(a2),d2
	bne.s	.DrawAgain
	addq.l	#8,a2
	addq.l	#3,a4
	bra.s	.NextChar
.DrawAgain
	move.l	d3,(a2)+
	move.l	d7,(a2)+
	move.l	d1,$f8(a2)
	move.l	d2,$fc(a2)
	move.w	d6,-2(a1)
	move.w	d6,$3e(a1)
	move.w	d0,-(a7)
	and.w	#$000f,d6
	mulu	#$0c00,d6
	movem.l	d6/a0,-(a7)
	bsr	.Draw
	movem.l	(a7)+,d6/a0
	lea	$03ff*3(a4),a4
	addq.l	#8,a0
	bsr	.Draw
	lea	-$0400*3(a4),a4
	move.w	(a7)+,d0
	bra	.NextChar
.Draw	move.l	d6,-(a7)
	moveq	#$00,d1
	moveq	#$00,d2
	moveq	#$00,d3
	moveq	#$00,d4
	moveq	#$00,d5
	moveq	#$00,d6	
	moveq	#$00,d7
	move.b	(a0)+,d0
	move.b	(a0)+,d1
	move.b	(a0)+,d2
	move.b	(a0)+,d3
	move.b	(a0)+,d4
	move.b	(a0)+,d5
	move.b	(a0)+,d6
	move.b	(a0)+,d7
	lea	HiresTable,a0
	add.l	(a7)+,a0
	move.b	0(a0,d0.w),$80*0*3(a4)
	move.b	0(a0,d1.w),$80*1*3(a4)
	move.b	0(a0,d2.w),$80*2*3(a4)
	move.b	0(a0,d3.w),$80*3*3(a4)
	move.b	0(a0,d4.w),$80*4*3(a4)
	move.b	0(a0,d5.w),$80*5*3(a4)
	move.b	0(a0,d6.w),$80*6*3(a4)
	move.b	0(a0,d7.w),$80*7*3(a4)
	lea	$100(a0),a0
	move.b	0(a0,d0.w),$80*0*3+1(a4)
	move.b	0(a0,d1.w),$80*1*3+1(a4)
	move.b	0(a0,d2.w),$80*2*3+1(a4)
	move.b	0(a0,d3.w),$80*3*3+1(a4)
	move.b	0(a0,d4.w),$80*4*3+1(a4)
	move.b	0(a0,d5.w),$80*5*3+1(a4)
	move.b	0(a0,d6.w),$80*6*3+1(a4)
	move.b	0(a0,d7.w),$80*7*3+1(a4)
	lea	$100(a0),a0
	move.b	0(a0,d0.w),$80*0*3+2(a4)
	move.b	0(a0,d1.w),$80*1*3+2(a4)
	move.b	0(a0,d2.w),$80*2*3+2(a4)
	move.b	0(a0,d3.w),$80*3*3+2(a4)
	move.b	0(a0,d4.w),$80*4*3+2(a4)
	move.b	0(a0,d5.w),$80*5*3+2(a4)
	move.b	0(a0,d6.w),$80*6*3+2(a4)
	move.b	0(a0,d7.w),$80*7*3+2(a4)
	lea	$100(a0),a0
	move.b	0(a0,d0.w),$20*3+$80*0*3(a4)
	move.b	0(a0,d1.w),$20*3+$80*1*3(a4)
	move.b	0(a0,d2.w),$20*3+$80*2*3(a4)
	move.b	0(a0,d3.w),$20*3+$80*3*3(a4)
	move.b	0(a0,d4.w),$20*3+$80*4*3(a4)
	move.b	0(a0,d5.w),$20*3+$80*5*3(a4)
	move.b	0(a0,d6.w),$20*3+$80*6*3(a4)
	move.b	0(a0,d7.w),$20*3+$80*7*3(a4)
	lea	$100(a0),a0
	move.b	0(a0,d0.w),$20*3+$80*0*3+1(a4)
	move.b	0(a0,d1.w),$20*3+$80*1*3+1(a4)
	move.b	0(a0,d2.w),$20*3+$80*2*3+1(a4)
	move.b	0(a0,d3.w),$20*3+$80*3*3+1(a4)
	move.b	0(a0,d4.w),$20*3+$80*4*3+1(a4)
	move.b	0(a0,d5.w),$20*3+$80*5*3+1(a4)
	move.b	0(a0,d6.w),$20*3+$80*6*3+1(a4)
	move.b	0(a0,d7.w),$20*3+$80*7*3+1(a4)
	lea	$100(a0),a0
	move.b	0(a0,d0.w),$20*3+$80*0*3+2(a4)
	move.b	0(a0,d1.w),$20*3+$80*1*3+2(a4)
	move.b	0(a0,d2.w),$20*3+$80*2*3+2(a4)
	move.b	0(a0,d3.w),$20*3+$80*3*3+2(a4)
	move.b	0(a0,d4.w),$20*3+$80*4*3+2(a4)
	move.b	0(a0,d5.w),$20*3+$80*5*3+2(a4)
	move.b	0(a0,d6.w),$20*3+$80*6*3+2(a4)
	move.b	0(a0,d7.w),$20*3+$80*7*3+2(a4)
	lea	$100(a0),a0
	move.b	0(a0,d0.w),$40*3+$80*0*3(a4)
	move.b	0(a0,d1.w),$40*3+$80*1*3(a4)
	move.b	0(a0,d2.w),$40*3+$80*2*3(a4)
	move.b	0(a0,d3.w),$40*3+$80*3*3(a4)
	move.b	0(a0,d4.w),$40*3+$80*4*3(a4)
	move.b	0(a0,d5.w),$40*3+$80*5*3(a4)
	move.b	0(a0,d6.w),$40*3+$80*6*3(a4)
	move.b	0(a0,d7.w),$40*3+$80*7*3(a4)
	lea	$100(a0),a0
	move.b	0(a0,d0.w),$40*3+$80*0*3+1(a4)
	move.b	0(a0,d1.w),$40*3+$80*1*3+1(a4)
	move.b	0(a0,d2.w),$40*3+$80*2*3+1(a4)
	move.b	0(a0,d3.w),$40*3+$80*3*3+1(a4)
	move.b	0(a0,d4.w),$40*3+$80*4*3+1(a4)
	move.b	0(a0,d5.w),$40*3+$80*5*3+1(a4)
	move.b	0(a0,d6.w),$40*3+$80*6*3+1(a4)
	move.b	0(a0,d7.w),$40*3+$80*7*3+1(a4)
	lea	$100(a0),a0
	move.b	0(a0,d0.w),$40*3+$80*0*3+2(a4)
	move.b	0(a0,d1.w),$40*3+$80*1*3+2(a4)
	move.b	0(a0,d2.w),$40*3+$80*2*3+2(a4)
	move.b	0(a0,d3.w),$40*3+$80*3*3+2(a4)
	move.b	0(a0,d4.w),$40*3+$80*4*3+2(a4)
	move.b	0(a0,d5.w),$40*3+$80*5*3+2(a4)
	move.b	0(a0,d6.w),$40*3+$80*6*3+2(a4)
	move.b	0(a0,d7.w),$40*3+$80*7*3+2(a4)
	lea	$100(a0),a0
	move.b	0(a0,d0.w),$60*3+$80*0*3(a4)
	move.b	0(a0,d1.w),$60*3+$80*1*3(a4)
	move.b	0(a0,d2.w),$60*3+$80*2*3(a4)
	move.b	0(a0,d3.w),$60*3+$80*3*3(a4)
	move.b	0(a0,d4.w),$60*3+$80*4*3(a4)
	move.b	0(a0,d5.w),$60*3+$80*5*3(a4)
	move.b	0(a0,d6.w),$60*3+$80*6*3(a4)
	move.b	0(a0,d7.w),$60*3+$80*7*3(a4)
	lea	$100(a0),a0
	move.b	0(a0,d0.w),$60*3+$80*0*3+1(a4)
	move.b	0(a0,d1.w),$60*3+$80*1*3+1(a4)
	move.b	0(a0,d2.w),$60*3+$80*2*3+1(a4)
	move.b	0(a0,d3.w),$60*3+$80*3*3+1(a4)
	move.b	0(a0,d4.w),$60*3+$80*4*3+1(a4)
	move.b	0(a0,d5.w),$60*3+$80*5*3+1(a4)
	move.b	0(a0,d6.w),$60*3+$80*6*3+1(a4)
	move.b	0(a0,d7.w),$60*3+$80*7*3+1(a4)
	lea	$100(a0),a0
	move.b	0(a0,d0.w),$60*3+$80*0*3+2(a4)
	move.b	0(a0,d1.w),$60*3+$80*1*3+2(a4)
	move.b	0(a0,d2.w),$60*3+$80*2*3+2(a4)
	move.b	0(a0,d3.w),$60*3+$80*3*3+2(a4)
	move.b	0(a0,d4.w),$60*3+$80*4*3+2(a4)
	move.b	0(a0,d5.w),$60*3+$80*5*3+2(a4)
	move.b	0(a0,d6.w),$60*3+$80*6*3+2(a4)
	move.b	0(a0,d7.w),$60*3+$80*7*3+2(a4)
	addq.l	#3,a4
	rts
.End
	movem.l	(a7)+,d0-d7/a0-a6
	rts

ScrollLeft
	movem.l	d0-d7/a0-a6,-(a7)
	move.w	HorizWidth,d0
	subq.w	#1,d0
	beq	.End
	lsr.w	#1,d0
	bcc.s	.1
	move.w	(a1)+,-4(a1)
	move.l	(a2)+,-12(a2)
	move.l	(a2)+,-12(a2)
.1	lsr.w	#1,d0
	bcc.s	.2
	move.w	(a1)+,-4(a1)
	move.w	(a1)+,-4(a1)
	movem.l	(a2)+,d1-d4
	movem.l	d1-d4,-$18(a2)
.2	lsr.w	#1,d0
	bcc.s	.3
	movem.w	(a1)+,d1-d4
	movem.w	d1-d4,-$a(a1)
	movem.l	(a2)+,d1-d7/a0
	movem.l	d1-d7/a0,-$28(a2)
.3	lsr.w	#1,d0
	bcc.s	.4
	movem.w	(a1)+,d1-d7/a0
	movem.w	d1-d7/a0,-$12(a1)
	movem.l	(a2)+,d1-d7/a0
	movem.l	d1-d7/a0,-$28(a2)
	movem.l	(a2)+,d1-d7/a0
	movem.l	d1-d7/a0,-$28(a2)
.4	lsr.w	#1,d0
	bcc.s	.5
	movem.w	(a1)+,d1-d7/a0
	movem.w	d1-d7/a0,-$12(a1)
	movem.w	(a1)+,d1-d7/a0
	movem.w	d1-d7/a0,-$12(a1)
	movem.l	(a2)+,d1-d7/a0
	movem.l	d1-d7/a0,-$28(a2)
	movem.l	(a2)+,d1-d7/a0
	movem.l	d1-d7/a0,-$28(a2)
	movem.l	(a2)+,d1-d7/a0
	movem.l	d1-d7/a0,-$28(a2)
	movem.l	(a2)+,d1-d7/a0
	movem.l	d1-d7/a0,-$28(a2)
.5			
	move.w	#$0008,d0
	move.w	d0,-2(a1)
	move.w	d0,(a1)
	move.l	#$55555555,d0
	move.l	d0,-8(a2)
	move.l	d0,-4(a2)
	move.l	d0,(a2)
	move.l	d0,4(a2)
	move.w	HorizWidth,d0
	lea	$03e0(a4),a4
	lea	-1(a4,d0.w),a4
	addq.w	#1,d0
	moveq	#-1,d1
	lsr.w	#1,d0
	bcs.s	.6
	clr.b	d1
.6
	lea	$dff000,a6
	move.l	a4,$050(a6)		;BLTAPTH,BLTAPTL
	move.l	a4,$054(a6)		;BLTDPTH,BLTDPTL
	move.w	d1,$044(a6)		;BLTAFWM
	swap	d1
	move.w	d1,$046(a6)		;BLTALWM
	move.w	#$0010,d1
	sub.w	d0,d1
	add.w	d1,d1
	move.w	d1,$064(a6)		;BLTAMOD
	move.w	d1,$066(a6)		;BLTDMOD
	move.l	#$89f00002,$040(a6)	;BLTCON0,BLTCON1
	or.w	#$40*8*4,d0
	move.w	d0,$058(a6)		;BLTSIZE
	btst	#6,$002(a6)
.7	btst	#6,$002(a6)
	bne.s	.7
.End
	movem.l	(a7)+,d0-d7/a0-a6
	rts
ScrollUp
	movem.l	d0-d7/a0-a6,-(a7)
	move.w	HorizWidth,d0
	beq	.End
	addq.w	#1,d0
	lea	$00f8(a2),a2
	lea	$003e(a1),a1
	lsr.w	#1,d0
	bcc.s	.1
	move.w	(a1)+,-$42(a1)
	move.l	(a2)+,-$104(a2)
	move.l	(a2)+,-$104(a2)
.1	lsr.w	#1,d0
	bcc.s	.2
	move.w	(a1)+,-$42(a1)
	move.w	(a1)+,-$42(a1)
	movem.l	(a2)+,d1-d4
	movem.l	d1-d4,-$110(a2)
.2	lsr.w	#1,d0
	bcc.s	.3
	movem.w	(a1)+,d1-d4
	movem.w	d1-d4,-$48(a1)
	movem.l	(a2)+,d1-d7/a0
	movem.l	d1-d7/a0,-$120(a2)
.3	lsr.w	#1,d0
	bcc.s	.4
	movem.w	(a1)+,d1-d7/a0
	movem.w	d1-d7/a0,-$50(a1)
	movem.l	(a2)+,d1-d7/a0
	movem.l	d1-d7/a0,-$120(a2)
	movem.l	(a2)+,d1-d7/a0
	movem.l	d1-d7/a0,-$120(a2)
.4	lsr.w	#1,d0
	bcc.s	.5
	movem.w	(a1)+,d1-d7/a0
	movem.w	d1-d7/a0,-$50(a1)
	movem.w	(a1)+,d1-d7/a0
	movem.w	d1-d7/a0,-$50(a1)
	movem.l	(a2)+,d1-d7/a0
	movem.l	d1-d7/a0,-$120(a2)
	movem.l	(a2)+,d1-d7/a0
	movem.l	d1-d7/a0,-$120(a2)
	movem.l	(a2)+,d1-d7/a0
	movem.l	d1-d7/a0,-$120(a2)
	movem.l	(a2)+,d1-d7/a0
	movem.l	d1-d7/a0,-$120(a2)
.5			
	move.w	#$0008,d0
	move.w	d0,-$42(a1)
	move.w	d0,-$40(a1)
	move.l	#$55555555,d0
	move.l	d0,-$108(a2)
	move.l	d0,-$104(a2)
	move.l	d0,-$100(a2)
	move.l	d0,-$0fc(a2)
	move.w	HorizWidth,d0
	addq.w	#1,d0
	lsr.w	#1,d0
	lea	$dff000,a6
	move.l	a4,$054(a6)		;BLTDPTH,BLTDPTL
	lea	$0400(a4),a4
	move.l	a4,$050(a6)		;BLTAPTH,BLTAPTL
	moveq	#-1,d1
	move.w	d1,$044(a6)		;BLTAFWM
	swap	d1
	move.w	d1,$046(a6)		;BLTALWM
	move.w	#$0010,d1
	sub.w	d0,d1
	add.w	d1,d1
	move.w	d1,$064(a6)		;BLTAMOD
	move.w	d1,$066(a6)		;BLTDMOD
	move.l	#$09f00000,$040(a6)	;BLTCON0,BLTCON1
	or.w	#$40*8*4,d0
	move.w	d0,$058(a6)		;BLTSIZE
	btst	#6,$002(a6)
.7	btst	#6,$002(a6)
	bne.s	.7
.End
	movem.l	(a7)+,d0-d7/a0-a6
	rts
	


**************************************************
	Section	Data_C,DATA_C
CopperList
	dc.w	$0801,$fffe
	dc.w	$0140,$0000,$0142,$0000
	dc.w	$0148,$0000,$014a,$0000
	dc.w	$0150,$0000,$0152,$0000
	dc.w	$0158,$0000,$015a,$0000
	dc.w	$0160,$0000,$0162,$0000
	dc.w	$0168,$0000,$016a,$0000
	dc.w	$0170,$0000,$0172,$0000
	dc.w	$0178,$0000,$017a,$0000
	dc.w	$0100,$0200,$0104,$0024
CopperListBitplanes
	dc.w	$00e0,$0000,$00e2,$0000
	dc.w	$00e4,$0000,$00e6,$0000
	dc.w	$00e8,$0000,$00ea,$0000
	dc.w	$00ec,$0000,$00ee,$0000
	dc.w	$2001,$fffe
CopperListInterlace
CopperListHires
	dc.w	$0100,$4200
	dc.w	$008a,$0000
CopperListDummy
	dc.w	$ffff,$fffe


	Section	Data_F,DATA
****************************************************************************
* TYPE OF MEM : 00000000 = RAM , 01010101 = ROM , b0b0b0b0 = NC            *
****************************************************************************
VolumeTable
	dc.w	$0000,$0004,$0009,$000d
	dc.w	$0011,$0015,$001a,$001e
	dc.w	$0022,$0026,$002b,$002f
	dc.w	$0033,$0037,$003c,$0040
ColorTable
	dc.w	$0000,$0fff,$0f00,$00ff
	dc.w	$0f0f,$00f0,$000f,$0ff0
	dc.w	$0f80,$0fb8,$0f88,$08ff
	dc.w	$0f8f,$08f8,$088f,$0ff8
KeyboardData1
	dc.b	$10,$00,$70,$01,$71,$02,$72,$03
	dc.b	$73,$04,$74,$05,$75,$06,$80,$74
	dc.b	$60,$11,$61,$12,$62,$13,$63,$14
	dc.b	$64,$15,$65,$16,$80,$00,$70,$01

	dc.b	$21,$51,$22,$52,$23,$53,$24,$54
	dc.b	$25,$55,$26,$56,$80,$71,$02,$72
	dc.b	$66,$41,$32,$42,$33,$43,$34,$44
	dc.b	$35,$45,$36,$80,$80,$03,$73,$04

	dc.b	$40,$76,$80,$17,$17,$30,$07,$80
	dc.b	$80,$80,$75,$80,$b7,$37,$27,$a7
	dc.b	$47,$c7,$57,$d7,$67,$e7,$77,$f7
	dc.b	$66,$56,$d5,$a6,$36,$16,$05,$80

	dc.b	$31,$46,$80,$20,$80,$80,$50,$80
	dc.b	$80,$80,$80,$80,$80,$80,$80,$80
	dc.b	$80,$80,$80,$80,$80,$80,$80,$80
	dc.b	$80,$80,$80,$80,$80,$80,$80,$80
KeyboardData2
	dc.b	$7f,$7f,$7f,$7f,$7f,$7f,$7f,$7f
	dc.b	$7f,$7f,$7f,$7f,$7f,$7f,$7f,$7f
	dc.b	$7f,$7f,$7f,$7f,$7f,$7f,$7f,$7f
	dc.b	$7f,$7f,$7f,$7f,$7f,$7f,$7f,$7f

	dc.b	$7f,$7f,$7f,$7f,$7f,$7f,$7f,$7f
	dc.b	$7f,$7f,$7f,$7f,$7f,$7f,$7f,$7f
	dc.b	$7f,$7f,$7f,$7f,$7f,$7f,$7f,$7f
	dc.b	$7f,$7f,$7f,$7f,$7f,$7f,$7f,$7f

	dc.b	$7f,$7f,$7f,$7f,$7f,$7f,$7f,$7f
	dc.b	$7f,$7f,$7f,$7f,$31,$7f,$7f,$31
	dc.b	$7f,$31,$7f,$31,$7f,$31,$7f,$31
	dc.b	$7f,$7f,$7f,$7f,$7f,$7f,$7f,$80

	dc.b	$7f,$7f,$7f,$7f,$81,$82,$7f,$83
	dc.b	$7f,$7f,$7f,$7f,$7f,$7f,$7f,$7f
	dc.b	$7f,$7f,$7f,$7f,$7f,$7f,$7f,$7f
	dc.b	$7f,$7f,$7f,$7f,$7f,$7f,$7f,$7f
BasicRomMem
	Incbin	"BasicROM.data"
CharRomMem
	Incbin	"CharROM.data"
KernalRomMem
	Incbin	"KernalROM.data"
InstTable1
	dc.w	I00-I00,I01-I00,I02-I00,I03-I00,I04-I00,I05-I00,I06-I00,I07-I00
	dc.w	I08-I00,I09-I00,I0A-I00,I0B-I00,I0C-I00,I0D-I00,I0E-I00,I0F-I00
	dc.w	I10-I00,I11-I00,I12-I00,I13-I00,I14-I00,I15-I00,I16-I00,I17-I00
	dc.w	I18-I00,I19-I00,I1A-I00,I1B-I00,I1C-I00,I1D-I00,I1E-I00,I1F-I00

	dc.w	I20-I00,I21-I00,I22-I00,I23-I00,I24-I00,I25-I00,I26-I00,I27-I00
	dc.w	I28-I00,I29-I00,I2A-I00,I2B-I00,I2C-I00,I2D-I00,I2E-I00,I2F-I00
	dc.w	I30-I00,I31-I00,I32-I00,I33-I00,I34-I00,I35-I00,I36-I00,I37-I00
	dc.w	I38-I00,I39-I00,I3A-I00,I3B-I00,I3C-I00,I3D-I00,I3E-I00,I3F-I00

	dc.w	I40-I00,I41-I00,I42-I00,I43-I00,I44-I00,I45-I00,I46-I00,I47-I00
	dc.w	I48-I00,I49-I00,I4A-I00,I4B-I00,I4C-I00,I4D-I00,I4E-I00,I4F-I00
	dc.w	I50-I00,I51-I00,I52-I00,I53-I00,I54-I00,I55-I00,I56-I00,I57-I00
	dc.w	I58-I00,I59-I00,I5A-I00,I5B-I00,I5C-I00,I5D-I00,I5E-I00,I5F-I00

	dc.w	I60-I00,I61-I00,I62-I00,I63-I00,I64-I00,I65-I00,I66-I00,I67-I00
	dc.w	I68-I00,I69-I00,I6A-I00,I6B-I00,I6C-I00,I6D-I00,I6E-I00,I6F-I00
	dc.w	I70-I00,I71-I00,I72-I00,I73-I00,I74-I00,I75-I00,I76-I00,I77-I00
	dc.w	I78-I00,I79-I00,I7A-I00,I7B-I00,I7C-I00,I7D-I00,I7E-I00,I7F-I00

	dc.w	I80-I00,I81-I00,I82-I00,I83-I00,I84-I00,I85-I00,I86-I00,I87-I00
	dc.w	I88-I00,I89-I00,I8A-I00,I8B-I00,I8C-I00,I8D-I00,I8E-I00,I8F-I00
	dc.w	I90-I00,I91-I00,I92-I00,I93-I00,I94-I00,I95-I00,I96-I00,I97-I00
	dc.w	I98-I00,I99-I00,I9A-I00,I9B-I00,I9C-I00,I9D-I00,I9E-I00,I9F-I00

	dc.w	IA0-I00,IA1-I00,IA2-I00,IA3-I00,IA4-I00,IA5-I00,IA6-I00,IA7-I00
	dc.w	IA8-I00,IA9-I00,IAA-I00,IAB-I00,IAC-I00,IAD-I00,IAE-I00,IAF-I00
	dc.w	IB0-I00,IB1-I00,IB2-I00,IB3-I00,IB4-I00,IB5-I00,IB6-I00,IB7-I00
	dc.w	IB8-I00,IB9-I00,IBA-I00,IBB-I00,IBC-I00,IBD-I00,IBE-I00,IBF-I00

	dc.w	IC0-I00,IC1-I00,IC2-I00,IC3-I00,IC4-I00,IC5-I00,IC6-I00,IC7-I00
	dc.w	IC8-I00,IC9-I00,ICA-I00,ICB-I00,ICC-I00,ICD-I00,ICE-I00,ICF-I00
	dc.w	ID0-I00,ID1-I00,ID2-I00,ID3-I00,ID4-I00,ID5-I00,ID6-I00,ID7-I00
	dc.w	ID8-I00,ID9-I00,IDA-I00,IDB-I00,IDC-I00,IDD-I00,IDE-I00,IDF-I00

	dc.w	IE0-I00,IE1-I00,IE2-I00,IE3-I00,IE4-I00,IE5-I00,IE6-I00,IE7-I00
	dc.w	IE8-I00,IE9-I00,IEA-I00,IEB-I00,IEC-I00,IED-I00,IEE-I00,IEF-I00
	dc.w	IF0-I00,IF1-I00,IF2-I00,IF3-I00,IF4-I00,IF5-I00,IF6-I00,IF7-I00
	dc.w	IF8-I00,IF9-I00,IFA-I00,IFB-I00,IFC-I00,IFD-I00,IFE-I00,IFF-I00

	dc.w	IEND-I00

;NEXTINSTR:
;	move.b	(a6)+,$xxxx(a5)
;	jmp	$xxxx(a4)

;DEFAULT:
;	rts		move.w	d0,d3
;	rts		rts

I00					;BRK
	SetAStatus
	move.w	a6,d7
	sub.w	a0,d7
	addq.w	#1,d7			;PC+2
	move.w	d7,-(a7)
	swap	d1
	move.b	(a7)+,0(a0,d1.w)
	subq.b	#1,d1
	move.b	d6,0(a0,d1.w)
	subq.b	#1,d1
	swap	d1
	PUSHP				;Push P on Stack
	or.w	#$0400,d5		;I=1
	lea	$FFFFFFFE(a0),a6
	jmp	$4C00(a5)		;JMP xxxx
	
I01					;ORA - (Indirect,X)
	GETINDXADDR
	MMU2	.io
	or.b	0(a0,d7.w),d0
	NextInstStat			;N & Z
.io
	INPUT
	or.b	d6,d0
	NextInstStat			;N & Z

I02					;TRAP
	clr.b	reqInterrupt(a0)
	st	reqTRAP(a0)
	bra.s	I02-4

I03					;+ ASL,ORA - (Ind,X)
	GETINDXADDR
	MMU	.rom
	lea	0(a0,d7.w),a2
	move.b	(a2),d6
	add.b	d6,d6
	scs	d4			;C
	move.b	d6,(a2)
	or.b	d6,d0
	NextInstStat
.rom
	bmi.s	.io
	lea	0(a0,d7.w),a2
	move.b	(a2),d6
	add.b	d6,d6
	scs	d4			;C
	or.b	d6,d0
	NextInstStat
.io
	INPUT
	add.b	d6,d6
	scs	d4			;C
	or.b	d6,d0
	move.w	d0,d3
	_OUTPUT

I04					;+ NOP - Zero Page
	addq.l	#1,a6
	NextInstStat2

I05					;ORA - Zero Page
	move.b	(a6)+,d6
	or.b	0(a0,d6.w),d0
	NextInstStat			;N & Z

I06					;ASL - Zero Page
	move.b	(a6)+,d6
	lea	0(a0,d6.w),a2
	move.b	(a2),d6
	add.b	d6,d6
	scs	d4			;C
	move.w	d6,d3			;N & Z
	move.b	d6,(a2)
	NextInst

I07					;+ ASL,ORA - Zero Page
	move.b	(a6)+,d6
	lea	0(a0,d6.w),a2
	move.b	(a2),d6
	add.b	d6,d6
	scs	d4			;C
	move.b	d6,(a2)
	or.b	d6,d0
	NextInstStat

I08					;PHP
					;C64 SR:NV_BDIZC
	SetAStatus
	move.w	d5,-(a7)
	move.b	(a7)+,d7		;B,D,I
	move.w	d5,d6
	and.w	#$0040,d6		;V
	or.w	d6,d7
	move.w	d4,d6
	and.w	#$0001,d6		;C
	or.w	d6,d7
	tst.w	d3
	bpl.s	.1
	or.w	#$0080,d7
.1
	tst.b	d3
	bpl.s	.2
	or.w	#$0080,d7
.2
	bne.s	.3
	or.w	#$0002,d7
.3
	swap	d1
	move.b	d7,0(a0,d1.w)
	subq.b	#1,d1
	swap	d1
	NextInst

I09					;ORA - Immediate
	or.b	(a6)+,d0
	NextInstStat			;N & Z

I0A					;ASL - Accumulator
	add.b	d0,d0
	scs	d4			;C
	NextInstStat			;N & Z

I0B					;+ AND,ASL - Immeditate
	and.b	(a6)+,d0
	move.w	d0,d6
	add.b	d6,d6
	scs	d4			;C
	move.w	d6,d3			;N & Z
	NextInst

I0C					;+ NOP - Absolute
	addq.l	#2,a6
	NextInstStat2

I0D					;ORA - Absolute
	GETABSADDR
	MMU2	.io
	or.b	0(a0,d7.w),d0
	NextInstStat			;N & Z
.io
	INPUT
	or.b	d6,d0
	NextInstStat			;N & Z

I0E					;ASL - Absolute
	GETABSADDR
	MMU	.rom
	lea	0(a0,d7.w),a2
	move.b	(a2),d6
	add.b	d6,d6
	scs	d4			;C
	move.w	d6,d3			;N & Z
	move.b	d6,(a2)
	NextInst
.rom
	bmi.s	.io
	move.b	0(a0,d7.w),d6
	add.b	d6,d6
	scs	d4			;C
	move.w	d6,d3			;N & Z
	NextInst
.io
	ASLIO

I0F					;+ ASL,ORA - Absolute
	GETABSADDR
	MMU	.rom
	lea	0(a0,d7.w),a2
	move.b	(a2),d6
	add.b	d6,d6
	scs	d4			;C
	move.b	d6,(a2)
	or.b	d6,d0
	NextInstStat
.rom
	bmi.s	.io
	move.b	0(a0,d7.w),d6
	add.b	d6,d6
	scs	d4
	or.b	d6,d0
	NextInstStat
.io
	INPUT
	add.b	d6,d6
	scs	d4			;C
	or.b	d6,d0
	move.w	d0,d3
	_OUTPUT

I10					;BPL
	move.b	(a6)+,d7
	tst.w	d3			;N
	bmi.s	.1
	tst.b	d3			;N
	bmi.s	.1
	ext.w	d7
	adda.w	d7,a6
.1
	NextInst
	IfStatus
	move.b	(a6)+,d7
	tst.b	d0			;N
	bmi.s	.2
	ext.w	d7
	adda.w	d7,a6
.2
	NextInstStat

I11					;ORA - (Indirect),y
	GETINDYADDR
	MMU2	.io
	or.b	0(a0,d7.w),d0
	NextInstStat
.io
	INPUT
	or.b	d6,d0
	NextInstStat

I12					;???
	NextInstStat2

I13					;+ ASL,ORA - (Indirect),Y
	GETINDYADDR
	MMU	.rom
	lea	0(a0,d7.w),a2
	move.b	(a2),d6
	add.b	d6,d6
	scs	d4			;C
	move.b	d6,(a2)
	or.b	d6,d0
	NextInstStat
.rom
	bmi.s	.io
	move.b	0(a0,d7.w),d6
	add.b	d6,d6
	scs	d4			;C
	or.b	d6,d0
	NextInstStat
.io
	INPUT
	add.b	d6,d6
	scs	d4			;C
	or.b	d6,d0
	move.w	d0,d3
	_OUTPUT

I14					;+ NOP - Zero Page
	addq.l	#1,a6
	NextInstStat2

I15					;ORA - Zero Page,X
	move.b	(a6)+,d6
	add.b	d1,d6			;X
	or.b	0(a0,d6.w),d0
	NextInstStat

I16					;ASL - Zero Page,X
	move.b	(a6)+,d6
	add.b	d1,d6			;X
	lea	0(a0,d6.w),a2
	move.b	(a2),d6
	add.b	d6,d6
	scs	d4			;C
	move.w	d6,d3			;N & Z
	move.b	d6,(a2)
	NextInst

I17					;+ ASL,ORA - Zero Page,X
	move.b	(a6)+,d6
	add.b	d1,d6			;X
	lea	0(a0,d6.w),a2
	move.b	(a2),d6
	add.b	d6,d6
	scs	d4			;C
	move.b	d6,(a2)
	or.b	d6,d0
	NextInstStat

I18					;CLC
	sub.b	d4,d4			;X___C
	NextInstStat2

I19					;ORA - Absolute,Y
	GETABSYADDR
	MMU2	.io
	or.b	0(a0,d7.w),d0
	NextInstStat
.io
	INPUT
	or.b	d6,d0
	NextInstStat

I1A					;+ NOP
	NextInstStat2

I1B					;+ ASL,ORA - Absolute,Y
	GETABSYADDR
	MMU	.rom
	lea	0(a0,d7.w),a2
	move.b	(a2),d6
	add.b	d6,d6
	scs	d4			;C
	move.b	d6,(a2)
	or.b	d6,d0
	NextInstStat
.rom
	bmi.s	.io
	move.b	0(a0,d7.w),d6
	add.b	d6,d6
	scs	d4			;C
	or.b	d6,d0
	NextInstStat
.io
	INPUT
	add.b	d6,d6
	scs	d4			;C
	or.b	d6,d0
	move.w	d0,d3
	_OUTPUT

I1C					;+ NOP - Absolute
	addq.l	#2,a6
	NextInstStat2

I1D					;ORA - Absolute,X
	GETABSXADDR
	MMU2	.io
	or.b	0(a0,d7.w),d0
	NextInstStat
.io
	INPUT
	or.b	d6,d0
	NextInstStat
	
I1E					;ASL - Absolute,X
	GETABSXADDR
	MMU	.rom
	lea	0(a0,d7.w),a2
	move.b	(a2),d6
	add.b	d6,d6
	scs	d4			;C
	move.w	d6,d3			;N & Z
	move.b	d6,(a2)
	NextInst
.rom
	bmi.s	.io
	move.b	0(a0,d7.w),d6
	add.b	d6,d6
	scs	d4			;C
	move.w	d6,d3			;N & Z
	NextInst
.io
	ASLIO

I1F					;+ ASL,ORA - Absolute,X
	GETABSXADDR
	MMU	.rom
	lea	0(a0,d7.w),a2
	move.b	(a2),d6
	add.b	d6,d6
	scs	d4			;C
	move.b	d6,(a2)
	or.b	d6,d0
	NextInstStat
.rom
	bmi.s	.io
	move.b	0(a0,d7.w),d6
	add.b	d6,d6
	scs	d4			;C
	or.b	d6,d0
	NextInstStat
.io
	INPUT
	add.b	d6,d6
	scs	d4			;C
	or.b	d6,d0
	move.w	d0,d3
	_OUTPUT	

I20					;JSR
	movep.w	1(a6),d7
	move.b	(a6)+,d7
	move.l	a6,a2
	sub.l	a0,a2
	lea	0(a0,d7.w),a6
	move.w	a2,d7
	move.w	d7,-(a7)
	swap	d1
	move.b	(a7)+,0(a0,d1.w)
	subq.b	#1,d1
	move.b	d7,0(a0,d1.w)
	subq.b	#1,d1
	swap	d1
	NextInstStat2

I21					;AND - (Indirect,X)
	GETINDXADDR
	MMU2	.io
	and.b	0(a0,d7.w),d0
	NextInstStat
.io
	INPUT
	and.b	d6,d0
	NextInstStat

I22					;???
	NextInstStat2

I23					;+ ROL,AND - (Ind,X)
	GETINDXADDR
	MMU	.rom
	lea	0(a0,d7.w),a2
	move.b	(a2),d6
	neg.b	d4			;C
	addx.b	d6,d6
	scs	d4			;C
	move.b	d6,(a2)
	and.b	d6,d0
	NextInstStat
.rom
	bmi.s	.io
	move.b	0(a0,d7.w),d6
	neg.b	d4			;C
	addx.b	d6,d6
	scs	d4			;C
	and.b	d6,d0
	NextInstStat
.io
	INPUT
	neg.b	d4			;C
	addx.b	d6,d6
	scs	d4			;C
	and.b	d6,d0
	move.w	d0,d3
	_OUTPUT
	
I24					;BIT - Zero Page
	move.b	(a6)+,d6
	move.b	0(a0,d6.w),d6
	move.b	d6,d3
	ext.w	d3			;N
	add.b	d3,d3
	smi	d5			;V
	and.b	d0,d6
	move.b	d6,d3			;Z
	NextInst

I25					;AND - Zero Page
	move.b	(a6)+,d6
	and.b	0(a0,d6.w),d0
	NextInstStat

I26					;ROL - Zero Page
	move.b	(a6)+,d6
	lea	0(a0,d6.w),a2
	move.b	(a2),d6
	neg.b	d4			;C
	addx.b	d6,d6
	scs	d4			;C
	move.w	d6,d3			;N & Z
	move.b	d6,(a2)
	NextInst

I27					;+ ROL,AND - Zero Page
	move.b	(a6)+,d6
	lea	0(a0,d6.w),a2
	move.b	(a2),d6
	neg.b	d4			;C
	addx.b	d6,d6
	scs	d4			;C
	move.b	d6,(a2)
	and.b	d6,d0
	NextInstStat

I28					;PLP
	PULLP
	CheckDecMode
	CheckIntFlag
	NextInst

I29					;AND - Immediate
	and.b	(a6)+,d0
	NextInstStat

I2A					;ROL - Accumulator
	neg.b	d4			;C
	addx.b	d0,d0
	scs	d4			;C
	NextInstStat

I2B					;+ AND,ROL - Immediate
	and.b 	(a6)+,d0
	move.w	d0,d6
	neg.b	d4			;C
	addx.b	d6,d6
	scs	d4			;C
	move.w	d6,d3			;N & Z
	NextInst

I2C					;BIT - Absolute
	GETABSADDR
	MMU2	.io
	move.b	0(a0,d7.w),d6
	move.b	d6,d3
	ext.w	d3			;N
	add.b	d3,d3
	smi	d5			;V
	and.b	d0,d6
	move.b	d6,d3			;Z
	NextInst
.io
	INPUT
	move.b	d6,d3
	ext.w	d3			;N
	add.b	d3,d3
	smi	d5			;V
	and.b	d0,d6
	move.b	d6,d3			;Z
	NextInst

I2D					;AND - Absolute
	GETABSADDR
	MMU2	.io
	and.b	0(a0,d7.w),d0
	NextInstStat
.io
	INPUT
	and.b	d6,d0
	NextInstStat

I2E					;ROL - Absolute
	GETABSADDR
	MMU	.rom
	lea	0(a0,d7.w),a2
	move.b	(a2),d6
	neg.b	d4			;C
	addx.b	d6,d6
	scs	d4			;C
	move.w	d6,d3			;N & Z
	move.b	d6,(a2)
	NextInst
.rom
	bmi.s	.io
	move.b	0(a0,d7.w),d6
	neg.b	d4			;C
	addx.b	d6,d6
	scs	d4			;C
	move.w	d6,d3			;N & Z
	NextInst
.io
	ROLIO

I2F					;+ ROL,AND - Absolute
	GETABSADDR
	MMU	.rom
	lea	0(a0,d7.w),a2
	move.b	(a2),d6
	neg.b	d4			;C
	addx.b	d6,d6
	scs	d4			;C
	move.b	d6,(a2)
	and.b	d6,d0
	NextInstStat
.rom
	bmi.s	.io
	move.b	0(a0,d7.w),d6
	neg.b	d4			;C
	addx.b	d6,d6
	scs	d4			;C
	and.b	d6,d0
	NextInstStat
.io
	INPUT
	neg.b	d4			;C
	addx.b	d6,d6
	scs	d4			;C
	and.b	d6,d0
	move.w	d0,d3
	_OUTPUT

I30					;BMI
	move.b	(a6)+,d7
	tst.w	d3
	bmi.s	.1
	tst.b	d3
	bpl.s	.2
.1
	ext.w	d7
	adda.w	d7,a6
.2
	NextInst
	IfStatus
	move.b	(a6)+,d7
	tst.b	d0
	bpl.s	.3
	ext.w	d7
	adda.w	d7,a6
.3
	NextInstStat

I31					;AND - (Indirect),y
	GETINDYADDR
	MMU2	.io
	and.b	0(a0,d7.w),d0
	NextInstStat
.io
	INPUT
	and.b	d6,d0
	NextInstStat
	
I32					;???
	NextInstStat2

I33					;+ ROL,AND - (Ind),Y
	GETINDYADDR
	MMU	.rom
	lea	0(a0,d7.w),a2
	move.b	(a2),d6
	neg.b	d4			;C
	addx.b	d6,d6
	scs	d4			;C
	move.b	d6,(a2)
	and.b	d6,d0
	NextInstStat
.rom
	bmi.s	.io
	move.b	0(a0,d7.w),d6
	neg.b	d4			;C
	addx.b	d6,d6
	scs	d4			;C
	and.b	d6,d0
	NextInstStat
.io
	INPUT
	neg.b	d4			;C
	addx.b	d6,d6
	scs	d4			;C
	and.b	d6,d0
	move.w	d0,d3
	_OUTPUT	

I34					;+ NOP - Zero Page
	addq.l	#1,a6
	NextInstStat2

I35					;AND - Zero Page,X
	move.b	(a6)+,d6
	add.b	d1,d6			;X
	and.b	0(a0,d6.w),d0
	NextInstStat

I36					;ROL - Zero Page,X
	move.b	(a6)+,d6
	add.b	d1,d6			;X
	lea	0(a0,d6.w),a2
	move.b	(a2),d6
	neg.b	d4			;C
	addx.b	d6,d6
	scs	d4			;C
	move.w	d6,d3			;N & Z
	move.b	d6,(a2)
	NextInst

I37					;+ ROL,AND - Zero Page,X
	move.b	(a6)+,d6
	add.b	d1,d6			;X
	lea	0(a0,d6.w),a2
	move.b	(a2),d6
	neg.b	d4			;C
	addx.b	d6,d6
	scs	d4			;C
	move.b	d6,(a2)
	and.b	d6,d0
	NextInstStat

I38					;SEC
	st	d4			;C
	NextInstStat2

I39					;AND - Absolute,Y
	GETABSYADDR
	MMU2	.io
	and.b	0(a0,d7.w),d0
	NextInstStat
.io
	INPUT
	and.b	d6,d0
	NextInstStat

I3A					;+ NOP
	NextInstStat2

I3B					;+ ROL,AND - Absolute,Y
	GETABSYADDR
	MMU	.rom
	lea	0(a0,d7.w),a2
	move.b	(a2),d6
	neg.b	d4			;C
	addx.b	d6,d6
	scs	d4			;C
	move.b	d6,(a2)
	and.b	d6,d0
	NextInstStat
.rom
	bmi.s	.io
	move.b	0(a0,d7.w),d6
	neg.b	d4			;C
	addx.b	d6,d6
	scs	d4			;C
	and.b	d6,d0
	NextInstStat
.io
	INPUT
	neg.b	d4			;C
	addx.b	d6,d6
	scs	d4			;C
	and.b	d6,d0
	move.w	d0,d3
	_OUTPUT

I3C					;+ NOP - Absolute
	addq.l	#2,a6
	NextInstStat2

I3D					;AND - Absolute,X
	GETABSXADDR
	MMU2	.io
	and.b	0(a0,d7.w),d0
	NextInstStat
.io
	INPUT
	and.b	d6,d0
	NextInstStat

I3E					;ROL - Absolute,X
	GETABSXADDR
	MMU	.rom
	lea	0(a0,d7.w),a2
	move.b	(a2),d6
	neg.b	d4			;C
	addx.b	d6,d6
	scs	d4			;C
	move.w	d6,d3			;N & Z
	move.b	d6,(a2)
	NextInst
.rom
	bmi.s	.io
	move.b	0(a0,d7.w),d6
	neg.b	d4			;C
	addx.b	d6,d6
	scs	d4			;C
	move.w	d6,d3			;N & Z
	NextInst
.io
	ROLIO

I3F					;+ ROL,AND - Absolute,X
	GETABSXADDR
	MMU	.rom
	lea	0(a0,d7.w),a2
	move.b	(a2),d6
	neg.b	d4			;C
	addx.b	d6,d6
	scs	d4			;C
	move.b	d6,(a2)
	and.b	d6,d0
	NextInstStat
.rom
	bmi.s	.io
	move.b	0(a0,d7.w),d6
	neg.b	d4			;C
	addx.b	d6,d6
	scs	d4			;C
	and.b	d6,d0
	NextInstStat
.io
	INPUT
	neg.b	d4			;C
	addx.b	d6,d6
	scs	d4			;C
	and.b	d6,d0
	move.w	d0,d3
	_OUTPUT

I40					;RTI
	PULLP
	CheckDecMode
	CheckIntFlag
	swap	d1
	addq.b	#1,d1
	move.b	0(a0,d1.w),d6
	addq.b	#1,d1
	move.b	0(a0,d1.w),-(a7)
	swap	d1
	move.w	(a7)+,d7
	move.b	d6,d7
	lea	0(a0,d7.w),a6
	NextInst

I41					;EOR - (Indirect,X)
	GETINDXADDR
	MMU2	.io
	move.b	0(a0,d7.w),d6
	eor.b	d6,d0
	NextInstStat
.io
	INPUT
	eor.b	d6,d0
	NextInstStat

I42					;???
	NextInstStat2

I43					;+ LSR,EOR - (Ind,X)
	GETINDXADDR
	lea	0(a0,d7.w),a2
	move.b	(a2),d6
	lsr.b	#1,d6
	scs	d4			;C
	move.b	d6,(a2)
	eor.b	d6,d0
	NextInstStat

I44					;+ NOP - Zero Page
	addq.l	#1,a6
	NextInstStat2

I45					;EOR - Zero Page
	move.b	(a6)+,d6
	move.b	0(a0,d6.w),d6
	eor.b	d6,d0
	NextInstStat

I46					;LSR - Zero Page
	move.b	(a6)+,d6
	lea	0(a0,d6.w),a2
	move.b	(a2),d6
	lsr.b	#1,d6
	scs	d4			;C
	move.w	d6,d3			;N & Z
	move.b	d6,(a2)
	NextInst

I47					;+ LSR,EOR - Zero Page
	move.b	(a6)+,d6
	lea	0(a0,d6.w),a2
	move.b	(a2),d6
	lsr.b	#1,d6
	scs	d4			;C
	move.b	d6,(a2)
	eor.b	d6,d0
	NextInstStat

I48					;PHA
	swap	d1
	move.b	d0,0(a0,d1.w)
	subq.b	#1,d1
	swap	d1
	NextInstStat2

I49					;EOR - Immediate
	move.b	(a6)+,d6
	eor.b	d6,d0
	NextInstStat

I4A					;LSR - Accumulator
	lsr.b	#1,d0
	scs	d4			;C
	NextInstStat

I4B					;+ AND,LSR - Immediate
	and.b	(a6)+,d0
	lsr.b	#1,d0
	scs	d4			;C
	NextInstStat

I4C					;JMP - Absolute
	movep.w	1(a6),d7
	move.b	(a6),d7
	lea	0(a0,d7.w),a6
	NextInstStat2

I4D					;EOR - Absolute
	GETABSADDR
	MMU2	.io
	move.b	0(a0,d7.w),d6
	eor.b	d6,d0
	NextInstStat
.io
	INPUT
	eor.b	d6,d0
	NextInstStat

I4E					;LSR - Absolute
	GETABSADDR
	MMU	.rom
	lea	0(a0,d7.w),a2
	move.b	(a2),d6
	lsr.b	#1,d6
	scs	d4			;C
	move.w	d6,d3			;N & Z
	move.b	d6,(a2)
	NextInst
.rom
	bmi.s	.io
	NextInst
.io
	LSRIO

I4F					;+ LSR,EOR - Absolute
	GETABSADDR
	lea	0(a0,d7.w),a2
	move.b	(a2),d6
	lsr.b	#1,d6
	scs	d4			;C
	move.b	d6,(a2)
	eor.b	d6,d0
	NextInstStat

I50					;BVC
	move.b	(a6)+,d7
	tst.b	d5
	bne.s	.1
	ext.w	d7
	adda.w	d7,a6
.1
	NextInstStat2

I51					;EOR - (Indirect),Y
	GETINDYADDR
	MMU2	.io
	move.b	0(a0,d7.w),d6
	eor.b	d6,d0
	NextInstStat
.io
	INPUT
	eor.b	d6,d0
	NextInstStat

I52					;???
	NextInstStat2

I53					;+ LSR,EOR - (Ind),Y
	GETINDYADDR
	lea	0(a0,d7.w),a2
	move.b	(a2),d6
	lsr.b	#1,d6
	scs	d4			;C
	move.b	d6,(a2)
	eor.b	d6,d0
	NextInstStat

I54					;+ NOP - Zero Page
	addq.l	#1,a6
	NextInstStat2

I55					;EOR - Zero Page,X
	move.b	(a6)+,d6
	add.b	d1,d6			;X
	move.b	0(a0,d6.w),d6
	eor.b	d6,d0
	NextInstStat

I56					;LSR - Zero Page,X
	move.b	(a6)+,d6
	add.b	d1,d6			;X
	lea	0(a0,d6.w),a2
	move.b	(a2),d6
	lsr.b	#1,d6
	scs	d4			;C
	move.w	d6,d3			;N & Z
	move.b	d6,(a2)
	NextInst

I57					;+ LSR,EOR - Zero Page,X
	move.b	(a6)+,d6
	add.b	d1,d6			;X
	lea	0(a0,d6.w),a2
	move.b	(a2),d6
	lsr.b	#1,d6
	scs	d4			;C
	move.b	d6,(a2)
	eor.b	d6,d0
	NextInstStat

I58					;CLI
	and.w	#$FBFF,d5
	tst.b	flgIrqMastEn(a0)
	bne.s	I58a
	NextInstStat2
I58a
	move.w	#$4000,$09a(a1)
	clr.b	flgIrqMastEn(a0)
	move.b	$FFFF912E(a0),d6
	and.b	$FFFF912D(a0),d6
	beq.s	I58b
	move.w	#$8008,$09c(a1)
I58b	move.w	#$c000,$09a(a1)
	NextInstStat2

I59					;EOR - Absolute,Y
	GETABSYADDR
	MMU2	.io
	move.b	0(a0,d7.w),d6
	eor.b	d6,d0
	NextInstStat
.io
	INPUT
	eor.b	d6,d0
	NextInstStat

I5A					;+ NOP
	NextInstStat2

I5B					;+ LSR,EOR - Absolute,Y
	GETABSYADDR
	lea	0(a0,d7.w),a2
	move.b	(a2),d6
	lsr.b	#1,d6
	scs	d4			;C
	move.b	d6,(a2)
	eor.b	d6,d0
	NextInstStat

I5C					;+ NOP - Absolute
	addq.l	#2,a6
	NextInstStat2

I5D					;EOR - Absolute,X
	GETABSXADDR
	MMU2	.io
	move.b	0(a0,d7.w),d7
	eor.b	d7,d0
	NextInstStat
.io
	INPUT
	eor.b	d6,d0
	NextInstStat

I5E					;LSR - Absolute,X
	GETABSXADDR
	MMU	.rom
	lea	0(a0,d7.w),a2
	move.b	(a2),d6
	lsr.b	#1,d6
	scs	d4			;C
	move.w	d6,d3			;N & Z
	move.b	d6,(a2)
	NextInst
.rom
	bmi.s	.io
	NextInst
.io
	LSRIO

I5F					;+ LSR,EOR - Absolute,X
	GETABSXADDR
	lea	0(a0,d7.w),a2
	move.b	(a2),d6
	lsr.b	#1,d6
	scs	d4			;C
	move.b	d6,(a2)
	eor.b	d6,d0
	NextInstStat

I60					;RTS
	swap	d1
	addq.b	#1,d1
	move.b	0(a0,d1.w),d6
	addq.b	#1,d1
	move.b	0(a0,d1.w),-(a7)
	swap	d1
	move.w	(a7)+,d7
	move.b	d6,d7
	lea	1(a0,d7.w),a6
	NextInstStat2

I61					;ADC - (Indirect,X)
	GETINDXADDR
	MMU2	.io
	move.b	0(a0,d7.w),d6
	neg.b	d4			;C
	DecimalMode1
	scs	d4			;C
	svs	d5			;V
	NextInstStat
.io
	INPUT
	neg.b	d4			;C
	DecimalMode1
	scs	d4			;C
	svs	d5			;V
	NextInstStat

I62					;???
	NextInstStat2

I63					;+ ROR,ADC - (Ind,X)
	GETINDXADDR
	lea	0(a0,d7.w),a2
	move.b	(a2),d6
	neg.b	d4			;C
	roxr.b	#1,d6
	move.b	d6,(a2)
	DecimalMode1
	scs	d4			;C
	svs	d5			;V
	NextInstStat

I64					;+ NOP - Zero Page
	addq.l	#1,a6
	NextInstStat2

I65					;ADC - Zero Page
	move.b	(a6)+,d6
	move.b	0(a0,d6.w),d6
	neg.b	d4			;C
	DecimalMode1
	scs	d4			;C
	svs	d5			;V
	NextInstStat

I66					;ROR - Zero Page
	move.b	(a6)+,d6
	lea	0(a0,d6.w),a2
	move.b	(a2),d6
	neg.b	d4			;C
	roxr.b	#1,d6
	scs	d4			;C
	move.w	d0,d3			;N & Z
	move.b	d6,(a2)
	NextInst

I67					;+ ROR,ADC - Zero Page
	move.b	(a6)+,d6
	lea	0(a0,d6.w),a2
	move.b	(a2),d6
	neg.b	d4			;C
	roxr.b	#1,d6
	move.b	d6,(a2)
	DecimalMode1
	scs	d4			;C
	svs	d5			;V
	NextInstStat

I68					;PLA
	swap	d1
	addq.b	#1,d1
	move.b	0(a0,d1.w),d0
	swap	d1
	NextInstStat

I69					;ADC - Immediate
	move.b	(a6)+,d6
	neg.b	d4			;C
	DecimalMode1
	scs	d4			;C
	svs	d5			;V
	NextInstStat

I6A					;ROR - Accumulator
	neg.b	d4			;C
	roxr.b	#1,d0
	scs	d4			;C
	NextInstStat

I6B					;+ AND,ROR - Immediate
	and.b	(a6)+,d0
	neg.b	d4			;C
	roxr.b	#1,d0
	scs	d4			;C
	NextInstStat

I6C					;JMP - Indirect
	movep.w	1(a6),d7
	move.b	(a6),d7
	lea	0(a0,d7.w),a6
	movep.w	1(a6),d7
	move.b	(a6),d7
	lea	0(a0,d7.w),a6
	NextInstStat2

I6D					;ADC - Absolute
	GETABSADDR
	MMU2	.io
	move.b	0(a0,d7.w),d6
	neg.b	d4			;C
	DecimalMode1
	scs	d4			;C
	svs	d5			;V
	NextInstStat
.io
	INPUT
	neg.b	d4			;C
	DecimalMode1
	scs	d4			;C
	svs	d5			;V
	NextInstStat

I6E					;ROR - Absolute
	GETABSADDR
	MMU	.rom
	lea	0(a0,d7.w),a2
	move.b	(a2),d6
	neg.b	d4			;C
	roxr.b	#1,d6
	scs	d4			;C
	move.w	d6,d3			;N & Z
	move.b	d6,(a2)
	NextInst
.rom
	bmi.s	.io
	NextInst
.io
	RORIO

I6F					;+ ROR,ADC - Absolute
	GETABSADDR
	lea	0(a0,d7.w),a2
	move.b	(a2),d6
	neg.b	d4			;C
	roxr.b	#1,d6
	move.b	d6,(a2)
	DecimalMode1
	scs	d4			;C
	svs	d5			;V
	NextInstStat

I70					;BVS
	move.b	(a6)+,d7
	tst.b	d5			;V
	beq.s	.1
	ext.w	d7
	adda.w	d7,a6
.1
	NextInstStat2

I71					;ADC - (Indirect),Y
	GETINDYADDR
	MMU2	.io
	move.b	0(a0,d7.w),d6
	neg.b	d4			;C
	DecimalMode1
	scs	d4			;C
	svs	d5			;V
	NextInstStat
.io
	INPUT
	neg.b	d4			;C
	DecimalMode1
	scs	d4			;C
	svs	d5			;V
	NextInstStat

I72					;???
	NextInstStat2

I73					;+ ROR,ADC - (Ind),Y
	GETINDYADDR
	lea	0(a0,d7.w),a2
	move.b	(a2),d6
	neg.b	d4			;C
	roxr.b	#1,d6
	move.b	d6,(a2)
	DecimalMode1
	scs	d4			;C
	svs	d5			;V
	NextInstStat

I74					;+ NOP - Zero Page
	addq.l	#1,a6
	NextInstStat2

I75					;ADC - Zero Page,X
	move.b	(a6)+,d6
	add.b	d1,d6			;X
	move.b	0(a0,d6.w),d6
	neg.b	d4			;C
	DecimalMode1
	scs	d4			;C
	svs	d5			;V
	NextInstStat

I76					;ROR - Zero Page,X
	move.b	(a6)+,d6
	add.b	d1,d6			;X
	lea	0(a0,d6.w),a2
	move.b	(a2),d6
	neg.b	d4			;C
	roxr.b	#1,d6
	scs	d4			;C
	move.w	d6,d3			;N & Z
	move.b	d6,(a2)
	NextInst

I77					;+ ROR,ADC - Zero Page,X
	move.b	(a6)+,d6
	add.b	d1,d6			;X
	lea	0(a0,d6.w),a2
	move.b	(a2),d6
	neg.b	d4			;C
	roxr.b	#1,d6
	move.b	d6,(a2)
	DecimalMode1
	scs	d4			;C
	svs	d5			;V
	NextInstStat

I78					;SEI
	or.w	#$0400,d5
	st	flgIrqMastEn(a0)
	NextInstStat2

I79					;ADC - Absolute,Y
	GETABSYADDR
	MMU2	.io
	move.b	0(a0,d7.w),d6
	neg.b	d4			;C
	DecimalMode1
	scs	d4			;C
	svs	d5			;V
	NextInstStat
.io
	INPUT
	neg.b	d4			;C
	DecimalMode1
	scs	d4			;C
	svs	d5			;V
	NextInstStat

I7A					;+ NOP
	NextInstStat2

I7B					;+ ROR,ADC - Absolute,Y
	GETABSYADDR
	lea	0(a0,d7.w),a2
	move.b	(a2),d6
	neg.b	d4			;C
	roxr.b	#1,d6
	move.b	d6,(a2)
	DecimalMode1
	scs	d4			;C
	svs	d5			;V
	NextInstStat

I7C					;???
	addq.l	#2,a6
	NextInstStat2

I7D					;ADC - Absolute,X
	GETABSXADDR
	MMU2	.io
	move.b	0(a0,d7.w),d6
	neg.b	d4			;C
	DecimalMode1
	scs	d4			;C
	svs	d5			;V
	NextInstStat
.io
	INPUT
	neg.b	d4			;C
	DecimalMode1
	scs	d4			;C
	svs	d5			;V
	NextInstStat

I7E					;ROR - Absolute,X
	GETABSXADDR
	MMU	.rom
	lea	0(a0,d7.w),a2
	move.b	(a2),d6
	neg.b	d4			;C
	roxr.b	#1,d6
	scs	d4			;C
	move.w	d6,d3			;N & Z
	move.b	d6,(a2)
	NextInst
.rom
	bmi.s	.io
	NextInst
.io
	RORIO

I7F					;+ ROR,ADC - Absolute,X
	GETABSXADDR
	lea	0(a0,d7.w),a2
	move.b	(a2),d6
	neg.b	d4			;C
	roxr.b	#1,d6
	move.b	d6,(a2)
	DecimalMode1
	scs	d4			;C
	svs	d5			;V
	NextInstStat

I80					;+ NOP - Zero Page
	addq.l	#1,a6
	NextInstStat2

I81					;STA - (Indirect,X)
	GETINDXADDR
	MMU	.rom
	move.b	d0,0(a0,d7.w)
	NextInstStat2
.rom
	bmi.s	.io
	NextInstStat2
.io
	SetAStatus
	move.l	d7,a2
	move.w	d6,d7
	move.b	d0,d6
	_OUTPUT2

I82					;+ NOP - Zero Page
	addq.l	#1,a6
	NextInstStat2

I83					;+ CLRX - (Ind,X)
	move.b	(a6)+,d6
	tst.b	d1			;X
	bne.s	.not
	lea	0(a0,d6.w),a2
	movep.w	1(a2),d7
	move.b	(a2),d7
	MMU2	.io
	clr.b	0(a0,d7.w)
.not
	NextInstStat2
.io
	SetAStatus
	move.l	d7,a2
	move.w	d6,d7
	moveq	#$00,d6
	_OUTPUT2

I84					;STY - Zero Page
	move.b	(a6)+,d6
	move.b	d2,0(a0,d6.w)
	NextInstStat2

I85					;STA - Zero Page
	move.b	(a6)+,d6
	move.b	d0,0(a0,d6.w)
	NextInstStat2

I86					;STX - Zero Page
	move.b	(a6)+,d6
	move.b	d1,0(a0,d6.w)
	NextInstStat2

I87					;+ STAX - Zero Page
	move.b	(a6)+,d6
	move.b	d0,d7			;A
	and.b	d1,d7			;X
	move.b	d7,0(a0,d6.w)
	NextInstStat2

I88					;DEY
	subq.b	#1,d2
	move.w	d2,d3			;N & Z
	NextInst

I89					;+ NOP - Zero Page
	addq.l	#1,a6
	NextInstStat2

I8A					;TXA
	move.b	d1,d0
	NextInstStat

I8B					;+ MXA - Immediate
	or.b	#$fe,d0
	and.b	(a6)+,d0
	and.b	d1,d0
	NextInstStat2

I8C					;STY - Absolute
	GETABSADDR
	MMU	.rom
	move.b	d2,0(a0,d7.w)
	NextInstStat2
.rom
	bmi.s	.io
	NextInstStat2
.io
	SetAStatus
	move.l	d7,a2
	move.w	d6,d7
	move.b	d2,d6
	_OUTPUT2

I8D					;STA - Absolute
	GETABSADDR
	MMU	.rom
	move.b	d0,0(a0,d7.w)
	NextInstStat2
.rom
	bmi.s	.io
	NextInstStat2
.io
	SetAStatus
	move.l	d7,a2
	move.w	d6,d7
	move.b	d0,d6
	_OUTPUT2

I8E					;STX - Absolute
	GETABSADDR
	MMU	.rom
	move.b	d1,0(a0,d7.w)
	NextInstStat2
.rom
	bmi.s	.io
	NextInstStat2
.io
	SetAStatus
	move.l	d7,a2
	move.w	d6,d7
	move.b	d1,d6
	_OUTPUT2

I8F					;+ STAX - Absolute
	GETABSADDR
	MMU2	.io
	move.b	d0,d6
	and.b	d1,d6
	move.b	d6,0(a0,d7.w)
	NextInstStat2
.io
	SetAStatus
	move.l	d7,a2
	move.w	d6,d7
	move.b	d0,d6
	and.b	d1,d6
	_OUTPUT2

I90					;BCC
	move.b	(a6)+,d7
	tst.b	d4
	bne.s	.1
	ext.w	d7
	adda.w	d7,a6
.1
	NextInstStat2

I91					;STA - (Indirect),Y
	GETINDYADDR
	MMU	.rom
	move.b	d0,0(a0,d7.w)
	NextInstStat2
.rom
	bmi.s	.io
	NextInstStat2
.io
	SetAStatus
	move.l	d7,a2
	move.w	d6,d7
	move.b	d0,d6
	_OUTPUT2

I92					;???
	NextInstStat2

I93					;+ STAX21 - (Ind),Y
	GETINDYADDR
	MMU2	.io
	moveq	#$21,d6
	and.b	d0,d6
	and.b	d1,d6
	move.b	d6,0(a0,d7.w)
	NextInstStat2
.io
	SetAStatus
	move.l	d7,a2
	move.w	d6,d7
	moveq	#$21,d6
	and.b	d0,d6
	and.b	d1,d6
	_OUTPUT2

I94					;STY - Zero Page,X
	move.b	(a6)+,d6
	add.b	d1,d6			;X
	move.b	d2,0(a0,d6.w)
	NextInstStat2

I95					;STA - Zero Page,X
	move.b	(a6)+,d6
	add.b	d1,d6			;X
	move.b	d0,0(a0,d6.w)
	NextInstStat2

I96					;STX - Zero Page,Y
	move.b	(a6)+,d6
	add.b	d2,d6			;Y
	move.b	d1,0(a0,d6.w)
	NextInstStat2

I97					;+ STAX - Zero Page,Y
	move.b	(a6)+,d6
	add.b	d2,d6
	move.b	d0,d7			;A
	and.b	d1,d7			;X
	move.b	d7,0(a0,d6.w)
	NextInstStat2

I98					;TYA
	move.b	d2,d0
	NextInstStat

I99					;STA - Absolute,Y
	GETABSYADDR
	MMU	.rom
	move.b	d0,0(a0,d7.w)
	NextInstStat2
.rom
	bmi.s	.io
	NextInstStat2
.io
	SetAStatus
	move.l	d7,a2
	move.w	d6,d7
	move.b	d0,d6
	_OUTPUT2

I9A					;TXS
	move.b	d1,d7
	swap	d1
	move.b	d7,d1
	swap	d1
	NextInstStat2

I9B					;+ STAX21SP - Absolute,Y
	GETABSYADDR
	MMU2	.io
	lea	0(a0,d7.w),a2
	move.w	a1,d7
	move.b	d0,d7
	and.b	d1,d7
	move.w	d7,a1
	and.b	#$21,d7
	move.b	d7,(a2)
	NextInstStat2
.io
	SetAStatus
	move.l	d7,a2
	move.w	a1,d7
	move.b	d0,d7
	and.b	d1,d7
	move.w	d7,a1
	move.w	d6,d7
	moveq	#$21,d6
	and.b	d0,d6
	and.b	d1,d6
	_OUTPUT2

I9C					;+ STAY21 - Absolute,X
	GETABSXADDR
	MMU2	.io
	moveq	#$21,d6
	and.b	d0,d6
	and.b	d2,d6
	move.b	d6,0(a0,d7.w)
	NextInstStat2
.io
	SetAStatus
	move.l	d7,a2
	move.w	d6,d7
	moveq	#$21,d6
	and.b	d0,d6
	and.b	d2,d6
	_OUTPUT2

I9D					;STA - Absolute,X
	GETABSXADDR
	MMU	.rom
	move.b	d0,0(a0,d7.w)
	NextInstStat2
.rom
	bmi.s	.io
	NextInstStat2
.io
	SetAStatus
	move.l	d7,a2
	move.w	d6,d7
	move.b	d0,d6
	_OUTPUT2

I9E					;+ STAX21 - Absolute,Y
	GETABSXADDR
	MMU2	.io
	moveq	#$21,d6
	and.b	d0,d6
	and.b	d1,d6
	move.b	d6,0(a0,d7.w)
	NextInstStat2
.io
	SetAStatus
	move.l	d7,a2
	move.w	d6,d7
	moveq	#$21,d6
	and.b	d0,d6
	and.b	d1,d6
	_OUTPUT2
	NextInstStat2

I9F					;+ STAX21 - Absolute,Y
	GETABSXADDR
	MMU2	I9Fb
	moveq	#$21,d6
	and.b	d0,d6
	and.b	d1,d6
	move.b	d6,0(a0,d7.w)
	NextInstStat2
I9Fb
	SetAStatus
	move.l	d7,a2
	move.w	d6,d7
	moveq	#$21,d6
	and.b	d0,d6
	and.b	d1,d6
	_OUTPUT2

IA0					;LDY - Immediate
	move.b	(a6)+,d2
	move.w	d2,d3			;N & Z
	NextInst

IA1					;LDA - (Indirect,X)
	GETINDXADDR
	MMU2	.io
	move.b	0(a0,d7.w),d0
	NextInstStat
.io
	INPUT
	move.b	d6,d0
	NextInstStat

IA2					;LDX - Immediate
	move.b	(a6)+,d1
	move.w	d1,d3			;N & Z
	NextInst

IA3					;+ LDAX - (Ind,X)
	GETINDXADDR
	move.b	0(a0,d7.w),d0
	move.b	d0,d1
	NextInstStat

IA4					;LDY - Zero Page
	move.b	(a6)+,d6
	move.b	0(a0,d6.w),d2
	move.w	d2,d3			;N & Z
	NextInst

IA5					;LDA - Zero Page
	move.b	(a6)+,d6
	move.b	0(a0,d6.w),d0
	NextInstStat

IA6					;LDX - Zero Page
	move.b	(a6)+,d6
	move.b	0(a0,d6.w),d1
	move.w	d1,d3			;N & Z
	NextInst

IA7					;+ LDAX - Zero Page
	move.b	(a6)+,d6
	move.b	0(a0,d6.w),d0
	move.b	d0,d1
	NextInstStat

IA8					;TAY
	move.b	d0,d2
	NextInstStat

IA9					;LDA - Immediate
	move.b	(a6)+,d0
	NextInstStat

IAA					;TAX
	move.b	d0,d1
	NextInstStat

IAB					;+ LDAX - Immediate
	move.b	(a6)+,d0
	move.b	d0,d1
	NextInstStat

IAC					;LDY - Absolute
	GETABSADDR
	MMU2	.io
	move.b	0(a0,d7.w),d2
	move.w	d2,d3			;N & Z
	NextInst
.io
	INPUT
	move.b	d6,d2
	move.w	d2,d3			;N & Z
	NextInst

IAD					;LDA - Absolute
	GETABSADDR
	MMU2	.io
	move.b	0(a0,d7.w),d0
	NextInstStat
.io
	INPUT
	move.b	d6,d0
	NextInstStat

IAE					;LDX - Absolute
	GETABSADDR
	MMU2	.io
	move.b	0(a0,d7.w),d1
	move.w	d1,d3			;N & Z
	NextInst
.io
	INPUT
	move.b	d6,d1
	move.w	d1,d3			;N & Z
	NextInst

IAF					;+ LDAX - Absolute
	GETABSADDR
	move.b	0(a0,d7.w),d0
	move.b	d0,d1
	NextInstStat

IB0					;BCS
	move.b	(a6)+,d7
	tst.b	d4
	beq.s	.1
	ext.w	d7
	adda.w	d7,a6
.1
	NextInstStat2

IB1					;LDA - (Indirect),Y
	GETINDYADDR
	MMU2	.io
	move.b	0(a0,d7.w),d0
	NextInstStat
.io
	INPUT
	move.b	d6,d0
	NextInstStat

IB2					;???
	NextInstStat2

IB3					;+ LDAX - (Ind),Y
	GETINDYADDR
	move.b	0(a0,d7.w),d0
	move.b	d0,d1
	NextInstStat

IB4					;LDY - Zero Page,X
	move.b	(a6)+,d6
	add.b	d1,d6			;X
	move.b	0(a0,d6.w),d2
	move.w	d2,d3			;N & Z
	NextInst

IB5					;LDA - Zero Page,X
	move.b	(a6)+,d6
	add.b	d1,d6			;X
	move.b	0(a0,d6.w),d0
	NextInstStat

IB6					;LDX - Zero Page,Y
	move.b	(a6)+,d6
	add.b	d2,d6			;Y
	move.b	0(a0,d6.w),d1
	move.w	d1,d3			;N & Z
	NextInst

IB7					;+ LDAX - Zero Page,Y
	move.b	(a6)+,d6
	add.b	d2,d6			;Y
	move.b	0(a0,d6.w),d0
	move.b	d0,d1
	NextInstStat

IB8					;CLV
	sub.b	d5,d5			;V
	NextInstStat2

IB9					;LDA - Absolute,Y
	GETABSYADDR
	MMU2	.io
	move.b	0(a0,d7.w),d0
	NextInstStat
.io
	INPUT
	move.b	d6,d0
	NextInstStat

IBA					;TSX
	swap	d1
	move.b	d1,d7
	swap	d1
	move.b	d7,d1
	move.w	d1,d3			;N & Z
	NextInst

IBB					;+ SPMAXSP - Absolute,Y
	GETABSYADDR
	addq.l	#2,a6
	move.b	0(a0,d7.w),d6
	move.w	a1,d7
	sub.w	a0,d7
	subq.b	#1,d7
	and.b	d7,d6
	move.b	d6,d0
	move.b	d6,d1
	move.w	a1,d7
	move.b	d6,d7
	move.w	d7,a1
	NextInstStat

IBC					;LDY - Absolute,X
	GETABSXADDR
	MMU2	.io
	move.b	0(a0,d7.w),d2
	move.w	d2,d3			;N & Z
	NextInst
.io
	INPUT
	move.b	d6,d2
	move.w	d2,d3			;N & Z
	NextInst

IBD					;LDA - Absolute,X
	GETABSXADDR
	MMU2	.io
	move.b	0(a0,d7.w),d0
	NextInstStat
.io
	INPUT
	move.b	d6,d0
	NextInstStat

IBE					;LDX - Absolute,Y
	GETABSYADDR
	MMU2	.io
	move.b	0(a0,d7.w),d1
	move.w	d1,d3			;N & Z
	NextInst
.io
	INPUT
	move.b	d6,d1
	move	d1,d3			;N & Z
	NextInst

IBF					;+ LDAX - Absolute,Y
	GETABSYADDR
	move.b	0(a0,d7.w),d0
	move.b	d0,d1
	NextInstStat

IC0					;CPY - Immediate
	move.w	d2,d3
	sub.b	(a6)+,d3		;N & Z
	scc	d4			;C
	NextInst

IC1					;CMP - (Indirect,X)
	GETINDXADDR
	MMU2	.io
	move.w	d0,d3			;N & Z
	sub.b	0(a0,d7.w),d3
	scc	d4			;C
	NextInst
.io
	INPUT
	move.w	d0,d3			;N & Z
	sub.b	d6,d3
	scc	d4			;C
	NextInst

IC2					;+ NOP - Zero Page
	addq.l	#1,a6
	NextInstStat2

IC3					;+ DEC,CMP - (Ind,X)
	GETINDXADDR
	lea	0(a0,d7.w),a2
	move.b	(a2),d6
	subq.b	#1,d6
	move.b	d6,(a2)
	move.w	d0,d3			;N & Z
	sub.b	d6,d3
	scc	d4			;C
	NextInst

IC4					;CPY - Zero Page
	move.b	(a6)+,d6
	move.w	d2,d3			;N & Z
	sub.b	0(a0,d6.w),d3
	scc	d4			;C
	NextInst

IC5					;CMP - Zero Page
	move.b	(a6)+,d6
	move.w	d0,d3			;N & Z
	sub.b	0(a0,d6.w),d3
	scc	d4			;C
	NextInst

IC6					;DEC - Zero Page
	move.b	(a6)+,d6
	lea	0(a0,d6.w),a2
	move.b	(a2),d6
	subq.b	#1,d6
	move.w	d6,d3			;N & Z
	move.b	d6,(a2)
	NextInst

IC7					;+ DEC,CMP - Zero Page
	move.b	(a6)+,d6
	lea	0(a0,d6.w),a2
	move.b	(a2),d6
	subq.b	#1,d6
	move.b	d6,(a2)
	move.w	d0,d3			;N & Z
	sub.b	d6,d3
	scc	d4			;C
	NextInst

IC8					;INY
	addq.b	#1,d2
	move.w	d2,d3			;N & Z
	NextInst

IC9					;CMP - Immediate
	move.w	d0,d3
	sub.b	(a6)+,d3		;N & Z
	scc	d4			;C
	NextInst

ICA					;DEX
	subq.b	#1,d1
	move.w	d1,d3			;N & Z
	NextInst

ICB					;+ AXM - Immediate
	and.b	d0,d1
	sub.b	(a6)+,d1
	move.w	d1,d3			;N & Z
	NextInst

ICC					;CPY - Absolute
	GETABSADDR
	MMU2	.io
	move.w	d2,d3			;N & Z
	sub.b	0(a0,d7.w),d3
	scc	d4			;C
	NextInst
.io
	INPUT
	move.w	d2,d3			;N & Z
	sub.b	d6,d3
	scc	d4			;C
	NextInst

ICD					;CMP - Absolute
	GETABSADDR
	MMU2	.io
	move.w	d0,d3			;N & Z
	sub.b	0(a0,d7.w),d3
	scc	d4			;C
	NextInst
.io
	INPUT
	move.w	d0,d3			;N & Z
	sub.b	d6,d3
	scc	d4			;C
	NextInst

ICE					;DEC - Absolute
	GETABSADDR
	MMU	.rom
	lea	0(a0,d7.w),a2
	move.b	(a2),d6
	subq.b	#1,d6
	move.w	d6,d3			;N & Z
	move.b	d6,(a2)
	NextInst
.rom
	bmi.s	.io
	NextInst
.io
	DECIO

ICF					;+ DEC,CMP - Absolute
	GETABSADDR
	lea	0(a0,d7.w),a2
	move.b	(a2),d6
	subq.b	#1,d6
	move.b	d6,(a2)
	move.w	d0,d3			;N & Z
	sub.b	d6,d3
	scc	d4			;C
	NextInst

ID0					;BNE
	move.b	(a6)+,d7
	tst.b	d3			;Z
	beq.s	.1
	ext.w	d7
	adda.w	d7,a6
.1
	NextInst
	IfStatus
	move.b	(a6)+,d7
	tst.b	d0
	beq.s	.2
	ext.w	d7
	adda.w	d7,a6
.2
	NextInstStat2

ID1					;CMP - (Indirect),Y
	GETINDYADDR
	MMU2	.io
	move.w	d0,d3
	sub.b	0(a0,d7.w),d3		;N & Z
	scc	d4			;C
	NextInst
.io
	INPUT
	move.w	d0,d3
	sub.b	d6,d3			;N & Z	
	scc	d4
	NextInst

ID2					;???
	NextInstStat2

ID3					;+ DEC,CMP - (Ind),Y
	GETINDYADDR
	lea	0(a0,d7.w),a2
	move.b	(a2),d6
	subq.b	#1,d6
	move.b	d6,(a2)
	move.w	d0,d3			;N & Z
	sub.b	d6,d3
	scc	d4			;C
	NextInst

ID4					;+ NOP - Zero Page
	addq.l	#1,a6
	NextInstStat2

ID5					;CMP - Zero Page,X
	move.b	(a6)+,d6
	add.b	d1,d6			;X
	move.w	d0,d3
	sub.b	0(a0,d6.w),d3		;N & Z
	scc	d4			;C
	NextInst

ID6					;DEC - Zero Page,X
	move.b	(a6)+,d6
	add.b	d1,d6			;X
	lea	0(a0,d6.w),a2
	move.b	(a2),d6
	subq.b	#1,d6
	move.w	d6,d3			;N & Z
	move.b	d6,(a2)
	NextInst

ID7					;+ DEC,CMP - Zero Page,X
	move.b	(a6)+,d6
	add.b	d1,d6			;X
	lea	0(a0,d6.w),a2
	move.b	(a2),d6
	subq.b	#1,d6
	move.b	d6,(a2)
	move.w	d0,d3			;N & Z
	sub.b	d6,d3
	scc	d4			;C
	NextInst

ID8					;CLD
	and.w	#$F7FF,d5		;D
	tst.w	d4			;D+
	bpl.s	ID8a
	move.l	#$FFFF0000,a2
	add.l	a2,a4
	add.l	a2,a5
	and.w	#$7fff,d4
	jmp	ID8a(pc,a2.l)
ID8a
	NextInstStat2

ID9					;CMP - Absolute,Y
	GETABSYADDR
	MMU2	.io
	move.w	d0,d3
	sub.b	0(a0,d7.w),d3		;N & Z
	scc	d4			;C
	NextInst
.io
	INPUT
	move.w	d0,d3
	sub.b	d6,d3			;N & Z
	scc	d4			;C
	NextInst

IDA					;+ NOP
	NextInstStat2

IDB					;+ DEC,CMP - Absolute,Y
	GETABSYADDR
	lea	0(a0,d7.w),a2
	move.b	(a2),d6
	subq.b	#1,d6
	move.b	d6,(a2)
	move.w	d0,d3			;N & Z
	sub.b	d6,d3
	scc	d4			;C
	NextInst

IDC					;+ NOP - Absolute
	addq.l	#2,a6
	NextInstStat2

IDD					;CMP - Absolute,X
	GETABSXADDR
	MMU2	.io
	move.w	d0,d3
	sub.b	0(a0,d7.w),d3		;N & Z
	scc	d4			;C
	NextInst
.io
	INPUT
	move.w	d0,d3
	sub.b	d6,d3			;N & Z
	scc	d4			;C
	NextInst

IDE					;DEC - Absolute,X
	GETABSXADDR
	MMU	.rom
	lea	0(a0,d7.w),a2
	move.b	(a2),d6
	subq.b	#1,d6
	move.w	d6,d3			;N & Z
	move.b	d6,(a2)
	NextInst
.rom
	bmi.s	.io
	NextInst
.io
	DECIO

IDF					;+ DEC,CMP - Absolute,X
	GETABSXADDR
	lea	0(a0,d7.w),a2
	move.b	(a2),d6
	subq.b	#1,d6
	move.b	d6,(a2)
	move.w	d0,d3			;N & Z
	sub.b	d6,d3
	scc	d4			;C
	NextInst

IE0					;CPX - Immediate
	move.w	d1,d3
	sub.b	(a6)+,d3		;N & Z
	scc	d4			;C
	NextInst

IE1					;SBC - (Indirect,X)
	GETINDXADDR
	MMU2	.io
	move.b	0(a0,d7.w),d6
	subq.b	#1,d4			;C-
	DecimalMode2
	scc	d4			;C
	svs	d5			;V
	NextInstStat
.io
	INPUT
	subq.b	#1,d4			;C-
	DecimalMode2
	scc	d4			;C
	svs	d5			;V
	NextInstStat

IE2					;+ NOP - Zero Page
	addq.l	#1,a6
	NextInstStat2

IE3					;+ INC,SBC - (Ind,X)
	GETINDXADDR
	lea	0(a0,d7.w),a2
	move.b	(a2),d6
	addq.b	#1,d6
	move.b	d6,(a2)
	subq.b	#1,d4			;C-
	DecimalMode2
	scc	d4			;C
	svs	d5			;V
	NextInstStat

IE4					;CPX - Zero Page
	move.b	(a6)+,d6
	move.w	d1,d3
	sub.b	0(a0,d6.w),d3		;N & Z
	scc	d4			;C
	NextInst

IE5					;SBC - Zero Page
	move.b	(a6)+,d6
	move.b	0(a0,d6.w),d6
	subq.b	#1,d4			;C-
	DecimalMode2
	scc	d4			;C
	svs	d5			;V
	NextInstStat

IE6					;INC - Zero Page
	move.b	(a6)+,d6
	lea	0(a0,d6.w),a2
	move.b	(a2),d6
	addq.b	#1,d6
	move.w	d6,d3			;N & Z
	move.b	d6,(a2)
	NextInst

IE7					;+ INC,SBC - Zero Page
	move.b	(a6)+,d6
	lea	0(a0,d6.w),a2
	move.b	(a2),d6
	addq.b	#1,d6
	move.b	d6,(a2)
	subq.b	#1,d4			;C-
	DecimalMode2
	scc	d4			;C
	svs	d5			;V
	NextInstStat

IE8					;INX
	addq.b	#1,d1
	move.w	d1,d3			;N & Z
	NextInst

IE9					;SBC - Immediate
	move.b	(a6)+,d6
	subq.b	#1,d4			;C-
	DecimalMode2
	scc	d4			;C
	svs	d5			;V
	NextInstStat

IEA					;NOP
	NextInstStat2

IEB					;+ SBC - Immediate
	move.b	(a6)+,d6
	subq.b	#1,d4			;C-
	DecimalMode2
	scc	d4			;C
	svs	d5			;V
	NextInstStat

IEC					;CPX - Absolute
	GETABSADDR
	MMU2	.io
	move.w	d1,d3
	sub.b	0(a0,d7.w),d3		;N & Z
	scc	d4			;C
	NextInst
.io
	INPUT
	move.w	d1,d3
	sub.b	d6,d3			;N & Z
	scc	d4			;C
	NextInst

IED					;SBC - Absolute
	GETABSADDR
	MMU2	.io
	move.b	0(a0,d7.w),d6
	subq.b	#1,d4			;C-
	DecimalMode2
	scc	d4			;C
	svs	d5			;V
	NextInstStat
.io
	INPUT
	subq.b	#1,d4			;C-
	DecimalMode2
	scc	d4			;C
	svs	d5			;V
	NextInstStat

IEE					;INC - Absolute
	GETABSADDR
	MMU	.rom
	lea	0(a0,d7.w),a2
	move.b	(a2),d6
	addq.b	#1,d6
	move.w	d6,d3			;N & Z
	move.b	d6,(a2)
	NextInst
.rom
	bmi.s	.io
	NextInst
.io
	INCIO

IEF					;+ INC,SBC - Absolute
	GETABSADDR
	MMU2	.io
	lea	0(a0,d7.w),a2
	move.b	(a2),d6
	addq.b	#1,d6
	move.b	d6,(a2)
	subq.b	#1,d4			;C-
	DecimalMode2
	scc	d4			;C
	svs	d5			;V
	NextInstStat
.io
	INPUT
	addq.b	#1,d6
	subq.b	#1,d4			;C-
	DecimalMode2
	scc	d4			;C
	svs	d5			;V
	move.w	d0,d3			;N & Z
	_OUTPUT

IF0					;BEQ
	move.b	(a6)+,d7
	tst.b	d3
	bne.s	.1
	ext.w	d7
	adda.w	d7,a6
.1
	NextInst
	IfStatus
	move.b	(a6)+,d7
	tst.b	d0
	bne.s	.2
	ext.w	d7
	adda.w	d7,a6
.2
	NextInstStat2

IF1					;SBC - (Indirect),Y
	GETINDYADDR
	MMU2	.io
	move.b	0(a0,d7.w),d6
	subq.b	#1,d4			;C
	DecimalMode2
	scc	d4			;C
	svs	d5			;V
	NextInstStat
.io
	INPUT
	subq.b	#1,d4			;C-
	DecimalMode2
	scc	d4			;C
	svs	d5			;V
	NextInstStat

IF2					;???
	NextInstStat2

IF3					;+ INC,SBC - (Ind),Y
	GETINDYADDR
	lea	0(a0,d7.w),a2
	move.b	(a2),d6
	addq.b	#1,d6
	move.b	d6,(a2)
	subq.b	#1,d4			;C-
	DecimalMode2
	scc	d4			;C
	svs	d5			;V
	NextInstStat

IF4					;+ NOP - Zero Page
	addq.l	#1,a6
	NextInstStat2

IF5					;SBC - Zero Page,X
	move.b	(a6)+,d6
	add.b	d1,d6
	move.b	0(a0,d6.w),d6
	subq.b	#1,d4			;C-
	DecimalMode2
	scc	d4			;C
	svs	d5			;V
	NextInstStat

IF6					;INC - Zero Page,X
	move.b	(a6)+,d6
	add.b	d1,d6			;X
	lea	0(a0,d6.w),a2
	move.b	(a2),d6
	addq.b	#1,d6
	move.w	d6,d3			;N & Z
	move.b	d6,(a2)
	NextInst

IF7					;+ INC,SBC - Zero Page,X
	move.b	(a6)+,d6
	add.b	d1,d6			;X
	lea	0(a0,d6.w),a2
	move.b	(a2),d6
	addq.b	#1,d6
	move.b	d6,(a2)
	subq.b	#1,d4			;C-
	DecimalMode2
	scc	d4			;C
	svs	d5			;V
	NextInstStat

IF8					;SED
	or.w	#$0800,d5		;D
	tst.w	d4			;D+
	bmi.s	IF8a
	move.l	#$00010000,a2
	add.l	a2,a4
	add.l	a2,a5
	or.w	#$8000,d4
	jmp	IF8a(pc,a2.l)
IF8a
	NextInstStat2

IF9					;SBC - Absolute,Y
	GETABSYADDR
	MMU2	.io
	move.b	0(a0,d7.w),d6
	subq.b	#1,d4			;C-
	DecimalMode2
	scc	d4			;C
	svs	d5			;V
	NextInstStat
.io
	INPUT
	subq.b	#1,d4			;C-
	DecimalMode2
	scc	d4			;C
	svs	d5			;V
	NextInstStat

IFA					;+ NOP
	NextInstStat2

IFB					;+ INC,SBC - Absolute,Y
	GETABSYADDR
	MMU2	.io
	lea	0(a0,d7.w),a2
	move.b	(a2),d6
	addq.b	#1,d6
	move.b	d6,(a2)
	subq.b	#1,d4			;C-
	DecimalMode2
	scc	d4			;C
	svs	d5			;V
	NextInstStat
.io
	INPUT
	addq.b	#1,d6
	subq.b	#1,d4			;C-
	DecimalMode2
	scc	d4			;C
	svs	d5			;V
	move.w	d0,d3			;N & Z
	_OUTPUT

IFC					;+ NOP - Absolute
	addq.l	#2,a6
	NextInstStat2

IFD					;SBC - Absolute,X
	GETABSXADDR
	MMU2	.io
	move.b	0(a0,d7.w),d6
	subq.b	#1,d4			;C-
	DecimalMode2
	scc	d4			;C
	svs	d5			;V
	NextInstStat
.io
	INPUT
	subq.b	#1,d4			;C-
	DecimalMode2
	scc	d4			;C
	svs	d5			;V
	NextInstStat

IFE					;INC - Absolute,X
	GETABSXADDR
	MMU	.rom
	lea	0(a0,d7.w),a2
	move.b	(a2),d6
	addq.b	#1,d6
	move.w	d6,d3			;N & Z
	move.b	d6,(a2)
	NextInst
.rom
	bmi.s	.io
	NextInst
.io
	INCIO

IFF					;+ INC,SBC - Absolute,X
	GETABSXADDR
	MMU2	.io
	lea	0(a0,d7.w),a2
	move.b	(a2),d6
	addq.b	#1,d6
	move.b	d6,(a2)
	subq.b	#1,d4			;C-
	DecimalMode2
	scc	d4			;C
	svs	d5			;V
	NextInstStat
.io
	INPUT
	addq.b	#1,d6
	subq.b	#1,d4			;C-
	DecimalMode2
	scc	d4			;C
	svs	d5			;V
	move.w	d0,d3			;N & Z
	_OUTPUT
IEND

GfxName
	GRAFNAME

	Section	Bss_F,BSS
IRQRegSave
	ds.l	7
CurrentRow
	ds.w	1
VerticalStart
	ds.w	1
VerticalStop
	ds.w	1
HorizontalStart
	ds.w	1
HorizontalStop
	ds.w	1
BitPlanesOffset
	ds.l	1
CPUVersion
	ds.w	1
OldDMAENA
	ds.w	1
OldIRQENA
	ds.w	1
Vic20Regs
	ds.w	8
SaveCIAAmiga
	ds.l	$30/4
SaveCIAC64
	ds.l	$30/4
_GfxBase
	ds.l	1
_DOSBase
	ds.l	1
OldVBR
	ds.l	1
OldCopper1
	ds.l	1
OldCopper2
	ds.l	1
Copper2List
	ds.l	1
VIC20Keyboard
	ds.l	2
PaddleXY
	ds.w	1
LeftAltKey
	ds.b	1
RightAltKey
	ds.b	1
RightAmigaKey
	ds.b	1
PaddleMode
	ds.b	1
Copper2Nr
	ds.b	1

**************************************************
END
