﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Linq;
using System.Windows.Forms;
using System.IO;
using KSDManager;
using Jacobi.Vst.Framework;
using Jacobi.Vst.Core;
using System.Configuration;
using System.Reflection;
using System.Runtime.InteropServices;
using Jacobi.Vst.Interop.Host;

namespace TinyFM8
{
    public partial class FM8HostForm : Form
    {
        [DllImport("user32.dll")]
        public static extern IntPtr GetParent(IntPtr hWnd);

        [DllImport("user32.dll")]
        static extern IntPtr GetFocus();

        public Plugin _plugin;
        public string LeftSideMode;
        public string RightSideMode;
        public bool   ShowButtomPanel;
        public float  ButtomPanelTop;
        public int    CompressorMode;
        public bool LoadKSDFromHostRequest;


        public FM8HostForm()
        {
            InitializeComponent();
            tabControl1.SelectedIndex = 1;         

            ButtomPanelTop = pnlButtom.Top;
        }

        bool IsInFocus()
        {
            var hWnd = GetFocus();
            var ContainerHandle = GetParent(Handle);

            while (hWnd != IntPtr.Zero)
            {
                if (ContainerHandle == hWnd)
                    return true;

                hWnd = GetParent(hWnd);
            }

            return false;
        }

        void HookManager_MouseUp(object sender, MouseEventArgs e)
        {
            if (IsInFocus())
                LoadKSDFromHostRequest = true;
                
        }

        private void trackBar1_Scroll(object sender, EventArgs e)
        {
            double Value = trackBar1.Value / 1000.0;
            _plugin.AudioProcessor.Track1 = (float)Value;
            label1.Text = Value.ToString();
        }

        private void trackBar2_Scroll(object sender, EventArgs e)
        {
            double Value = trackBar2.Value / 1000.0;
            _plugin.AudioProcessor.Track2 = (float)Value;
            label2.Text = Value.ToString();
        }

        private void trackBar3_Scroll(object sender, EventArgs e)
        {
            double Value = trackBar3.Value / 1000.0;
            _plugin.AudioProcessor.Track3 = (float)Value;
            label3.Text = Value.ToString();
        }

        private void timerStartup_Tick(object sender, EventArgs e)
        {
            timerStartup.Enabled = false;
            trackBar1.Value = 500; trackBar1_Scroll(null, null);
            trackBar2.Value = 500; trackBar2_Scroll(null, null);
            trackBar3.Value = 500; trackBar3_Scroll(null, null);
            _plugin.LoadFM8FromHost();
        }

        private void timerUpdate_Tick(object sender, EventArgs e)
        {
            lblCurrentOut.Text = _plugin.AudioProcessor.ScrollLock ? "FM8" : "TinyFM8";

            if (LoadKSDFromHostRequest)
            {
                LoadKSDFromHostRequest = false;
                _plugin.LoadFM8FromHost();
            }
        }

        private void btnCopyWave_Click(object sender, EventArgs e)
        {
            _plugin.AudioProcessor.GetSample = true;
        }

        private void VSTUserControl_VisibleChanged(object sender, EventArgs e)
        {
        }
    }
}
