#include "FM8_Utils.h"

int LoadInterlacedStruct(UInt8*& pInterlacedData, UInt8*& pStructs, int nStructSize, int nLoadSize)
{
    // Get the number of instruments
    UInt8 nElements = *pInterlacedData++;

    // Allocate member
    pStructs = (UInt8*)GlobalAlloc(GMEM_ZEROINIT, nElements * nStructSize);
    FM8_memset(pStructs, 0, nElements * nStructSize);

    // load static block
    for (int i = 0; i < nLoadSize; i++)
        for (int j = 0; j < nElements; j++) 
            pStructs[j * nStructSize + i] = *(pInterlacedData++);
        
    return nElements;
}

void Load2DJaggedArray(UInt8* pDst, UInt8*& pSrc, int nItemSize, Int8* nRowsLength)
{
    for (int nRow = 0; nRow < 9/*nRowsCount*/; nRow++)
    {
        int nRowSize = nItemSize * (*nRowsLength++); 
        FM8_memcpy(pDst, pSrc, nRowSize);
        pSrc += nRowSize;
        pDst += (128/*nDstItemsStride*/ * nItemSize);
    }
}


#ifdef ENABLE_SAMPLE_LOGGING

	void LOG_CREATE(HANDLE& hFile, char* szFilename)
	{
		if (hFile == 0)
		  hFile = CreateFile(szFilename,  GENERIC_WRITE, 0,  NULL, CREATE_ALWAYS, 0, 0);
	}

	void LOG_SAMPLE(HANDLE file, float Sample)
	{
		 if ((GetKeyState( VK_NUMLOCK) & 1) == 0)
			 return;
	 
		DWORD writecount;
		WriteFile(file, &Sample, sizeof(Sample), &writecount, NULL);
	}

#endif

