﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
using Jacobi.Vst.Core;
using Jacobi.Vst.Framework;

namespace ReverbFX
{
    /// <summary>
    /// This class manages all parameters used by the plugin.
    /// </summary>
    public class PluginParameterFactory
    {
        Plugin _plugin;
        // we bypass thread safety concerns for now...

        /// <summary>
        /// A collection of parameter categories.
        /// </summary>
        public VstParameterCategoryCollection Categories = new VstParameterCategoryCollection();
        /// <summary>
        /// A collection of parameter definitions.
        /// </summary>
        public VstParameterInfoCollection ParameterInfos = new VstParameterInfoCollection();

        /// <summary>
        /// Initializes the new instance.
        /// </summary>
        public PluginParameterFactory(Plugin plugin)
        {
            _plugin = plugin;
            VstParameterCategory paramCat = new VstParameterCategory();
            paramCat.Name = "Parameters";

            Categories.Add(paramCat);
        }

        /// <summary>
        /// Fills the <paramref name="parameters"/> collection with all parameters.
        /// </summary>
        /// <param name="parameters">Must not be null.</param>
        /// <remarks>A <see cref="VstParameter"/> instance is created and linked up for each
        /// <see cref="VstParameterInfo"/> instance found in the <see cref="ParameterInfos"/> collection.</remarks>
        public void CreateParameters(VstParameterCollection parameters, List<VstParameterEx> paramList)
        {
            foreach (VstParameterInfoEx paramInfo in ParameterInfos)
            {
                if (Categories.Count > 0 && paramInfo.Category == null)
                {
                    paramInfo.Category = Categories[0];
                }

                VstParameterEx param;
                if (paramList == null)
                {
                    param = new VstParameterEx(paramInfo);
                }
                else
                {
                    param = paramList.First(t => t.Info.Label == paramInfo.Label);
                }

                //param.PropertyChanged += _plugin.param_PropertyChanged;
                parameters.Add(param);
            }
        }
    }
}
