﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using System.Windows.Forms;
using System.Reflection;
using KSDManager;

public class InstData
{
    public string Name;
    public string Incopatabilities;
    public string Filename; 
}

public class InstLib
{
    public List<InstData> InstList = new List<InstData>();

    public InstLib()
    {
        LoadLibrary();
    }

    private void LoadLibrary()
    {

        // Load Ini and folderlist
        var IniFilename = Path.GetDirectoryName(Assembly.GetAssembly(this.GetType()).Location) + @"\Settings.ini";
        //MessageBox.Show("Could not find " + IniFilename);
        if (!File.Exists(IniFilename))
        {
            MessageBox.Show("Could not find " + IniFilename);
            return;
        }

        var Ini = new INIFile(IniFilename);
        var FoldersList = Ini.GetValue("General", "SearchPath", "");
        if (String.IsNullOrEmpty(FoldersList))
            MessageBox.Show("SearchPath was not defined. Not KSD will be loaded");

        // Load and splite folders
        var Folders = FoldersList
            .Split(new char[] { ';' }, StringSplitOptions.RemoveEmptyEntries)
            .Select(t => t.Trim());

        // Load files from each folder
        foreach (var folder in Folders)
        {
            DirectoryInfo di;
            try
            {
                di = new DirectoryInfo(folder);
                if (!di.Exists)
                    throw new Exception("Folder was not found");
            }
            catch (Exception ex)
            {
                MessageBox.Show("The directory \"" + folder + "\" could not be processed.\r\n" + ex.Message, "Warning", MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                continue;
            }

            var FilesList = di.GetFiles("*.ksd");
            foreach (var file in FilesList)
            {
                var inst = new InstData();
                inst.Filename = file.FullName;
                inst.Name = Path.GetFileNameWithoutExtension(file.Name);

                try
                {
                    var ksd = KSDData.LoadFromFile(file.FullName);
                    //inst.Incopatabilities = AudioProcessor.ReportIncompatibilities(ksd);
                }
                catch (Exception ex)
                {
                    inst.Incopatabilities = "Load Error " + ex.Message;
                }

                InstList.Add(inst);
            }
        }
    }

}
