﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Jacobi.Vst.Framework;

public class CompressorData
{
    public VstParameterInfoCollection ParameterInfos = new VstParameterInfoCollection();
    public List<VstParameterEx> Parameters = new List<VstParameterEx>();

    public VstParameterManager prmAttackTimeMgr;
    public VstParameterManager prmReleaseTimeMgr;
    public VstParameterManager prmThresholdMgr;
    public VstParameterManager prmMakeupGainMgr;
    public VstParameterManager prmRatioMgr;

    public VstParameterEx prmAttackTime;
    public VstParameterEx prmReleaseTime;
    public VstParameterEx prmThreshold;
    public VstParameterEx prmMakeupGain;
    public VstParameterEx prmRatio;

    private void CreateParam(string Name, string Label, string Formatter, string PostFix, float DefaultValue, float MinValue, float MaxValue, int TrackMin, int TrackMax, int nSteps, out VstParameterManager paramManager, out VstParameterEx param)
    {
        var prmInfo = new VstParameterInfoEx(Name, Label, Formatter, PostFix, DefaultValue, MinValue, MaxValue, TrackMin, TrackMax, nSteps, out paramManager);
        param = new VstParameterEx(prmInfo);
        Parameters.Add(param);
        ParameterInfos.Add(prmInfo);
    }

    public CompressorData()
    {        
        CreateParam("Attack",  "Attack Time",  "{0:0.000}", "ms",   10,   0.001f,   10,   0,  100, 100, out prmAttackTimeMgr, out prmAttackTime);
        CreateParam("Release", "Release Time", "{0:0.000}", "ms",  100,   0.001f,  100,   0,  100, 100, out prmReleaseTimeMgr, out prmReleaseTime);
        CreateParam("Thshld",  "Threshold",    "{0:0.00}",  "dB",  -60,   0,      -100,   0, -100, 100, out prmThresholdMgr, out prmThreshold);
        CreateParam("Gain",    "MakeupGain",   "{0:0.00}",  "dB",    0, -50,        50, -50,   50, 100, out prmMakeupGainMgr, out prmMakeupGain);
        CreateParam("Ratio",   "Ratio",        "{0:0.0}:1",   "",    2,   1,        16,   0,  100, 100, out prmRatioMgr, out prmRatio);
    }
}
