; AutoHotkey Skript zur Erstellung einer GUI für die Batch-Datei

Version := "1.4"

Gui, Add, Text,, Bitte wählen Sie die WAV-Datei aus:
Gui, Add, Edit, vDatei w400
Gui, Add, Button, gBrowse, Durchsuchen

Gui, Add, Text,, Möchten Sie den Standardwert von -10 LUFS ändern?
Gui, Add, Radio, vChangeLoudness gShowLoudnessEdit, Ja
Gui, Add, Radio, Checked vNoChangeLoudness gHideLoudnessEdit, Nein

; Das Eingabefeld für den LUFS-Wert wird zunächst nicht angezeigt
Gui, Add, Text, vLoudnessLabel Hidden, Geben Sie den Ziel-Lautheitswert ein (Standard: -10 LUFS):
Gui, Add, Edit, vLoudness w100 Hidden

Gui, Add, Button, gStart, Starten
Gui, Show,, melcom's FFmpeg Audio Normalisierer v%Version%

return

; Überprüfen, ob ffmpeg.exe existiert
CheckFFmpeg:
if not FileExist("ffmpeg.exe")
{
    MsgBox, ffmpeg.exe wurde nicht gefunden. Bitte laden Sie die Datei von hier herunter: https://github.com/BtbN/FFmpeg-Builds/releases/tag/latest und kopieren Sie die Datei in das Verzeichnis dieses Tools.
    ExitApp
}
return
Browse:
FileSelectFile, Datei, 3, , Alle Dateien (*.*)
if not ErrorLevel
{
    SplitPath, Datei, , , Ext
    if (Ext != "wav")
    {
        MsgBox, Es handelt sich nicht um eine WAV-Datei. Bitte wählen Sie eine WAV-Datei aus.
        goto Browse
    }
    GuiControl,, Datei, %Datei%
}
return

ShowLoudnessEdit:
GuiControl, Show, LoudnessLabel
GuiControl, Show, Loudness
return

HideLoudnessEdit:
GuiControl, Hide, LoudnessLabel
GuiControl, Hide, Loudness
return
Start:
; Überprüfen, ob ffmpeg.exe existiert
if not FileExist("ffmpeg.exe")
{
    MsgBox, ffmpeg.exe wurde nicht gefunden. Bitte laden Sie die Datei von hier herunter: https://github.com/BtbN/FFmpeg-Builds/releases/tag/latest und kopieren Sie die Datei in das Verzeichnis dieses Tools.
    return
}

Gui, Submit, NoHide

if (Datei = "")
{
    MsgBox, Bitte wählen Sie eine WAV-Datei aus.
    ; Rufe die Dateiauswahl erneut auf
    goto Browse
}

if (NoChangeLoudness)
    Loudness := "-10"
else
    Loudness := Loudness

; Entferne die Erweiterung .wav und füge den neuen Namen hinzu
StringTrimRight, DateiOhneErw, Datei, 4
NormaleDatei := DateiOhneErw . "-Normalized.wav"

; Gemeinsame Log-Datei initialisieren
LogDatei := "ffmpeg_log.txt"
FormatTime, LogDatum,, yyyy-MM-dd HH:mm:ss
NeuerEintrag = ========================================================`n
NeuerEintrag .= "Prozess gestartet: " LogDatum "`n"
NeuerEintrag .= "========================================================`n"
FileAppend, %NeuerEintrag%, %LogDatei%
; Überprüfe, ob die Ausgabedatei bereits existiert
if FileExist(NormaleDatei)
{
    MsgBox, Die Ausgabedatei existiert bereits. Möchten Sie sie überschreiben?
    ifMsgBox, No
    {
        MsgBox, Der Prozess wurde abgebrochen.
        NeuerEintrag = "Prozess abgebrochen: " LogDatum "`n"
        NeuerEintrag .= "========================================================`n"
        FileAppend, %NeuerEintrag%, %LogDatei%
        return
    }
    ; Datei löschen, bevor sie überschrieben wird
    FileDelete, %NormaleDatei%
}

; Zeige Fortschrittsfenster an
Progress, b2 zh0 fs18, Bitte warten Sie, der Prozess läuft..., melcom's FFmpeg Audio Normalisierer v%Version%
SetTimer, UpdateProgress, 1000
Thread, NoTimers

; Überprüfe, ob die Eingabedatei existiert
if not FileExist(Datei)
{
    MsgBox, Eingabedatei nicht gefunden. Der Prozess wird abgebrochen.
    NeuerEintrag = "Fehler: Eingabedatei nicht gefunden.`n"
    NeuerEintrag .= "========================================================`n"
    FileAppend, %NeuerEintrag%, %LogDatei%
    Progress, Off
    SetTimer, UpdateProgress, Off
    return
}

; Führt den FFmpeg-Befehl aus und protokolliert die Ausgabe
RunWait, %comspec% /c ""ffmpeg.exe" -i "%Datei%" -af "loudnorm=I=%Loudness%:TP=-1" -ar 48000 -ac 2 -c:a pcm_f32le "%NormaleDatei%" >> "%LogDatei%" 2>>&1", , Hide

; Verberge Fortschrittsfenster
Progress, Off
SetTimer, UpdateProgress, Off

; Füge die Abschlussmeldung hinzu
FormatTime, LogDatum,, yyyy-MM-dd HH:mm:ss
if FileExist(NormaleDatei)
{
    NeuerEintrag = ========================================================`n
    NeuerEintrag .= "Prozess erfolgreich abgeschlossen: " LogDatum "`n"
    NeuerEintrag .= "========================================================`n"
}
else
{
    NeuerEintrag = ========================================================`n
    NeuerEintrag .= "Fehler bei der Normalisierung: " LogDatum "`n"
    NeuerEintrag .= "========================================================`n"
    MsgBox, Es gab ein Problem beim Erstellen der Ausgabedatei. Überprüfen Sie die Log-Datei für Details.
    Run, notepad.exe %LogDatei%
}
FileAppend, %NeuerEintrag%, %LogDatei%

; Zeige Abschlussmeldung und Möglichkeit, das Tool zu schließen
if FileExist(NormaleDatei)
{
    if FileExist(LogDatei)
    {
        MsgBox, Der Prozess wurde erfolgreich abgeschlossen.`nDie Log-Datei wurde aktualisiert.`nKlicken Sie auf OK, um eine weitere Datei zu verarbeiten.
    }
    else
    {
        MsgBox, Der Prozess wurde erfolgreich abgeschlossen.`nEine neue Log-Datei wurde erstellt.`nKlicken Sie auf OK, um eine weitere Datei zu verarbeiten.
    }
}
else
{
    MsgBox, Der Prozess konnte nicht abgeschlossen werden.`nKlicken Sie auf OK, um zum Hauptmenü zurückzukehren.
}

Gui, Submit, NoHide
GuiControl,, Datei,    ; Setze die Dateipfad-Eingabe zurück

Progress, Off
SetTimer, UpdateProgress, Off

return

GuiClose:
ExitApp

UpdateProgress:
Progress, 50
return
