/******************************************************************************/
/*                                                                            */
/*---== Raw Fast Fourier Transform v1.0 fot The Ultimate Chip Konstruktor==-- */
/*         Create files in the FFT format from an existing sound file         */
/*   Copyright (C) 1997  Frankie LIMONT  a.k.a. Kahar' Touch/BSB              */
/*                                                                            */
/*   This program is free software; you can redistribute it and/or modify     */
/*   it under the terms of the GNU General Public License as published by     */
/*   the Free Software Foundation; either version 2 of the License, or        */
/*   (at your option) any later version.                                      */
/*                                                                            */
/*   This program is distributed in the hope that it will be useful,          */
/*   but WITHOUT ANY WARRANTY; without even the implied warranty of           */
/*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            */
/*   GNU General Public License for more details.                             */
/*                                                                            */
/*   You should have received a copy of the GNU General Public License        */
/*   along with this program; if not, write to the Free Software              */
/*   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                */
/*                                                                            */
/*                                                                            */
/*   A copy of the GNU General Public License is available with this package  */
/*   in the .../chip/ directory (in the file COPYING). Please READ IT to know */
/*   YOUR rights.                                                             */
/*                                                                            */
/******************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

int main(int argc,char **argv)
{
FILE *wave, *coeff;
char *chaine;
int minfreq=20;
int maxfreq=11025;
int samprate=22050;
int sampnum,taboffs;
long sourcesize;
char *source; 
char *coefficients;
char *sintab;
int i,j;
long *carray; 
long maxim;
/* coefficient significatif minimal (en dessous ou gal on vire)*/
char mincoeff=0;

/* une jolie banner */
printf(" Raw Fast Fourier Transform v1.0 forThe Ultimate Chip Konstruktor v1.0\n Copyright (C) 1997 Frankie LIMONT\n");
printf(" \nRaw Fast Fourier Transform comes with ABSOLUTELY NO WARRANTY.\n");
printf(" This is free software, and you are welcome to redistribute it\n");
printf(" under certain conditions.\n");
printf(" See the GNU General Public License for more details\n");
printf(" A copy of the GNU General Public License is available in the .../chip/ directory\n");
printf(" in the file COPYING\n\n");


/* on teste le nombre d'arguments */
if (argc<3) { fprintf(stderr,"Bad argument count.\nSyntax : rfft infile.ext outfile.ext [mincoeff]\n\tmincoeff (optionnal) must belongs to 0..127 (0 is the default value)\n"); return -1; }
if (argc>4) { fprintf(stderr,"Bad argument count.\nSyntax : rfft infile.ext outfile.ext [mincoeff]\n\tmincoeff (optionnal) must belongs to 0..127 (0 is the default value)\n"); return -1; }
if (argc==4) { mincoeff=atoi(argv[3]); }
if ((wave=fopen(argv[1],"rb"))==NULL) { fprintf(stderr,"Error opening %s.\n",argv[1]); return -1 ; }
if ((coeff=fopen(argv[2],"w"))==NULL) { fprintf(stderr,"Error opening %s.\n",argv[1]); return -1 ; }
printf("Files correctly opened.\n");
/* combien y a-t-il de samples */
sourcesize=0;
while (getc(wave)!=EOF) { sourcesize++; }
/* allouons la mmoire en consquence */
sintab=malloc(sourcesize*sizeof(char));
source=malloc(sourcesize*sizeof(char));
carray=malloc((maxfreq-minfreq)*sizeof(long));
coefficients=malloc((maxfreq-minfreq)*sizeof(char));
/* chargeons le fichier en valeurs signes (pour une intgration c'est mieux)*/
rewind(wave);
for (i=0;i<sourcesize+1;i++) { source[i]=getc(wave)-128; }
fclose(wave);
printf("Memory allocation succesful : %d samples.\n",sourcesize);
/* partons alors dans le calcul des coeffs */
printf("Computing sinus tables and coefficients. It takes a few minutes ...\nPlease WAIT !\n");
/* on les initialise  zro */
for (i=0;i<(maxfreq-minfreq+1);i++) { carray[i]=0; }
printf("initialised.");
/*la boucle qui bouffe du temps processeur au petit djeuner */
for (i=minfreq;i<(maxfreq+1);i++)
        { 
        taboffs=i-minfreq;
        /* la table de sinus */
        for (j=0;j<sourcesize+1;j++) 
                {
                sintab[j]=128*sin(2*PI*i*j/samprate);
                /* printf("%3d\n",sintab[j]); */
                }
        /* calcul des coeffs de sinus */
        for (j=0;j<sourcesize+1;j++) { carray[taboffs]=(sintab[j]*source[j]/(2*PI))+carray[taboffs]; }
        /* printf("Frequency : %5d Coefficient : %10d\n",i,carray[i]); */
        }
/* et quelques temps plus tard */
printf("Coefficients succesfuly computed.\n");
printf("Normalizing data.\n");
/* dtermination du coefficient maximum */
maxim=0;
for (i=0;i<(maxfreq-minfreq+1);i++)
        { if (maxim<abs(carray[i]))
                { if ((carray[i])<0) { maxim=(-carray[i]); }
                  if ((carray[i])>0) { maxim=(carray[i]); }  
                }
        }
printf("Got maximum : %30d .\n",maxim);
/* on ramne le tout en 8 bits prt  tre enregistr en sign */
for (i=0;i<(maxfreq-minfreq+1);i++)
        {
        coefficients[i]=(127*carray[i])/maxim;
        /* printf("8bits coeff : %10d 32bits coeff : %30d\n",coefficients[i],carray[i]); */
        }
printf("Normalization done.\n");
printf("Creating output file.");
/* Ecrit les donnes dans le fichier de sortie. */
chaine="; Fichier cr par RAWFFT ralis par la Blue Sprite Band.\n";
fputs(chaine,coeff);
fputs("#header ",coeff);
sampnum=0;
for (i=0;i<(maxfreq-minfreq+1);i++)
        { if (abs(coefficients[i])>mincoeff) { sampnum++; } }
itoa(sampnum,chaine,10);
fputs(chaine,coeff);
fputs("\n#data\n",coeff);
printf(" Writing data.");
for (i=0;i<(maxfreq-minfreq+1);i++)
        { if (abs(coefficients[i])>mincoeff) {
                itoa(i+minfreq,chaine,10);
                fputs(chaine,coeff);
                fputs(" ",coeff);
                itoa(coefficients[i],chaine,10);
                fputs(chaine,coeff);
                fputs(" ",coeff);
                fputs("s",coeff);
                fputs("\n",coeff);
                }
        }
        fputs("\n#eof\n",coeff); 
printf(" Done.\n\n");
fclose(coeff);
free(sintab);
free(source);
free(carray);
free(coefficients);
printf("Everything went OK.\n");
printf("Thank you for using a blue product.\n");
return 0;
}
