;----------------------------------------------------------------------------
; Music Box Musicplayer ISAS Example V1.03.00
;
; $d000-d436 Version (player: $d000-$d420, memory usage: $d421-$d436)
;
; By Ray 'Credo' Nemes of Black Box Development <blackbox@resource.cx>
;
; From 05/09/1998 to 26/02/2001
;
; note: this is a really-really minimal quick start example, not a good
; learning material as it is wasting more battery power than needed (LCDC LYC
; interrupt usage is more recommended or VBLANK), is using the ISAS compiler
; (RGBDS and GBDK (as GBDK compiler can use RGBDS) versions are also
; available in the package and can be ported to any other compiler in a
; couple of seconds) and doesn't demonstrating the STOP, CONTINUE functions,
; the multispeed musics (doubleplayer, quattro player) and soundeffects (to
; make this one smaller and easier to understand)
;
; also note: customers will get examples for all the GameBoy compilers, also
; can compile the player everywhere in ROM/WRAM/SRAM, also can set the
; player's memory usage everywhere in WRAM/SRAM, also will get customized
; examples and customized players on request
;----------------------------------------------------------------------------

;-[header]-------------------------------------------------------------------

                onbankgroup
bank00          group $00
                org $0000

                libbin header.bin       ; a typical header file with card
                                        ; name, ROM/RAM size, etc, this one
                                        ; will start the program at $0150,
                                        ; you can use your own header

;-[main code]----------------------------------------------------------------

                org $0150

main:           ld      hl,player       ; this routine will upload the $0421
                ld      de,$d000        ; large musicplayer into the WRAM
                ld      bc,$0421        ; from $d000
uploadloop:     ld      a,(hl+)         ; note: you can use several WRAM
                ld      (de),a          ; banks on GBC in this area, so
                inc     de              ; theorically this will not waste
                dec     bc              ; memory, but always switch on the
                ld      a,b             ; player's WRAM bank before calling
                or      c               ; player functions
                jr      nz,uploadloop

;-[!INITIALIZATION!]---------------------------------------------------------

                ld      hl,music        ; load music address to hl
                xor     a               ; load beginning pattern pos to a (0)
                ld      b,a             ; load restart pattern pos to b (0)
                call    $d000           ; initialize the music

;-[!END OF INITIALIZATION!]--------------------------------------------------

mainloop:       ld      a,($ff44)       ; wait for a raster position, in this
                cp      $00             ; case to the 000th position, but
                jr      nz,mainloop     ; can be changed

;-[!PLAYING THE MUSIC!]------------------------------------------------------

                call    $d006           ; update the music in every frame at
                                        ; the same raster position

;-[!END OF PLAYING THE MUSIC!]-----------------------------------------------

                jr      mainloop        ; jump back to the main loop

;----------------------------------------------------------------------------

player:         libbin player.bin       ; the player as binary data

music:          libbin xayne.sav        ; the music as binary data
                                        ; this is a simple 8K file directly
                                        ; from the editor card's SRAM or
                                        ; saved by an emulator as
                                        ; musicbox.sav

;----------------------------------------------------------------------------
