// ------------------------------------------------------
// Synth.h
// CopyRight (C) 2004 Franck "hitchhikr" Charlet / TRSI.

#ifndef _SYNTH_H_
#define _SYNTH_H_

// ------------------------------------------------------
// Includes
#include "CList.h"
#include <stdio.h>

// ------------------------------------------------------
// Constants
#define INS_WF_SIN 1
#define INS_WF_SQR 2
#define INS_WF_SAW 3
#define INS_WF_RND 4
#define INS_WF_TRIANGLE 5
#define INS_WF_CUST 6

#define INS_OP_ADD 1
#define INS_OP_SUB 2
#define INS_OP_MUL 3
#define INS_OP_DIV 4

#define SEQ_DSP_LOPASS 1			// Rezo/Cutoff
#define SEQ_DSP_HIPASS 2			// Rezo/Cutoff
#define SEQ_DSP_VCFPASS 3			// Rezo/Cutoff
#define SEQ_DSP_DELAY 4				// Delay/Feedback/Pan
#define SEQ_DSP_DISTO 5				// [Not used]/Distortion amount
#define SEQ_DSP_FORMANT 6			// Filter number (1 to 5)/[Not Used]
#define SEQ_DSP_REVERB 7			// Delay/Feedback/Pan

#define SEQ_FX_ARPEGGIO 1			// Quarter1/Quarter2
#define SEQ_FX_PITCHBENDUP 2		// Speed
#define SEQ_FX_PITCHBENDDOWN 3		// Speed
#define SEQ_FX_VIBRATO 4			// Speed/Depth
#define SEQ_FX_VOLSLIDEUP 5			// Speed
#define SEQ_FX_VOLSLIDEDOWN 6		// Speed
#define SEQ_FX_SETEMPO 7			// Tempo
#define SEQ_FX_SETFXTEMPO 8			// FX Tempo
#define SEQ_FX_SETGLOBALVOLUME 9	// Volume
#define SEQ_FX_TONEPORTAMENTO 10	// Speed
#define SEQ_FX_SYNCHRO 11			// User value

// ------------------------------------------------------
// Structures
typedef struct _INSTRUMENT_DAT {
	BYTE Operator;
	BYTE Waveform;
	WORD PhaseShift;
	BYTE Attack_Vol;
	BYTE Attack_Vol_Delta;
	WORD Attack;
	BYTE Decay_Vol;
	BYTE Decay_Vol_Delta;
	WORD Decay;
	BYTE Sustain_Vol;
	BYTE Sustain_Vol_Delta;
	WORD Sustain;
	BYTE Release_Vol;
	BYTE Release_Vol_Delta;
	WORD Release;
} INSTRUMENT_DAT, *LPINSTRUMENT_DAT;

typedef struct _SEQUENCE_DAT {
	BYTE Note[16];
	WORD Instrument[16];
	BYTE Volume[16];
	BYTE Panning[16];
	BYTE DspMask[16];
	BYTE Dsp[16];
	BYTE DspDatas1[16];
	BYTE DspDatas2[16];
	BYTE DspDatas3[16];
	BYTE Fx[16];
	BYTE FxDatas[16];
} SEQUENCE_DAT, *LPSEQUENCE_DAT;

typedef struct _SONG_DAT {
	WORD Seq_Nbr;
	BYTE Transpose;
	BYTE Volume;
} SONG_DAT, *LPSONG_DAT;

typedef struct _INSTRUMENT_VARS {
	float Instrument_Vol;
	int Instrument_Tick;
	float wrn1;
	float wrn2;
	float wrpos;
	float FPos;
	DWORD Frac_Lo_Pos;
	DWORD Oscillator;
} INSTRUMENT_VARS, *LPINSTRUMENT_VARS;

enum PLAY_TYPES {
	No_Play,
	Play_Instrument,
	Play_Sequence,
	Play_Song
};

typedef struct _INSTRUMENT {
	char *FileName;
	CList *Datas;			// INSTRUMENT_DAT
} INSTRUMENT, *LPINSTRUMENT;

typedef struct _SEQUENCE {
	LPSEQUENCE_DAT Seq_Cur_Sequence;
	LPINSTRUMENT Seq_Current_Instrument;
	LPINSTRUMENT_DAT Seq_Current_Instrument_Dat;
	DWORD Seq_Instrument_NbrComb;
	DWORD Seq_Freq_Lo_Speed;
	DWORD Seq_Freq_Hi_Speed;
	float Seq_Pan;					// 0.5f
	float Seq_Volume;				// 1.0f
	float Seq_Position_Volume;		// 1.0f
	float Seq_Mute_Volume;
	int Seq_Position_Transpose;
	int Formant_Param1;
	float Disto_Param;
	float Disto_Abs_Input;
	float Seq_Hi_Pass_Param1;
	float Seq_Hi_Pass_Param2;
	float Seq_Hi_Pass_In1;
	float Seq_Hi_Pass_Out1;
	float Seq_Hi_Pass_In2;
	float Seq_Hi_Pass_Out2;
	float Seq_Lo_Pass_Param1;
	float Seq_Lo_Pass_Param2;
	float Seq_Lo_Pass_In1;
	float Seq_Lo_Pass_Out1;
	float Seq_Lo_Pass_In2;
	float Seq_Lo_Pass_Out2;
	float Seq_VCF_Pass_Param1;
	float Seq_VCF_Pass_Param2;
	float Seq_VCF_Pass_Out1;
	float Seq_VCF_Pass_Out2;
	float Seq_VCF_Pass_Out3;
	float Seq_VCF_Pass_Out4;
	float Seq_VCF_Pass_In1;
	float Seq_VCF_Pass_In2;
	float Seq_VCF_Pass_In3;
	float Seq_VCF_Pass_In4;
	int Seq_Reverb_Cursor;
	long Seq_Reverb_Value;
	float Seq_Reverb_Left_FeedBack_Value;
	float Seq_Reverb_Right_FeedBack_Value;
	float *Seq_Reverb_Left_Buffer;
	float *Seq_Reverb_Right_Buffer;
	float Seq_Reverb_Left_Value;
	float Seq_Reverb_Right_Value;
	int Seq_Delay_Cursor;
	long Seq_Delay_Value;
	float Seq_Delay_Left_FeedBack_Value;
	float Seq_Delay_Right_FeedBack_Value;
	float *Seq_Delay_Left_Buffer;
	float *Seq_Delay_Right_Buffer;
	int Seq_Arpeggio;
	float Seq_Vol_Side;
	int Seq_Pitch_Bend_Freq;
	int Seq_Current_Freq;
	int Seq_Pitch_Bend;
	int Seq_Vibrato;
	int Seq_Vibrato_Freq;
	int Seq_Vibrato_Tick;
	int Seq_Tone_Portamento_Speed;
	int Seq_Tone_Portamento_Note;
	float Sound_Datas;
	int Seq_Old_Vol_Side_Down;
	int Seq_Old_Vol_Side_Up;
	int Seq_Old_Pitch_Bend_Down;
	int Seq_Old_Pitch_Bend_Up;
	int Seq_Old_Vibrato;
	int Seq_Old_Arpeggio;
	int Seq_Old_Tone_Portamento_Speed;
	int Seq_Old_Tone_Portamento_Note;
	int Seq_Cur_Note;
	int Seq_Cur_Freq;
	INSTRUMENT_VARS Seq_Cur_Instrument_Vars[256];
	double Formant_Tmp_Mem[10];
} SEQUENCE, *LPSEQUENCE;

// ------------------------------------------------------
// Variables
extern int Synth_Play_State;
extern WORD Spectrum_Buffer[44100];
extern int Play_Type;
extern int Tempo;
extern int Cur_Ticks;
extern int Tempo_Ticks;
extern int Fx_Tempo;
extern int Fx_Ticks;
extern int Fx_Tempo_Ticks;
extern LPINSTRUMENT Current_Instrument;
extern int Instr_Datas_Copied;
extern int Current_Instr_Note;
extern int Arpeggio_Counter;
extern int Cur_Seq_Play_Pos;
extern int OnOff_Status[8];
extern CList Instruments;			// INSTRUMENT
extern CList Instruments_Dats;		// INSTRUMENT_DAT
extern CList *Positions[8];
extern CList Sequences;
extern SEQUENCE Dummy_Sequence_Dats;
extern int Song_Position;
extern int Song_Restart;
extern int Render_Wave;

// ------------------------------------------------------
// Functions
int __stdcall Synth_Init(HWND hWnd, void (__stdcall *CallBack)(int Datas));
void __stdcall Synth_Stop(void);
void __stdcall Synth_Play(void);
int __stdcall Get_Mix_Buffer_Len(DWORD BPM);
void Clear_Buffers(void);
void __stdcall Display_Tempo(int Tempo_Display);
void __stdcall Display_Fx_Tempo(int Tempo_Display);

#endif
