; ------------------------------------------
; Test for TRSI Sound Monitor replay routine
; Written by Franck 'hitchhikr' Charlet/TRSI
;
; MASM32 required.
; ------------------------------------------
; buildblock RELEASE
; 	CAPT [BINDIR]\ml.exe /c /coff /I"[INCLUDEDIR]" "%2"
; 	CAPT [BINDIR]\Link.exe /MERGE:.data=.text /LIBPATH:"[LIBDIR]" /MERGE:.rdata=.text /SECTION:.text,ERW /IGNORE:4078 /SUBSYSTEM:WINDOWS "%1.obj" "TSMReplay.obj"
; buildblockend
; buildblock DEBUG
; 	CAPT [BINDIR]\ml.exe /Zd /Zi /c /coff /I"[INCLUDEDIR]" "%2"
;	CAPT [BINDIR]\Link.exe /DEBUG /DEBUGTYPE:CV /INCREMENTAL:NO /LIBPATH:"[LIBDIR]" /MERGE:.data=.text /MERGE:.rdata=.text /SECTION:.text,ERW /IGNORE:4078 /SUBSYSTEM:WINDOWS "%1.obj" "TSMReplay.obj"
; buildblockend

; --------------- File model
				.386
				.model	flat,stdcall
				option	casemap:none

; --------------- Includes
				include	windows.inc
		 		include kernel32.inc
		 		include user32.inc
				include dsound.inc
		 		include DSoundConst.inc

; --------------- Libraries
				includelib kernel32.lib
				includelib user32.lib
				includelib dsound.lib


; --------------- External functions
TSM_Init			PROTO	:DWORD,:HWND,:DWORD
TSM_Stop			PROTO
TSM_Play			PROTO

; --------------- Datas section
				.data

Window_Name			db	"TRSI Sound Monitor replay routine.",0
Window_Class_Name		db	"TSMReplay_Class",0
hWnd				dd	0
Module_Mem			dd	0
Read_Bytes			dd	0
Thread_Id			dd	0
hReplay_Thread			dd	0

; ***** Change this *****
Module_Name			db	"..\Songs\wizardry.TSM",0

; --------------- Code section
				.code

; --------------- Handle song messages
CallBack_Routine		proc	Datas:dword

				ret
CallBack_Routine		endp

; --------------- Audio rendering
Synth_Thread			proc	lpParameter:dword
Synth_Loop:			invoke	TSM_Play
				invoke	Sleep,1
				jmp	Synth_Loop
Synth_Thread			endp

; --------------- Handle window messages
Main_Loop			proc	hWin:dword,uMsg:dword,wParam:dword,lParam:dword
				.if uMsg == WM_DESTROY
					.if hReplay_Thread != 0
						invoke	TerminateThread, hReplay_Thread, 0
						invoke	CloseHandle, hReplay_Thread
					.endif
					invoke	TSM_Stop
					invoke	GlobalFree,Module_Mem
					invoke	PostQuitMessage,0
					xor	eax,eax
					ret
				.endif
				invoke	DefWindowProc,hWin,uMsg,wParam,lParam
				ret
Main_Loop			endp

; --- Open a file and load it into a memory block
; Returns the allocated memory block or 0
; (Free memory block with GlobalFree)
Load_File			proc	FName:dword,File_Read_Bytes:dword
				local	FHandle:dword
				local	FSize:dword
				local	FPosition:dword

				mov	FPosition,0
				invoke	CreateFile,FName,GENERIC_READ,0,0,OPEN_EXISTING,FILE_FLAG_SEQUENTIAL_SCAN,0
				inc	eax
				je	Error_OpenFile
				dec	eax
				mov	FHandle,eax
				invoke	GetFileSize,eax,0
				inc	eax
				je	Error_ReadFile
				dec	eax
				mov	FSize,eax
				inc	eax				; Append a 0 char
				invoke	GlobalAlloc,GMEM_FIXED or GMEM_ZEROINIT,eax
				test	eax,eax
				jz	Error_ReadFile
				mov	FPosition,eax
				invoke	ReadFile,FHandle,FPosition,FSize,File_Read_Bytes,0
Error_ReadFile:			invoke	CloseHandle,FHandle
Error_OpenFile:			mov	eax,FPosition			; Return the memory block address
				ret
Load_File			endp

; --------------- Display main window
DisplayWindow			proc	hInst:dword
				local	wc:WNDCLASSEX
	        		mov	wc.cbSize,sizeof WNDCLASSEX
				mov	wc.style,CS_HREDRAW or CS_VREDRAW or CS_BYTEALIGNWINDOW
				mov	wc.lpfnWndProc,offset Main_Loop
				xor	eax,eax
				mov	wc.cbClsExtra,eax
				mov	wc.cbWndExtra,eax
				push	hInst
				pop	wc.hInstance
				mov	wc.hbrBackground,COLOR_BTNFACE+1
				mov	wc.lpszMenuName,eax
				mov	wc.lpszClassName,offset Window_Class_Name
				mov	wc.hIcon,eax
				mov	wc.hIconSm,eax
				invoke	LoadCursor,eax,IDC_ARROW
				mov	wc.hCursor,eax
				invoke	RegisterClassEx,addr wc
			        invoke	CreateWindowEx,0,addr Window_Class_Name,addr Window_Name,WS_BORDER or WS_CAPTION or WS_SYSMENU,100,100,400,100,0,0,hInst,0
				mov	hWnd,eax
				invoke	ShowWindow,hWnd,SW_SHOWNORMAL
				invoke	UpdateWindow,hWnd
				mov	eax,hWnd
				ret
DisplayWindow			endp

; --------------- Process window messages
DoEvents			proc
				local	msg:MSG
StartLoop:			invoke	GetMessage,addr msg, 0, 0, 0
				test	eax,eax
				jz	ExitLoop
				invoke	DispatchMessage,addr msg
				jmp	StartLoop
ExitLoop:			mov	eax,msg.wParam
				ret
DoEvents			endp

; -----------------
; --- WinMain() ---
; -----------------
WinMain				proc	hInstance:dword,hPrevInstance:dword,lpCmdLine:dword,nCmdShow:dword
				; Load the file into memory
				invoke	Load_File,addr Module_Name,addr Read_Bytes
				mov	Module_Mem,eax
				test	eax,eax
				jz	Err_LoadModule
				invoke	DisplayWindow,hInstance
				test	eax,eax
				jz	Err_InitModule
				;CallBack_Routine can be NULL
				invoke	TSM_Init,Module_Mem,eax,addr CallBack_Routine
				test	eax,eax
				jz	Err_InitModule
				invoke	CreateThread,0, 0, addr Synth_Thread, 0, 0, addr Thread_Id
				mov	hReplay_Thread,eax
				test	eax,eax
				jz	Err_InitModule
				invoke	DoEvents
				ret
Err_InitModule:			invoke	GlobalFree,Module_Mem
				invoke	TSM_Stop
Err_LoadModule:			xor	eax,eax
				ret
WinMain				endp

; ---------------------
; --- Program start ---
; ---------------------
start:				invoke	GetModuleHandle,NULL
				push	eax
				invoke	GetCommandLine
				pop	ebx
				invoke	WinMain,ebx,0,eax,SW_SHOWDEFAULT
				invoke	ExitProcess,eax

end start
