/*
 * Decompiled with CFR 0.152.
 */
package symreader;

import java.util.Arrays;

class SymphonieDSP {
    boolean Running = false;
    int NumbOfChannels = 2;
    private int RingBufferLenSamples;
    private int NewFXLength = this.RingBufferLenSamples = 128000 * this.NumbOfChannels;
    private int FXLength = this.RingBufferLenSamples;
    private float[] RingBuffer;
    private int readPtrDelay = 100;
    private int readPtrIndex = 0;
    private int writePtrIndex = 0;
    int InputChannels = 0;
    float DSPIntensity = 0.4f;
    float WetMixVolume = 0.65f;
    private int FxType = 0;
    private boolean OverWritePrevSample = false;
    private int BufferLenSub = 1;
    private boolean LengthInBeats;
    private int BeatLength;
    private int MaxBeatsDspLen;

    SymphonieDSP(int NumbOfInputChannels) {
        this.InputChannels = NumbOfInputChannels;
        this.allocMemory();
        this.emptyRingBuffers();
        this.setDelay(this.RingBufferLenSamples);
        this.setSyncToBeat(false);
    }

    private void allocMemory() {
        this.RingBuffer = new float[this.RingBufferLenSamples + 256];
    }

    void init() {
        this.allocMemory();
        this.SetFxClass(0);
    }

    void setBeatLength(int len) {
        this.BeatLength = len;
        this.recalcNumbOfBeats();
    }

    private void recalcNumbOfBeats() {
        if (this.BeatLength == 0) {
            this.BeatLength = 600;
        }
        this.MaxBeatsDspLen = this.RingBufferLenSamples / this.BeatLength;
    }

    void setSyncToBeat(boolean b) {
        this.LengthInBeats = b;
        this.recalcNumbOfBeats();
    }

    int getMaxBeatsDspLen() {
        this.recalcNumbOfBeats();
        return this.MaxBeatsDspLen;
    }

    void SetFxClass(int myFxType) {
        this.stop();
        this.FxType = myFxType;
        this.OverWritePrevSample = true;
        if (this.FxType == 1 || this.FxType == 2) {
            this.OverWritePrevSample = false;
        }
        this.BufferLenSub = this.FxType == 2 ? 1 : 2;
        if (this.FxType != 0) {
            this.start();
        }
    }

    void emptyRingBuffers() {
        Arrays.fill(this.RingBuffer, 0.0f);
    }

    void setNewLength(int len) {
        if (this.Running) {
            this.stop();
            this.NewFXLength = !this.LengthInBeats ? this.RingBufferLenSamples * len / 100 : this.BeatLength * len;
            this.start();
        }
    }

    private void initLenghts() {
        this.FXLength = this.NewFXLength;
        this.readPtrIndex = 0;
        int NewDelayLen = (this.FXLength - 2) * this.readPtrDelay / 100;
        this.writePtrIndex = this.FxType == 4 || this.FxType == 2 ? NewDelayLen - 1 : (NewDelayLen &= 0xFFFFFFFE);
        if (this.writePtrIndex < 0) {
            this.writePtrIndex = 0;
        }
    }

    void setDelay(int len) {
        if (this.Running) {
            this.stop();
            this.readPtrDelay = len;
            this.start();
        }
    }

    void start() {
        this.stop();
        this.emptyRingBuffers();
        this.initLenghts();
        if (this.NewFXLength > 0) {
            this.Running = true;
        }
    }

    void stop() {
        this.Running = false;
    }

    void doDSP() {
        if (this.Running && this.FxType != 0) {
            switch (this.FxType) {
                case 1: {
                    this.RingBuffer[this.readPtrIndex] = this.RingBuffer[this.readPtrIndex] * this.DSPIntensity;
                    break;
                }
                case 2: {
                    this.RingBuffer[this.readPtrIndex] = this.RingBuffer[this.readPtrIndex] * this.DSPIntensity;
                    break;
                }
                case 3: {
                    this.RingBuffer[this.readPtrIndex] = this.RingBuffer[this.readPtrIndex] * this.DSPIntensity;
                    break;
                }
                case 4: {
                    this.RingBuffer[this.readPtrIndex] = this.RingBuffer[this.readPtrIndex] * this.DSPIntensity;
                }
            }
        }
    }

    void advanceWritePtr() {
        if (this.Running) {
            if (this.writePtrIndex == 0) {
                this.FXLength = this.NewFXLength;
            }
            this.writePtrIndex = this.advanceRingBufferPtr(this.writePtrIndex);
        }
    }

    void addVoiceSampleIntoDSP(float Sample) {
        if (this.Running) {
            int n = this.writePtrIndex;
            this.RingBuffer[n] = this.RingBuffer[n] + Sample;
        }
    }

    float getWetMixSample() {
        if (this.Running) {
            this.doDSP();
            float Sample = this.RingBuffer[this.readPtrIndex];
            if (this.OverWritePrevSample) {
                this.RingBuffer[this.readPtrIndex] = 0.0f;
            }
            return Sample * this.WetMixVolume;
        }
        return 0.0f;
    }

    private int advanceRingBufferPtr(int myptr) {
        if (++myptr >= this.FXLength - this.BufferLenSub) {
            myptr = 0;
        }
        return myptr;
    }

    void advanceReadPtr() {
        if (this.Running) {
            this.readPtrIndex = this.advanceRingBufferPtr(this.readPtrIndex);
        }
    }
}

