/*
 * Decompiled with CFR 0.152.
 */
package symreader;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.DefaultListModel;
import symreader.Position;
import symreader.Sequence;
import symreader.Song;
import symreader.SongEvent;
import symreader.SongPattern;
import symreader.SymphSongEvent;
import symreader.SymphonieInstrument;

public class ImportSongSymphonie {
    private DefaultListModel DebugListModel;
    private DefaultListModel InstrumentNamesModel;
    private DefaultListModel PositionsListModel;
    private Song mySong;
    private byte[] TempPatternData;
    float BPMScaleFactor = 0.92958f;
    private int ActualSampleIndex = 0;
    private SymphSongEvent tempEvent = new SymphSongEvent();

    public void initImport(DefaultListModel ListModel, DefaultListModel InstrList, DefaultListModel myPositionsListModel, Song SymSong) {
        this.DebugListModel = ListModel;
        this.InstrumentNamesModel = InstrList;
        this.PositionsListModel = myPositionsListModel;
        this.mySong = SymSong;
    }

    private void addInstrumentList(String s) {
        this.InstrumentNamesModel.addElement(s);
    }

    private void addPositionList(String s) {
        this.PositionsListModel.addElement(s);
    }

    private void PrintInfo(String s) {
        this.DebugListModel.addElement(s);
    }

    private void PrintToInfoWindow(String s) {
        this.PrintInfo(s);
    }

    private void PrintToInfoWindow(String s, int i) {
        s = s + i;
        this.PrintToInfoWindow(s);
    }

    private void PrintToInfoWindow(String s, int i, String s2) {
        s = s + i + " " + s2;
        this.PrintToInfoWindow(s);
    }

    private void PrintByteBlockAsString(byte[] SrcByteBlock, int Len) {
        String s = "";
        int i = 0;
        int counter = 0;
        for (i = 0; i < Len; ++i) {
            boolean CR = false;
            char c = (char)SrcByteBlock[i];
            if (SrcByteBlock[i] == 13) {
                CR = true;
            }
            if (SrcByteBlock[i] == 10) {
                CR = true;
            }
            if (SrcByteBlock[i] > 31) {
                s = s + c;
            }
            if (++counter <= 256 && !CR) continue;
            counter = 0;
            this.PrintToInfoWindow("        " + s);
            s = "";
        }
        this.PrintToInfoWindow(s);
    }

    private String ReadID(FileInputStream fi) {
        String s = "";
        int databyte = 0;
        try {
            databyte = fi.read();
            s = s + (char)databyte;
            databyte = fi.read();
            s = s + (char)databyte;
            databyte = fi.read();
            s = s + (char)databyte;
            databyte = fi.read();
            s = s + (char)databyte;
        }
        catch (IOException e) {
            this.PrintInfo("ReadID():Error while reading file.");
        }
        return s;
    }

    private long ReadLong(FileInputStream fi) {
        int databyte = 0;
        int Value = 0;
        try {
            databyte = fi.read();
            Value = databyte &= 0xFF;
            databyte = fi.read();
            Value = 256 * Value + (databyte &= 0xFF);
            databyte = fi.read();
            Value = 256 * Value + (databyte &= 0xFF);
            databyte = fi.read();
            Value = 256 * Value + (databyte &= 0xFF);
        }
        catch (IOException e) {
            this.PrintInfo("ReadLong():Error while reading file.");
        }
        return Value;
    }

    private int ReadInt(FileInputStream fi) {
        int databyte = 0;
        int bigint = 0;
        try {
            databyte = fi.read();
            databyte = fi.read();
            databyte = fi.read();
            databyte = fi.read();
            bigint = databyte < 128 ? databyte : databyte - 256;
        }
        catch (IOException e) {
            this.PrintInfo("ReadInt():Error while reading file.");
            bigint = 10000;
        }
        return bigint;
    }

    private int ReadMemoryByteToInt(byte[] SrcByteBlock, int Offset) {
        int tempint = SrcByteBlock[Offset];
        return tempint &= 0xFF;
    }

    private int ReadMemoryShortToInt(byte[] SrcByteBlock, int Offset) {
        int a = SrcByteBlock[Offset];
        int b = SrcByteBlock[Offset + 1];
        return (a &= 0xFF) * 256 + (b &= 0xFF);
    }

    private int ReadMemoryShortToSignedInt(byte[] SrcByteBlock, int Offset) {
        int a = SrcByteBlock[Offset];
        a &= 0xFF;
        int b = SrcByteBlock[Offset + 1];
        if ((a = a * 256 + (b &= 0xFF)) >= 32768) {
            a = -(65536 - a);
        }
        return a;
    }

    private long ReadMemoryLong(byte[] SrcByteBlock, int Offset) {
        long templong2 = 0L;
        long templong = 0L;
        byte tempbyte = 0;
        tempbyte = SrcByteBlock[Offset];
        templong2 = tempbyte;
        templong *= 256L;
        templong |= (templong2 &= 0xFFL);
        tempbyte = SrcByteBlock[++Offset];
        templong2 = tempbyte;
        templong *= 256L;
        templong |= (templong2 &= 0xFFL);
        tempbyte = SrcByteBlock[++Offset];
        templong2 = tempbyte;
        templong *= 256L;
        templong |= (templong2 &= 0xFFL);
        tempbyte = SrcByteBlock[++Offset];
        ++Offset;
        templong2 = tempbyte;
        templong *= 256L;
        return templong |= (templong2 &= 0xFFL);
    }

    private String ConvertByteBlockToString(byte[] SrcByteBlock, int Len) {
        String s = "";
        int i = 0;
        int counter = 0;
        for (i = 0; i < Len; ++i) {
            char c = (char)SrcByteBlock[i];
            s = s + c;
            if (++counter <= 40) continue;
            counter = 0;
            c = '\r';
            s = s + c;
        }
        return s;
    }

    private int ConvertByteToInt(byte tempbyte) {
        int newint = tempbyte;
        if (newint < 0) {
            newint = 256 + newint;
        }
        return newint;
    }

    private void LoadPattern(byte[] Src, int Len) {
        int SrcEventLen = 4;
        int PatternSize = this.mySong.getNumbOfRows() * this.mySong.getNumbOfVoices() * SrcEventLen;
        int NewNumbOfPatterns = Len / PatternSize;
        this.PrintToInfoWindow("Loading Pattern. Total Length:", Len);
        if (Len > 0) {
            if (NewNumbOfPatterns > 0) {
                this.mySong.allocNumbOfPatterns(NewNumbOfPatterns);
            }
            this.ImportSymphoniePatterns(Src, Len);
            this.PrintToInfoWindow("Pattern Import Done.");
        }
    }

    void BuildSongEvent(byte[] Src, int PatternIndex, int VoiceIndex, int LineNr, SongEvent se) {
        int w = this.mySong.getNumbOfVoices();
        int h = this.mySong.getNumbOfRows();
        int SrcEventLen = 4;
        int PatternSize = w * h * SrcEventLen;
        int BasePtr = PatternSize * PatternIndex + LineNr * w * SrcEventLen + VoiceIndex * SrcEventLen;
        this.ConvertEvent(se, Src[BasePtr + 0], Src[BasePtr + 3], Src[BasePtr + 1], Src[BasePtr + 2]);
    }

    void ConvertInstrNr(SongEvent se) {
        int temp = (int)se.A;
    }

    void ConvertEvent(SongEvent se, int FXType, int ParaA, int ParaB, int ParaC) {
        se.D = 0.0f;
        se.SongFXType = 0;
        if ((FXType &= 0xFF) == 0 && (ParaB &= 0xFF) == 255 && (ParaA &= 0xFF) == 0 && (ParaC &= 0xFF) == 0) {
            se.SongFXType = 0;
            se.A = 0.0f;
            se.B = 0.0f;
            se.C = 0.0f;
        } else {
            se.A = ParaA;
            se.B = ParaB;
            se.C = ParaC;
            switch (FXType) {
                case 0: {
                    if (ParaC > 200) {
                        switch (ParaC) {
                            case 251: {
                                se.SongFXType = 2;
                                break;
                            }
                            case 252: {
                                se.SongFXType = 1009;
                                break;
                            }
                            case 253: {
                                se.SongFXType = 1008;
                                break;
                            }
                            case 254: {
                                se.SongFXType = 1007;
                                break;
                            }
                            case 250: {
                                se.SongFXType = 4001;
                                break;
                            }
                            case 249: {
                                se.SongFXType = 4002;
                                break;
                            }
                            case 246: {
                                se.SongFXType = 2008;
                                break;
                            }
                            case 244: {
                                se.SongFXType = 2010;
                                break;
                            }
                            case 242: {
                                se.SongFXType = 2012;
                                break;
                            }
                            case 247: {
                                se.SongFXType = 2007;
                                break;
                            }
                            case 245: {
                                se.SongFXType = 2009;
                                break;
                            }
                            case 243: {
                                se.SongFXType = 2011;
                                break;
                            }
                            case 248: {
                                se.SongFXType = 2000;
                                this.ConvertInstrNr(se);
                            }
                        }
                        break;
                    }
                    if (se.B == 255.0f) {
                        se.SongFXType = 1000;
                        se.B = 0.0f;
                        break;
                    }
                    se.SongFXType = 1;
                    this.ConvertInstrNr(se);
                    break;
                }
                case 11: {
                    se.SongFXType = 1003;
                    break;
                }
                case 19: {
                    se.SongFXType = 1005;
                    break;
                }
                case 20: {
                    se.SongFXType = 1006;
                    break;
                }
                case 12: {
                    se.SongFXType = 1004;
                    break;
                }
                case 2: {
                    se.SongFXType = 1002;
                    se.A = 0.0f;
                    se.B = 0.0f;
                    se.D = se.C;
                    se.C = 0.0f;
                    break;
                }
                case 1: {
                    se.SongFXType = 1001;
                    se.A = 0.0f;
                    se.B = 0.0f;
                    se.D = se.C;
                    se.C = 0.0f;
                    break;
                }
                case 10: {
                    se.D = se.C;
                    se.C = 0.0f;
                    se.SongFXType = 2004;
                    break;
                }
                case 18: {
                    se.D = se.C;
                    se.C = 0.0f;
                    se.SongFXType = 2006;
                    break;
                }
                case 4: {
                    se.D = se.C;
                    se.C = 0.0f;
                    se.SongFXType = 2003;
                    break;
                }
                case 3: {
                    se.D = se.C;
                    se.C = 0.0f;
                    se.SongFXType = 2002;
                    break;
                }
                case 15: {
                    se.D = se.C;
                    se.C = 0.0f;
                    se.SongFXType = 2001;
                    break;
                }
                case 13: {
                    se.SongFXType = 2005;
                    break;
                }
                case 26: {
                    se.SongFXType = 5005;
                    break;
                }
                case 25: {
                    se.SongFXType = 5003;
                    break;
                }
                case 24: {
                    float tempf;
                    int temp;
                    se.D = se.C;
                    se.C = 0.0f;
                    if (se.B == 0.0f) {
                        se.SongFXType = 5001;
                        se.A = 0.0f;
                        se.B = 0.0f;
                        se.C = 0.0f;
                        se.D = 0.0f;
                    }
                    if (se.B == 1.0f) {
                        se.SongFXType = 5001;
                        temp = 1 << (int)se.A;
                        tempf = temp;
                        se.C = 100.0f / tempf;
                    }
                    if (se.B == 2.0f) {
                        se.SongFXType = 5002;
                        temp = 1 << (int)se.A;
                        tempf = temp;
                        se.C = 100 / temp;
                    }
                    if (se.B == 3.0f) {
                        se.SongFXType = 5002;
                        temp = 1 << (int)se.A;
                        tempf = temp;
                        se.C = 100 - 100 / temp;
                    }
                    se.A = 0.0f;
                    se.B = 0.0f;
                    break;
                }
                case 17: {
                    se.SongFXType = 4;
                    break;
                }
                case 23: {
                    se.SongFXType = 5000;
                    break;
                }
                case 9: {
                    se.D = se.C;
                    se.C = 0.0f;
                    se.SongFXType = 4000;
                    break;
                }
                case 8: {
                    se.D = se.C;
                    se.C = 0.0f;
                    se.SongFXType = 3004;
                    break;
                }
                case 6: {
                    se.D = se.C;
                    se.C = 0.0f;
                    se.SongFXType = 3001;
                    this.ConvertInstrNr(se);
                    break;
                }
                case 5: {
                    se.D = se.C;
                    se.C = 0.0f;
                    se.SongFXType = 3000;
                    break;
                }
                case 16: {
                    se.D = se.C;
                    se.C = 0.0f;
                    se.SongFXType = 3;
                    break;
                }
                case 14: {
                    se.D = se.C;
                    se.C = 0.0f;
                    se.SongFXType = 3005;
                    break;
                }
                case 7: {
                    se.D = se.C;
                    se.C = 0.0f;
                    se.SongFXType = 3003;
                }
            }
        }
        se.UpdateEventClass();
    }

    void ImportSymphoniePatterns(byte[] Src, int Len) {
        SongEvent se = new SongEvent();
        for (int PatternIndex = 0; PatternIndex < this.mySong.getNumbOfPatterns(); ++PatternIndex) {
            SongPattern myPat = this.mySong.getPattern(PatternIndex);
            myPat.init(this.mySong.getNumbOfVoices());
            for (int VoiceIndex = 0; VoiceIndex < this.mySong.getNumbOfVoices(); ++VoiceIndex) {
                for (int LineNr = 0; LineNr < this.mySong.getNumbOfRows(); ++LineNr) {
                    float TimePosition = LineNr;
                    this.BuildSongEvent(Src, PatternIndex, VoiceIndex, LineNr, se);
                    myPat.addSongEvent(VoiceIndex, TimePosition, se);
                }
            }
        }
    }

    private String GetElementName(int ElementId) {
        String s = "Unknown Element ID";
        switch (ElementId) {
            case -1: {
                s = "Number of Audiochannels";
                break;
            }
            case -2: {
                s = "Tracklength";
                break;
            }
            case -3: {
                s = "Total Patternlength in Events";
                break;
            }
            case -4: {
                s = "Number of Instruments";
                break;
            }
            case -5: {
                s = "Length of one Songevent in bytes";
                break;
            }
            case -6: {
                s = "System BPM";
                break;
            }
            case -7: {
                s = "Is a pure Song without Samples included (Flag)";
                break;
            }
            case -10: {
                s = "Songdata";
                break;
            }
            case -11: {
                s = "Sample (Binary)";
                break;
            }
            case -12: {
                s = "";
                break;
            }
            case -13: {
                s = "Notedata (Songevents)";
                break;
            }
            case -14: {
                s = "Samplenames (Instrumentdefinitions)";
                break;
            }
            case -15: {
                s = "Sequence";
                break;
            }
            case -16: {
                s = "Infotext";
                break;
            }
            case -17: {
                s = "Sample (Binary Deltapacked)";
                break;
            }
            case -18: {
                s = "Sample (Binary Deltapacked as 16 Bit)";
                break;
            }
            case -19: {
                s = "Infotype";
                break;
            }
            case -20: {
                s = "Infoobject (Binary)";
                break;
            }
            case -21: {
                s = "Infostring";
                break;
            }
            case 10: {
                s = "NG Sampleboost activated (Global Samplevolume)";
                break;
            }
            case 11: {
                s = "Stereo Enhancer, Pitchdiff";
                break;
            }
            case 12: {
                s = "Stereo Enhancer, Samplediff";
            }
        }
        return s;
    }

    private boolean isElementWithSingleParameter(int ElementId) {
        boolean b = false;
        if (ElementId <= -1 && ElementId >= -7) {
            b = true;
        }
        if (ElementId <= 12 && ElementId >= 10) {
            b = true;
        }
        return b;
    }

    private void MoveNextNonVirtualSample() {
        boolean done = false;
        do {
            ++this.ActualSampleIndex;
            if (this.ActualSampleIndex >= this.mySong.getNumbOfInstruments()) {
                done = true;
                continue;
            }
            SymphonieInstrument si = this.mySong.getInstrumentExisting(this.ActualSampleIndex);
            if (si == null || si.MultiChannel >= 2) continue;
            done = true;
        } while (!done);
    }

    private void LoadInstrumentNamesBlock(byte[] SrcByteBlock, long Len) {
        int SrcOffset = 0;
        int ActualInstrNr = 0;
        int NumbOfInstruments = (int)Len / 256;
        assert (NumbOfInstruments != 0);
        this.mySong.allocNumbInstruments(NumbOfInstruments);
        for (int i = 0; i < NumbOfInstruments; ++i) {
            String s = "";
            char c = (char)SrcByteBlock[SrcOffset];
            int j = 0;
            while (c != '\u0000') {
                s = s.concat(String.valueOf(c));
                c = (char)SrcByteBlock[SrcOffset + ++j];
                if (j <= 127) continue;
                c = '\u0000';
            }
            if (s.equals("ViRT")) {
                s = "* Virtual Instrument *";
                this.addInstrumentList(s);
                this.LoadInstrumentDefBlock(SrcByteBlock, i, SrcOffset, ActualInstrNr, s, true);
                ++ActualInstrNr;
            } else if (!s.isEmpty()) {
                this.addInstrumentList(s);
                this.LoadInstrumentDefBlock(SrcByteBlock, i, SrcOffset, ActualInstrNr, s, false);
                ++ActualInstrNr;
            }
            SrcOffset += 256;
        }
    }

    private void LoadInstrumentDefBlock(byte[] SrcByteBlock, int OrigInstrNr, int SrcOffset, int InstrNr, String s, boolean isVirtual) {
        SymphonieInstrument si = this.mySong.getInstrumentIndex(InstrNr);
        si.Name = s;
        si.VirtualSample = isVirtual;
        si.ID = OrigInstrNr;
        this.mySong.setIDOfInstrIndex(si.ID, InstrNr);
        si.Type = this.ConvertByteToInt(SrcByteBlock[SrcOffset + 128]);
        si.MultiChannel = this.ConvertByteToInt(SrcByteBlock[SrcOffset + 132]);
        si.Volume = this.ConvertByteToInt(SrcByteBlock[SrcOffset + 134]);
        if (si.Volume == 0) {
            si.Volume = 100;
        }
        if (si.Volume > 100) {
            si.Volume = 100;
        }
        si.Tune = SrcByteBlock[SrcOffset + 139];
        if (SrcByteBlock[SrcOffset + 143] != 0) {
            if (SrcByteBlock[SrcOffset + 143] == 1) {
                si.Tune -= 12;
            }
            if (SrcByteBlock[SrcOffset + 143] == 2) {
                si.Tune -= 24;
            }
            if (SrcByteBlock[SrcOffset + 143] == 3) {
                si.Tune -= 36;
            }
            if (SrcByteBlock[SrcOffset + 143] == 4) {
                si.Tune -= 48;
            }
        }
        si.FineTune = SrcByteBlock[SrcOffset + 138];
        si.setLoopStart(this.ConvertByteToInt(SrcByteBlock[SrcOffset + 129]) * 256 * 256);
        si.setLoopLen(this.ConvertByteToInt(SrcByteBlock[SrcOffset + 130]) * 256 * 256);
        si.setNumbOfLoops(this.ConvertByteToInt(SrcByteBlock[SrcOffset + 131]));
        boolean bl = si.NewLoopSystem = (si.LineSampleFlags & 0x10) != 0;
        if (si.NewLoopSystem) {
            si.setLoopStart(this.ConvertByteToInt(SrcByteBlock[SrcOffset + 129]) * 256 * 256 + this.ConvertByteToInt(SrcByteBlock[SrcOffset + 150]) * 256 + this.ConvertByteToInt(SrcByteBlock[SrcOffset + 151]));
            si.setLoopLen(this.ConvertByteToInt(SrcByteBlock[SrcOffset + 130]) * 256 * 256 + this.ConvertByteToInt(SrcByteBlock[SrcOffset + 152]) * 256 + this.ConvertByteToInt(SrcByteBlock[SrcOffset + 153]));
        }
        if (si.Type == 0) {
            si.deactivateLoop();
        }
        if (si.Type == 4) {
            si.setHasLoop(true);
        }
        si.PlayFlag = this.ConvertByteToInt(SrcByteBlock[SrcOffset + 142]) & 0xFF;
        si.AllowPosDetune = (si.PlayFlag & 1) == 0;
        si.NoDsp = (si.PlayFlag & 2) != 0;
        si.PlaySynced = (si.PlayFlag & 4) != 0;
        si.LineSampleFlags = this.ConvertByteToInt(SrcByteBlock[SrcOffset + 140]) & 0xFF;
        si.PlayReverse = (si.LineSampleFlags & 1) != 0;
        si.AsQueue = (si.LineSampleFlags & 2) != 0;
        si.MirrorX = (si.LineSampleFlags & 4) != 0;
        si.SampleResolution = (si.LineSampleFlags & 8) != 0 ? 16 : 8;
        si.NewLoopSystem = (si.LineSampleFlags & 0x10) != 0;
        si.isInUse = true;
    }

    private void LoadInstrumentSample(byte[] src, long len) {
        int i = this.ActualSampleIndex;
        this.BuildInstrumentSamples(this.mySong.getInstrumentIndex(i), src, (int)len);
        this.mySong.getInstrumentIndex((int)i).SampleDataLoaded = true;
    }

    private void BuildInstrumentSamples(SymphonieInstrument si, byte[] src, int len) {
        si.ImportSample.Analyse(src, len);
        si.sp = si.ImportSample.SamplePools[0];
        int LoopStart = si.getLoopStart();
        int LoopLen = si.getLoopLen();
        si.sp.initLoopDateSymphonieFormat(si, si.hasLoop(), si.getLoopStart(), si.getLoopLen(), si.getNumbOfLoops());
        if (si.MultiChannel == 1 && si.ImportSample.getNumbOfChannels() == 2) {
            SymphonieInstrument siRight = this.mySong.getInstrumentIndex(this.ActualSampleIndex + 1);
            siRight.sp = si.ImportSample.SamplePools[1];
            siRight.sp.initLoopDateSymphonieFormat(si, si.hasLoop(), LoopStart, LoopLen, si.getNumbOfLoops());
            siRight.SampleDataLoaded = true;
            siRight.isInUse = true;
            siRight.MultiChannel = 2;
            siRight.Name = si.Name;
        }
    }

    private void DecodeSampleDeltapacked(byte[] Src, int Len) {
        int i;
        int Index = 0;
        long ActByte = Src[Index];
        ActByte &= 0xFFL;
        for (i = 1; i < Len; ++i) {
            byte tempByte;
            long AddByte = Src[Index + 1];
            ActByte += AddByte;
            if ((ActByte &= 0xFFL) > 255L) {
                ActByte -= 256L;
            }
            Src[Index + 1] = tempByte = (byte)ActByte;
            ++Index;
        }
        i = 1;
    }

    private void DecodeSampleDeltapacked(byte[] Src, int Len, int StartOffset) {
        int i;
        int Index = StartOffset;
        long ActByte = Src[Index];
        ActByte &= 0xFFL;
        for (i = 1; i < Len; ++i) {
            byte tempByte;
            long AddByte = Src[Index + 1];
            ActByte += AddByte;
            if ((ActByte &= 0xFFL) > 255L) {
                ActByte -= 256L;
            }
            Src[Index + 1] = tempByte = (byte)ActByte;
            ++Index;
        }
        i = 1;
    }

    private void DecodeSampleDeltapacked16(byte[] Src, int Len) {
        int TempSrcOffset = 0;
        int SrcOffsetMSB = 0;
        int SrcOffsetLSB = 0;
        int DestIndex = 0;
        int BlockSize = 4096;
        byte[] DestTempBlock = new byte[BlockSize];
        if (Len > BlockSize) {
            int NumbOfBlocks = Len / BlockSize;
            SrcOffsetMSB = BlockSize / 2;
            SrcOffsetLSB = 0;
            for (int j = 0; j < NumbOfBlocks; ++j) {
                int i;
                DestIndex = 0;
                TempSrcOffset = SrcOffsetLSB;
                this.DecodeSampleDeltapacked(Src, BlockSize, SrcOffsetLSB);
                for (i = 0; i < BlockSize / 2; ++i) {
                    byte tempbyte = Src[SrcOffsetMSB++];
                    DestTempBlock[DestIndex++] = tempbyte;
                    DestTempBlock[DestIndex++] = Src[SrcOffsetLSB++];
                }
                DestIndex = 0;
                for (i = 0; i < BlockSize; ++i) {
                    Src[TempSrcOffset++] = DestTempBlock[DestIndex++];
                }
                SrcOffsetMSB = TempSrcOffset + BlockSize / 2;
                SrcOffsetLSB = TempSrcOffset;
            }
        }
    }

    private boolean CheckIsRLEPacked(byte[] SrcByteBlock, byte[] DestByteBlock, long Len) {
        boolean isRLEPacked = true;
        if (SrcByteBlock[0] != 80) {
            isRLEPacked = false;
        }
        if (SrcByteBlock[1] != 65) {
            isRLEPacked = false;
        }
        if (SrcByteBlock[2] != 67) {
            isRLEPacked = false;
        }
        if (SrcByteBlock[3] != 75) {
            isRLEPacked = false;
        }
        if (SrcByteBlock[4] != -1) {
            isRLEPacked = false;
        }
        if (SrcByteBlock[5] != -1) {
            isRLEPacked = false;
        }
        if (Len <= 16L) {
            isRLEPacked = false;
        }
        return isRLEPacked;
    }

    private void DecodeByteBlockRLE(byte[] SrcByteBlock, byte[] DestByteBlock, long Len, int DataBlockID) {
        boolean done = false;
        int SrcOffset = 0;
        int DestOffset = 0;
        long UnpackedLen = Len;
        if (this.CheckIsRLEPacked(SrcByteBlock, DestByteBlock, Len) && (UnpackedLen = this.ReadMemoryLong(SrcByteBlock, 6)) != 0L) {
            int i;
            DestByteBlock = new byte[(int)UnpackedLen];
            SrcOffset = 10;
            while (!done) {
                byte packtype = SrcByteBlock[SrcOffset];
                ++SrcOffset;
                switch (packtype) {
                    case 0: {
                        int blocklen = this.ConvertByteToInt(SrcByteBlock[SrcOffset]);
                        ++SrcOffset;
                        for (i = 0; i < blocklen; ++i) {
                            DestByteBlock[DestOffset] = SrcByteBlock[SrcOffset];
                            ++DestOffset;
                            ++SrcOffset;
                        }
                        break;
                    }
                    case 3: {
                        int blocklen = this.ConvertByteToInt(SrcByteBlock[SrcOffset]);
                        ++SrcOffset;
                        for (i = 0; i < blocklen; ++i) {
                            DestByteBlock[DestOffset] = 0;
                            ++DestOffset;
                        }
                        break;
                    }
                    case 2: {
                        DestByteBlock[DestOffset] = SrcByteBlock[SrcOffset];
                        DestByteBlock[DestOffset + 1] = SrcByteBlock[SrcOffset + 1];
                        DestByteBlock[DestOffset + 2] = SrcByteBlock[SrcOffset + 2];
                        DestByteBlock[DestOffset + 3] = SrcByteBlock[SrcOffset + 3];
                        DestByteBlock[DestOffset += 4] = SrcByteBlock[SrcOffset];
                        DestByteBlock[DestOffset + 1] = SrcByteBlock[SrcOffset + 1];
                        DestByteBlock[DestOffset + 2] = SrcByteBlock[SrcOffset + 2];
                        DestByteBlock[DestOffset + 3] = SrcByteBlock[SrcOffset + 3];
                        DestOffset += 4;
                        SrcOffset += 4;
                        break;
                    }
                    case 1: {
                        int blocklen = this.ConvertByteToInt(SrcByteBlock[SrcOffset]);
                        ++SrcOffset;
                        for (i = 0; i < blocklen; ++i) {
                            DestByteBlock[DestOffset] = SrcByteBlock[SrcOffset];
                            DestByteBlock[DestOffset + 1] = SrcByteBlock[SrcOffset + 1];
                            DestByteBlock[DestOffset + 2] = SrcByteBlock[SrcOffset + 2];
                            DestByteBlock[DestOffset + 3] = SrcByteBlock[SrcOffset + 3];
                            DestOffset += 4;
                        }
                        SrcOffset += 4;
                        break;
                    }
                    case -1: {
                        done = true;
                    }
                }
                if ((long)SrcOffset >= Len) {
                    done = true;
                }
                if (packtype > 3) {
                    done = true;
                }
                if (packtype >= -1) continue;
                done = true;
            }
            SrcByteBlock = new byte[(int)UnpackedLen];
            i = 0;
            while ((long)i < UnpackedLen) {
                SrcByteBlock[i] = DestByteBlock[i];
                ++i;
            }
            this.PrintToInfoWindow("      RLE packed.  Unpacked Blocksize in Byte:", (int)UnpackedLen);
        }
        this.LoadDataBlock(SrcByteBlock, UnpackedLen, DataBlockID);
    }

    void CopyByteBlock(byte[] src, byte[] dest, int len) {
        for (int i = 0; i < len; ++i) {
            dest[i] = src[i];
        }
    }

    void CopyByteBlock(byte[] src, byte[] dest, long len) {
        for (int i = 0; i < (int)len; ++i) {
            dest[i] = src[i];
        }
    }

    private void LoadDataBlock(byte[] SrcByteBlock, long Len, int DataBlockID) {
        if (Len > 0L) {
            switch (DataBlockID) {
                case -14: {
                    this.LoadInstrumentNamesBlock(SrcByteBlock, Len);
                    break;
                }
                case -11: {
                    this.LoadInstrumentSample(SrcByteBlock, Len);
                    this.MoveNextNonVirtualSample();
                    break;
                }
                case -13: {
                    this.TempPatternData = new byte[(int)Len];
                    this.CopyByteBlock(SrcByteBlock, this.TempPatternData, (int)Len);
                    break;
                }
                case -17: {
                    this.DecodeSampleDeltapacked(SrcByteBlock, (int)Len);
                    this.LoadInstrumentSample(SrcByteBlock, Len);
                    this.MoveNextNonVirtualSample();
                    break;
                }
                case -18: {
                    this.DecodeSampleDeltapacked16(SrcByteBlock, (int)Len);
                    this.LoadInstrumentSample(SrcByteBlock, Len);
                    this.MoveNextNonVirtualSample();
                    break;
                }
                case -15: {
                    this.ImportSongSeq(SrcByteBlock, (int)Len);
                    break;
                }
                case -10: {
                    this.ImportSongPositions(SrcByteBlock, (int)Len);
                }
            }
        }
    }

    void ImportSongSeq(byte[] src, long Len) {
        int NumbOfElements = (int)Len / 16;
        this.mySong.allocNumbOfSequences(NumbOfElements);
        if (Len > 0L && src != null && NumbOfElements > 0) {
            if (NumbOfElements > this.mySong.getNumbOfSequences()) {
                NumbOfElements = this.mySong.getNumbOfSequences();
            }
            for (int i = 0; i < NumbOfElements; ++i) {
                int of = 16 * i;
                Sequence Seq = this.mySong.getSequence(i);
                Seq.StartPosition = this.ReadMemoryShortToInt(src, of + 0);
                Seq.EndPosition = this.ReadMemoryShortToInt(src, of + 2);
                Seq.EndPosition -= Seq.StartPosition;
                Seq.Action = this.ReadMemoryShortToInt(src, of + 6);
                Seq.Tune = this.ReadMemoryShortToSignedInt(src, of + 8);
                Seq.NumbOfLoops = this.ReadMemoryShortToInt(src, of + 4);
            }
        } else {
            this.PrintInfo("Error:Importing Sequence.");
        }
    }

    void ImportSongPositions(byte[] src, long Len) {
        int NumbOfElements = (int)Len / 32;
        this.mySong.allocNumbOfPositions(NumbOfElements);
        if (Len > 0L && src != null && NumbOfElements > 0) {
            this.PrintInfo("Number of Positions:" + NumbOfElements);
            if (NumbOfElements > this.mySong.getNumbOfPositions()) {
                NumbOfElements = this.mySong.getNumbOfPositions();
            }
            for (int i = 0; i < NumbOfElements; ++i) {
                int of = 32 * i;
                Position Pos = this.mySong.getPosition(i);
                Pos.setNumbOfLayers(1);
                Pos.PatternNumbers[0] = this.ReadMemoryShortToInt(src, of + 8);
                Pos.Tune = this.ReadMemoryShortToSignedInt(src, of + 16);
                Pos.StartRow = this.ReadMemoryShortToInt(src, of + 10);
                Pos.RowLength = this.ReadMemoryShortToInt(src, of + 12);
                Pos.NumbOfLoops = this.ReadMemoryShortToInt(src, of + 4);
                Pos.Speed_Cycl = this.ReadMemoryShortToInt(src, of + 14);
                this.addPositionList("" + i + ". Pat:" + Pos.PatternNumbers[0] + " Spd:" + Pos.Speed_Cycl + " Loops:" + Pos.NumbOfLoops + " LineNr:" + Pos.StartRow + " Len:" + Pos.RowLength + " Tune:" + Pos.Tune);
            }
        } else {
            this.PrintInfo("Error:Importing Positions.");
        }
    }

    private void LoadDataValue(int DataBlockID, int Value) {
        switch (DataBlockID) {
            case -2: {
                this.mySong.setNumbOfRows(Value);
                break;
            }
            case -1: {
                this.mySong.setNumbOfVoices(Value);
                break;
            }
            case -6: {
                float OriginalBPM = (float)Value * 1000.0f;
                int tempbpm = (int)(OriginalBPM *= this.BPMScaleFactor);
                OriginalBPM = tempbpm;
                this.mySong.setBPM(OriginalBPM / 1000.0f);
            }
        }
    }

    public void runImport(File f) {
        String s = "";
        long l = 0L;
        int DataBlockID = 0;
        boolean done = false;
        long MaxElements = 1000L;
        long ElementCounter = 0L;
        long FileLength = 0L;
        long ReadLength = 0L;
        byte[] DestByteBlock = new byte[]{};
        this.ActualSampleIndex = 0;
        this.PrintInfo("Loading SymMod...");
        this.PrintInfo(f.getPath());
        try {
            FileInputStream fi = new FileInputStream(f);
            s = this.ReadID(fi);
            this.PrintInfo(s);
            if (s.equals("SymM")) {
                this.PrintInfo(">> Symphonie Modul Header ID detected.");
            } else {
                done = true;
                this.PrintInfo(">> Aborted. No Symphonie Modul Header detected.");
                if (s.equals("XPKF")) {
                    this.PrintInfo(">> Possibly XPK packed File. Unpack this file and try again.");
                }
            }
            l = this.ReadLong(fi);
            this.PrintToInfoWindow(">> Format Version:", (int)l);
            FileLength = f.length();
            this.PrintToInfoWindow(">> Filelength in Byte:", (int)FileLength);
            ReadLength += 8L;
            while (!done) {
                if (++ElementCounter >= MaxElements) {
                    done = true;
                    this.PrintInfo(">> Aborted Reading: Possibly no Symphonie Module Format.");
                }
                DataBlockID = this.ReadInt(fi);
                ReadLength += 4L;
                String sDataBlockID = this.GetElementName(DataBlockID);
                if (sDataBlockID != "") {
                    this.PrintToInfoWindow(">> Element ID:", DataBlockID, sDataBlockID);
                }
                if (DataBlockID != -12) {
                    if (this.isElementWithSingleParameter(DataBlockID)) {
                        l = this.ReadLong(fi);
                        if (DataBlockID == -4 || DataBlockID == -5) {
                            l &= 0xFFFFL;
                        }
                        this.LoadDataValue(DataBlockID, (int)l);
                        this.PrintToInfoWindow("Size:" + l);
                        ReadLength += 4L;
                    } else {
                        l = this.ReadLong(fi);
                        ReadLength += 4L;
                        this.PrintToInfoWindow("      Binary Datalength in Byte:", (int)l);
                        try {
                            byte[] SrcByteBlock = new byte[(int)l];
                            int numberread = fi.read(SrcByteBlock, 0, (int)l);
                            this.DecodeByteBlockRLE(SrcByteBlock, DestByteBlock, l, DataBlockID);
                            if (DataBlockID == -16) {
                                this.PrintByteBlockAsString(SrcByteBlock, (int)l);
                            }
                            ReadLength += l;
                        }
                        catch (IOException e) {
                            this.PrintInfo("ERROR:While reading datablock.");
                        }
                    }
                }
                if (ReadLength < FileLength) continue;
                done = true;
                this.PrintInfo(">> Finished. End of File reached.");
            }
        }
        catch (FileNotFoundException e) {
            this.PrintInfo("Error:File not Found.");
        }
        if (this.TempPatternData != null) {
            this.LoadPattern(this.TempPatternData, this.TempPatternData.length);
        }
    }
}

