/////////////////////////////////////////////////////////////////////
//  SimplePlayer.cpp
/////////////////////////////////////////////////////////////////////
//
//  Description: Simple example which plays a song
//
//  This file is part of the SkalePlayer library.
//
//  This library is freeware only for non-commercial projects. For 
//  commercial uses of this library you must to get my permision,
//  contact me at baktery@skale.org
//
//  Use it at your own risk.
//
//  Ruben Ramos Salvador aka Baktery/Chanka
//  email: baktery@skale.org
//  http://www.skale.org
//
/////////////////////////////////////////////////////////////////////

// Includes
#include <windows.h>
#include <stdio.h>

// SkalePlayer Includes
#include "SkalePlayer.h"

// FileName
char g_szSongFileName[1024] = { 0 };

// Title
const char TITLE[] = "SkalePlayer SimplePlayer Example";


////////////////////////////////////////////////
// GetFileName(): Gets the filename to play
////////////////////////////////////////////////
bool GetFileName(HINSTANCE hInstance)
{
  bool bOK = true;

  OPENFILENAME OpenFileName;
  memset(&OpenFileName,0,sizeof(OpenFileName));
  OpenFileName.lStructSize = sizeof(OpenFileName);
  OpenFileName.hInstance = hInstance; 
  OpenFileName.lpstrFilter = "SkalePlayer Supported Formats(*.MOD *.XM *.SKM)\0*.mod;*.xm;*.skm\0All Files(*.*)\0*.*\0";
  OpenFileName.lpstrFile = g_szSongFileName; 
  OpenFileName.nMaxFile = sizeof(g_szSongFileName); 
  OpenFileName.lpstrTitle = TITLE; 
  OpenFileName.Flags = OFN_FILEMUSTEXIST; 

  bOK = GetOpenFileName(&OpenFileName) != 0;    

  return bOK;
}

//////////////////////////////////////////////////
// WaitUntilUserPressOK(): Shows a messagebox and wait until user press OK
////////////////////////////////////////////////
void WaitUntilUserPressOK()
{
  char szMessage[sizeof(g_szSongFileName)+1024];
  sprintf(szMessage,"Playing song(%s), press OK to exit",g_szSongFileName);
  MessageBox(NULL,szMessage,TITLE,MB_OK);
}


////////////////////////////////////////////////
// WinMain()
////////////////////////////////////////////////
int __stdcall WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow )
{
  if ( GetFileName(hInstance) )
  {
    // Init Skale Player
    ISkalePlayer* pSkalePlayer = ISkalePlayer::GetSkalePlayer();
    ISkalePlayer::EInitError Error = pSkalePlayer->Init(ISkalePlayer::TInitData());

    if ( Error == ISkalePlayer::INIT_OK )
    {
      // Load Song
      const ISkalePlayer::ISong* pSong = pSkalePlayer->LoadSongFromFile(g_szSongFileName);

      if ( pSong )
      {
        // Set loaded song as active
        pSkalePlayer->SetCurrentSong(pSong);

        // Play
        pSkalePlayer->SetPlayMode(ISkalePlayer::PLAY_MODE_PLAY_SONG_FROM_START);

        // Wait until the user press OK
        WaitUntilUserPressOK();
      }

      // Uninit SkalePlayer
      pSkalePlayer->End();
    }
  }

  return 0;
}

