//
// R_MUSIC.H
//

//#include "stdafx.h"

#ifndef RMT_R_MUSIC_
#define RMT_R_MUSIC_

#include <fstream.h>

#include "xpokey.h"


#define TRACKLEN	128
#define TRACKSNUM	254			//0-253
#define SONGLEN		256
#define SONGTRACKS	8
#define INSTRSNUM	64
#define NOTESNUM	61			//noty 0-60 vcetne

#define MAXVOLUME	15			//maximalni hlasitost

#define PARCOUNT	24			//24 parametru instrumentu
#define ENVCOLS		32			//32 sloupcu v envelope
#define ENVROWS		8			//8 radku (parametru) v envelope


#define INSTRNAMEMAXLEN	32		//maximalni delka nazvu nastroje
#define SONGNAMEMAXLEN	64		//maximalni delka nazvu songu
#define TRACKMAXSPEED	256		//maximalni rychlost 1 beatu

#define MAXATAINSTRLEN	16+(ENVCOLS*3)	//atari instrument ma maximalne 16 parametru + 32*3 bytu envelope
#define MAXATATRACKLEN	256		//atari track ma max. 256 bytu (index tracku je 0-255)
#define MAXATASONGLEN	SONGTRACKS*SONGLEN	//maximalni datova velikost atari song casti

#define PARTINFO	0
#define PARTTRACKS	1
#define PARTINSTRS	2
#define PARTSONG	3


#define IOTYPE_RMT			1
#define IOTYPE_RMW			2
#define IOTYPE_RMTSTRIPPED	3
#define IOTYPE_SAP			4
#define IOTYPE_XEX			5

#define IOINSTR_RTI			1
#define IOINSTR_RMW			2


//bity v TRACKFLAGU
#define TF_NOEMPTY		1
#define TF_USED			2

//bity v INSTRUMENTFLAGU
#define IF_NOEMPTY		1
#define IF_USED			2
#define IF_FILTER		4
#define IF_BASS16		8
#define IF_PORTAMENTO	16
#define IF_POLY9		32
#define IF_15KHZ		64

//-----------------------------------------------------

struct TTrack
{
	int len;
	int go;
	int note[TRACKLEN];
	int instr[TRACKLEN];
	int volume[TRACKLEN];
	int speed[TRACKLEN];
};



//-----------------------------------------------------


class CTracks
{
public:
	CTracks();
	BOOL InitTracks();
	BOOL ClearTrack(int t);
	BOOL IsEmptyTrack(int track);
	BOOL DrawTrack(int col,int x,int y,int tr,int aline,int pline,BOOL isactive,int acu=0);
	BOOL SetNoteInstrVol(int note,int instr,int vol,int track,int line);
	BOOL SetInstr(int instr,int track,int line);
	BOOL SetVol(int vol,int track,int line);
	BOOL SetSpeed(int speed,int track,int line);
	int GetNote(int track,int line)		{ return m_track[track].note[line]; };
	int GetInstr(int track, int line)	{ return m_track[track].instr[line]; };
	int GetVol(int track,int line)		{ return m_track[track].volume[line]; };
	int GetSpeed(int track,int line)	{ return m_track[track].speed[line]; };
	BOOL SetEnd(int track, int line);
	int GetLastLine(int track);
	BOOL SetGo(int track, int line);
	int GetGoLine(int track);

	BOOL InsertLine(int track, int line);
	BOOL DeleteLine(int track, int line);

	TTrack* GetTrack(int tr)	{ return &m_track[tr]; };

	int TrackToAta(int track,unsigned char* dest,int max);
	BOOL AtaToTrack(unsigned char* sour,int len,int track);

	int SaveAll(ofstream& ou);
	int LoadAll(ifstream& in);


	BOOL CalculateNoEmpty(int track);

	int m_maxtracklen;

private:
	TTrack m_track[TRACKSNUM];
};

//-----------------------------------------------------

struct TInstrument
{
	int act;
	char name[INSTRNAMEMAXLEN+1];
	int activenam;
	int par[PARCOUNT];						//[24]
	int activepar;
	int env[ENVCOLS][ENVROWS];				//[32][8]
	int activeenvx,activeenvy;
};

class CInstruments
{
public:
	CInstruments();
	BOOL InitInstruments();
	BOOL ClearInstrument(int it);
	BOOL DrawInstrument(int it);
	BOOL ModificationInstrument(int it);
	BOOL RecalculateFlag(int instr);

	BYTE GetFlag(int instr)	{ return m_iflag[instr]; };

	char *GetName(int it)	{ return m_instr[it].name; };

	int SaveAll(ofstream& ou);
	int LoadAll(ifstream& in);

	int SaveInstrument(int instr, ofstream& ou, int iotype);
	int LoadInstrument(int instr, ifstream& in, int iotype);

	BYTE InstrToAta(int instr,unsigned char *ata,int max);
	BOOL AtaToInstr(unsigned char *ata, int instr);

	BOOL CalculateNoEmpty(int instr);

	TInstrument m_instr[INSTRSNUM];
private:
	BOOL DrawName(int it);
	BOOL DrawPar(int p,int it);
	BOOL DrawEnv(int e,int it);

	BYTE m_iflag[INSTRSNUM];
};

//-----------------------------------------------------

class CSong
{
public:
	CSong();
	~CSong();
	BOOL ClearSong(int numoftracks);
	BOOL DrawSong();
	BOOL DrawTracks();
	BOOL DrawInstrument();
	BOOL DrawInfo();			//levy horni roh
	BOOL DrawAnalyzer(CDC *pDC);

	BOOL InfoKey(int vk,int shift,int control);

	BOOL InstrKey(int vk,int shift,int control);
	BOOL ActiveInstrSetByNum(int num);
	int GetActiveInstr()	{ return m_activeinstr; };

	BOOL ProveKey(int vk,int shift,int control);

	BOOL TrackKey(int vk,int shift,int control);
	BOOL TrackUp();
	BOOL TrackDown(BOOL stoponlastline=1);
	BOOL TrackLeft(BOOL column=0);
	BOOL TrackRight(BOOL column=0);
	BOOL TrackSetNoteActualInstrVol(int note)	{ return m_tracks.SetNoteInstrVol(note,m_activeinstr,m_volume,SongGetActiveTrack(),m_trackactiveline); };
	BOOL TrackSetNoteInstrVol(int note,int instr,int vol)	{ return m_tracks.SetNoteInstrVol(note,instr,vol,SongGetActiveTrack(),m_trackactiveline); };
	BOOL TrackSetInstr(int instr) { return m_tracks.SetInstr(instr,SongGetActiveTrack(),m_trackactiveline); };
	BOOL TrackSetVol(int vol)	{ return m_tracks.SetVol(vol,SongGetActiveTrack(),m_trackactiveline); };
	BOOL TrackSetSpeed(int speed)	{ return m_tracks.SetSpeed(speed,SongGetActiveTrack(),m_trackactiveline); };
	int TrackGetNote()			{ return m_tracks.GetNote(SongGetActiveTrack(),m_trackactiveline); };
	int TrackGetInstr()			{ return m_tracks.GetInstr(SongGetActiveTrack(),m_trackactiveline); };
	int TrackGetVol()			{ return m_tracks.GetVol(SongGetActiveTrack(),m_trackactiveline); };
	int TrackGetSpeed()			{ return m_tracks.GetSpeed(SongGetActiveTrack(),m_trackactiveline); };
	BOOL TrackSetEnd()			{ return m_tracks.SetEnd(SongGetActiveTrack(),m_trackactiveline); };
	int TrackGetLastLine()		{ return m_tracks.GetLastLine(SongGetActiveTrack()); };
	BOOL TrackSetGo()			{ return m_tracks.SetGo(SongGetActiveTrack(),m_trackactiveline); };
	int TrackGetGoLine()		{ return m_tracks.GetGoLine(SongGetActiveTrack()); };

	void TrackGetLoopingNoteInstrVol(int track,int& note,int& instr,int& vol);


	BOOL SongKey(int vk,int shift,int control);
	BOOL SongUp();
	BOOL SongDown();
	BOOL SongTrackSet(int t);
	BOOL SongTrackSetByNum(int num);
	BOOL SongTrackDec();
	BOOL SongTrackInc();
	BOOL SongTrackEmpty();
	int SongGetActiveTrack() { return m_song[m_songactiveline][m_trackactivecol]; };
	int SongGetActiveTrackInColumn(int column) { return m_song[m_songactiveline][column]; };
	int SongGetActiveLine()	 { return m_songactiveline; };
	
	BOOL SongTrackGoOnOff();
	int SongGetGo()			{ return m_songgo[m_songactiveline]; }
	void SongTrackGoDec()	{ m_songgo[m_songactiveline] = (m_songgo[m_songactiveline]-1) & 0xff; };
	void SongTrackGoInc()	{ m_songgo[m_songactiveline] = (m_songgo[m_songactiveline]+1) & 0xff; };

	BOOL SongInsertLine(int line);
	BOOL SongDeleteLine(int line);

	void OctaveUp()		{ if (m_octave<4) m_octave++; };
	void OctaveDown()	{ if (m_octave>0) m_octave--; };

	void VolumeUp()		{ if (m_volume<15) m_volume++; };
	void VolumeDown()	{ if (m_volume>0) m_volume--; };

	BOOL Play(int mode, BOOL follow);
	BOOL Stop();
	BOOL SongPlayNextLine();

	BOOL PlayBeat();
	BOOL PlayVBI();

	BOOL PlayPressedTonesInit();
	BOOL SetPlayPressedTonesTNIV(int t,int n,int i,int v) { m_playptnote[t]=n; m_playptinstr[t]=i; m_playptvolume[t]=v; return 1; }
	BOOL SetPlayPressedTonesV(int t,int v) { m_playptvolume[t]=v; return 1; };
	BOOL SetPlayPressedTonesSilence();
	BOOL PlayPressedTones();
	
	void TimerRoutine();

	BOOL InitPokey()	{ return m_pokey.InitSound(); };

	void SetRMTTitle();

	void FileOpen();
	void FileSave();
	void FileSaveAs();
	void FileNew();
	void FileExportAs();

	void FileInstrumentSave();
	void FileInstrumentLoad();

	int SongToAta(unsigned char* dest, int max, int adr);
	BOOL AtaToSong(unsigned char* sour, int len);

	int Save(ofstream& ou);
	int Load(ifstream& in);

	int Export(ofstream& ou,int iotype);
	int Import(ifstream& in,int iotype);

	int TestBeforeFileSave();

	int MakeModule(unsigned char* mem,int adr,int iotype,BYTE *instrsaved,BYTE* tracksaved);
	int DecodeModule(unsigned char* mem,int adrfrom,int adrend,int iotype,BYTE *instrloaded,BYTE* trackloaded);

	//
	void TrackCopy();
	void TrackPaste();
	void TrackCut();
	void TrackDelete()			{ m_tracks.ClearTrack(SongGetActiveTrack()); };

	void InstrCopy();
	void InstrPaste();
	void InstrCut();
	void InstrDelete()			{ m_instrs.ClearInstrument(GetActiveInstr()); };

	void SongCopyLine();
	void SongPasteLine();
	void SongClearLine();

	//

	CXPokey* GetPokey()					{ return &m_pokey; };
	CTracks* GetTracks()				{ return &m_tracks; };

	int GetPlayMode()					{ return m_play; };

	BOOL volatile m_followplay;

private:
	CXPokey m_pokey;

	CInstruments m_instrs;
	CTracks m_tracks;

	int m_song[SONGLEN][SONGTRACKS];
	int m_songgo[SONGLEN];					//je-li>=0, pak plati GO

	int m_songactiveline;
	int volatile m_songplayline;

	int m_trackactiveline;
	int volatile m_trackplayline;
	int m_trackactivecol;						//0-7
	int m_trackactivecur;						//0-2

	int m_trackplayblockstart;
	int m_trackplayblockend;

	int m_activeinstr;
	int m_volume;
	int m_octave;

	int m_infoact;
	char m_songname[SONGNAMEMAXLEN+1];
	int m_songnamecur;

	int volatile m_play;
	int volatile m_mainspeed;
	int volatile m_speed;
	int volatile m_speeda;

	int volatile m_instrspeed;
	int volatile m_instrspeeda;

	int volatile m_50s;

	int m_playptnote[SONGTRACKS];
	int m_playptinstr[SONGTRACKS];
	int m_playptvolume[SONGTRACKS];

	TInstrument m_instrclipboard;
	int m_songlineclipboard[SONGTRACKS];
	int m_songgoclipboard;

	UINT m_timer;

	CString m_filename;
	int m_filetype;

};

//-----------------------------------------------------

class CTrackClipboard
{
public:
	CTrackClipboard::CTrackClipboard();
	void Init(CSong* song);
	void Empty();
	BOOL IsBlockSelected()		{ return (m_selcol>=0); };
	BOOL BlockSetBegin(int col, int track, int line);
	BOOL BlockSetEnd(int line);
	void BlockDeselect();

	int BlockCopyToClipboard();
	int BlockPasteToTrack(int track, int line);
	int BlockClear();
	int BlockRestoreFromBackup();

	void GetFromTo(int& from, int& to);

	//
	void BlockNoteTransposition(int instr,int addnote);
	void BlockInstrumentChange(int instr,int addinstr);
	void BlockVolumeChange(int instr,int addvol);

	void BlockAllOnOff();
	void BlockInitBase(int track);

	//bloky
	int m_selcol;					//0-7
	int m_seltrack;
	int m_selsongline;
	int m_selfrom;
	int m_selto;
	TTrack m_track;

	//zmeny v bloku
	BOOL m_all;						//TRUE = zmeny vsech / FALSE = zmeny jen u instrumentu stejnych jako aktualni
	int m_instrbase;
	int m_changenote;
	int	m_changeinstr;
	int	m_changevolume;
	TTrack m_trackbase;

	TTrack m_trackbackup;

	//kopirovani celych tracku
	TTrack m_trackcopy;

private:
	void ClearTrack();

	CSong* m_song;
};

//-----------------------------------------------------


#endif
