// RmtView.cpp : implementation of the CRmtView class
//

#include "stdafx.h"
#include "Rmt.h"

#include "RmtDoc.h"
#include "RmtView.h"

#include "MainFrm.h"			//!

#include "r_music.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif




/////////////////////////////////////////////////////////////////////////////
// CRmtView

IMPLEMENT_DYNCREATE(CRmtView, CView)

BEGIN_MESSAGE_MAP(CRmtView, CView)
	//{{AFX_MSG_MAP(CRmtView)
	ON_WM_ERASEBKGND()
	ON_WM_LBUTTONDOWN()
	ON_WM_RBUTTONDOWN()
	ON_WM_KEYDOWN()
	ON_WM_KEYUP()
	ON_COMMAND(ID_FILE_OPEN, OnFileOpen)
	ON_COMMAND(ID_FILE_SAVE, OnFileSave)
	ON_COMMAND(ID_FILE_SAVE_AS, OnFileSaveAs)
	ON_COMMAND(ID_FILE_NEW, OnFileNew)
	ON_COMMAND(ID_FILE_EXPORT_AS, OnFileExportAs)
	ON_COMMAND(ID_INSTR_LOAD, OnInstrLoad)
	ON_COMMAND(ID_INSTR_SAVE, OnInstrSave)
	ON_COMMAND(ID_INSTR_COPY, OnInstrCopy)
	ON_COMMAND(ID_INSTR_PASTE, OnInstrPaste)
	ON_COMMAND(ID_INSTR_CUT, OnInstrCut)
	ON_COMMAND(ID_INSTR_DELETE, OnInstrDelete)
	ON_COMMAND(ID_TRACK_DELETE, OnTrackDelete)
	ON_COMMAND(ID_TRACK_COPY, OnTrackCopy)
	ON_COMMAND(ID_TRACK_PASTE, OnTrackPaste)
	ON_COMMAND(ID_TRACK_CUT, OnTrackCut)
	ON_COMMAND(ID_SONG_COPYLINE, OnSongCopyline)
	ON_COMMAND(ID_SONG_PASTELINE, OnSongPasteline)
	ON_COMMAND(ID_SONG_CLEARLINE, OnSongClearline)
	ON_COMMAND(ID_PLAY1, OnPlay1)
	ON_COMMAND(ID_PLAY2, OnPlay2)
	ON_COMMAND(ID_PLAY3, OnPlay3)
	ON_COMMAND(ID_PLAYSTOP, OnPlaystop)
	ON_COMMAND(ID_PLAYFOLLOW, OnPlayfollow)
	ON_COMMAND(ID_EM_INFO, OnEmInfo)
	ON_COMMAND(ID_EM_INSTRUMENTS, OnEmInstruments)
	ON_COMMAND(ID_EM_SONG, OnEmSong)
	ON_COMMAND(ID_EM_TRACKS, OnEmTracks)
	ON_UPDATE_COMMAND_UI(ID_EM_TRACKS, OnUpdateEmTracks)
	ON_UPDATE_COMMAND_UI(ID_EM_INSTRUMENTS, OnUpdateEmInstruments)
	ON_UPDATE_COMMAND_UI(ID_EM_INFO, OnUpdateEmInfo)
	ON_UPDATE_COMMAND_UI(ID_EM_SONG, OnUpdateEmSong)
	ON_UPDATE_COMMAND_UI(ID_PLAYFOLLOW, OnUpdatePlayfollow)
	ON_UPDATE_COMMAND_UI(ID_PLAY1, OnUpdatePlay1)
	ON_UPDATE_COMMAND_UI(ID_PLAY2, OnUpdatePlay2)
	ON_UPDATE_COMMAND_UI(ID_PLAY3, OnUpdatePlay3)
	ON_COMMAND(ID_PROVEMODE, OnProvemode)
	ON_UPDATE_COMMAND_UI(ID_PROVEMODE, OnUpdateProvemode)
	ON_WM_TIMER()
	ON_WM_DESTROY()
	ON_COMMAND(ID_VIEW_VOLUMEANALYZER, OnViewVolumeanalyzer)
	ON_UPDATE_COMMAND_UI(ID_VIEW_VOLUMEANALYZER, OnUpdateViewVolumeanalyzer)
	ON_COMMAND(ID_VIEW_INSTRUMENTACTIVEHELP, OnViewInstrumentactivehelp)
	ON_UPDATE_COMMAND_UI(ID_VIEW_INSTRUMENTACTIVEHELP, OnUpdateViewInstrumentactivehelp)
	ON_COMMAND(ID_VIEW_BLOCKTOOLBAR, OnViewBlocktoolbar)
	ON_UPDATE_COMMAND_UI(ID_VIEW_BLOCKTOOLBAR, OnUpdateViewBlocktoolbar)
	ON_COMMAND(ID_BLOCK_NOTEUP, OnBlockNoteup)
	ON_UPDATE_COMMAND_UI(ID_BLOCK_NOTEUP, OnUpdateBlockNoteup)
	ON_COMMAND(ID_BLOCK_VOLUMEDOWN, OnBlockVolumedown)
	ON_UPDATE_COMMAND_UI(ID_BLOCK_VOLUMEDOWN, OnUpdateBlockVolumedown)
	ON_COMMAND(ID_BLOCK_VOLUMEUP, OnBlockVolumeup)
	ON_UPDATE_COMMAND_UI(ID_BLOCK_VOLUMEUP, OnUpdateBlockVolumeup)
	ON_COMMAND(ID_BLOCK_NOTEDOWN, OnBlockNotedown)
	ON_UPDATE_COMMAND_UI(ID_BLOCK_NOTEDOWN, OnUpdateBlockNotedown)
	ON_COMMAND(ID_BLOCK_INSTRLEFT, OnBlockInstrleft)
	ON_UPDATE_COMMAND_UI(ID_BLOCK_INSTRLEFT, OnUpdateBlockInstrleft)
	ON_COMMAND(ID_BLOCK_INSTRRIGHT, OnBlockInstrright)
	ON_UPDATE_COMMAND_UI(ID_BLOCK_INSTRRIGHT, OnUpdateBlockInstrright)
	ON_COMMAND(ID_BLOCK_INSTRALL, OnBlockInstrall)
	ON_UPDATE_COMMAND_UI(ID_BLOCK_INSTRALL, OnUpdateBlockInstrall)
	ON_COMMAND(ID_BLOCK_BACKUP, OnBlockBackup)
	ON_UPDATE_COMMAND_UI(ID_BLOCK_BACKUP, OnUpdateBlockBackup)
	ON_COMMAND(ID_BLOCK_PLAY, OnBlockPlay)
	ON_UPDATE_COMMAND_UI(ID_BLOCK_PLAY, OnUpdateBlockPlay)
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CRmtView construction/destruction

CString FindCLToken(CString& sour)
{
	int from=0,len=0;
	char a,pu=0;
	for(int i=0; i<sour.GetLength(); i++)
	{
		a=sour[i];
		if (a=='"') 
		{ 
			pu++;
			if (pu==1)
				from=i+1;
			else
				return sour.Mid(from,i-from);
		}
		else
		if (a==' ' && pu==0)
		{
			if (len==0)
				from = i+1;
			else
				return sour.Mid(from,i-from);
		}
		else
			len++;
	}
	return (len>0)? sour : "";
}


CRmtView::CRmtView()
{
	// TODO: add construction code here
	CString cl = GetCommandLine();
	CString s = FindCLToken(cl);
	int lastslash = s.ReverseFind('\\');
	if (lastslash<0) lastslash = s.ReverseFind('/');
	if (lastslash>=0) 
		g_prgpath = s.Left(lastslash+1);
	else
		g_prgpath = "";

	Memory_Clear();
	if (!Atari_LoadRMTRoutines())
	{
		MessageBox("Can't open Atari RMT ATA system routines.","Error",MB_ICONERROR);
		exit(1);
	}
	Atari_InitRMTRoutine();

	//
	//
	g_screena=0;
	g_screenwait=5;		//5 setin

}

CRmtView::~CRmtView()
{
	g_mem_dc->SelectObject(m_penorig);		//vraceni puvodniho Penu
	delete m_pen1;							//uvolneni newnuteho m_pen1
}

void CRmtView::OnDestroy() 
{
	if (m_timeranalyzer) KillTimer(m_timeranalyzer);

	CView::OnDestroy();
	
	// TODO: Add your message handler code here
}

void CRmtView::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default
	if (nIDEvent == m_timeranalyzer)
	{
		DrawAnalyzer();
	}
	else
		CView::OnTimer(nIDEvent);
}

BOOL CRmtView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs
	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CRmtView drawing

void CRmtView::OnDraw(CDC* pDC)
{

	//CRmtDoc* pDoc = GetDocument();
	//ASSERT_VALID(pDoc);
	// TODO: add draw code for native data here


	if (g_screenupdate && g_invalidatebytimer )
	{
		g_screenupdate=0;
		g_invalidatebytimer=0;
		g_screena = g_screenwait;
//		MessageBeep(-1);
		DrawAll();
	}

	//MessageBeep(-1);
	pDC->BitBlt(0,0,800,600,&m_mem_dc,0,0,SRCCOPY);

}

BOOL CRmtView::DrawAll()
{
	m_mem_dc.FillSolidRect(0,0,800,600,RGB(80,80,80));
	
	m_song.DrawInfo();
	m_song.DrawSong();
	if (g_active_ti==PARTTRACKS)	//v dolni casti je aktivni?
	{
		m_song.DrawTracks();		
	}
	else
		m_song.DrawInstrument();

	m_song.DrawAnalyzer(NULL);

	return 1;
}

void CRmtView::DrawAnalyzer()
{
	CDC* pDC = GetDC();
	if (pDC)
	{
		m_song.DrawAnalyzer(pDC);
		ReleaseDC(pDC);
	}
}

BOOL CRmtView::OnEraseBkgnd(CDC* pDC) 
{
	// TODO: Add your message handler code here and/or call default
	//Invalidate(0);	
	return 1;	//CView::OnEraseBkgnd(pDC);
}


/////////////////////////////////////////////////////////////////////////////
// CRmtView printing

BOOL CRmtView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CRmtView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void CRmtView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}

/////////////////////////////////////////////////////////////////////////////
// CRmtView diagnostics

#ifdef _DEBUG
void CRmtView::AssertValid() const
{
	CView::AssertValid();
}

void CRmtView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CRmtDoc* CRmtView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CRmtDoc)));
	return (CRmtDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CRmtView message handlers


void CRmtView::OnInitialUpdate() 
{
	CView::OnInitialUpdate();

	CDC *dc=GetDC();

	//
	m_song.SetRMTTitle();

	//
	m_mem_bitmap.CreateCompatibleBitmap(dc,800,600);
	m_mem_dc.CreateCompatibleDC(dc);
	m_mem_dc.SelectObject(&m_mem_bitmap);

	m_gfx_bitmap.LoadBitmap(MAKEINTRESOURCE(IDB_GFX));
	m_gfx_dc.CreateCompatibleDC(dc);
	m_gfx_dc.SelectObject(&m_gfx_bitmap);

	g_mem_dc = &m_mem_dc;
	g_gfx_dc = &m_gfx_dc;

	m_shiftkey=m_controlkey=0;
	g_activepart = PARTTRACKS;		//tracks
	g_active_ti = PARTTRACKS;	//v dolni casti aktivni tracks

	m_pen1 = new CPen(PS_SOLID,1,RGB(144,144,144));
	m_penorig = g_mem_dc->SelectObject(m_pen1);

	m_mem_dc.FillSolidRect(0,0,800,600,RGB(0,0,0)); //inicializacni cerne pozadi

	ReleaseDC(dc);

	if (!m_song.InitPokey()) exit(1);	//hlasku vypsal uz InitPokey

	g_screenupdate=1;	//prvni vykresleni

	m_timeranalyzer=0;
	m_timeranalyzer = SetTimer(1,20,NULL);


	//PostMessage(WM_COMMAND,ID_FILE_NEW); //aby se pak vyvolal new dialog
}

void CRmtView::OnLButtonDown(UINT nFlags, CPoint point) 
{
	//m_song.Play();

	CView::OnLButtonDown(nFlags, point);
}

void CRmtView::OnRButtonDown(UINT nFlags, CPoint point) 
{
	//m_song.Stop();
	
	CView::OnRButtonDown(nFlags, point);
}

const int  NChaCode[]={  36,  38,  33, VK_SUBTRACT,  37,  12,  39, VK_ADD,  35,  40,  34,  45};
const char FlaToCha[]={0x67,0x68,0x69,109,0x64,0x65,0x66,107,0x61,0x62,0x63,0x60};
#define SCREENUPDATE	g_screenupdate=1

void CRmtView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{

	int vk = nChar;
	//*
	if (nFlags>=71 && nFlags<=82) 
	{
		if ((int)nChar == NChaCode[nFlags-71])
		{
			vk=FlaToCha[nFlags-71];
			m_shiftkey=1;
		}
	}
	//*/

	/*
		char s[128];
		sprintf(s,"shift=%i nChar=%i nFlags=%i    ",m_shiftkey,nChar,nFlags);
		//MessageBox(s);
		TextXY(s,0,0);
		SCREENUPDATE;
		//return;
	// */
	switch(vk)
	{
	case VK_ESCAPE:
		m_song.Stop();					//utisi vsechno
		if (g_prove)					//je-li zapnuto, vypne PROVE MODE
		{
			g_prove=0;
			SCREENUPDATE;
		}
		break;

		//
	case VK_F1:
		//if (m_timeranalyzer) {	KillTimer(m_timeranalyzer);	m_timeranalyzer = 0; }
		break;

	case VK_F2:
		m_song.Play(1,m_shiftkey);		//cely song od 0  (+shift => followplay)	
		break;

	case VK_F3:
		m_song.Play(2,m_shiftkey);		//od aktualniho mista (+shift => followplay)	
		break;

	case VK_F4:
		if (m_controlkey)
			m_song.Play(4,m_shiftkey);		//aktualni blok porad dokola (+shift => followplay)
		else
			m_song.Play(3,m_shiftkey);		//aktualni tracky porad dokola (+shift => followplay)	
		break;

		//
	case VK_F5:
		OnEmTracks();
		break;

	case VK_F6:
		OnEmInstruments();
		break;

	case VK_F7:
		OnEmInfo();
		break;

	case VK_F8:
		OnEmSong();
		break;

		//

	case VK_F9:							//prove mode
		OnProvemode();
		break;

	case VK_F11:						//respect volume
		g_respectvolume ^=1;
		SCREENUPDATE;
		break;

		//

	case VK_F12:
		if (g_activepart != g_active_ti)
			g_activepart = g_active_ti;
		else
		{
			if (g_activepart==PARTTRACKS)
				g_activepart=g_active_ti=PARTINSTRS;
			else
				g_activepart=g_active_ti=PARTTRACKS;	
		}
		SCREENUPDATE;
		break;
		
		//
	case VK_PAUSE:
		m_song.GetPokey()->ReInitSound();
		//MessageBeep(-1);
		break;

	case VK_SHIFT:
		m_shiftkey =1;
		break;

	case VK_CONTROL:
		m_controlkey =1;
		break;

	case VK_DIVIDE:
		m_song.TrackLeft(1);
		SCREENUPDATE;
		break;
	
	case VK_MULTIPLY:
		m_song.TrackRight(1);
		SCREENUPDATE;
		break;


	default:
//DefaultKey:
		int r=0;

		if (g_prove)
		{
			//testovani hry na klavesnici
			r=m_song.ProveKey(vk,m_shiftkey,m_controlkey);
		}
		else
		{
			if (m_shiftkey && (NoteKey(vk)>=0 || Numblock09Key(vk)>=0 || vk==VK_SPACE))
			{
				r = m_song.ProveKey(vk,m_shiftkey,m_controlkey);
			}
			else
			{
				switch (g_activepart)
				{
				case PARTINFO:
					r=m_song.InfoKey(vk,m_shiftkey,m_controlkey);
					break;
				case PARTTRACKS:
					r=m_song.TrackKey(vk,m_shiftkey,m_controlkey);
					break;
				case PARTINSTRS:
					r=m_song.InstrKey(vk,m_shiftkey,m_controlkey);
					break;
				case PARTSONG:
					r=m_song.SongKey(vk,m_shiftkey,m_controlkey);
					break;
				}
			}
		}
		if (r)
			SCREENUPDATE;
		else
			CView::OnKeyDown(nChar, nRepCnt, nFlags);
	}
}

void CRmtView::OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	if (nChar==VK_SHIFT) m_shiftkey=0;
	else
	if (nChar==VK_CONTROL) 
	{
		m_controlkey=0;
	}
	else
		CView::OnKeyUp(nChar, nRepCnt, nFlags);
}


void CRmtView::OnFileOpen() 
{
	m_song.FileOpen();
}

void CRmtView::OnFileSave() 
{
	m_song.FileSave();
}

void CRmtView::OnFileSaveAs() 
{
	m_song.FileSaveAs();
}

void CRmtView::OnFileNew() 
{
	m_song.FileNew();
	g_screenupdate=1;
}

void CRmtView::OnFileExportAs() 
{
	m_song.FileExportAs();
}

void CRmtView::OnInstrLoad() 
{
	m_song.FileInstrumentLoad();
	g_screenupdate=1;
}

void CRmtView::OnInstrSave() 
{
	m_song.FileInstrumentSave();	
}

void CRmtView::OnInstrCopy() 
{
	m_song.InstrCopy();	
}

void CRmtView::OnInstrPaste() 
{
	m_song.InstrPaste();
	g_screenupdate=1;
}

void CRmtView::OnInstrCut() 
{
	m_song.InstrCut();
	g_screenupdate=1;
}

void CRmtView::OnInstrDelete() 
{
	m_song.InstrDelete();
	g_screenupdate=1;
}

void CRmtView::OnTrackCopy() 
{
	m_song.TrackCopy();
}

void CRmtView::OnTrackPaste() 
{
	m_song.TrackPaste();
	g_screenupdate=1;
}

void CRmtView::OnTrackCut() 
{
	m_song.TrackCut();
	g_screenupdate=1;
}

void CRmtView::OnTrackDelete() 
{
	m_song.TrackDelete();
	g_screenupdate=1;
}

void CRmtView::OnSongCopyline() 
{
	m_song.SongCopyLine();	
}

void CRmtView::OnSongPasteline() 
{
	m_song.SongPasteLine();
	g_screenupdate=1;
}

void CRmtView::OnSongClearline() 
{
	m_song.SongClearLine();	
	g_screenupdate=1;
}

void CRmtView::OnPlay1() 
{
	m_song.Play(1,m_song.m_followplay);		//cely song od 0  - s respektovanim followplay
}

void CRmtView::OnPlay2() 
{
	m_song.Play(2,m_song.m_followplay);		//od aktualniho mista  - s respektovanim followplay
}

void CRmtView::OnPlay3() 
{
	m_song.Play(3,m_song.m_followplay);		//aktualni tracky porad dokola  - s respektovanim followplay
}


void CRmtView::OnPlaystop() 
{
	m_song.Stop();					//utisi vsechno	
}

void CRmtView::OnPlayfollow() 
{
	m_song.m_followplay ^= 1;
}

void CRmtView::OnEmTracks() 
{
	g_activepart=g_active_ti=PARTTRACKS;	//tracks
	SCREENUPDATE;
}

void CRmtView::OnEmInstruments() 
{
	g_activepart=g_active_ti=PARTINSTRS;	//instrs
	g_trackcl.BlockDeselect();
	SCREENUPDATE;
}

void CRmtView::OnEmInfo() 
{
	g_activepart=PARTINFO;		//info
	g_trackcl.BlockDeselect();
	SCREENUPDATE;
}

void CRmtView::OnEmSong() 
{
	g_activepart=PARTSONG;		//song
	g_trackcl.BlockDeselect();
	SCREENUPDATE;
}


void CRmtView::OnUpdatePlay1(CCmdUI* pCmdUI) 
{
	int ch= (m_song.GetPlayMode()==1)? 1 : 0;
	pCmdUI->SetCheck(ch);
}

void CRmtView::OnUpdatePlay2(CCmdUI* pCmdUI) 
{
	int ch= (m_song.GetPlayMode()==2)? 1 : 0;
	pCmdUI->SetCheck(ch);
}

void CRmtView::OnUpdatePlay3(CCmdUI* pCmdUI) 
{
	int ch= (m_song.GetPlayMode()==3)? 1 : 0;
	pCmdUI->SetCheck(ch);
}

void CRmtView::OnUpdatePlayfollow(CCmdUI* pCmdUI) 
{
	int ch= (m_song.m_followplay)? 1 : 0;
	pCmdUI->SetCheck(ch);
}

void CRmtView::OnUpdateEmTracks(CCmdUI* pCmdUI) 
{
	int ch= (g_activepart==PARTTRACKS && g_active_ti==PARTTRACKS)? 1 : 0;
	pCmdUI->SetCheck(ch);
}

void CRmtView::OnUpdateEmInstruments(CCmdUI* pCmdUI) 
{
	int ch= (g_activepart==PARTINSTRS && g_active_ti==PARTINSTRS)? 1 : 0;
	pCmdUI->SetCheck(ch);
}

void CRmtView::OnUpdateEmInfo(CCmdUI* pCmdUI) 
{
	int ch= (g_activepart==PARTINFO)? 1 : 0;
	pCmdUI->SetCheck(ch);
}

void CRmtView::OnUpdateEmSong(CCmdUI* pCmdUI) 
{
	int ch= (g_activepart==PARTSONG)? 1 : 0;
	pCmdUI->SetCheck(ch);
}


void CRmtView::OnProvemode() 
{
	if (g_prove==0)
		g_prove=1;
	else
	{
		if (g_prove==1 && g_tracks4_8>4)	//PROVE 2 jde jen pro 8 tracku
			g_prove=2;
		else
			g_prove=0;
	}
	SCREENUPDATE;
}

void CRmtView::OnUpdateProvemode(CCmdUI* pCmdUI) 
{
	int ch= (g_prove>0)? 1 : 0;
	pCmdUI->SetCheck(ch);
}

void CRmtView::OnViewVolumeanalyzer() 
{
	g_viewanalyzer ^= 1;
	SCREENUPDATE;
}

void CRmtView::OnUpdateViewVolumeanalyzer(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(g_viewanalyzer);	
}

void CRmtView::OnViewInstrumentactivehelp() 
{
	g_viewinstractivehelp ^= 1;
	SCREENUPDATE;	
}

void CRmtView::OnUpdateViewInstrumentactivehelp(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(g_viewinstractivehelp);	
}

void CRmtView::OnViewBlocktoolbar() 
{
	CMainFrame* mf = (CMainFrame*)AfxGetApp()->GetMainWnd();

	g_viewblocktoolbar = !mf->m_ToolBarBlock.IsWindowVisible();
	mf->ShowControlBar((CControlBar*)(&mf->m_ToolBarBlock),g_viewblocktoolbar,0);
}

void CRmtView::OnUpdateViewBlocktoolbar(CCmdUI* pCmdUI) 
{
	//pCmdUI->SetCheck(g_viewblocktoolbar);
	pCmdUI->SetCheck(((CMainFrame*)AfxGetApp()->GetMainWnd())->m_ToolBarBlock.IsWindowVisible());
}

void CRmtView::OnBlockNoteup() 
{
	g_trackcl.BlockNoteTransposition(m_song.GetActiveInstr(),1);
	SCREENUPDATE;
}

void CRmtView::OnUpdateBlockNoteup(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(g_trackcl.IsBlockSelected());
}

void CRmtView::OnBlockNotedown() 
{
	g_trackcl.BlockNoteTransposition(m_song.GetActiveInstr(),-1);
	SCREENUPDATE;
}

void CRmtView::OnUpdateBlockNotedown(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(g_trackcl.IsBlockSelected());
}

void CRmtView::OnBlockVolumeup() 
{
	g_trackcl.BlockVolumeChange(m_song.GetActiveInstr(),1);	
	SCREENUPDATE;
}

void CRmtView::OnUpdateBlockVolumeup(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(g_trackcl.IsBlockSelected());
}

void CRmtView::OnBlockVolumedown() 
{
	g_trackcl.BlockVolumeChange(m_song.GetActiveInstr(),-1);	
	SCREENUPDATE;
}

void CRmtView::OnUpdateBlockVolumedown(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(g_trackcl.IsBlockSelected());
}


void CRmtView::OnBlockInstrleft() 
{
	g_trackcl.BlockInstrumentChange(m_song.GetActiveInstr(),-1);	
	SCREENUPDATE;
}

void CRmtView::OnUpdateBlockInstrleft(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(g_trackcl.IsBlockSelected());
}

void CRmtView::OnBlockInstrright() 
{
	g_trackcl.BlockInstrumentChange(m_song.GetActiveInstr(),1);	
	SCREENUPDATE;
}

void CRmtView::OnUpdateBlockInstrright(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(g_trackcl.IsBlockSelected());
}

void CRmtView::OnBlockInstrall() 
{
	g_trackcl.BlockAllOnOff();	
	SCREENUPDATE;
}

void CRmtView::OnUpdateBlockInstrall(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(g_trackcl.m_all);
	pCmdUI->Enable(g_trackcl.IsBlockSelected());
}

void CRmtView::OnBlockBackup() 
{
	g_trackcl.BlockRestoreFromBackup();	
	SCREENUPDATE;
}

void CRmtView::OnUpdateBlockBackup(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(g_trackcl.IsBlockSelected());
}

void CRmtView::OnBlockPlay() 
{
	m_song.Play(4,m_song.m_followplay);		//aktualni tracky porad dokola  - s respektovanim followplay		
}

void CRmtView::OnUpdateBlockPlay(CCmdUI* pCmdUI) 
{
	int ch= (m_song.GetPlayMode()==4)? 1 : 0;
	pCmdUI->SetCheck(ch);
	pCmdUI->Enable(g_trackcl.IsBlockSelected());
}
