#ifndef __CPU_INCLUDED__
#define __CPU_INCLUDED__

#define NO_GOTO


#define UBYTE unsigned char
#define UWORD unsigned short
#define SWORD short
#define SBYTE char


#define N_FLAG 0x80
#define V_FLAG 0x40
#define G_FLAG 0x20
#define B_FLAG 0x10
#define D_FLAG 0x08
#define I_FLAG 0x04
#define Z_FLAG 0x02
#define C_FLAG 0x01

UBYTE g_atarimem[65536];

void Memory_Clear();
int GO(int goaddr,unsigned char A,unsigned char X,unsigned char Y);
int LoadBinaryBlock(ifstream& in,unsigned char* memory,WORD& fromadr, WORD& toadr);
int LoadBinaryFile(char *fname, unsigned char *memory,WORD& minadr,WORD& maxadr);
int SaveBinaryBlock(ofstream& out,unsigned char* memory,WORD fromadr,WORD toadr,BOOL ffffhead);

#define SetN regP|=N_FLAG
#define ClrN regP&=(~N_FLAG)
#define SetV regP|=V_FLAG
#define ClrV regP&=(~V_FLAG)
#define SetB regP|=B_FLAG
#define ClrB regP&=(~B_FLAG)
#define SetD regP|=D_FLAG
#define ClrD regP&=(~D_FLAG)
#define SetI regP|=I_FLAG
#define ClrI regP&=(~I_FLAG)
#define SetZ regP|=Z_FLAG
#define ClrZ regP&=(~Z_FLAG)
#define SetC regP|=C_FLAG
#define ClrC regP&=(~C_FLAG)


#endif
