;----------------------------------------------------------------------------------------
; rv's GB sound system V1.1 Compact version
; code by Stephane Hockenhull
;
; August-99
;
;----------------------------------------------------------------------------------------


;----------------------------------------------------------------------------------------
; functions
;----------------------------------------------------------------------------------------

; Init sound system
; all registers trashed
GLOBAL Audio_Init

; called every frame for sound processing
; all registers trashed
GLOBAL Audio_FrameProcess

; stop (pause) music playback and turn off all music used channels
; AF trashed
; other registers preserved
GLOBAL Audio_Music_Stop

; A = Music Index
; AF trashed
; other registers preserved
GLOBAL  Audio_Music_Play

; resume music playback
; AF trashed
; other registers preserved
GLOBAL  Audio_Music_Resume

; a = SFX index number
; l = note index
; a gets trashed with value of l
GLOBAL  Audio_SFX_Play

; stop all sfx (turn off all sfx used channels)
; AF trashed
; other registers preserved
GLOBAL  Audio_SFX_Stop

; lock/unlock channel 3
; A get trashed
; other registers preserved
GLOBAL  Audio_SFX_LockChnl3
GLOBAL  Audio_SFX_UnlockChnl3

;----------------------------------------------------------------------------------------
; Music & SFX vars
;----------------------------------------------------------------------------------------

; table of double words, (pointer to instruments, pointer to music)
GLOBAL 	Music_Table
GLOBAL  SFX_Table

; table of pointers to sound effects (4 pointers per SFX (one per channel) NULL = channel unused)
;GLOBAL  SoundFXTable
; bank where the SoundFXTable and soundfx are located (WORD)
;GLOBAL  SoundFXBank

;GLOBAL  SoundFXLock     ; read only, for debug

; table of pointers to instruments (1 pointer per Instrument)
;GLOBAL  MusicInstrumentTable
;bank where the MusicInstrumentTable and instruments are located (WORD)
;GLOBAL  MusicInstrumentBank

; arbitrary data set by music to allow visual effects synced with music
; originally initialized to 0
;GLOBAL  MusicSyncFlag

IF !DEF (SoundSystem_RAM_START)
SoundSystem_RAM_START EQU $DF80
ENDC

RSSET SoundSystem_RAM_START

MusicSyncFlag           RB 1    ; arbitrary value set by the song to sync visual effects
                                ; with bg music
MusicPlayMode           RB 1    ; current music mode, 0 = off

;*** Soundfx vars
SoundFXLock             RB 1    ; bit field, %43214321, 1 = Music, 0 = SFX Locked
SoundFXWrite            RB 1    ; index to write sfx commands
SoundFXRead             RB 1    ; index to read sfx commands
SoundFXStart            RB 8    ; (sound fx to start, note)

;*** music/sfx shared vars
MusicSFXPanning         RB 1
MusicSFXInstPause       RB 4    ; Frames Left before instrument/soundfx update
MusicSFXInstPtr         RB 8    ; pointers to playing instruments/soundfx
MusicSFXInstChnl3WaveID RB 1    ; current waveid loaded, 255 = none, IDs of 255 in instruments will load, whatever the value here
MusicSFXInstChnl3Lock   RB 1    ; 0 = no lock, 1 = external lock

;*** Music vars
MusicNextFrame          RB 1    ; number of frames until the next music commands
MusicCommandPtr         RB 2    ; position of playing music
MusicOrderPtr           RB 2    ; position of pattern order list (list of pointers to start of patterns)
MusicInstrumentTable    RB 2    ; table of instrument pointers

MusicPatternLoopCounter RB 1    ; pattern loop counter

; ** misc vars
ChannelMusicFreqs       RB 8    ; GB frequencies of channels for music backup
ChannelMusicNotes       RB 8    ; GB frequencies of channels for music backup
ChannelFreqs            RB 8    ; GB frequencies of channels
ChannelVols             RB 4    ; volumes of channels, byte[4:VOL,4:xxxx]

MusicSpeed              RB 1    ; speed

; ** effect vars
ChannelMusicEffects     RB 4    ; active effect, 0 = none
ChannelMusicFXParam     RB 8    ; parameters for effects (WORDs)
ChannelMusicFXParam2    RB 8    ; parameters for effects (WORDs)

Temp                    RB 2    ; Temporary storage for player calcs

SoundSystem_RAM_END     RB 0

;----------------------------------------------------------------------------------------
; music commands
;----------------------------------------------------------------------------------------
RSRESET

MUSIC_CMD_ENDOFFRAME      RB 1

MUSIC_CMD_PLAYINSTNOTE    RB 1
MUSIC_CMD_PLAYINST        RB 1

MUSIC_CMD_SETVOLUME       RB 1
;MUSIC_CMD_SETPANNING      RB 1
MUSIC_CMD_VIBRATO_ON      RB 1
;MUSIC_CMD_DUALNOTE_ON     RB 1
MUSIC_CMD_EFFECT_OFF      RB 1
;MUSIC_CMD_SETMASTERVOLUME RB 1

MUSIC_CMD_SYNCFLAG        RB 1

MUSIC_CMD_ENDOFPATTERN    RB 1
;MUSIC_CMD_LOOPPATTERN     RB 1
MUSIC_CMD_GOTOORDER       RB 1
MUSIC_CMD_ENDOFSONG       RB 1

MUSIC_CMD_SETSPEED        RB 1
MUSIC_CMD_ENDOFFRAME1X    RB 1
MUSIC_CMD_ENDOFFRAME2X    RB 1
MUSIC_CMD_ENDOFFRAME3X    RB 1
MUSIC_CMD_ENDOFFRAME4X    RB 1

MUSIC_CMD_PITCHUP_ON      RB 1
MUSIC_CMD_PITCHDOWN_ON    RB 1
MUSIC_CMD_TRIPLENOTE_ON   RB 1

MUSIC_CMD_EXTRA           RB 1

; number of commands
MUSIC_CMD_TOTALCOUNT     RB 0
;----------------------------------------------------------------------------------------
; music effects
;----------------------------------------------------------------------------------------
RSRESET

MUSIC_FX_NONE           RB 1
MUSIC_FX_VIB1           RB 1
MUSIC_FX_VIB2           RB 1
;MUSIC_FX_DUALFREQ1      RB 1
;MUSIC_FX_DUALFREQ2      RB 1

MUSIC_FX_TRIPLEFREQ1    RB 1
MUSIC_FX_TRIPLEFREQ2    RB 1
MUSIC_FX_TRIPLEFREQ3    RB 1

MUSIC_FX_PITCHUP        RB 1
MUSIC_FX_PITCHDOWN      RB 1
;----------------------------------------------------------------------------------------
; instrument commands
;----------------------------------------------------------------------------------------

; common commands
RSRESET

MUSIC_INSTCMD_X_FRAMEEND        RB 1
MUSIC_INSTCMD_X_START           RB 1
MUSIC_INSTCMD_X_END             RB 1
MUSIC_INSTCMD_X_ENVELOPE        RB 1
MUSIC_INSTCMD_X_STARTFREQ       RB 1
MUSIC_INSTCMD_X_ENVELOPEVOL     RB 1
MUSIC_INSTCMD_X_STARTENVVOLFREQ RB 1
MUSIC_INSTCMD_X_PANMID          RB 1
MUSIC_INSTCMD_X_PANRIGHT        RB 1
MUSIC_INSTCMD_X_PANLEFT         RB 1
; count of common instrument commands
MUSIC_INSTCMD_COMMONCOUNT RB 0

; specific commands

; channel 1&2
RSSET MUSIC_INSTCMD_COMMONCOUNT
MUSIC_INSTCMD_12_PULSELEN       RB 1
MUSIC_INSTCMD_1_SWEEP           RB 1

; channel 3
RSSET MUSIC_INSTCMD_COMMONCOUNT
MUSIC_INSTCMD_3_WAVE            RB 1
MUSIC_INSTCMD_3_LEN             RB 1

; channel 4
RSSET MUSIC_INSTCMD_COMMONCOUNT
MUSIC_INSTCMD_4_POLYLOAD        RB 1
MUSIC_INSTCMD_4_LEN             RB 1

