IF !DEF(BASEINC)
BASEINC SET 1

;=============================================================================
; start of program
GLOBAL Main
;=============================================================================

MAINSTACK_SIZE 	EQU $100
GAME_NAME EQUS "\"SNDTEST P5     \""
COLOR_FLAG_BW           EQU $00
COLOR_FLAG_BWCOMPATIBLE EQU $80
COLOR_FLAG_COLORONLY    EQU $C0
COLOR_FLAG              EQU COLOR_FLAG_BWCOMPATIBLE
SUPERGB_FLAG_GB         EQU 0
SUPERGB_FLAG_SGB        EQU 3
SUPERGB_FLAG            EQU SUPERGB_FLAG_GB
LICENSEE_CODE           EQU "00"
LANG_CODE_JAPANESE      EQU 0
LANG_CODE_NONJAPANESE   EQU 1
LANG_CODE               EQU LANG_CODE_NONJAPANESE
CART_TYPE               EQU 0 ; ROMONLY
CART_ROMSIZE        	EQU 0;CART_ROMSIZE_32K
CART_RAMSIZE        	EQU 0;CART_RAMSIZE_NONE

RAM_BANK        EQU $FF70

GLOBAL VOAM

GLOBAL VIntFlag
OAM_DMA_Routine EQU $FF80
HIGHRAM_Sysram  EQU $FF90

GBTYPE_BW     EQU $01
GBTYPE_POCKET EQU $FF     ; main system turns it back to GBTYPE_BW by default
GBTYPE_CGB    EQU $11

RSSET   HIGHRAM_Sysram
VIntFlag            RB  1
VIntCounter         RB  1
GBType              RB  1
ROMBank             RW  1
extRAMBank          RB  1
intRAMBank          RB  1
GamePad_New         RB  1
GamePad_Changes     RB  1
GamePad_Presses     RB  1
GamePad_Releases    RB  1
VInt_jp             RB  1
VInt                RW  1     ; all regs already saved, not banked
LCDCInt_jp          RB  1
LCDCInt             RW  1     ; no reg saved, not banked
RND                 RW  1
;IF DEF(HIGHRAMDEFFILE)
;INCLUDE HIGHRAMDEFFILE
;ENDC
HIGHRAM_FirstFree   RB  0

GLOBAL VInt_ret

;=============================================================================
; bits for controller switches
BTN_RIGHT   EQU 0
BTN_LEFT    EQU 1
BTN_UP      EQU 2
BTN_DOWN    EQU 3
BTN_A       EQU 4
BTN_B       EQU 5
BTN_SEL     EQU 6
BTN_SELECT  EQU BTN_SEL
BTN_START   EQU 7

PAD_RIGHT   EQU BTN_RIGHT
PAD_LEFT    EQU BTN_LEFT
PAD_UP      EQU BTN_UP
PAD_DOWN    EQU BTN_DOWN
PAD_A       EQU BTN_A
PAD_B       EQU BTN_B
PAD_SEL     EQU BTN_SEL
PAD_SELECT  EQU BTN_SELECT
PAD_START   EQU BTN_START

KEY_RIGHT   EQU BTN_RIGHT
KEY_LEFT    EQU BTN_LEFT
KEY_UP      EQU BTN_UP
KEY_DOWN    EQU BTN_DOWN
KEY_A       EQU BTN_A
KEY_B       EQU BTN_B
KEY_SEL     EQU BTN_SEL
KEY_SELECT  EQU BTN_SELECT
KEY_START   EQU BTN_START

; read the controller
; all regs trashed
GLOBAL ReadInputs
;=============================================================================
GLOBAL DisplayOff
;=============================================================================

;=============================================================================
Switch2Mhz: MACRO
    ld a, $30
    ld [$FF00], a

    ld a, [$FF4D]
    and $80
    jr nz, already2Mhz\@

    ld a, 1
    ld [$FF4D], a

    stop

    nop
    nop

    ld a, 0
    ld [$FF4D], a

    ld a, $30
    ld [$FF00], a

already2Mhz\@:
    ENDM
;=============================================================================
; in: c = internal ram bank #
; a, b trashed
; out: c = previous ram bank
SetRAMBank: MACRO
    ld a, [intRAMBank]
    ld b, a
    ld a, c
    ld c, b
    ld [intRAMBank], a
    ld [RAM_BANK], a
    ENDM

; in: c = internal ram bank #
; a trashed
SetRAMBankFast: MACRO
    ld a, c
    ld [intRAMBank], a
    ld [RAM_BANK], a
    ENDM
;=============================================================================
ENDC
