;****************************************************************************
; Filename: ATEXIT.ASM
;   Author: Peter Andersson
;  Version: 0.0
;  Created: 1995.03.13
;  Updated: -
;****************************************************************************
; Copyright Peter Andersson, 1994-1995.
; All rights reserved.
;****************************************************************************
; Function: ULONG @atexit(PFUNC);
;  Comment: @atexit registers an exit function which will be called when
;           your program ends. Up to 32 functions may be added to the exit
;           queue. The functions are executed in a last in, first out order.
;           This function will NOT be called when you exit your program with
;           @abort().
;    Input: Eax - function pointer (*func)()
;   Output: zero on success and nonzero when there are no more no space left.
;****************************************************************************
; Function: ULONG _cexit(VOID);
;  Comment: _cexit executes all registered @atexit() functions but does not
;           exit your program.
;    Input: nothing
;   Output: nothing
;****************************************************************************

	Include STDDEF.INC

MAX_ATEXIT = 32

	Codeseg

Proc	atexit  ,1
		Mov	Edx,[ExitLength]
		Cmp	Edx,MAX_ATEXIT
		Jae	@@Exit01
		Mov	[ExitQueue+Edx*4],Eax
		Inc	Edx
		Mov	[ExitLength],Edx
		Clear	Eax
@@Exit01:	Ret
Endp

	Align	4

Proc	_cexit
@@Loop01:	Mov	Ecx,[ExitLength]
		Jecxz	@@Exit01
		Dec	Ecx
		Mov	[ExitLength],Ecx
		Push	Offset @@Loop01
		Jmp	[ExitQueue+Ecx*4]
	Align	4
@@Exit01:	Ret
Endp

	Dataseg

ExitLength	Dd	0
ExitQueue	Dd	MAX_ATEXIT Dup (?)

	End
