/*             Power Assembly Library  C header file            */

typedef unsigned char uchar;
typedef unsigned short ushort;
typedef unsigned long ulong;
typedef void *pvoid;
typedef char *pchar;


#define  PAL_H

#ifndef FASTCALLS
#define _fastcall
#endif


#ifdef __cplusplus
extern "C" {
#endif

/****************************************************************************
 *       STARTUP
 ***************************************************************************/
extern ulong dos32version;       /* version of DOS32.                      */
extern char  dos32system;        /* system type-RAW,XMS,VCPI or DPMI       */
extern ulong exesize;            /* size in bytes                          */
extern char * exename;           /* PSZ to executable name                 */
extern pvoid _psp;               /* program segment prefix pointer         */
extern char *_environ;           /* environment pointer                    */
extern char **environ;           /* pointer of environment pointer table   */
extern ulong envsize;            /* environment table size                 */
extern pvoid _zero;              /* zero pointer                           */
extern ulong _zero_sel;          /* selector of zero based semgnet         */

extern pvoid DMA_addr;            /* DMA near pointer address         */
extern ulong DMA_size;            /* DMA buffer size                  */
extern pvoid DMA_phys;            /* DMA physical address             */


/****************************************************************************
 * FILEIO - file I/O
 ***************************************************************************/
extern long _fastcall chdir(pchar path);
extern long _fastcall close(long handle);
extern long _fastcall filelength(long handle);
extern long fprint(long handle,pchar fmtstr,...);
extern long _fastcall lseek(long handle,long filepos,long whence);
extern long _fastcall mkdir(pchar path);
extern long _fastcall open(pchar filename,ulong filemode);
extern long _fastcall read(long handle,pvoid buf,ulong len);
extern long _fastcall rename(pchar oldname,pchar newname);
extern long _fastcall rmdir(pchar path);
extern long _fastcall unlink(pchar filename);
extern long _fastcall write(long handle,pvoid buf,ulong len);
extern long _fastcall creat(pchar filename, long filemode);

extern long fprintf(long handle, pchar fmtstr,...);

#define O_BINARY   0          /* Binary mode                                 */
#define O_RDONLY   0          /* Read only                                   */
#define O_WRONLY   1          /* Write only                                  */
#define O_RDWR     2          /* Read and write                              */
#define O_APPEND   4          /* File pointer will be set to the end of file */
#define O_CREAT    8          /* Creates the file if it doesn't exist        */
#define O_TRUNC    16	      /* Truncate the file when open                 */
#define O_EXCL     32         /* Returns an error if file exists (O_CREAT)   */

#define SEEK_SET   0          /* Seek from file beginning                    */
#define SEEK_CUR   1          /* Seek from current file position             */
#define SEEK_END   2          /* Seek from end of file                       */


/*****************************************************************************
 * MALLOC - memory allocation
 ****************************************************************************/
extern pvoid _fastcall malloc(ulong blocksize);
extern pvoid _fastcall calloc(ulong blocksize);
extern void _fastcall free(pvoid blockptr);
extern ulong maxavail(void);
extern ulong memavail(void);
extern pvoid _fastcall realloc(pvoid blockptr,ulong size);
extern pvoid _fastcall resize(pvoid blockptr,ulong size);


/*****************************************************************************
 *   MATH - math functions
 ****************************************************************************/
extern ulong _fastcall max(ulong a,ulong b);
extern ulong _fastcall max3(ulong a,ulong b,ulong c);
extern ulong _fastcall min(ulong a,ulong b);
extern ulong _fastcall max3(ulong a,ulong b,ulong c);
extern ulong _fastcall atoi(pchar string);


/*****************************************************************************
 * STRINGS - various string I/O
 ****************************************************************************/
extern ulong _fastcall isdigit(char chr);
extern ulong _fastcall isxdigit(char chr);
extern ulong _fastcall isalpha(char chr);
extern ulong _fastcall islower(char chr);
extern ulong _fastcall isupper(char chr);
extern ulong _fastcall isalnum(char chr);
extern ulong _fastcall iscntrl(char chr);
extern ulong _fastcall isspace(char chr);
extern ulong _fastcall ispunct(char chr);
extern ulong _fastcall isascii(char chr);
extern ulong _fastcall isprint(char chr);
extern ulong _fastcall toupper(char chr);
extern ulong _fastcall tolowwer(char chr);

extern pchar _fastcall btoa(ulong value,pchar string);
extern pchar _fastcall ltoa(long value,pchar string,int radix);
extern pchar _fastcall ultoa(ulong value,pchar string,int radix);
extern pchar _fastcall otoa(ulong value,pchar string);
extern pchar _fastcall xtoa(ulong value,pchar string);
extern pchar _fastcall ptos(pvoid pascalstr);
extern ulong sprintf(pchar dest,pchar fmtstr,...);
extern pchar _fastcall stpcpy(pchar dest,pchar source);
extern pchar _fastcall strcat(pchar dest,pchar source);
extern pchar _fastcall strchr(pchar string,char chr);
extern pchar _fastcall strchrn(char string,char chr);
extern pchar _fastcall strcpy(pchar destptr,pchar srcptr);
extern pchar _fastcall strdup(pchar string);
extern long _fastcall strcmp(pchar srcptr,pchar destptr);
extern long _fastcall stricmp(pchar srcptr,pchar destptr);
extern ulong _fastcall strlen(pchar string);
extern pchar _fastcall strlwr(pchar string);
extern pchar _fastcall strupr(pchar string);
extern pchar _fastcall strncpy(pchar dest,pchar source,ulong length);
extern pchar _fastcall strpbrk(pchar s1,pchar s2);


/**************************************************************************
 * CONIO - console I/O
 *************************************************************************/

extern long printf(pchar fmtstr,...);
extern long kbhit(void);


/*****************************************************************************
 * SYSTEM - system specific
 ****************************************************************************/
extern void abort(void);
extern ulong _fastcall atexit(pvoid exitfunc);
extern void _fastcall exit(int errorlevel);
extern pvoid _fastcall getvect(ulong interrupt);
extern pvoid _fastcall setvect(ulong interrupt,pvoid vector);
extern ulong _fastcall MK_FP(pvoid address);
extern pvoid _fastcall MK_FAR(ulong);
extern void _fastcall memset(pvoid buf,char value,ulong length);
extern pvoid _fastcall memcpy(void * dest,void * source,int length);
extern pvoid _fastcall memmove(void * dest, void * source, ulong count);
extern void _fastcall _exit(ulong errorlevel);
extern void _fastcall _cexit(void);
extern pvoid _fastcall getenv(char * name);
extern int _fastcall inp(unsigned portid);
extern unsigned _fastcall inpw(unsigned portid);
extern int _fastcall outp(unsigned portid, int value);
extern unsigned _fastcall outpw(unsigned portid, unsigned value);

extern long errno;                      /* System error code */


#ifdef __cplusplus
}
#endif


/******************************************************************************
  *  Standed macros
******************************************************************************/
#define  EOF  -1
#define  NULL  0
#define  EXIT_SUCCESS 0
#define  EXIT_FAILURE 1



/* extern long _fastcall fopen(pchar filename,pchar filemode);


#define  stdin   0		            /* Standard input file ptr */
#define  stdout  1		            /* Standard output file ptr */
#define  stderr  2		            /* Standard error file ptr */

#define  fgetc  getc
#define  fputc  putc
#define  getchar() getc(stdin)
#define  putchar(c) putc((c),stdout)

extern long _fastcall putc(char chr,long handle);
extern long _fastcall getc(long handle);

*/

