;****************************************************************************
; Filename: MEMORY.INC
;   Author: Peter Andersson
;  Version: 0.0
;  Created: 1994.12.25
;  Updated: -
; Function: 
;    Input: 
;   Output: 
;  Comment: 
; See also: 
;****************************************************************************
; Copyright Peter Andersson, 1994-1995.
; All rights reserved.
;****************************************************************************

MEMALIGN = 8		; Alignment address
MINBLOCK = 16		; Minimum block size in bytes
MEMBLOCK = 8		; Total number of memory block sizes
ALLOCID = 0ADD2FEEDh	; Identifier for an allocated block - High and odd.

Struc	AllocBlock	; Alloc block - 16 bytes
Ident		Dd	ALLOCID		; Identifier for allocated block
BlockSize	Dd	0		; Block size in bytes inc. header
PrevBlock	Dd	0		; Pointer to previous block
Debug		Dd	0		; Debug ID pointer (PSZ)
Ends	AllocBlock

Struc	FreeBlock	; Free block - 16 bytes
NextFree	Dd	0		; Pointer to next free block
BlockSize	Dd	0		; Block size in bytes inc. header
PrevBlock	Dd	0		; Pointer to previous block
PrevFree	Dd	0		; Pointer to previous free block
Ends	FreeBlock

Global BlockTable:FreeBlock,BlockTableEnd:FreeBlock

Macro	GetSize	BlockReg:REQ,SizeReg:REQ
	Local	@@ExitSize
BitSize = MINBLOCK Shl 2
		Mov	BlockReg,Offset BlockTable
	Rept MEMBLOCK-1
		Cmp	SizeReg,BitSize
		Jbe	@@ExitSize
BitSize = BitSize Shl 2
		Add	BlockReg,Size FreeBlock
	Endm
	Align	4
@@ExitSize:
Endm	GetSize

Macro	Adjust MemReg:REQ,Value:REQ
	Local	@@NoAlign
		Test	MemReg,(Value-1)
		Jz	@@NoAlign
		And	MemReg,Not (Value-1)
		Add	MemReg,Value
@@NoAlign:
Endm	Adjust
