
********************************************
*                                          *
* THE FUTURE COMPOSER EDITOR FOR THE AMIGA *
* WRITTEN BY BANSAI ON 25/08/90!   1 MB OF *
* CHIP RAM  IS HIGHLY RECOMMENDED  AS THIS *
* PROGGY MUST RUN  FROM CHIP RAM!  WELCOME *
* TO THE NEVER-ENDING SOURCE CODE...  100% *
* MC68000  FUN.     OVER  3000+  LINES  OF *
* ASSEMBLY-LANGUAGE ECSTACY     -BSI 1990! *
* ASSEMBLE   WITH   THE   SEKA   EDITOR... *
* FINALLY I CAN GET SOME SLEEP....   YEAH! *
*                                          *
********************************************

BEGIN:	BRA START

; //// DO NOT INSERT ANYTHING HERE AS THE FILE INF MUST BE
;      ON A LONGWORD BOUNDARY!!! ////

FILEINF:BLK.L 260,0

********** THE ALMIGHTY COPPER LIST **********

COPLIST:DC.L $2B01FFFE,$01800000,$018200C0
	DC.L $01A20FFF,$01A40008,$01A60FFF ; COLORS FOR SPR 0/1
	DC.L $01AA0FFF,$01AC0008,$01AE0FFF ; COLORS FOR SPR 2/3
	DC.L $01440000,$01460000
	DC.L $008E0581,$01000200,$01040024,$009040C1
	DC.L $00920038,$009400D0,$01020000,$01080000,$010A0000
PLAN1H:	DC.L $00E00000
PLAN1L:	DC.L $00E20000
	DC.L $2C01FFFE,$01001200
RAS182:	BLK.B 200*8,0	; COLORS GO HERE...
	DC.L $01000200
	DC.L $00960020
	DC.L $FFFFFFFE

BACKRAS:DC.W $0022,$0044,$0066,$0088
	DC.W $00AA,$00CC,$00EE,$00EE

RASVAL:	DC.L $01820000
RASWT:	DC.L $2D01FFFE

COPDO:	MOVE.B #$2D,RASWT		; FIX R182 COLORS...
	MOVE.W #199,D0
	LEA RAS182,A0
	LEA BACKRAS,A1
	CLR.L D1
R182LP:	MOVE.W (A1,D1.W),RASVAL+2
	MOVE.L RASVAL,(A0)+
	ADDI.W #2,D1
	ANDI.W #15,D1
	MOVE.L RASWT,(A0)+
	ADDI.B #1,RASWT
	DBF D0,R182LP

	MOVE.L #BPL,D0
	MOVE.W D0,PLAN1L+2
	SWAP D0
	MOVE.W D0,PLAN1H+2
	MOVE.L #COPLIST,$DFF080
	MOVE.W #0,$DFF088
	RTS
OLDCOP:	MOVE.L GRBAS,A4
	MOVE.L 38(A4),$DFF080
	MOVE.W #0,$DFF088
	RTS

********** READ DIRECTORY **********

DCHR:	DC.B "(DIR)  ",0
DRSPAC:	DC.B 13,"PRESS SPACE TO RETURN TO MENU..."
SPAC:	DC.B " ",0

DRPATH:	DC.B "DRIVE:PATH1/PATH2/ETC",13,">",0
	EVEN

DIRECT:	BSR CLS
	LEA DRPATH,A0
	BSR PRINT
	MOVE.W #79,D0
	JSR INPUT
	TST.B D0
	BEQ LDRMENU
	LEA RETCHAR,A0
	BSR PRINT
	MOVE.L DBASE,A6
	MOVE.L #INBUFF,D1
	MOVE.L #-2,D2
	JSR -84(A6)
	TST.L D0
	BEQ DERROR
	MOVE.L D0,LOCKSAV
	MOVE.L DBASE,A6
	MOVE.L LOCKSAV,D1
	MOVE.L #FILEINF,D2
	JSR -102(A6)
	TST.L D0
	BEQ DERROR
	BRA OUTPUFF
DIRLOOP:MOVE.L DBASE,A6
	MOVE.L LOCKSAV,D1
	MOVE.L #FILEINF,D2
	JSR -108(A6)
	TST.L D0
	BEQ DERROR
OUTPUFF:TST.L FILEINF+4
	BMI SLAPHEX
	LEA DCHR,A0
	BSR PRINT
	BRA NAMSLAP
SLAPHEX:MOVE.L FILEINF+124,D0
	JSR LONGCON
	LEA 2+LONG,A0
	JSR PRINT
	LEA SPAC,A0
	BSR PRINT
NAMSLAP:MOVE.L #8+FILEINF,A0
	BSR UCASER
	MOVE.L #8+FILEINF,A0
	JSR PRINT
DOUTREC:LEA RETCHAR,A0
	JSR PRINT
	BRA DIRLOOP
DERROR:	MOVE.L DBASE,A6
	JSR -132(A6)    ; IF D0=232, OK...
	LEA DRSPAC,A0
	JSR PRINT
	JSR SPACEWT
	JMP LDRMENU

LOCKSAV:DC.L 0

********** LOWER TO UPPERCASE (PTR IN A0) **********

UCASER:	MOVEM.L D0/A0,-(A7)
	CLR.W D0
UCLOOP:	MOVE.B (A0),D0
	CMPI.W #96,D0
	BLT UCOK
	CMPI.W #122,D0
	BGT UCOK
	SUBI.W #32,D0
UCOK:	MOVE.B D0,(A0)+
	TST.B D0
	BNE UCLOOP
	MOVEM.L (A7)+,D0/A0
	RTS

********** PROGRAM MAIN ENTRY **********

START:	MOVE.L $6C,OLDCOPR
	JSR COPDO
	JSR OWNBL
	BSR MOTROFF
	MOVE.W #$8020,$dff096
	CLR.L D2
FREEALL:JSR DALLOC	
	ADDQ #1,D2
	CMPI.B #$3F,D2
	BNE FREEALL
	JSR OLDCOP
	JSR DISOWN
	JSR VCLOSE
	CLR.L D0
	RTS

GRBAS:	DC.L 0
DBASE:	DC.L 0
GRNAM:	DC.B "graphics.library",0
	EVEN
DOSNAM:	DC.B "dos.library",0
	EVEN
OWNBL:	MOVE.L 4,A6
	LEA DOSNAM,A1
	CLR.L D0
	JSR -552(A6)
	MOVE.L D0,DBASE
	JSR VOPEN
	MOVE.L 4,A6
	MOVE.L #GRNAM,A1
	CLR.L D0
	JSR -30-522(A6)
	MOVE.L D0,A6
	MOVE.L A6,GRBAS
	JSR -30-426(A6)
	MOVE.L 4,A6
	JSR -30-102(A6)
	RTS
DISOWN:	BTST #14,$DFF002
	BNE DISOWN
	MOVE.L GRBAS,A6
	JSR -30-432(A6)
	MOVE.L 4,A6
	JSR -30-108(A6)
	MOVE.L 4,A6
	MOVE.L GRBAS,A1
	JSR -414(A6)
	MOVE.L DBASE,A1
	JSR -414(A6)
	RTS

**************************************************************
*
* AMIGA RAWKEY -> ASCII KEYBOARD DRIVER
* ASCII RETURNED IN D0 AND CHV...
*
**************************************************************

GET:	MOVE.L A0,A0STORE
GETT:	MOVE.L $DFF004,D0	; APPROPRIATE WAIT...
	AND.L #$F00,D0
	BNE GETT
	BRA GETA

A0STORE:DC.L 0
OLDVCH:	DC.B $C4
CHV:	DC.B 0
RPCNT:	DC.B 0
RFLAG:	DC.B 0
SHIFLAG:DC.B 0
	EVEN

GETA:	MOVE.B $BFEC01,D0
	NOT D0
	ROR.B #1,D0
	ANDI.W #$FF,D0
	BTST #7,D0
	BNE RELEASE
	CMP.B OLDVCH,D0
	BNE RELEASE
	ADDI.B #1,RPCNT
	TST.B RFLAG
	BEQ RPNEW
	CMPI.B #50,RPCNT	; BETWEEN REP CHARS...
	BEQ NEWCH
NULLCH:	MOVE.B #$6F,D0
	BRA SHTST
RPNEW:	CMPI.B #250,RPCNT	; INITIAL WAIT
	BNE NULLCH
	MOVE.B #1,RFLAG
	CLR.B RPCNT
	BRA SHTST
RELEASE:CLR.B RFLAG
NEWCH:	CLR.B RPCNT
	MOVE.B D0,OLDVCH
SHTST:	CMPI.B #$60,D0
	BEQ ASHIF
	CMPI.B #$61,D0
	BEQ ASHIF
	CMPI.B #$E0,D0
	BEQ KSHIF
	CMPI.B #$E1,D0
	BEQ KSHIF
GCHTAB:	BTST #7,D0
	BEQ GCHB
	MOVE.B #$6F,D0
GCHB:	LEA UKTAB,A0
	TST.B SHIFLAG
	BEQ GCHA
	LEA SKTAB,A0
GCHA:	ANDI.W #$7F,D0
	MOVE.B (A0,D0.W),D0
	TST.B SHIFLAG
	BNE GCHEX
	CMPI.B #"a",D0
	BLT GCHEX
	CMPI.B #"z",D0
	BGT GCHEX
	SUBI.B #32,D0
GCHEX:	MOVE.B D0,CHV
	MOVE.L A0STORE,A0
	RTS
ASHIF:	MOVE.B #1,SHIFLAG
	BRA GCHTAB
KSHIF:	CLR.B SHIFLAG
	BRA GCHTAB

********** USA1 KEYMAPS **********
* NOTE: F1-F10 ARE 128-137
* HELP=138, RT=28, LFT=29, UP=30, DN=31
* ESC=27, BSK=8 TAB=9, SHTAB=12
* ENT=13, SHENT=10
********** USA1 KEYMAPS **********

UKTAB:	DC.B "`1234567890-=\",0,"0"
	DC.B "qwertyuiop[]",0,"123"
	DC.B "asdfghjkl;'",0,0,"456"
	DC.B 0,"zxcvbnm,./",0,".789"
	DC.B 32,8,9,13,13,27,127,0,0,0,"-",0,30,31,28,29
	DC.B 128,129,130,131,132,133,134,135,136,137,"()/*+",138
	DC.B 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

SKTAB:	DC.B "~!@#$%^&*()_+|",0,"0"
	DC.B "QWERTYUIOP{}",0,"123"
	DC.B "ASDFGHJKL:",34,0,0,"456"
	DC.B 0,"ZXCVBNM<>?",0,".789"
	DC.B 32,8,12,10,10,27,127,0,0,0,"-",0,30,31,28,29
	DC.B 128,129,130,131,132,133,134,135,136,137,"()/*+",138
	DC.B 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

********** HEX TO 2 CHAR CONVERTER **********

HX:	DC.B "  ",0
	EVEN
HEX:	DC.B "0123456789ABCDEF"
HXCONV:	MOVEM.L D0-D1/A0-A1,-(A7)
	MOVE.B D0,D1
	ANDI.W #$0F,D0
	LSR.B #4,D1
	ANDI.W #$0F,D1
	LEA HEX,A0
	MOVE.B (A0,D1.W),HX
	MOVE.B (A0,D0.W),HX+1
	MOVEM.L (A7)+,D0-D1/A0-A1
	RTS

********** PRINT CHR$(D0) AT CX,CY **********

CX:	DC.B 0
CY:	DC.B 0
PRCH:	MOVEM.L D0-D2/A0-A1,-(A7)
	ANDI.L #$FF,D0
	ASL.L #3,D0
	LEA FONT,A0
	ADD.L D0,A0
	CLR.L D1
	CLR.L D2
	MOVE.B CX,D1
	MOVE.B CY,D2
	MULU #320,D2
	LEA BPL,A1
	ADD.L D1,D2
	ADD.L D2,A1
	MOVE.B (A0)+,(A1)
	MOVE.B (A0)+,40(A1)
	MOVE.B (A0)+,80(A1)
	MOVE.B (A0)+,120(A1)
	MOVE.B (A0)+,160(A1)
	MOVE.B (A0)+,200(A1)
	MOVE.B (A0)+,240(A1)
	MOVE.B (A0)+,280(A1)
	MOVEM.L (A7)+,D0-D2/A0-A1
	RTS

********** PRINT STRING AT (A0) **********

PRINT:	MOVEM.L D0/A0,-(A7)
PRLOOP:	MOVE.B (A0)+,D0
	CMPI.B #13,D0
	BEQ PRET
	TST.B D0
	BEQ PREX
	ANDI.B #$3F,D0
	BSR PRCH
	ADDQ.B #1,CX
	CMPI.B #40,CX
	BNE PRLOOP
PRET:	CLR.B CX
	ADDQ.B #1,CY
	CMPI.B #25,CY
	BNE PRLOOP
	MOVE.B #24,CY
	BSR SCROLL
	BRA PRLOOP
PREX:	MOVEM.L (A7)+,D0/A0
	RTS

********** SCROLL UP A LINE (PREV ROUT CALLS THIS) **********

SCROLL:	MOVEM.L D0/A0-A1,-(A7)
	LEA BPL,A1
	LEA BPL+320,A0
	MOVE.W #1919,D0
SCRLP:	MOVE.L (A0)+,(A1)+
	DBF D0,SCRLP
	MOVE.W #79,D0
SCRCL:	CLR.L (A1)+
	DBF D0,SCRCL
	MOVEM.L (A7)+,D0/A0-A1
	RTS

********** CLEAR THE SCREEN **********

CLS:	MOVEM.L D0/A0,-(A7)
	MOVE.W #1999,D0
	LEA BPL,A0
CLSLP:	CLR.L (A0)+
	DBF D0,CLSLP
	CLR.B CX
	CLR.B CY
	MOVEM.L (A7)+,D0/A0
	RTS

********** DRAW THE EDITOR SCREEN **********

DRAWED:	LEA PTRK0,A0
	BSR PRINT
	BSR BTRK
	LEA PTRK1,A0
	BSR PRINT
	BSR BTRK
	LEA PTRK2,A0
	BSR PRINT
	BSR BTRK
	LEA PTRK3,A0
	BSR PRINT
	BSR BTRK
	LEA TREND,A0
	BSR PRINT
	BSR HEXSHOW
	RTS

********** UPDATE ALL HEX EN MASSE **********

HEXSHOW:MOVEM.L D0-D4/A0-A1,-(A7)
	MOVE.W TR0P,D0
	MOVE.B #1,D4
	LEA TRK0,A1
	JSR HEXTRK
	MOVE.W TR1P,D0
	MOVE.B #7,D4
	LEA TRK1,A1
	JSR HEXTRK
	MOVE.W TR2P,D0
	MOVE.B #13,D4
	LEA TRK2,A1
	JSR HEXTRK
	MOVE.W TR3P,D0
	MOVE.B #19,D4
	LEA TRK3,A1
	JSR HEXTRK
	MOVEM.L (A7)+,D0-D4/A0-A1
	RTS

********** SPACING BETWEEN TRACK HEADERS **********

BTRK:	MOVEQ #4,D0
BTLP:	LEA BLTRK,A0
	BSR PRINT
	DBF D0,BTLP
	RTS


PTRK0:	DC.B "+-TRK1---------------------+-BLOCK:**-+",13,0
PTRK1:	DC.B "+-TRK2---------------------:          :",13,0
PTRK2:	DC.B "+-TRK3---------------------:          :",13,0
PTRK3:	DC.B "+-TRK4---------------------:          :",13,0
TREND:	DC.B "+--FUTURE COMPOSER BY BSI--+-BLPOS:**-+",0
BLTRK:	DC.B ":  :                       :          :"
RETCHAR:DC.B 13,0
	EVEN

********** PRINT HEX VALS FOR TRACKS **********
* D0=BYTE OFFSET                              *
* A1=POINTER                                  *
* D4=CY VALUE                                 *
********** PRINT HEX VALS FOR TRACKS **********

HEXTRK:	MOVEM.L D0-D4/A0-A1,-(A7)
	MOVE.W D0,D2	; D2 SAVES BEGINNING POS...
	MOVE.B D4,CY
	MOVEQ #4,D1
TRPLPA:	MOVE.B #1,CX	
	JSR HXCONV
	LEA HX,A0
	JSR PRINT
	ADDQ.B #8,D0
	ADDI.B #1,CY
	DBF D1,TRPLPA
	
	MOVEQ #4,D3
	MOVE.B D4,CY
TRLPB:	MOVE.B #4,CX
TRLPC:	MOVE.B (A1,D2.W),D0	
	BSR HXCONV
	LEA HX,A0
	BSR PRINT
	ADDQ.W #1,D2
	ADDI.B #1,CX
	CMPI.B #28,CX
	BNE TRLPC
	ADDI.B #1,CY
	DBF D3,TRLPB
	MOVEM.L (A7)+,D0-D4/A0-A1
	RTS

********** LONG INT IN D0.L STRING IN "LONG" **********

HXER:	DC.L 0
LONG:	BLK.B 9,0
	EVEN
LONGCON:MOVEM.L D0-D1/A0-A1,-(A7)
	CLR.L D1	
	MOVE.L D0,HXER
	LEA LONG,A0
	LEA HXER,A1
LENLOO2:MOVE.B (A1,D1.W),D0
	BSR HXCONV
	MOVE.W HX,(A0)+
	ADDI.W #1,D1
	CMPI.W #4,D1
	BNE LENLOO2
	MOVEM.L (A7)+,D0-D1/A0-A1
	RTS

********** THE MENU SCREEN **********

MENUSCR:DC.B "  FUTURE COMPOSER (W)1990 BY BSI LABS!",13
	DC.B "PRODUCED BY THE AMIGA PRIVATEERS SOCIETY"
	DC.B "----------------------------------------"
	DC.B "PRESS:",13
	DC.B "A) FC EDITOR",13
	DC.B "B) LOAD / SAVE / DIRECTORY / ETC",13
	DC.B "C) GREETINGS",13	
	DC.B "D) NTSC (60HZ)",13
	DC.B "E) PAL  (50HZ)",13
	DC.B "F) INSTRUCTIONS",13
	DC.B "G) EXIT TO CLI",13
	DC.B "----------------------------------------"
	DC.B "ANOTHER MIDNIGHT CODER SPECIAL BY BANSAI"
	DC.B "FOR THE AMIGA PRIVATEERS SOCIETY AND THE"
	DC.B "INFOMANIACS!    (MAKE YOUR SELECTION...)",13
CHIPPER:DC.B "AVAIL CHIP:        ",13
FASTTER:DC.B "AVAIL FAST:        ",13,13
	DC.B "----------------------------------------",0
	EVEN

ARUSURE:DC.B 13,13,"ARE YOU SURE? (Y/N)",0

MENU:	JSR MUSOFF	; JUST IN CASE THEY FORGOT...
	CLR.W HILO
	BSR CLS
	MOVEQ #2,D1
	MOVE.L 4,A6
	JSR -216(A6)
	BSR LONGCON
	LEA CHIPPER+11,A0
	LEA LONG,A1
	MOVEQ #7,D0
AVCHPLP:MOVE.B (A1,D0.W),(A0,D0.W)
	DBF D0,AVCHPLP	
	MOVEQ #4,D1
	MOVE.L 4,A6
	JSR -216(A6)
	BSR LONGCON
	LEA FASTTER+11,A0
	LEA LONG,A1
	MOVEQ #7,D0
AVFASLP:MOVE.B (A1,D0.W),(A0,D0.W)
	DBF D0,AVFASLP	
	LEA MENUSCR,A0
	BSR PRINT

MENULP:	BSR GET
	TST.B D0
	BEQ MENULP
	CMPI.B #"A",D0
	BEQ ED
	CMPI.B #"D",D0
	BEQ NTSC
	CMPI.B #"E",D0
	BEQ PAL
	CMPI.B #"F",D0
	BEQ INSTRUC
	CMPI.B #"G",D0
	BEQ MENUEX
	CMPI.B #"B",D0
	BEQ LDRMENX
	CMPI.B #"C",D0
	BEQ DOGREET
	BRA MENULP
MENUEX:	LEA ARUSURE,A0
	BSR PRINT
RSGET:	BSR GET
	TST.B D0	
	BEQ RSGET
	CMPI.B #"Y",D0
	BEQ MENUBYE
	CMPI.B #"N",D0
	BNE RSGET
	BRA MENU
MENUBYE:RTS

NTSC:	MOVE.W #$00,$DFF1DC
	BRA MENULP

PAL:	MOVE.W #$20,$DFF1DC
	BRA MENULP

********** INSTRUCTIONS **********

INTEXT:	DC.B "IN THE EDITOR (HEX EDIT):",13,13
	DC.B "PRESS F1-F4 TO EDIT TRACKS 1-4.  THIS",13
	DC.B "ALSO HOMES THE TRACK CURSOR TO 00. YOU",13
	DC.B "HAVE 256 BYTES PER TRACK.  BYTES ARE:",13,13
	DC.B "00-3F = BLOCK # TO PLAY",13
	DC.B "40-7F = REPEAT NEXT VAL XX-3F TIMES",13
	DC.B "80-A3 = TRANSPOSE XX-80 HALF STEPS",13
	DC.B "C0-C1 = FILTER ON-OFF",13
	DC.B "FC XX = SET VOL FOR THIS TRACK (00-3F)",13
	DC.B "FD XX = GOTO BYTE XX IN THIS TRACK",13
	DC.B "FE    = END SONG",13
	DC.B "FF    = RESTART THIS TRACK",13,13
	DC.B "NOTE THAT SINCE YOU INDICATE BLOCKS TO",13
	DC.B "BE PLAYED AS WELL AS REPEAT VALUES WHICH"
	DC.B "MAY BE EXECUTED INDEPENDENTLY OF THE",13
	DC.B "OTHER VOICES, LONG SONGS AS WELL AS",13
	DC.B "REPETITIOUS SONG PARTS MAY BE CREATED",13
	DC.B "WITH EASE.",13,13
	DC.B "(CONTINUED... PRESS SPACE)",0

INTEX1A:DC.B "ESCAPE RETURNS YOU TO THE MAIN MENU",13
	DC.B "WHILE IN THE HEX EDITOR. NOTE THAT ",13
	DC.B "SHIFT-ENT IS INSERT A BYTE, AND DEL",13
	DC.B "DELETES ONE.  BACKSPACE ACTS AS A",13
	DC.B "CURSOR LEFT.",13,13
	DC.B "PRESS THE FOLLOWING TO HEAR THE TUNE:",13
	DC.B "F8 - START TUNE FROM BEGINNING",13
	DC.B "F10- STOP TUNE",13
	DC.B "F9 - CONTINUE TUNE FROM STOP POINT",13,13
	DC.B "NOTE THAT THE ABOVE KEYS ARE ALSO",13
	DC.B "ACTIVE IN THE BLOCK EDITOR.",13,13
	DC.B "TO KEEP THE MUSIC DRIVER FROM GOING",13
	DC.B "INTO AN ENDLESS LOOP, IT WILL DISABLE",13
	DC.B "ITSELF IF MORE THAN 512 ITEMS ARE",13
	DC.B "PROCESSED IN ANY TRACK DURING 1/60",13
	DC.B "SECOND.  512 IS IMPOSSIBLE TO ATTAIN",13
	DC.B "DURING NORMAL SONGPLAY.",13,13
	DC.B "(IS THIS CLOSE TO FC64 OR WHAT?!?",13
	DC.B "PRESS SPACE FOR MORE...)",0
	EVEN

INTEX1B:DC.B "THE EQUALIZER",13
	DC.B "-------------",13,13
	DC.B "WHILE A SONG IS PLAYING, YOU WILL SEE",13
	DC.B "A FOUR TRACK EQUALIZER IN THE TRACK 1",13
	DC.B "WORKSPACE.  THE TOP 40% COMPRISES THE",13
	DC.B "ANALOG EQUALIZER, AND THE LOWER 60%",13
	DC.B "CONTAIN THE FOLLOWING INFORMATION FOR",13
	DC.B "EACH TRACK:",13,13
	DC.B "CURRENT BLOCK# BEING PLAYED (00-3F)",13
	DC.B "POSITION IN THAT BLOCK (I.E. BLPOS)",13
	DC.B "COUNTDOWN UNTIL NEXT NOTE (I.E. DUR)",13,13
	DC.B "YOU MAY PRESS THE LEFT MOUSE BUTTON",13
	DC.B "TO SPEED THE SONG TO FIVE TIMES",13
	DC.B "NORMAL SPEED.  THE RIGHT BUTTON WILL",13
	DC.B "TOGGLE THE EQUALIZER DISPLAY ON AND",13
	DC.B "OFF SO YOU MAY EDIT TRACK 1 WHILE",13
	DC.B "YOUR TUNE IS PLAYING.",13,13
	DC.B "(TRICK, EH?  HIT SPACE...)",0

INTEXT2:DC.B "PRESS ",34,"*",34," TO ENTER THE BLOCK EDITOR...",13
	DC.B "...IT ALSO TOGGLES BACK TO MAIN EDITOR",13
	DC.B 13
	DC.B "*END!*   MARKS THE END OF A MUSIC BLOCK",13
	DC.B "         (253 STEPS MAX-NOT DISP ON FD!)"
	DC.B "SND.XX   SUBSEQUENT NOTES USE DIGI XX",13
	DC.B "         (00-3E:AS DEFINED IN SOUND LDR)"
	DC.B "DUR.XX   PLAY DIGI FOR (00-3F) JIFFIES",13
	DC.B "         (00 IS ACTUALLY 40)",13
	DC.B "MOD.XX   MODIFY/DETUNE PERIOD +2*(00-3C)"
	DC.B "TEM.XX   SELECT TEMPO 00-0F. 02=NORMAL",13,13
	DC.B "NOTES PLAYABLE ARE C-0 THROUGH B-3.",13
	DC.B "FLATS NOT SUPPORTED. USE SHARPS INSTEAD:"
	DC.B "I.E. A#2 RATHER THAN B FLAT 2.",13,13
	DC.B "CURSOR KEYS FUNCTION AS IN THE HEX",13
	DC.B "EDITOR.  PRESS DEL TO DELETE CURRENT",13
	DC.B "LINE, SHIFT-ENTER TO INSERT. ANY UP,",13
	DC.B "DOWN, ENTER, SHIFT-ENTER, OR * WILL",13
	DC.B "AUTOMATICALLY ENTER THE LINE.",13,13
	DC.B "(SPACE FOR MORE...)",13,13
	DC.B "NOT JUST ANOTHER MUSIC PROGGY...",0
	EVEN	

INTEX2A:DC.B "USING GLIDE WITH MOD.",13
	DC.B "---------------------",13,13
	DC.B "NORMALLY, MOD WILL DETUNE THE FOLLOWING",13
	DC.B "NOTES BY 2 TIMES THE PARAMETER FOLLOWING"
	DC.B "IT.  (00-3C)  HOWEVER, VALUES 3D-3F HAVE"
	DC.B "SPECIAL FUNCTIONS:",13,13
	DC.B "MOD.3D  -  GLIDE DOWN",13
	DC.B "MOD.3E  -  NO GLIDE",13
	DC.B "MOD.3F  -  GLIDE UP",13,13
	DC.B "NOTE THAT YOU SHOULD EITHER PRECEDE OR",13
	DC.B "FOLLOW THE ABOVE MOD STATEMENTS WITH",13
	DC.B "ANOTHER MOD STATEMENT (00-3C) THAT",13
	DC.B "INDICATES THE GLIDE UP/DOWN VALUES.",13,13
	DC.B "NOTE THAT AFTER A MOD.3E, YOU SHOULD",13
	DC.B "FOLLOW IT WITH A MOD.00 TO CANCEL",13
	DC.B "DETUNING IF IT IS NOT DESIRED.",13,13
	DC.B "(HIT THE LONG FURRY ONE...)",0

INTEXT3:DC.B "BLOCK EDITOR (CONTINUED):",13
	DC.B "-------------------------",13,13
	DC.B "NOTE THAT YOU NEED NOT TYPE THE WHOLE",13
	DC.B "CONTROL NAME CORRECTLY AS THE FIRST",13
	DC.B "CHAR AND THE HEX DIGITS IN COLUMNS",13
	DC.B "FOUR AND FIVE (FROM ZERO) ARE",13
	DC.B "ENCODED.  SO, YOU CAN TYPE: DXXX20XX",13
	DC.B "WHICH RESULTS IN: DUR.20",13,13
	DC.B "FOR NOTE NAMES, THE FIRST 3 CHARS ARE",13
	DC.B "EVALUATED, AND THE OCTAVE ASCII VALUE",13
	DC.B "IS ANDED WITH 3.  THEREFORE:",13
	DC.B 34,"C-!",34," BECOMES ",34,"C-1",34,".",13,13
	DC.B "THIS IS HELPFUL IN TYPING OVER INCORRECT"
	DC.B "VALUES.  THE IMPOSSIBLE NOTE VALUES",13
	DC.B "B# AND E# ARE REJECTED AS FALSE INPUT.",13
	DC.B "ANY FALSE INPUT RETURNS THE CORRECT",13
	DC.B "VALUE THAT WAS PREVIOUSLY LOCATED THERE.",13
	DC.B "(HIT THE LONG ONE...)",13,13
	DC.B "THIS RADICAL CHARSET IS BY FUSION!",0
	EVEN

INTEX3A:DC.B "ADDITIONAL BLOCK EDIT COMMANDS:",13
	DC.B "-------------------------------",13,13
	DC.B "THE COMMANDS ",34,"?",34," AND ",34,"!",34," ARE",13
	DC.B "QUITE USEFUL.  THE QUESTION MARK WILL",13
	DC.B "QUERY THE CURRENT BLOCK AND COPY IT TO",13
	DC.B "A SPECIAL BLOCK BUFFER.  THE EXCLAMATION"
	DC.B "POINT COPIES THE CONTENTS OF THE BUFFER",13
	DC.B "TO THE CURRENT BLOCK. NOTE THAT THE",13
	DC.B "BUFFER STARTS OUT EMPTY, AND THE ONLY",13
	DC.B "TIME IT WILL EVER CHANGE IS WHEN YOU",13
	DC.B "COPY SOMETHING TO IT.",13,13
	DC.B "NOTE THAT THE SCREEN WILL MOMENTARILY",13
	DC.B "FLASH WHITE TO INDICATE THAT THE",13
	DC.B "OPERATION HAS BEEN COMPLETED.",13,13
	DC.B "THE ? AND ! COMMANDS WILL ONLY WORK",13
	DC.B "IF SHIFTED. THIS IS FOR YOUR OWN",13
	DC.B "PROTECTION AGAINST ACCIDENTAL KEY",13
	DC.B "PRESSES.",13,13
	DC.B "(SPACE-THE GREAT AMERICAN CHOCOLATE BAR)",0
	
INTEXT4:DC.B "THE I/O MENU:",13
	DC.B "-------------",13,13
	DC.B "LOAD/SAVE SONG DATAS- LOADS OR SAVES THE"
	DC.B "BLOCK AND TRACK DATAS ONLY.",13,13
	DC.B "LOAD IFF DIGI INSTRUMENTS- LOADS AN IFF",13
	DC.B "SOUND. IT ACCEPTS WAVEFORMS AND NORMAL",13
	DC.B "DIGI SOUNDS.",13,13
	DC.B "LOAD FC MODULE- LOADS A FUCO FILE INTO",13
	DC.B "MEMORY.  BOTH DATAS AND DIGIS WILL LOAD.",13
	DC.B "DIRECTORY- SHOWS THE DIRECTORY AS YOU",13
	DC.B "SPECIFY IT. (DRIVE:PATH/XXX)",13,13
	DC.B "SAVE FC MODULE- SAVES DATAS & DIGIS AS",13
	DC.B "ONE FILE.",13,13
	DC.B "DELETE FILE- DELETES THE FILE THAT IS",13
	DC.B "SPECIFIED. (NO (DIR) DELETIONS)",13,13
	DC.B "(SPACE FOR MORE...)",0
	EVEN

INTEXT5:DC.B "I/O MENU (CONTINUED):",13
	DC.B "---------------------",13,13
	DC.B "DELETE DIGI IN MEMORY- DELETES A DIGI",13
	DC.B "FROM 00-3F AS SELECTED.",13,13
	DC.B "MAKEDIR- CREATES A DIRECTORY IN THE",13
	DC.B "CURRENT DIRECTORY WITH THE NAME THAT",13
	DC.B "IS SPECIFIED.",13,13
	DC.B "CLEAR ALL DATAS- THIS CLEARS ALL SONG",13
	DC.B "DATAS AND DE-ALLOCATES ALL MEMORY FOR",13
	DC.B "THE DIGIS.  NOTE THAT THIS IS AN",13
	DC.B "INCINERATOR AND IS NOT RECOVERABLE!",13,13
	DC.B "*** NOTE ***",13,13
	DC.B "PRESSING ENTER AT A FILENAME PROMPT WILL"
	DC.B "TAKE YOU BACK TO THE I/O MENU.  ALSO, IF"
	DC.B "THE COMPUTER SEEMS TO LOCK UP AFTER YOU",13
	DC.B "INPUT A NAME, PRESS LEFT AMIGA-B THEN",13
	DC.B "LEFT AMIGA-V TO CONTINUE.",13,13
	DC.B "(THERE'S MORE...)",0
	EVEN

INTEXT6:DC.B "DISPLAY DIGIS IN MEMORY- THIS DISPLAYS",13
	DC.B "THE SOUND NUMBER, FIRST 4 CHARS OF THE",13
	DC.B "SOUND NAME, AS WELL AS BODY LENGTH,",13
	DC.B "START LOOP, AND REPEAT LENGTH VALUES.",13,13,13
	DC.B "TECHNICAL INFO:",13
	DC.B "---------------",13,13
	DC.B "THIS EDITOR WAS WRITTEN IN A TEN DAY",13
	DC.B "PERIOD IN SEKA ASSEMBLER.  QUITE SIMPLY",13
	DC.B "THE BEST 68000 ASSEMBLER ON THE AMIGA!",13,13
	DC.B "THIS PROGGY WAS AN EXERCISE FOR MYSELF",13
	DC.B "SO I COULD GET SOME PRACTICE IN FILE",13
	DC.B "MANIPULATION AND MEMORY ALLOCATION",13
	DC.B "GYMNASTICS.",13,13
	DC.B "FUTURE COMPOSER AMIGA WAS INSPIRED BY",13
	DC.B "THE C64 VERSION BY THE BEASTIE BOYS.",13,13
	DC.B "THERE'S NOTHING ELSE TO WRITE.  PRESS",13
	DC.B 34,"C",34," IN THE MAIN MENU FOR GREETZ.",13,13
	DC.B "SLATES FROM BSI!",0
	EVEN

SPACEWT:BSR GET
	CMPI.B #$20,D0
	BNE SPACEWT
	RTS

INSTRUC:BSR CLS
	LEA INTEXT,A0	
	BSR PRINT
	BSR SPACEWT
	BSR CLS
	LEA INTEX1A,A0
	BSR PRINT
	BSR SPACEWT
	BSR CLS
	LEA INTEX1B,A0
	BSR PRINT
	BSR SPACEWT
	BSR CLS
	LEA INTEXT2,A0
	BSR PRINT
	BSR SPACEWT
	BSR CLS
	LEA INTEX2A,A0
	BSR PRINT
	BSR SPACEWT
	BSR CLS
	LEA INTEXT3,A0
	BSR PRINT
	BSR SPACEWT
	BSR CLS
	LEA INTEX3A,A0
	BSR PRINT
	BSR SPACEWT
	BSR CLS
	LEA INTEXT4,A0
	BSR PRINT
	BSR SPACEWT
	BSR CLS
	LEA INTEXT5,A0
	BSR PRINT
	BSR SPACEWT
	BSR CLS
	LEA INTEXT6,A0
	BSR PRINT
	BSR SPACEWT
	BRA MENU

********** UPDATE HEX FOR A TRACK **********

UPDATH:	CLR.L D0
	MOVE.W CURV,D0
	LSL.W #8,D0
	LEA TRK0,A1
	ADD.L D0,A1
	MOVE.W CURV,D0
	LEA VOICEY,A0
	MOVE.B (A0,D0.W),D4
	ASL.W #1,D0
	LEA TR0P,A0
	MOVE.W (A0,D0.W),D0
	BSR HEXTRK
	BRA MAINSC3

********** CALC XYPOS **********

TROFF:	DC.W 0
YOFF:	DC.B 0
	EVEN
CALCPOS:MOVEM.L D0-D1,-(A7)
	MOVE.W TROFF,D0
	MOVE.W D0,D1
	LSR.W #3,D0
	ADD.B YOFF,D0
	ANDI.W #$07,D1
	MULU #3,D1
	ADDQ.W #4,D1
	ADD.W HILO,D1
	MOVE.B D0,CY
	MOVE.B D1,CX
	MOVEM.L (A7)+,D0-D1
	RTS

********** XOR THE CURSOR TO THE SCREEN **********

CURSOR:	MOVEM.L D1-D2/A1,-(A7)
	CLR.L D1
	CLR.L D2
	MOVE.B CX,D1
	MOVE.B CY,D2
	MULU #320,D2
	LEA BPL,A1
	ADD.L D2,A1
	ADD.L D1,A1
	MOVEQ #7,D1
CURSLP:	EORI.B #$FF,(A1)
	ADDI.L #40,A1
	DBF D1,CURSLP
	MOVEM.L (A7)+,D1-D2/A1
	RTS

********** DRAW THE EDITOR SCREEN **********

ED:	BSR DRAWED
	BRA MAINSC	

********** MAIN KEYPRESS ACCEPTOR IN ED **********

VOICEY:	DC.B 1,7,13,19
CURV:	DC.W 0
HILO:	DC.W 0

MAINSC:	CLR.W TROFF
MAINSC2:BSR HEXSHOW
MAINSC3:MOVE.W CURV,D0
	LEA VOICEY,A0
	MOVE.B (A0,D0.W),YOFF
	BSR CALCPOS
	BSR CURSOR
MAINLP:	BSR GET
	CMPI.W #$80,D0
	BLT NOSELV
	CMPI.W #$83,D0
	BGT NOSELV
	BSR CALCPOS
	BSR CURSOR
	CLR.W TROFF
	CLR.W HILO
	SUBI.B #$80,D0
	MOVE.B D0,CURV+1
	BRA MAINSC3
NOSELV:	CMPI.B #30,D0
	BEQ MUP
	CMPI.B #31,D0
	BEQ MDN
	CMPI.B #8,D0	; BACKSPACE DOES A LEFT ARROW...
	BEQ MLT
	CMPI.B #29,D0
	BEQ MLT
	CMPI.B #13,D0	; ENTER DOES A RIGHT SPACE...
	BEQ MRT
	CMPI.B #28,D0
	BEQ MRT
	CMPI.B #10,D0	; SHIFT-ENT=INSERT.  HXD WILL
	BEQ HXD		; DISCRIMINATE...
	CMPI.B #27,D0	; ESCAPE EXITS...
	BEQ MENU
	CMPI.B #127,D0	; DELETE A BYTE...
	BEQ HXD	
	CMPI.B #135,D0
	BEQ MSON
	CMPI.B #136,D0
	BEQ MSCON
	CMPI.B #137,D0
	BEQ MSOFF

	CMPI.B #"*",D0  ; GOTO BLOCK EDITOR...
	BEQ BLKEDIT

	LEA HEX,A0	; CHECK FOR HEX KEYSTROKES...
	CLR.W D1
GHEXSRC:CMP.B (A0,D1.W),D0
	BEQ GHXKEY
	ADDQ #1,D1
	BTST #4,D1
	BEQ GHEXSRC

	BRA MAINLP

GHXKEY:	BSR CALCPOS
	ANDI.W #$3F,D0
	BSR PRCH
	MOVE.W D1,D3
	CLR.L D1
	MOVE.W CURV,D1
	ASL.W #1,D1
	LEA TR0P,A0
	MOVE.W (A0,D1.W),D1
	ADD.W TROFF,D1
	CLR.L D2
	MOVE.W CURV,D2
	ASL.W #8,D2
	LEA TRK0,A0	
	ADD.L D1,D2
	ADD.L D2,A0
	MOVE.B (A0),D1
	TST.W HILO
	BEQ MODHINB
	ANDI.B #$F0,D1
	OR.B D3,D1
	BRA UPDBYT
MODHINB:LSL.B #4,D3
	ANDI.B #$0F,D1
	OR.B D3,D1
UPDBYT:	MOVE.B D1,(A0)
	BRA MRTA

********** MUSIC ON/OFF PART **********

MSON:	JSR MUSOFF
	JSR MUSON
	BRA MAINLP

MSOFF:	JSR MUSOFF
	BRA MAINLP

MSCON:	JSR MUSOFF
	JSR MUSCON
	BRA MAINLP 

********** DELETE / INSERT A BYTE IN HEX BLOCK **********

HXD:	CLR.L D2
	MOVE.W CURV,D2
	ASL.W #1,D2
	LEA TR0P,A0
	MOVE.W (A0,D2.W),D1
	ADD.W TROFF,D1

	MOVE.W CURV,D2
	LSL.W #8,D2
	LEA TRK0,A0
	ADD.L D2,A0

	CMPI.B #10,D0	; INSERT DISCRIMINATOR...
	BEQ HXI

	MOVE.L D1,$F0000
	CMPI.B #$FF,D1
	BEQ HXDLEX
HXDL:	MOVE.B 1(A0,D1.W),(A0,D1.W)
	ADDI.B #1,D1
	CMPI.B #$FF,D1
	BNE HXDL
HXDLEX:	CLR.B (A0,D1.W)
	BRA UPDATH

********** THE INSERT HEX BYTE **********

HXI:	MOVE.W #$FE,D0
	CMPI.B #$FF,D1
	BEQ HXILEX
	SUBI.W #1,D1
HXIL:	MOVE.B (A0,D0.W),1(A0,D0.W)
	SUBQ #1,D0
	CMP.W D1,D0
	BNE HXIL
HXILEX:	BRA UPDATH

********** CURSOR MOVEMENT IN HEX BLOCKS... **********

MUP:	BSR CALCPOS
	BSR CURSOR
	MOVE.W TROFF,D1
	CMPI.B #$08,D1
	BLT UPC
	SUBI.W #8,TROFF
	BRA MAINSC3
UPC:	MOVE.W CURV,D0
	ASL.W #1,D0
	LEA TR0P,A0
	MOVE.W (A0,D0.W),D1
	CMPI.W #$08,D1
	BLT NOUP
	SUBI.W #8,D1
NOUP:	MOVE.W D1,(A0,D0.W)
	BRA UPDATH

MDN:	BSR CALCPOS
	BSR CURSOR
	MOVE.W TROFF,D1
	CMPI.B #$1F,D1
	BHI DNC
	ADDI.W #8,TROFF
	BRA MAINSC3
DNC:	MOVE.W CURV,D0
	ASL.W #1,D0
	LEA TR0P,A0
	MOVE.W (A0,D0.W),D1
	CMPI.W #$D7,D1
	BHI NODN
	ADDI.W #8,D1
NODN:	MOVE.W D1,(A0,D0.W)
	BRA UPDATH

MLT:	BSR CALCPOS
	BSR CURSOR
	EORI.W #1,HILO
	TST.W HILO
	BNE MLTPT
	BRA MAINSC3
MLTPT:	SUBI.W #1,TROFF
	BPL MAINSC3
	MOVE.W CURV,D0
	ASL.W #1,D0
	LEA TR0P,A0
	MOVE.W (A0,D0.W),D1
	TST.B D1
	BNE MLTA8
	CLR.W TROFF
	CLR.W HILO
	BRA UPC
MLTA8:	ADDI.W #8,TROFF
	BRA UPC

MRT:	BSR CALCPOS
	BSR CURSOR
MRTA:	EORI.W #1,HILO
	TST.W HILO
	BEQ MRTPL
	BRA MAINSC3
MRTPL:	ADDI.W #1,TROFF
	CMPI.W #$28,TROFF
	BLT MAINSC3
	MOVE.W CURV,D0
	ASL.W #1,D0
	LEA TR0P,A0
	MOVE.W (A0,D0.W),D1
	CMPI.B #$D8,D1
	BNE MRTS8
	MOVE.W #$27,TROFF
	EORI.W #$01,HILO
	BRA DNC
MRTS8:	SUBI.W #8,TROFF
	BRA DNC

********** BLOCK EDITING : DECODE D0.B INTO STRING **********

MNOT:	DC.B "CCDDEFFGGAAB"
MNOT2:	DC.B "-#-#--#-#-#-"
WKSPACE:DC.B "        ",0
	EVEN
MARP:	DC.B "TEM."
MSND:	DC.B "SND."
MDUR:	DC.B "DUR."
MGLD:	DC.B "MOD."
MEND:	DC.B "*END!*"

DECODE:	MOVEM.L D0-D2/A0,-(A7)
	MOVE.L #$20202020,D1
	MOVE.L D1,WKSPACE
	MOVE.L D1,WKSPACE+4
	ANDI.W #$FF,D0
	BTST #7,D0
	BNE DHISET
	CMPI #$30,D0
	BLT DNTDEC
	MOVE.W D0,D1
	ANDI.W #$70,D1
	CMPI.B #$70,D1
	BEQ DARPDEC
	BRA DGLDDEC
DHISET:	CMPI.B #$FF,D0
	BEQ DENDMKR
	BTST #6,D0
	BNE DSNDDEC
	BRA DDURDEC

DNTDEC:	ANDI.L #$3F,D0
	MOVE.L D0,D1
	MOVE.L D1,D2
	DIVU #12,D1
	MOVE.L D1,D0
	MULU #12,D0
	SUB.W D0,D2
	LEA MNOT,A0
	MOVE.B (A0,D2.W),WKSPACE
	MOVE.B 12(A0,D2.W),WKSPACE+1
	LEA HEX,A0
	MOVE.B (A0,D1.W),WKSPACE+2
	BRA DECEXIT

DARPDEC:MOVE.L MARP,WKSPACE
	ANDI.W #$0F,D0
DEHEXPL:JSR HXCONV
	MOVE.W HX,WKSPACE+4
	BRA DECEXIT

DDURDEC:MOVE.L MDUR,WKSPACE
D0AND3F:ANDI.W #$3F,D0
	BRA DEHEXPL

DSNDDEC:MOVE.L MSND,WKSPACE
	BRA D0AND3F

DGLDDEC:MOVE.L MGLD,WKSPACE
	SUBI.W #$30,D0
	BRA D0AND3F

DENDMKR:MOVE.L MEND,WKSPACE
	MOVE.W MEND+4,WKSPACE+4

DECEXIT:MOVEM.L (A7)+,D0-D2/A0
	RTS

********** CLEAR THE BLOCK EDIT AREA **********

BLANKL:	DC.B "        ",0
	EVEN

CLRBED:	MOVEM.L D0/A0,-(A7)
	MOVEQ #1,D0
	LEA BLANKL,A0
CLRBLA:	MOVE.B #29,CX
	MOVE.B D0,CY	
	BSR PRINT
	ADDI.B #1,D0
	CMPI.B #24,D0
	BNE CLRBLA
	MOVEM.L (A7)+,D0/A0
	RTS	

********** WITH CURRENT BLOCK IN D0.B, DISPLAY CONTENTS... **********
********** OFFSET IN D1.B **********

DISPBLK:MOVEM.L D0-D2/A0-A2,-(A7)
	LEA BLKASC,A1
	ANDI.L #$FF,D0
	JSR HXCONV
	LEA HX,A0
	MOVE.B #0,CY
	MOVE.B #35,CX
	BSR PRINT
	ASL.W #8,D0
	ANDI.W #$FF,D1
	LEA BLOX,A2
	ADD.L D0,A2
	MOVE.B #1,D2
	LEA WKSPACE,A0
DBLKLP:	MOVE.B #29,CX		
	MOVE.B D2,CY
	MOVE.B (A2,D1.W),D0
	BSR DECODE
	BSR PRINT
	BSR ASCINC
	CMPI.B #$FF,D0
	BEQ BLNKNXT
	ADDQ #1,D1
	ADDQ #1,D2
	CMPI.B #24,D2
	BEQ DBLKEX
	CMPI.B #$FE,D1
	BNE DBLKLP

BLNKRES:LEA BLANKL,A0
	MOVE.B #29,CX
	MOVE.B D2,CY
	BSR PRINT
	BSR ASCINC
BLNKNXT:ADDQ #1,D2
	CMPI.B #24,D2
	BNE BLNKRES
	
DBLKEX:	MOVEM.L (A7)+,D0-D2/A0-A2
	RTS

ASCINC:	MOVE.L WKSPACE,(A1)+
	MOVE.L WKSPACE+4,(A1)+
	RTS

BLKASC:	BLK.B 23*8,$20

********** BLOCK EDITOR **********

CURBLK:	DC.W 0
BLKROW:	DC.W 0
BLKTOP:	DC.W 0
BLKCOL:	DC.W 0
VADDR:	DC.L 0
TADDR:	DC.L 0

BLKEDIT:CLR.L CURBLK
	CLR.L BLKTOP
	MOVE.W CURV,D0
	CLR.L D1
	MOVE.W D0,D1
	LSL.W #8,D0
	LEA TRK0,A1
	ADD.L D0,A1
	ASL.W #1,D1
	LEA TR0P,A0
	MOVE.W (A0,D1.W),D1
	ADD.L D1,A1
	MOVE.W TROFF,D0
	MOVE.B (A1,D0.W),D0
	ANDI.W #$FF,D0
	MOVE.W D0,CURBLK
	CMPI.W #$40,D0
	BLT BLKVLOK
	BRA MAINLP

BLKVLOK:MOVE.W CURBLK,D0
	CLR.W D1
	BSR DISPBLK

BLLOOPA:BSR BLKCUR
	MOVE.W CX,D3	; SAVE CURRENT CX.B+CY.B
	MOVE.W BLKTOP,D0
	ADD.W BLKROW,D0
	BSR HXCONV
	LEA HX,A0
	MOVE.W #35*256+24,CX
	BSR PRINT
	MOVE.W D3,CX

BLLOOP:	BSR GET
	TST.B D0
	BEQ BLLOOP
	CMPI.B #27,D0	; ESCAPE ALSO EXITS BLOCK EDITOR
	BEQ BLEX
	CMPI.B #"*",D0
	BEQ BLEX
	CMPI.B #29,D0
	BEQ BLKLEFT
	CMPI.B #127,D0	; DEL=DELETE LINE...
	BEQ BLKDEL
	CMPI.B #8,D0	; BACKSPACE=LEFT
	BEQ BLKLEFT
	CMPI.B #28,D0
	BEQ BLKRITE
	CMPI.B #13,D0
	BEQ BENTER
	CMPI.B #10,D0	; SHIFT-ENTER=INSERT
	BEQ BINSERT
	CMPI.B #31,D0
	BEQ BENTER	; ACTUALLY DOWN...
	CMPI.B #30,D0
	BEQ BUP	
	CMPI.B #"?",D0	; COPY COMMAND...
	BEQ BCOPY
	CMPI.B #"!",D0	; PASTE FROM BUFFER...
	BEQ BPASTE
	CMPI.B #135,D0
	BEQ BLMON
	CMPI.B #136,D0
	BEQ BLMCON
	CMPI.B #137,D0
	BEQ BLMOFF
	BTST #7,D0
	BNE BLLOOP
	BRA BACCEPT

********** MUSIC ON/OFF IN BLOCK EDIT **********

BLMON:	JSR MUSOFF
	JSR MUSON
	BRA BLLOOP

BLMCON:	JSR MUSOFF
	JSR MUSCON
	BRA BLLOOP

BLMOFF:	JSR MUSOFF
	BRA BLLOOP

********** ? AND ! COMMANDS **********

BCOPY:	MOVE.W CURBLK,D0
	ANDI.L #$3F,D0
	LSL.L #8,D0
	LEA BLOX,A0
	ADD.L D0,A0
	LEA BLOKEND,A1
BCOPA:	MOVE.W #$FF,D0
BCLOOP:	MOVE.B (A0)+,(A1)+
	DBF D0,BCLOOP
	MOVE.W #$0FFF,$DFF180
	CLR.W BLKTOP
	CLR.W BLKROW
	CLR.W BLKCOL
	BRA BLKVLOK

BPASTE: MOVE.W CURBLK,D0
	ANDI.L #$3F,D0
	LSL.L #8,D0
	LEA BLOKEND,A0
	LEA BLOX,A1	
	ADD.L D0,A1
	BRA BCOPA

BLKCUR:	MOVE.W BLKROW,D0		
	ADDQ.W #1,D0
	MOVE.B D0,CY
	MOVE.W BLKCOL,D0
	ADDI.W #29,D0
	MOVE.B D0,CX
	BSR CURSOR
	LEA BLOX,A0
	CLR.L D0
	MOVE.W CURBLK,D0
	ASL.W #8,D0
	ADD.L D0,A0
	MOVE.W BLKTOP,D0
	ADD.L D0,A0
	MOVE.W BLKROW,D0
	ADD.L D0,A0
	MOVE.L A0,VADDR
	LEA BLKASC,A0
	MOVE.W BLKROW,D0
	ASL.W #3,D0
	ADD.L D0,A0	
	MOVE.L A0,TADDR
	RTS

BLEX:	BSR BLKCUR
	BSR ENCODE
	BRA MAINLP	

BLKRITE:BSR CURSOR
	ADDI.W #1,BLKCOL
BLKRTE2:ANDI.W #7,BLKCOL
	BRA BLLOOPA	

BLKLEFT:BSR CURSOR
	SUBI.W #1,BLKCOL
	BRA BLKRTE2

BACCEPT:LEA TADDR,A0
	MOVE.L (A0),A0
	MOVE.W BLKCOL,D1
	MOVE.B D0,(A0,D1.W)
	ANDI.W #$3F,D0
	BSR PRCH
	ADDI.W #1,BLKCOL
	ANDI.W #7,BLKCOL	
	MOVE.W BLKCOL,D1
	ADDI.W #29,D1
	MOVE.B D1,CX
	BRA BLLOOPA

HEXBENC:LEA HEX,A1
	MOVEQ #15,D2
HEXFND:	CMP.B (A1,D2.W),D0
	BEQ HXBFD
	SUBQ #1,D2
	TST.B D2
	BNE HEXFND
HXBFD:	RTS

HEXENC:	MOVE.B 5(A0),D0
	BSR HEXBENC
	MOVE.B D2,D3
	ANDI.B #$0F,D3
	MOVE.B 4(A0),D0
	BSR HEXBENC
	ASL.W #4,D2
	OR.W D3,D2
	ANDI.W #$3F,D2
	RTS

ENCLEG:	DC.W 0

ENCODE:	CLR.W ENCLEG
	LEA TADDR,A0
	MOVE.L (A0),A0
	BSR HEXENC	; D2=HEX VAL...
	MOVE.B (A0),D0	
	CMPI.B #"*",D0
	BEQ ENCEND
	LEA MNOT,A2
	LEA MNOT2,A3
	CLR.L D1
	MOVE.W D2,D3
SRCHNOT:MOVE.B (A2)+,D2
	CMP.B (A0),D2
	BNE NXTNOTE
	MOVE.B (A3)+,D2
	CMP.B 1(A0),D2
	BEQ FNDNOTE
NXTNOTE:MOVE.W D3,D2
	ADDI.B #1,D1
	CMPI.B #13,D1
	BNE SRCHNOT
	MOVE.B (A0),D0
	CMPI.B #"T",D0
	BEQ ARPENC
	CMPI.B #"D",D0
	BEQ DURENC
	CMPI.B #"S",D0
	BEQ SNDENC
	CMPI.B #"M",D0
	BEQ GLDENC
	ST ENCLEG
ENCEND:	MOVE.B #$FF,D2
	RTS

FNDNOTE:MOVE.B 2(A0),D2
	ANDI.L #3,D2
	MULU #12,D2
	ADD.B D1,D2
	BRA ENCEX

ARPENC:	ANDI.W #$0F,D2
	ADDI.W #$70,D2
	BRA ENCEX
DURENC:	ADDI.W #$80,D2
	BRA ENCEX
SNDENC:	ADDI.W #$C0,D2
	CMPI.B #$FF,D2
	BNE ENCEX
	MOVE.B #$FE,D2
	BRA ENCEX
GLDENC:	ADDI.W #$30,D2
ENCEX:	MOVE.L VADDR,A0
	MOVE.B D2,(A0)
	RTS

BENTER:	MOVE.W D0,D4
	BSR ENCODE
	LEA BLOX,A0
	CLR.L D0
	MOVE.W CURBLK,D0
	ASL.W #8,D0
	ADD.L D0,A0	
	MOVE.W BLKTOP,D0
	ADD.W BLKROW,D0
	TST.W ENCLEG
	BEQ BLKSLEG
	CMPI.B #$FF,1(A0,D0.W)
	BNE BENTBYP
	BRA BENTOK	
BLKSLEG:CMPI.B #$FF,D2
	BEQ BENTOK
BENTBYP:ADDI.W #1,BLKROW
	CMPI.W #23,BLKROW
	BNE BENTOK
	MOVE.W #22,BLKROW
	ADDI.W #1,BLKTOP
	CMPI.W #255-23,BLKTOP
	BNE BENTOK
	MOVE.W #255-24,BLKTOP
BENTOK:	LEA BLOX,A0
	CLR.L D0
	MOVE.W CURBLK,D0
	ASL.W #8,D0
	ADD.L D0,A0
	MOVE.W #$FFFF,$FE(A0)
	MOVE.W CURBLK,D0
	MOVE.W BLKTOP,D1		
	BSR DISPBLK
	CMPI.B #31,D4
	BEQ BLLOOPA
	CLR.W BLKCOL
	BRA BLLOOPA
	
BUP:	TST.W BLKROW
	BNE BUP2
	TST.W BLKTOP
	BEQ BLLOOP
BUP2:	BSR ENCODE
	SUBQ.W #1,BLKROW
	BPL BENTOK
	CLR.W BLKROW
	SUBQ.W #1,BLKTOP
	BPL BENTOK
	CLR.W BLKTOP
	BRA BENTOK

BINSERT:BSR ENCODE
	LEA BLOX,A0
	CLR.L D0
	MOVE.W CURBLK,D0
	ASL.W #8,D0
	ADD.L D0,A0
	MOVE.W BLKTOP,D0
	ADD.W BLKROW,D0
	CMPI.W #$FC,D0
	BGT INSEX
	MOVE.W #$FD,D1
INSLOOP:MOVE.B -1(A0,D1.W),0(A0,D1.W)
	SUBQ #1,D1
	CMP.B D0,D1
	BNE INSLOOP
	MOVE.W CURBLK,D0
	MOVE.W BLKTOP,D1
	BSR DISPBLK
INSEX:	MOVE.W #$FFFF,$FE(A0)
	CLR.W BLKCOL
	BRA BLLOOPA

BLKDEL:	LEA BLOX,A0
	CLR.L D0
	MOVE.W CURBLK,D0
	ASL.W #8,D0
	ADD.L D0,A0
	MOVE.W #$FFFF,$FE(A0)
	MOVE.W BLKTOP,D0
	ADD.W BLKROW,D0
BLKDELP:MOVE.B 1(A0,D0.W),(A0,D0.W)
	ADDQ #1,D0
	CMPI.B #$FE,D0
	BNE BLKDELP
	CLR.W BLKCOL		
	MOVE.W CURBLK,D0
	MOVE.W BLKTOP,D1
	BSR DISPBLK
	BRA BLLOOPA

********** INPUT A STRING OF D0.B CHARS INTO INBUFF **********
**********    LEN OF STRING IS RETURNED IN D0.B     **********

INBUFF:	BLK.B 256,0
INPUT:	MOVEM.L D1-D2/A0/A6,-(A7)
	MOVE.L 4,A6
	JSR -132(A6)
	MOVE.B D0,D1
	ANDI.W #$FF,D1
	MOVE.W #$FF,D0
	LEA INBUFF,A0
INCLR:	CLR.B (A0,D0.W)
	DBF D0,INCLR
	CLR.L D2
INLB:	BSR CURSOR
INLA:	BSR GET
	ANDI.W #$FF,D0
	TST.B D0
	BEQ INLA
	CMPI.B #8,D0
	BEQ INDEL
	CMPI.B #127,D0
	BEQ INDEL
	CMPI.B #13,D0
	BEQ INRET
	CMPI.B #10,D0
	BEQ INRET
	CMPI.W #$20,D0
	BLT INLA
	CMPI.W #$5F,D0
	BGT INLA
	MOVE.B D0,(A0,D2.W)
	ANDI.B #$3F,D0
	BSR PRCH
	BSR INCCXCY
	ADDQ #1,D2
	CMP.B D2,D1
	BNE INLB
	BSR DECCXCY
	SUBI #1,D2
	BRA INLB
INDEL:	TST.B D2
	BEQ INLA
	BSR CURSOR
	MOVE.B #$20,D0
	BSR PRCH
	SUBI.W #1,D2
	CLR.B (A0,D2.W)
	CLR.B -1(A0,D1.W)
	BSR DECCXCY
	MOVE.B #$20,D0
	BSR PRCH
	BRA INLB

DECCXCY:SUBI.B #1,CX
	BPL DECCXOK
	MOVE.B #39,CX
	SUBI.B #1,CY
	BPL DECCXOK
	CLR.B CY
DECCXOK:RTS

INCCXCY:ADDI.B #1,CX
	CMPI.B #40,CX
	BNE INCCXOK
	CLR.B CX
	ADDI.B #1,CY
	CMPI.B #25,CY
	BNE INCCXOK
	MOVE.B #24,CY
	BSR SCROLL
INCCXOK:RTS

INRET:	BSR CURSOR
	MOVE.W D2,D0
	MOVE.L 4,A6
	JSR -138(A6)
	MOVEM.L (A7)+,D1-D2/A0/A6
	RTS
	
********** LOADER MAIN MENU **********

LDRMESS:DC.B "       -=MODULES AND DATAS I/O=-",13,13
	DC.B "A) LOAD SONG DATAS",13
	DC.B "B) LOAD IFF DIGI INSTRUMENTS",13
	DC.B "C) LOAD FC MODULE (DATA + DIGI)",13
	DC.B "D) DIRECTORY",13
	DC.B "E) SAVE FC MODULE (DATA + DIGI)",13
	DC.B "F) DELETE FILE",13
	DC.B "G) DELETE DIGI IN MEMORY",13
	DC.B "H) MAKEDIR",13
	DC.B "I) CLEAR ALL DATAS",13
	DC.B "J) DISPLAY DIGIS IN MEMORY",13
	DC.B "K) SAVE SONG DATAS",13
	DC.B "L) EXIT TO MAIN MENU",13,13
	DC.B "----------------------------------------",13
	DC.B "IF THE COMPUTER SEEMS TO LOCK UP AFTER",13
	DC.B "YOU ENTER A FILENAME, PRESS LEFT AMIGA-B"
	DC.B "THEN LEFT AMIGA-V AND WAIT FOR A FILE",13
	DC.B "ERROR OR SOME OTHER MESSAGE...",13,13
	DC.B "----------------------------------------",13
	DC.B "                       (W)1990 BSI LABS",0

	EVEN

LDRMENX:MOVE.L GRBAS,A6
	JSR -462(A6)
	move.l 4,a6
	jsr -138(a6)

LDRMENU:BSR CLS
	LEA LDRMESS,A0
	BSR PRINT
LMGET:	BSR GET
	CMPI.B #"K",D0
	BEQ SAVDAT
	CMPI.B #"J",D0
	BEQ DIGDSP
	CMPI.B #"D",D0
	BNE LMCT
	JMP DIRECT

********** SAVE DATAS **********

SAVDAT:	BSR CLS
	LEA FILEMES,A0
	BSR PRINT
	MOVE.B #79,D0
	BSR INPUT
	TST.B D0
	BEQ LDRMENU
	LEA RETCHAR,A0
	BSR PRINT
	
	MOVE.L DBASE,A5
	MOVE.L #INBUFF,D1
	MOVE.L #1006,D2
	JSR -30(A5)
	MOVE.L D0,DLHAND

	TST.L D0
	BEQ SVDERRA

	MOVE.L DLHAND,D1
	MOVE.L #DATSTRT,D2
	MOVE.L #$4404,D3
	JSR -48(A5)
	CMPI.L #$4404,D0
	BNE SVDERR

	MOVE.L DLHAND,D1
	JSR -36(A5)

	LEA SVDOK,A0
SVDWT:	BSR PRINT
	BSR SPACEWT
	BRA LDRMENU

SVDOK:	DC.B 13,13,"*** DATAS SAVED OK! PRESS SPACE... ***",0
SVDM:	DC.B 13,13,"*** ERROR IN SAVE! PRESS SPACE... ***",0
	EVEN

SVDERR:	MOVE.L DLHAND,D1
	JSR -36(A5)
SVDERRA:LEA SVDM,A0
	BRA SVDWT

********** DISPLAY DIGIS LOADED IN MEMORY... **********

DIGDSPM:DC.B "PRESS ENTER KEY TO PAUSE/UNPAUSE...",13,13
	DC.B "HEX  NAME  BODY LEN  STRTLOOP  REPEATLP",13
	DC.B "---  ----  --------  --------  --------",13,0
	EVEN

DIGDSP:	BSR CLS
	LEA DIGDSPM,A0
	BSR PRINT
	LEA DIGBLOK,A1
	MOVE.W #$00,D1
DILOOP:	MOVE.L (A1),D0
	TST.L D0
	BEQ NXDIL
	BSR GET
	CMPI.B #13,D0
	BNE SPEX
SPWT:	BSR GET
	CMPI.B #13,D0
	BEQ SPWT
SPWTA:	BSR GET
	CMPI.B #13,D0
	BNE SPWTA
SPWTB:	BSR GET
	CMPI.B #13,D0
	BEQ SPWTB
SPWTC:	BSR GET
	TST.B D0
	BNE SPWTC

SPEX:	MOVE.W #32767,D0
DI2LP:	DBF D0,DI2LP
	CLR.L D0
	MOVE.B D1,D0
	BSR LONGCON
	LEA LONG+5,A0
	BSR PRINT
	LEA LONG+4,A0
	MOVE.L (A1),(A0)
	MOVE.B #5,CX
	BSR PRINT
	MOVE.B #11,CX
	MOVE.L 4(A1),D0
	BSR LONGCON
	LEA LONG,A0
	BSR PRINT
	MOVE.B #21,CX
	MOVE.L 8(A1),D0
	BSR LONGCON
	BSR PRINT
	MOVE.B #31,CX
	MOVE.L 12(A1),D0
	BSR LONGCON
	BSR PRINT
	LEA RETCHAR,A0
	BSR PRINT
NXDIL:	ADDI.L #16,A1
	ADDQ #1,D1
	CMPI.B #$3F,D1
	BNE DILOOP
	LEA PRSP,A0
	BSR PRINT
	BSR SPACEWT
	BRA LDRMENU
PRSP:	DC.B 13,"PRESS SPACE TO GO ON...",0
	EVEN

LMCT:	CMPI.B #"L",D0
	BEQ LDRMEX
	CMPI.B #"A",D0
	BEQ DATLDR
	CMPI.B #"B",D0
	BEQ LOADIFF
	CMPI.B #"E",D0
	BEQ SAVMOD
	CMPI.B #"G",D0
	BEQ DELMOD
	CMPI.B #"F",D0
	BEQ DELFILE
	CMPI.B #"H",D0
	BEQ MAKEDIR
	CMPI.B #"C",D0
	BEQ LOADMOD
	CMPI.B #"I",D0
	BEQ CLRALL
	BRA LMGET

LDRMEX:	MOVE.L GRBAS,A6
	JSR -30-426(A6)
	MOVE.L 4,A6
	JSR -30-102(A6)

MOTROFF:ORI.B #$88,$BFD100
	ANDI.B #$87,$BFD100
	ORI.B #$78,$BFD100
	BRA MENU

********** DATAS LOADER **********

FILEMES:DC.B "DRIVE:DRAWER/FILENAME",13,">",0
	EVEN
FILENF:	DC.B "*** FILE NOT FOUND! ***",13
	DC.B "     (PRESS SPACE)",0
	EVEN

NOTFUCO:DC.B "*** NOT A FUCO DATA FILE! ***",13
	DC.B "        (PRESS SPACE)",0
	EVEN

FUCFINI:DC.B "DATAS LOADED, PRESS SPACE...",0
	EVEN

DLHAND:	DC.L 0

DATLDR:	BSR CLS
	LEA FILEMES,A0
	BSR PRINT
	MOVE.B #79,D0
	BSR INPUT
	TST.B D0
	BEQ LDRMENU
	LEA RETCHAR,A0
	BSR PRINT

	MOVE.L DBASE,A5
	MOVE.L #INBUFF,D1
	MOVE.L #1005,D2
	JSR -30(A5)
	MOVE.L D0,DLHAND
	TST.L D0
	BNE DLFOUND

	LEA FILENF,A0
	BSR PRINT
	BSR SPACEWT
	BRA LDRMENU

DLFOUND:MOVE.L DLHAND,D1
	MOVE.L #INBUFF,D2
	MOVE.L #4,D3
	JSR -42(A5)
	CMPI.L #"FUCO",INBUFF
	BEQ ISADL
	
NOFU:	LEA NOTFUCO,A0
CLOFU:	BSR PRINT
	BSR SPACEWT	
	MOVE.L DLHAND,D1
	JSR -36(A5)
	BRA LDRMENU

ISADL:	MOVE.L DLHAND,D1
	MOVE.L #TRK0,D2
	MOVE.L #$4400,D3
	JSR -42(A5)	
	TST.L D0
	BEQ ISAOK
	MOVE.L D0,$A0000
	CMPI.W #$4400,D0
	BNE NOFU
ISAOK:	LEA FUCFINI,A0
	BRA CLOFU
	BRA LMGET

********** MALLOC/DALLOC DIGI MANAGER **********
********* D2=SOUND # TO ALLOC, D3=LEN. *********

ALLOLEN:DC.L 0
SNDNR:	DC.W 0
MEMTAB:	BLK.L 128,0
MALLOC:	MOVEM.L D4-D7/A0-A6,-(A7)
	BSR DALLOC
	MOVE.L D3,D0
	MOVE.L D3,ALLOLEN
	MOVE.W D2,SNDNR
	MOVEQ #2,D1
	MOVE.L 4,A6
	JSR -198(A6)
	MOVE.W SNDNR,D2
	ANDI.W #$3F,D2
	ASL.W #3,D2
	LEA MEMTAB,A0
	MOVE.L D0,(A0,D2.W)
	MOVE.L ALLOLEN,4(A0,D2.W)
	MOVEM.L (A7)+,D4-D7/A0-A6
	RTS

DALLOC:	MOVEM.L D0-D7/A0-A6,-(A7)
	ANDI.L #$3F,D2
	MOVE.L D2,D3	
	LEA DIGBLOK,A1
	ASL.W #4,D3
	ADD.L D3,A1
	CLR.L (A1)+
	CLR.L (A1)+
	CLR.L (A1)+
	CLR.L (A1)+

	ASL.W #3,D2
	LEA MEMTAB,A0
	MOVE.L (A0,D2.W),A1
	CMPI.L #0,A1
	BEQ DFREE
	MOVE.L 4(A0,D2.W),D0
	MOVE.L 4,A6
	JSR -210(A6)
DFREE:	LEA MEMTAB,A0
	CLR.L (A0,D2.W)
	CLR.L 4(A0,D2.W)
	MOVEM.L (A7)+,D0-D7/A0-A6
	RTS

********** LOAD IFF DIGI SECTION **********

LNAM:	DC.L 0
LBOD:	DC.L 0
LSTR:	DC.L 0
LREP:	DC.L 0
LSND:	DC.L 0

LIFFDMS:DC.B "          -=LOAD IFF DIGI=-",13,13
	DC.B "DRIVE:DRAWER/FILENAME",13
	DC.B ">",13,13,13,13
	DC.B "----------------------------------------"
	DC.B "SOUND NR  :   (USE 00-3E)",13
	DC.B "HEADER    :",13
	DC.B "CREATED IN:",13
	DC.B "SOUND NAME:",13
	DC.B "BODY LEN  :",13
	DC.B "START LOOP:",13
	DC.B "REPEAT LEN:",13
	DC.B "----------------------------------------",0
	EVEN
IFFHAN:	DC.L 0

LOADIFF:BSR CLS
	LEA LIFFDMS,A0
	BSR PRINT
	MOVE.W #$0103,CX
	MOVE.W #119,D0
	BSR INPUT
	TST.B D0
	BEQ LDRMENU
	
	MOVE.L #INBUFF,D1
	MOVE.L #1005,D2
	MOVE.L DBASE,A6
	JSR -30(A6)
	MOVE.L D0,IFFHAN
	TST.L D0
	BEQ NIFFFIL
	
	MOVE.L IFFHAN,D1
	MOVE.L #FILEINF,D2
	MOVE.L #$100,D3
	JSR -42(A6)

	CMPI.L #"FORM",FILEINF
	BNE NIFFFIL
	CLR.B FILEINF+16
	LEA FILEINF+8,A0
	JSR UCASER
	MOVE.W #$0B09,CX
	BSR PRINT
	CMPI.L #"8SVX",FILEINF+8	
	BNE NIFFFIL
	MOVE.L FILEINF+$14,D0	
	MOVE.L D0,LSTR
	BSR LONGCON
	LEA LONG,A0
	MOVE.W #$0B0D,CX
	BSR PRINT
	MOVE.L FILEINF+$18,D0
	MOVE.L D0,LREP
	BSR LONGCON
	MOVE.W #$0B0E,CX
	BSR PRINT	
	
	MOVE.L #"ANNO",D1			
	BSR SRCHFOR	
	CMPI.L #$00,A0
	BEQ EXIFNAM
	JSR UCASER
	MOVE.W #$0B0A,CX
	BSR PRINT

EXIFNAM:MOVE.L #"NAME",D1
	BSR SRCHFOR
	CMPI.L #$00,A0
	BEQ FETBODY
	JSR UCASER
	MOVE.L (A0),LNAM
	MOVE.W #$0B0B,CX
	BSR PRINT

FETBODY:MOVE.L #"BODY",D1
	BSR SRCHFOR
	CMPI.L #$00,A0
	BEQ NIFFFIL
	MOVE.W D0,D2	
	ANDI.L #$FF,D2
	MOVE.L #-1,D3
	MOVE.L IFFHAN,D1
	JSR -66(A6)

	MOVE.L #FILEINF,D2	; READ "BODY",LEN.L
	MOVE.L #$08,D3	
	MOVE.L IFFHAN,D1
	JSR -42(A6)

	MOVE.L FILEINF+4,D0
	MOVE.L D0,LBOD
	BSR LONGCON
	LEA LONG,A0
	MOVE.W #$0B0C,CX
	BSR PRINT

	MOVE.B #2,D0
	MOVE.W #$0B08,CX
	BSR INPUT
	MOVE.W #$0011,CX
	BSR CONVSTR
	ANDI.L #$3F,D0
	CMPI.B #$3F,D0
	BNE IFNO3F
	MOVE.B #$3E,D0
IFNO3F:	MOVE.B D0,D2
	MOVE.L D0,LSND
	MOVE.L FILEINF+4,D3
	CMPI.L #$20000,D3
	BGT TOOLONG
	BSR MALLOC
	TST.L D0
	BEQ NOMEM

	MOVE.L FILEINF+4,D3
	MOVE.L D0,D2
	MOVE.L IFFHAN,D1	
	JSR -42(A6)
	MOVE.L IFFHAN,D1
	JSR -36(A6)
	LEA IFLDOK,A0
	BSR PRINT

	LEA DIGBLOK,A0	
	MOVE.L LSND,D0
	ASL.W #4,D0
	ADD.L D0,A0
	MOVE.L LNAM,(A0)+
	MOVE.L LBOD,(A0)+
	MOVE.L LSTR,(A0)+
	MOVE.L LREP,(A0)+

	BSR SPACEWT
	BRA LDRMENU

IFLDOK:	DC.B "*** SOUND LOADED OK ***",13
	DC.B "PRESS SPACE...",0

NOMEMMS:DC.B "*** NOT ENOUGH MEMORY FOR SOUND ***",13
	DC.B "PRESS SPACE...",0

TOOMESS:DC.B "*** SOUND IS TOO LONG: >$20000 BYTES ***"
	DC.B "PRESS SPACE...",0
	EVEN

NOMEM:	LEA NOMEMMS,A0
NOMEMA:	BSR PRINT
	BRA CLOSIFF

TOOLONG:LEA TOOMESS,A0
	BRA NOMEMA

********** D1=4 CHAR IDT TO SEARCH FOR IN IFF FILE **********
********** A0 RETURNS WHERE. NULL=NOT FOUND **********

SRCHFOR:LEA FILEINF,A0
	CLR.L D0
SRCHLPA:CMP.L (A0,D0.W),D1
	BEQ FNDSRCH	
	ADDQ #2,D0
	CMPI.L #$100,D0
	BNE SRCHLPA
	MOVE.L #0,A0
	RTS
FNDSRCH:ADD.L D0,A0
	ADDQ.L #8,A0
	RTS

NIFFFMS:DC.B "*** NOT AN IFF SOUND FILE! ***",13
	DC.B "PRESS SPACE...",0

NIFFFIL:LEA NIFFFMS,A0
	MOVE.W #$0011,CX
	BSR PRINT
	TST.L IFFHAN
	BEQ NIFCLEX
CLOSIFF:MOVE.L IFFHAN,D1
	MOVE.L DBASE,A6
	JSR -36(A6)
NIFCLEX:JSR SPACEWT
	BRA LOADIFF

********** CONVERT INBUFF STRING TO HEX IN D0.L **********

CONVSTR:MOVEM.L D1-D3/A0-A1,-(A7)
	CLR.L D0
	CLR.L D1
	LEA INBUFF,A0
	LEA HEX,A1
CVMAIN:	TST.B (A0,D1.B)
	BEQ CVSEX
	LSL.L #4,D0
	MOVE.B (A0,D1.B),D2
	CLR.L D3
CVSHXLP:CMP.B (A1,D3.B),D2
	BEQ CVSHXFD
	ADDQ #1,D3
	CMPI.B #$10,D3
	BNE CVSHXLP
	CLR.B D3
CVSHXFD:ADD.L D3,D0
	ADDI.W #1,D1
	BRA CVMAIN
CVSEX:	MOVEM.L (A7)+,D1-D3/A0-A1
	RTS

********** REMOVE KEYSTROKES **********

VOIDHAN:DC.L 0
VNAME:	DC.B "CON:0/0/127/10/The Void",0
	EVEN

VOPEN:	MOVE.L DBASE,A6
	MOVE.L #VNAME,D1
	MOVE.L #1005,D2
	JSR -30(A6)
	MOVE.L D0,VOIDHAN
	RTS	

VCLOSE:	MOVE.L DBASE,A6
	MOVE.L VOIDHAN,D1
	JSR -36(A6)
	RTS

********** DO THE GREETINGS **********

DOGREET:BSR CLS
	LEA GRMESS,A0
	BSR PRINT
	BSR SPACEWT
	BRA MENU

GRMESS:	DC.B "GREETINGS TO...",13
	DC.B "---------------",13,13
	DC.B "UNCLE INDY AND LORD FLASH-HEART OF THE",13
	DC.B "AMIGA PRIVATEERS SOCIETY, SLOWHAND OF",13
	DC.B "ICE, THE OWL (NIGEL IN OZ!), PILGRIM,",13
	DC.B "HCE OF ELF, MERLIN AT GENERAL,",13
	DC.B "DRAGONFLY AT THE DISMAL SWAMP, AND",13
	DC.B "PSYCHOPATH OF SPECTRE IN SWEDEN!",13,13
	DC.B "MANY THANKS TO THE AMIGA FOR BEING THE",13
	DC.B "GREAT COMPUTER THAT IT IS! FLUSH THOSE",13
	DC.B "UPGRADED IBM AMIGA-WANNA-BE'S DOWN THE",13
	DC.B "SEWER SYSTEM!",13,13
	DC.B "REMEMBER- A DIRTY MIND IS A TERRIBLE",13
	DC.B "THING TO WASTE!",13,13
	DC.B "                       -SLATES FROM BSI!",13
	DC.B "(HIT THE LONG ONE...)",0
	EVEN 

********** SAVE A MODULE **********

SVMDMES:DC.B "SAVE MEMORY AS A FC MODULE...",13
	DC.B "DRIVE:DRAWER/FILE",13,">",0

SVMERRR:DC.B 13,13,"*** FILE ERROR ***",13
	DC.B "PRESS SPACE...",0
	EVEN
SHAND:	DC.L 0
CURMODN:DC.W 0

SAVMOD:	BSR CLS
	LEA SVMDMES,A0
	BSR PRINT
	MOVE.B #79,D0
	BSR INPUT
	TST.B D0
	BEQ LDRMENU

	MOVE.L DBASE,A6
	MOVE.L #INBUFF,D1
	MOVE.L #1006,D2
	JSR -30(A6)
	MOVE.L D0,SHAND
	TST.L D0
	BEQ SVMERRD

	MOVE.L SHAND,D1
	MOVE.L #DATSTRT,D2
	MOVE.L #BLOKEND-DATSTRT,D3
	JSR -48(A6)
	TST.L D0
	BMI SVMERRD
		
	CLR.W CURMODN		
FETLP:	MOVE.W CURMODN,D2
	BSR FETBUFF
	TST.L D3
	BEQ NXTFETH
	MOVE.L DBASE,A6
	MOVE.L SHAND,D1
	JSR -48(A6)
	TST.L D0
	BMI SVMERRD
NXTFETH:ADDI.W #1,CURMODN
	CMPI.W #$3F,CURMODN
	BNE FETLP
	LEA MODSVOK,A0
	BSR PRINT
	BRA CLOSVM

MODSVOK:DC.B 13,13,"MODULE SAVED OK, PRESS SPACE...",0
	EVEN

SVMERRD:LEA SVMERRR,A0
	BSR PRINT
	TST.L SHAND
	BEQ NOSVMCL
CLOSVM:	MOVE.L SHAND,D1
	JSR -36(A6)
NOSVMCL:BSR SPACEWT
	BRA LDRMENU

***** FETCH BUFFER(D2),LEN(D3)WHEN SOUNDNR IS IN D2 *****

FETBUFF:MOVE.L A0,-(A7)
	LEA MEMTAB,A0
	ANDI.L #$3F,D2
	ASL.W #3,D2
	ADD.L D2,A0
	MOVE.L (A0),D2
	MOVE.L 4(A0),D3
	MOVE.L (A7)+,A0
	RTS

********** DELETE A DIGI IN RAM **********

DELMDTX:DC.B "DELETE A DIGI SOUND IN RAM:",13
	DC.B "ENTER 00-3E FOR SOUND TO DELETE",13,">",0

DELMDTY:DC.B 13,13,"THE SOUND HAS BEEN DELETED.",13
	DC.B "PRESS THE LONG BEIGE BAR...",0

DELMOD:	BSR CLS
	LEA DELMDTX,A0
	BSR PRINT
	MOVE.B #2,D0
	BSR INPUT
	TST.B D0
	BEQ LDRMENU
	BSR CONVSTR
	MOVE.L D0,D2
	BSR DALLOC
	LEA DELMDTY,A0
	BSR PRINT
	BSR SPACEWT
	BRA LDRMENU

********** DELETE A FILE ON ANY DEVICES... **********

DELMESS:DC.B "DELETE A FILE:",13
	DC.B "USE DRIVE:DRAWER/FILE",13,">",0

DELMOK:	DC.B 13,13,"FILE WAS DELETED. PRESS SPACE...",0
DELERR:	DC.B 13,13,"*** FILE ERROR ***",13
	DC.B       "   PRESS SPACE!",0
	EVEN

DELFILE:BSR CLS
	LEA DELMESS,A0
	BSR PRINT
	MOVE.B #79,D0
	BSR INPUT
	TST.B D0
	BEQ LDRMENU
	
	MOVE.L DBASE,A6
	MOVE.L #INBUFF,D1
	JSR -72(A6)
	TST.L D0
	BEQ DELMERR
	LEA DELMOK,A0
	BRA DELPR
DELMERR:LEA DELERR,A0
DELPR:	BSR PRINT
	BSR SPACEWT
	BRA LDRMENU

********** MAKEDIR **********

MDMESS:	DC.B "CREATE A SUBDIRECTORY (AKA MAKEDIR):",13
	DC.B ">",0

MDMOK:	DC.B 13,13,"DIRECTORY WAS CREATED. PRESS SPACE.",0
MDMERR:	DC.B 13,13,"OPERATION FAILED.  PRESS SPACE.",0
	EVEN

MAKEDIR:BSR CLS
	LEA MDMESS,A0
	BSR PRINT
	MOVE.B #79,D0
	BSR INPUT
	TST.B D0
	BEQ LDRMENU
	MOVE.L DBASE,A6
	MOVE.L #INBUFF,D1
	JSR -120(A6)
	TST.L D0
	BEQ MDER
	LEA MDMOK,A0
	BRA DELPR
MDER:	LEA MDMERR,A0
	BRA DELPR

********** LOAD A FC MODULE **********

LDFCM:	DC.B "LOAD A FC MODULE...",13
	DC.B "DRIVE:DRAWER/FILENAME",13,">",0

LDERR:	DC.B 13,13,"*** NOT A FC MODULE OR CORRUPTED ***",13
	DC.B       "            PRESS SPACE!",0
           
LDNF:	DC.B 13,13,"FILE NOT FOUND. PRESS SPACE.",0
	EVEN
LDHAN:	DC.L 0
MALSAV:	BLK.B 16,0

LOADMOD:BSR CLS
	LEA LDFCM,A0
	BSR PRINT
	MOVE.B #79,D0
	BSR INPUT
	TST.B D0
	BEQ LDRMENU

	MOVE.L DBASE,A6
	MOVE.L #INBUFF,D1
	MOVE.L #1005,D2
	JSR -30(A6)
	MOVE.L D0,LDHAN
	TST.L D0
	BNE LDFOUND

	LEA LDNF,A0
	BSR PRINT
	BSR SPACEWT
	BRA LDRMENU

LDFOUND:MOVE.L LDHAN,D1
	MOVE.L #FILEINF,D2
	MOVE.L #4,D3
	JSR -42(A6)
	TST.L D0
	BPL LDROK

LDRERR:	MOVE.L LDHAN,D1
	JSR -36(A6)
	BSR SPACEWT
	LEA LDERR,A0
	BSR PRINT
	BSR SPACEWT
	BRA LDRMENU

LDROK:	CMPI.L #"FUCO",FILEINF
	BNE LDRERR
	MOVE.L LDHAN,D1
	MOVE.L #$4404,D2
	MOVE.L #-1,D3
	JSR -66(A6)
	MOVE.L LDHAN,D1
	MOVE.L #FILEINF,D2
	MOVE.L #4,D3
	JSR -42(A6)
	CMPI.L #"DIGI",FILEINF
	BNE LDROK
	MOVE.L LDHAN,D1
	MOVE.L #$47F8,D2
	MOVE.L #-1,D3
	JSR -66(A6)
	MOVE.L LDHAN,D1
	MOVE.L #FILEINF,D2
	MOVE.L #4,D3
	JSR -42(A6)
	CMPI.L #"DIGP",FILEINF
	BNE LDROK

	CLR.W CURMODN
DELDLP:	MOVE.W CURMODN,D2
	BSR DALLOC
	ADDI.W #1,CURMODN
	CMPI.W #$3F,CURMODN
	BNE DELDLP

	MOVE.L LDHAN,D1
	CLR.L D2
	MOVE.L #-1,D3
	JSR -66(A6)
	MOVE.L LDHAN,D1
	MOVE.L #DATSTRT,D2
	MOVE.L #$47FC,D3
	JSR -42(A6)

	LEA LDESTAT,A0
	BSR PRINT

	CLR.W CURMODN
INDIGIS:LEA DIGBLOK,A3
	CLR.L D0
	MOVE.W CURMODN,D0
	ASL.W #4,D0
	ADD.L D0,A3
	TST.L (A3)
	BEQ INDIGSK
	MOVE.L (A3),LONG
	CLR.B LONG+4
	LEA LONG,A0
	BSR PRINT
	MOVE.L 4(A3),D0
	BSR LONGCON
	LEA LONG,A0
	MOVE.B #6,CX
	BSR PRINT
	MOVE.L 8(A3),D0
	BSR LONGCON
	LEA LONG,A0
	MOVE.B #16,CX
	BSR PRINT
	MOVE.L 12(A3),D0
	BSR LONGCON
	LEA LONG,A0
	MOVE.B #26,CX
	BSR PRINT
	LEA RETCHAR,A0
	BSR PRINT

	LEA MALSAV,A2
	MOVE.L (A3),(A2)
	MOVE.L 4(A3),4(A2)
	MOVE.L 8(A3),8(A2)
	MOVE.L 12(A3),12(A2)

	MOVE.L 4(A3),D3
	MOVE.W CURMODN,D2
	BSR MALLOC

	MOVE.L (A2),(A3)
	MOVE.L 4(A2),4(A3)
	MOVE.L 8(A2),8(A3)
	MOVE.L 12(A2),12(A3)

	TST.L D0
	BEQ LNOMEML

	MOVE.L LDHAN,D1
	MOVE.L D0,D2
	MOVE.L 4(A3),D3
	JSR -42(A6)
	TST.L D0
	BMI LDRERR

INDIGSK:ADDI.W #1,CURMODN
	CMPI.W #$3F,CURMODN
	BNE INDIGIS

	MOVE.L LDHAN,D1
	JSR -36(A6)
	LEA LDEDOK,A0
	BSR PRINT
	BSR SPACEWT
	BRA LDRMENU

LDEDOK:	DC.B 13,"*** MODULE LOADED OK, PRESS SPACE ***",0
	EVEN

LDESTAT:DC.B 13,13,"NAME  BODY LEN  STRTLOOP  REPEATLP",13
	DC.B "----  --------  --------  --------",13,0
	EVEN

LNOMEMS:DC.B 13,13,"*** OUT OF MEMORY! ***",13
	DC.B       "     PRESS SPACE!",0
	EVEN

LNOMEML:MOVE.L LDHAN,D1
	JSR -36(A6)
	LEA LNOMEMS,A0
	BSR PRINT
	BSR SPACEWT
	BRA LDRMENU

********** CLEAR ALL DATAS **********

CLDMES:	DC.B "CLEAR ALL DATAS IN MEMORY. NOTE THAT",13
	DC.B "ALL TRACK, BLOCK, AND DIGI DATAS WILL",13
	DC.B "BE INCINERATED FROM MEMORY!",0
	EVEN

CLRALL:	BSR CLS
	LEA CLDMES,A0
	BSR PRINT
	LEA ARUSURE,A0
	BSR PRINT
CLRALP:	BSR GET
	TST.B D0
	BEQ CLRALP
	CMPI.B #"Y",D0
	BEQ INCINER
	CMPI.B #"N",D0
	BNE CLRALP
	BRA LDRMENU

INCINER:CLR.W CURMODN
INCINLP:MOVE.W CURMODN,D2
	BSR DALLOC
	ADDI.W #1,CURMODN
	CMPI.W #$3F,CURMODN
	BNE INCINLP

	LEA DIGBLOK,A0
	MOVE.W #1007,D0
DBFIX:	CLR.B (A0)+
	DBF D0,DBFIX

	LEA TRK0,A0
	MOVE.W #1023,D0
TRKCLR:	CLR.B (A0)+
	DBF D0,TRKCLR

	LEA BLOX,A0
	MOVE.W #$3FFF,D0
BLXFIL:	ST (A0)+		; ST IS A BYTE INSTRUCTION!
	DBF D0,BLXFIL
	BRA LDRMENU

*///////// MUSIC DATAS SECTION... \\\\\\\\\*

BPL:	BLK.B 8000,0

TR0P:	DC.W 0
TR1P:	DC.W 0
TR2P:	DC.W 0
TR3P:	DC.W 0

DATSTRT:DC.B "FUCO"
TRK0:	BLK.B 256,0
TRK1:	BLK.B 256,0
TRK2:	BLK.B 256,0
TRK3:	BLK.B 256,0
BLOX:	BLK.B 256*64,$FF

DIGSTRT:DC.B "DIGI"
DIGBLOK:BLK.B 63*16,0
	DC.B "DIGP"
BLOKEND:BLK.B 256,$FF	; USED AS A BLOCK BUFFER FOR ? AND !

********** THE MUSIC DRIVER **********

PERTAB:	DC.W 1712,1616,1520,1440,1360,1280,1200,1136,1072,1016,960,904
	DC.W 856,808,760,720,680,640,600,568,536,508,480,452
	DC.W 428,404,380,360,340,320,300,284,268,254,240,226
	DC.W 214,202,190,180,170,165,150,142,134,127,120,113
	DC.W 107,101,95,90,85,83,75,71,67,64,60,57 ; TRXPOSE VALS...
	DC.W 54,51,48,45,43,41,38,36,34,32,30,28
	DC.W 27,25,24,23,21,20,19,18,17,16,15,14
DMA:	DC.W $0001,$0002,$0004,$0008
DMV:	DC.W 0

SADDR:	BLK.L 64*4,0
OLDCOPR:DC.L 0

MUSON:	LEA DIGBLOK,A0
	LEA SADDR,A1
	MOVE.W #255,D0
MPLA:	MOVE.L (A0)+,(A1)+
	DBF D0,MPLA

	MOVE.L #MEMTAB,A0; BASE ADDRESS OF DIGIS
	LEA SADDR,A1
	MOVE.W #63,D0
PRPLOOP:MOVE.L (A0),(A1)
	MOVE.L (A0),A2
	CLR.W (A2)
	ADDI.L #8,A0
	ADDI.L #16,A1
	DBF D0,PRPLOOP

	MOVE.W #2,TEMPO
	MOVE.L #$00100010,D0
	MOVE.L D0,DUR0
	MOVE.L D0,DUR0+4
	LSR.L #4,D0
	MOVE.L D0,RP0
	MOVE.L D0,RP0+4
	MOVE.L #$FFFFFFFF,D0
	MOVE.L D0,BF0
	MOVE.L D0,BF0+4
	LEA CDUR0,A0
	MOVE.W #36,D0
CLDRVS:	CLR.W (A0)+
	DBF D0,CLDRVS

MUSCON:	MOVE.W #$70,$DFF09A
	MOVE.W #$C020,$DFF09A
	MOVE.L #IRQ,$6C
	MOVE.W #$8020,SPRDMA
	RTS

MUSOFF:	MOVE.L OLDCOPR,$6C
	MOVE.W #$000F,$DFF096
	LEA $DFF0A0,A0
	CLR.W $8(A0)
	CLR.W $18(A0)
	CLR.W $28(A0)
	CLR.W $38(A0)
	RTS

********** THE ALMIGHTY INTERRUPT **********

IRQ:	MOVEM.L D0-D7/A0-A6,-(A7)
	MOVE.W HX,-(A7)	; SO THE HEX DISPLAY DOESN'T FREAK!
	LEA $DFF120,A0
	MOVE.L #SPR0,(A0)+
	MOVE.L #SPR1,(A0)+
	MOVE.L #SPR2,(A0)+
	MOVE.L #SPR3,(A0)+
	MOVE.L #NULLSPR,D0
	MOVE.L D0,(A0)+
	MOVE.L D0,(A0)+
	MOVE.L D0,(A0)+
	MOVE.L D0,(A0)+
	MOVE.W SPRDMA,$DFF096
	MOVE $DFF01E,D1
	BTST #4,D1
	BNE IREXIT

	MOVE.W #5,FPLAYCT
DRIVLP:	BSR DRIVER
	BTST #6,$BFE001
	BNE DRAWEQ
	MOVE.L #$FFFFFFFF,EQUA
	MOVE.L #$FFFFFFFF,EQUA+4
	SUBI.W #1,FPLAYCT
	BNE DRIVLP

DRAWEQ:	MOVE.B 1+BLK0,D0 ; DRAW EQUALIZER + STATS FOR THE TRACKS...
	LEA STAT0,A0
	BSR TOSPR
	MOVE.B 1+BF0,D0
	BSR TOSPR
	MOVE.B 1+CDUR0,D0
	BSR TOSPR

	MOVE.B 3+BLK0,D0
	LEA STAT1,A0
	BSR TOSPR
	MOVE.B 3+BF0,D0
	BSR TOSPR
	MOVE.B 3+CDUR0,D0
	BSR TOSPR

	MOVE.B 5+BLK0,D0
	LEA STAT2,A0
	BSR TOSPR
	MOVE.B 5+BF0,D0
	BSR TOSPR
	MOVE.B 5+CDUR0,D0
	BSR TOSPR

	MOVE.B 7+BLK0,D0
	LEA STAT3,A0
	BSR TOSPR
	MOVE.B 7+BF0,D0
	BSR TOSPR
	MOVE.B 7+CDUR0,D0
	BSR TOSPR

	SUBI.W #1,STBRTB
	BNE RMBA
	MOVE.W #20,STBRTB

RMBA:	MOVE.W #$0C00,$DFF034	; RIGHT MOUSE BUTTON SENSE
RMB:	BTST #10,$DFF016
	BNE RMBFIX
	CMPI.W #20,STBRTB
	BNE IREXIT
	EORI.W #$8000,SPRDMA
	BRA IREXIT

RMBFIX:	MOVE.W #1,STBRTB
IREXIT:	BSR EQUALZ
	MOVE #$70,$DFF09C	 
	MOVE.W (A7)+,HX
	MOVEM.L (A7)+,D0-D7/A0-A6
	RTE

STBRTB:	DC.W 20	; STROBE RMB EVERY 1/3 SEC...
FPLAYCT:DC.W 0
SPRDMA:	DC.W $8020
EQUA:	DC.W 0,0,0,0	; EQUALIZER VALUES...

********** DO EQUALIZER FOR VOICES **********

EQUALZ:	LEA EQUA,A0
	LEA EQU0,A1
	MOVEQ #3,D2
EQZL:	MOVE.W (A0),D0
	TST.W D0
	BPL EQZIN
	MOVE.L A1,A2
	MOVEQ #15,D1
FILEQ:	MOVE.L #$0000FFFF,(A2)+
	DBF D1,FILEQ	
	BRA EQUEX
EQZIN:	ASL.W #2,D0
	CLR.W 2(A1,D0.W)
EQUEX:	ADDI.L #168,A1
	ADDQ.L #2,A0
	DBF D2,EQZL
	RTS

********** THE SPRITE DATAS (DON'T CHANGE!!!) **********

SPR0:	DC.L $34505C00
EQU0:	BLK.L 16,$00000000
STAT0:	BLK.L 24,$0000FFFF
	DC.L 0

SPR1:	DC.L $345C5C00
EQU1:	BLK.L 16,$00000000
STAT1:	BLK.L 24,$0000FFFF
	DC.L 0

SPR2:	DC.L $34685C00
EQU2:	BLK.L 16,$00000000
STAT2:	BLK.L 24,$0000FFFF
	DC.L 0

SPR3:	DC.L $34745C00
EQU3:	BLK.L 16,$00000000
STAT3:	BLK.L 24,$0000FFFF
	DC.L 0

NULLSPR:DC.L $34003400	
	DC.L $0,$0

********** CONV HEX IN D0.B TO SPRITE AT A0.L **********

TOSPR:	MOVEM.L D0/A1,-(A7)
	JSR HXCONV
	MOVE.B HX,D0
	BSR MAKNUM
	MOVE.B HX+1,D0
	ADDQ.L #1,A0
	BSR MAKNUM
	MOVEM.L (A7)+,D0/A1
	ADDI.L #31,A0	; INCR TO NEXT ROW IN SPRITE...
	RTS

MAKNUM:	ANDI.L #$3F,D0
	ASL.W #3,D0
	LEA FONT,A1
	ADD.L D0,A1
	MOVE.B (A1)+,(A0)
	MOVE.B (A1)+,4(A0)
	MOVE.B (A1)+,8(A0)
	MOVE.B (A1)+,12(A0)
	MOVE.B (A1)+,16(A0)
	MOVE.B (A1)+,20(A0)
	MOVE.B (A1)+,24(A0)
	MOVE.B (A1)+,28(A0)
	RTS

********** VARIABLES USED IN THE DRIVER **********

TEMPO:	DC.W 2
TMCNT:	DC.W 0

DUR0:	DC.W $10,$10,$10,$10
CDUR0:	DC.W 0,0,0,0
GLDUD:	DC.W 0,0,0,0
TRX0:	DC.W 0,0,0,0
GLDVAL:	DC.W 0,0,0,0
PERVAL:	DC.W 0,0,0,0
BLK0:	DC.W 0,0,0,0
V0:	DC.W 0,0,0,0
DETUN0:	DC.W 0,0,0,0
SN0:	DC.W 0,0,0,0
SONPLAY:DC.W 0
INFCHK:	DC.W 0		; CHECKS FOR ENDLESS LOOPS IN MUSIC...
BF0:	DC.W $FF,$FF,$FF,$FF
RP0:	DC.W 1,1,1,1
VOL0:	DC.W 64,64,64,64

********** LET THE MUSIC PLAY... **********

DRIVER:	TST.W SONPLAY
	BNE DMOFF
	SUBI.W #1,TMCNT
	BPL DRVEX
	MOVE.W TEMPO,TMCNT
	MOVEQ #3,D5
DRVLP:	BSR DRIVOI
	DBF D5,DRVLP
DRVEX:	RTS
DMOFF:	MOVE.W #$000F,$DFF096
	RTS

********** DRIVE VOICE D5.B **********

DRIVOI:	CLR.W INFCHK
	LEA $DFF0A0,A4
	MOVE.W D5,D6
	ASL.W #1,D6
	MOVE.W D5,D7
	ASL.W #4,D7

	LEA GLDUD(PC),A3
	TST.W (A3,D6.W)
	BEQ DOEQUAL

	LEA DETUN0(PC),A2
	MOVE.W (A2,D6.W),D1
	TST.W (A3,D6.W)
	BMI GLIDEUP	
	NEG.W D1

GLIDEUP:LEA PERVAL(PC),A3
	ADD.W (A3,D6.W),D1
	ANDI.L #$FFFF,D1
	CMPI.L #127,D1
	BGT CHKDGL
	MOVE.W #127,D1
CHKDGL:	CMPI.L #$0800,D1
	BLT NOCHKP
	MOVE.W #$0800,D1
NOCHKP:	MOVE.W D1,6(A4,D7.W)
	MOVE.W D1,(A3,D6.W)

DOEQUAL:LEA EQUA(PC),A3
	CMPI.W #$0F,(A3,D6.W)
	BEQ SKEQINC
	ADDI.W #$01,(A3,D6.W)

SKEQINC:LEA 1+BF0(PC),A3
	CMPI.B #$FF,(A3,D6.W)
	BNE BLGO
BEGBLK:	LEA BF0(PC),A3
	CLR.W (A3,D6.W)
	LEA RP0(PC),A3
	SUBI.W #1,(A3,D6.W)
	BNE BLGO

NXV:	LEA RP0(PC),A3
	MOVE.W #1,(A3,D6.W)
NXVA:	ADDI.W #1,INFCHK	; THIS TRAPS AN FF VALUE IN
	BTST #8,INFCHK		; POSITION 0 OF EACH TRACK...
	BNE SONEND
	CLR.L D0
	MOVE.W D5,D0
	ASL.W #8,D0
	LEA TRK0(PC),A0
	ADD.L D0,A0
	LEA V0(PC),A3
	MOVE.W (A3,D6.W),D0
	CLR.W D1
	MOVE.B (A0,D0.W),D1
	CMPI.W #$40,D1
	BLT FBL
	CMPI.W #$80,D1
	BLT RPX
	CMPI.W #$FB,D1
	BGT CTR
	CMPI.B #$BF,D1	
	BGT FILTMOD

TRXPOSE:ANDI.W #$3F,D1
	CMPI.W #35,D1
	BGT FILTMOD
	LEA TRX0(PC),A3
	MOVE.W D1,(A3,D6.W)
	BRA VINC

FILTMOD:MOVE.B $BFE001,D0
	ANDI.B #$FD,D0
	ANDI.B #1,D1	; MODIFY FILTER...
	ASL.B #1,D1
	OR.B D1,D0
	MOVE.B D0,$BFE001
	
VINC:	LEA 1+V0(PC),A3
 	ADDI.B #1,(A3,D6.W)
	BRA NXVA

RPX:	SUBI.W #$3F,D1
	LEA RP0(PC),A3
	MOVE.W D1,(A3,D6.W)
	BRA VINC

FBL:	LEA 1+V0(PC),A3
	ADDI.B #1,(A3,D6.W)
	LEA 1+BLK0(PC),A3
	MOVE.B D1,(A3,D6.W)
	BRA BLGO

CTR:	CMPI.B #$FC,D1
	BEQ VOL
	CMPI.B #$FD,D1
	BEQ GT
	CMPI.B #$FE,D1
	BEQ SONEND
	CMPI.B #$FF,D1
	BNE VINC

	LEA V0(PC),A3    ; THE $FF BYTE
	CLR.W (A3,D6.W)
	BRA NXV

SONEND:	ST SONPLAY
	RTS

VOL:	ADDI.B #1,D0
	LEA 1+V0(PC),A3
	MOVE.B D0,(A3,D6.W)
	MOVE.B (A0,D0.W),D1
	MOVE.W D1,8(A4,D7.W); SET VOLUME...
	LEA VOL0(PC),A3
	MOVE.W D1,(A3,D6.W)
	BRA VINC

GT:	ADDI.B #1,D0
	LEA 1+V0(PC),A3
	MOVE.B (A0,D0.W),(A3,D6.W)
	BRA NXV

BLGO:	LEA CDUR0(PC),A3
	SUBI.W #1,(A3,D6.W)
	BEQ BLDO
	BMI BLDO
	RTS

BLDO:	ADDI.W #1,INFCHK	; ENDS SONG IF AN INFINITE
	BTST #8,INFCHK		; LOOP IS FOUND...
	BNE SONEND
	LEA BF0(PC),A3
	MOVE.W (A3,D6.W),D0
	LEA BLK0(PC),A3
	MOVE.W (A3,D6.W),D1
	ASL.W #8,D1
	ADD.W D1,D0
	LEA BLOX(PC),A0
	CLR.W D1
	MOVE.B (A0,D0.W),D1 ; VAL IN THE BLOCK...
	CMPI.B #$FF,D1
	BEQ BEGBLK
	CMPI.W #$30,D1
	BLT PNOT
	CMPI.W #$70,D1
	BLT DETFIX
	CMPI.W #$80,D1
	BLT TEMFIX
	CMPI.W #$C0,D1
	BLT DURFIX

	ANDI.W #$3F,D1		; GET SOUND NR.
	LEA SN0(PC),A3
	MOVE.W D1,(A3,D6.W)
NXBF:	LEA 1+BF0(PC),A3
	ADDI.B #1,(A3,D6.W)
	BRA BLDO

TEMFIX:	ANDI.W #$0F,D1
	MOVE.W D1,TEMPO
	BRA NXBF

DETFIX:	LEA GLDUD(PC),A3
	SUBI.W #$30,D1
	CMPI.B #$3D,D1
	BEQ DNGLD
	CMPI.B #$3E,D1
	BEQ NOGLD
	CMPI.B #$3F,D1
	BEQ UPGLD
	ASL.W #1,D1
	LEA DETUN0(PC),A3
	MOVE.W D1,(A3,D6.W)
	BRA NXBF

DNGLD:	MOVE.W #$FFFF,(A3,D6.W)	 
	BRA NXBF

NOGLD:	CLR.W (A3,D6.W)
	BRA NXBF

UPGLD:	MOVE.W #$0001,(A3,D6.W)
	BRA NXBF	

DURFIX:	ANDI.W #$3F,D1		
	TST.B D1
	BNE DUROK
	MOVE.B #$40,D1
DUROK:	LEA DUR0(PC),A3
	MOVE.W D1,(A3,D6.W)
	BRA NXBF

PNOT:	MOVE.W D5,D4
	ASL.W #1,D4
	LEA DMA(PC),A3
	MOVE.W (A3,D4.W),DMV
	
	LEA SADDR,A1
	LEA SN0(PC),A3
	MOVE.W (A3,D6.W),D0
	ASL.W #4,D0

	TST.L 4(A1,D0.W)	; SKIP IF SOUND NOT LOADED...
	BEQ PNENDA
		
	LEA EQUA(PC),A2		; RESTART EQUALIZER AT 00...
	MOVE.W #$FFFF,(A2,D6.W)

	MOVE.W DMV,$DFF096	
	MOVE.W #$1D0,D2		; LET DMA CATCH UP...
DF:	DBF D2,DF
	MOVE.L 0(A1,D0.W),(A4,D7.W)
	MOVE.L 4(A1,D0.W),D2
	LSR.L #1,D2
	MOVE.W D2,4(A4,D7.W)
	LEA TRX0(PC),A2	; D1 NOTEVAL + THE TRANSPOSE VALUE...
	ADD.W (A2,D6.W),D1
	ASL.W #1,D1
	LEA PERTAB(PC),A2
	MOVE.W (A2,D1.W),D1
	LEA DETUN0(PC),A3
	ADD.W (A3,D6.W),D1
	MOVE.W D1,6(A4,D7.W)
	LEA PERVAL(PC),A2
	MOVE.W D1,(A2,D6.W)
	ORI.W #$8000,DMV
	MOVE.W DMV,$DFF096

	TST.L 12(A1,D0.W)
	BNE WAVE
	MOVE.W #1,4(A4,D7.W)
	BRA PNEND

WAVE:	MOVE.W #$30,D1
DMAWT:	DBF D1,DMAWT
	MOVE.L 12(A1,D0.W),D1
	LSR.L #1,D1
	MOVE.W D1,4(A4,D7.W)
	MOVE.L (A1,D0.W),D1
	ADD.L 8(A1,D0.W),D1
	MOVE.L D1,(A4,D7.W)

PNEND:	LEA VOL0(PC),A3
	MOVE.W (A3,D6.W),8(A4,D7.W)
PNENDA:	LEA DUR0(PC),A3
	LEA CDUR0(PC),A1
	MOVE.W (A3,D6.W),(A1,D6.W)
	LEA BF0(PC),A3
	ADDI.W #1,(A3,D6.W)
	RTS

********** PLACE FONT HERE **********

FONT:	BLK.B 512,0

