/* Copyright Stefan Hlln
 * May not be used without
 * the authors specific
 * authorization
 * el98shn@ing.umu.se       */

#include <math.h>

#include "isInstrument.h"
#include "isDistortion.h"

isInstrument::isInstrument(isSamplePool &samplePool) : samplePool(samplePool)
{
	OutputDebugString("isInstrument\n");

	bufferLength=1;
	nrOfVoices=0;
	IncVoice();
	enableDistortion=false;
	enableArpeggiator=false;
	
}

isInstrument::~isInstrument()
{
}

void isInstrument::Load(isFile *f)
{
	unsigned char v;
	// load the voices
	int nr=f->ReadInt(1);
	
	for(v=0;v<nrOfVoices;v++)
		delete voc[v];

	nrOfVoices=nr;
	int *voicePoly=new int[nrOfVoices];
	for(unsigned int p=0;p<nrOfVoices;p++)
		voicePoly[p]=f->ReadInt(1);

	isVoice loaded(samplePool);
	char str[50];
	for(v=0;v<nrOfVoices;v++)
	{
		// fix the polyvoices and stuff
		voc[v]=new isVoice(samplePool);
		voc[v]->Load(f);
		voc[v]->SetPoly(voicePoly[v]);
	}
	// is the distortion enabled (saved)?
	enableDistortion=f->ReadInt(1)==1?true:false;
	if(enableDistortion) // if so, load it
	{
		LoadType(f);
		distortion.Load(f);
	}

	// is the arpeggiator enabled (saved)?
	enableArpeggiator=f->ReadInt(1)==1?true:false;
	if(enableArpeggiator) // if so, load it
	{
		arpeggiator.Load(f);
	}
	
	delete []voicePoly;
}

void isInstrument::Save(isFile *f)
{
	// save the voices
	f->WriteInt(nrOfVoices,1);

	for(unsigned int p=0;p<nrOfVoices;p++)
	{
		f->WriteInt(voc[p]->GetPoly(),1);
	}

	unsigned char v;
	for(v=0;v<nrOfVoices;v++)
	{
		voc[v]->Save(f);
	}

	f->WriteInt(enableDistortion?1:0,1);
	if(enableDistortion)
		distortion.Save(f);

	f->WriteInt(enableArpeggiator?1:0,1);
	if(enableArpeggiator)
		arpeggiator.Save(f);


}

void isInstrument::Play(float *buffer)
{
	if(enableArpeggiator)
	{
		arpeggiator.Play(nrOfVoices,voc);
	}
	for(int vocNr=0;vocNr<nrOfVoices;vocNr++)
	{
		if(voc[vocNr]->Active())
			voc[vocNr]->Play(buffer);
	}
	if(enableDistortion)
		distortion.Play(buffer,0);
}

bool isInstrument::IsActive()
{
	for(int vocNr=0;vocNr<nrOfVoices;vocNr++)
	{
		if(voc[vocNr]->Active())
				return true;
	}
	return false;
}

void isInstrument::SetBufferSize(int length)
{
	bufferLength=length;
	for(int vocNr=0;vocNr<nrOfVoices;vocNr++)
	{
		voc[vocNr]->SetBufferSize(length);
	}
	distortion.SetBufferSize(length);
	
}

void isInstrument::Event(isEVENT event)
{
	if(enableArpeggiator && (event.type==NOTE_ON || event.type==NOTE_OFF))
	{
		arpeggiator.Event(event);
		return;
	}
	for(int vocNr=0;vocNr<nrOfVoices;vocNr++)
	{
		voc[vocNr]->Event(event);
	}
}

// here goes stuff for the editor API
// ******************************************************
isVoice *isInstrument::GetVoice(int index)
{
	if(index>=nrOfVoices)
		return NULL;
	else
		return voc[index];
}

void isInstrument::IncVoice()
{
	nrOfVoices++;
	voc[nrOfVoices-1]=new isVoice(samplePool);
	voc[nrOfVoices-1]->SetBufferSize(bufferLength);
}

void isInstrument::DecVoice()
{
	delete voc[nrOfVoices-1];
	nrOfVoices--;
}

// ******************************************************
