/* Copyright Stefan Hlln
 * May not be used without
 * the authors specific
 * authorization
 * el98shn@ing.umu.se       */

#include <windows.h>
#include <math.h>
#include <assert.h>

#include "isChorus.h"

isChorus::isChorus()
{
	speed=0.02f;
	depth=0.4f;
	spread=1.0f;
	feedback=0.1f;
	volume=-1.0f;
	dryMix=0.0f;
	hifi=true;

	bufferCnt=0;
	left=right=NULL;
	count=0.0f;

	// for isBase
	type=is_CHORUS;
}

isChorus::~isChorus()
{
	if(left!=NULL)
	{
		delete left;
		delete right;
	}
}

void isChorus::Save(isFile *f)
{
	SaveType(f);

	f->WriteFloat(speed);
	f->WriteFloat(depth);
	f->WriteFloat(spread);
	f->WriteFloat(feedback);
	f->WriteFloat(volume);
	f->WriteFloat(dryMix);
	
	f->WriteInt(hifi?1:0,1);
}

void isChorus::Load(isFile *f)
{
	speed=f->ReadFloat();
	depth=f->ReadFloat();
	spread=f->ReadFloat();
	feedback=f->ReadFloat();
	volume=f->ReadFloat();
	dryMix=f->ReadFloat();

	hifi=(f->ReadInt(1)==1)?true:false;

}


void isChorus::Play(float *leftIn, float *rightIn, float *leftOut, float *rightOut)
{
	int buflenmod = myBufferLength - 1;

	float adder = speed *0.5f / bufferLength;
	float leftDel,rightDel,leftDS,leftDE,rightDS,rightDE,leftDD,rightDD;
	
	count-=(int)count;
	leftDS = 50+ Wave(count) * (bufferLength - 51) * depth;
	rightDS = 50+ Wave(count + spread*0.5f) * (bufferLength - 51) * depth;
	
	leftDE = 50+Wave(count + speed * 0.5f) * (bufferLength - 51) * depth;
	rightDE = 50+Wave(count + spread * 0.5f + speed * 0.5f) * (bufferLength - 51) * depth;

	leftDel = leftDS;
	rightDel = rightDS;

	leftDD = (leftDE - leftDS) / bufferLength;
	rightDD = (rightDE - rightDS) / bufferLength;

	int cnt1 = myBufferLength & buflenmod;
	for(unsigned int b=0;b<bufferLength;b++)
	{
	
		float leftM,rightM;
		float leftFeed,rightFeed;
		unsigned int leftD,rightD;

		// float->int vill man grna slippa slippa!
		__asm fld leftDel
		__asm fld rightDel
		__asm fistp rightD
		__asm fistp leftD
		
		leftM = leftDel - leftD;
		rightM = rightDel - rightD;

		// Rkna fram bufferposition samt berkna MOD p den ocks.
		bufferCnt++;
		int bufferCntMod = bufferCnt & buflenmod;
		
		// Hmta leftIN
		float in_l_b = leftIn[ b ];
		float in_r_b = rightIn[ b ];

		left[ bufferCntMod ] = in_l_b;
		right[ bufferCntMod ] = in_r_b;
		
		// Rkna ut in_*dryMix
		// Detta skall adderas till leftOut.. men jag vntar med det till senare
		in_l_b *= dryMix;
		in_r_b *= dryMix;

		/////////////////////////////////////////////////////////////////////////////////////////////////////////
		// leftFeed = left[ tmp_leftd_addr ] * (1.0f-leftM) + left[ tmp_leftd_addr_1 ] * (leftM);
		/////////////////////////////////////////////////////////////////////////////////////////////////////////
		int tmp_leftd_addr = (bufferCnt - leftD + 65536 * 256) & buflenmod;
		int tmp_leftd_addr_1 = (tmp_leftd_addr - 1) & buflenmod;
		float lMneg = 1.0f - leftM;
		leftFeed = left[ tmp_leftd_addr_1 ] * leftM;
		lMneg *= left[ tmp_leftd_addr ];
		leftFeed += lMneg;

		/////////////////////////////////////////////////////////////////////////////////////////////////////////
		// rightFeed=right[(bufferCnt-rightD)%myBufferLength]*(1.0f-rightM)+right[(bufferCnt-rightD-1)%myBufferLength]*(rightM);
		/////////////////////////////////////////////////////////////////////////////////////////////////////////
		int tmp_rightd_addr = (bufferCnt - rightD + 65536 * 256) & buflenmod;
		int tmp_rightd_addr_1 = (tmp_rightd_addr - 1) & buflenmod;
		float rMneg = 1.0f - rightM;
		rightFeed = right[ tmp_rightd_addr_1 ] * rightM;
		rMneg *= right[ tmp_rightd_addr ];
		rightFeed += rMneg;

		in_l_b += leftFeed;
		in_r_b += rightFeed;

		// Lgg p till utmatningen.. plus det i ovan
		leftOut[ b ] += in_l_b;
		rightOut[ b ] += in_r_b;

		// feedback
		if(feedback!=0.0f)
		{
			// Cnt1 rknades upp frut med en ifsats
			left[ bufferCntMod ] += leftFeed * feedback;
			right[ bufferCntMod ] += rightFeed * feedback;
		}

		count += adder;
		leftDel += leftDD;
		rightDel += rightDD;
		
	}


}

void isChorus::SetBufferSize(unsigned int length)
{
	isStereoFX::SetBufferSize(length);

	// Berkna en bufferLength som r en 2potens
	myBufferLength = 2;
	while (myBufferLength < (length*2)) {
		myBufferLength *= 2;
	}

	if(left!=NULL)
	{
		delete left;
		delete right;
	}

	// Allokera och nollstll
	left = new float[ myBufferLength ];
	right = new float[ myBufferLength ];
	for(unsigned int b=0;b<myBufferLength;b++)
		left[b]=right[b]=0.0f;
}

float isChorus::Wave(float cnt)
{
	return 0.5f+(float)sin(cnt*6.283185307179586476925286766559)*0.5f;
//	if(cnt<0) cnt=-cnt;
//	cnt=cnt-(unsigned int)cnt;
//	return (cnt<0.5f) ? (cnt*2.0f) : (1.0f-(cnt-0.5f)*2.0f);
}