/* Copyright Stefan Hlln
 * May not be used without
 * the authors specific
 * authorization
 * el98shn@ing.umu.se       */

#include "isArpeggiator.h"
#include <stdlib.h>

isArpeggiator::isArpeggiator()
{
	for(int s=0;s<32;s++)
	{
		// 255=no note
		// 0 = first note in list
		step[s].index[0]=s&15;
		step[s].index[1]=255;
		step[s].index[2]=255;

		step[s].octave=0;;
		step[s].velocity=255;
		step[s].length=6;

	}
	for(s=0;s<32*3;s++)
	{
		offNotesList[s].length=0;
		offNotesList[s].tickCounter=-1; // empty offTick
		offNotesList[s].offNoteNr=255;
		offNotesList[s].offVelo=0;
	}

	for(int i=0;i<16;i++)
	{
		noteNr[i]=255;
		velo[i]=0;
	}
	ticksPerRow=8;

	tickCounter=0;
	rowCounter=0;
}


isArpeggiator::~isArpeggiator()
{
}

void isArpeggiator::Save(isFile *f)
{
	for(int s=0;s<32;s++)
	{
		f->WriteInt(step[s].index[0],1);
		f->WriteInt(step[s].index[1],1);
		f->WriteInt(step[s].index[2],1);
		
		f->WriteInt(step[s].octave,1);
		f->WriteInt(step[s].velocity,1);
		f->WriteInt(step[s].length,1);
	}

	f->WriteInt(ticksPerRow,1);
}

void isArpeggiator::Load(isFile *f)
{
	isArpeggiator();
	for(int s=0;s<32;s++)
	{
		step[s].index[0]=f->ReadInt(1);
		step[s].index[1]=f->ReadInt(1);
		step[s].index[2]=f->ReadInt(1);

		step[s].octave=f->ReadInt(1);
		step[s].velocity=f->ReadInt(1);
		step[s].length=f->ReadInt(1);
	}

	ticksPerRow=f->ReadInt(1);
}

void isArpeggiator::Play(int nrOfVoices, isVoice **voice)
{
	char str[100];
	int nrOfNotes=0;
	for(int a=0;a<16;a++)
	{
		if(noteNr[a]!=255)
			nrOfNotes++;
	}
	if(nrOfNotes==0)
	{
		rowCounter=0;
		tickCounter=-1;
	}
	
	isEVENT event;
	// should we do anything on this tick?
	if(nrOfNotes!=0)
	{
		if( (tickCounter%ticksPerRow)==0 )
		{
			tickCounter=0;
			for(int i=0;i<3;i++)
			{
				// note indexed on this row?
				if(step[rowCounter].index[i]!=255)
				{
					int index=GetRealNoteNr(step[rowCounter].index[i]);
					
					if(index==255)
						continue;

					event.type=NOTE_ON;
					event.param1=noteNr[index]+step[rowCounter].octave*12;
					event.param2=(velo[index]*step[rowCounter].velocity)>>8;
					sprintf(str,"NOTE_ON nr: %i velo: %i \n",event.param1,event.param2);
					OutputDebugString(str);

					// add to offNotesList
					for(int s=0;s<32*3;s++)
					{
						if(offNotesList[s].tickCounter==-1)
						{
							offNotesList[s].length=step[rowCounter].length;
							offNotesList[s].offNoteNr=event.param1;
							offNotesList[s].offVelo=event.param2;
							offNotesList[s].tickCounter=0;
							break;
						}
					}
					for(int voc=0;voc<nrOfVoices;voc++)
					{
						voice[voc]->Event(event);
					}
				}
			}
			
			rowCounter=(rowCounter+1)&0x1f;
		}
	}
	int row;
	for(row=0;row<32*3;row++)
	{
		if(offNotesList[row].tickCounter==offNotesList[row].length)
		{
			event.type=NOTE_OFF;
			event.param1=offNotesList[row].offNoteNr;
			event.param2=offNotesList[row].offVelo;
			offNotesList[row].tickCounter=-1;
			
			sprintf(str,"NOTE_OFF nr: %i velo: %i \n",event.param1,event.param2);
			OutputDebugString(str);

			for(int voc=0;voc<nrOfVoices;voc++)
			{
				voice[voc]->Event(event);
			}
		}
		
		if(offNotesList[row].tickCounter!=-1)
		{
			offNotesList[row].tickCounter++;
		}
		
	}
	
	tickCounter++;

}


int isArpeggiator::GetRealNoteNr(int index)
{
	index&=0x0f; // max 16 notes;
	unsigned char *noteList;
	noteList=noteNr;

	int nr=0;
	
	for(nr=0;nr<16 && noteList[nr]==255;nr++)
	{
	}

	if(nr==16)
	{
		return 255;
	}

	for(int i=0;i<index;i++)
	{
		int n=0;
		do
		{
			nr++;
			nr&=0x0f;
			n++;
		} while	(n<16 && noteList[nr]==255);

	}

	return nr;
}

void isArpeggiator::Event(isEVENT event)
{
	int i;
	switch(event.type) 
	{
	case NOTE_ON:
		for(i=0;i<16;i++)
		{
			if(noteNr[i]==255)
			{
				noteNr[i]=event.param1;
				velo[i]=event.param2;
				i=16;
			}
		}
		break;
	case NOTE_OFF:
		for(i=0;i<16;i++)
		{
			if(noteNr[i]==event.param1)
			{
				noteNr[i]=255;
				velo[i]=event.param2;
				i=16;
			}
		}
		break;
	default:
		break;
	}
}
