#ifndef __GTK_FORMAT_H__
#define __GTK_FORMAT_H__

#include <windows.h>
#include "isSynth.h"

#define GTK_CURRENT_VERSION 0x0103
#define GTK_DEFAULT_PATCHANNELS 0x10	// 16 kanaler i varje pattern _ONLY_
#define	GTK_NOTE_OFF 0xff


#define GTK_DEFAULT_BPM 125
#define GTK_DEFAULT_PATTICK 6
#define GTK_DEFAULT_SEQTICK 16

typedef struct GTK GTK;
typedef struct GTK_SEQCHANNEL GTK_SEQCHANNEL;
typedef struct GTK_SEQPOS GTK_SEQPOS;
typedef struct GTK_PATTERN GTK_PATTERN;
typedef struct GTK_PATTERNPOS GTK_PATTERNPOS;


// multiplier for sequence tick sleep
#define GTK_SEQ_MUL 16
#define GTK_FILEFLAG_SEQPOS_NONE 0
#define GTK_FILEFLAG_SEQPOS_PATTERN 0x01
#define GTK_FILEFLAG_SEQPOS_TRANSPOSE 0x02
#define GTK_FILEFLAG_SEQPOS_FX 0x04
#define GTK_FILEFLAG_SEQPOS_PARAM1 0x08
#define GTK_FILEFLAG_SEQPOS_PARAM2 0x10
#define GTK_FILEFLAG_SEQPOS_PARAM3 0x20
#define GTK_FILEFLAG_SEQPOS_PARAM4 0x40
#define GTK_FILEFLAG_SEQPOS_PARAM5 0x80
#define GTK_FILEFLAG_SEQPOS_PARAM6 0x100


struct GTK_SEQCHANNEL
{
	unsigned short len;     // !VERSION! 0102 =  unsigned char len;
	GTK_SEQPOS *positions;
};
struct GTK_SEQPOS
{
	unsigned char pattern;
	char transpose;
	unsigned char fx, param1, param2, param3,param4,param5,param6;
};

struct GTK_PATTERN
{
    unsigned short len;     //	!VERSION! 0102 = unsigned char len;
	GTK_PATTERNPOS **patterndata;
};
struct GTK_PATTERNPOS
{
	unsigned char note,velocity,fx,param;
};
struct GTK
{
	unsigned char num_channels,num_patterns,num_instruments;	
	unsigned char def_bpm,def_pattick,internal_seqtick;
    unsigned short def_seqtick;
	GTK_SEQCHANNEL *channels;
	GTK_PATTERN *patterns;	

};




GTK *gtk_load (isSynth *synth,char *fname);
int gtk_save (GTK *gtk,isSynth *synth,char *fname);
GTK *gtk_create (void);
int gtk_clearmod (GTK *mod);


#endif
