#include "stdafx.h"
#include <mmsystem.h>
#include "MIDIInput.h"

static DWORD WINAPI MIDIThreadProc( LPVOID lpParameter )
{
	MIDIInput *inp = (MIDIInput *) lpParameter;
	inp->thread();
	ExitThread(0);
	return 0;
}

MIDIInput::MIDIInput()
{
	m_curdevice = 0;
	m_handle = 0;
	m_isopen = FALSE;
	m_msgdest = 0;

	// Skapa trd	
	m_thread = CreateThread( 0, 0, &MIDIThreadProc, this, 0, &m_threadid );
}

MIDIInput::~MIDIInput()
{
	// Vld!
	PostThreadMessage( m_threadid, WM_QUIT, 0, 0 );
	if (WAIT_OBJECT_0 != WaitForSingleObject( m_thread, 1000 )) 
		TerminateThread( m_thread, 0 );
}

void MIDIInput::thread(void)
{
	MSG msg;
	while (GetMessage(&msg,0,0,0)) {
		if (m_msgdest) 
			PostMessage( m_msgdest, msg.message, msg.wParam, msg.lParam );
	}
}

void MIDIInput::setmsgdest( HWND hwnd )
{
	m_msgdest = hwnd;
}

void MIDIInput::endmsgdest( HWND hwnd )
{
	if (m_msgdest == hwnd) 
		m_msgdest = 0;
}

void MIDIInput::start( UINT device )
{
	if (TRUE == m_isopen) {
		MIDIInput::stop();
	}

	m_curdevice = device;

	if (MMSYSERR_NOERROR != midiInOpen( &m_handle, m_curdevice, (DWORD)m_threadid, 0, CALLBACK_THREAD ))
		MessageBox( NULL, _T("Error!"), _T("MIDI Error!"), MB_OK );
	else {
		if (MMSYSERR_NOERROR == midiInStart( m_handle )) {
			m_isopen = TRUE;			
		}
	}

	

	
}

void MIDIInput::stop( void )
{
	if (FALSE == m_isopen)
		return;
	
    midiInStop( m_handle );
    midiInClose( m_handle );

	m_isopen = FALSE;
}


