unit gmtawe2;
interface
procedure awedru;
procedure affeffect;
{procedure customizerev;
procedure customizech; }
procedure detectawe32;
procedure disabledr;
procedure enabledr;
procedure setf(val,v:byte);
procedure awesample;
procedure awe32win;
procedure awewl(command,dataport:word;b:byte;l:longint);
function awerl(command,dataport:word):longint;
function awer(command,dataport:word):word;
procedure awerd(command,dataport:word;var lw,hw:word);
procedure awew(command,dataport:word;data:word );
procedure setreverb(effect:byte);
procedure setchorus(effect:byte);
procedure uploads(var g:file;fpos:longint;b,elem:byte;nb8:longint;rst:word);
procedure initawe;
procedure awloads(var g:file;fpos:longint;b:byte;smptai:longint);
procedure awereadp(p:longint);
procedure awewrtp(p:longint);
procedure playAWEins(ins:byte);
{***************************************************}

implementation
uses gmtcrt3,textgraf;
const

EffectData:array[0..127] of word =
( $03FF,$030,$07FF,$130,$0BFF,$230,$0FFF,$330,
  $13FF,$430,$17FF,$530,$1BFF,$630,$1FFF,$730,
  $23FF,$830,$27FF,$930,$2BFF,$A30,$2FFF,$B30,
  $33FF,$C30,$37FF,$D30,$3BFF,$E30,$3FFF,$F30,

  $43FF,$030,$47FF,$130,$4BFF,$230,$4FFF,$330,
  $53FF,$430,$57FF,$530,$5BFF,$630,$5FFF,$730,
  $63FF,$830,$67FF,$930,$6BFF,$A30,$6FFF,$B30,
  $73FF,$C30,$77FF,$D30,$7BFF,$E30,$7FFF,$F30,

  $83FF,$030,$87FF,$130,$8BFF,$230,$8FFF,$330,
  $93FF,$430,$97FF,$530,$9BFF,$630,$9FFF,$730,
  $A3FF,$830,$A7FF,$930,$ABFF,$A30,$AFFF,$B30,
  $B3FF,$C30,$B7FF,$D30,$BBFF,$E30,$BFFF,$F30,

  $C3FF,$030,$C7FF,$130,$CBFF,$230,$CFFF,$330,
  $D3FF,$430,$D7FF,$530,$DBFF,$630,$DFFF,$730,
  $E3FF,$830,$E7FF,$930,$EBFF,$A30,$EFFF,$B30,
  $F3FF,$C30,$F7FF,$D30,$FBFF,$E30,$FFFF,$F30);

EffectData2:array[0..127] of word =
( $0C10,$8470,$14FE,$B488,$167F,$A470,$18E7,$84B5,
  $1B6E,$842A,$1F1D,$852A,$0DA3,$0F7C,$167E,$7254,
  $0000,$842A,$0001,$852A,$18E6,$0BAA,$1B6D,$7234,
  $229F,$8429,$2746,$8529,$1F1C,$06E7,$229E,$7224,

  $0DA4,$8429,$2C29,$8529,$2745,$07F6,$2C28,$7254,
  $383B,$8428,$320F,$8528,$320E,$0F02,$1341,$7264,
  $3EB6,$8428,$3EB9,$8528,$383A,$0FA9,$3EB5,$7294,
  $3EB7,$8474,$3EBA,$8575,$3EB8,$44C3,$3EBB,$45C3,

  $0000,$A404,$0001,$A504,$141F,$0671,$14FD,$0287,
  $3EBC,$E610,$3EC8,$0C7B,$031A,$07E6,$3EC8,$86F7,
  $3EC0,$821E,$3EBE,$D280,$3EBD,$021F,$3ECA,$0386,
  $3EC1,$0C03,$3EC9,$031E,$3ECA,$8C4C,$3EBF,$0C55,

  $3EC9,$C280,$3EC4,$BC84,$3EC8,$0EAD,$3EC8,$D380,
  $3EC2,$8F7E,$3ECB,$0219,$3ECB,$D2E6,$3EC5,$031F,
  $3EC6,$C380,$3EC3,$327F,$3EC9,$0265,$3EC9,$8319,
  $1342,$D3E6,$3EC7,$337F,$0000,$8365,$1420,$9570 );

EffectCommand:array[0..7]of word =  ( $40,$A20,$40,$A22,$60,$A20,$60,$A22 );
ChorusCommand:array[0..13] of word=  ($69,$A20 ,$6C,$A20 ,$63,$A22 ,$29,$A20,
                                      $2A,$A20 ,$2D,$A20 ,$2E,$A20 );
ReverbCommand:array[0..55] of word =
 ($43,$A20, $45,$A20, $7F,$A22, $47,$A20,
  $54,$A22, $56,$A22, $4F,$A20, $57,$A20,
  $5F,$A20, $47,$A22, $4F,$A22, $57,$A22,
  $5D,$A22, $5F,$A22, $61,$A20, $63,$A20,
  $49,$A20, $4B,$A20, $51,$A20, $53,$A20,
  $59,$A20, $5B,$A20, $41,$A22, $43,$A22,
  $49,$A22, $4B,$A22, $51,$A22, $53,$A22 );

defpara:array[0..11] of word=
(49689,49945,0,
33310, 53768, 798, 54024, 541, 53785, 33561, 54041, 1);
type
smpHeader=
 record
 siz:longint;
 loopb:longint;
 looplg:longint;
 vol:byte;
 ft:byte;
 typ:byte;
 panig:byte;
 rt:byte;
 res:byte;
 tname:array[0..21] of byte;
 end;

var awekey:array[0..29] of byte;


{***************************************************}
procedure awew(command,dataport:word;data:word );assembler;
{portw[base+$802]:=command;
portw[base-$620+dataport]:=data;}
asm
mov dx,base
add dx,802h
mov ax,command
cli
out dx,ax
add dx,dataport
sub dx,0e22h
mov ax,data
out dx,ax
sti
end;
{**************************************************}
procedure awewd(command,dataport:word;datahi,datalo:word);assembler;
{portw[base+$802]:=command;
portw[base-$620+dataport]:=   datalo;
portw[base-$620+dataport+2]:= datahi;}
asm
mov dx,base
add dx,802h
mov ax,command
cli
out dx,ax
add dx,dataport
sub dx,0e22h
mov ax,datalo
out dx,ax
add dx,2
mov ax,datahi
out dx,ax
sti
end;
{**************************************************}
procedure awewhb(command,dataport:word;hb:byte);assembler;
{portw[base+$802]:=command;
portw[base-$620+dataport]:=   datalo;
portw[base-$620+dataport+2]:= datahi;}
asm
mov dx,base
add dx,802h
mov ax,command
cli
out dx,ax
add dx,dataport
sub dx,0e22h
in ax,dx
mov ah,hb
out dx,ax
add dx,2
in ax,dx
out dx,ax
sti
end;
{**************************************************}
procedure awewmhb(command,dataport:word;hb:byte);assembler;
{portw[base+$802]:=command;
portw[base-$620+dataport]:=   datalo;
portw[base-$620+dataport+2]:= datahi;}
asm
mov dx,base
add dx,802h
mov ax,command
cli
out dx,ax
add dx,dataport
sub dx,0e22h
in ax,dx
out dx,ax
add dx,2
in ax,dx
mov ah,hb
out dx,ax
sti
end;
{**************************************************}
procedure awewlb(command,dataport:word;hb:byte);assembler;
{portw[base+$802]:=command;
portw[base-$620+dataport]:=   datalo;
portw[base-$620+dataport+2]:= datahi;}
asm
mov dx,base
add dx,802h
mov ax,command
cli
out dx,ax
add dx,dataport
sub dx,0e22h
in ax,dx
mov al,hb
out dx,ax
add dx,2
in ax,dx
out dx,ax
sti
end;
{***************************************************}
procedure awewl(command,dataport:word;b:byte;l:longint);assembler;
{portw[base+$802]:=command;
portw[base-$620+dataport]:=   l and $ffff;
portw[base-$620+dataport+2]:= (b shl 8)or((l shr 16) and $ff);}
asm
mov dx,base
add dx,802h
mov ax,command
cli
out dx,ax
add dx,dataport
sub dx,0e22h
db 66h;mov ax,word ptr l
out dx,ax
db 66h;shr ax,16
mov ah,b
add dx,2
out dx,ax
sti
end;
{***************************************************}
procedure awecopyw(command,dataport:word;csr,cci:byte);
var htmp,ltmp:word;
begin
asm cli end;
portw[base+$802]:=command+csr;
ltmp:=portw[base-$620+dataport];
portw[base+$802]:=command+cci;
portw[base-$620+dataport]:=ltmp;
asm sti end;
end;
{***************************************************}
procedure awecopydw(command,dataport:word;csr,cci:byte);
var htmp,ltmp:word;
begin
asm cli end;
portw[base+$802]:=command+csr;
ltmp:=portw[base-$620+dataport];
htmp:=portw[base-$620+dataport+2];
portw[base+$802]:=command+cci;
portw[base-$620+dataport]:=ltmp;
portw[base-$620+dataport+2]:=htmp;
asm sti end;
end;
{***************************************************}
function awer(command,dataport:word):word;
begin
asm cli end;
portw[base+$802]:=command;
awer:=portw[base-$620+dataport];
asm sti end;
end;
{***************************************************}
procedure awerd(command,dataport:word;var lw,hw:word);
begin
asm cli end;
portw[base+$802]:=command;
lw:=portw[base-$620+dataport];
hw:=portw[base-$620+dataport+2];
asm sti end;
end;
{***************************************************}
function awerl(command,dataport:word):longint;
var hw,lw:longint;
begin
asm cli end;
portw[base+$802]:=command;
lw:=portw[base-$620+dataport];
hw:=portw[base-$620+dataport+2];
hw:=hw and $ff;
awerl:=lw+hw shl 16;
asm sti end;
end;
{***************************************************}
procedure awewait(clocks:word);
var k,time:longint;
begin
k:=awer($3b,$a22);
time:=k;
while (clocks >time-k) and (time>=k) do time:=awer($3b,$a22);
end;
{***************************************************}
procedure initeffect(data:array of word);
var k,i:word;
begin
for k:=0 to 3 do
for i:=0 to 31 do
awew(effectcommand[k*2]+i,effectcommand[k*2+1],data[k*32+i]);
end;
{***************************************************}
procedure initeffect2(data:array of word);
var k,i:word;
   tempdata:word;
begin
for k:=0 to 3 do for i:=0 to 31 do
 begin
 tempdata:=data[k*32+i];
 awew(effectcommand[k*2]+i,effectcommand[k*2+1],tempdata or ((i and 1 ) shl 15) );
 end;
end;
{***************************************************}
procedure setrevpara(revtab:array of word);
var k:word;
begin
for k:=0 to 27 do
awew(reverbcommand[k*2],reverbcommand[k*2+1],revtab[k]);
end;
{***************************************************}
procedure setreverb(effect:byte);
begin
if effect<9 then
 begin
 setrevpara(revpara[effect].tab);
 wrt(62,52,bar,2,revpara[effect].nom);
 end;
end;
{***************************************************}
procedure setchor(chtab:array of word);
var k:word;
begin
for k:=0 to 2 do
awew(choruscommand[k*2],choruscommand[k*2+1],chtab[k]);
k:=3;
awewd(choruscommand[k*2],choruscommand[k*2+1],chtab[k+2],chtab[k]);
k:=4;
awewd(choruscommand[k*2],choruscommand[k*2+1],chtab[k+2],chtab[k]);

awewl(choruscommand[5*2],choruscommand[5*2+1],0,$8000);
awewl(choruscommand[6*2],choruscommand[6*2+1],0,0);
end;
{***************************************************}
{procedure chorusinc(val,v:byte);
var k,lw,hw:word;
begin
k:=val shr 4;
val:=val and $0f;
case k of
0..2:begin
      hw:=awer(choruscommand[k*2],choruscommand[k*2+1]);
      inc(hw,val);
      awew(choruscommand[k*2],choruscommand[k*2+1],hw);
     end;
3,4: begin
     awerd(choruscommand[k*2],choruscommand[k*2+1],lw,hw);
     inc(lw,val);
     awewd(choruscommand[k*2],choruscommand[k*2+1],hw,lw);
     end;
5,6: begin
     k:=k-2;
     awerd(choruscommand[k*2],choruscommand[k*2+1],lw,hw);
     inc(hw,val);
     awewd(choruscommand[k*2],choruscommand[k*2+1],hw,lw);
     end;
end;
end;   }
{***************************************************}
{procedure chorusdec(val,v:byte);
var k,lw,hw:word;
begin
k:=val shr 4;
val:=val and $0f;
case k of
0..2:begin
      hw:=awer(choruscommand[k*2],choruscommand[k*2+1]);
      dec(hw,val);
      awew(choruscommand[k*2],choruscommand[k*2+1],hw);
     end;
3,4: begin
     awerd(choruscommand[k*2],choruscommand[k*2+1],lw,hw);
     dec(lw,val);
     awewd(choruscommand[k*2],choruscommand[k*2+1],hw,lw);
     end;
5,6: begin
     k:=k-2;
     awerd(choruscommand[k*2],choruscommand[k*2+1],lw,hw);
     dec(hw,val);
     awewd(choruscommand[k*2],choruscommand[k*2+1],hw,lw);
     end;
end;
end;   }
{***************************************************}
procedure setchorus(effect:byte);
begin
if effect<9 then
 begin
 setchor(chorpara[effect].tab);
 wrt(62,53,bar,2,chorpara[effect].nom);
 end
end;
{***************************************************}
procedure enabledr;
var k:word;
scratch,hw,lw:word;
begin
stopplay;
awew($3e,$a20,$20);
for k:=0 to 29  do
  begin
  awew($a0+k,$a20,$80);
  awewd($60+k,$620,0,0);
  awewd($40+k,$620,0,0);
  awewd($c0+k,$620,0,0);
  awewd($e0+k,$620,0,0);
  awewd($20+k,$620,$4000,0);
  awewd($0+k,$620,$4000,0);
  scratch:=((k and 1) shl 9) +$400;
  awewd($0+k,$a20,scratch,0);
  end;
k:=0;
repeat
 awerd($36,$a20,lw,hw);
 inc(k);
until (hw and $8000=0) or (k>60000);

scratch:=0;
repeat
 awerd($34,$a20,lw,hw);
 inc(scratch);
until (hw and $8000=0) or (scratch>60000);

if (k>60000) or (scratch>60000)  then message(' AWE DRAM not responding ! ');

awewait($10);
end;
{***************************************************}
procedure disabledr;
var k,hw,lw,scratch:word;
begin

k:=0;
repeat
 awerd($36,$a20,lw,hw);
 inc(k);
until (hw and $8000=0) or (k>60000);

scratch:=0;
repeat
 awerd($34,$a20,lw,hw);
 inc(scratch);
until (hw and $8000=0) or (scratch>60000);
                     {
if (k>60000) or (scratch>60000)  then message(' AWE DRAM not responding ! ');
                      }

for k:=0 to 29 do
 begin
 awewd(k,$a20,0,0);
 awew($a0+k,$a20,$807f);
 end;
restart;

wrt(62,51,bar,2,w2d(2*(dramsize-awcp) shr 10)+' KB');
awewait($10);
end;
{***************************************************}
procedure initenv(k:byte);
begin
AWEw($A0+k,$A20,$80);
AWEw($C0+k,$A22,0);
AWEw($E0+k,$A20,0);
AWEw($00+k,$E20,$E000);
AWEw($20+k,$E20,$FF00);
AWEw($40+k,$E20,0);
AWEw($60+k,$E20,0);
AWEw($80+k,$E20,$18);
AWEw($A0+k,$E20,$18);
AWEw($C0+k,$E20,0);
AWEw($E0+k,$A22,0);
AWEw($A0+k,$A22,0);
AWEw($80+k,$A22,0);
AWEw($80+k,$A20,0);
AWEw($C0+k,$A20,0);
end;
{***************************************************}
procedure initsound(k:byte);
begin
AWEwD($20+k,$620,0,0);
AWEwD($60+k,$620,0,$FFFF);
AWEwD($C0+k,$620,0,0);
AWEwD($E0+k,$620,0,0);
AWEwD($00+k,$620,0,0);
AWEwD($40+k,$620,0,$FFFF);
AWEwD($00+k,$A20,0,0);
AWEwD($A0+k,$620,0,0);
AWEwD($80+k,$620,0,0);
AWEw($A0+k,$A20,$807F);
end;
{***************************************************}
procedure initawe;
var k:integer;
l:longint;
begin
awew($3d,$a20,$59);
awew($3e,$a20,$20);
awew($3f,$a20,0);

for k:=0 to 31	do initenv(k);
AWEWait(2);
for k:=0 to 31	do initsound(k);

awew($34,$a20,0);
awew($35,$a20,0);
awew($36,$a20,0);
awew($35,$a20,0);

initeffect(effectdata);
awewait($400);
for k:=0 to $13 do awewd($20+k,$a20,0,0);
initeffect2(effectdata);
initeffect2(effectdata2);
awewd($29,$a20,0,0);
awewd($2a,$a20,0,$83);
awewd($2d,$a20,0,$8000);
awewd($2e,$a20,0,0);
initeffect(effectdata2);

awew($be,$a20,$80);
awewd($de,$620,$ffff,$ffe0);
awewd($fe,$620,$7fff,$ffe8);
awewd($3e,$620,$70,$ff);
awewd($1e,$620,0,0);
awewd($1e,$a20,$ff,$ffe3);

awew($bf,$a20,$80);
awewd($df,$620,$00ff,$fff0);
awewd($ff,$620,$7fff,$fff8);
awewd($3f,$620,$70,$ff);
awewd($1f,$620,0,$8000);
awewd($1f,$a20,$ff,$fff3);

asm cli end;
portw[base+$802]:=$3e;
portw[base]:=0;
while ((portw[base+$802] and $1000)=0)  do ;
while ((portw[base+$802] and $1000)>0)  do ;

portw[base+2]:=$4828;
portw[base+$802]:=$3c;
portw[base+$400]:=0;
asm sti end;


awewd($7e,$620,$8000,$ffff);
awewd($7f,$620,$8000,$ffff);
awew($3f,$a20,6);
setreverb(revt);
setchorus(cht);
end;
{***************************************************}
procedure awenotof(vc,rel1,rel2:byte);
begin
awechanst[vc]:=true;
awew($a0+vc,$a20,$8000+(127-rel1));
awew($e0+vc,$a20,$8000+(127-rel2));
end;
{***************************************************}
procedure awenof(v:byte);
begin
with curr[v],awei[ins] do if afct then
 begin
 awenotof(canal,t[20],t[12]);
 afct:=false;

 if PSactive[v]=1 then begin
 awenotof(PSsecondchannel[v],t[20],t[12]);
 PSactive[v]:=0;
 end;

               {nnnnnnn}
 end;
end;
{***************************************************}
procedure awestopp;
var k:byte;
begin
for k:=0 to 29 do
 begin
 awenotof(k,0,0);
 PSactive[k]:=0;
 end;
end;
{***************************************************}
procedure awewrtp(p:longint);
 var lw,hw:word;
begin
repeat awerd($36,$a20,lw,hw) until (hw<$8000);
awewl($36,$a20,0,p);
port[base+$802]:=$3a;
end;
{***************************************************}
procedure awereadp(p:longint);
var hw,lw:word;
begin
repeat awerd($34,$a20,lw,hw) until (hw<$8000);
awewl($34,$a20,0,p);
awer($3a,$a20);
end;
{***************************************************}
function awpeek(p:longint):integer;
var hw,lw:word;
begin
repeat awerd($34,$a20,lw,hw) until (hw<$8000);
awewl($34,$a20,0,p);
awer($3a,$a20);
awpeek:=awer($3a,$a20);
end;
{***************************************************}
procedure awpoke(p:longint;w:word);
var hw,lw:word;
begin
repeat awerd($36,$a20,lw,hw) until (hw<$8000);
awewl($36,$a20,0,p);
awew($3a,$a20,w);
end;
{***************************************************}
procedure del(dep,fin:longint);
var wh,wl,k1:word;
begin
if fin <awcp then
begin
 enabledr;
 wh:=(awcp-fin) shr 16;
 wl:=(awcp-fin) and $ffff;
 awewl($34,$a20,0,fin);
 awewl($36,$a20,0,dep);
 awer($3a,$a20);
 port[base+$802]:=$3a;
  asm
    db 66h
    xor cx,cx
    mov cx,wh
    db 66h
    shl cx,16
    mov cx,wl
    mov dx,bs
   @loop:
    in ax,dx
    out dx,ax
    db 66h
    dec cx
    db 66h
   jne @loop
  end;
end;
awcp:=awcp-fin+dep;
for k1:=0 to maxwav do if (sample[k1].t[0]>dep) and ((sample[k1].loop and 3)=3) then
 begin
 dec(sample[k1].t[0],fin-dep);
 dec(svs[k1].ad,fin-dep);
 end;
disabledr;
end;
{***********************************************}
procedure dels(n:byte);
begin
with sample[n] do
 begin
  if (loop and 3=3) then del(t[0],t[0]+t[1]);
  t[0]:=0;
  t[1]:=0;
  t[2]:=0;
  t[3]:=0;
  t[4]:=0;
  binf:=0;
  loop:=0;
  nom:='        ';
 end;
end;
{***************************************************}
procedure aweupload16(n:word);
begin
asm
  mov di,sg
  mov es,di
  mov di,offs
  mov cx,n
  mov dx,bs
 @loop:
  in ax,dx
  stosw
  dec cx
 jne @loop
 end;
end;
{***************************************************}
procedure aweload16(n:word);
begin
 asm
  mov si,sg
  mov ds,si
  mov si,offs
  mov cx,n
  mov dx,bs
 @loop:
  lodsw
  out dx,ax
  dec cx
 jne @loop
 end;
end;
{***************************************************}
procedure aweload8ns(n:word);
begin
 asm
  mov si,sg
  mov ds,si
  mov si,offs
  mov cx,n
  mov dx,bs
 @loop:
  lodsb
  sub al,128
  shl ax,8
  out dx,ax
  dec cx
 jne @loop
 end;
end;
{***************************************************}
procedure aweupload8ns(n:word);
begin
 asm
  mov di,sg
  mov es,di
  mov di,offs
  mov cx,n
  mov dx,bs
 @loop:
  in ax,dx
  shr ax,8
  add ax,128
  stosb
  dec cx
 jne @loop
 end;
end;
{***************************************************}
procedure aweload8s(n:word);
begin
 asm
  mov si,sg
  mov ds,si
  mov si,offs
  mov cx,n
  mov dx,bs
 @loop:
  lodsb
  shl ax,8
  out dx,ax
  dec cx
 jne @loop
 end;
end;
{***************************************************}
procedure aweupload8s(n:word);
begin
 asm
  mov di,sg
  mov es,di
  mov di,offs
  mov cx,n
  mov dx,bs
 @loop:
  in ax,dx
  shr ax,8
  stosb
  dec cx
 jne @loop
 end;
end;
{*************************************************************}
procedure uploads(var g:file;fpos:longint;b,elem:byte;nb8:longint;rst:word);
var k:longint;
begin
if fpos>0 then seek(g,fpos);
if nb8>0 then for k:=1 to nb8 do
   begin
   if b=16 then begin aweupload16(4000);blockwrite(g,txtbuff,8000 div elem);end;
   if b=7 then  begin aweupload8s(4000);blockwrite(g,txtbuff,4000 div elem);end;
   if b=8 then  begin aweupload8ns(4000);blockwrite(g,txtbuff,4000 div elem);end;
   end;
if rst>0 then begin
  if b=16 then begin aweupload16(rst);blockwrite(g,txtbuff,(2*rst) div elem);end;
  if b=7 then  begin aweupload8s(rst);blockwrite(g,txtbuff,(1*rst) div elem);end;
  if b=8 then  begin aweupload8ns(rst);blockwrite(g,txtbuff,(1*rst) div elem);end;
           end;

end;
{*************************************************************}
procedure awloads(var g:file;fpos:longint;b:byte;smptai:longint);
var k,nb8,rst:longint;
interleave,intercnt,vnt:longint;
pixelcount:byte;
maxpix,minpix:byte;

begin

interleave:=smptai div 128;
intercnt:=0;vnt:=0;pixelcount:=0;
minpix:=16;maxpix:=16;
             {
if fpos>0 then seek(g,fpos); }
nb8:=smptai div 4000;
rst:=smptai mod 4000;
if nb8>0 then for k:=1 to nb8 do
         begin
         if b=16 then blockread(g,txtbuff,8000) else blockread(g,txtbuff,4000);
         vnt:=0;
         if b=16 then repeat
                      inc(intercnt);
                      if (txtbuff[vnt]) div 256 div 8+16>maxpix then
                         maxpix:=(txtbuff[vnt]) div 256 div 8+16;
                      if (txtbuff[vnt]) div 256 div 8+16<minpix then
                         minpix:=(txtbuff[vnt]) div 256 div 8+16;
                      inc(vnt);
                      if intercnt mod interleave=0 then begin
                               pixelpos[pixelcount]:=maxpix;
                               pixelneg[pixelcount]:=minpix;
                               maxpix:=(txtbuff[vnt]) div 256 div 8+16;
                               minpix:=maxpix;
                               inc(pixelcount);
                               end;
                      until vnt=4000;
         if b=7 then repeat
                      inc(intercnt);
                      if (txtbuff[vnt]) div 8+16>maxpix then
                         maxpix:=(txtbuff[vnt]) div 256 div 8+16;
                      if (txtbuff[vnt]) div 8+16<minpix then
                         minpix:=(txtbuff[vnt]) div 256 div 8+16;
                      inc(vnt);
                      if intercnt mod interleave=0 then begin
                               pixelpos[pixelcount]:=maxpix;
                               pixelneg[pixelcount]:=minpix;
                               maxpix:=(txtbuff[vnt]) div 8+16;
                               minpix:=maxpix;
                               inc(pixelcount);
                               end;
                      until vnt=4000;
         if b=8 then repeat
                      inc(intercnt);
                      if ((txtbuff[vnt]+128)and $ff) div 8+16>maxpix then
                         maxpix:=(txtbuff[vnt]) div 256 div 8+16;
                      if ((txtbuff[vnt]+128)and $ff) div 8+16<minpix then
                         minpix:=(txtbuff[vnt]) div 256 div 8+16;
                      inc(vnt);
                      if intercnt mod interleave=0 then begin
                               pixelpos[pixelcount]:=maxpix;
                               pixelneg[pixelcount]:=minpix;
                               maxpix:=((txtbuff[vnt]+128)and $ff) div 8+16;
                               minpix:=maxpix;
                               inc(pixelcount);
                               end;
                      until vnt=4000;
         if b=16 then aweload16(4000);
         if b=7 then  aweload8s(4000);
         if b=8 then aweload8ns(4000);
         end;
if rst>0 then begin
           if b=16 then blockread(g,txtbuff,2*rst) else
              blockread(g,txtbuff,rst);
           vnt:=0;
           if b=16 then repeat
                      inc(intercnt);
                      if (txtbuff[vnt]) div 256 div 8+16>maxpix then
                         maxpix:=(txtbuff[vnt]) div 256 div 8+16;
                      if (txtbuff[vnt]) div 256 div 8+16<minpix then
                         minpix:=(txtbuff[vnt]) div 256 div 8+16;
                      inc(vnt);
                      if intercnt mod interleave=0 then begin
                               if pixelcount<128 then pixelpos[pixelcount]:=maxpix;
                               if pixelcount<128 then pixelneg[pixelcount]:=minpix;
                               maxpix:=(txtbuff[vnt]) div 256 div 8+16;
                               minpix:=maxpix;
                               inc(pixelcount);
                               end;
                      until vnt=rst;

           if b=16 then aweload16(rst);
           if b=7 then aweload8s(rst);
           if b=8 then aweload8ns(rst);
           end;

inittextdraw;
for vnt:=0 to 127 do begin
for pixelcount:=0 to pixelneg[vnt]-1 do charboxpixel(vnt,pixelcount,0);
for pixelcount:=pixelneg[vnt] to pixelpos[vnt] do charboxpixel(vnt,pixelcount,1);
for pixelcount:=pixelpos[vnt]+1 to 31 do charboxpixel(vnt,pixelcount,0);
end;
closetextdraw;



for vnt:=0 to 127 do mem[seg(instrumentgraph^):vnt+csmp shl 8]:=pixelpos[vnt];
for vnt:=0 to 127 do mem[seg(instrumentgraph^):vnt+128+csmp shl 8]:=pixelneg[vnt];

end;
{***************************************************}
procedure savesmp(sam:byte);
var k:byte;
begin
with svs[sam] do
 begin
 awewl($34,$a20,0,ad-15);
 awer($3a,$a20);
 aweupload16(16);
 move(txtbuff[0],t[0],32);
 end;
end;
{***************************************************}
procedure restoresmp(sam:byte);
var k:byte;
begin
with svs[sam] do
 begin
 move(t[0],txtbuff[0],32);
 awewl($36,$a20,0,ad-15);
 port[base+$802]:=$3a;
 aweload16(16);
 end;
end;
{***************************************************}
procedure anticlick(sam:byte);
var k:byte;
    w,i:integer;
begin
if (sample[sam].loop and 3=3) then
begin
 enabledr;
 restoresmp(sam);
 with sample[sam] do
  if (loop>127) then
  begin
  if t[4]<t[3]+8 then t[3]:=t[4]-8;
  svs[sam].ad:=t[0]+t[4];
  savesmp(sam);
  awpoke(t[0]+t[4]-1,awpeek(t[0]+t[3]));
  awpoke(t[0]+t[4],awpeek(t[0]+t[3]+1));
  end else

  begin
  t[3]:=t[4]-7;
  svs[sam].ad:=t[0]+t[4];
  savesmp(sam);
  w:=txtbuff[0];
  for k:=1 to 7 do txtbuff[k]:=w-k*(w div 8);
  for k:=8 to 15 do txtbuff[k]:=0;
  awewl($36,$a20,0,t[0]+t[4]-15);
  port[base+$802]:=$3a;
  aweload16(16);
  end;
disabledr;
end;
end;
{***************************************************}
procedure reverse;
var li,nb8,oldt0,oldt1:longint;
    rst:word;
    oldloop:byte;
begin
with sample[csmp] do if t[1]<dramsize-awcp then
 begin
 enabledr;
 restoresmp(csmp);
 oldt0:=t[0];oldt1:=t[1];oldloop:=loop;
 li:=t[1];
 awewrtp(awcp);
 nb8:=li div 4000;rst:=li mod 4000;
 if nb8>0 then for li:=1 to nb8 do
    begin
    awereadp(t[0]+t[1]-li*4000);
    aweupload16(4000);
    asm
    mov cx,4000
    mov dx,bs
    lea si,txtbuff
    add si,7998
    std
    @loop:
     lodsw
     out dx,ax
     dec cx
    jne @loop
    cld
    end;
    end;
 if rst>0 then
    begin
    awereadp(t[0]);
    aweupload16(rst);
    asm
    mov cx,rst
    mov dx,bs
    lea si,txtbuff
    mov ax,cx;shl ax,1
    add si,ax
    sub si,2
    std
    @loop:
     lodsw
     out dx,ax
     dec cx
    jne @loop
    cld
    end;
    end;
 t[0]:=awcp;
 inc(awcp,t[1]);
 if loop and 3=1 then loop:=loop or 2;
 svs[csmp].ad:=t[0]+t[4];
 savesmp(csmp);
 disabledr;
 anticlick(csmp);
 if oldloop and 2 =2 then del(oldt0,oldt0+oldt1);
 end else message(' You not have enough free memory ');
end;
{***************************************************}
procedure makbidir;
var li,nb8,oldt0,oldt1:longint;
    rst:word;
    oldloop:byte;
begin
with sample[csmp] do if (t[4]-t[3]+t[4]+1)<dramsize-awcp then
 begin
 enabledr;
 restoresmp(csmp);
 awereadp(t[0]);awewrtp(awcp);
 oldt0:=t[0];oldt1:=t[1];oldloop:=loop;
 li:=t[4]-1;
 asm
  db 66h;mov cx,word ptr li
  db 66h;inc cx
  mov dx,bs
  @loop:
   in ax,dx
   out dx,ax
   db 66h;dec cx
  jne @loop
 end;
 li:=t[4]-t[3]-2;
 awewrtp(awcp+t[4]-1);
 nb8:=li div 4000;rst:=li mod 4000;
 if nb8>0 then for li:=1 to nb8 do
    begin
    awereadp(t[0]+t[4]-li*4000-2);
    aweupload16(4000);
    asm
    mov cx,4000
    mov dx,bs
    lea si,txtbuff
    add si,7998
    std
    @loop:
     lodsw
     out dx,ax
     dec cx
    jne @loop
    cld
    end;
    end;
 if rst>0 then
    begin
    awereadp(t[0]+t[3]);
    aweupload16(rst);
    asm
    mov cx,rst
    mov dx,bs
    lea si,txtbuff
    mov ax,cx;shl ax,1
    add si,ax
    sub si,2
    std
    @loop:
     lodsw
     out dx,ax
     dec cx
    jne @loop
    cld
    end;
    end;
 if loop and 3=1 then loop:=loop or 2;
 t[0]:=awcp;
 t[4]:=t[4]-2+t[4]-2-t[3]+1;
 t[1]:=t[4]+1;
 inc(awcp,t[1]);
 svs[csmp].ad:=t[0]+t[4];
 savesmp(csmp);
 disabledr;
 anticlick(csmp);
 if oldloop and 2 =2 then del(oldt0,oldt0+oldt1);
 end else message(' You not have enough free memory ');
end;
{***************************************************}
procedure normalize;
var maxim,tmp:integer;
    k,li:longint;
begin
with sample[csmp] do if (loop and 3)=3 then
 begin
 enabledr;
 restoresmp(csmp);
 maxim:=0;
 for k:=t[0] to t[0]+t[4] do
    begin
    tmp:=awpeek(k);
    if abs(tmp)>maxim then
          begin
          maxim:=abs(tmp);
          li:=k-t[0];
          end;
    end;

 if (maxim<32767) and (maxim>0) then
   begin
   for k:=t[0] to t[0]+t[4] do
       begin
       li:=awpeek(k);
       li:=(li*32767) div maxim;
       awpoke(k,li);
       end;
   end;
 savesmp(csmp);
 disabledr;
 anticlick(csmp);
 end;
end;
{!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!}
procedure tube;
var maxim,tmp:integer;
    k,li:longint;
begin
with sample[csmp] do if (loop and 3)=3 then
 begin
 enabledr;
 restoresmp(csmp);
 maxim:=0;
 for k:=t[0] to t[0]+t[4] do
    begin
    tmp:=awpeek(k);
    if abs(tmp)>maxim then
          begin
          maxim:=abs(tmp);
          li:=k-t[0];
          end;
    end;

   begin
   for k:=t[0] to t[0]+t[4] do
       begin
       li:=awpeek(k);
       li:=round(sin(((li*32767)/maxim)/32767*0.5*pi)*32767);
       awpoke(k,li);
       end;
   end;
 savesmp(csmp);
 disabledr;
 anticlick(csmp);
 end;
end;

procedure crush;
var maxim,tmp:integer;
    k,li:longint;
begin
with sample[csmp] do if (loop and 3)=3 then
 begin
 enabledr;
 restoresmp(csmp);
 maxim:=0;
 for k:=t[0] to t[0]+t[4] do
    begin
    tmp:=awpeek(k);
    if abs(tmp)>maxim then
          begin
          maxim:=abs(tmp);
          li:=k-t[0];
          end;
    end;

   begin
   for k:=t[0] to t[0]+t[4] do
       begin
       li:=awpeek(k);
       li:=li and $c000;
       awpoke(k,li);
       end;
   end;
 savesmp(csmp);
 disabledr;
 anticlick(csmp);
 end;
end;

procedure invphase;
var maxim,tmp:integer;
    k,li:longint;
begin
with sample[csmp] do if (loop and 3)=3 then
 begin
 enabledr;
 restoresmp(csmp);
 maxim:=0;
 for k:=t[0] to t[0]+t[4] do
    begin
    tmp:=awpeek(k);
    if abs(tmp)>maxim then
          begin
          maxim:=abs(tmp);
          li:=k-t[0];
          end;
    end;

   begin
   for k:=t[0] to t[0]+t[4] do
       begin
       li:=awpeek(k);
       li:=not(li);
       awpoke(k,li);
       end;
   end;
 savesmp(csmp);
 disabledr;
 anticlick(csmp);
 end;
end;

procedure lofi;
var maxim,tmp:integer;
    k,li:longint;
    li2:longint;
begin
with sample[csmp] do if (loop and 3)=3 then
 begin
 enabledr;
 restoresmp(csmp);
 maxim:=0;
 for k:=t[0] to t[0]+t[4] do
    begin
    tmp:=awpeek(k);
    if abs(tmp)>maxim then
          begin
          maxim:=abs(tmp);
          li:=k-t[0];
          end;
    end;

   begin
   for k:=t[0] to t[0]+t[4] do
       begin
       li:=awpeek(k);
       if k=k shr 3 shl 3 then li2:=li;
       li:=li2;
       awpoke(k,li);
       end;
   end;
 savesmp(csmp);
 disabledr;
 anticlick(csmp);
 end;
end;

{!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!}
procedure expand;
var maxim,tmp:integer;
    k,li:longint;
begin
with sample[csmp] do if (loop and 3)=3 then
 begin
 enabledr;
 restoresmp(csmp);
 maxim:=0;
 for k:=t[0] to t[0]+t[4] do
    begin
    tmp:=awpeek(k);
    if abs(tmp)>maxim then
          begin
          maxim:=abs(tmp);
          li:=k-t[0];
          end;
    end;

   begin
   for k:=t[0] to t[0]+t[4] do
       begin
       li:=awpeek(k);
       if li>=0 then li:=round(     ( sin( ((li*32767)/maxim)  /32767*0.5*pi -pi/2 )+1)*32700);
       if li<0 then li:=round(      ( sin( ((li*32767)/maxim)  /32767*0.5*pi +pi/2 )-1)*32700);


       awpoke(k,li);
       end;
   end;
 savesmp(csmp);
 disabledr;
 anticlick(csmp);
 end;
end;


{***************************************************}
procedure savewav(wan:string);
var waf:file;
var nb8:longint;
    rst:word;
    bb:byte;
    s:string[8];
    wah:wavheader;
    realzahl:real;

begin
chd(lastsampledir{savwavdircdir});
if cre(wan+'.WAV',waf,1) then  with sample[csmp] do with wah do
 begin
 realzahl:=523.25113*exp(t[5]/5909.445-10.418914)*44100;
 if realzahl>44100 then repeat realzahl:=realzahl*0.5 until realzahl<=44100;
 move(head,wah,44);
  if binf=16 then
   begin
   fs:=44+t[1]*2+38;
   avbps:=round(realzahl*2);
   sr:=round(realzahl);
   if t[5]=24580 then avbps:=44100*2;
   if t[5]=24580 then sr:=44100;
   bal:=2;
   bps:=16;
   nofb:=t[1]*2;
   end else
   begin
   fs:=44+t[1]+38;
   avbps:=round(realzahl);
   sr:=round(realzahl);
   if t[5]=24580 then avbps:=44100*2;
   if t[5]=24580 then sr:=44100;
   bal:=1;
   bps:=8;
   nofb:=t[1];
   end;
 blockwrite(waf,wah,44);
 enabledr;
 awewl($34,$a20,0,t[0]);
 awer($3a,$a20);
 restoresmp(csmp);
 nb8:=t[1] div 4000;
 rst:=t[1] mod 4000;
 if binf=7 then uploads(waf,0,8,1,nb8,rst) else uploads(waf,0,16,1,nb8,rst);
 s:='astawsmp';
 blockwrite(waf,s[1],8);
 bb:=loop;
 if (loop and 2)=0 then loop:=loop or 2;
 blockwrite(waf,t[1],30);
 close(waf);
 loop:=bb;
 disabledr;
 anticlick(csmp);
 waitrel;
 end;
end;


{***************SAMPLES************************************}
procedure aweloadxi16(n:word;var old:word);
begin
 asm
  les di,old
  mov bx,es:[di]
  mov si,sg
  mov ds,si
  mov si,offs
  mov cx,n
  mov dx,bs
 @loop:
  lodsw
  add ax,bx
  out dx,ax
  mov bx,ax
  dec cx
 jne @loop
  les di,old
  mov es:[di],bx
 end;
end;
{***************************************************}
procedure aweloadxi8(n:word;var old:word);
begin
 asm
  les di,old
  mov bx,es:[di]
  mov si,sg
  mov ds,si
  mov si,offs
  mov cx,n
  mov dx,bs
 @loop:
  lodsb
  shl ax,8
  add ax,bx
  out dx,ax
  mov bx,ax
  dec cx
 jne @loop
  les di,old
  mov es:[di],bx
 end;
end;
{***************************************************}
function load_xi(sam:byte;s:string;updatepos:boolean):boolean;
var xi:file;
    xih:smpHeader;
    bit:byte;
    i,j,k,old:word;
    nb8,rst:longint;
begin
load_xi:=false;
if ouvre(s,xi,1) then  with sample[sam] do with xih do
 begin
 if ((loop and 3)=3) and updatepos then dels(sam);
 seek(xi,298);
 blockread(xi,xih,sizeof(xih));
 t[0]:=awcp;
 t[2]:=0;

 case typ and 3 of
 0:loop:=$03;
 1,2:loop:=$83;
 end;
 if typ and $10=$10 then binf:=16 else binf:=7;
 if binf=7 then
   begin
   t[1]:=min(siz,dramsize-awcp);
   t[3]:=loopb;
   t[4]:=loopb+looplg;
  end else
   begin
   t[1]:=min(siz div 2,dramsize-awcp);
   t[3]:=loopb div 2;
   t[4]:=(loopb+looplg) div 2;
   end;

 if loop and $80=0 then
   begin
   t[4]:=t[1]-1;
   t[3]:=t[4]-8;
   end;

 nom:=fn2n(s);
 enabledr;
 awewrtp(awcp);
 port[base+$802]:=$3a;
  nb8:=t[1] div 4000;
  rst:=t[1] mod 4000;
  old:=0;
 if binf=16 then
   begin
     if nb8>0 then for k:=1 to nb8 do
       begin
       blockread(xi,txtbuff,8000);
       aweloadxi16(4000,old);
       end;
     if rst>0 then
        begin
        blockread(xi,txtbuff,2*rst);
        aweloadxi16(rst,old);
        end;
   end else
   begin
     if nb8>0 then for k:=1 to nb8 do
       begin
       blockread(xi,txtbuff,4000);
       aweloadxi8(4000,old);
       end;
     if rst>0 then
        begin
        blockread(xi,txtbuff,rst);
        aweloadxi8(rst,old);
        end;
   end;

 if updatepos then inc(awcp,t[1]);
 svs[sam].ad:=t[0]+t[4];
 savesmp(sam);
 disabledr;
 anticlick(sam);
 close(xi);
 load_xi:=true;
 if dramsize<=awcp then message(' Not enough Dram , only a part of sample is loaded');
 end else message(' Can''t open '+s);

end;
{***************************************************}
procedure fileloadXI(s:string);
var k:byte;
begin
if tmploadfile<>s then
  begin
  for k:=0 to 29 do awekey[k]:=0;
  tmploadfile:=s;
  move(txtbuff,b^,sizeof(tabfic));
  load_xi(128,s,false);
  move(vaw,awei[128].t[1],29);
  awei[128].t[1]:=cpan;
  awei[128].t[2]:=cch;
  awei[128].t[3]:=crev;
  awei[128].flg:=$ff;
  awei[128].t[0]:=128;
  move(b^,txtbuff,sizeof(tabfic));
  end;
playaweins(128);
end;
{***************************************************}
function loadxi:boolean;
var xin:string[12];
begin
loadxi:=false;
if getfic('*.xi        ',xin,' Select an XI file ',cwavdir,fileloadXI) then
 loadxi:=load_xi(csmp,xin,true);
end;
{***************************************************}
procedure fileloadXI_ins(s:string);
var k:byte;
begin
if tmploadfile<>s then
  begin
  for k:=0 to 29 do awekey[k]:=0;
  tmploadfile:=s;
  move(txtbuff,b^,sizeof(tabfic));
  load_xi(128,s,false);
  move(awei[cawei].t[1],awei[128].t[1],29);
  awei[128].flg:=awei[cawei].flg;
  awei[128].t[0]:=128;
  move(b^,txtbuff,sizeof(tabfic));
  end;
playaweins(128);
end;
{***************************************************}
function loadxi_ins:boolean;
var xin:string[12];
begin
loadxi_ins:=false;
if getfic('*.xi        ',xin,' Select an XI file ',cwavdir,fileloadXI_ins) then
 loadxi_ins:=load_xi(csmp,xin,true);
end;
{***************************************************}

procedure load_wav(sam:byte;s:string;updatepos:boolean);
var wav:file;
    tmpl:longint;
    wavh:wavheader;
label NoRiff;
begin
if ouvre(s,wav,1) then  with sample[sam] do with wavh do
 begin
 if ((loop and 3)=3) and updatepos then dels(sam);
 if dramsize-awcp>15 then
  begin
  enabledr;
  blockread(wav,wavh,44);

  if riff<>1179011410 then goto NoRiff;

  fs:=filesize(wav);
  binf:=bps;
  tmpl:=1635017060;
  if data<>tmpl then
   begin
   while (tmpl<>data) do blockread(wav,data,4);
   blockread(wav,nofb,4);
   end;

  if (binf=8) or (binf=16) then rien else binf:=16;
  if binf=16 then t[1]:=min(nofb div 2,dramsize-awcp) else
                  t[1]:=min(nofb ,dramsize-awcp);
  if (t[1]>fs) or (t[1]<44) then t[1]:=fs-44;

  if sr>44100 then repeat sr:=sr div 2 until sr<=44100;

  t[5]:=round((  ln(sr/(523.25*44100))  +10.4189 )*5909.445);


  awewl($36,$a20,0,awcp);
  portw[base+$802]:=$3a;
  awloads(wav,0,binf,t[1]);
   if binf=8 then binf:=7;
   t[0]:=awcp;
   if updatepos then inc(awcp,t[1]);
   t[2]:=0;
   t[4]:=t[1]-1;
   t[3]:=t[4]-8;
   loop:=3;
  nom:=fn2n(s);
  s[0]:=#8;
  blockread(wav,s[1],8);
  tmpl:=t[1];
  if s='astawsmp'then blockread(wav,t[1],30);
  if tmpl<t[1] then  begin
                     t[1]:=tmpl;
                     t[4]:=t[1]-1;
                     t[3]:=t[4]-8;
                     t[2]:=0;
                     end;
  if ioresult=0 then;
  svs[sam].ad:=t[0]+t[4];
  savesmp(sam);

  NoRiff:
  disabledr;
  close(wav);
  anticlick(sam);
  if dramsize<=awcp then message(' Not enough Dram , only a part of sample is loaded');
  end
 else message(' No more free memory');
 end
 else if s<>'' then message(' Can''t open '+s);

end;
{***************************************************}
procedure fileloadwav(s:string);
var k:byte;
begin
if tmploadfile<>s then
  begin
  for k:=0 to 29 do awekey[k]:=0;
  tmploadfile:=s;
  move(txtbuff,b^,sizeof(tabfic));
  load_wav(128,s,false);
  move(vaw,awei[128].t[1],29);
  awei[128].t[1]:=cpan;
  awei[128].t[2]:=cch;
  awei[128].t[3]:=crev;
  awei[128].flg:=$ff;
  awei[128].t[0]:=128;
  move(b^,txtbuff,sizeof(tabfic));
  end;
playaweins(128);
end;
{***************************************************}
procedure loadwav;
var wan:string[12];
begin
if getfic('*.wav       ',wan,' Select a WAV file ',cwavdir,fileloadwav) then
 load_wav(csmp,wan,true);
end;
{***************************************************}
procedure load_noform(sam,b:byte;s:string;updatepos:boolean);
var wav:file;
    k,k2,rst:word;
    nb8:longint;
    fl:boolean;
begin
if ouvre(s,wav,1) then  with sample[sam] do
  begin
  if ((loop and 3)=3) and updatepos then dels(sam);
  if dramsize-awcp>15 then
  begin
  enabledr;
  awewl($36,$a20,0,awcp);
  if b=16 then t[1]:=min((dramsize-awcp),filesize(wav) div 2)
          else t[1]:=min((dramsize-awcp),filesize(wav));
  portw[base+$802]:=$3a;
  awloads(wav,0,b,t[1]);
  if b=8 then b:=7;
  binf:=b;
  t[0]:=awcp;
  if updatepos then inc(awcp,t[1]);
  t[4]:=t[1]-1;
  t[2]:=0;
  loop:=3;
  nom:=fn2n(s);
  svs[sam].ad:=t[0]+t[4];
  savesmp(sam);
  disabledr;
  close(wav);
  anticlick(sam);
  if dramsize<=awcp then message(' Not enough Dram , only a part of sample is loaded');
  end
  else message('No more free memory');
  end
 else if s<>'' then message(' Can''t open '+s);

end;
{***************************************************}
procedure fileload8s(s:string);
var k:byte;
begin
if tmploadfile<>s then
  begin
  for k:=0 to 29 do awekey[k]:=0;
  tmploadfile:=s;
  move(txtbuff,b^,sizeof(tabfic));
  load_noform(128,7,s,false);
  move(vaw,awei[128].t[1],29);
  awei[128].t[1]:=cpan;
  awei[128].t[2]:=cch;
  awei[128].t[3]:=crev;
  awei[128].flg:=$ff;
  awei[128].t[0]:=128;
  move(b^,txtbuff,sizeof(tabfic));
  end;
playaweins(128);
end;
{***************************************************}
procedure fileload8u(s:string);
var k:byte;
begin
if tmploadfile<>s then
  begin
  for k:=0 to 29 do awekey[k]:=0;
  tmploadfile:=s;
  move(txtbuff,b^,sizeof(tabfic));
  load_noform(128,8,s,false);
  move(vaw,awei[128].t[1],29);
  awei[128].t[1]:=cpan;
  awei[128].t[2]:=cch;
  awei[128].t[3]:=crev;
  awei[128].flg:=$ff;
  awei[128].t[0]:=128;
  move(b^,txtbuff,sizeof(tabfic));
  end;
playaweins(128);
end;
{***************************************************}
procedure fileload16(s:string);
var k:byte;
begin
if tmploadfile<>s then
  begin
  for k:=0 to 29 do awekey[k]:=0;
  tmploadfile:=s;
  move(txtbuff,b^,sizeof(tabfic));
  load_noform(128,16,s,false);
  move(vaw,awei[128].t[1],29);
  awei[128].t[1]:=cpan;
  awei[128].t[2]:=cch;
  awei[128].t[3]:=crev;
  awei[128].flg:=$ff;
  awei[128].t[0]:=128;
  move(b^,txtbuff,sizeof(tabfic));
  end;
playaweins(128);
end;
{***************************************************}
procedure load(b:byte);
var  wan:string[12];
     fl:boolean;
begin
if b=7 then fl:=getfic('*.*         ',wan,' Select a 8 bits signed file ',cwavdir,fileload8s)
else if b=16 then
fl:=getfic('*.*         ',wan,' Select a 16 bits file ',cwavdir,fileload16)
else
fl:=getfic('*.*         ',wan,' Select a 8 bits unsigned file',cwavdir,fileload8u);
if fl then load_noform(csmp,b,wan,true);
end;
{**************SAMPLES ENDE*************************************}



procedure affeffect;
var k:byte;
begin
win(10,10,35,39,'chorus and reverb');
waitrel;
repeat
for k:=0 to 8 do
 begin
 wrtmb(2,3*k+2,cdef,chorpara[k].nom);
 wrtmb(14,3*k+2,cdef,revpara[k].nom);
 end;
wrtmb(2,3*cht+2,surb,chorpara[cht].nom);
wrtmb(14,3*revt+2,surb,revpara[revt].nom);
wait;
if lb then begin
           if mouin(1,1,13,27) then cht:=(my-1) div 3;
           if mouin(14,1,25,27) then revt:=(my-1) div 3;
           end;
setchorus(cht);
setreverb(revt);
until wkey=1;
waitrel;
wkey:=0;
restwin;
end;
{***************************************************}
procedure seteffect(val,v:byte);
var k:byte;
begin
k:=val and $0f;
val:=val shr 4;
if val<9 then begin cht:=val;setchorus(val);end;
if   k<9 then begin revt:=k;setreverb(k);end;
end;
{***************************************************}
procedure resample;
var wh,wl:word;
begin
waitrel;
if (sample[csmp].loop and 3=3) then
 begin
 enabledr;
 restoresmp(csmp);
 with sample[csmp]  do begin
  awewl($34,$a20,0,t[0]);
  awewl($36,$a20,0,t[0]);
 awer($3a,$a20);
 port[base+$802]:=$3a;
 t[1]:=t[1] div 2;
 wh:=t[1] shr 16;
 wl:=t[1] and $ffff;
    asm
    db 66h;xor cx,cx
    mov cx,wh
    db 66h;shl cx,16
    mov cx,wl
    mov dx,bs
    @loop:
     in ax,dx
     out dx,ax
     in ax,dx
     db 66h;dec cx
    jne @loop
    end;

  del(t[0]+t[1],t[0]+t[1]*2);
  t[2]:=t[2] div 2;
  t[4]:=t[4] div 2;
  t[3]:=t[3] div 2;
  t[5]:=max(0,t[5]-4096);
  svs[csmp].ad:=t[0]+t[4];
  savesmp(csmp);
  end;
 disabledr;
 anticlick(csmp);
end;
end;

          {
procedure resample2;
var wh,wl:word;
lngint:longint;
realzahl:real;
rz2:real;
freqzahl:word;
begin
waitrel;
freqzahl:=sample[csmp].t[5] mod 4096;

if ((freqzahl>34) and (freqzahl<4070))=true
then
if (sample[csmp].loop and 3=3) then
 begin

 enabledr;
 restoresmp(csmp);
 with sample[csmp]  do begin
  awewl($34,$a20,0,t[0]);
  awewl($36,$a20,0,t[0]);
 awer($3a,$a20);
 port[base+$802]:=$3a;

 realzahl:=1/exp(t[5]/5909.445-10.418914);
 realzahl:=523.25113/realzahl;
 if realzahl<1 then repeat realzahl:=realzahl*2 until realzahl>1;
 if realzahl>2 then repeat realzahl:=realzahl*0.5 until realzahl<2;
 t[1]:=round(t[1]/realzahl);
 rz2:=realzahl;
 realzahl:=realzahl-1;
 realzahl:=realzahl*16384;
 freqzahl:=round(realzahl);

 wh:=t[1] shr 16;
 wl:=t[1] and $ffff;
    asm
    cli
    db 66h;xor cx,cx
    mov cx,wh
    db 66h;shl cx,16
    mov cx,wl
    mov dx,bs
    mov bx,0
    mov es,bx
    @loop:
      mov bx,es
      add bx,freqzahl
      mov es,bx
      cmp bx,16384
      jb @loop2
        sub bx,16384
        mov es,bx

        in ax,dx
        sar ax,1
        mov bx,ax
        in ax,dx
        sar ax,1
        add ax,bx
        out dx,ax

        jmp @loop3
      @loop2:
      in ax,dx
      out dx,ax

    @loop3:
     db 66h;dec cx
    jne @loop
    sti
    end;

  del(t[0]+t[1],t[0]+round(t[1]*rz2));
  t[2]:=round(t[2]/rz2);
  t[4]:=round(t[4]/rz2);
  t[3]:=round(t[3]/rz2);
  t[5]:=24580;
  svs[csmp].ad:=t[0]+t[4];
  savesmp(csmp);

  end;
 disabledr;
 anticlick(csmp);
end;
end;     }
{***************************************************}
function newvoice:byte;
var k,tmp:byte;
    di,dl:word;
    Lbg,lend,plpos:longint;
    bool:boolean;
begin

lbg:=29;
k:=0;
lend:=65535;
if not btmode then
 begin
 for k:=0 to 29 do if awechanst[k] then
   begin
   awerd($60+k,$620,dl,di);
   if lend>=di then
      begin
      lend:=di;
      lbg:=k;
      end;
   end;
 end else
 begin
 for k:= 0 to 29 do if awechanst[k] then
   begin
   awerd($60+k,$620,dl,di);
   if lend>=di then
      begin
      tmp:=0;
      repeat
       with curr[tmp] do bool:=(canal=k) and (drief=3);
       inc(tmp);
      until bool or (tmp=33);
      if not bool then
        begin
        lend:=di;
        lbg:=k;
        end;
      end;
   end;
 end;


newvoice:=lbg;
end;
{***************************************************}
function i2d(i:integer):string;
var s:string;
begin
str(i,s);
i2d:=s;
end;
{***************************************************}
procedure affsample;
var k,mi,ma:byte;
begin
clearec(1,1,78,16,cdef);
clearec(1,17,78,32,c4def);

with sample[csmp] do if (loop and 1 =1) then
 begin
 enabledr;
 awereadp(t[0]+t[3]-39);
 aweupload16(78);
 mi:=39-min(39,t[3]);
 ma:=38+min(39,t[1]-t[3]);
 lineh(1,9,77,cdef,fonpat,#207);
 lineh(1,25,77,c4def,fonpat,#207);
 linev(40,1,32,bar,bar,#32);
 for k:=mi to ma do wrtw(k+1,1+(txtbuff[k]+32768) shr 12,cdef,15,chr(((txtbuff[k]+32768) shr 9) and 7+207));
 k:=39;
 wrtw(k+1,1+(txtbuff[k]+32768) shr 12,bar,15,chr(((txtbuff[k]+32768) shr 9) and 7+207));
 wrtw(73,16,cdef,fonpat,i2d(-txtbuff[39]));
 awereadp(t[0]+t[4]-41);
 aweupload16(78);
 disabledr;
 mi:=39-min(39,t[4]-2);
 ma:=38+min(39,t[1]-t[4]+2);
 for k:=mi to ma do wrtw(k+1,17+(txtbuff[k]+32768) shr 12,c4def,15,
                        chr(((txtbuff[k]+32768) shr 9) and 7+207));
 k:=39;
 wrtw(k+1,17+(txtbuff[k]+32768) shr 12,bar,15,
                        chr(((txtbuff[k]+32768) shr 9) and 7+207));
 wrtw(73,32,c4def,fonpat,i2d(-txtbuff[39]));
 end;
end;
{***************************************************}
procedure awafnom2;
var kf:byte;
begin
for kf:= 0 to 14 do wrtw(56,34+kf,fonpat,1,'   '+''+'        '+''+'         ');

for kf:= max(csmp-7,0) to min(csmp+7,maxwav) do begin

 if sampleused[kf] then begin
      if sample[kf].loop and 3<>0 then wrtw(56,41+kf-csmp,fonpat,15,
         b2d(kf)+''+sample[kf].nom+''+l2d(sample[kf].t[1]))
         else wrtw(56,41+kf-csmp,fonpat,7,
         b2d(kf)+''+sample[kf].nom+''+l2d(sample[kf].t[1]))

 end else wrtw(56,41+kf-csmp,fonpat,7 ,b2d(kf)+''+sample[kf].nom+''+l2d(sample[kf].t[1]));

 end;

for kf:= max(csmp-7,0) to min(csmp+7,maxwav) do begin
    cnt2:=0;
    for cnt1:=0 to 126 do if awei[cnt1].t[0]=kf then inc(cnt2);
    if sample[kf].loop and 3=0 then wrtw(69,41+kf-csmp,fonpat,7,' ')
       else begin
            if cnt2<>0 then if sampleused[kf] then wrtw(69,41+kf-csmp,fonpat,15,'x')
                                              else wrtw(69,41+kf-csmp,fonpat,7,'x');
            if cnt2=0 then wrtw(69,41+kf-csmp,fonpat,7,'?');
            end;
end;




wrtw(56,41,6,txt,b2d(csmp)+''+sample[csmp].nom+''+l2d(sample[csmp].t[1]));
cnt2:=0;
for cnt1:=0 to 126 do if awei[cnt1].t[0]=csmp then inc(cnt2);
if sample[csmp].loop and 3=0 then wrtw(69,41,6,txt,' ')
               else begin
               if cnt2=0 then wrtw(69,41,6,txt,'?');
               if cnt2<>0 then wrtw(69,41,6,txt,'x');
               end;
end;
{****************************************************}
procedure load_int(sam:byte;s:string);
var f:file;
begin
if ouvre(s,f,1) then with sample[sam] do
                            begin
                            if (loop and 3=3) and (sam<>128) then dels(csmp);
                            loop:=1;
                            blockread(f,t[0],8);
                            t[2]:=0;
                            t[3]:=t[1]-8;
                            t[4]:=t[1]-1;
                            t[5]:=25258;
                            binf:=16;
                            close(f);
                            nom:=fn2n(s);
                            end;
end;
{****************************************************}
procedure fileloadint(s:string);
var k:byte;
begin
if tmploadfile<>s then
  begin
  for k:=0 to 29 do awekey[k]:=0;
  tmploadfile:=s;
  move(txtbuff,b^,sizeof(tabfic));
  load_int(128,s);
  move(vaw,awei[128].t[1],29);
  awei[128].t[1]:=cpan;
  awei[128].t[2]:=cch;
  awei[128].t[3]:=crev;
  awei[128].flg:=$ff;
  awei[128].t[0]:=128;
  move(b^,txtbuff,sizeof(tabfic));
  end;
playaweins(128);
end;
{****************************************************}
procedure loadint;
var fn:string[12];
begin
if getfic('*.ais       ',fn,'Select an AIS file',aitdir,fileloadint)
then load_int(csmp,fn);
awafnom2;
affsample;
end;

{***************************************************}
procedure awesmp;
var k,mk:byte;
    rf:longint;
    hw,lw:word;
    maxt:array[2..5] of longint;
    mint:array[2..5] of longint;
    oldv:array[2..4] of longint;
    getpos:byte;
    by,by2:byte;
    ih:integer;
    realzahl:real;
    freqzahl:longint;
    stx:string[8];
procedure drawgr;
var by,by2:byte;
begin
inittextdraw;
if sample[csmp].loop and 3<>1 then begin
for by:=0 to 127 do begin
     for by2:=0 to mem[seg(instrumentgraph^):by+csmp shl 8+128]-1 do
                  charboxpixel(by,by2,0);
              for by2:=mem[seg(instrumentgraph^):by+csmp shl 8+128] to
                  mem[seg(instrumentgraph^):by+csmp shl 8]
                  do charboxpixel(by,by2,1);
              for by2:=mem[seg(instrumentgraph^):by+csmp shl 8]+1 to 31 do
                  charboxpixel(by,by2,0);
              end;end else drawinternal;
if sample[csmp].loop <>3 then if sample[csmp].t[1]<>0 then begin
ih:=round(sample[csmp].t[3]/sample[csmp].t[1]*127);
for by2:=0 to 15 do charboxpixel(ih,by2*2,1);
for by2:=0 to 15 do charboxpixel(ih,by2*2+1,0);
ih:=round(sample[csmp].t[4]/sample[csmp].t[1]*127);
for by2:=0 to 15 do charboxpixel(ih,by2*2,1);
for by2:=0 to 15 do charboxpixel(ih,by2*2+1,0);
end;
closetextdraw;
end;
begin
for k:=0 to 29 do awekey[k]:=0;

win(1,1,80,50,'Sample Editor');
lineh(1,33,77,cdef,bar,#219);
wrtw(2,38,cdef,fonpat,'Base pitch:');
wrtw(2,35,cdef,fonpat,'Begin     :');
wrtw(2,36,cdef,fonpat,'Loop begin:');
wrtw(2,37,cdef,fonpat,'Loop end  :');
wrtw(2,39,cdef,fonpat,'Pitch in %:');
wrtw(2,40,cdef,fonpat,'Definition:');
wrtw(2,41,cdef,fonpat,'Memory    :');
wrtmb(2,43,cdef,' LOOP     :         ');
wrtw(2,46,cdef,fonpat,'Chorus :');
wrtw(2,47,cdef,fonpat,'Reverb :');
wrtw(2,48,cdef,fonpat,'Panora :');
wrtmb(25,35,cdef,'8Bit S');
wrtmb(25,38,cdef,'8bit U');
wrtmb(25,41,cdef,'16bit ');
wrtmb(25,44,cdef,'*.WAV ');
wrtmb(25,47,cdef,' ROM  ');
wrtmb(33,35,cdef,' Save ');
wrtmb(33,38,cdef,'Delete');
wrtmb(33,41,cdef,'      ');
wrtmb(33,44,cdef,'Instru');
wrtmb(33,47,cdef,'      ');
wrtmb(41,35,cdef,'Revers');
wrtmb(41,38,cdef,' Trim ');
wrtmb(41,41,cdef,'Resamp');
wrtmb(41,44,cdef,'Bidirl');
wrtmb(41,47,cdef,'Normal');
wrtmb(49,35,cdef,' Tube ');
wrtmb(49,38,cdef,'Impuls');
wrtmb(49,41,cdef,'Crush ');
wrtmb(49,44,cdef,' LoFi ');
wrtmb(49,47,cdef,'InvPhs');

getpos:=0;
mk:=2;
awafnom2;
affsample;
drawgr;


repeat
wrtw(13,46,fonpat,txt,b2d(cch));
wrtw(13,47,fonpat,txt,b2d(crev));
wrtw(13,48,fonpat,txt,b2d(cpan));
with sample[csmp] do
 begin
 acti(15,43,loop>127);
 if binf=16 then wrtw(14,40,cdef,txt,'16 bits') else
 if binf=7  then wrtw(14,40,cdef,txt,'8 bits ')
            else wrtw(14,40,cdef,txt,'       ');
 if (loop and 1 =0) then wrtw(14,41,cdef,txt,' unused  ')
    else if loop and 3= 3 then wrtw(14,41,cdef,txt,'  RAM    ')
    else if loop and 3= 1 then wrtw(14,41,cdef,txt,'  ROM    ') ;
 for k:=2 to 5 do wrtw(14,33+k,fonpat,txt,l2da(t[k],8));



 realzahl:=523.25113*exp(t[5]/5909.445-10.418914)*100;
 freqzahl:=round(realzahl);
 str(freqzahl,stx);
 wrtw(19-length(stx),39,cdef,txt,'  '+stx+'%');



 maxt[5]:=$ffff;
 maxt[4]:=t[1];
 maxt[3]:=t[4]-7;
 maxt[2]:=t[4];
 mint[2]:=0;
 mint[3]:=0;
 mint[4]:=15;
 mint[5]:=0;
 move(sample[csmp].t[2],oldv[2],12);

 case getpos of
   0:t[mk]:=getnum(14,33+mk,8,maxt[mk],mint[mk],t[mk],0,true);
   1:cch:=getnum(13,46,3,255,0,cch,3000,true);
   2:crev:=getnum(13,47,3,255,0,crev,3000,true);
   3:cpan:=getnum(13,48,3,255,0,cpan,3000,true);
 end;

 if (t[3]<>oldv[3]) or (t[4]<>oldv[4]) then  begin
                                             anticlick(csmp);
                                             affsample;
                                             end;
 if (t[2]>=t[4]) then t[2]:=t[4];
 end;
if lb then
 begin

 if mouin(32,40,39,42) then wkey:=kf1 else

 if mouin(32,43,39,45) then wkey:=kf3 else
 if mouin(32,46,39,48) then affeffect else
 if mouin(1,42,22,44) then wkey:=57 else
 if mouin(56,34,78,40) or mouin(56,42,78,48) then
                           begin
                          if (my-41+csmp>=0) and(my-41+csmp<=maxwav)
                          then csmp:=my-41+csmp;
                          awafnom2;
                          affsample;
                          waitrel
                          end else
if mouin(60,41,67,41) then  begin
                      if (my-41+csmp>=0) and(my-41+csmp<=maxwav)
                          then csmp:=my-41+csmp;
                          awafnom2;
                          affsample;
                          sample[csmp].nom:=getchai(60,41,8,sample[csmp].nom);
                          awafnom2;

                          end else
if mouin(40,40,47,42) then begin
                         if (sample[csmp].loop and 3=3) then resample;
                         awafnom2;
                         affsample;
                         end else
(*if mouin(48,46,55,48)  then begin
                         if (sample[csmp].loop and 3=3) then begin {resample2;}end;
                         awafnom2;
                         affsample;
                         end else      *)
if mouin(40,43,47,45) then begin
                         if sample[csmp].t[2]<>sample[csmp].t[3] then makbidir;
                         awafnom2;
                         affsample;
                         end else
if mouin(40,46,47,48) then begin
                         normalize;
                         for by2:=0 to 127 do pixelpos[by2]:=
                             mem[seg(instrumentgraph^):by2+csmp shl 8];
                         for by2:=0 to 127 do pixelneg[by2]:=
                             mem[seg(instrumentgraph^):by2+csmp shl 8+128];
                         by:=16;
                         for by2:=0 to 127 do begin
                         if pixelpos[by2]>by then by:=pixelpos[by2];
                         if pixelneg[by2]>(abs(16-by)+16) then by:=abs(16-pixelneg[by2])+16;
                         end;
                         for by2:=0 to 127 do begin
                         ih:=(mem[seg(instrumentgraph^):by2+csmp shl 8]-16);
                         ih:=ih*32 div (by);
                         mem[seg(instrumentgraph^):by2+csmp shl 8]:=ih+16;
                         end;
                         for by2:=0 to 127 do begin
                         ih:=(mem[seg(instrumentgraph^):by2+csmp shl 8+128]-16);
                         ih:=ih*32 div (by);
                         mem[seg(instrumentgraph^):by2+csmp shl 8+128]:=16+ih;
                         end;
                         awafnom2;
                         affsample;
                         waitrel;
                         end else
if mouin(40,34,47,36) then begin
                         reverse;
                         for by2:=0 to 127 do pixelpos[by2]:=
                             mem[seg(instrumentgraph^):by2+csmp shl 8];
                         for by2:=0 to 127 do mem[seg(instrumentgraph^):by2+csmp shl 8]:=
                             pixelpos[127-by2];
                         for by2:=0 to 127 do pixelpos[by2]:=
                             mem[seg(instrumentgraph^):by2+csmp shl 8+128];
                         for by2:=0 to 127 do mem[seg(instrumentgraph^):by2+csmp shl 8+128]:=
                             pixelpos[127-by2];
                         awafnom2;
                         affsample;
                         end else
if mouin(40,37,47,39) then begin
                         with sample[csmp] do begin
                           {if t[2]<>t[3] then}
                           begin
                           for by2:=0 to 127 do pixelpos[by2]:=
                             mem[seg(instrumentgraph^):by2+csmp shl 8];
                           for by2:=0 to 127 do
                              mem[seg(instrumentgraph^):by2+csmp shl 8]:=
                              pixelpos[round(by2*(t[3]/t[1]))];
                           for by2:=0 to 127 do pixelpos[by2]:=
                             mem[seg(instrumentgraph^):by2+csmp shl 8+128];
                           for by2:=0 to 127 do
                              mem[seg(instrumentgraph^):by2+csmp shl 8+128]:=
                              pixelpos[round(by2*(t[3]/t[1]))];
                           rf:=min(t[2],t[3]);
                           del(t[0],t[0]+rf);
                           for k:=1 to 4 do dec(t[k],rf);
                           rf:=t[1]-t[4]-1;
                           del(t[0]+t[4]+1,t[0]+t[1]);
                           dec(t[1],rf);
                           svs[csmp].ad:=t[0]+t[4];
                           awafnom2;
                           affsample;
                           end;

                           end;
                         end else
if mouin(13,35,22,38) then  begin
                             mk:=my-33;
                             getpos:=0;
                             end else
if mouin(24,40,31,42) then wkey:=$400+28 else
if mouin(24,37,31,39) then begin
                          load(8);
                          awafnom2;
                          affsample;
                          end else

if mouin(24,34,31,36) then begin
                          load(7);
                          awafnom2;
                          affsample;
                          end else
if mouin(24,43,31,45) then wkey:=28 else
if mouin(32,34,39,36) then begin
                         if sample[csmp].loop and 1=1 then savewav(sample[csmp].nom);
                         end else
if mouin(32,37,39,39) then wkey:=ksup else
if mouin(24,46,31,48) then wkey:=$800+28 else
if mouin(12,46,16,46) then getpos:=1
                           else
if mouin(12,47,16,47) then getpos:=2
                           else
if mouin(12,48,16,48) then getpos:=3
                           else
if mouin(48,34,55,36) then begin
                      tube;

                      for by2:=0 to 127 do pixelpos[by2]:=
                             mem[seg(instrumentgraph^):by2+csmp shl 8];
                      for by2:=0 to 127 do pixelneg[by2]:=
                             mem[seg(instrumentgraph^):by2+csmp shl 8+128];
                      by:=16;
                      for by2:=0 to 127 do begin
                         if pixelpos[by2]>by then by:=pixelpos[by2];
                         if pixelneg[by2]>(abs(16-by)+16) then by:=abs(16-pixelneg[by2])+16;
                         end;

                      for by2:=0 to 127 do begin
                         ih:=(mem[seg(instrumentgraph^):by2+csmp shl 8]-16);
                         ih:=round(  sin( ih*32/by /16*pi/2)*15   );
                         mem[seg(instrumentgraph^):by2+csmp shl 8]:=ih+16;
                         end;
                      for by2:=0 to 127 do begin
                         ih:=(mem[seg(instrumentgraph^):by2+csmp shl 8+128]-16);
                         ih:=round(  sin( ih*32/by /16*pi/2)*15   );
                         mem[seg(instrumentgraph^):by2+csmp shl 8+128]:=16+ih;
                         end;

                      awafnom2;
                      affsample;
                      waitrel;
                      end else
if mouin(48,40,55,42) then begin
                      crush;

                      for by2:=0 to 127 do pixelpos[by2]:=
                             mem[seg(instrumentgraph^):by2+csmp shl 8];
                      for by2:=0 to 127 do pixelneg[by2]:=
                             mem[seg(instrumentgraph^):by2+csmp shl 8+128];
                      by:=16;
                      for by2:=0 to 127 do begin
                         if pixelpos[by2]>by then by:=pixelpos[by2];
                         if pixelneg[by2]>(abs(16-by)+16) then by:=abs(16-pixelneg[by2])+16;
                         end;

                      for by2:=0 to 127 do begin
                         ih:=(mem[seg(instrumentgraph^):by2+csmp shl 8]-16);
                         ih:=ih div 8*8;
                         mem[seg(instrumentgraph^):by2+csmp shl 8]:=ih+16;
                         end;
                      for by2:=0 to 127 do begin
                         ih:=(mem[seg(instrumentgraph^):by2+csmp shl 8+128]-16);
                         ih:=ih div 8 *8;
                         mem[seg(instrumentgraph^):by2+csmp shl 8+128]:=16+ih;
                         end;

                      awafnom2;
                      affsample;
                      waitrel;
                      end else
if mouin(48,37,55,39) then begin
                      expand;
                      for by2:=0 to 127 do pixelpos[by2]:=
                             mem[seg(instrumentgraph^):by2+csmp shl 8];
                      for by2:=0 to 127 do pixelneg[by2]:=
                             mem[seg(instrumentgraph^):by2+csmp shl 8+128];
                      by:=16;
                      for by2:=0 to 127 do begin
                         if pixelpos[by2]>by then by:=pixelpos[by2];
                         if pixelneg[by2]>(abs(16-by)+16) then by:=abs(16-pixelneg[by2])+16;
                         end;

                      for by2:=0 to 127 do begin
                         ih:=(mem[seg(instrumentgraph^):by2+csmp shl 8]-16);
                         ih:=round( ( sin( ih*32/by /16*pi/2-pi/2)+1)*15   );
                         mem[seg(instrumentgraph^):by2+csmp shl 8]:=ih+16;
                         end;
                      for by2:=0 to 127 do begin
                         ih:=(mem[seg(instrumentgraph^):by2+csmp shl 8+128]-16);
                         ih:=round( ( sin( ih*32/by /16*pi/2+pi/2)-1)*15   );
                         mem[seg(instrumentgraph^):by2+csmp shl 8+128]:=16+ih;
                         end;
                      awafnom2;
                      affsample;
                      waitrel;
                      end else
if mouin(48,45,55,48) then begin

                      invphase;
                      for by2:=0 to 127 do pixelpos[by2]:=
                             mem[seg(instrumentgraph^):by2+csmp shl 8];
                      for by2:=0 to 127 do pixelneg[by2]:=
                             mem[seg(instrumentgraph^):by2+csmp shl 8+128];
                      by:=16;
                      for by2:=0 to 127 do begin
                         if pixelpos[by2]>by then by:=pixelpos[by2];
                         if pixelneg[by2]>(abs(16-by)+16) then by:=abs(16-pixelneg[by2])+16;
                         end;

                      for by2:=0 to 127 do begin
                         ih:=(mem[seg(instrumentgraph^):by2+csmp shl 8]-16);
                         ih:=15-ih;
                         mem[seg(instrumentgraph^):by2+csmp shl 8]:=ih+16;
                         end;
                      for by2:=0 to 127 do begin
                         ih:=(mem[seg(instrumentgraph^):by2+csmp shl 8+128]-16);
                         ih:=15-ih;
                         mem[seg(instrumentgraph^):by2+csmp shl 8+128]:=16+ih;
                         end;

                      awafnom2;
                      affsample;
                      waitrel;
                      end;
if mouin(48,43,55,45) then begin
                      lofi;
                      end else

end;
case wkey of
 tab:if getpos<3 then inc(getpos) else getpos :=0;
 invtb:if getpos>0 then dec(getpos) else getpos:=3;

 $800+28:loadint;
 $400+28:begin
          load(16);
          awafnom2;
          affsample;
         end;
  57:begin
      if sample[csmp].loop>127
       then sample[csmp].loop:=sample[csmp].loop and $7f
       else sample[csmp].loop:=sample[csmp].loop or  $80;
      anticlick(csmp);
      affsample;
      waitrel;
     end;
 kSup:begin
     dels(csmp);
     awafnom2;
     affsample;
     for by:=0 to 255 do mem[seg(instrumentgraph^):by+csmp shl 8]:=16;

     end;
 28:begin
      loadwav;
      awafnom2;
      affsample;
     end;
 1069:begin
      loadxi;
      awafnom2;
      affsample;
      end;
 $800+31:if sample[csmp].loop and 1=1 then savewav(sample[csmp].nom);

 kf1:begin end;
 pgdn:if csmp<maxwav then  begin inc(csmp);awafnom2;affsample;

              end;
 pgup:if csmp>0 then  begin dec(csmp);awafnom2;affsample;

         end;
 kfh:if mk>2 then dec(mk);
 kfb:if mk<5 then inc(mk);

 3..53: if clv[wkey]<maxnote then
        begin
        midbr[0]:=$90;
        midbr[1]:=min(clv[wkey]+oct*12,127);
        midbr[2]:=$7f;
        end;
 $80+3..$80+53:if clv[wkey and $7f]<maxnote then
               begin
                midbr[0]:=$90;
                midbr[1]:=min(clv[wkey and $7f]+oct*12,127);
                midbr[2]:=$0;
               end;
   end;
case midbr[0] and $f0 of
$c0:begin
    csmp:=midbr[1];
    awafnom2;
    affsample;
    end;
$90:with sample[csmp] do if (loop and 1)=1 then if midbr[2]>0 then
         begin
         hw:=midbr[1];
         k:=0;
         while (k<29) and (awekey[k]<>hw) do inc(k);
         if awekey[k]<>hw then
           begin
           voice:=newvoice;
           awechanst[voice]:=false;
           awekey[voice]:=hw;
           awew($a0+voice,$a20,$807f);
           awew($a0+voice,$a20,$80);
           awewl($60+voice,$620,$00,$000000);
           awew($20+voice,$e20,$ff00+not(midbr[2]+$80));
           AWEw($60+voice,$E20,0);
           AWEw($80+voice,$E20,0);
           AWEw($A0+voice,$E20,0);
           awewl($c0+voice,$620,cpan,t[0]+t[3]);
           awewl($e0+voice,$620,cch,t[0]+t[4]-2);
           awewl($20+voice,$620,0,crev shl 8+not(cpan));
           awew($a0+voice,$a20,$7f7f);
           awew($e0+voice,$a20,$7f7f);
           awew(voice,$e20,min(65535,round(hw*341.33)+t[5]) );
           awewl(voice,$a20,$0,t[0]+t[2]);
           end;
         end else
          begin
           hw:=midbr[1];
           k:=0;
           while (k<29) and (awekey[k]<>hw) do inc(k);
               if awekey[k]=hw then
                      begin
                      awenotof(k,0,0);
                      awekey[k]:=0;
                      end;
          end;



end;


drawgr;


closetextdraw;

wrt(0,58,7,2,'  Waves directory                                             ');
wrt(0,59,2,15,'                                                              ');
wrt(0,59,2,15,'  '+lastsampledir);
wrt(0,58,7,2,#127);
wrt(0,59,2,7,#127);
wrt(61,58,1,7,#127);
wrt(61,59,7,2,#127);
until (wkey=1) or (wkey=kf3);

restwin;
defaultcharbox(0);
end;
{***************************************************}
procedure setcho(val,v:byte);
begin
with curr[v] do
 begin
 cho:=val;
 awewmhb($e0+canal,$620,cho);
 end;
end;
{***************************************************}
procedure setpan(val,v:byte);
var hl,ll:word;
begin
with curr[v] do
 begin
 pan:=val;
 awewmhb($c0+canal,$620,pan);
 awewlb($20+canal,$620,not(pan));
 end;
end;

procedure setpanvorh(val,v:byte);
var hl,ll:word;
begin
with curr[v-1] do
 begin
 pan:=val;
 awewmhb($c0+canal,$620,pan);
 awewlb($20+canal,$620,not(pan));
 end;
end;
{!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!}

{***************************************************}
procedure rndpan(val,v:byte);
var hl,ll:word;
begin
with curr[v] do
 begin
 pan:=random($ff);
 awewmhb($c0+canal,$620,pan);
 awewlb($20+canal,$620,not(pan));
 end;
end;
{***************************************************}
procedure setpmt(val,v:byte);
begin
if val >2 then curr[v].pmt:=val;
end;
{***************************************************}
procedure pmt2n(val,v:byte);
begin
val:=(val shr 4)*12+(val and $0f);
with curr[v] do with awei[ins] do if val<128 then
 begin
 xp:=fr;
 xp:=xp shl 7;
 adp:=integer( min(65535,val*341+sample[t[0]].t[5]-fr));
 adp:=(adp * 128) div pmt;
 pmtp:=pmt;
 end;
end;
{***************************************************}
procedure pitchsd(val,v:byte);
begin
with curr[v] do
 begin
 xp:=fr;
 xp:=xp shl 7;
 adp:=-min(fr,val shl 4);
 adp:=adp shl 4;
 pmtp:=8;
 end;
end;
{***************************************************}
procedure pitchsu(val,v:byte);
begin
with curr[v] do
 begin
 xp:=fr;
 xp:=xp shl 7;
 adp:=min($ffff-fr,val shl 4);
 adp:=adp shl 4;
 pmtp:=8;
 end;
end;
{***************************************************}
procedure combislide(val,v:byte);
begin
val:=(val shr 4)*12+(val and $0f);
with curr[v] do with awei[ins] do if val<128 then
 begin
 xp:=fr;
 xp:=xp shl 7;
 adp:=integer( min(65535,val*341+sample[t[0]].t[5]-fr));
 adp:=(adp * 128) div pmt;
 pmtp:=pmt;

 xf:=filt shl 7;;
 adf:=adp shr 7;
 pmtpf:=pmt;
 end;
end;

procedure pmt2f(val,v:byte);
begin
with curr[v] do
 begin
 adf:=integer(val-filt);
 xf:=filt shl 7;
 adf:=(adf*128) div pmtf;
 pmtpf:=pmtf;
 end;
end;
{***************************************************}
procedure filtersdt(val,v:byte);
var k:byte;
begin
k:=val and $0f;
val:=val shr 4;
if val>0 then with curr[v] do
 begin
 xf:=filt shl 7;
 adf:=-min(filt,k*16);
 adf:=(adf*128) div (8*val);
 pmtpf:=8*val;
 end;
end;
{***************************************************}
procedure filtersd(val,v:byte);
begin
with curr[v] do
 begin
 xf:=filt shl 7;
 adf:=-min(filt,val);
 adf:=adf shl 4;
 pmtpf:=8;
 end;
end;
{***************************************************}
procedure filtersu(val,v:byte);
begin
with curr[v] do
 begin
 xf:=filt shl 7;
 adf:=min(255-filt,val);
 adf:=adf shl 4;
 pmtpf:=8;
 end;
end;
{***************************************************}
procedure volsd(val,v:byte);
begin
with curr[v] do
 begin
 xv:=vol shl 7;
 adv:=-min(vol,val);
 adv:=adv shl 4;
 pmtvol:=8;
 end;
end;
{***************************************************}
procedure volsu(val,v:byte);
begin
with curr[v] do
 begin
 xv:=vol shl 7;
 adv:=min(127-vol,val);
 adv:=adv shl 4;
 pmtvol:=8;
 end;
end;
{!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!}
{***************************************************}
procedure pansd(val,v:byte);
begin
with curr[v] do
 begin
 xs:=pan shl 7;
 ads:=-min(pan,val);
 ads:=ads shl 4;
 pmtpan:=8;
 end;
end;
{***************************************************}
procedure pansu(val,v:byte);
begin
with curr[v] do
 begin
 xs:=pan shl 7;
 ads:=min(255-pan,val);
 ads:=ads shl 4;
 pmtpan:=8;
 end;
end;
{***************************************************}
procedure setpmtf(val,v:byte);
begin
if val >2 then curr[v].pmtf:=val;
end;
{***************************************************}
procedure setf(val,v:byte);
begin
val:=(val shr 4)*12+(val and $0f);
with curr[v] do with awei[ins] do if val<119 then
 begin
 fr:=min(65535,val*341+sample[t[0]].t[5]);
 awew(canal,$e20,fr);
 end;
end;
{***************************************************}
procedure setlfo1f(val,v:byte);
begin
with curr[v] do with awei[ins] do
 begin
 lfo1f:=val;
 awew($80+canal,$e20,t[23] shl 8+lfo1f);
 end;
end;
{***************************************************}
procedure setlfo2f(val,v:byte);
begin
with curr[v] do with awei[ins] do
 begin
 lfo2f:=val;
 awew($a0+canal,$e20,t[28] shl 8+lfo2f);
 end;
end;
{***************************************************}
procedure vibrato(val,v:byte);
var spd,dep:word;
begin
dep:=val;
spd:=(dep shr 4)*16+7;
dep:=(dep and $0f) shl 3;
with curr[v] do
 begin
 awew($e0+canal,$a22,$8000);
 awew($a0+canal,$e20,dep shl 8 +spd);
 end;
end;
{***************************************************}
procedure tremolo(val,v:byte);
var spd,dep:word;
begin
dep:=val;
spd:=(dep shr 4)*16+7;
dep:=(dep and $0f) shl 3;
with curr[v] do
 begin
 awew($a0+canal,$a22,$8000);
 awew($80+canal,$e20,dep shl 8 +spd);
 end;
end;
{***************************************************}
procedure startlfo(val,v:byte);
begin
with curr[v] do with awei[ins] do
 begin
 if (val and $f0)>0 then awew($a0+canal,$a22,(128-t[21]) shl 8);
 if (val and $0f)>0 then awew($e0+canal,$a22,(128-t[26]) shl 8)
 end;
end;
{***************************************************}
procedure setrev(val,v:byte);
var hl,ll:word;
begin
with curr[v] do
 begin
 rev:=val;
 awewhb($20+canal,$620,rev);
 end;
end;
{***************************************************}
procedure setfilter(val,v:byte);
begin
with curr[v] do with awei[ins] do
 begin
 filt:=val;
 awew($20+canal,$e20,(filt shl 8) + not(vol+t[6]));
 pmtpf:=0;
 end;
end;
{***************************************************}
procedure setfilterp(val,v:byte);
begin
if v>0 then
with curr[v-1] do with awei[ins] do
 begin
 filt:=val;
 awew($20+canal,$e20,(filt shl 8) + not(vol+t[6]));
 pmtpf:=0;
 end;
end;
{***************************************************}
procedure rndfilter(val,v:byte);
begin
with curr[v] do with awei[ins] do
 begin
 filt:=val+random($ff-val);
 awew($20+canal,$e20,(filt shl 8) + not(vol+t[6]));
 pmtpf:=0;
 end;
end;
{***************************************************}
procedure sampleof(val,v:byte);
var awplaypos:longint;
begin
with curr[v] do with awei[ins] do
 begin
 awplaypos:=val*(sample[t[0]].t[4]-sample[t[0]].t[2]) div 256
       +sample[t[0]].t[0]+sample[t[0]].t[2];
 awewl(canal,$a20,fltq shl 4,awplaypos);
 end;
end;





{!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!}
procedure offsetcut(val,v:byte);
var awplaypos:longint;
begin

with curr[v] do with awei[ins] do
 begin
 notcut:=3;
 awplaypos:=val*(sample[t[0]].t[4]-sample[t[0]].t[2]) div 256
       +sample[t[0]].t[0]+sample[t[0]].t[2];
 awewl(canal,$a20,fltq shl 4,awplaypos);
 end;
end;



{***************************************************}
procedure sampleof_FT(val,v:byte);
var awplaypos:longint;
begin
with curr[v] do with awei[ins] do
 begin
 awplaypos:=val;
 awplaypos:=awplaypos* 256 +sample[t[0]].t[0]+sample[t[0]].t[2];
 awewl(canal,$a20,fltq shl 4,awplaypos);
 end;
end;
{***************************************************}
procedure awchi(val,v:byte);
begin
curr[v].ins:=val and $7f;
{if val<127 then lastinstsetval:=val; }
instinfo;
end;
{***************************}
procedure awefmrev(val,v:byte);
begin
awewd($3f,$620,0,val shl 8 +$ff);
end;
{***************************}
procedure awe2filt(val,v:byte);
begin
with curr[v] do with awei[ins] do
 begin
 e12f:=val;
 awew($40+canal,$e20,e12p shl 8+e12f);
 end;
end;
{***************************}
procedure setdecay2(val,v:byte);
begin
with curr[v] do with awei[ins] do
 begin
  awew($80+canal,$a22,$7f00+(127-t[19]));
  awew($a0+canal,$a20,(t[16] shl 8)+(127-val));
 end;
end;
{***************************}
procedure setl12fi(val,v:byte);
begin
with curr[v] do with awei[ins] do
 begin
 l12f:=val;
 awew($60+canal,$e20,t[24] shl 8+l12f);
 end;
end;
{***************************}
procedure sete12pi(val,v:byte);
begin
with curr[v] do with awei[ins] do
 begin
 e12p:=val;
 awew($40+canal,$e20,e12p shl 8+e12f);
 end;
end;
{***************************}
procedure awefmcho(val,v:byte);
begin
awewl($fe,$620,val,$ffffe8);
awewl($ff,$620,val,$fffff8);
end;
{***************************************************}
procedure awecvo(val,v:byte);
begin
with curr[v] do  with awei[ins] do
begin
vol:=val;
if (sample[t[0]].loop and 1=1) then
  awew($20+canal,$e20,(filt shl 8)+not(vol+t[6]))
  else awew($20+canal,$e20,(filt shl 8)+255 );
end;
end;
{***************************************************}

procedure awecoc(var vc:byte;i:byte;n:word;vo:byte;var f,cho,rev,pan,lfo1f,lfo2f,fltq,l12fi,e12fi,e12pi:byte;setplp:boolean);
var rf:longint;
    hw,lw:word;
begin
with awei[i] do
 begin
 if btmode and (not setplp) then hw:=vc else hw:=newvoice;
 awecopyw($a0,$a22,vc,hw);
 awecopyw($e0,$a22,vc,hw);
 vc:=hw;
 awew($a0+vc,$a20,$807f);
 awew($a0+vc,$a20,$80);
 awewl($60+vc,$620,$00,$000000);

if (flg and 4 )>0 then f:=t[4];
if (flg and 8 )>0 then lfo1f:=t[22];
if (flg and 16)>0 then cho:=t[2];
if (flg and 32)>0 then rev:=t[3];
if (flg and 64)>0 then pan:=t[1];
if (flg and 128)>0 then lfo2f:=t[27];
if (t[5] and $10)=0 then fltq:=t[5] and $0f;
if (t[5] and $20)=0 then l12fi:=t[25];
if (t[5] and $40)=0 then e12fi:=t[13];
if (t[5] and $80)=0 then e12pi:=t[14];

awewd($20+vc,$620,hw,rev shl 8+not(pan));

awew(vc,$e20,n);

awew($80+vc,$a22,(127-t[18]) shl 8+(127-t[19]));
awew($c0+vc,$a22,(127-t[10]) shl 8+(127-t[11]));

if (sample[t[0]].loop and 1=1) then awew($20+vc,$e20,(f shl 8)+not(vo+t[6]))
  else awew($20+vc,$e20,(f shl 8)+255 );
awew($40+vc,$e20,e12pi shl 8+e12fi);
awew($60+vc,$e20,t[24] shl 8+l12fi);
awew($80+vc,$e20,t[23] shl 8+lfo1f);
awew($a0+vc,$e20,t[28] shl 8+lfo2f);

awewl($c0+vc,$620,pan,sample[t[0]].t[0]+sample[t[0]].t[3]);
awewl($e0+vc,$620,cho,sample[t[0]].t[0]+sample[t[0]].t[4]-2);


with awetb[vc] do
 begin
 plp:=sample[t[0]].t[0]+sample[t[0]].t[2];
 fltqb:=(fltq and $0f) shl 4;
 if (not btmode) or (plstat=0) or setplp then
     begin
     awewl(vc,$a20,fltqb,plp);
     if (flg and 1)<>0  then awew($a0+vc,$a22,(128-t[21]) shl 8);
     if (flg and 2)<>0  then awew($e0+vc,$a22,(128-t[26]) shl 8);
     awew($80+vc,$a20,(128-t[15]) shl 8);
     awew($c0+vc,$a20,(128-t[7]) shl 8);
     awew($e0+vc,$a20,(t[8] shl 8)+(127-t[9]));
     awew($a0+vc,$a20,(t[16] shl 8)+(127-t[17]));
     end;
 instrum:=i;
 setpp:=true;
 wait2setpp:=true;
 end;

end;
end;
{***************************************************}
procedure aweco(co:com;v:byte);
begin
with curr[v] do with awei[ins] do if (co.eff<>82) or (plstat=0) then
 begin
 lno:=co;
 vol:=co.vel and 127;
 pmtp:=0;
 fr:=min(65535,round(co.note*341.33)+sample[t[0]].t[5]);
 awenof(v);
 awecoc(canal,ins,fr,vol,filt,cho,rev,pan,lfo1f,lfo2f,fltq,l12f,e12f,e12p,false);

 afct:=true;
 awechanst[canal]:=false;
 end;
end;

procedure tremor(val,v:byte);
begin
if playrow[v].eff=65 then if compt=playrow[v].val then
with curr[v] do with awei[ins] do if on then awew($20+canal,$e20,(filt shl 8)+not(1));
end;


procedure pitchshifttick(val,v:byte);
var xxxx:longint;
function hochzehn(jjj:real):real;
begin
hochzehn:=jjj*jjj*jjj*jjj*jjj*jjj*jjj*jjj*jjj*jjj;
end;
begin
if PSactive[v]<>1 then exit;
with curr[v] do with awei[ins] do
 begin
   if compt=4 then begin
      awewl(pssecondchannel[v],$a20,fltq shl 4,PSoffsetadder[v]-PSsamplesperviertel[v] shr 1
             +sample[t[0]].t[0]+sample[t[0]].t[2]);
      awew($20+pssecondchannel[v],$e20,(filt shl 8)+not(vol+t[6]-12));
   end;
   if compt=7 then begin
      awew($20+canal,$e20,(filt shl 8)+not(1+t[6]));
      end;
   if compt=3 then begin
      awew($20+pssecondchannel[v],$e20,(filt shl 8)+not(1+t[6]));
      end;
   if compt=8 then begin
      {LFO}
      xxxx:=round(hochzehn((vol+t[6])/256)*100);
      if xxxx>127 then xxxx:=127;
      awew($80+canal,$e20,xxxx shl 8+round(tempo*1.572));
      awew($80+PSsecondchannel[v],$e20,(255-xxxx) shl 8+round(tempo*1.572));
      {Offset+Volume kanal1}
      awewl(canal,$a20,fltq shl 4,PSoffsetadder[v]+sample[t[0]].t[0]+sample[t[0]].t[2]);
      awew($20+canal,$e20,(filt shl 8)+not(vol+t[6]-12));
      PSoffsetadder[v]:=PSoffsetadder[v]+PSsamplesperviertel[v];
      end;
   if (PSoffsetadder[v]+PSsamplesperviertel[v])>sample[t[0]].t[4] then begin
      awenof(v);
      awechanst[PSsecondchannel[v]]:=true;
      end;

  end;
end;




procedure pitchshift(val,v:byte);
var awplaypos:longint;
realpitch:real;
xxxx:longint;
begin
if ((PSactive[v]=0)and(pitchshifternote[v]=0)) then exit;
with curr[v] do with awei[ins] do begin
      if pitchshifternote[v]>0 then begin
          realpitch:=523.25113* exp((sample[t[0]].t[5]-32768+341*(pitchshifternote[v]))/5909.445-10.418914);
          PSsamplesperviertel[v]:=round((2646000*realpitch)/(4*tempo));
          PSOffsetadder[v]:=PSsamplesperviertel[v];
          if val> 128 then begin
             xxxx:=round(PSsamplesperviertel[v]/48*(128-xxxx));
             if xxxx>(PSsamplesperviertel[v] div 3) then xxxx:=PSsamplesperviertel[v] div 3;
             PSOffsetadder[v]:=xxxx+PSOffsetadder[v];
             end;
          recentpitchshifternote[v]:=pitchshifternote[v];
          xxxx:=canal;
          awecoc(canal,ins,recentpitchshifternote[v],midbr[2],t[4],t[2],t[3],t[1],t[22],t[27],t[5],t[25],t[13],t[14],true);
          awechanst[canal]:=false;
          PSsecondchannel[v]:=canal;
          canal:=xxxx;
          PSactive[v]:=1;
      end;
      {Pitch setzen}
      xxxx:=playrow[v].val;
      if xxxx>127 then xxxx:=128-xxxx;
      xxxx:=min(65535,(recentpitchshifternote[v]+xxxx)*341+sample[t[0]].t[5]);
      awew(canal,$e20,xxxx);
      awew(PSsecondchannel[v],$e20,xxxx);
  end;
end;
{***************************************************}

{***************************************************}
procedure savawi;
var f:file;
    nb8,rst:longint;
begin
chd(savwavdir);
with awei[cawei] do if cre(nom+'.awi',f,1) then
 begin
 blockwrite(f,awei[cawei],39);
 blockwrite(f,sample[t[0]],35);
 blockwrite(f,svs[t[0]],36);
 if (sample[t[0]].loop and 3 =3) then
     begin
     enabledr;
     nb8:=sample[t[0]].t[1] div 4000;
     rst:=sample[t[0]].t[1] mod 4000;
     awereadp(sample[t[0]].t[0]);
     uploads(f,0,sample[t[0]].binf,1,nb8,rst);
     disabledr;
     end;
 close(f);
 end;
waitrel;
end;
{***************************************************}
function load_awi(ins,sam:byte;fn:string;updatepos:boolean) :boolean ;
var f:file;
begin

if ouvre(fn,f,1) then
 with awei[ins] do
  begin
  blockread(f,awei[ins],39);
  t[0]:=sam;
  blockread(f,sample[t[0]],35);
  blockread(f,svs[t[0]],36);
  if (sample[t[0]].loop and 3 =3) then
  begin
    if (sample[t[0]].t[1]<dramsize-awcp) then
        begin
        enabledr;
        sample[t[0]].t[0]:=awcp;
        svs[t[0]].ad:=sample[t[0]].t[0]+sample[t[0]].t[4];
        awewrtp(awcp);
        awloads(f,0,sample[t[0]].binf,sample[t[0]].t[1]);
        if updatepos then inc(awcp,sample[t[0]].t[1]);
        disabledr;
        end
        else begin
             message(' NOT ENOUGH AWE MEMORY ');
             sample[t[0]].nom:='        ';
             sample[t[0]].t[1]:=0;
             sample[t[0]].t[2]:=0;
             sample[t[0]].t[3]:=0;
             sample[t[0]].t[4]:=0;
             sample[t[0]].loop:=0;
             sample[t[0]].binf:=0;
             end;
  end;
  close(f);
  end;
end;
{***************************************************}
procedure playAWEins(ins:byte);
var hw,lw:word;
    k:byte;
begin
case midbr[0] and $f0 of
$90: with awei[ins] do if midbr[2]>0 then
        begin
          hw:=midbr[1];
          k:=0;
          while (k<29) and (awekey[k]<>hw) do inc(k);
          if awekey[k]<>hw then
            begin
            lw:=min(round((hw*341.33)+sample[t[0]].t[5]),$ffff);
            k:=t[5] and $0f;
            awecoc(voice,ins,lw,midbr[2],t[4],t[2],t[3],t[1],t[22],t[27],k,t[25],t[13],t[14],true);
            awekey[voice]:=hw;
            awechanst[voice]:=false;
            end;
         end else
            begin
                hw:=midbr[1];
                k:=0;
                while (k<29) and (awekey[k]<>hw) do inc(k);
                if awekey[k]=hw then
                      begin
                      awenotof(k,t[20],t[12]);
                      awekey[k]:=0;
                      end;
             end;

end;
end;
{***************************************************}
procedure fileloadAWI(s:string);
var k:byte;
begin
if tmploadfile<>s then
  begin
  for k:=0 to 29 do awekey[k]:=0;
  tmploadfile:=s;
  move(txtbuff,b^,sizeof(tabfic));
  load_awi(128,128,s,false);
  move(b^,txtbuff,sizeof(tabfic));
  end;
playaweins(128);
end;
{***************************************************}
procedure loadawi;
var tmpn:string[12];
    freesmp:byte;
begin
freesmp:=0;
while (freesmp<maxwav) and (sample[freesmp].loop and 1 =1) do inc(freesmp);
if sample[freesmp].loop and 1 =0 then
begin
 if getfic('*.awi      ',tmpn,' Select an AWI file ',cwavdir,fileloadAWI) then
 load_awi(cawei,freesmp,tmpn,true);
end else message(' NO MORE FREE SAMPLES  ');
end;
{***************************************************}
procedure awaifnom;
var kf:byte;
begin
for kf:= 2 to 47 do wrtw(34,kf,fonpat,1,'  '+''+'        '+''+'          ');

for kf:= max(cawei-21,0) to min(cawei+24,maxawei) do if awei[kf].t[0]<>127 then
 begin

 if instused[kf] then
    begin
    if sample[awei[kf].t[0]].loop and 3<>0 then
    wrtw(34,23+kf-cawei,fonpat,15,b2h(kf)+''+
    awei[kf].nom+''+sample[awei[kf].t[0]].nom+''++b2h(awei[kf].t[0]))
    else
    wrtw(34,23+kf-cawei,fonpat,15,b2h(kf)+''+
    awei[kf].nom+'    ?   '++b2h(awei[kf].t[0]))
    end
 else
    begin
    if sample[awei[kf].t[0]].loop and 3<>0 then
     wrtw(34,23+kf-cawei,fonpat,7,b2h(kf)+''+
          awei[kf].nom+''+sample[awei[kf].t[0]].nom+''++b2h(awei[kf].t[0]))
    else
     wrtw(34,23+kf-cawei,fonpat,7,b2h(kf)+''+
          awei[kf].nom+'    ?   '++b2h(awei[kf].t[0]));
    end
 end
 else
 wrtw(34,23+kf-cawei,fonpat,7,b2h(kf)+''+awei[kf].nom+'        ');

if awei[cawei].t[0]<127 then begin
   if sample[awei[cawei].t[0]].loop and 3=0 then

      wrtw(34,23,6,txt,b2h(cawei)+''+awei[cawei].nom+'    ?   '
      +b2h(awei[cawei].t[0]))
   else
       wrtw(34,23,6,txt,b2h(cawei)+''+awei[cawei].nom+''
       +sample[awei[cawei].t[0]].nom+''+b2h(awei[cawei].t[0]));
end else
 wrtw(34,23,6,txt,b2h(cawei)+''+awei[cawei].nom+'        ');

end;
{***************************************************}
procedure waitaweins(b:byte);
var k:byte;
    maxi,mini:byte;
begin
maxi:=min(cawei+24,maxawei);
mini:=max(cawei-21,0);
for k:=0 to 31 do with curr[k] do
if (drief=3) and (ins>=mini) and (ins<maxi)
then wrtw(33,23+ins-cawei,0,6,chr(equal and 7+224) );
showmcursoo;
waitr;
hidemcursoo;
linev(33,2,46,7,0,'');
end;
{***************************************************}
procedure invbit(var n:byte;d:byte);
var k:byte;
begin
k:=1 shl d;
if n and k=0 then n:=n or k else n:=n xor k;
waitrel;
end;

procedure drawcharbox(x,y:byte);
var cnt1,cnt2:byte;
begin
for cnt1:=0 to 38 do charbox[cnt1]:=128+cnt1;
for cnt1:=0 to 21 do charbox[cnt1+39]:=231+cnt1;
for cnt1:=0 to 1 do charbox[cnt1+61]:=20+cnt1;

for cnt1:=0 to 15 do for cnt2:=0 to 3 do begin
wrt(x+cnt1,y+cnt2,7,15,chr(charbox[cnt2+cnt1*4]));
end;
end;
{***************************************************}
procedure awe32wn;
const maxpara:array[0..28] of byte=
(maxwav,255,255,255,255,15,128,128,127,127,127,127,127,255,255,
                               128,127,127,127,127,127,
                               128,255,255,255,255,
                               128,255,255);
var k,mk,sp:byte;
    hw,lw:word;
    by,by2:byte;
    ih:integer;
procedure drawgr2;
var by,by2:byte;
begin
inittextdraw;
if sample[awei[cawei].t[0]].loop and 3<>1 then begin
        for by:=0 to 127 do begin
        for by2:=0 to mem[seg(instrumentgraph^):by+awei[cawei].t[0] shl 8+128]-1 do
                  charboxpixel(by,by2,0);
              for by2:=mem[seg(instrumentgraph^):by+awei[cawei].t[0] shl 8+128] to
                  mem[seg(instrumentgraph^):by+awei[cawei].t[0] shl 8]
                  do charboxpixel(by,by2,1);
              for by2:=mem[seg(instrumentgraph^):by+awei[cawei].t[0] shl 8]+1 to 31 do
                  charboxpixel(by,by2,0);
              end end else drawinternal;
if sample[awei[cawei].t[0]].loop <>3 then if sample[awei[cawei].t[0]].t[1]<>0 then begin
ih:=round(sample[awei[cawei].t[0]].t[3]/sample[awei[cawei].t[0]].t[1]*127);
for by2:=0 to 15 do charboxpixel(ih,by2*2,1);
for by2:=0 to 15 do charboxpixel(ih,by2*2+1,0);
ih:=round(sample[awei[cawei].t[0]].t[4]/sample[awei[cawei].t[0]].t[1]*127);
for by2:=0 to 15 do charboxpixel(ih,by2*2,1);
for by2:=0 to 15 do charboxpixel(ih,by2*2+1,0);
end;
closetextdraw;
end;

begin
if channelins[curc]<127 then cawei:=channelins[curc];
for k:=0 to 29 do awekey[k]:=0;
win(1,1,80,50,' AWE32 instrument editor ');
wrtw(34,1,cdef,fonpat,'Nr'+''+' Instr. '+''+' Sample '+'Nr');
wrtw(2,2,6,4,'        Sample number:');
wrtw(2,3,6,4,'            Pan level:');
wrtw(2,4,6,4,'               Chorus:');
wrtw(2,5,6,4,'               Reverb:');
wrtw(2,6,6,4,'           Filter cut:');
wrtw(2,7,6,4,'             Filter Q:');
wrtw(2,8,6,4,'               Volume:');
wrtw(12,09,2,7,'      Delay:');
wrtw(2,09,2,15,'ENVELOPE 1');
wrtw(2,10,2,7,'        Sustain level:');
wrtw(2,11,2,7,'           Decay time:');
wrtw(2,12,2,7,'            Hold time:');
wrtw(2,13,2,7,'          Attack time:');
wrtw(2,14,2,7,'              Release:');
wrtw(2,15,2,7,'      Env 1 to filter:');
wrtw(2,16,2,7,'       Env 1 to pitch:');
wrtw(12,17,3,6,'      Delay:');
wrtw(2,17,3,15,'ENVELOPE 2');
wrtw(2,18,3,6,'        Sustain level:');
wrtw(2,19,3,6,'           Decay time:');
wrtw(2,20,3,6,'            Hold time:');
wrtw(2,21,3,6,'          Attack time:');
wrtw(2,22,3,6,'              Release:');
wrtw(12,23,2,7,'      Delay:');
wrtw(2,23,2,15,'LFO1      ');
wrtw(2,24,2,7,'                Pitch:');
wrtw(2,25,2,7,'            to volume:');
wrtw(2,26,2,7,'              vibrato:');
wrtw(2,27,2,7,'            to filter:');
wrtw(12,28,3,6,'      Delay:');
wrtw(2,28,3,15,'LFO2      ');
wrtw(2,29,3,6,'                Pitch:');
wrtw(2,30,3,6,'              vibrato:');
wrtmb(2,32,cdef,'Set LFO 1 :   ');
wrtmb(2,35,cdef,'Set LFO 2 :   ');
wrtmb(2,38,cdef,'Set Filter:   ');
wrtmb(2,41,cdef,'Set LFO1 f:   ');
wrtmb(2,44,cdef,'Set Filt Q:   ');
wrtmb(2,47,cdef,'Set E1 2fi:   ');
wrtmb(18,32,cdef,'Set Chorus:   ');
wrtmb(18,35,cdef,'Set Reverb:   ');
wrtmb(18,38,cdef,'Set panora:   ');
wrtmb(18,41,cdef,'Set LFO2 f:   ');
wrtmb(18,44,cdef,'Set L1 2fi:   ');
wrtmb(18,47,cdef,'Set E1 2Pi:   ');
wrtmb(61, 6,cdef,'   Load  WAV    ');
wrtmb(61, 9,cdef,'   Save  WAV    ');
wrtmb(61,12,cdef,'   Load  AWI    ');
wrtmb(61,15,cdef,'   Save  AWI    ');
wrtmb(61,18,cdef,'   Load  XI     ');
wrtmb(61,29,cdef,'     Delete     ');
wrtmb(61,32,cdef,' Delete Setting ');
wrtmb(61,37,cdef,'      Help      ');
wrtmb(61,40,cdef,'      Exit      ');
wrtmb(61,43,cdef,'     Sample     ');
wrtmb(61,46,cdef,' Chorus, Reverb ');
linev(33,2,46,7,0,'');
linev(56,2,46,7,0,'');
wrt(56,23,1,1,'');
wrtmb(58,2,cdef,'') ;
wrtmb(58,46,cdef,'');
cadr(57,4,59,44,cdef,c4def);
drawcharbox(61,22);
wrt(60,21,7,2,'');wrt(77,21,7,1,'');
wrt(60,22,7,2,'');wrt(77,22,7,1,'');
wrt(60,23,7,2,'');wrt(77,23,7,1,'');
wrt(60,24,7,2,'');wrt(77,24,7,1,'');
wrt(60,25,7,2,'');wrt(77,25,7,1,'');
wrt(60,26,7,1,'');wrt(60,26,7,2,'');
mk:=0;
awaifnom;
waitrel;
waitp:=waitaweins;
drawgr2;



repeat          {SCHLEIFE}
linev(58,5,39,cdef,cdef,'');
wrtw(58,5+(cawei*38)div maxawei,cdef,fonpat,'');

for k:=0 to 3 do acti(13,3*k+32, not( (awei[cawei].flg) and (1 shl k)=0) );
for k:=4 to 7 do acti(29,3*(k-4)+32,not((awei[cawei].flg) and (1 shl k)=0) );
for k:=0 to 28 do wrtw(25,k+2,fonpat,txt,b2d(awei[cawei].t[k]));

wrtw(25,5+2,fonpat,txt,b2d(awei[cawei].t[5] and $0f));

with awei[cawei] do
 begin
 acti(13,44,t[5] and $10=0);
 acti(13,47,t[5] and $20=0);
 acti(29,44,t[5] and $40=0);
 acti(29,47,t[5] and $80=0);
 end;

by:=awei[cawei].t[0];
sp:=awei[cawei].t[0];
if mk=5 then
 begin
 k:=awei[cawei].t[5] and $0f;
 k:=getnum(25,mk+2,3,maxpara[mk],0,k,0,true);
 awei[cawei].t[5]:=(awei[cawei].t[5] and $f0)+k;
 end else
awei[cawei].t[mk]:= getnum(25,mk+2,3,maxpara[mk],0,awei[cawei].t[mk],0,true);

if awei[cawei].t[0]<>by then drawgr2;

if awei[cawei].t[0]<>sp then
if awei[cawei].t[0]<>127 then begin

  if sample[awei[cawei].t[0]].loop and 3<>0 then begin
     wrtw(34,23,bar,txt,b2h(cawei)+''+awei[cawei].nom+
       ''+sample[awei[cawei].t[0]].nom+''+b2h(awei[cawei].t[0]));
      end
  else begin
   wrtw(34,23,bar,txt,b2h(cawei)+''+awei[cawei].nom+'    ?   '
   +b2h(awei[cawei].t[0]));end;


  end
  else wrtw(34,23,bar,txt,b2h(cawei)+''+awei[cawei].nom+'        ');


if lb then
begin
if mouin(60,5,76,7) then wkey:=28 else
if mouin(60,8,76,10) then begin if sample[awei[cawei].t[0]].loop and 1=1 then savewav(sample[awei[cawei].t[0]].nom);
end else
if mouin(60,11,76,13) then wkey:=38 else
if mouin(60,14,76,16) then savawi else
if mouin(60,17,76,19) then wkey:=1069 else
if mouin(60,28,76,30) then wkey:=ksup else
if mouin(60,31,76,33) then begin
                        move(vaw,awei[cawei].t[1],29);
                        awei[cawei].flg:=255;
                        awei[cawei].nom:='        ';
                        awei[cawei].t[0]:=127;
                        awaifnom;
                      end else
if mouin(60,42,75,44) then wkey:=kf3 else
if mouin(60,39,75,41) then wkey:=1 else
if mouin(60,36,75,38) then wkey:=kf1 else
if mouin(60,45,75,47) then affeffect else
if mouin(57,1,59,3) then wkey:=pgup else
if mouin(57,45,59,47) then wkey:=pgdn else
if mouin(33,2,36,48) or mouin(48,2,56,48)
                      then begin
                      if (my-23+cawei>=0) and (my-23+cawei<=maxawei)
                          then cawei:=my-23+cawei;
                          awaifnom;
                          waitrel;
                          drawgr2;

                         end else
if mouin(20,2,28,30) then mk:=my-2 else
if mouin(1,31,16,42) then
                       begin
                       k:=(my-31) div 3;
                       invbit(awei[cawei].flg,k);
                       end else
if mouin(17,31,32,42) then
                       begin
                       k:=(my-31) div 3+4;
                       invbit(awei[cawei].flg,k);
                       end else
if mouin(37,2,47,48) then
               begin
                if (my-23+cawei>=0) and (my-25+cawei<=maxawei)
                   then cawei:=my-23+cawei;
                awaifnom;
               awei[cawei].nom:=getchai(37,23,8,awei[cawei].nom);
               awaifnom;

               end else
if mouin(1,43,16,45) then invbit(awei[cawei].t[5],4) else
if mouin(17,44,32,45) then invbit(awei[cawei].t[5],6) else
if mouin(1,46,16,48) then invbit(awei[cawei].t[5],5) else
if mouin(17,46,32,48) then invbit(awei[cawei].t[5],7);

end;
case wkey of
1069:begin
     k:=0;
     while (k<maxwav) and (sample[k].loop and 1 =1) do inc(k);
     if sample[k].loop and 1 =0 then
         begin
         csmp:=k;
         if loadxi_ins then awei[cawei].t[0]:=csmp;
         end else message(' No more free sample !');
     awaifnom;
     end;

38:begin
    loadawi;
    awaifnom;
    end;     {wwwwwwwwwwwwwww}
$800+31:if sample[awei[cawei].t[0]].loop and 1=1 then savewav(sample[awei[cawei].t[0]].nom);

28:begin
    if sample[awei[cawei].t[0]].loop and 1<>1 then begin
    cnt1:=255;
    repeat
    inc(cnt1);
    until (sample[cnt1].loop and 3=0);
    csmp:=cnt1;
    end;
    loadwav;
    if loadflag=true then begin
    awei[cawei].nom:=sample[csmp].nom;
    awei[cawei].t[0]:=csmp;
    awei[cawei].flg:=255;
    move(vaw[1],awei[cawei].t[1],28);
    awaifnom;
    end;
    csmp:=0;
    end;

kf1:help(0,'f');
kfH:if mk>0 then dec(mk);
kfb:if mk<28 then inc(mk);
pgdn:if cawei<maxawei then begin inc(cawei);awaifnom;drawgr2;end;
pgup:if cawei>0 then begin dec(cawei);awaifnom;drawgr2;end;
3..53: if clv[wkey]<maxnote then
       begin
       midbr[0]:=$90;
       midbr[1]:=min(clv[wkey]+oct*12,127);
       midbr[2]:=$7f;
       end;
$80+3..$80+53: if clv[wkey and $7f]<maxnote then
               begin
               midbr[0]:=$90;
               midbr[1]:=min(clv[wkey and $7f]+oct*12,127);
               midbr[2]:=$00;
               end;
kSup:begin
     dels(awei[cawei].t[0]);

     for by:=0 to 255 do mem[seg(instrumentgraph^):by+awei[cawei].t[0] shl 8]:=16;
     awei[cawei].nom:='        ';
     awei[cawei].t[0]:=127;
      awei[cawei].flg:=255;
     move(vaw[1],awei[cawei].t[1],28);
     awaifnom;
     end;

end;

case midbr[0] and $f0 of
$c0:begin
    cawei:=midbr[1];
    awaifnom;
    end;
$90: playaweins(cawei);
end;

csmp:=awei[cawei].t[0];
if csmp=127 then csmp:=0;

wrt(0,58,7,2,'  Waves directory                                             ');
wrt(0,59,2,15,'                                                              ');
wrt(0,59,2,15,'  '+lastsampledir);
wrt(0,58,7,2,#127);
wrt(0,59,2,7,#127);
wrt(61,58,1,7,#127);
wrt(61,59,7,2,#127);



until (wkey=1) or (wkey=kf3);
restwin;

if awei[cawei].t[0]<127 then lastinstsetval:=cawei;
defaultcharbox(0);


end;
{***************************************************}
procedure winawe(n:byte);
begin
repeat
if n=1 then awe32wn;
n:=1;
if wkey<>1 then awesmp;
until wkey=1;
end;
{***************************************************}

{***************************************************}
procedure awe32win;
begin
winawe(1);
end;
{***************************************************}
procedure awesample;
begin
winawe(0);
end;
{***************************************************}
procedure awedru;
var k,mk:byte;
   hw:word;
   stf:boolean;
begin
for k:=0 to 29 do awekey[k]:=0;
stf:=false;
win(8,2,72,43,' AWE DRUM INSTRUMENTS PARAMETERS ');
wrtmb(2,2,cdef,'      Exit       ');
wrtmb(2,5,cdef,'      Help       ');
wrtw(20,2,cdef,fonpat,' Note Instrument   Pitch Inst.name Sample');
for k:=36 to 35+36 do wrtw(22,k-32,cdef,fonpat,no2str(k));

for k:=0 to 35 do with awd[k] do
                  begin
                  wrtw(29,k+4,fonpat,txt,b2d(ist));
                  wrtw(39,k+4,fonpat,txt,w2d(f));
                  wrtw(45,k+4,c4def,txt,awei[ist].nom+' '+sample[ awei[ist].t[0] ].nom);
                  end;
waitrel;
mk:=0;
repeat
with awd[mk] do
 wrtw(45,mk+4,c4def,txt,awei[ist].nom+' '+sample[ awei[ist].t[0] ].nom);

if stf then awd[mk].f:=getnum(39,mk+4,5,$ffff,0,awd[mk].f,0,true)
       else awd[mk].ist:=getnum(29,mk+4,3,127,0,awd[mk].ist,3000,true);

if lb then
 begin
 if mouin(1,1,20,3) then wkey:=1 else
 if mouin(1,4,20,7) then wkey:=kf1 else
 if mouin(28,4,32,39) then begin mk:=my-4;stf:=false end
   else if mouin(38,4,44,39) then begin
                                  stf:=true;
                                  mk:=my-4;
                                  end;
 end;
case wkey of
kf1:help(0,'j');
kfh : if mk>0 then dec(mk);
kfb : if mk<35 then inc(mk);
3..53: if clv[wkey]<maxnote then
       begin
       midbr[0]:=$90;
       midbr[1]:=min(clv[wkey]+oct*12,127);
       midbr[2]:=$7f;
       end;
$80+3..$80+53:if clv[wkey and $7f]<maxnote then
              begin
               midbr[0]:=$90;
               midbr[1]:=min(clv[wkey and $7f]+oct*12,127);
               midbr[2]:=0;
              end;

 end;
case midbr[0] and $f0 of
$c0: mk:=midbr[1] mod 36;

$90: if midbr[2]>0 then
      begin
        hw:=midbr[1];
        mk:=hw mod 36;
        k:=0;
        while (k<29) and (awekey[k]<>hw) do inc(k);
        if awekey[k]<>hw then with awd[hw mod 36],awei[ist] do
          begin
          k:=t[5] and $0f;
          awecoc(voice,ist,f,midbr[2],t[4],t[2],t[3],t[1],t[22],t[27],k,t[25],t[13],t[14],true);
          awekey[voice]:=hw;
          awechanst[voice]:=false;
          end;
        end else
        begin
          hw:=midbr[1];
          k:=0;
          while (k<29) and (awekey[k]<>hw) do inc(k);
          if awekey[k]=hw then with awd[hw mod 36],awei[ist] do
                 begin
                 awenotof(k,t[20],t[12]);
                 awekey[k]:=0;
                 end;
         end;


end;
until wkey=1;
restwin;
end;
{***************************************************}
procedure awedruco(co:com;v:byte);
begin
 with curr[v] do
  begin
  lno:=co;
  vol:=co.vel and 127;
  pmtp:=0;
  fr:=awd[co.note mod 36].f;
  {awenof(canal,awei[ins].t[20],awei[ins].t[12]);}
  awenof(v);
  ins:=awd[co.note mod 36].ist;
  awecoc(canal,ins,fr,vol,filt,cho,rev,pan,lfo1f,lfo2f,fltq,l12f,e12f,e12p,false);
  afct:=true;
  awechanst[canal]:=false;
  end;
end;
{***************************}
procedure fltqch(val,v:byte);
var hiw,low,tw:word;
begin
with curr[v] do
 begin
 fltq:=val and $0f;
 awewmhb(canal,$a20,fltq shl 4)
 end;
end;
{***************************************************}
procedure awegltrtv;
var k:byte;
begin
if btmode then
begin
awewait(44);
 for k:=0 to 29 do with awetb[k],awei[instrum] do if setpp then
  begin
  awewl(k,$a20,fltqb,plp);
  if (flg and 1)<>0  then awew($a0+k,$a22,(128-t[21]) shl 8);
  if (flg and 2)<>0  then awew($e0+k,$a22,(128-t[26]) shl 8);
  awew($80+k,$a20,(128-t[15]) shl 8);
  awew($c0+k,$a20,(128-t[7]) shl 8);
  awew($e0+k,$a20,(t[8] shl 8)+(127-t[9]));
  awew($a0+k,$a20,(t[16] shl 8)+(127-t[17]));
  setpp:=false;
  end;

end;
end;
{***************************************************}
procedure awetrtv(v:byte);
begin
with curr[v] do with awei[ins] do
 begin

 if pmtp>0 then
    begin
    xp:=xp+adp;
    fr:=xp shr 7;
    awew(canal,$e20,fr);
    dec(pmtp);
    end;

 if pmtpf>0 then
    begin
    xf:=xf+adf;
    filt:=max(1,xf shr 7);
    awew($20+canal,$e20,(filt shl 8) + not(vol+t[6]));
    dec(pmtpf);
    end;

 if pmtvol>0 then
    begin
    xv:=xv+adv;
    vol:=xv shr 7;
    awew($20+canal,$e20,(filt shl 8) + not(vol+t[6]));
    dec(pmtvol);
    end;

 if pmtpan>0 then
    begin
    xs:=xs+ads;
    pan:=xs shr 7;
    awewmhb($c0+canal,$620,pan);
    awewlb($20+canal,$620,not(pan));
    dec(pmtpan);
    end;

 end;
pitchshifttick(123,v);
tremor(123,v);
end;
{***************************************************}
procedure setequal(eqt:array of word);
var w:word;
begin
 AweW($60+$01,$a22,eqt[0]);
 AweW($60+$11,$a22, eqt[1]);
 AweW($60+$11,$a20, eqt[3]);
 AweW($60+$13,$a20, eqt[4]);
 AweW($60+$1B,$a20, eqt[5]);
 AweW($60+$07,$a22, eqt[6]);
 AweW($60+$0B,$a22, eqt[7]);
 AweW($60+$0D,$a22, eqt[8]);
 AweW($60+$17,$a22, eqt[9]);
 AweW($60+$19,$a22, eqt[10]);
 w := eqt[2]+ eqt[11];
 AweW($60+$15,$a22, w+$0263);
 AweW($60+$1D,$a22, w-$7C9D);
end;
{***************************************************}
{procedure winequal;
var mk,k:byte;
    f:file;
    tmpn:string[12];
begin
win(10,10,40,26,' AWE EQUALIZER ');
for k:=0 to 2  do wrtw(2,2+k,cdef,fonpat,'Bass ');
for k:=3 to 11 do wrtw(2,2+k,cdef,fonpat,'Treble');
wrtmb(18,2,cdef,' Load EQL ');
wrtmb(18,5,cdef,' Save EQL ');
wrtmb(18,8,cdef,'   Exit   ');
wrtmb(18,11,cdef,' Save Conf');
wrtw(18,14,fonpat,txt,eqname);
mk:=0;
repeat
for k:=0 to 11 do wrtw(9,2+k,fonpat,txt,w2d(eqpara[k]));
eqpara[mk]:=getnum(9,2+mk,5,65535,0,eqpara[mk],0,true);
if lb then
 begin
 if mouin(8,2,14,13) then mk:=my-2 else
 if mouin(17,10,28,12) then saveconf else
 if mouin(18,14,25,14) then eqname:=getchai(18,14,8,eqname) else
 if mouin(17,7,28,9) then wkey:=1 else
 if mouin(17,1,28,3) then wkey:=28 else
 if mouin(17,4,28,6) then
  begin
  chd(ceffdir);
  if cre(eqname+'.eql',f,1) then
      begin
      blockwrite(f,eqpara,24);
      close(f);
      waitrel;
      end;
  end;
 end;
case wkey of
kfb:if mk<11 then inc(mk);
kfh:if mk>0 then dec(mk);
28: if getfic('*.eql       ',tmpn,' Select EQL file',ceffdir,testrien) then
     if ouvre(tmpn,f,1) then
        begin
        blockread(f,eqpara,24);
        eqname:=fn2n(tmpn);
        close(f);
        end;
end;
setequal(eqpara);
until wkey=1;
restwin;
end;   }
{***************************************************}
procedure ramsize;
var hw,lw,mem0,mem1,w:word;
label end_ramsize;
begin

enabledr;
dramsize:=$200000;
mem0:=word(awpeek($200000));

awpoke($200000,$aa55);
if word(awpeek($200000))<>$aa55 then goto end_ramsize;
awpoke($200000,$55aa);
if word(awpeek($200000))<>$55aa then goto end_ramsize;

repeat
  inc(dramsize,$40000);
  mem1:=word(awpeek(dramsize));
  awpoke(dramsize,$aa55);
  w:=word(awpeek($200000)) xor $55aa;
  if w=0 then w:=w or (word(awpeek(dramsize)) xor $aa55);
  awpoke(dramsize,mem1);

until (w<>0) or (dramsize> $200000+14*1024*1024) ;

end_ramsize:
awpoke($200000,mem0);

disabledr;
end;
{***************************************************}
procedure detectawe32;
var b:boolean;
    k:byte;
    w1,w2,w3,w4:word;
begin
awedt:=false;
portw[$c02+base-$400]:=224;
w1:=portw[$c00+base-$400];
w1:=portw[$c00+base-$400];
awedt:=((w1 and $f)=$c);

if awedt then
  begin
   initawe;

   setequal(eqpara);

   ramsize;

   awedt:=true;  {
   wrt(58,55,bar,2,b2h(base shr 8)+b2h(base and $ff)+'h'); }
   bs:=base-$620+$a20;
   sco[5]:=awedruco;
   sco[3]:=aweco;noof[3]:=awenof;stoppe[3]:=awestopp;trtv[3]:=awetrtv;
   reglevo[3]:=awecvo;
   gltrtv[3]:=awegltrtv;
   ef[3][ord('o')]:=sampleof;
   ef[3][ord('P')]:=pitchshift; {!}
   ef[3][ord('9')]:=sampleof_FT;
   ef[3][ord('U')]:=offsetcut;    {!}
   ef[3][ord('4')]:=vibrato;
   ef[3][ord('7')]:=tremolo;
   ef[3][ord('e')]:=pmt2n;
   ef[3][ord('i')]:=awchi;
   ef[3][ord('f')]:=setfilter;
   ef[3][ord('g')]:=setcho;
   ef[3][ord('h')]:=setrev;
   ef[3][ord('s')]:=setpan;
   ef[3][ord('V')]:=setpanvorh;  {!}
   ef[3][ord('l')]:=startlfo;
   ef[3][ord('m')]:=setlfo1f;
   ef[3][ord('S')]:=rndpan;
   ef[3][ord('F')]:=rndfilter;
   ef[3][ord('n')]:=setlfo2f;
   ef[3][ord('p')]:=setf;
   ef[3][ord('q')]:=setpmt;
   ef[3][ord('a')]:=setpmtf;
   ef[3][ord('b')]:=pmt2f;
   ef[3][ord('c')]:=seteffect;
   ef[3][ord('u')]:=awe2filt;
   ef[3][ord('k')]:=fltqch;
   ef[3][ord('L')]:=setl12fi;
   ef[3][ord('v')]:=sete12pi;
   ef[3][ord('G')]:=setfilterp;
   ef[3][ord('J')]:=filtersd;
   ef[3][ord('K')]:=filtersu;
   ef[3][ord('H')]:=pitchsd;
   ef[3][ord('I')]:=pitchsu;
   ef[3][ord('M')]:=pansd;
   ef[3][ord('O')]:=pansu;
   ef[3][ord('D')]:=volsd;
   ef[3][ord('E')]:=volsu;
   ef[3][ord('Q')]:=filtersdt;
   ef[3][ord('x')]:=setdecay2;
   ef[2][ord('c')]:=seteffect;
   ef[2][ord('g')]:=awefmcho;
   ef[2][ord('h')]:=awefmrev;
   ef[3][ord('2')]:=combislide;

  end
else begin      {
     wrt(58,55,bar,cdef,'No     ');   }
     sco[3]:=rc;trtv[3]:=nihil;noof[3]:=nihil;stoppe[3]:=rien;
     reglevo[3]:=rrr;
     gltrtv[3]:=rien;
     for k:=46 to 122 do ef[3][k]:=rrr;
      ef[2][ord('g')]:=rrr;
      ef[2][ord('h')]:=rrr;
      ef[2][ord('b')]:=rrr;
     end;
end;
{***************************************************}
begin
move(defpara,eqpara,24);
eqname:='HW_deflt;';
revt:=0;
cht:=0;
sample[128].t[5]:=24580;
awei[128].t[0]:=128;

end.
