	
; 	Arkos Tracker - Player Test
;	MSX VER 0.03 BY WYZ

;	Thanks to SYX for the EXPTBL label missing.



Music_Address		equ #4000
Music_SFX_Address	equ #D000

;INTERRUPT HANDLER (50/60 HZ)

HOOK            EQU     $FD9F



;SoundEffects equ 0				;If to 1, set it also PLY_UseSoundEffects to 1 in the player.


		org #8800
		end #8800 			; exec_address for pasmo
		di



 
;enable RAM in page 1 / MSX ASSEMBLY PAGE	

ENASLT: 	EQU 	#0024
RAMAD1: 	EQU 	#F342
EXPTBL: 	EQU 	#FCC1


Enable_RAM2: 	ld     a,(EXPTBL+3)
             	ld     b,a                 ;check if slot is expanded
             	and    a
             	jp     z,Ena_RAM2_jp
             	ld     a,(#FFFF)           ;if so, read subslot value first
             	cpl                        ;complement value
             	and    %11000000
             	rrca                       ;shift subslot bits to bits 2-3
             	rrca
             	rrca
             	rrca
             	or     b
             	ld     b,a
Ena_RAM2_jp: 	in     a,(#A8)             ;read slot value
             	and    %11000000           ;shift slot bits to bits 0-1
             	rlca
             	rlca
             	or     b
             	ld     h,#40               ;select slot
             	call   ENASLT
		
		
		
		LD	HL,MODULE		;SET MODULE AT RIGHT ADDRESS
		LD	DE,Music_Address
		LD	BC,MODULE_END-MODULE
		LDIR

	ld 	de,Music_Address		;START! config module.
	call 	Player_Address
	

;SET INTERRUPT SERVICE IM1
		
                LD      HL,Player_Address + 3	;cont. playing at this address.
                LD      [HOOK+1],HL		
                LD      A,$C3			;jump at HOOK 1/50 or 1/60
                LD      [HOOK],A
                EI


MainLoop	JP	MainLoop		;can't go to basic. page 1 selected as RAM.
	



;FILES________________________

Player_Address	
		include "ArkosTrackerPlayer_CPC_MSX.asm"

MODULE		incbin "molusk.bin"		;include your module here.
MODULE_END	DB	0

		END
