// everything that looks odd or weird is the result of experimentation. 

#include "stdafx.h"
#include <math.h>

/**************************************************************/

#define MAX_FACES		20000			// should be enough beer...
#define ROTATION_STEPS	64

Quad pint_obj[MAX_FACES];
Quad bottle_obj[MAX_FACES];

int total_quads_pint;
int total_quads_bottle;

GLuint m_uiTexID[2];
unsigned char phongbottle[256*256*4];
unsigned char phongpint[256*256*4];

#define bottle_path_size 14
#define pint_path_size 7

// here are stored the line path, points are defined in the XZ plane

unsigned char bottle_path[] = {0,45,	7,0,	9,0,	8,5,	10,9,
10,12,	8,14,	9,36,	19,76,
21,91,	22, 100, 22,171,	16,173,	0,173};

unsigned char pint_path[] = {0,139,	7,139,	31,0,	35,0,
12,139,	20,150,	0,150};

/**************************************************************/


// rotation around the z axis (vertical axis)
int QuadGenerateLatheObj(unsigned char* points, unsigned char nb_points, Quad* dest)
{
	int listidx;
	float rho;
	float drho = 6.28f / ROTATION_STEPS;
	int i;
	Quad temp;

	listidx = 0; 

	for (i = 0; i < nb_points - 1; i++) {
		for (rho = 0; rho < 6.28f; rho += drho) {
			Vertex v1,v2;

			temp.v[0].x = (float)(((float)(points[i << 1]))*sin(rho));
			temp.v[0].z = (float)(((float)(points[i << 1]))*cos(rho));
			temp.v[0].y = -(float)(points[(i << 1) + 1]);

			temp.v[1].x = (float)(((float)(points[(i << 1) + 2]))*sin(rho));
			temp.v[1].z = (float)(((float)(points[(i << 1) + 2]))*cos(rho));
			temp.v[1].y = -(float)(points[(i << 1) + 3]);

			temp.v[2].x = (float)(((float)(points[(i << 1) + 2]))*sin(rho + drho));
			temp.v[2].z = (float)(((float)(points[(i << 1) + 2]))*cos(rho + drho));
			temp.v[2].y = -(float)(points[(i << 1) + 3]);

			temp.v[3].x = (float)(((float)(points[i << 1]))*sin(rho + drho));
			temp.v[3].z = (float)(((float)(points[i << 1]))*cos(rho + drho));
			temp.v[3].y = -(float)(points[(i << 1) + 1]);

			v1.x = temp.v[1].x - temp.v[0].x;
			v1.y = temp.v[1].y - temp.v[0].y;
			v1.z = temp.v[1].z - temp.v[0].z;

			v2.x = temp.v[2].x - temp.v[1].x;
			v2.y = temp.v[2].y - temp.v[1].y;
			v2.z = temp.v[2].z - temp.v[1].z;

			// compute cross product for normal
			temp.normal.x = v1.y * v2.z - v1.z * v2.y;
			temp.normal.y = v1.z * v2.x - v1.x * v2.z;
			temp.normal.z = v1.x * v2.y - v1.y * v2.x;

			{
			float length = (float)sqrt(temp.normal.x * temp.normal.x + temp.normal.y * temp.normal.y + temp.normal.z * temp.normal.z);

			temp.normal.x /= length;
			temp.normal.y /= length;
			temp.normal.z /= length;
			}

			dest[listidx++] = temp;
		}
	}

	return listidx;
}

float random[65536];
float random2[65536];


// THIS IS USELESS AND SHOULD HAVE BEEN REMOVED BUT I LIKED MY LIGHTING AND HAD ENOUGH ROOM.
void GeneratePhongMap(unsigned char* dest, unsigned char red, unsigned char green, unsigned char blue)
{
	int x,y,idx = 0;

	// Ld0d algo.
	for (y = 0; y < 256; y++) {
		for (x = 0; x < 256; x++) {
			float f = (float)(fabs(sin(x * 0.005f))*(sqrt((x - 128.0f)*(x - 128.0f) + (y - 128.0f)*(y - 128.0f))*64) / 16.0f);
			if (f > 128)
				f = 128;
			f = (float)(cos(f * 3.14f / 128.0f) + 1.0f) * 127.0f;

			{
			int r,g,b;
			r = (int)f + red; if (r > 255)
						 	r = 255;
			g = (int)f + green; if (g > 255)
						   	g = 255;
			b = (int)f + blue; if (b > 255)
						  	b = 255;

			dest[idx] = b;
			dest[idx + 1] = g;
			dest[idx + 2] = r;
			}

			dest[idx + 3] = 255;

			idx += 4;
		}
	}
}




void Texture(GLuint id, unsigned char* src)
{
	glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
	glBindTexture(GL_TEXTURE_2D, id);

	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);

	glTexImage2D(GL_TEXTURE_2D,0,4,256,256,0,GL_BGRA_EXT, GL_UNSIGNED_BYTE, src);
}


void Init3D()
{
	int n;

	for (n = 0; n < 65536; n++) {
		random[n] = (float)(rand()) / RAND_MAX;
		random2[n] = (float)(rand()) / RAND_MAX;
	}

	GeneratePhongMap((unsigned char*) &phongbottle, 100,50,30);
	GeneratePhongMap((unsigned char*) &phongpint, 122,132,140);

	glGenTextures(2, (GLuint * ) &m_uiTexID);


	Texture(m_uiTexID[0], (unsigned char*) &phongbottle);
	Texture(m_uiTexID[1], (unsigned char*) &phongpint);

	total_quads_bottle = QuadGenerateLatheObj((unsigned char*) &bottle_path, 
	bottle_path_size, (Quad * ) &bottle_obj);

	total_quads_pint = QuadGenerateLatheObj((unsigned char*) &pint_path, 
	pint_path_size, (Quad * ) &pint_obj);
}

//  height=0, diameter = 31 

void DrawFoam(float timing, char beer)
{
	float rho;
	int i;
	float radius = 7.0f + timing * 23.3f;


	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glLineWidth(2.0);

	for (rho = 0.01f; rho <= 6.28f; rho += 0.02f) {
		glBegin(GL_LINE_STRIP);

		for (i = 0; i < 20; i++) {
			float r = random[(i + (int)(timing * rho * Timer_T * 10.0))&65535]; 
			float r2 = random2[((int)(r) + i + (int)(timing * rho * Timer_T * 10.0))&65535];

			if (beer)
				glColor4f(1.0f, 0.75f, 0.0f, r * 0.05f);
			else {
				glColor4f(1.0f, 1.0f, 0.9f, r * 0.05f);
			}


			glVertex3f((float)sin(rho)*(radius + r)*r,
				-139.0f + timing * 125.0f + r2 * (11.0f + radius * 0.2f), 
				(float)cos(rho)*(radius + r)*r);
		}

		glEnd();
	}


	if (beer) {
		int i;

		for (i = 0; i < 40; i++) {
			glBegin(GL_POINTS);
			{
			float r = (float)(rand()) / RAND_MAX;
			float r2 = (float)(rand()) / RAND_MAX;
			//float r3=(float)(rand())/RAND_MAX;
			glColor4f(1.0f, 1.0f, 1.0f,1.0f);
			glVertex3f((float)r * radius - radius * 0.5f, 
				(float)(-139.0 + timing * 125.0 + r2 * (13 + timing * 4)),
				(float)(r2 * radius - radius * 0.5));
			}
			glEnd();
		}
	}

	glDisable(GL_BLEND);
}


void Display(float timer, char showflow)
{
	int i;
	Vertex from,at,up;
	float invtimer = (timer - 0.8f)*5;

	from.x = (float)(1.0f + sin(timer * 2.0f)*4.0f);
	from.z = (float)(cos(timer * 2.0f)*4.0f);
	from.y = 1;

	at.x = at.y = at.z = 0.0;

	up.x = up.z = 0.0;
	up.y = 1.0;

	//////////////////////////////////////////////////////////////////////////
	glClearColor(0.1f, 0.0f, 0.0f, 0.0f);
	glBindTexture(GL_TEXTURE_2D, m_uiTexID[0]);
	glTexGeni(GL_S, GL_TEXTURE_GEN_MODE, GL_SPHERE_MAP);
	glTexGeni(GL_T, GL_TEXTURE_GEN_MODE, GL_SPHERE_MAP);

	glEnable(GL_TEXTURE_GEN_S);
	glEnable(GL_TEXTURE_GEN_T);
	glEnable(GL_TEXTURE_2D);

	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);					// Clear The Screen And The Depth Buffer

	glLoadIdentity();													// Reset The View
	gluLookAt(from.x,from.y,from.z,at.x,at.y,at.z,up.x,up.y,up.z);
	glTranslatef(0.0f,0.4f,-0.3f-(1.0f-timer));							// Move Into The Screen And Left
	glScalef(1.0f / 89.0f, 1.0f / 89.0f, 1.0f / 89.0f);
	glRotatef(timer * 110.0f,1.0f,0.0f,0.0f);

	glBegin(GL_QUADS);	

	for (i = 0; i < total_quads_bottle; i++) {
		glColor4f(1.0f, 1.0f, 1.0f, 0.1f);
		glNormal3f(bottle_obj[i].normal.x, bottle_obj[i].normal.y, bottle_obj[i].normal.z);

		glVertex3f(bottle_obj[i].v[0].x,bottle_obj[i].v[0].y,bottle_obj[i].v[0].z);		
		glVertex3f(bottle_obj[i].v[1].x,bottle_obj[i].v[1].y,bottle_obj[i].v[1].z);			
		glVertex3f(bottle_obj[i].v[2].x,bottle_obj[i].v[2].y,bottle_obj[i].v[2].z);	
		glVertex3f(bottle_obj[i].v[3].x,bottle_obj[i].v[3].y,bottle_obj[i].v[3].z);
	}

	glEnd();

	//////////////////////////////////////////////////////////////////////////



	glEnable(GL_BLEND);
	glDisable(GL_DEPTH_TEST);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

	glBindTexture(GL_TEXTURE_2D, m_uiTexID[1]);
	glTexGeni(GL_S, GL_TEXTURE_GEN_MODE, GL_SPHERE_MAP);
	glTexGeni(GL_T, GL_TEXTURE_GEN_MODE, GL_SPHERE_MAP);

	glLoadIdentity();										// Reset The View
	gluLookAt(from.x,from.y,from.z,at.x,at.y,at.z,up.x,up.y,up.z);

	glTranslatef(0.0f,0.0f,0.0f);							// Move Into The Screen And Left
	glScalef(1.0f / 78.0f, 1.0f / 78.0f, 1.0f / 78.0f);

	glBegin(GL_QUADS);									// Start Drawing A Polygon

	for (i = 0; i < total_quads_pint; i++) {
		glColor4f(1.0f, 1.0f, 1.0f, 0.2f);
		glNormal3f(pint_obj[i].normal.x, pint_obj[i].normal.y, pint_obj[i].normal.z);

		glVertex3f(pint_obj[i].v[0].x,pint_obj[i].v[0].y,pint_obj[i].v[0].z);							// Red	
		glVertex3f(pint_obj[i].v[1].x,pint_obj[i].v[1].y,pint_obj[i].v[1].z);	
		glVertex3f(pint_obj[i].v[2].x,pint_obj[i].v[2].y,pint_obj[i].v[2].z);	
		glVertex3f(pint_obj[i].v[3].x,pint_obj[i].v[3].y,pint_obj[i].v[3].z);
	}

	glEnd();

	//////////////////////////////////////////////////////////////////////////
	glDisable(GL_TEXTURE_2D);




	if (timer > 0.8) {
		float layer = 0;


		for (layer = 0.0f; layer < 5; layer += 0.3f) {
			DrawFoam((timer - 0.8f)*layer, 1);
		}

		DrawFoam(invtimer, 0);
	}

	////


	glDisable(GL_BLEND);


	glEnable(GL_DEPTH_TEST);

	if (timer > 0.8 && showflow) {
		float x;
		int flow;

		glLineWidth(2.0f + invtimer * 3.0f);

		glEnable(GL_BLEND);
		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

		glLoadIdentity();													// Reset The View
		gluLookAt(from.x,from.y,from.z,at.x,at.y,at.z,up.x,up.y,up.z);
		glTranslatef(0.0f,0.4f,-0.3f-(1.0f-timer));							// Move Into The Screen And Left
		glScalef(1.0f / 78.0f, 1.0f / 78.0f, 1.0f / 78.0f);

		for (flow = 0; flow < 1 + invtimer * 20; flow++) {
			float perturb = 4.0f*((float)(rand())) / RAND_MAX;
			glBegin(GL_LINE_STRIP);

			for (x = 0.0; x < 1.0f; x += 0.005f) {
				float f = -140.0f*x * x * (1.0f-invtimer * 0.6f);
				glColor4f(0.9f, 0.8f, 0.0,0.3f*((float)(rand())) / RAND_MAX);
				glVertex3f(0.0, f + perturb - 4.0f, x * (28 + perturb));
			}
			glEnd();
		}
		glDisable(GL_BLEND);
	}
}