; ------------------------------------------------------
; Text Bitmap 2D
; Copyright (c) 2005-2016, Franck Charlet
; All rights reserved.
; ------------------------------------------------------
; buildblock RELEASE
;       CAPT %5\Release.bat
; buildblockend
; buildblock DEBUG
;       CAPT %5\Debug.bat
; buildblockend

; ------------------------------------------------------
; Constants
SCREEN_WIDTH            equ     800
SCREEN_HEIGHT           equ     600
SCREEN_BPP              equ     32

NBR_CHARS               equ     48
MAX_SIZE                equ     64                      ; Size of the textures holding the letters

; ------------------------------------------------------
; Includes
                        include ..\Common_Src\FrameWork.asm
                        include ..\Common_Src\Bmp.asm
                        include ..\Common_Src\Fonts.asm

; ------------------------------------------------------
; Variables
Texture1                BMP     <>
Texture1_Id             dd      0

Font                    BITMAP_FONT <>

Chars_Ascii             db      "abcdefghijklmnopqrstuvwxyz()-0123456789?!.,:;""' "
Chars_Pos               dd      0, 32, 64, 96, 128, 160, 192, 224, 256, 268, 300, 332, 364, 396, 428, 460, 492
                        dd      524, 556, 588, 620, 652, 684, 716, 748, 780, 812, 829, 846, 876, 906, 922, 952
                        dd      982, 1012, 1042, 1072, 1102, 1132, 1162, 1194, 1206, 1218, 1230, 1242, 1254, 1278, 1290,

Chars_Size              dd      32, 32, 32, 32, 32, 32, 32, 32, 12, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32
                        dd      32, 32, 17, 17, 30, 30, 16, 30, 30, 30, 30, 30, 30, 30, 30, 32, 12, 12, 12, 12, 12, 24, 12, 13

; ------------------------------------------------------
; Name: Initialize()
; Desc: Perform the various initializations
Initialize              proc

                        invoke  glClearDepth, CDBL(1.0)
                        invoke  glHint, GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST
                        invoke  glClearColor, 0, 0, 0, CFLT(1.0)
                        invoke  glEnable, GL_NORMALIZE
                        invoke  glEnable, GL_CULL_FACE

                        invoke  Load_BMP, CSTR("..\..\Media\knight_font.bmp"), addr Texture1, -1
                        .if     eax == FALSE
                                invoke  Set_Error_Msg, CSTR("Can't load texture file")
                                mov     eax, FALSE
                                ret
                        .endif
                        
                        invoke  Init_Textures_Context

                        mov     Font.Nbr_Chars, NBR_CHARS
                        mov     Font.Pos_Table, offset Chars_Pos
                        mov     Font.Size_Table, offset Chars_Size
                        mov     Font.Ascii_Table, offset Chars_Ascii
                        mov     Font.Orig_Width, CMEM(Texture1.Orig_Width)
                        mov     Font.Orig_Height, CMEM(Texture1.Orig_Height)
                        mov     Font.Orig_Datas, CMEM(Texture1.Datas)
                        mov     Font.Texture_Size, MAX_SIZE                     ; Must be a standard texture size
                        mov     Font.Color_Key, 0                               ; Background color
                        invoke  Create_Bitmap_Font, addr Font
                        .if     eax == FALSE
                                invoke  Set_Error_Msg, CSTR("Can't create font")
                                mov     eax, FALSE
                                ret
                        .endif

                        mov     eax, TRUE
                        ret
Initialize              endp

; ------------------------------------------------------
; Name: Deinitialize()
; Desc: Free allocated resources
Deinitialize            proc
                        invoke  Destroy_Bitmap_Font, addr Font

                        invoke  Unload_BMP, addr Texture1
                        ret
Deinitialize            endp

; ------------------------------------------------------
; Name: Update()
; Desc: Update the scene
Update                  proc    FrameRate:real4

                        ; Update scene here

                        invoke  DInput_Get_Key, DIK_ESCAPE
                        test    eax, eax
                        jz      Esc_Pressed
                        invoke  Terminate_Application
Esc_Pressed:            ret
Update                  endp

; ------------------------------------------------------
; Name: Draw()
; Desc: Draw the scene
Draw                    proc
                        invoke  glClear, GL_COLOR_BUFFER_BIT or GL_DEPTH_BUFFER_BIT or GL_STENCIL_BUFFER_BIT

                        ; Draw scene here
                        invoke  Enter_2D_Mode, INT2FLT(SCREEN_WIDTH), INT2FLT(SCREEN_HEIGHT)
                                invoke  glColor3f, CFLT(1.0), CFLT(1.0), CFLT(1.0)
                                invoke  glEnable, GL_BLEND
                                invoke  glBlendFunc, GL_DST_ALPHA, GL_ONE_MINUS_SRC_ALPHA
                                ; Center it in the window
                                lea     ebx, CSTR("masm32")
                                invoke  lstrlen, ebx
                                invoke  Display_Bitmap_Text, INT2FLT(40), INT2FLT(30), addr Font, ebx, eax
                                lea     ebx, CSTR("this font is")
                                invoke  lstrlen, ebx
                                invoke  Display_Bitmap_Text, INT2FLT(40), INT2FLT(65), addr Font, ebx, eax
                                lea     ebx, CSTR("(c)1988 knight hawks")
                                invoke  lstrlen, ebx
                                invoke  Display_Bitmap_Text, INT2FLT(40), INT2FLT(91), addr Font, ebx, eax
                                invoke  glDisable, GL_BLEND
                        invoke  Leave_2d_Mode

                        ret
Draw                    endp

end start
