; ------------------------------------------------------
; Specular Material
; Copyright (c) 2005-2016, Franck Charlet
; All rights reserved.
; ------------------------------------------------------
; buildblock RELEASE
;       CAPT %5\Release.bat
; buildblockend
; buildblock DEBUG
;       CAPT %5\Debug.bat
; buildblockend

; ------------------------------------------------------
; Constants
SCREEN_WIDTH            equ     800
SCREEN_HEIGHT           equ     600
SCREEN_BPP              equ     32

; ------------------------------------------------------
; Includes
                        include ..\Common_Src\FrameWork.asm

; ------------------------------------------------------
; Variables
RotX                    real4   0.0
RotXSpeed               real4   40.0
RotY                    real4   0.0
RotYSpeed               real4   30.0
RotZ                    real4   0.0
RotZSpeed               real4   20.0

Light_Position          real4   -1.0, 1.0, 1.0, 1.0
Light_Diffuse           real4   0.6, 0.8, 1.0, 1.0
Light_Ambient           real4   0.2, 0.5, 0.7, 1.0
Mat_Specular            real4   1.0, 1.0, 1.0, 1.0

; ------------------------------------------------------
; Name: Initialize()
; Desc: Perform the various initializations
Initialize              proc

                        invoke  glClearDepth, CDBL(1.0)
                        invoke  glHint, GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST
                        invoke  glClearColor, 0, 0, 0, CFLT(1.0)
                        invoke  glEnable, GL_NORMALIZE
                        invoke  glEnable, GL_CULL_FACE

                        invoke  glEnable, GL_LIGHTING
                        invoke  glLightModeli, GL_LIGHT_MODEL_COLOR_CONTROL_EXT, GL_SEPARATE_SPECULAR_COLOR_EXT

                        mov     eax, TRUE
                        ret
Initialize              endp

; ------------------------------------------------------
; Name: Deinitialize()
; Desc: Free allocated resources
Deinitialize            proc

                        ret
Deinitialize            endp

; ------------------------------------------------------
; Name: Update()
; Desc: Update the scene
Update                  proc    FrameRate:real4

                        ; Update scene here
                        fld     RotXSpeed
                        fmul    FrameRate
                        fadd    RotX
                        fstp    RotX

                        fld     RotYSpeed
                        fmul    FrameRate
                        fadd    RotY
                        fstp    RotY

                        fld     RotZSpeed
                        fmul    FrameRate
                        fadd    RotZ
                        fstp    RotZ

                        invoke  DInput_Get_Key, DIK_ESCAPE
                        test    eax, eax
                        jz      Esc_Pressed
                        invoke  Terminate_Application
Esc_Pressed:            ret
Update                  endp

; ------------------------------------------------------
; Name: Draw()
; Desc: Draw the scene
Draw                    proc
                        invoke  glClear, GL_COLOR_BUFFER_BIT or GL_DEPTH_BUFFER_BIT or GL_STENCIL_BUFFER_BIT

                        ; Draw scene here
                        invoke  glLightfv, GL_LIGHT0, GL_DIFFUSE, addr Light_Diffuse
                        invoke  glLightfv, GL_LIGHT0, GL_AMBIENT, addr Light_Ambient
                        invoke  glLightfv, GL_LIGHT0, GL_POSITION, addr Light_Position
                        invoke  glEnable, GL_LIGHT0

                        invoke  glMaterialf, GL_FRONT, GL_SHININESS, CFLT(20.0)
                        invoke  glMaterialfv, GL_FRONT, GL_SPECULAR, addr Mat_Specular

                        invoke  glPushMatrix
                                invoke  glTranslatef, CFLT(0.0), CFLT(0.0), CFLT(-4.0)
                                invoke  glRotatef, RotX, CFLT(0.0), CFLT(1.0), CFLT(0.0)
                                invoke  glRotatef, RotY, CFLT(1.0), CFLT(0.0), CFLT(0.0)
                                invoke  glRotatef, RotZ, CFLT(0.0), CFLT(0.0), CFLT(1.0)

                                invoke  glBegin, GL_QUADS
                                        invoke  glNormal3f, CFLT(0.0), CFLT(0.0), CFLT(1.0)
                                        invoke  glVertex3f, CFLT(-1.0), CFLT(-1.0), CFLT(1.0)
                                        invoke  glVertex3f, CFLT(1.0), CFLT(-1.0), CFLT(1.0)
                                        invoke  glVertex3f, CFLT(1.0), CFLT(1.0), CFLT(1.0)
                                        invoke  glVertex3f, CFLT(-1.0),  CFLT(1.0), CFLT(1.0)

                                        invoke  glNormal3f, CFLT(0.0), CFLT(0.0), CFLT(-1.0)
                                        invoke  glVertex3f, CFLT(-1.0), CFLT(-1.0), CFLT(-1.0)
                                        invoke  glVertex3f, CFLT(-1.0),  CFLT(1.0), CFLT(-1.0)
                                        invoke  glVertex3f, CFLT(1.0),  CFLT(1.0), CFLT(-1.0)
                                        invoke  glVertex3f, CFLT(1.0), CFLT(-1.0), CFLT(-1.0)

                                        invoke  glNormal3f, CFLT(0.0), CFLT(1.0), CFLT(0.0)
                                        invoke  glVertex3f, CFLT(-1.0),  CFLT(1.0), CFLT(-1.0)
                                        invoke  glVertex3f, CFLT(-1.0),  CFLT(1.0), CFLT(1.0)
                                        invoke  glVertex3f, CFLT(1.0),  CFLT(1.0), CFLT(1.0)
                                        invoke  glVertex3f, CFLT(1.0),  CFLT(1.0), CFLT(-1.0)

                                        invoke  glNormal3f, CFLT(0.0), CFLT(-1.0), CFLT(0.0)
                                        invoke  glVertex3f, CFLT(-1.0), CFLT(-1.0), CFLT(-1.0f)
                                        invoke  glVertex3f, CFLT(1.0), CFLT(-1.0), CFLT(-1.0f)
                                        invoke  glVertex3f, CFLT(1.0), CFLT(-1.0), CFLT(1.0f)
                                        invoke  glVertex3f, CFLT(-1.0), CFLT(-1.0), CFLT(1.0f)

                                        invoke  glNormal3f, CFLT(1.0), CFLT(0.0), CFLT(0.0)     
                                        invoke  glVertex3f, CFLT(1.0), CFLT(-1.0), CFLT(-1.0)
                                        invoke  glVertex3f, CFLT(1.0), CFLT(1.0), CFLT(-1.0)
                                        invoke  glVertex3f, CFLT(1.0), CFLT(1.0), CFLT(1.0)
                                        invoke  glVertex3f, CFLT(1.0), CFLT(-1.0), CFLT(1.0)

                                        invoke  glNormal3f, CFLT(-1.0), CFLT(0.0), CFLT(0.0)
                                        invoke  glVertex3f, CFLT(-1.0), CFLT(-1.0), CFLT(-1.0)
                                        invoke  glVertex3f, CFLT(-1.0), CFLT(-1.0), CFLT(1.0)
                                        invoke  glVertex3f, CFLT(-1.0), CFLT(1.0), CFLT(1.0)
                                        invoke  glVertex3f, CFLT(-1.0), CFLT(1.0), CFLT(-1.0)
                                invoke  glEnd

                        invoke  glPopMatrix
                        ret
Draw                    endp

end start
