;
; Copyright (C) 1998-2002 ATI Technologies Inc.
;

;
; Notes:
;
;  Listed support is for current drivers and should really only be used
;  as a guideline.  ISV should still use glGetString() and
;  wglGetExtensionsString() to determine the exact set of supported
;  GL and WGL extensions.
;
; Converted to asm by Franck Charlet.

;
;  OpenGL 1.2 functionality
;
ifndef GL_VERSION_1_2
GL_VERSION_1_2 equ 1

GL_SMOOTH_POINT_SIZE_RANGE equ 00B12h
GL_SMOOTH_POINT_SIZE_GRANULARITY equ 00B13h
GL_SMOOTH_LINE_WIDTH_RANGE equ 00B22h
GL_SMOOTH_LINE_WIDTH_GRANULARITY equ 00B23h
GL_ALIASED_POINT_SIZE_RANGE equ 0846Dh
GL_ALIASED_LINE_WIDTH_RANGE equ 0846Eh

;
;  D.1 Three-Dimensional Texturing
;
GL_TEXTURE_BINDING_3Dequ 0806Ah
GL_PACK_SKIP_IMAGES equ 0806Bh
GL_PACK_IMAGE_HEIGHT equ 0806Ch
GL_UNPACK_SKIP_IMAGES equ 0806Dh
GL_UNPACK_IMAGE_HEIGHT equ 0806Eh
GL_TEXTURE_3D equ 0806Fh
GL_PROXY_TEXTURE_3D equ 08070h
define GL_TEXTURE_DEPTH equ 08071h
GL_TEXTURE_WRAP_R equ 08072h
GL_MAX_3D_TEXTURE_SIZE equ 08073h


PFNGLCOPYTEXSUBIMAGE3DPROC_proto typedef proto :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
PFNGLCOPYTEXSUBIMAGE3DPROC typedef ptr PFNGLCOPYTEXSUBIMAGE3DPROC_proto

PFNGLTEXIMAGE3DPROC_proto typedef proto :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
PFNGLTEXIMAGE3DPROC typedef ptr PFNGLTEXIMAGE3DPROC_proto

PFNGLTEXSUBIMAGE3DPROC_proto typedef proto :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
PFNGLTEXSUBIMAGE3DPROC typedef ptr PFNGLTEXSUBIMAGE3DPROC_proto

;
;  D.2 BGRA Pixel Formats
;
GL_BGR equ 080E0h
GL_BGRA equ 080E1h

;
;  D.3 Packed Pixel Formats
;
GL_UNSIGNED_BYTE_3_3_2 equ 08032h
GL_UNSIGNED_SHORT_4_4_4_4 equ 08033h
GL_UNSIGNED_SHORT_5_5_5_1 equ 08034h
GL_UNSIGNED_INT_8_8_8_8 equ 08035h
GL_UNSIGNED_INT_10_10_10_2 equ 08036h
GL_UNSIGNED_BYTE_2_3_3_REV equ 08362h
GL_UNSIGNED_SHORT_5_6_5 equ 08363h
GL_UNSIGNED_SHORT_5_6_5_REV equ 08364h
GL_UNSIGNED_SHORT_4_4_4_4_REV equ 08365h
GL_UNSIGNED_SHORT_1_5_5_5_REV equ 08366h
GL_UNSIGNED_INT_8_8_8_8_REV equ 08367h
GL_UNSIGNED_INT_2_10_10_10_REV equ 08368h

;
;  D.4 Normal Rescaling
;
GL_RESCALE_NORMAL equ 0803Ah

;
;  D.5 Separate Specular Color
;
GL_LIGHT_MODEL_COLOR_CONTROL equ 081F8h
GL_SINGLE_COLOR equ 081F9h
GL_SEPARATE_SPECULAR_COLOR equ 081FAh

;
;  D.6 Texture Coordinate Edge Clamping
;
GL_CLAMP_TO_EDGE equ 0812Fh

;
;  D.7 Texture Level of Detail Control
;
GL_TEXTURE_MIN_LOD equ 0813Ah
GL_TEXTURE_MAX_LOD equ 0813Bh
GL_TEXTURE_BASE_LEVEL equ 0813Ch
GL_TEXTURE_MAX_LEVEL equ 0813Dh

;
;  D.8 Vertex Array Draw Element Range
;
GL_MAX_ELEMENTS_VERTICES equ 080E8h
GL_MAX_ELEMENTS_INDICES equ 080E9h

PFNGLDRAWRANGEELEMENTSPROC_proto typedef proto :dword, :dword, :dword, :dword, :dword, :dword
PFNGLDRAWRANGEELEMENTSPROC typedef ptr PFNGLDRAWRANGEELEMENTSPROC_proto

endif ; GL_VERSION_1_2

;
;  OpenGL 1.3 functionality
;
ifndef GL_VERSION_1_3
GL_VERSION_1_3 equ 1

;
;  F.1 Compressed Textures
;
GL_COMPRESSED_ALPHA equ 084E9h
GL_COMPRESSED_LUMINANCE equ 084EAh
GL_COMPRESSED_LUMINANCE_ALPHA equ 084EBh
GL_COMPRESSED_INTENSITY equ 084ECh
GL_COMPRESSED_RGB equ 084EDh
GL_COMPRESSED_RGBA equ 084EEh
GL_TEXTURE_COMPRESSION_HINT equ 084EFh
GL_TEXTURE_COMPRESSED_IMAGE_SIZE equ 086A0h
GL_TEXTURE_COMPRESSED equ 086A1h
GL_NUM_COMPRESSED_TEXTURE_FORMATS equ 086A2h
GL_COMPRESSED_TEXTURE_FORMATS equ 086A3h

PFNGLCOMPRESSEDTEXIMAGE1DPROC_proto typedef proto :dword, :dword, :dword, :dword, :dword, :dword, :dword
PFNGLCOMPRESSEDTEXIMAGE1DPROC typedef ptr PFNGLCOMPRESSEDTEXIMAGE1DPROC_proto

PFNGLCOMPRESSEDTEXIMAGE2DPROC_proto typedef proto :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
PFNGLCOMPRESSEDTEXIMAGE2DPROC typedef ptr PFNGLCOMPRESSEDTEXIMAGE2DPROC_proto

PFNGLCOMPRESSEDTEXIMAGE3DPROC_proto typedef proto :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
PFNGLCOMPRESSEDTEXIMAGE3DPROC typedef ptr PFNGLCOMPRESSEDTEXIMAGE3DPROC_proto

PFNGLCOMPRESSEDTEXSUBIMAGE1DPROC_proto typedef proto :dword, :dword, :dword, :dword, :dword, :dword, :dword
PFNGLCOMPRESSEDTEXSUBIMAGE1DPROC typedef ptr PFNGLCOMPRESSEDTEXSUBIMAGE1DPROC_proto

PFNGLCOMPRESSEDTEXSUBIMAGE2DPROC_proto typedef proto :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
PFNGLCOMPRESSEDTEXSUBIMAGE2DPROC typedef ptr PFNGLCOMPRESSEDTEXSUBIMAGE2DPROC_proto

PFNGLCOMPRESSEDTEXSUBIMAGE3DPROC_proto typedef proto :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
PFNGLCOMPRESSEDTEXSUBIMAGE3DPROC typedef ptr PFNGLCOMPRESSEDTEXSUBIMAGE3DPROC_proto

PFNGLGETCOMPRESSEDTEXIMAGEPROC_proto typedef proto :dword, :dword, :dword
PFNGLGETCOMPRESSEDTEXIMAGEPROC typedef ptr PFNGLGETCOMPRESSEDTEXIMAGEPROC_proto

;
;  F.2 Cube Map Textures
;
GL_NORMAL_MAP equ 08511h
GL_REFLECTION_MAP equ 08512h
GL_TEXTURE_CUBE_MAP equ 08513h
GL_TEXTURE_BINDING_CUBE_MAP equ 08514h
GL_TEXTURE_CUBE_MAP_POSITIVE_X equ 08515h
GL_TEXTURE_CUBE_MAP_NEGATIVE_X equ 08516h
GL_TEXTURE_CUBE_MAP_POSITIVE_Y equ 08517h
GL_TEXTURE_CUBE_MAP_NEGATIVE_Y equ 08518h
GL_TEXTURE_CUBE_MAP_POSITIVE_Z equ 08519h
GL_TEXTURE_CUBE_MAP_NEGATIVE_Z equ 0851Ah
GL_PROXY_TEXTURE_CUBE_MAP equ 0851Bh
GL_MAX_CUBE_MAP_TEXTURE_SIZE equ 0851Ch

;
;  F.3 Multisample
;
GL_MULTISAMPLE equ 0809Dh
GL_SAMPLE_ALPHA_TO_COVERAGE equ 0809Eh
GL_SAMPLE_ALPHA_TO_ONE equ 0809Fh
GL_SAMPLE_COVERAGE equ 080A0h
GL_SAMPLE_BUFFERS equ 080A8h
GL_SAMPLES equ 080A9h
GL_SAMPLE_COVERAGE_VALUE equ 080AAh
GL_SAMPLE_COVERAGE_INVERT equ 080ABh
GL_MULTISAMPLE_BIT equ 020000000h

PFNGLSAMPLECOVERAGEPROC_proto typedef proto :dword, :dword
PFNGLSAMPLECOVERAGEPROC typedef ptr PFNGLSAMPLECOVERAGEPROC_proto

;
;  F.4 Multitexture
;
GL_TEXTURE0 equ 084C0h
GL_TEXTURE1 equ 084C1h
GL_TEXTURE2 equ 084C2h
GL_TEXTURE3 equ 084C3h
GL_TEXTURE4 equ 084C4h
GL_TEXTURE5 equ 084C5h
GL_TEXTURE6 equ 084C6h
GL_TEXTURE7 equ 084C7h
GL_TEXTURE8 equ 084C8h
GL_TEXTURE9 equ 084C9h
GL_TEXTURE10 equ 084CAh
GL_TEXTURE11 equ 084CBh
GL_TEXTURE12 equ 084CCh
GL_TEXTURE13 equ 084CDh
GL_TEXTURE14 equ 084CEh
GL_TEXTURE15 equ 084CFh
GL_TEXTURE16 equ 084D0h
GL_TEXTURE17 equ 084D1h
GL_TEXTURE18 equ 084D2h
GL_TEXTURE19 equ 084D3h
GL_TEXTURE20 equ 084D4h
GL_TEXTURE21 equ 084D5h
GL_TEXTURE22 equ 084D6h
GL_TEXTURE23 equ 084D7h
GL_TEXTURE24 equ 084D8h
GL_TEXTURE25 equ 084D9h
GL_TEXTURE26 equ 084DAh
GL_TEXTURE27 equ 084DBh
GL_TEXTURE28 equ 084DCh
GL_TEXTURE29 equ 084DDh
GL_TEXTURE30 equ 084DEh
GL_TEXTURE31 equ 084DFh
GL_ACTIVE_TEXTURE equ 084E0h
GL_CLIENT_ACTIVE_TEXTURE equ 084E1h
GL_MAX_TEXTURE_UNITS equ 084E2h

PFNGLACTIVETEXTUREPROC_proto typedef proto :dword
PFNGLACTIVETEXTUREPROC typedef ptr PFNGLACTIVETEXTUREPROC_proto

PFNGLCLIENTACTIVETEXTUREPROC_proto typedef proto :dword
PFNGLCLIENTACTIVETEXTUREPROC typedef ptr PFNGLCLIENTACTIVETEXTUREPROC_proto

PFNGLMULTITEXCOORD1DPROC_proto typedef proto :dword, :real8
PFNGLMULTITEXCOORD1DPROC typedef ptr PFNGLMULTITEXCOORD1DPROC_proto

PFNGLMULTITEXCOORD1DVPROC_proto typedef proto :dword, :ptr real8
PFNGLMULTITEXCOORD1DVPROC typedef ptr PFNGLMULTITEXCOORD1DVPROC_proto

PFNGLMULTITEXCOORD1FPROC_proto typedef proto :dword, :real4
PFNGLMULTITEXCOORD1FPROC typedef ptr PFNGLMULTITEXCOORD1FPROC_proto

PFNGLMULTITEXCOORD1FVPROC_proto typedef proto :dword, :ptr real4
PFNGLMULTITEXCOORD1FVPROC typedef ptr PFNGLMULTITEXCOORD1FVPROC_proto

PFNGLMULTITEXCOORD1IPROC_proto typedef proto :dword, :dword
PFNGLMULTITEXCOORD1IPROC typedef ptr PFNGLMULTITEXCOORD1IPROC_proto

PFNGLMULTITEXCOORD1IVPROC_proto typedef proto :dword, :ptr dword
PFNGLMULTITEXCOORD1IVPROC typedef ptr PFNGLMULTITEXCOORD1IVPROC_proto

PFNGLMULTITEXCOORD1SPROC_proto typedef proto :dword, :dword
PFNGLMULTITEXCOORD1SPROC typedef ptr PFNGLMULTITEXCOORD1SPROC_proto

PFNGLMULTITEXCOORD1SVPROC_proto typedef proto :dword, :ptr dword
PFNGLMULTITEXCOORD1SVPROC typedef ptr PFNGLMULTITEXCOORD1SVPROC_proto

PFNGLMULTITEXCOORD2DPROC_proto typedef proto :dword, :real8, :real8
PFNGLMULTITEXCOORD2DPROC typedef ptr PFNGLMULTITEXCOORD2DPROC_proto

PFNGLMULTITEXCOORD2DVPROC_proto typedef proto :dword, :ptr real8
PFNGLMULTITEXCOORD2DVPROC typedef ptr PFNGLMULTITEXCOORD2DVPROC_proto

PFNGLMULTITEXCOORD2FPROC_proto typedef proto :dword, :real4, :real4
PFNGLMULTITEXCOORD2FPROC typedef ptr PFNGLMULTITEXCOORD2FPROC_proto

PFNGLMULTITEXCOORD2FVPROC_proto typedef proto :dword, :ptr real4
PFNGLMULTITEXCOORD2FVPROC typedef ptr PFNGLMULTITEXCOORD2FVPROC_proto

PFNGLMULTITEXCOORD2IPROC_proto typedef proto :dword, :dword, :dword
PFNGLMULTITEXCOORD2IPROC typedef ptr PFNGLMULTITEXCOORD2IPROC_proto

PFNGLMULTITEXCOORD2IVPROC_proto typedef proto :dword, :ptr dword
PFNGLMULTITEXCOORD2IVPROC typedef ptr PFNGLMULTITEXCOORD2IVPROC_proto

PFNGLMULTITEXCOORD2SPROC_proto typedef proto :dword, :dword, :dword
PFNGLMULTITEXCOORD2SPROC typedef ptr PFNGLMULTITEXCOORD2SPROC_proto

PFNGLMULTITEXCOORD2SVPROC_proto typedef proto :dword, :ptr dword
PFNGLMULTITEXCOORD2SVPROC typedef ptr PFNGLMULTITEXCOORD2SVPROC_proto

PFNGLMULTITEXCOORD3DPROC_proto typedef proto :dword, :real8, :real8, :real8
PFNGLMULTITEXCOORD3DPROC typedef ptr PFNGLMULTITEXCOORD3DPROC_proto

PFNGLMULTITEXCOORD3DVPROC_proto typedef proto :dword, :ptr real8
PFNGLMULTITEXCOORD3DVPROC typedef ptr PFNGLMULTITEXCOORD3DVPROC_proto

PFNGLMULTITEXCOORD3FPROC_proto typedef proto :dword, :real4, :real4, :real4
PFNGLMULTITEXCOORD3FPROC typedef ptr PFNGLMULTITEXCOORD3FPROC_proto

PFNGLMULTITEXCOORD3FVPROC_proto typedef proto :dword, :ptr real4
PFNGLMULTITEXCOORD3FVPROC typedef ptr PFNGLMULTITEXCOORD3FVPROC_proto

PFNGLMULTITEXCOORD3IPROC_proto typedef proto :dword, :dword, :dword, :dword
PFNGLMULTITEXCOORD3IPROC typedef ptr PFNGLMULTITEXCOORD3IPROC_proto

PFNGLMULTITEXCOORD3IVPROC_proto typedef proto :dword, :ptr dword
PFNGLMULTITEXCOORD3IVPROC typedef ptr PFNGLMULTITEXCOORD3IVPROC_proto

PFNGLMULTITEXCOORD3SPROC_proto typedef proto :dword, :dword, :dword, :dword
PFNGLMULTITEXCOORD3SPROC typedef ptr PFNGLMULTITEXCOORD3SPROC_proto

PFNGLMULTITEXCOORD3SVPROC_proto typedef proto :dword, :ptr dword
PFNGLMULTITEXCOORD3SVPROC typedef ptr PFNGLMULTITEXCOORD3SVPROC_proto

PFNGLMULTITEXCOORD4DPROC_proto typedef proto :dword, :real8, :real8, :real8, :real8
PFNGLMULTITEXCOORD4DPROC typedef ptr PFNGLMULTITEXCOORD4DPROC_proto

PFNGLMULTITEXCOORD4DVPROC_proto typedef proto :dword, :ptr real8
PFNGLMULTITEXCOORD4DVPROC typedef ptr PFNGLMULTITEXCOORD4DVPROC_proto

PFNGLMULTITEXCOORD4FPROC_proto typedef proto :dword, :real4, :real4, :real4, :real4
PFNGLMULTITEXCOORD4FPROC typedef ptr PFNGLMULTITEXCOORD4FPROC_proto

PFNGLMULTITEXCOORD4FVPROC_proto typedef proto :dword, :ptr real4
PFNGLMULTITEXCOORD4FVPROC typedef ptr PFNGLMULTITEXCOORD4FVPROC_proto

PFNGLMULTITEXCOORD4IPROC_proto typedef proto :dword, :dword, :dword, :dword, :dword
PFNGLMULTITEXCOORD4IPROC typedef ptr PFNGLMULTITEXCOORD4IPROC_proto

PFNGLMULTITEXCOORD4IVPROC_proto typedef proto :dword, :ptr dword
PFNGLMULTITEXCOORD4IVPROC typedef ptr PFNGLMULTITEXCOORD4IVPROC_proto

PFNGLMULTITEXCOORD4SPROC_proto typedef proto :dword, :dword, :dword, :dword, :dword
PFNGLMULTITEXCOORD4SPROC typedef ptr PFNGLMULTITEXCOORD4SPROC_proto

PFNGLMULTITEXCOORD4SVPROC_proto typedef proto :dword, :ptr dword
PFNGLMULTITEXCOORD4SVPROC typedef ptr PFNGLMULTITEXCOORD4SVPROC_proto

;
;  F.6 Texture Combine Environment Mode
;
GL_SUBTRACT equ 084E7h
GL_COMBINE equ 08570h
GL_COMBINE_RGB equ 08571h
GL_COMBINE_ALPHA equ 08572h
GL_RGB_SCALE equ 08573h
GL_ADD_SIGNED equ 08574h
GL_INTERPOLATE equ 08575h
GL_CONSTANT equ 08576h
GL_PRIMARY_COLOR equ 08577h
GL_PREVIOUS equ 08578h
GL_SOURCE0_RGB equ 08580h ; obsolete
GL_SOURCE1_RGB equ 08581h ; obsolete
GL_SOURCE2_RGB equ 08582h ; obsolete
GL_SOURCE0_ALPHA equ 08588h ; obsolete
GL_SOURCE1_ALPHA equ 08589h ; obsolete
GL_SOURCE2_ALPHA equ 0858Ah ; obsolete
GL_OPERAND0_RGB equ 08590h
GL_OPERAND1_RGB equ 08591h
GL_OPERAND2_RGB equ 08592h
GL_OPERAND0_ALPHA equ 08598h
GL_OPERAND1_ALPHA equ 08599h
GL_OPERAND2_ALPHA equ 0859Ah

;
;  F.7 Texture Dot3 Environment Mode
;
GL_DOT3_RGB equ 086AEh
GL_DOT3_RGBA equ 086AFh

;
;  F.8 Texture Border Clamp
;
GL_CLAMP_TO_BORDER equ 0812Dh

;
;  F.9 Transpose Matrix
;
GL_TRANSPOSE_MODELVIEW_MATRIX equ 084E3h
GL_TRANSPOSE_PROJECTION_MATRIX equ 084E4h
GL_TRANSPOSE_TEXTURE_MATRIX equ 084E5h
GL_TRANSPOSE_COLOR_MATRIX equ 084E6h

PFNGLLOADTRANSPOSEMATRIXDPROC_proto typedef proto :ptr real8
PFNGLLOADTRANSPOSEMATRIXDPROC typedef ptr PFNGLLOADTRANSPOSEMATRIXDPROC_proto

PFNGLLOADTRANSPOSEMATRIXFPROC_proto typedef proto :ptr real4
PFNGLLOADTRANSPOSEMATRIXFPROC typedef ptr PFNGLLOADTRANSPOSEMATRIXFPROC_proto

PFNGLMULTTRANSPOSEMATRIXDPROC_proto typedef proto :ptr real8
PFNGLMULTTRANSPOSEMATRIXDPROC typedef ptr PFNGLMULTTRANSPOSEMATRIXDPROC_proto

PFNGLMULTTRANSPOSEMATRIXFPROC_proto typedef proto :ptr real4
PFNGLMULTTRANSPOSEMATRIXFPROC typedef ptr PFNGLMULTTRANSPOSEMATRIXFPROC_proto

endif ; GL_VERSION_1_3

;
;  OpenGL 1.4 functionality
;
ifndef GL_VERSION_1_4
GL_VERSION_1_4 equ 1

;
;  G.1 Automatic Mipmap Generation
;
GL_GENERATE_MIPMAP equ 08191h
GL_GENERATE_MIPMAP_HINT equ 08192h

;
;  G.3 Changes to the Imaging Subset
;
GL_CONSTANT_COLOR equ 08001h
GL_ONE_MINUS_CONSTANT_COLOR equ 08002h
GL_CONSTANT_ALPHA equ 08003h
GL_ONE_MINUS_CONSTANT_ALPHA equ 08004h
GL_BLEND_COLOR equ 08005h

PFNGLBLENDCOLORPROC_proto typedef proto :real4, :real4, :real4, :real4
PFNGLBLENDCOLORPROC typedef ptr PFNGLBLENDCOLORPROC_proto

PFNGLBLENDEQUATIONPROC_proto typedef proto :dword
PFNGLBLENDEQUATIONPROC typedef ptr PFNGLBLENDEQUATIONPROC_proto

;
;  G.4 Depth Textures and Shadows
;
GL_DEPTH_COMPONENT16 equ 081A5h
GL_DEPTH_COMPONENT24 equ 081A6h
GL_DEPTH_COMPONENT32 equ 081A7h
GL_TEXTURE_DEPTH_SIZE equ 0884Ah
GL_DEPTH_TEXTURE_MODE equ 0884Bh
GL_TEXTURE_COMPARE_MODE equ 0884Ch
GL_TEXTURE_COMPARE_FUNC equ 0884Dh
GL_COMPARE_R_TO_TEXTURE equ 0884Eh

;
;  G.5 Fog Coordinate
;
GL_FOG_COORDINATE_SOURCE equ 08450h ; obsolete
GL_FOG_COORDINATE equ 08451h ; obsolete
GL_FRAGMENT_DEPTH equ 08452h
GL_CURRENT_FOG_COORDINATE equ 08453h ; obsolete
GL_FOG_COORDINATE_ARRAY_TYPE equ 08454h ; obsolete
GL_FOG_COORDINATE_ARRAY_STRIDE equ 08455h ; obsolete
GL_FOG_COORDINATE_ARRAY_POINTER equ 08456h ; obsolete
GL_FOG_COORDINATE_ARRAY equ 08457h ; obsolete

PFNGLFOGCOORDDPROC_proto typedef proto :real8
PFNGLFOGCOORDDPROC typedef ptr PFNGLFOGCOORDDPROC_proto

PFNGLFOGCOORDDVPROC_proto typedef proto :ptr real8
PFNGLFOGCOORDDVPROC typedef ptr PFNGLFOGCOORDDVPROC_proto

PFNGLFOGCOORDFPROC_proto typedef proto :real4
PFNGLFOGCOORDFPROC typedef ptr PFNGLFOGCOORDFPROC_proto

PFNGLFOGCOORDFVPROC_proto typedef proto :ptr real4
PFNGLFOGCOORDFVPROC typedef ptr PFNGLFOGCOORDFVPROC_proto

PFNGLFOGCOORDPOINTERPROC_proto typedef proto :dword, :dword, :dword
PFNGLFOGCOORDPOINTERPROC typedef ptr PFNGLFOGCOORDPOINTERPROC_proto

;
;  G.6 Multiple Draw Arrays
;
PFNGLMULTIDRAWARRAYSPROC_proto typedef proto :dword, :ptr dword, :ptr dword, :dword
PFNGLMULTIDRAWARRAYSPROC typedef ptr PFNGLMULTIDRAWARRAYSPROC_proto

PFNGLMULTIDRAWELEMENTSPROC_proto typedef proto :dword, :ptr dword, :dword, :dword, :dword
PFNGLMULTIDRAWELEMENTSPROC typedef ptr PFNGLMULTIDRAWELEMENTSPROC_proto

;
;  G.7 Point Parameters
;
GL_POINT_SIZE_MIN equ 08126h
GL_POINT_SIZE_MAX equ 08127h
GL_POINT_FADE_THRESHOLD_SIZE equ 08128h
GL_POINT_DISTANCE_ATTENUATION equ 08129h

PFNGLPOINTPARAMETERFPROC_proto typedef proto :dword, :real4
PFNGLPOINTPARAMETERFPROC typedef ptr PFNGLPOINTPARAMETERFPROC_proto

PFNGLPOINTPARAMETERFVPROC_proto typedef proto :dword, :ptr real4
PFNGLPOINTPARAMETERFVPROC typedef ptr PFNGLPOINTPARAMETERFVPROC_proto

PFNGLPOINTPARAMETERIPROC_proto typedef proto :dword, :dword
PFNGLPOINTPARAMETERIPROC typedef ptr PFNGLPOINTPARAMETERIPROC_proto

PFNGLPOINTPARAMETERIVPROC_proto typedef proto :dword, :ptr dword
PFNGLPOINTPARAMETERIVPROC typedef ptr PFNGLPOINTPARAMETERIVPROC_proto

;
;  G.8 Secondary Color
;
GL_COLOR_SUM equ 08458h
GL_CURRENT_SECONDARY_COLOR equ 08459h
GL_SECONDARY_COLOR_ARRAY_SIZE equ 0845Ah
GL_SECONDARY_COLOR_ARRAY_TYPE equ 0845Bh
GL_SECONDARY_COLOR_ARRAY_STRIDE equ 0845Ch
GL_SECONDARY_COLOR_ARRAY_POINTER equ 0845Dh
GL_SECONDARY_COLOR_ARRAY equ 0845Eh

PFNGLSECONDARYCOLOR3BPROC_proto typedef proto :dword, :dword, :dword
PFNGLSECONDARYCOLOR3BPROC typedef ptr PFNGLSECONDARYCOLOR3BPROC_proto

PFNGLSECONDARYCOLOR3BVPROC_proto typedef proto :ptr dword
PFNGLSECONDARYCOLOR3BVPROC typedef ptr PFNGLSECONDARYCOLOR3BVPROC_proto

PFNGLSECONDARYCOLOR3DPROC_proto typedef proto :real8, :real8, :real8
PFNGLSECONDARYCOLOR3DPROC typedef ptr PFNGLSECONDARYCOLOR3DPROC_proto

PFNGLSECONDARYCOLOR3DVPROC_proto typedef proto :ptr real8
PFNGLSECONDARYCOLOR3DVPROC typedef ptr PFNGLSECONDARYCOLOR3DVPROC_proto

PFNGLSECONDARYCOLOR3FPROC_proto typedef proto :real4, :real4, :real4
PFNGLSECONDARYCOLOR3FPROC typedef ptr PFNGLSECONDARYCOLOR3FPROC_proto

PFNGLSECONDARYCOLOR3FVPROC_proto typedef proto :ptr real4
PFNGLSECONDARYCOLOR3FVPROC typedef ptr PFNGLSECONDARYCOLOR3FVPROC_proto

PFNGLSECONDARYCOLOR3IPROC_proto typedef proto :dword, :dword, :dword
PFNGLSECONDARYCOLOR3IPROC typedef ptr PFNGLSECONDARYCOLOR3IPROC_proto

PFNGLSECONDARYCOLOR3IVPROC_proto typedef proto :ptr dword
PFNGLSECONDARYCOLOR3IVPROC typedef ptr PFNGLSECONDARYCOLOR3IVPROC_proto

PFNGLSECONDARYCOLOR3SPROC_proto typedef proto :dword, :dword, :dword
PFNGLSECONDARYCOLOR3SPROC typedef ptr PFNGLSECONDARYCOLOR3SPROC_proto

PFNGLSECONDARYCOLOR3SVPROC_proto typedef proto :ptr dword
PFNGLSECONDARYCOLOR3SVPROC typedef ptr PFNGLSECONDARYCOLOR3SVPROC_proto

PFNGLSECONDARYCOLOR3UBPROC_proto typedef proto :dword, :dword, :dword
PFNGLSECONDARYCOLOR3UBPROC typedef ptr PFNGLSECONDARYCOLOR3UBPROC_proto

PFNGLSECONDARYCOLOR3UBVPROC_proto typedef proto :ptr dword
PFNGLSECONDARYCOLOR3UBVPROC typedef ptr PFNGLSECONDARYCOLOR3UBVPROC_proto

PFNGLSECONDARYCOLOR3UIPROC_proto typedef proto :dword, :dword, :dword
PFNGLSECONDARYCOLOR3UIPROC typedef ptr PFNGLSECONDARYCOLOR3UIPROC_proto

PFNGLSECONDARYCOLOR3UIVPROC_proto typedef proto :ptr dword
PFNGLSECONDARYCOLOR3UIVPROC typedef ptr PFNGLSECONDARYCOLOR3UIVPROC_proto

PFNGLSECONDARYCOLOR3USPROC_proto typedef proto :dword, :dword, :dword
PFNGLSECONDARYCOLOR3USPROC typedef ptr PFNGLSECONDARYCOLOR3USPROC_proto

PFNGLSECONDARYCOLOR3USVPROC_proto typedef proto :ptr dword
PFNGLSECONDARYCOLOR3USVPROC typedef ptr PFNGLSECONDARYCOLOR3USVPROC_proto

PFNGLSECONDARYCOLORPOINTERPROC_proto typedef proto :dword, :dword, :dword, :dword
PFNGLSECONDARYCOLORPOINTERPROC typedef ptr PFNGLSECONDARYCOLORPOINTERPROC_proto

;
;  G.9 Separate Blend Functions
;
GL_BLEND_DST_RGB equ 080C8h
GL_BLEND_SRC_RGB equ 080C9h
GL_BLEND_DST_ALPHA equ 080CAh
GL_BLEND_SRC_ALPHA equ 080CBh

PFNGLBLENDFUNCSEPARATEPROC_proto typedef proto :dword, :dword, :dword, :dword
PFNGLBLENDFUNCSEPARATEPROC typedef ptr PFNGLBLENDFUNCSEPARATEPROC_proto

;
;  G.10 Stencil Wrap
;
GL_INCR_WRAP equ 08507h
GL_DECR_WRAP equ 08508h

;
;  G.12 Texture LOD Bias
;
GL_MAX_TEXTURE_LOD_BIAS equ 084FDh
GL_TEXTURE_FILTER_CONTROL equ 08500h
GL_TEXTURE_LOD_BIAS equ 08501h

;
;  G.13 Texture Mirrored Repeat
;
GL_MIRRORED_REPEAT equ 08370h

;
;  G.14 Window Raster Position
;

PFNGLWINDOWPOS2DPROC_proto typedef proto :real8, :real8
PFNGLWINDOWPOS2DPROC typedef ptr PFNGLWINDOWPOS2DPROC_proto

PFNGLWINDOWPOS2DVPROC_proto typedef proto :ptr real8
PFNGLWINDOWPOS2DVPROC typedef ptr PFNGLWINDOWPOS2DVPROC_proto

PFNGLWINDOWPOS2FPROC_proto typedef proto :real4, :real4
PFNGLWINDOWPOS2FPROC typedef ptr PFNGLWINDOWPOS2FPROC_proto

PFNGLWINDOWPOS2FVPROC_proto typedef proto :ptr real4
PFNGLWINDOWPOS2FVPROC typedef ptr PFNGLWINDOWPOS2FVPROC_proto

PFNGLWINDOWPOS2IPROC_proto typedef proto :dword, :dword
PFNGLWINDOWPOS2IPROC typedef ptr PFNGLWINDOWPOS2IPROC_proto

PFNGLWINDOWPOS2IVPROC_proto typedef proto :ptr dword
PFNGLWINDOWPOS2IVPROC typedef ptr PFNGLWINDOWPOS2IVPROC_proto

PFNGLWINDOWPOS2SPROC_proto typedef proto :dword, :dword
PFNGLWINDOWPOS2SPROC typedef ptr PFNGLWINDOWPOS2SPROC_proto

PFNGLWINDOWPOS2SVPROC_proto typedef proto :ptr dword
PFNGLWINDOWPOS2SVPROC typedef ptr PFNGLWINDOWPOS2SVPROC_proto

PFNGLWINDOWPOS3DPROC_proto typedef proto :real8, :real8, :real8
PFNGLWINDOWPOS3DPROC typedef ptr PFNGLWINDOWPOS3DPROC_proto

PFNGLWINDOWPOS3DVPROC_proto typedef proto :ptr real8
PFNGLWINDOWPOS3DVPROC typedef ptr PFNGLWINDOWPOS3DVPROC_proto

PFNGLWINDOWPOS3FPROC_proto typedef proto :real4, :real4, :real4
PFNGLWINDOWPOS3FPROC typedef ptr PFNGLWINDOWPOS3FPROC_proto

PFNGLWINDOWPOS3FVPROC_proto typedef proto :ptr real4
PFNGLWINDOWPOS3FVPROC typedef ptr PFNGLWINDOWPOS3FVPROC_proto

PFNGLWINDOWPOS3IPROC_proto typedef proto :dword, :dword, :dword
PFNGLWINDOWPOS3IPROC typedef ptr PFNGLWINDOWPOS3IPROC_proto

PFNGLWINDOWPOS3IVPROC_proto typedef proto :ptr dword
PFNGLWINDOWPOS3IVPROC typedef ptr PFNGLWINDOWPOS3IVPROC_proto

PFNGLWINDOWPOS3SPROC_proto typedef proto :dword, :dword, :dword
PFNGLWINDOWPOS3SPROC typedef ptr PFNGLWINDOWPOS3SPROC_proto

PFNGLWINDOWPOS3SVPROC_proto typedef proto :ptr dword
PFNGLWINDOWPOS3SVPROC typedef ptr PFNGLWINDOWPOS3SVPROC_proto

endif ; GL_VERSION_1_4

;
;  OpenGL 1.5 functionality
;
ifndef GL_VERSION_1_5
GL_VERSION_1_5 equ 1

;
;  H.1 Buffer Objects
;
GLintptr typedef ptr dword
GLsizeiptr typedef ptr dword

GL_BUFFER_SIZE equ 08764h
GL_BUFFER_USAGE equ 08765h
GL_ARRAY_BUFFER equ 08892h
GL_ELEMENT_ARRAY_BUFFER equ 08893h
GL_ARRAY_BUFFER_BINDING equ 08894h
GL_ELEMENT_ARRAY_BUFFER_BINDING equ 08895h
GL_VERTEX_ARRAY_BUFFER_BINDING equ 08896h
GL_NORMAL_ARRAY_BUFFER_BINDING equ 08897h
GL_COLOR_ARRAY_BUFFER_BINDING equ 08898h
GL_INDEX_ARRAY_BUFFER_BINDING equ 08899h
GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING equ 0889Ah
GL_EDGE_FLAG_ARRAY_BUFFER_BINDING equ 0889Bh
GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING equ 0889Ch
GL_FOG_COORD_ARRAY_BUFFER_BINDING equ 0889Dh
GL_READ_ONLY equ 088B8h
GL_WRITE_ONLY equ 088B9h
GL_READ_WRITE equ 088BAh
GL_BUFFER_ACCESS equ 088BBh
GL_BUFFER_MAPPED equ 088BCh
GL_BUFFER_MAP_POINTER equ 088BDh
GL_STREAM_DRAW equ 088E0h
GL_STREAM_READ equ 088E1h
GL_STREAM_COPY equ 088E2h
GL_STATIC_DRAW equ 088E4h
GL_STATIC_READ equ 088E5h
GL_STATIC_COPY equ 088E6h
GL_DYNAMIC_DRAW equ 088E8h
GL_DYNAMIC_READ equ 088E9h
GL_DYNAMIC_COPY equ 088EAh

PFNGLBINDBUFFERPROC_proto typedef proto :dword, :dword
PFNGLBINDBUFFERPROC typedef ptr PFNGLBINDBUFFERPROC_proto

PFNGLBUFFERDATAPROC_proto typedef proto :dword, :dword, :dword, :dword
PFNGLBUFFERDATAPROC typedef ptr PFNGLBUFFERDATAPROC_proto

PFNGLBUFFERSUBDATAPROC_proto typedef proto :dword, :dword, :dword, :dword
PFNGLBUFFERSUBDATAPROC typedef ptr PFNGLBUFFERSUBDATAPROC_proto

PFNGLDELETEBUFFERSPROC_proto typedef proto :dword, :ptr dword
PFNGLDELETEBUFFERSPROC typedef ptr PFNGLDELETEBUFFERSPROC_proto

PFNGLGENBUFFERSPROC_proto typedef proto :dword, :ptr dword
PFNGLGENBUFFERSPROC typedef ptr PFNGLGENBUFFERSPROC_proto

PFNGLGETBUFFERPARAMETERIVPROC_proto typedef proto :dword, :dword, :ptr dword
PFNGLGETBUFFERPARAMETERIVPROC typedef ptr PFNGLGETBUFFERPARAMETERIVPROC_proto

PFNGLGETBUFFERPOINTERVPROC_proto typedef proto :dword, :dword, :dword
PFNGLGETBUFFERPOINTERVPROC typedef ptr PFNGLGETBUFFERPOINTERVPROC_proto

PFNGLGETBUFFERSUBDATAPROC_proto typedef proto :dword, :dword, :dword, :dword
PFNGLGETBUFFERSUBDATAPROC typedef ptr PFNGLGETBUFFERSUBDATAPROC_proto

PFNGLISBUFFERPROC_proto typedef proto :dword
PFNGLISBUFFERPROC typedef ptr PFNGLISBUFFERPROC_proto

PFNGLMAPBUFFERPROC_proto typedef proto :dword, :dword
PFNGLMAPBUFFERPROC typedef ptr PFNGLMAPBUFFERPROC_proto

PFNGLUNMAPBUFFERPROC_proto typedef proto :dword
PFNGLUNMAPBUFFERPROC typedef ptr PFNGLUNMAPBUFFERPROC_proto

;
;  H.2 Occlusion Queries
;
GL_QUERY_COUNTER_BITS equ 08864h
GL_CURRENT_QUERY equ 08865h
GL_QUERY_RESULT equ 08866h
GL_QUERY_RESULT_AVAILABLE equ 08867h
GL_SAMPLES_PASSED equ 08914h

PFNGLBEGINQUERYPROC_proto typedef proto :dword, :dword
PFNGLBEGINQUERYPROC typedef ptr PFNGLBEGINQUERYPROC_proto

PFNGLDELETEQUERIESPROC_proto typedef proto :dword, :ptr dword
PFNGLDELETEQUERIESPROC typedef ptr PFNGLDELETEQUERIESPROC_proto

PFNGLENDQUERYPROC_proto typedef proto :dword
PFNGLENDQUERYPROC typedef ptr PFNGLENDQUERYPROC_proto

PFNGLGENQUERIESPROC_proto typedef proto :dword, :ptr dword
PFNGLGENQUERIESPROC typedef ptr PFNGLGENQUERIESPROC_proto

PFNGLGETQUERYIVPROC_proto typedef proto :dword, :dword, :ptr dword
PFNGLGETQUERYIVPROC typedef ptr PFNGLGETQUERYIVPROC_proto

PFNGLGETQUERYOBJECTIVPROC_proto typedef proto :dword, :dword, :ptr dword
PFNGLGETQUERYOBJECTIVPROC typedef ptr PFNGLGETQUERYOBJECTIVPROC_proto

PFNGLGETQUERYOBJECTUIVPROC_proto typedef proto :dword, :dword, :ptr dword
PFNGLGETQUERYOBJECTUIVPROC typedef ptr PFNGLGETQUERYOBJECTUIVPROC_proto

PFNGLISQUERYPROC_proto typedef proto :dword
PFNGLISQUERYPROC typedef ptr PFNGLISQUERYPROC_proto

;
;  H.4 Changed Tokens
;
GL_FOG_COORD_SRC equ 08450h
GL_FOG_COORD equ 08451h
GL_CURRENT_FOG_COORD equ 08453h
GL_FOG_COORD_ARRAY_TYPE equ 08454h
GL_FOG_COORD_ARRAY_STRIDE equ 08455h
GL_FOG_COORD_ARRAY_POINTER equ 08456h
GL_FOG_COORD_ARRAY equ 08457h
GL_SRC0_RGB equ 08580h
GL_SRC1_RGB equ 08581h
GL_SRC2_RGB equ 08582h
GL_SRC0_ALPHA equ 08588h
GL_SRC1_ALPHA equ 08589h
GL_SRC2_ALPHA equ 0858Ah

endif ; GL_VERSION_1_5

;
;  OpenGL 2.0 functionality
;
ifndef GL_VERSION_2_0
GL_VERSION_2_0 equ 1

;
;  I.1 Programmable Shading
;

GL_SHADER_TYPE equ 08B4Fh
GL_DELETE_STATUS equ 08B80h
GL_COMPILE_STATUS equ 08B81h
GL_LINK_STATUS equ 08B82h
GL_VALIDATE_STATUS equ 08B83h
GL_INFO_LOG_LENGTH equ 08B84h
GL_ATTACHED_SHADERS equ 08B85h
GL_ACTIVE_UNIFORMS equ 08B86h
GL_ACTIVE_UNIFORM_MAX_LENGTH equ 08B87h
GL_SHADER_SOURCE_LENGTH equ 08B88h

GL_FLOAT_VEC2 equ 08B50h
GL_FLOAT_VEC3 equ 08B51h
GL_FLOAT_VEC4 equ 08B52h
GL_INT_VEC2 equ 08B53h
GL_INT_VEC3 equ 08B54h
GL_INT_VEC4 equ 08B55h
GL_BOOL equ 08B56h
GL_BOOL_VEC2 equ 08B57h
GL_BOOL_VEC3 equ 08B58h
GL_BOOL_VEC4 equ 08B59h
GL_FLOAT_MAT2 equ 08B5Ah
GL_FLOAT_MAT3 equ 08B5Bh
GL_FLOAT_MAT4 equ 08B5Ch
GL_SAMPLER_1D equ 08B5Dh
GL_SAMPLER_2D equ 08B5Eh
GL_SAMPLER_3D equ 08B5Fh
GL_SAMPLER_CUBE equ 08B60h
GL_SAMPLER_1D_SHADOW equ 08B61h
GL_SAMPLER_2D_SHADOW equ 08B62h
GL_SAMPLER_2D_RECT equ 08B63h
GL_SAMPLER_2D_RECT_SHADOW equ 08B64h

GL_VERTEX_SHADER equ 08B31h

GL_MAX_VERTEX_UNIFORM_COMPONENTS equ 08B4Ah
GL_MAX_VARYING_FLOATS equ 08B4Bh
GL_MAX_VERTEX_ATTRIBS equ 08869h
GL_MAX_TEXTURE_IMAGE_UNITS equ 08872h
GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS equ 08B4Ch
GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS equ 08B4Dh
GL_MAX_TEXTURE_COORDS equ 08871h

GL_VERTEX_PROGRAM_POINT_SIZE equ 08642h
GL_VERTEX_PROGRAM_TWO_SIDE equ 08643h 

GL_ACTIVE_ATTRIBUTES equ 08B89h
GL_ACTIVE_ATTRIBUTE_MAX_LENGTH equ 08B8Ah

GL_VERTEX_ATTRIB_ARRAY_ENABLED equ 08622h
GL_VERTEX_ATTRIB_ARRAY_SIZE equ 08623h
GL_VERTEX_ATTRIB_ARRAY_STRIDE equ 08624h
GL_VERTEX_ATTRIB_ARRAY_TYPE equ 08625h
GL_VERTEX_ATTRIB_ARRAY_NORMALIZED equ 0886Ah
GL_CURRENT_VERTEX_ATTRIB equ 08626h

GL_VERTEX_ATTRIB_ARRAY_POINTER equ 08645h

GL_FRAGMENT_SHADER equ 08B30h

GL_MAX_FRAGMENT_UNIFORM_COMPONENTS equ 08B49h

GL_FRAGMENT_SHADER_DERIVATIVE_HINT equ 08B8Bh

GL_SHADING_LANGUAGE_VERSION equ 08B8Ch
GL_CURRENT_PROGRAM equ 08B8Dh

PFNGLDETACHSHADERPROC_proto typedef proto :dword, :dword
PFNGLDETACHSHADERPROC typedef ptr PFNGLDETACHSHADERPROC_proto

PFNGLCREATESHADERPROC_proto typedef proto :dword
PFNGLCREATESHADERPROC typedef ptr PFNGLCREATESHADERPROC_proto

PFNGLSHADERSOURCEPROC_proto typedef proto :dword, :dword, :dword, :ptr dword
PFNGLSHADERSOURCEPROC typedef ptr PFNGLSHADERSOURCEPROC_proto

PFNGLCOMPILESHADERPROC_proto typedef proto :dword
PFNGLCOMPILESHADERPROC typedef ptr PFNGLCOMPILESHADERPROC_proto

PFNGLCREATEPROGRAMPROC_proto typedef proto
PFNGLCREATEPROGRAMPROC typedef ptr PFNGLCREATEPROGRAMPROC_proto

PFNGLATTACHSHADERPROC_proto typedef proto :dword, :dword
PFNGLATTACHSHADERPROC typedef ptr PFNGLATTACHSHADERPROC_proto

PFNGLLINKPROGRAMPROC_proto typedef proto :dword
PFNGLLINKPROGRAMPROC typedef ptr PFNGLLINKPROGRAMPROC_proto

PFNGLUSEPROGRAMPROC_proto typedef proto :dword
PFNGLUSEPROGRAMPROC typedef ptr PFNGLUSEPROGRAMPROC_proto

PFNGLVALIDATEPROGRAMPROC_proto typedef proto :dword
PFNGLVALIDATEPROGRAMPROC typedef ptr PFNGLVALIDATEPROGRAMPROC_proto

PFNGLUNIFORM1FPROC_proto typedef proto :dword, :real4
PFNGLUNIFORM1FPROC typedef ptr PFNGLUNIFORM1FPROC_proto

PFNGLUNIFORM2FPROC_proto typedef proto :dword, :real4, :real4
PFNGLUNIFORM2FPROC typedef ptr PFNGLUNIFORM1FPROC_proto

PFNGLUNIFORM3FPROC_proto typedef proto :dword, :real4, :real4, :real4
PFNGLUNIFORM3FPROC typedef ptr PFNGLUNIFORM3FPROC_proto

PFNGLUNIFORM4FPROC_proto typedef proto :dword, :real4, :real4, :real4, :real4
PFNGLUNIFORM4FPROC typedef ptr PFNGLUNIFORM4FPROC_proto

PFNGLUNIFORM1IPROC_proto typedef proto :dword, :dword
PFNGLUNIFORM1IPROC typedef ptr PFNGLUNIFORM1IPROC_proto

PFNGLUNIFORM2IPROC_proto typedef proto :dword, :dword, :dword
PFNGLUNIFORM2IPROC typedef ptr PFNGLUNIFORM2IPROC_proto

PFNGLUNIFORM3IPROC_proto typedef proto :dword, :dword, :dword, :dword
PFNGLUNIFORM3IPROC typedef ptr PFNGLUNIFORM3IPROC_proto

PFNGLUNIFORM4IPROC_proto typedef proto :dword, :dword, :dword, :dword, :dword
PFNGLUNIFORM4IPROC typedef ptr PFNGLUNIFORM4IPROC_proto

PFNGLUNIFORM1FVPROC_proto typedef proto :dword, :dword, :ptr real4
PFNGLUNIFORM1FVPROC typedef ptr PFNGLUNIFORM1FVPROC_proto

PFNGLUNIFORM2FVPROC_proto typedef proto :dword, :dword, :ptr real4
PFNGLUNIFORM2FVPROC typedef ptr PFNGLUNIFORM2FVPROC_proto

PFNGLUNIFORM3FVPROC_proto typedef proto :dword, :dword, :ptr real4
PFNGLUNIFORM3FVPROC typedef ptr PFNGLUNIFORM3FVPROC_proto

PFNGLUNIFORM4FVPROC_proto typedef proto :dword, :dword, :ptr real4
PFNGLUNIFORM4FVPROC typedef ptr PFNGLUNIFORM4FVPROC_proto

PFNGLUNIFORM1IVPROC_proto typedef proto :dword, :dword, :ptr dword
PFNGLUNIFORM1IVPROC typedef ptr PFNGLUNIFORM1IVPROC_proto

PFNGLUNIFORM2IVPROC_proto typedef proto :dword, :dword, :ptr dword
PFNGLUNIFORM2IVPROC typedef ptr PFNGLUNIFORM2IVPROC_proto

PFNGLUNIFORM3IVPROC_proto typedef proto :dword, :dword, :ptr dword
PFNGLUNIFORM3IVPROC typedef ptr PFNGLUNIFORM3IVPROC_proto

PFNGLUNIFORM4IVPROC_proto typedef proto :dword, :dword, :ptr dword
PFNGLUNIFORM4IVPROC typedef ptr PFNGLUNIFORM4IVPROC_proto

PFNGLUNIFORMMATRIX2FVPROC_proto typedef proto :dword, :dword, :dword, :ptr real4
PFNGLUNIFORMMATRIX2FVPROC typedef ptr PFNGLUNIFORMMATRIX2FVPROC_proto

PFNGLUNIFORMMATRIX3FVPROC_proto typedef proto :dword, :dword, :dword, :ptr real4
PFNGLUNIFORMMATRIX3FVPROC typedef ptr PFNGLUNIFORMMATRIX3FVPROC_proto

PFNGLUNIFORMMATRIX4FVPROC_proto typedef proto :dword, :dword, :dword, :ptr real4
PFNGLUNIFORMMATRIX4FVPROC typedef ptr PFNGLUNIFORMMATRIX4FVPROC_proto

PFNGLGETATTACHEDSHADERSPROC_proto typedef proto :dword, :dword, :ptr dword, :ptr dword
PFNGLGETATTACHEDSHADERSPROC typedef ptr PFNGLGETATTACHEDSHADERSPROC_proto

PFNGLGETUNIFORMLOCATIONPROC_proto typedef proto :dword, :dword
PFNGLGETUNIFORMLOCATIONPROC typedef ptr PFNGLGETUNIFORMLOCATIONPROC_proto

PFNGLGETACTIVEUNIFORMPROC_proto typedef proto :dword, :dword, :dword, :ptr dword, :ptr dword, :ptr dword, :dword
PFNGLGETACTIVEUNIFORMPROC typedef ptr PFNGLGETACTIVEUNIFORMPROC_proto

PFNGLGETUNIFORMFVPROC_proto typedef proto :dword, :dword, :ptr real4
PFNGLGETUNIFORMFVPROC typedef ptr PFNGLGETUNIFORMFVPROC_proto

PFNGLGETUNIFORMIVPROC_proto typedef proto :dword, :dword, :ptr dword
PFNGLGETUNIFORMIVPROC typedef ptr PFNGLGETUNIFORMIVPROC_proto

PFNGLGETSHADERSOURCEPROC_proto typedef proto :dword, :dword, :ptr dword, :dword
PFNGLGETSHADERSOURCEPROC typedef ptr PFNGLGETSHADERSOURCEPROC_proto

PFNGLVERTEXATTRIB1SPROC_proto typedef proto :dword, :dword
PFNGLVERTEXATTRIB1SPROC typedef ptr PFNGLVERTEXATTRIB1SPROC_proto

PFNGLVERTEXATTRIB1FPROC_proto typedef proto :dword, :real4
PFNGLVERTEXATTRIB1FPROC typedef ptr PFNGLVERTEXATTRIB1FPROC_proto

PFNGLVERTEXATTRIB1DPROC_proto typedef proto :dword, :real8
PFNGLVERTEXATTRIB1DPROC typedef ptr PFNGLVERTEXATTRIB1DPROC_proto

PFNGLVERTEXATTRIB2SPROC_proto typedef proto :dword, :dword, :dword
PFNGLVERTEXATTRIB2SPROC typedef ptr PFNGLVERTEXATTRIB2SPROC_proto

PFNGLVERTEXATTRIB2FPROC_proto typedef proto :dword, :real4, :real4
PFNGLVERTEXATTRIB2FPROC typedef ptr PFNGLVERTEXATTRIB2FPROC_proto

PFNGLVERTEXATTRIB2DPROC_proto typedef proto :dword, :real8, :real8
PFNGLVERTEXATTRIB2DPROC typedef ptr PFNGLVERTEXATTRIB2DPROC_proto

PFNGLVERTEXATTRIB3SPROC_proto typedef proto :dword, :dword, :dword, :dword
PFNGLVERTEXATTRIB3SPROC typedef ptr PFNGLVERTEXATTRIB3SPROC_proto

PFNGLVERTEXATTRIB3FPROC_proto typedef proto :dword, :real4, :real4, :real4
PFNGLVERTEXATTRIB3FPROC typedef ptr PFNGLVERTEXATTRIB3FPROC_proto

PFNGLVERTEXATTRIB3DPROC_proto typedef proto :dword, :real8, :real8, :real8
PFNGLVERTEXATTRIB3DPROC typedef ptr PFNGLVERTEXATTRIB3DPROC_proto

PFNGLVERTEXATTRIB4SPROC_proto typedef proto :dword, :dword, :dword, :dword, :dword
PFNGLVERTEXATTRIB4SPROC typedef ptr PFNGLVERTEXATTRIB4SPROC_proto

PFNGLVERTEXATTRIB4FPROC_proto typedef proto :dword, :real4, :real4, :real4, :real4
PFNGLVERTEXATTRIB4FPROC typedef ptr PFNGLVERTEXATTRIB4FPROC_proto

PFNGLVERTEXATTRIB4DPROC_proto typedef proto :dword, :real8, :real8, :real8, :real8
PFNGLVERTEXATTRIB4DPROC typedef ptr PFNGLVERTEXATTRIB4DPROC_proto

PFNGLVERTEXATTRIB4NUBPROC_proto typedef proto :dword, :dword, :dword, :dword, :dword
PFNGLVERTEXATTRIB4NUBPROC typedef ptr PFNGLVERTEXATTRIB4NUBPROC_proto

PFNGLVERTEXATTRIB1SVPROC_proto typedef proto :dword, :ptr dword
PFNGLVERTEXATTRIB1SVPROC typedef ptr PFNGLVERTEXATTRIB1SVPROC_proto

PFNGLVERTEXATTRIB1FVPROC_proto typedef proto :dword, :ptr real4
PFNGLVERTEXATTRIB1FVPROC typedef ptr PFNGLVERTEXATTRIB1SVPROC_proto

PFNGLVERTEXATTRIB1DVPROC_proto typedef proto :dword, :ptr real8
PFNGLVERTEXATTRIB1DVPROC typedef ptr PFNGLVERTEXATTRIB1DVPROC_proto

PFNGLVERTEXATTRIB2SVPROC_proto typedef proto :dword, :ptr dword
PFNGLVERTEXATTRIB2SVPROC typedef ptr PFNGLVERTEXATTRIB2SVPROC_proto

PFNGLVERTEXATTRIB2FVPROC_proto typedef proto :dword, :ptr real4
PFNGLVERTEXATTRIB2FVPROC typedef ptr PFNGLVERTEXATTRIB2FVPROC_proto

PFNGLVERTEXATTRIB2DVPROC_proto typedef proto :dword, :ptr real8
PFNGLVERTEXATTRIB2DVPROC typedef ptr PFNGLVERTEXATTRIB2DVPROC_proto

PFNGLVERTEXATTRIB3SVPROC_proto typedef proto :dword, :ptr dword
PFNGLVERTEXATTRIB3SVPROC typedef ptr PFNGLVERTEXATTRIB3SVPROC_proto

PFNGLVERTEXATTRIB3FVPROC_proto typedef proto :dword, :ptr real4
PFNGLVERTEXATTRIB3FVPROC typedef ptr PFNGLVERTEXATTRIB3FVPROC_proto

PFNGLVERTEXATTRIB3DVPROC_proto typedef proto :dword, :ptr real8
PFNGLVERTEXATTRIB3DVPROC typedef ptr PFNGLVERTEXATTRIB3DVPROC_proto

PFNGLVERTEXATTRIB4BVPROC_proto typedef proto :dword, :ptr dword
PFNGLVERTEXATTRIB4BVPROC typedef ptr PFNGLVERTEXATTRIB4BVPROC_proto

PFNGLVERTEXATTRIB4SVPROC_proto typedef proto :dword, :ptr dword
PFNGLVERTEXATTRIB4SVPROC typedef ptr PFNGLVERTEXATTRIB4SVPROC_proto

PFNGLVERTEXATTRIB4IVPROC_proto typedef proto :dword, :ptr dword
PFNGLVERTEXATTRIB4IVPROC typedef ptr PFNGLVERTEXATTRIB4IVPROC_proto

PFNGLVERTEXATTRIB4UBVPROC_proto typedef proto :dword, :ptr dword
PFNGLVERTEXATTRIB4UBVPROC typedef ptr PFNGLVERTEXATTRIB4UBVPROC_proto

PFNGLVERTEXATTRIB4USVPROC_proto typedef proto :dword, :ptr dword
PFNGLVERTEXATTRIB4USVPROC typedef ptr PFNGLVERTEXATTRIB4USVPROC_proto

PFNGLVERTEXATTRIB4UIVPROC_proto typedef proto :dword, :ptr dword
PFNGLVERTEXATTRIB4UIVPROC typedef ptr PFNGLVERTEXATTRIB4UIVPROC_proto

PFNGLVERTEXATTRIB4FVPROC_proto typedef proto :dword, :ptr real4
PFNGLVERTEXATTRIB4FVPROC typedef ptr PFNGLVERTEXATTRIB4FVPROC_proto

PFNGLVERTEXATTRIB4DVPROC_proto typedef proto :dword, :ptr real8
PFNGLVERTEXATTRIB4DVPROC typedef ptr PFNGLVERTEXATTRIB4DVPROC_proto

PFNGLVERTEXATTRIB4NBVPROC_proto typedef proto :dword, :ptr dword
PFNGLVERTEXATTRIB4NBVPROC typedef ptr PFNGLVERTEXATTRIB4NBVPROC_proto

PFNGLVERTEXATTRIB4NSVPROC_proto typedef proto :dword, :ptr dword
PFNGLVERTEXATTRIB4NSVPROC typedef ptr PFNGLVERTEXATTRIB4NSVPROC_proto

PFNGLVERTEXATTRIB4NIVPROC_proto typedef proto :dword, :ptr dword
PFNGLVERTEXATTRIB4NIVPROC typedef ptr PFNGLVERTEXATTRIB4NIVPROC_proto

PFNGLVERTEXATTRIB4NUBVPROC_proto typedef proto :dword, :ptr dword
PFNGLVERTEXATTRIB4NUBVPROC typedef ptr PFNGLVERTEXATTRIB4NUBVPROC_proto

PFNGLVERTEXATTRIB4NUSVPROC_proto typedef proto :dword, :ptr dword
PFNGLVERTEXATTRIB4NUSVPROC typedef ptr PFNGLVERTEXATTRIB4NUSVPROC_proto

PFNGLVERTEXATTRIB4NUIVPROC_proto typedef proto :dword, :ptr dword
PFNGLVERTEXATTRIB4NUIVPROC typedef ptr PFNGLVERTEXATTRIB4NUSVPROC_proto

PFNGLVERTEXATTRIBPOINTERPROC_proto typedef proto :dword, :dword, :dword, :dword, :dword, :dword
PFNGLVERTEXATTRIBPOINTERPROC typedef ptr PFNGLVERTEXATTRIBPOINTERPROC_proto

PFNGLENABLEVERTEXATTRIBARRAYPROC_proto typedef proto :dword
PFNGLENABLEVERTEXATTRIBARRAYPROC typedef ptr PFNGLENABLEVERTEXATTRIBARRAYPROC_proto

PFNGLDISABLEVERTEXATTRIBARRAYPROC_proto typedef proto :dword
PFNGLDISABLEVERTEXATTRIBARRAYPROC typedef ptr PFNGLDISABLEVERTEXATTRIBARRAYPROC_proto

PFNGLBINDATTRIBLOCATIONPROC_proto typedef proto :dword, :dword, :dword
PFNGLBINDATTRIBLOCATIONPROC typedef ptr PFNGLBINDATTRIBLOCATIONPROC_proto

PFNGLGETACTIVEATTRIBPROC_proto typedef proto :dword, :dword, :dword, :ptr dword, :ptr dword, :ptr dword, :dword
PFNGLGETACTIVEATTRIBPROC typedef ptr PFNGLGETACTIVEATTRIBPROC_proto

PFNGLGETATTRIBLOCATIONPROC_proto typedef proto :dword, :dword
PFNGLGETATTRIBLOCATIONPROC typedef ptr PFNGLGETATTRIBLOCATIONPROC_proto

PFNGLGETVERTEXATTRIBDVPROC_proto typedef proto :dword, :dword, :ptr real8
PFNGLGETVERTEXATTRIBDVPROC typedef ptr PFNGLGETVERTEXATTRIBDVPROC_proto

PFNGLGETVERTEXATTRIBFVPROC_proto typedef proto :dword, :dword, :ptr real4
PFNGLGETVERTEXATTRIBFVPROC typedef ptr PFNGLGETVERTEXATTRIBFVPROC_proto

PFNGLGETVERTEXATTRIBIVPROC_proto typedef proto :dword, :dword, :ptr dword
PFNGLGETVERTEXATTRIBIVPROC typedef ptr PFNGLGETVERTEXATTRIBIVPROC_proto

PFNGLGETVERTEXATTRIBPOINTERVPROC_proto typedef proto :dword, :dword, :dword
PFNGLGETVERTEXATTRIBPOINTERVPROC typedef ptr PFNGLGETVERTEXATTRIBPOINTERVPROC_proto

PFNGLDELETESHADERPROC_proto typedef proto :dword
PFNGLDELETESHADERPROC typedef ptr PFNGLDELETESHADERPROC_proto

PFNGLISSHADERPROC_proto typedef proto :dword
PFNGLISSHADERPROC typedef ptr PFNGLISSHADERPROC_proto

PFNGLGETSHADERIVPROC_proto typedef proto :dword, :dword, :ptr dword
PFNGLGETSHADERIVPROC typedef ptr PFNGLGETSHADERIVPROC_proto

PFNGLGETSHADERINFOLOGPROC_proto typedef proto :dword, :dword, :ptr dword, :dword
PFNGLGETSHADERINFOLOGPROC typedef ptr PFNGLGETSHADERINFOLOGPROC_proto

PFNGLDELETEPROGRAMPROC_proto typedef proto :dword
PFNGLDELETEPROGRAMPROC typedef ptr PFNGLDELETEPROGRAMPROC_proto

PFNGLISPROGRAMPROC_proto typedef proto :dword
PFNGLISPROGRAMPROC typedef ptr PFNGLISPROGRAMPROC_proto

PFNGLGETPROGRAMIVPROC_proto typedef proto :dword, :dword, :ptr dword
PFNGLGETPROGRAMIVPROC typedef ptr PFNGLGETPROGRAMIVPROC_proto

PFNGLGETPROGRAMINFOLOGPROC_proto typedef proto :dword, :dword, :ptr dword, :dword
PFNGLGETPROGRAMINFOLOGPROC typedef ptr PFNGLGETPROGRAMINFOLOGPROC_proto

;
;  I.2 Multiple Render Targets
;
GL_MAX_DRAW_BUFFERS equ 08824h
GL_DRAW_BUFFER0 equ 08825h
GL_DRAW_BUFFER1 equ 08826h
GL_DRAW_BUFFER2 equ 08827h
GL_DRAW_BUFFER3 equ 08828h
GL_DRAW_BUFFER4 equ 08829h
GL_DRAW_BUFFER5 equ 0882Ah
GL_DRAW_BUFFER6 equ 0882Bh
GL_DRAW_BUFFER7 equ 0882Ch
GL_DRAW_BUFFER8 equ 0882Dh
GL_DRAW_BUFFER9 equ 0882Eh
GL_DRAW_BUFFER10 equ 0882Fh
GL_DRAW_BUFFER11 equ 08830h
GL_DRAW_BUFFER12 equ 08831h
GL_DRAW_BUFFER13 equ 08832h
GL_DRAW_BUFFER14 equ 08833h
GL_DRAW_BUFFER15 equ 08834h

PFNGLDRAWBUFFERSPROC_proto typedef proto :dword, :dword
PFNGLDRAWBUFFERSPROC typedef ptr PFNGLDRAWBUFFERSPROC_proto

;
;  I.4 Point Sprites
;
GL_POINT_SPRITE equ 08861h
GL_COORD_REPLACE equ 08862h
GL_POINT_SPRITE_COORD_ORIGIN equ 08CA0h
GL_LOWER_LEFT equ 08CA1h
GL_UPPER_LEFT equ 08CA2h   

;
;  I.5 Separate Stencil
;

GL_STENCIL_BACK_FUNC equ 08800h
GL_STENCIL_BACK_FAIL equ 08801h
GL_STENCIL_BACK_PASS_DEPTH_FAIL equ 08802h
GL_STENCIL_BACK_PASS_DEPTH_PASS equ 08803h
GL_STENCIL_BACK_REF equ 08CA3h
GL_STENCIL_BACK_VALUE_MASK equ 08CA4h
GL_STENCIL_BACK_WRITEMASK equ 08CA5h

PFNGLSTENCILOPSEPARATEPROC_proto typedef proto :dword, :dword, :dword, :dword
PFNGLSTENCILOPSEPARATEPROC typedef ptr PFNGLSTENCILOPSEPARATEPROC_proto

PFNGLSTENCILFUNCSEPARATEPROC_proto typedef proto :dword, :dword, :dword, :dword
PFNGLSTENCILFUNCSEPARATEPROC typedef ptr PFNGLSTENCILFUNCSEPARATEPROC_proto

PFNGLSTENCILMASKSEPARATEPROC_proto typedef proto :dword, :dword
PFNGLSTENCILMASKSEPARATEPROC typedef ptr PFNGLSTENCILMASKSEPARATEPROC_proto

;
;  BlendEquationSeparate
;
GL_BLEND_EQUATION_RGB equ GL_BLEND_EQUATION
GL_BLEND_EQUATION_ALPHA equ 0883Dh

PFNGLBLENDEQUATIONSEPARATEPROC_proto typedef proto :dword, :dword
PFNGLBLENDEQUATIONSEPARATEPROC typedef ptr PFNGLBLENDEQUATIONSEPARATEPROC_proto

endif ; GL_VERSION_2_0

;
;  ARB EXTENSIONS
;

;
; GL_ARB_vertex_buffer_object
;
; Support:
;   Rage   128  based : Not Supported
;   Radeon 7xxx based : Not Supported
;   Radeon 8xxx based : Not Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_ARB_vertex_buffer_object
GL_ARB_vertex_buffer_object equ 1

GLintptrARB typedef dword
GLsizeiptrARB typedef dword

GL_ARRAY_BUFFER_ARB                             equ 08892h
GL_ELEMENT_ARRAY_BUFFER_ARB                     equ 08893h

GL_ARRAY_BUFFER_BINDING_ARB                     equ 08894h
GL_ELEMENT_ARRAY_BUFFER_BINDING_ARB             equ 08895h
GL_VERTEX_ARRAY_BUFFER_BINDING_ARB              equ 08896h
GL_NORMAL_ARRAY_BUFFER_BINDING_ARB              equ 08897h
GL_COLOR_ARRAY_BUFFER_BINDING_ARB               equ 08898h
GL_INDEX_ARRAY_BUFFER_BINDING_ARB               equ 08899h
GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING_ARB       equ 0889Ah
GL_EDGE_FLAG_ARRAY_BUFFER_BINDING_ARB           equ 0889Bh
GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING_ARB     equ 0889Ch
GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING_ARB      equ 0889Dh
GL_WEIGHT_ARRAY_BUFFER_BINDING_ARB              equ 0889Eh

GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING_ARB       equ 0889Fh

GL_STREAM_DRAW_ARB                              equ 088E0h
GL_STREAM_READ_ARB                              equ 088E1h
GL_STREAM_COPY_ARB                              equ 088E2h
GL_STATIC_DRAW_ARB                              equ 088E4h
GL_STATIC_READ_ARB                              equ 088E5h
GL_STATIC_COPY_ARB                              equ 088E6h
GL_DYNAMIC_DRAW_ARB                             equ 088E8h
GL_DYNAMIC_READ_ARB                             equ 088E9h
GL_DYNAMIC_COPY_ARB                             equ 088EAh

GL_READ_ONLY_ARB                                equ 088B8h
GL_WRITE_ONLY_ARB                               equ 088B9h
GL_READ_WRITE_ARB                               equ 088BAh

GL_BUFFER_SIZE_ARB                              equ 08764h
GL_BUFFER_USAGE_ARB                             equ 08765h
GL_BUFFER_ACCESS_ARB                            equ 088BBh
GL_BUFFER_MAPPED_ARB                            equ 088BCh

GL_BUFFER_MAP_POINTER_ARB                       equ 088BDh

PFNGLBINDBUFFERARBPROC_proto typedef proto :dword, :dword
PFNGLBINDBUFFERARBPROC typedef ptr PFNGLBINDBUFFERARBPROC_proto

PFNGLDELETEBUFFERSARBPROC_proto typedef proto :dword, :ptr dword
PFNGLDELETEBUFFERSARBPROC typedef ptr PFNGLDELETEBUFFERSARBPROC_proto

PFNGLGENBUFFERSARBPROC_proto typedef proto :dword, :ptr dword
PFNGLGENBUFFERSARBPROC typedef ptr PFNGLGENBUFFERSARBPROC_proto

PFNGLISBUFFERARBPROC_proto typedef proto :dword
PFNGLISBUFFERARBPROC typedef ptr PFNGLISBUFFERARBPROC_proto

PFNGLBUFFERDATAARBPROC_proto typedef proto :dword, :dword, :dword, :dword
PFNGLBUFFERDATAARBPROC typedef ptr PFNGLBUFFERDATAARBPROC_proto

PFNGLBUFFERSUBDATAARBPROC_proto typedef proto :dword, :dword, :dword, :dword
PFNGLBUFFERSUBDATAARBPROC typedef ptr PFNGLBUFFERSUBDATAARBPROC_proto

PFNGLGETBUFFERSUBDATAARBPROC_proto typedef proto :dword, :dword, :dword, :dword
PFNGLGETBUFFERSUBDATAARBPROC typedef ptr PFNGLGETBUFFERSUBDATAARBPROC_proto

PFNGLMAPBUFFERARBPROC_proto typedef proto :dword, :dword
PFNGLMAPBUFFERARBPROC typedef ptr PFNGLMAPBUFFERARBPROC_proto

PFNGLUNMAPBUFFERARBPROC_proto typedef proto :dword
PFNGLUNMAPBUFFERARBPROC typedef ptr PFNGLUNMAPBUFFERARBPROC_proto

PFNGLGETBUFFERPARAMETERIVARBPROC_proto typedef proto :dword, :dword, :ptr dword
PFNGLGETBUFFERPARAMETERIVARBPROC typedef ptr PFNGLGETBUFFERPARAMETERIVARBPROC_proto

PFNGLGETBUFFERPOINTERVARBPROC_proto typedef proto :dword, :dword, :dword
PFNGLGETBUFFERPOINTERVARBPROC typedef ptr PFNGLGETBUFFERPOINTERVARBPROC_proto

endif ; GL_ARB_vertex_buffer_object

;
; GL_ARB_matrix_palette
;
; Support:
;   Rage   128  based : Not Supported
;   Radeon 7xxx based : Not Supported
;   Radeon 8xxx based : Not Supported
;   Radeon 9xxx based : Not Supported
;
ifndef GL_ARB_matrix_palette
GL_ARB_matrix_palette                   equ 1

GL_MATRIX_PALETTE_ARB                   equ 08840h
GL_MAX_MATRIX_PALETTE_STACK_DEPTH_ARB   equ 08841h
GL_MAX_PALETTE_MATRICES_ARB             equ 08842h
GL_CURRENT_PALETTE_MATRIX_ARB           equ 08843h
GL_MATRIX_INDEX_ARRAY_ARB               equ 08844h
GL_CURRENT_MATRIX_INDEX_ARB             equ 08845h
GL_MATRIX_INDEX_ARRAY_SIZE_ARB          equ 08846h
GL_MATRIX_INDEX_ARRAY_TYPE_ARB          equ 08847h
GL_MATRIX_INDEX_ARRAY_STRIDE_ARB        equ 08848h
GL_MATRIX_INDEX_ARRAY_POINTER_ARB       equ 08849h

PFNGLCURRENTPALETTEMATRIXARBPROC_proto typedef proto :dword 
PFNGLCURRENTPALETTEMATRIXARBPROC typedef ptr PFNGLCURRENTPALETTEMATRIXARBPROC_proto
PFNGLMATRIXINDEXUBVARBPROC_proto typedef proto :dword , :dword 
PFNGLMATRIXINDEXUBVARBPROC typedef ptr PFNGLMATRIXINDEXUBVARBPROC_proto
PFNGLMATRIXINDEXUSVARBPROC_proto typedef proto :dword , :dword 
PFNGLMATRIXINDEXUSVARBPROC typedef ptr PFNGLMATRIXINDEXUSVARBPROC_proto
PFNGLMATRIXINDEXUIVARBPROC_proto typedef proto :dword , :dword 
PFNGLMATRIXINDEXUIVARBPROC typedef ptr PFNGLMATRIXINDEXUIVARBPROC_proto
PFNGLMATRIXINDEXPOINTERARBPROC_proto typedef proto :dword , :dword , :dword , :dword 
PFNGLMATRIXINDEXPOINTERARBPROC typedef ptr PFNGLMATRIXINDEXPOINTERARBPROC_proto

endif ; GL_ARB_matrix_palette

;
; GL_ARB_multisample
;
; Support:
;   Rage   128  based : Not Supported
;   Radeon 7xxx based : Not Supported
;   Radeon 8xxx based : Not Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_ARB_multisample
GL_ARB_multisample              equ 1

GL_MULTISAMPLE_ARB              equ 0809Dh
GL_SAMPLE_ALPHA_TO_COVERAGE_ARB equ 0809Eh
GL_SAMPLE_ALPHA_TO_ONE_ARB      equ 0809Fh
GL_SAMPLE_COVERAGE_ARB          equ 080A0h
GL_SAMPLE_BUFFERS_ARB           equ 080A8h
GL_SAMPLES_ARB                  equ 080A9h
GL_SAMPLE_COVERAGE_VALUE_ARB    equ 080AAh
GL_SAMPLE_COVERAGE_INVERT_ARB   equ 080ABh
GL_MULTISAMPLE_BIT_ARB          equ 020000000h

PFNGLSAMPLECOVERAGEARBPROC_proto typedef proto :dword , :dword 
PFNGLSAMPLECOVERAGEARBPROC typedef ptr PFNGLSAMPLECOVERAGEARBPROC_proto

endif ; GL_ARB_multisample

;
; GL_ARB_multitexture
;
;  Support:
;   Rage 128 based    : Supported
;   Radeon 7xxx based : Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_ARB_multitexture
GL_ARB_multitexture                 equ 1

GL_ACTIVE_TEXTURE_ARB               equ 084E0h
GL_CLIENT_ACTIVE_TEXTURE_ARB        equ 084E1h
GL_MAX_TEXTURE_UNITS_ARB            equ 084E2h
GL_TEXTURE0_ARB                     equ 084C0h
GL_TEXTURE1_ARB                     equ 084C1h
GL_TEXTURE2_ARB                     equ 084C2h
GL_TEXTURE3_ARB                     equ 084C3h
GL_TEXTURE4_ARB                     equ 084C4h
GL_TEXTURE5_ARB                     equ 084C5h
GL_TEXTURE6_ARB                     equ 084C6h
GL_TEXTURE7_ARB                     equ 084C7h
GL_TEXTURE8_ARB                     equ 084C8h
GL_TEXTURE9_ARB                     equ 084C9h
GL_TEXTURE10_ARB                    equ 084CAh
GL_TEXTURE11_ARB                    equ 084CBh
GL_TEXTURE12_ARB                    equ 084CCh
GL_TEXTURE13_ARB                    equ 084CDh
GL_TEXTURE14_ARB                    equ 084CEh
GL_TEXTURE15_ARB                    equ 084CFh
GL_TEXTURE16_ARB                    equ 084D0h
GL_TEXTURE17_ARB                    equ 084D1h
GL_TEXTURE18_ARB                    equ 084D2h
GL_TEXTURE19_ARB                    equ 084D3h
GL_TEXTURE20_ARB                    equ 084D4h
GL_TEXTURE21_ARB                    equ 084D5h
GL_TEXTURE22_ARB                    equ 084D6h
GL_TEXTURE23_ARB                    equ 084D7h
GL_TEXTURE24_ARB                    equ 084D8h
GL_TEXTURE25_ARB                    equ 084D9h
GL_TEXTURE26_ARB                    equ 084DAh
GL_TEXTURE27_ARB                    equ 084DBh
GL_TEXTURE28_ARB                    equ 084DCh
GL_TEXTURE29_ARB                    equ 084DDh
GL_TEXTURE30_ARB                    equ 084DEh
GL_TEXTURE31_ARB                    equ 084DFh

PFNGLACTIVETEXTUREARBPROC_proto typedef proto :dword 
PFNGLACTIVETEXTUREARBPROC typedef ptr PFNGLACTIVETEXTUREARBPROC_proto
PFNGLCLIENTACTIVETEXTUREARBPROC_proto typedef proto :dword 
PFNGLCLIENTACTIVETEXTUREARBPROC typedef ptr PFNGLCLIENTACTIVETEXTUREARBPROC_proto
PFNGLMULTITEXCOORD1DARBPROC_proto typedef proto :dword , :real8
PFNGLMULTITEXCOORD1DARBPROC typedef ptr PFNGLMULTITEXCOORD1DARBPROC_proto
PFNGLMULTITEXCOORD1DVARBPROC_proto typedef proto :dword , :ptr real8
PFNGLMULTITEXCOORD1DVARBPROC typedef ptr PFNGLMULTITEXCOORD1DVARBPROC_proto
PFNGLMULTITEXCOORD1FARBPROC_proto typedef proto :dword , :real4
PFNGLMULTITEXCOORD1FARBPROC typedef ptr PFNGLMULTITEXCOORD1FARBPROC_proto
PFNGLMULTITEXCOORD1FVARBPROC_proto typedef proto :dword , :ptr real4
PFNGLMULTITEXCOORD1FVARBPROC typedef ptr PFNGLMULTITEXCOORD1FVARBPROC_proto
PFNGLMULTITEXCOORD1IARBPROC_proto typedef proto :dword , :dword 
PFNGLMULTITEXCOORD1IARBPROC typedef ptr PFNGLMULTITEXCOORD1IARBPROC_proto
PFNGLMULTITEXCOORD1IVARBPROC_proto typedef proto :dword , :ptr dword 
PFNGLMULTITEXCOORD1IVARBPROC typedef ptr PFNGLMULTITEXCOORD1IVARBPROC_proto
PFNGLMULTITEXCOORD1SARBPROC_proto typedef proto :dword , :dword 
PFNGLMULTITEXCOORD1SARBPROC typedef ptr PFNGLMULTITEXCOORD1SARBPROC_proto
PFNGLMULTITEXCOORD1SVARBPROC_proto typedef proto :dword , :ptr dword 
PFNGLMULTITEXCOORD1SVARBPROC typedef ptr PFNGLMULTITEXCOORD1SVARBPROC_proto
PFNGLMULTITEXCOORD2DARBPROC_proto typedef proto :dword , :real8, :real8
PFNGLMULTITEXCOORD2DARBPROC typedef ptr PFNGLMULTITEXCOORD2DARBPROC_proto
PFNGLMULTITEXCOORD2DVARBPROC_proto typedef proto :dword , :ptr real8
PFNGLMULTITEXCOORD2DVARBPROC typedef ptr PFNGLMULTITEXCOORD2DVARBPROC_proto
PFNGLMULTITEXCOORD2FARBPROC_proto typedef proto :dword , :real4 , :real4
PFNGLMULTITEXCOORD2FARBPROC typedef ptr PFNGLMULTITEXCOORD2FARBPROC_proto
PFNGLMULTITEXCOORD2FVARBPROC_proto typedef proto :dword , :ptr real4
PFNGLMULTITEXCOORD2FVARBPROC typedef ptr PFNGLMULTITEXCOORD2FVARBPROC_proto
PFNGLMULTITEXCOORD2IARBPROC_proto typedef proto :dword , :dword , :dword 
PFNGLMULTITEXCOORD2IARBPROC typedef ptr PFNGLMULTITEXCOORD2IARBPROC_proto
PFNGLMULTITEXCOORD2IVARBPROC_proto typedef proto :dword , :ptr dword 
PFNGLMULTITEXCOORD2IVARBPROC typedef ptr PFNGLMULTITEXCOORD2IVARBPROC_proto
PFNGLMULTITEXCOORD2SARBPROC_proto typedef proto :dword , :dword , :dword 
PFNGLMULTITEXCOORD2SARBPROC typedef ptr PFNGLMULTITEXCOORD2SARBPROC_proto
PFNGLMULTITEXCOORD2SVARBPROC_proto typedef proto :dword , :dword 
PFNGLMULTITEXCOORD2SVARBPROC typedef ptr PFNGLMULTITEXCOORD2SVARBPROC_proto
PFNGLMULTITEXCOORD3DARBPROC_proto typedef proto :dword , :real8 , :real8 , :real8
PFNGLMULTITEXCOORD3DARBPROC typedef ptr PFNGLMULTITEXCOORD3DARBPROC_proto
PFNGLMULTITEXCOORD3DVARBPROC_proto typedef proto :dword , :ptr real8
PFNGLMULTITEXCOORD3DVARBPROC typedef ptr PFNGLMULTITEXCOORD3DVARBPROC_proto
PFNGLMULTITEXCOORD3FARBPROC_proto typedef proto :dword , :real4, :real4 , :real4
PFNGLMULTITEXCOORD3FARBPROC typedef ptr PFNGLMULTITEXCOORD3FARBPROC_proto
PFNGLMULTITEXCOORD3FVARBPROC_proto typedef proto :dword , :ptr real4
PFNGLMULTITEXCOORD3FVARBPROC typedef ptr PFNGLMULTITEXCOORD3FVARBPROC_proto
PFNGLMULTITEXCOORD3IARBPROC_proto typedef proto :dword , :dword , :dword , :dword 
PFNGLMULTITEXCOORD3IARBPROC typedef ptr PFNGLMULTITEXCOORD3IARBPROC_proto
PFNGLMULTITEXCOORD3IVARBPROC_proto typedef proto :dword , :dword
PFNGLMULTITEXCOORD3IVARBPROC typedef ptr PFNGLMULTITEXCOORD3IVARBPROC_proto
PFNGLMULTITEXCOORD3SARBPROC_proto typedef proto :dword , :dword , :dword , :dword 
PFNGLMULTITEXCOORD3SARBPROC typedef ptr PFNGLMULTITEXCOORD3SARBPROC_proto
PFNGLMULTITEXCOORD3SVARBPROC_proto typedef proto :dword , :ptr dword 
PFNGLMULTITEXCOORD3SVARBPROC typedef ptr PFNGLMULTITEXCOORD3SVARBPROC_proto
PFNGLMULTITEXCOORD4DARBPROC_proto typedef proto :dword , :real8 , :real8 , :real8 , :real8
PFNGLMULTITEXCOORD4DARBPROC typedef ptr PFNGLMULTITEXCOORD4DARBPROC_proto
PFNGLMULTITEXCOORD4DVARBPROC_proto typedef proto :dword , :ptr real8
PFNGLMULTITEXCOORD4DVARBPROC typedef ptr PFNGLMULTITEXCOORD4DVARBPROC_proto
PFNGLMULTITEXCOORD4FARBPROC_proto typedef proto :dword , :real4, :real4, :real4, :real4
PFNGLMULTITEXCOORD4FARBPROC typedef ptr PFNGLMULTITEXCOORD4FARBPROC_proto
PFNGLMULTITEXCOORD4FVARBPROC_proto typedef proto :dword , :ptr real4
PFNGLMULTITEXCOORD4FVARBPROC typedef ptr PFNGLMULTITEXCOORD4FVARBPROC_proto
PFNGLMULTITEXCOORD4IARBPROC_proto typedef proto :dword , :dword , :dword , :dword , :dword 
PFNGLMULTITEXCOORD4IARBPROC typedef ptr PFNGLMULTITEXCOORD4IARBPROC_proto
PFNGLMULTITEXCOORD4IVARBPROC_proto typedef proto :dword , :ptr dword
PFNGLMULTITEXCOORD4IVARBPROC typedef ptr PFNGLMULTITEXCOORD4IVARBPROC_proto
PFNGLMULTITEXCOORD4SARBPROC_proto typedef proto :dword , :dword , :dword , :dword , :dword 
PFNGLMULTITEXCOORD4SARBPROC typedef ptr PFNGLMULTITEXCOORD4SARBPROC_proto
PFNGLMULTITEXCOORD4SVARBPROC_proto typedef proto :dword , :ptr dword 
PFNGLMULTITEXCOORD4SVARBPROC typedef ptr PFNGLMULTITEXCOORD4SVARBPROC_proto

endif ; GL_ARB_multitexture

;
; GL_ARB_occlusion_query
;
; Support:
;   Rage 128 based    : Not Supported
;   Radeon 7xxx based : Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_ARB_occlusion_query
GL_ARB_occlusion_query equ 1

GL_SAMPLES_PASSED_ARB equ 08914h
GL_QUERY_COUNTER_BITS_ARB equ 08864h
GL_CURRENT_QUERY_ARB equ 08865h
GL_QUERY_RESULT_ARB equ 08866h
GL_QUERY_RESULT_AVAILABLE_ARB equ 08867h

PFNGLGENQUERIESARBPROC_proto typedef proto :dword , :ptr dword 
PFNGLGENQUERIESARBPROC typedef ptr PFNGLGENQUERIESARBPROC_proto

PFNGLDELETEQUERIESARBPROC_proto typedef proto :dword , :ptr dword 
PFNGLDELETEQUERIESARBPROC typedef ptr PFNGLDELETEQUERIESARBPROC_proto

PFNGLISQUERYARBPROC_proto typedef proto :dword
PFNGLISQUERYARBPROC typedef ptr PFNGLISQUERYARBPROC_proto

PFNGLBEGINQUERYARBPROC_proto typedef proto :dword, :dword
PFNGLBEGINQUERYARBPROC typedef ptr PFNGLBEGINQUERYARBPROC_proto

PFNGLENDQUERYARBPROC_proto typedef proto :dword
PFNGLENDQUERYARBPROC typedef ptr PFNGLENDQUERYARBPROC_proto

PFNGLGETQUERYIVARBPROC_proto typedef proto :dword, :dword, :ptr dword
PFNGLGETQUERYIVARBPROC typedef ptr PFNGLGETQUERYIVARBPROC_proto

PFNGLGETQUERYOBJECTIVARBPROC_proto typedef proto :dword, :dword, :ptr dword
PFNGLGETQUERYOBJECTIVARBPROC typedef ptr PFNGLGETQUERYOBJECTIVARBPROC_proto

PFNGLGETQUERYOBJECTUIVARBPROC_proto typedef proto :dword, :dword, :ptr dword
PFNGLGETQUERYOBJECTUIVARBPROC typedef ptr PFNGLGETQUERYOBJECTUIVARBPROC_proto

endif ; GL_ARB_occlusion_query

;
; GL_ARB_texture_border_clamp
;
; Support:
;   Rage 128 based    : Supported
;   Radeon 7xxx based : Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_ARB_texture_border_clamp
GL_ARB_texture_border_clamp equ 1

GL_CLAMP_TO_BORDER_ARB  equ 0812Dh

endif ; GL_ARB_texture_border_clamp

;
; GL_ARB_texture_compression
;
; Support:
;   Rage 128 based    : Not Supported
;   Radeon 7xxx based : Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_ARB_texture_compression
GL_ARB_texture_compression equ 1

GL_COMPRESSED_ALPHA_ARB               equ 084E9h
GL_COMPRESSED_LUMINANCE_ARB           equ 084EAh
GL_COMPRESSED_LUMINANCE_ALPHA_ARB     equ 084EBh
GL_COMPRESSED_INTENSITY_ARB           equ 084ECh
GL_COMPRESSED_RGB_ARB                 equ 084EDh
GL_COMPRESSED_RGBA_ARB                equ 084EEh
GL_TEXTURE_COMPRESSION_HINT_ARB       equ 084EFh
GL_TEXTURE_COMPRESSED_IMAGE_SIZE_ARB  equ 086A0h
GL_TEXTURE_COMPRESSED_ARB             equ 086A1h
GL_NUM_COMPRESSED_TEXTURE_FORMATS_ARB equ 086A2h
GL_COMPRESSED_TEXTURE_FORMATS_ARB     equ 086A3h

PFNGLCOMPRESSEDTEXIMAGE3DARBPROC_proto typedef proto :dword , :dword , :dword , :dword , :dword , :dword , :dword , :dword , :dword 
PFNGLCOMPRESSEDTEXIMAGE3DARBPROC typedef ptr PFNGLCOMPRESSEDTEXIMAGE3DARBPROC_proto
PFNGLCOMPRESSEDTEXIMAGE2DARBPROC_proto typedef proto :dword , :dword , :dword , :dword , :dword , :dword , :dword , :dword 
PFNGLCOMPRESSEDTEXIMAGE2DARBPROC typedef ptr PFNGLCOMPRESSEDTEXIMAGE2DARBPROC_proto
PFNGLCOMPRESSEDTEXIMAGE1DARBPROC_proto typedef proto :dword , :dword , :dword , :dword , :dword , :dword , :dword 
PFNGLCOMPRESSEDTEXIMAGE1DARBPROC typedef ptr PFNGLCOMPRESSEDTEXIMAGE1DARBPROC_proto
PFNGLCOMPRESSEDTEXSUBIMAGE3DARBPROC_proto typedef proto :dword , :dword , :dword , :dword , :dword , :dword , :dword , :dword , :dword , :dword , :dword 
PFNGLCOMPRESSEDTEXSUBIMAGE3DARBPROC typedef ptr PFNGLCOMPRESSEDTEXSUBIMAGE3DARBPROC_proto
PFNGLCOMPRESSEDTEXSUBIMAGE2DARBPROC_proto typedef proto :dword , :dword , :dword , :dword , :dword , :dword , :dword , :dword , :dword 
PFNGLCOMPRESSEDTEXSUBIMAGE2DARBPROC typedef ptr PFNGLCOMPRESSEDTEXSUBIMAGE2DARBPROC_proto
PFNGLCOMPRESSEDTEXSUBIMAGE1DARBPROC_proto typedef proto :dword , :dword , :dword , :dword , :dword , :dword , :dword 
PFNGLCOMPRESSEDTEXSUBIMAGE1DARBPROC typedef ptr PFNGLCOMPRESSEDTEXSUBIMAGE1DARBPROC_proto
PFNGLGETCOMPRESSEDTEXIMAGEARBPROC_proto typedef proto :dword , :dword , :dword 
PFNGLGETCOMPRESSEDTEXIMAGEARBPROC typedef ptr PFNGLGETCOMPRESSEDTEXIMAGEARBPROC_proto


endif ; GL_ARB_texture_compression

;
; GL_ARB_texture_cube_map
;
;  Support:
;   Rage 128 based    : Not Supported
;   Radeon 7xxx based : Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_ARB_texture_cube_map
GL_ARB_texture_cube_map equ 1

GL_NORMAL_MAP_ARB                  equ 08511h
GL_REFLECTION_MAP_ARB              equ 08512h
GL_TEXTURE_CUBE_MAP_ARB            equ 08513h
GL_TEXTURE_BINDING_CUBE_MAP_ARB    equ 08514h
GL_TEXTURE_CUBE_MAP_POSITIVE_X_ARB equ 08515h
GL_TEXTURE_CUBE_MAP_NEGATIVE_X_ARB equ 08516h
GL_TEXTURE_CUBE_MAP_POSITIVE_Y_ARB equ 08517h
GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_ARB equ 08518h
GL_TEXTURE_CUBE_MAP_POSITIVE_Z_ARB equ 08519h
GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_ARB equ 0851Ah
GL_PROXY_TEXTURE_CUBE_MAP_ARB      equ 0851Bh
GL_MAX_CUBE_MAP_TEXTURE_SIZE_ARB   equ 0851Ch

endif ; GL_ARB_texture_cube_map

;
; GL_ARB_texture_env_add
;
;  Support:
;   Rage 128 based    : Supported
;   Radeon 7xxx based : Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_ARB_texture_env_add
GL_ARB_texture_env_add  equ 1

endif ; GL_ARB_texture_env_add

;
; GL_ARB_texture_env_combine
;
;  Support:
;   Rage 128 based    : Not Supported
;   Radeon 7xxx based : Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;

ifndef GL_ARB_texture_env_combine
GL_ARB_texture_env_combine  equ 1

GL_COMBINE_ARB        equ 08570h
GL_COMBINE_RGB_ARB    equ 08571h
GL_COMBINE_ALPHA_ARB  equ 08572h
GL_SOURCE0_RGB_ARB    equ 08580h
GL_SOURCE1_RGB_ARB    equ 08581h
GL_SOURCE2_RGB_ARB    equ 08582h
GL_SOURCE0_ALPHA_ARB  equ 08588h
GL_SOURCE1_ALPHA_ARB  equ 08589h
GL_SOURCE2_ALPHA_ARB  equ 0858Ah
GL_OPERAND0_RGB_ARB   equ 08590h
GL_OPERAND1_RGB_ARB   equ 08591h
GL_OPERAND2_RGB_ARB   equ 08592h
GL_OPERAND0_ALPHA_ARB equ 08598h
GL_OPERAND1_ALPHA_ARB equ 08599h
GL_OPERAND2_ALPHA_ARB equ 0859Ah
GL_RGB_SCALE_ARB      equ 08573h
GL_ADD_SIGNED_ARB     equ 08574h
GL_INTERPOLATE_ARB    equ 08575h
GL_CONSTANT_ARB       equ 08576h
GL_PRIMARY_COLOR_ARB  equ 08577h
GL_PREVIOUS_ARB       equ 08578h
GL_SUBTRACT_ARB       equ 084E7h

endif ; GL_ARB_texture_env_combine

;
; GL_ARB_texture_env_crossbar
;
;  Support:
;   Rage 128 based    : Not Supported
;   Radeon 7xxx based : Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_ARB_texture_env_crossbar
GL_ARB_texture_env_crossbar equ 1

endif ; GL_ARB_texture_env_crossbar

;
; GL_ARB_texture_env_dot3
;
;  Support:
;   Rage 128 based     : Not Supported
;   Radeon 7xxx based  : Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_ARB_texture_env_dot3
GL_ARB_texture_env_dot3 equ 1

GL_DOT3_RGB_ARB  equ 086AEh
GL_DOT3_RGBA_ARB equ 086AFh

endif ; GL_ARB_texture_env_dot3

;
; GL_ARB_texture_mirrored_repeat
;
;  Support:
;   Rage 128 based    : Not Supported
;   Radeon 7xxx based : Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_ARB_texture_mirrored_repeat
GL_ARB_texture_mirrored_repeat equ 1

GL_MIRRORED_REPEAT_ARB               equ 08370h

endif ; GL_ARB_texture_mirrored_repeat

;
; GL_ARB_transpose_matrix
;
;  Support:
;   Rage 128 based    : Supported
;   Radeon 7xxx based : Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_ARB_transpose_matrix
GL_ARB_transpose_matrix equ 1

GL_TRANSPOSE_MODELVIEW_MATRIX_ARB  equ 084E3h
GL_TRANSPOSE_PROJECTION_MATRIX_ARB equ 084E4h
GL_TRANSPOSE_TEXTURE_MATRIX_ARB    equ 084E5h
GL_TRANSPOSE_COLOR_MATRIX_ARB      equ 084E6h

PFNGLLOADTRANSPOSEMATRIXFARBPROC_proto typedef proto :ptr real4
PFNGLLOADTRANSPOSEMATRIXFARBPROC typedef ptr PFNGLLOADTRANSPOSEMATRIXFARBPROC_proto
PFNGLLOADTRANSPOSEMATRIXDARBPROC_proto typedef proto :ptr real8
PFNGLLOADTRANSPOSEMATRIXDARBPROC typedef ptr PFNGLLOADTRANSPOSEMATRIXDARBPROC_proto
PFNGLMULTTRANSPOSEMATRIXFARBPROC_proto typedef proto :ptr real4
PFNGLMULTTRANSPOSEMATRIXFARBPROC typedef ptr PFNGLMULTTRANSPOSEMATRIXFARBPROC_proto
PFNGLMULTTRANSPOSEMATRIXDARBPROC_proto typedef proto :ptr real8
PFNGLMULTTRANSPOSEMATRIXDARBPROC typedef ptr PFNGLMULTTRANSPOSEMATRIXDARBPROC_proto

endif ; GL_ARB_transpose_matrix

;
; GL_ARB_vertex_blend
;
;  Support:
;   Rage 128 based    : Supported
;   Radeon 7xxx based : Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_ARB_vertex_blend
GL_ARB_vertex_blend         equ 1

GL_MAX_VERTEX_UNITS_ARB     equ 086A4h
GL_ACTIVE_VERTEX_UNITS_ARB  equ 086A5h
GL_WEIGHT_SUM_UNITY_ARB     equ 086A6h
GL_VERTEX_BLEND_ARB         equ 086A7h
GL_CURRENT_WEIGHT_ARB       equ 086A8h
GL_WEIGHT_ARRAY_TYPE_ARB    equ 086A9h
GL_WEIGHT_ARRAY_STRIDE_ARB  equ 086AAh
GL_WEIGHT_ARRAY_SIZE_ARB    equ 086ABh
GL_WEIGHT_ARRAY_POINTER_ARB equ 086ACh
GL_WEIGHT_ARRAY_ARB         equ 086ADh
GL_MODELVIEW0_ARB           equ 01700h
ifndef GL_MODELVIEW1_ARB
GL_MODELVIEW1_ARB           equ 0850ah
endif
GL_MODELVIEW2_ARB           equ 08722h
GL_MODELVIEW3_ARB           equ 08723h
GL_MODELVIEW4_ARB           equ 08724h
GL_MODELVIEW5_ARB           equ 08725h
GL_MODELVIEW6_ARB           equ 08726h
GL_MODELVIEW7_ARB           equ 08727h
GL_MODELVIEW8_ARB           equ 08728h
GL_MODELVIEW9_ARB           equ 08729h
GL_MODELVIEW10_ARB          equ 0872Ah
GL_MODELVIEW11_ARB          equ 0872Bh
GL_MODELVIEW12_ARB          equ 0872Ch
GL_MODELVIEW13_ARB          equ 0872Dh
GL_MODELVIEW14_ARB          equ 0872Eh
GL_MODELVIEW15_ARB          equ 0872Fh
GL_MODELVIEW16_ARB          equ 08730h
GL_MODELVIEW17_ARB          equ 08731h
GL_MODELVIEW18_ARB          equ 08732h
GL_MODELVIEW19_ARB          equ 08733h
GL_MODELVIEW20_ARB          equ 08734h
GL_MODELVIEW21_ARB          equ 08735h
GL_MODELVIEW22_ARB          equ 08736h
GL_MODELVIEW23_ARB          equ 08737h
GL_MODELVIEW24_ARB          equ 08738h
GL_MODELVIEW25_ARB          equ 08739h
GL_MODELVIEW26_ARB          equ 0873Ah
GL_MODELVIEW27_ARB          equ 0873Bh
GL_MODELVIEW28_ARB          equ 0873Ch
GL_MODELVIEW29_ARB          equ 0873Dh
GL_MODELVIEW30_ARB          equ 0873Eh
GL_MODELVIEW31_ARB          equ 0873Fh

PFNGLWEIGHTBVARBPROC_proto typedef proto :dword , :ptr dword 
PFNGLWEIGHTBVARBPROC typedef ptr PFNGLWEIGHTBVARBPROC_proto
PFNGLWEIGHTSVARBPROC_proto typedef proto :dword , :ptr dword 
PFNGLWEIGHTSVARBPROC typedef ptr PFNGLWEIGHTSVARBPROC_proto
PFNGLWEIGHTIVARBPROC_proto typedef proto :dword , :ptr dword
PFNGLWEIGHTIVARBPROC typedef ptr PFNGLWEIGHTIVARBPROC_proto
PFNGLWEIGHTFVARBPROC_proto typedef proto :dword , :ptr real4 
PFNGLWEIGHTFVARBPROC typedef ptr PFNGLWEIGHTFVARBPROC_proto
PFNGLWEIGHTDVARBPROC_proto typedef proto :dword , :ptr real8
PFNGLWEIGHTDVARBPROC typedef ptr PFNGLWEIGHTDVARBPROC_proto
PFNGLWEIGHTUBVARBPROC_proto typedef proto :dword , :ptr dword 
PFNGLWEIGHTUBVARBPROC typedef ptr PFNGLWEIGHTUBVARBPROC_proto
PFNGLWEIGHTUSVARBPROC_proto typedef proto :dword , :ptr dword 
PFNGLWEIGHTUSVARBPROC typedef ptr PFNGLWEIGHTUSVARBPROC_proto
PFNGLWEIGHTUIVARBPROC_proto typedef proto :dword , :ptr dword 
PFNGLWEIGHTUIVARBPROC typedef ptr PFNGLWEIGHTUIVARBPROC_proto
PFNGLWEIGHTPOINTERARBPROC_proto typedef proto :dword , :dword , :dword , :dword 
PFNGLWEIGHTPOINTERARBPROC typedef ptr PFNGLWEIGHTPOINTERARBPROC_proto
PFNGLVERTEXBLENDARBPROC_proto typedef proto :dword 
PFNGLVERTEXBLENDARBPROC typedef ptr PFNGLVERTEXBLENDARBPROC_proto

endif ; GL_ARB_vertex_blend

;
; GL_ARB_vertex_program
;
;  Support:
;   Rage 128  * based : Not Supported
;   Radeon    * based : Not Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_ARB_vertex_program
GL_ARB_vertex_program equ 1

GL_VERTEX_PROGRAM_ARB                               equ 08620h
GL_VERTEX_PROGRAM_POINT_SIZE_ARB                    equ 08642h
GL_VERTEX_PROGRAM_TWO_SIDE_ARB                      equ 08643h
GL_COLOR_SUM_ARB                                    equ 08458h
GL_PROGRAM_FORMAT_ASCII_ARB                         equ 08875h
GL_VERTEX_ATTRIB_ARRAY_ENABLED_ARB                  equ 08622h
GL_VERTEX_ATTRIB_ARRAY_SIZE_ARB                     equ 08623h
GL_VERTEX_ATTRIB_ARRAY_STRIDE_ARB                   equ 08624h
GL_VERTEX_ATTRIB_ARRAY_TYPE_ARB                     equ 08625h
GL_VERTEX_ATTRIB_ARRAY_NORMALIZED_ARB               equ 0886Ah
GL_CURRENT_VERTEX_ATTRIB_ARB                        equ 08626h
GL_VERTEX_ATTRIB_ARRAY_POINTER_ARB                  equ 08645h
GL_PROGRAM_LENGTH_ARB                               equ 08627h
GL_PROGRAM_FORMAT_ARB                               equ 08876h
GL_PROGRAM_BINDING_ARB                              equ 08677h
GL_PROGRAM_INSTRUCTIONS_ARB                         equ 088A0h
GL_MAX_PROGRAM_INSTRUCTIONS_ARB                     equ 088A1h
GL_PROGRAM_NATIVE_INSTRUCTIONS_ARB                  equ 088A2h
GL_MAX_PROGRAM_NATIVE_INSTRUCTIONS_ARB              equ 088A3h
GL_PROGRAM_TEMPORARIES_ARB                          equ 088A4h
GL_MAX_PROGRAM_TEMPORARIES_ARB                      equ 088A5h
GL_PROGRAM_NATIVE_TEMPORARIES_ARB                   equ 088A6h
GL_MAX_PROGRAM_NATIVE_TEMPORARIES_ARB               equ 088A7h
GL_PROGRAM_PARAMETERS_ARB                           equ 088A8h
GL_MAX_PROGRAM_PARAMETERS_ARB                       equ 088A9h
GL_PROGRAM_NATIVE_PARAMETERS_ARB                    equ 088AAh
GL_MAX_PROGRAM_NATIVE_PARAMETERS_ARB                equ 088ABh
GL_PROGRAM_ATTRIBS_ARB                              equ 088ACh
GL_MAX_PROGRAM_ATTRIBS_ARB                          equ 088ADh
GL_PROGRAM_NATIVE_ATTRIBS_ARB                       equ 088AEh
GL_MAX_PROGRAM_NATIVE_ATTRIBS_ARB                   equ 088AFh
GL_PROGRAM_ADDRESS_REGISTERS_ARB                    equ 088B0h
GL_MAX_PROGRAM_ADDRESS_REGISTERS_ARB                equ 088B1h
GL_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB             equ 088B2h
GL_MAX_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB         equ 088B3h
GL_MAX_PROGRAM_LOCAL_PARAMETERS_ARB                 equ 088B4h
GL_MAX_PROGRAM_ENV_PARAMETERS_ARB                   equ 088B5h
GL_PROGRAM_UNDER_NATIVE_LIMITS_ARB                  equ 088B6h
GL_PROGRAM_STRING_ARB                               equ 08628h
GL_PROGRAM_ERROR_POSITION_ARB                       equ 0864Bh
GL_CURRENT_MATRIX_ARB                               equ 08641h
GL_TRANSPOSE_CURRENT_MATRIX_ARB                     equ 088B7h
GL_CURRENT_MATRIX_STACK_DEPTH_ARB                   equ 08640h
GL_MAX_VERTEX_ATTRIBS_ARB                           equ 08869h
GL_MAX_PROGRAM_MATRICES_ARB                         equ 0862Fh
GL_MAX_PROGRAM_MATRIX_STACK_DEPTH_ARB               equ 0862Eh
GL_PROGRAM_ERROR_STRING_ARB                         equ 08874h
GL_MATRIX0_ARB                                      equ 088C0h
GL_MATRIX1_ARB                                      equ 088C1h
GL_MATRIX2_ARB                                      equ 088C2h
GL_MATRIX3_ARB                                      equ 088C3h
GL_MATRIX4_ARB                                      equ 088C4h
GL_MATRIX5_ARB                                      equ 088C5h
GL_MATRIX6_ARB                                      equ 088C6h
GL_MATRIX7_ARB                                      equ 088C7h
GL_MATRIX8_ARB                                      equ 088C8h
GL_MATRIX9_ARB                                      equ 088C9h
GL_MATRIX10_ARB                                     equ 088CAh
GL_MATRIX11_ARB                                     equ 088CBh
GL_MATRIX12_ARB                                     equ 088CCh
GL_MATRIX13_ARB                                     equ 088CDh
GL_MATRIX14_ARB                                     equ 088CEh
GL_MATRIX15_ARB                                     equ 088CFh
GL_MATRIX16_ARB                                     equ 088D0h
GL_MATRIX17_ARB                                     equ 088D1h
GL_MATRIX18_ARB                                     equ 088D2h
GL_MATRIX19_ARB                                     equ 088D3h
GL_MATRIX20_ARB                                     equ 088D4h
GL_MATRIX21_ARB                                     equ 088D5h
GL_MATRIX22_ARB                                     equ 088D6h
GL_MATRIX23_ARB                                     equ 088D7h
GL_MATRIX24_ARB                                     equ 088D8h
GL_MATRIX25_ARB                                     equ 088D9h
GL_MATRIX26_ARB                                     equ 088DAh
GL_MATRIX27_ARB                                     equ 088DBh
GL_MATRIX28_ARB                                     equ 088DCh
GL_MATRIX29_ARB                                     equ 088DDh
GL_MATRIX30_ARB                                     equ 088DEh
GL_MATRIX31_ARB                                     equ 088DFh

PFNGLVERTEXATTRIB1SARBPROC_proto typedef proto :dword , :dword 
PFNGLVERTEXATTRIB1SARBPROC typedef ptr PFNGLVERTEXATTRIB1SARBPROC_proto
PFNGLVERTEXATTRIB1FARBPROC_proto typedef proto :dword , :real4 
PFNGLVERTEXATTRIB1FARBPROC typedef ptr PFNGLVERTEXATTRIB1FARBPROC_proto
PFNGLVERTEXATTRIB1DARBPROC_proto typedef proto :dword , :real8 
PFNGLVERTEXATTRIB1DARBPROC typedef ptr PFNGLVERTEXATTRIB1DARBPROC_proto
PFNGLVERTEXATTRIB2SARBPROC_proto typedef proto :dword , :dword , :dword 
PFNGLVERTEXATTRIB2SARBPROC typedef ptr PFNGLVERTEXATTRIB2SARBPROC_proto
PFNGLVERTEXATTRIB2FARBPROC_proto typedef proto :dword , :real4 , :real4
PFNGLVERTEXATTRIB2FARBPROC typedef ptr PFNGLVERTEXATTRIB2FARBPROC_proto
PFNGLVERTEXATTRIB2DARBPROC_proto typedef proto :dword , :real8 , :real8 
PFNGLVERTEXATTRIB2DARBPROC typedef ptr PFNGLVERTEXATTRIB2DARBPROC_proto
PFNGLVERTEXATTRIB3SARBPROC_proto typedef proto :dword , :dword , :dword , :dword 
PFNGLVERTEXATTRIB3SARBPROC typedef ptr PFNGLVERTEXATTRIB3SARBPROC_proto
PFNGLVERTEXATTRIB3FARBPROC_proto typedef proto :dword , :real4 , :real4 , :real4 
PFNGLVERTEXATTRIB3FARBPROC typedef ptr PFNGLVERTEXATTRIB3FARBPROC_proto
PFNGLVERTEXATTRIB3DARBPROC_proto typedef proto :dword , :real8 , :real8 , :real8 
PFNGLVERTEXATTRIB3DARBPROC typedef ptr PFNGLVERTEXATTRIB3DARBPROC_proto
PFNGLVERTEXATTRIB4SARBPROC_proto typedef proto :dword , :dword , :dword , :dword , :dword 
PFNGLVERTEXATTRIB4SARBPROC typedef ptr PFNGLVERTEXATTRIB4SARBPROC_proto
PFNGLVERTEXATTRIB4FARBPROC_proto typedef proto :dword , :real4 , :real4 , :real4 , :real4 
PFNGLVERTEXATTRIB4FARBPROC typedef ptr PFNGLVERTEXATTRIB4FARBPROC_proto
PFNGLVERTEXATTRIB4DARBPROC_proto typedef proto :dword , :real8 , :real8 , :real8 , :real8 
PFNGLVERTEXATTRIB4DARBPROC typedef ptr PFNGLVERTEXATTRIB4DARBPROC_proto
PFNGLVERTEXATTRIB4NUBARBPROC_proto typedef proto :dword , :dword , :dword , :dword , :dword 
PFNGLVERTEXATTRIB4NUBARBPROC typedef ptr PFNGLVERTEXATTRIB4NUBARBPROC_proto
PFNGLVERTEXATTRIB1SVARBPROC_proto typedef proto :dword , :ptr dword 
PFNGLVERTEXATTRIB1SVARBPROC typedef ptr PFNGLVERTEXATTRIB1SVARBPROC_proto
PFNGLVERTEXATTRIB1FVARBPROC_proto typedef proto :dword , :ptr real4 
PFNGLVERTEXATTRIB1FVARBPROC typedef ptr PFNGLVERTEXATTRIB1FVARBPROC_proto
PFNGLVERTEXATTRIB1DVARBPROC_proto typedef proto :dword , :ptr real8
PFNGLVERTEXATTRIB1DVARBPROC typedef ptr PFNGLVERTEXATTRIB1DVARBPROC_proto
PFNGLVERTEXATTRIB2SVARBPROC_proto typedef proto :dword , :ptr dword 
PFNGLVERTEXATTRIB2SVARBPROC typedef ptr PFNGLVERTEXATTRIB2SVARBPROC_proto
PFNGLVERTEXATTRIB2FVARBPROC_proto typedef proto :dword , :ptr real4 
PFNGLVERTEXATTRIB2FVARBPROC typedef ptr PFNGLVERTEXATTRIB2FVARBPROC_proto
PFNGLVERTEXATTRIB2DVARBPROC_proto typedef proto :dword , :ptr real8 
PFNGLVERTEXATTRIB2DVARBPROC typedef ptr PFNGLVERTEXATTRIB2DVARBPROC_proto
PFNGLVERTEXATTRIB3SVARBPROC_proto typedef proto :dword , :ptr dword 
PFNGLVERTEXATTRIB3SVARBPROC typedef ptr PFNGLVERTEXATTRIB3SVARBPROC_proto
PFNGLVERTEXATTRIB3FVARBPROC_proto typedef proto :dword , :ptr real4 
PFNGLVERTEXATTRIB3FVARBPROC typedef ptr PFNGLVERTEXATTRIB3FVARBPROC_proto
PFNGLVERTEXATTRIB3DVARBPROC_proto typedef proto :dword , :ptr real8 
PFNGLVERTEXATTRIB3DVARBPROC typedef ptr PFNGLVERTEXATTRIB3DVARBPROC_proto
PFNGLVERTEXATTRIB4BVARBPROC_proto typedef proto :dword , :dword 
PFNGLVERTEXATTRIB4BVARBPROC typedef ptr PFNGLVERTEXATTRIB4BVARBPROC_proto
PFNGLVERTEXATTRIB4SVARBPROC_proto typedef proto :dword , :dword 
PFNGLVERTEXATTRIB4SVARBPROC typedef ptr PFNGLVERTEXATTRIB4SVARBPROC_proto
PFNGLVERTEXATTRIB4IVARBPROC_proto typedef proto :dword , :dword
PFNGLVERTEXATTRIB4IVARBPROC typedef ptr PFNGLVERTEXATTRIB4IVARBPROC_proto
PFNGLVERTEXATTRIB4UBVARBPROC_proto typedef proto :dword , :dword 
PFNGLVERTEXATTRIB4UBVARBPROC typedef ptr PFNGLVERTEXATTRIB4UBVARBPROC_proto
PFNGLVERTEXATTRIB4USVARBPROC_proto typedef proto :dword , :dword 
PFNGLVERTEXATTRIB4USVARBPROC typedef ptr PFNGLVERTEXATTRIB4USVARBPROC_proto
PFNGLVERTEXATTRIB4UIVARBPROC_proto typedef proto :dword , :dword 
PFNGLVERTEXATTRIB4UIVARBPROC typedef ptr PFNGLVERTEXATTRIB4UIVARBPROC_proto
PFNGLVERTEXATTRIB4FVARBPROC_proto typedef proto :dword , :ptr real4 
PFNGLVERTEXATTRIB4FVARBPROC typedef ptr PFNGLVERTEXATTRIB4FVARBPROC_proto
PFNGLVERTEXATTRIB4DVARBPROC_proto typedef proto :dword , :ptr real8
PFNGLVERTEXATTRIB4DVARBPROC typedef ptr PFNGLVERTEXATTRIB4DVARBPROC_proto
PFNGLVERTEXATTRIB4NBVARBPROC_proto typedef proto :dword , :dword 
PFNGLVERTEXATTRIB4NBVARBPROC typedef ptr PFNGLVERTEXATTRIB4NBVARBPROC_proto
PFNGLVERTEXATTRIB4NSVARBPROC_proto typedef proto :dword , :dword 
PFNGLVERTEXATTRIB4NSVARBPROC typedef ptr PFNGLVERTEXATTRIB4NSVARBPROC_proto
PFNGLVERTEXATTRIB4NIVARBPROC_proto typedef proto :dword , :dword 
PFNGLVERTEXATTRIB4NIVARBPROC typedef ptr PFNGLVERTEXATTRIB4NIVARBPROC_proto
PFNGLVERTEXATTRIB4NUBVARBPROC_proto typedef proto :dword , :dword 
PFNGLVERTEXATTRIB4NUBVARBPROC typedef ptr PFNGLVERTEXATTRIB4NUBVARBPROC_proto
PFNGLVERTEXATTRIB4NUSVARBPROC_proto typedef proto :dword , :dword 
PFNGLVERTEXATTRIB4NUSVARBPROC typedef ptr PFNGLVERTEXATTRIB4NUSVARBPROC_proto
PFNGLVERTEXATTRIB4NUIVARBPROC_proto typedef proto :dword , :dword 
PFNGLVERTEXATTRIB4NUIVARBPROC typedef ptr PFNGLVERTEXATTRIB4NUIVARBPROC_proto
PFNGLVERTEXATTRIBPOINTERARBPROC_proto typedef proto :dword , :dword , :dword , :dword , :dword , :dword 
PFNGLVERTEXATTRIBPOINTERARBPROC typedef ptr PFNGLVERTEXATTRIBPOINTERARBPROC_proto
PFNGLENABLEVERTEXATTRIBARRAYARBPROC_proto typedef proto :dword 
PFNGLENABLEVERTEXATTRIBARRAYARBPROC typedef ptr PFNGLENABLEVERTEXATTRIBARRAYARBPROC_proto
PFNGLDISABLEVERTEXATTRIBARRAYARBPROC_proto typedef proto :dword 
PFNGLDISABLEVERTEXATTRIBARRAYARBPROC typedef ptr PFNGLDISABLEVERTEXATTRIBARRAYARBPROC_proto
PFNGLPROGRAMSTRINGARBPROC_proto typedef proto :dword , :dword , :dword , :dword 
PFNGLPROGRAMSTRINGARBPROC typedef ptr PFNGLPROGRAMSTRINGARBPROC_proto
PFNGLBINDPROGRAMARBPROC_proto typedef proto :dword , :dword 
PFNGLBINDPROGRAMARBPROC typedef ptr PFNGLBINDPROGRAMARBPROC_proto
PFNGLDELETEPROGRAMSARBPROC_proto typedef proto :dword , :ptr dword 
PFNGLDELETEPROGRAMSARBPROC typedef ptr PFNGLDELETEPROGRAMSARBPROC_proto
PFNGLGENPROGRAMSARBPROC_proto typedef proto :dword , :ptr dword 
PFNGLGENPROGRAMSARBPROC typedef ptr PFNGLGENPROGRAMSARBPROC_proto
PFNGLPROGRAMENVPARAMETER4FARBPROC_proto typedef proto :dword , :dword , :real4, :real4 , :real4 , :real4 
PFNGLPROGRAMENVPARAMETER4FARBPROC typedef ptr PFNGLPROGRAMENVPARAMETER4FARBPROC_proto
PFNGLPROGRAMENVPARAMETER4DARBPROC_proto typedef proto :dword , :dword , :real8 , :real8 , :real8 , :real8
PFNGLPROGRAMENVPARAMETER4DARBPROC typedef ptr PFNGLPROGRAMENVPARAMETER4DARBPROC_proto
PFNGLPROGRAMENVPARAMETER4FVARBPROC_proto typedef proto :dword , :dword , :dword 
PFNGLPROGRAMENVPARAMETER4FVARBPROC typedef ptr PFNGLPROGRAMENVPARAMETER4FVARBPROC_proto
PFNGLPROGRAMENVPARAMETER4DVARBPROC_proto typedef proto :dword , :dword , :dword 
PFNGLPROGRAMENVPARAMETER4DVARBPROC typedef ptr PFNGLPROGRAMENVPARAMETER4DVARBPROC_proto
PFNGLPROGRAMLOCALPARAMETER4FARBPROC_proto typedef proto :dword , :dword , :real4, :real4 , :real4 , :real4 
PFNGLPROGRAMLOCALPARAMETER4FARBPROC typedef ptr PFNGLPROGRAMLOCALPARAMETER4FARBPROC_proto
PFNGLPROGRAMLOCALPARAMETER4DARBPROC_proto typedef proto :dword , :dword , :real8 , :real8 , :real8 , :real8
PFNGLPROGRAMLOCALPARAMETER4DARBPROC typedef ptr PFNGLPROGRAMLOCALPARAMETER4DARBPROC_proto
PFNGLPROGRAMLOCALPARAMETER4FVARBPROC_proto typedef proto :dword , :dword , :dword 
PFNGLPROGRAMLOCALPARAMETER4FVARBPROC typedef ptr PFNGLPROGRAMLOCALPARAMETER4FVARBPROC_proto
PFNGLPROGRAMLOCALPARAMETER4DVARBPROC_proto typedef proto :dword , :dword , :dword 
PFNGLPROGRAMLOCALPARAMETER4DVARBPROC typedef ptr PFNGLPROGRAMLOCALPARAMETER4DVARBPROC_proto
PFNGLGETPROGRAMENVPARAMETERFVARBPROC_proto typedef proto :dword , :dword , :dword 
PFNGLGETPROGRAMENVPARAMETERFVARBPROC typedef ptr PFNGLGETPROGRAMENVPARAMETERFVARBPROC_proto
PFNGLGETPROGRAMENVPARAMETERDVARBPROC_proto typedef proto :dword , :dword , :dword 
PFNGLGETPROGRAMENVPARAMETERDVARBPROC typedef ptr PFNGLGETPROGRAMENVPARAMETERDVARBPROC_proto
PFNGLGETPROGRAMLOCALPARAMETERFVARBPROC_proto typedef proto :dword , :dword , :dword 
PFNGLGETPROGRAMLOCALPARAMETERFVARBPROC typedef ptr PFNGLGETPROGRAMLOCALPARAMETERFVARBPROC_proto
PFNGLGETPROGRAMLOCALPARAMETERDVARBPROC_proto typedef proto :dword , :dword , :dword 
PFNGLGETPROGRAMLOCALPARAMETERDVARBPROC typedef ptr PFNGLGETPROGRAMLOCALPARAMETERDVARBPROC_proto
PFNGLGETPROGRAMIVARBPROC_proto typedef proto :dword , :dword , :ptr dword 
PFNGLGETPROGRAMIVARBPROC typedef ptr PFNGLGETPROGRAMIVARBPROC_proto
PFNGLGETPROGRAMSTRINGARBPROC_proto typedef proto :dword , :dword , :dword 
PFNGLGETPROGRAMSTRINGARBPROC typedef ptr PFNGLGETPROGRAMSTRINGARBPROC_proto
PFNGLGETVERTEXATTRIBDVARBPROC_proto typedef proto :dword , :dword , :dword 
PFNGLGETVERTEXATTRIBDVARBPROC typedef ptr PFNGLGETVERTEXATTRIBDVARBPROC_proto
PFNGLGETVERTEXATTRIBFVARBPROC_proto typedef proto :dword , :dword , :dword 
PFNGLGETVERTEXATTRIBFVARBPROC typedef ptr PFNGLGETVERTEXATTRIBFVARBPROC_proto
PFNGLGETVERTEXATTRIBIVARBPROC_proto typedef proto :dword , :dword , :dword 
PFNGLGETVERTEXATTRIBIVARBPROC typedef ptr PFNGLGETVERTEXATTRIBIVARBPROC_proto
PFNGLGETVERTEXATTRIBPOINTERVARBPROC_proto typedef proto :dword , :dword , :dword
PFNGLGETVERTEXATTRIBPOINTERVARBPROC typedef ptr PFNGLGETVERTEXATTRIBPOINTERVARBPROC_proto
PFNGLISPROGRAMARBPROC_proto typedef proto :dword 
PFNGLISPROGRAMARBPROC typedef ptr PFNGLISPROGRAMARBPROC_proto

endif ; GL_ARB_vertex_program

;
; GL_ARB_window_pos
;
;  Support:
;   Rage 128  * based : Supported
;   Radeon 7xxx based : Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_ARB_window_pos
GL_ARB_window_pos   equ 1

PFNGLWINDOWPOS2DARBPROC_proto typedef proto :real8 , :real8
PFNGLWINDOWPOS2DARBPROC typedef ptr PFNGLWINDOWPOS2DARBPROC_proto
PFNGLWINDOWPOS2FARBPROC_proto typedef proto :real4, :real4
PFNGLWINDOWPOS2FARBPROC typedef ptr PFNGLWINDOWPOS2FARBPROC_proto
PFNGLWINDOWPOS2IARBPROC_proto typedef proto :dword, :dword
PFNGLWINDOWPOS2IARBPROC typedef ptr PFNGLWINDOWPOS2IARBPROC_proto
PFNGLWINDOWPOS2SARBPROC_proto typedef proto :dword, :dword
PFNGLWINDOWPOS2SARBPROC typedef ptr PFNGLWINDOWPOS2SARBPROC_proto
PFNGLWINDOWPOS2IVARBPROC_proto typedef proto :dword
PFNGLWINDOWPOS2IVARBPROC typedef ptr PFNGLWINDOWPOS2IVARBPROC_proto
PFNGLWINDOWPOS2SVARBPROC_proto typedef proto :dword
PFNGLWINDOWPOS2SVARBPROC typedef ptr PFNGLWINDOWPOS2SVARBPROC_proto
PFNGLWINDOWPOS2FVARBPROC_proto typedef proto :dword
PFNGLWINDOWPOS2FVARBPROC typedef ptr PFNGLWINDOWPOS2FVARBPROC_proto
PFNGLWINDOWPOS2DVARBPROC_proto typedef proto :dword
PFNGLWINDOWPOS2DVARBPROC typedef ptr PFNGLWINDOWPOS2DVARBPROC_proto
PFNGLWINDOWPOS3IARBPROC_proto typedef proto :dword, :dword, :dword
PFNGLWINDOWPOS3IARBPROC typedef ptr PFNGLWINDOWPOS3IARBPROC_proto
PFNGLWINDOWPOS3SARBPROC_proto typedef proto :dword, :dword, :dword
PFNGLWINDOWPOS3SARBPROC typedef ptr PFNGLWINDOWPOS3SARBPROC_proto
PFNGLWINDOWPOS3FARBPROC_proto typedef proto :real4, :real4, :real4
PFNGLWINDOWPOS3FARBPROC typedef ptr PFNGLWINDOWPOS3FARBPROC_proto
PFNGLWINDOWPOS3DARBPROC_proto typedef proto :real8, :real8, :real8
PFNGLWINDOWPOS3DARBPROC typedef ptr PFNGLWINDOWPOS3DARBPROC_proto
PFNGLWINDOWPOS3IVARBPROC_proto typedef proto :dword
PFNGLWINDOWPOS3IVARBPROC typedef ptr PFNGLWINDOWPOS3IVARBPROC_proto
PFNGLWINDOWPOS3SVARBPROC_proto typedef proto :dword
PFNGLWINDOWPOS3SVARBPROC typedef ptr PFNGLWINDOWPOS3SVARBPROC_proto
PFNGLWINDOWPOS3FVARBPROC_proto typedef proto :dword
PFNGLWINDOWPOS3FVARBPROC typedef ptr PFNGLWINDOWPOS3FVARBPROC_proto
PFNGLWINDOWPOS3DVARBPROC_proto typedef proto :dword
PFNGLWINDOWPOS3DVARBPROC typedef ptr PFNGLWINDOWPOS3DVARBPROC_proto

endif ; GL_ARB_window_pos

;
; GL_ARB_depth_texture
;
; Support:
;   Rage 128 based    : Not Supported
;   Radeon 7xxx based : Not Supported
;   Radeon 8xxx based : Not Supported
;   Radeon 9xxx based : Supported
;

ifndef GL_ARB_depth_texture
GL_ARB_depth_texture            equ 1

GL_DEPTH_COMPONENT16_ARB        equ 081A5h
GL_DEPTH_COMPONENT24_ARB        equ 081A6h
GL_DEPTH_COMPONENT32_ARB        equ 081A7h

GL_TEXTURE_DEPTH_SIZE_ARB       equ 0884Ah
GL_DEPTH_TEXTURE_MODE_ARB       equ 0884Bh

endif ; GL_ARB_depth_texture

ifndef GL_ARB_shadow
GL_ARB_shadow                   equ 1

;
; GL_ARB_shadow
;
; Support:
;   Rage 128 based    : Not Supported
;   Radeon 7xxx based : Not Supported
;   Radeon 8xxx based : Not Supported
;   Radeon 9xxx based : Supported
;

GL_TEXTURE_COMPARE_MODE_ARB     equ 0884Ch
GL_TEXTURE_COMPARE_FUNC_ARB     equ 0884Dh
GL_COMPARE_R_TO_TEXTURE_ARB     equ 0884Eh

endif  ; GL_ARB_shadow

;
; GL_ARB_shadow_ambient
;
; Support:
;   Rage 128 based    : Not Supported
;   Radeon 7xxx based : Not Supported
;   Radeon 8xxx based : Not Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_ARB_shadow_ambient
GL_ARB_shadow_ambient             equ 1

GL_TEXTURE_COMPARE_FAIL_VALUE_ARB equ 080BFh

endif ; GL_ARB_shadow_ambient

;
;  ATI EXTENSIONS
;
;
; GL_ATI_envmap_bumpmap
;
; Support:
;   Rage 128 based     : Not Supported
;   Radeon 7xxx based  : Supported
;   Radeon 8xxx based  : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_ATI_envmap_bumpmap
GL_ATI_envmap_bumpmap       equ 1

GL_BUMP_ROT_MATRIX_ATI      equ 08775h
GL_BUMP_ROT_MATRIX_SIZE_ATI equ 08776h
GL_BUMP_NUM_TEX_UNITS_ATI   equ 08777h
GL_BUMP_TEX_UNITS_ATI       equ 08778h
GL_DUDV_ATI                 equ 08779h
GL_DU8DV8_ATI               equ 0877Ah
GL_BUMP_ENVMAP_ATI          equ 0877Bh
GL_BUMP_TARGET_ATI          equ 0877Ch

PFNGLTEXBUMPPARAMETERIVATIPROC_proto typedef proto :dword , :dword 
PFNGLTEXBUMPPARAMETERIVATIPROC typedef ptr PFNGLTEXBUMPPARAMETERIVATIPROC_proto
PFNGLTEXBUMPPARAMETERFVATIPROC_proto typedef proto :dword , :dword 
PFNGLTEXBUMPPARAMETERFVATIPROC typedef ptr PFNGLTEXBUMPPARAMETERFVATIPROC_proto
PFNGLGETTEXBUMPPARAMETERIVATIPROC_proto typedef proto :dword , :dword 
PFNGLGETTEXBUMPPARAMETERIVATIPROC typedef ptr PFNGLGETTEXBUMPPARAMETERIVATIPROC_proto
PFNGLGETTEXBUMPPARAMETERFVATIPROC_proto typedef proto :dword , :dword 
PFNGLGETTEXBUMPPARAMETERFVATIPROC typedef ptr PFNGLGETTEXBUMPPARAMETERFVATIPROC_proto


endif ; GL_ATI_envmap_bumpmap


;
; GL_ATI_fragment_shader
;
; Support:
;   Rage 128 based     : Not Supported
;   Radeon 7xxx based  : Not Supported
;   Radeon 8xxx based  : Supported
;   Radeon 9xxx based  : Supported
;
ifndef GL_ATI_fragment_shader
GL_ATI_fragment_shader                   equ 1

GL_FRAGMENT_SHADER_ATI                   equ 08920h
GL_REG_0_ATI                             equ 08921h
GL_REG_1_ATI                             equ 08922h
GL_REG_2_ATI                             equ 08923h
GL_REG_3_ATI                             equ 08924h
GL_REG_4_ATI                             equ 08925h
GL_REG_5_ATI                             equ 08926h
GL_REG_6_ATI                             equ 08927h
GL_REG_7_ATI                             equ 08928h
GL_REG_8_ATI                             equ 08929h
GL_REG_9_ATI                             equ 0892Ah
GL_REG_10_ATI                            equ 0892Bh
GL_REG_11_ATI                            equ 0892Ch
GL_REG_12_ATI                            equ 0892Dh
GL_REG_13_ATI                            equ 0892Eh
GL_REG_14_ATI                            equ 0892Fh
GL_REG_15_ATI                            equ 08930h
GL_REG_16_ATI                            equ 08931h
GL_REG_17_ATI                            equ 08932h
GL_REG_18_ATI                            equ 08933h
GL_REG_19_ATI                            equ 08934h
GL_REG_20_ATI                            equ 08935h
GL_REG_21_ATI                            equ 08936h
GL_REG_22_ATI                            equ 08937h
GL_REG_23_ATI                            equ 08938h
GL_REG_24_ATI                            equ 08939h
GL_REG_25_ATI                            equ 0893Ah
GL_REG_26_ATI                            equ 0893Bh
GL_REG_27_ATI                            equ 0893Ch
GL_REG_28_ATI                            equ 0893Dh
GL_REG_29_ATI                            equ 0893Eh
GL_REG_30_ATI                            equ 0893Fh
GL_REG_31_ATI                            equ 08940h
GL_CON_0_ATI                             equ 08941h
GL_CON_1_ATI                             equ 08942h
GL_CON_2_ATI                             equ 08943h
GL_CON_3_ATI                             equ 08944h
GL_CON_4_ATI                             equ 08945h
GL_CON_5_ATI                             equ 08946h
GL_CON_6_ATI                             equ 08947h
GL_CON_7_ATI                             equ 08948h
GL_CON_8_ATI                             equ 08949h
GL_CON_9_ATI                             equ 0894Ah
GL_CON_10_ATI                            equ 0894Bh
GL_CON_11_ATI                            equ 0894Ch
GL_CON_12_ATI                            equ 0894Dh
GL_CON_13_ATI                            equ 0894Eh
GL_CON_14_ATI                            equ 0894Fh
GL_CON_15_ATI                            equ 08950h
GL_CON_16_ATI                            equ 08951h
GL_CON_17_ATI                            equ 08952h
GL_CON_18_ATI                            equ 08953h
GL_CON_19_ATI                            equ 08954h
GL_CON_20_ATI                            equ 08955h
GL_CON_21_ATI                            equ 08956h
GL_CON_22_ATI                            equ 08957h
GL_CON_23_ATI                            equ 08958h
GL_CON_24_ATI                            equ 08959h
GL_CON_25_ATI                            equ 0895Ah
GL_CON_26_ATI                            equ 0895Bh
GL_CON_27_ATI                            equ 0895Ch
GL_CON_28_ATI                            equ 0895Dh
GL_CON_29_ATI                            equ 0895Eh
GL_CON_30_ATI                            equ 0895Fh
GL_CON_31_ATI                            equ 08960h
GL_MOV_ATI                               equ 08961h
GL_ADD_ATI                               equ 08963h
GL_MUL_ATI                               equ 08964h
GL_SUB_ATI                               equ 08965h
GL_DOT3_ATI                              equ 08966h
GL_DOT4_ATI                              equ 08967h
GL_MAD_ATI                               equ 08968h
GL_LERP_ATI                              equ 08969h
GL_CND_ATI                               equ 0896Ah
GL_CND0_ATI                              equ 0896Bh
GL_DOT2_ADD_ATI                          equ 0896Ch
GL_SECONDARY_INTERPOLATOR_ATI            equ 0896Dh
GL_NUM_FRAGMENT_REGISTERS_ATI            equ 0896Eh
GL_NUM_FRAGMENT_CONSTANTS_ATI            equ 0896Fh
GL_NUM_PASSES_ATI                        equ 08970h
GL_NUM_INSTRUCTIONS_PER_PASS_ATI         equ 08971h
GL_NUM_INSTRUCTIONS_TOTAL_ATI            equ 08972h
GL_NUM_INPUT_INTERPOLATOR_COMPONENTS_ATI equ 08973h
GL_NUM_LOOPBACK_COMPONENTS_ATI           equ 08974h
GL_COLOR_ALPHA_PAIRING_ATI               equ 08975h
GL_SWIZZLE_STR_ATI                       equ 08976h
GL_SWIZZLE_STQ_ATI                       equ 08977h
GL_SWIZZLE_STR_DR_ATI                    equ 08978h
GL_SWIZZLE_STQ_DQ_ATI                    equ 08979h
GL_SWIZZLE_STRQ_ATI                      equ 0897Ah
GL_SWIZZLE_STRQ_DQ_ATI                   equ 0897Bh
GL_RED_BIT_ATI                           equ 000000001h
GL_GREEN_BIT_ATI                         equ 000000002h
GL_BLUE_BIT_ATI                          equ 000000004h
GL_2X_BIT_ATI                            equ 000000001h
GL_4X_BIT_ATI                            equ 000000002h
GL_8X_BIT_ATI                            equ 000000004h
GL_HALF_BIT_ATI                          equ 000000008h
GL_QUARTER_BIT_ATI                       equ 000000010h
GL_EIGHTH_BIT_ATI                        equ 000000020h
GL_SATURATE_BIT_ATI                      equ 000000040h
GL_COMP_BIT_ATI                          equ 000000002h
GL_NEGATE_BIT_ATI                        equ 000000004h
GL_BIAS_BIT_ATI                          equ 000000008h


PFNGLGENFRAGMENTSHADERSATIPROC_proto typedef proto :dword
PFNGLGENFRAGMENTSHADERSATIPROC typedef ptr PFNGLGENFRAGMENTSHADERSATIPROC_proto
PFNGLBINDFRAGMENTSHADERATIPROC_proto typedef proto :dword 
PFNGLBINDFRAGMENTSHADERATIPROC typedef ptr PFNGLBINDFRAGMENTSHADERATIPROC_proto
PFNGLDELETEFRAGMENTSHADERATIPROC_proto typedef proto :dword 
PFNGLDELETEFRAGMENTSHADERATIPROC typedef ptr PFNGLDELETEFRAGMENTSHADERATIPROC_proto
PFNGLBEGINFRAGMENTSHADERATIPROC_proto typedef proto
PFNGLBEGINFRAGMENTSHADERATIPROC typedef ptr PFNGLBEGINFRAGMENTSHADERATIPROC_proto
PFNGLENDFRAGMENTSHADERATIPROC_proto typedef proto
PFNGLENDFRAGMENTSHADERATIPROC typedef ptr PFNGLENDFRAGMENTSHADERATIPROC_proto
PFNGLPASSTEXCOORDATIPROC_proto typedef proto :dword , :dword , :dword 
PFNGLPASSTEXCOORDATIPROC typedef ptr PFNGLPASSTEXCOORDATIPROC_proto
PFNGLSAMPLEMAPATIPROC_proto typedef proto :dword , :dword , :dword 
PFNGLSAMPLEMAPATIPROC typedef ptr PFNGLSAMPLEMAPATIPROC_proto
PFNGLCOLORFRAGMENTOP1ATIPROC_proto typedef proto :dword , :dword , :dword , :dword , :dword , :dword , :dword 
PFNGLCOLORFRAGMENTOP1ATIPROC typedef ptr PFNGLCOLORFRAGMENTOP1ATIPROC_proto
PFNGLCOLORFRAGMENTOP2ATIPROC_proto typedef proto :dword , :dword , :dword , :dword , :dword , :dword , :dword , :dword , :dword , :dword 
PFNGLCOLORFRAGMENTOP2ATIPROC typedef ptr PFNGLCOLORFRAGMENTOP2ATIPROC_proto
PFNGLCOLORFRAGMENTOP3ATIPROC_proto typedef proto :dword , :dword , :dword , :dword , :dword , :dword , :dword , :dword , :dword , :dword , :dword , :dword , :dword 
PFNGLCOLORFRAGMENTOP3ATIPROC typedef ptr PFNGLCOLORFRAGMENTOP3ATIPROC_proto
PFNGLALPHAFRAGMENTOP1ATIPROC_proto typedef proto :dword , :dword , :dword , :dword , :dword , :dword 
PFNGLALPHAFRAGMENTOP1ATIPROC typedef ptr PFNGLALPHAFRAGMENTOP1ATIPROC_proto
PFNGLALPHAFRAGMENTOP2ATIPROC_proto typedef proto :dword , :dword , :dword , :dword , :dword , :dword , :dword , :dword , :dword  
PFNGLALPHAFRAGMENTOP2ATIPROC typedef ptr PFNGLALPHAFRAGMENTOP2ATIPROC_proto
PFNGLALPHAFRAGMENTOP3ATIPROC_proto typedef proto :dword , :dword , :dword , :dword , :dword , :dword , :dword , :dword , :dword , :dword , :dword , :dword 
PFNGLALPHAFRAGMENTOP3ATIPROC typedef ptr PFNGLALPHAFRAGMENTOP3ATIPROC_proto
PFNGLSETFRAGMENTSHADERCONSTANTATIPROC_proto typedef proto :dword, :dword
PFNGLSETFRAGMENTSHADERCONSTANTATIPROC typedef ptr PFNGLSETFRAGMENTSHADERCONSTANTATIPROC_proto

endif ; GL_ATI_fragment_shader

;
; GL_ARB_fragment_program
;
; Support:
;   Rage 128 based     : Not Supported
;   Radeon 7xxx based  : Not Supported
;   Radeon 8xxx based  : Not Supported
;   Radeon 9xxx based  : Supported
;
ifndef GL_ARB_fragment_program
GL_ARB_fragment_program                    equ 1

GL_FRAGMENT_PROGRAM_ARB                    equ 08804h
GL_PROGRAM_ALU_INSTRUCTIONS_ARB            equ 08805h
GL_PROGRAM_TEX_INSTRUCTIONS_ARB            equ 08806h
GL_PROGRAM_TEX_INDIRECTIONS_ARB            equ 08807h
GL_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB     equ 08808h
GL_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB     equ 08809h
GL_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB     equ 0880Ah
GL_MAX_PROGRAM_ALU_INSTRUCTIONS_ARB        equ 0880Bh
GL_MAX_PROGRAM_TEX_INSTRUCTIONS_ARB        equ 0880Ch
GL_MAX_PROGRAM_TEX_INDIRECTIONS_ARB        equ 0880Dh
GL_MAX_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB equ 0880Eh
GL_MAX_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB equ 0880Fh
GL_MAX_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB equ 08810h
GL_MAX_TEXTURE_COORDS_ARB                  equ 08871h
GL_MAX_TEXTURE_IMAGE_UNITS_ARB             equ 08872h

endif ; GL_ARB_fragment_program

;
; GL_ARB_fragment_program_shadow
;
; Support:
;   Rage 128 based     : Not Supported
;   Radeon 7xxx based  : Not Supported
;   Radeon 8xxx based  : Not Supported
;   Radeon 9xxx based  : Supported
;
ifndef GL_ARB_fragment_program_shadow
GL_ARB_fragment_program_shadow equ 1
endif ; GL_ARB_fragment_program_shadow

;
; GL_ATI_pn_triangles
;
; Support
;   Rage 128 based     : Not Supported
;   Radeon 7xxx based  : Not Supported
;   Radeon 8xxx based  : Supported
;   Radeon 9xxx based  : Supported
;
ifndef GL_ATI_pn_triangles
GL_ATI_pn_triangles                       equ 1

GL_PN_TRIANGLES_ATI                       equ 087F0h
GL_MAX_PN_TRIANGLES_TESSELATION_LEVEL_ATI equ 087F1h
GL_PN_TRIANGLES_POINT_MODE_ATI            equ 087F2h
GL_PN_TRIANGLES_NORMAL_MODE_ATI           equ 087F3h
GL_PN_TRIANGLES_TESSELATION_LEVEL_ATI     equ 087F4h
GL_PN_TRIANGLES_POINT_MODE_LINEAR_ATI     equ 087F5h
GL_PN_TRIANGLES_POINT_MODE_CUBIC_ATI      equ 087F6h
GL_PN_TRIANGLES_NORMAL_MODE_LINEAR_ATI    equ 087F7h
GL_PN_TRIANGLES_NORMAL_MODE_QUADRATIC_ATI equ 087F8h

PFNGLPNTRIANGLESIATIPROC_proto typedef proto :dword , :dword 
PFNGLPNTRIANGLESIATIPROC typedef ptr PFNGLPNTRIANGLESIATIPROC_proto
PFNGLPNTRIANGLESFATIPROC_proto typedef proto :dword , :dword 
PFNGLPNTRIANGLESFATIPROC typedef ptr PFNGLPNTRIANGLESFATIPROC_proto

endif ; GL_ATI_pn_triangles

;
; GL_ATI_separate_stencil
;
; Support
;   Rage 128 based    : Not Supported
;   Radeon 7xxx based : Not Supported
;   Radeon 8xxx based : Not Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_ATI_separate_stencil
GL_ATI_separate_stencil                     equ 1

GL_STENCIL_BACK_FUNC_ATI                    equ 08800h
GL_STENCIL_BACK_FAIL_ATI                    equ 08801h
GL_STENCIL_BACK_PASS_DEPTH_FAIL_ATI         equ 08802h
GL_STENCIL_BACK_PASS_DEPTH_PASS_ATI         equ 08803h

PFNGLSTENCILOPSEPARATEATIPROC_proto typedef proto :dword , :dword , :dword , :dword 
PFNGLSTENCILOPSEPARATEATIPROC typedef ptr PFNGLSTENCILOPSEPARATEATIPROC_proto
PFNGLSTENCILFUNCSEPARATEATIPROC_proto typedef proto :dword , :dword , :dword , :dword 
PFNGLSTENCILFUNCSEPARATEATIPROC typedef ptr PFNGLSTENCILFUNCSEPARATEATIPROC_proto

endif ; GL_ATI_separate_stencil

;
; GL_ATI_texture_compression_3dc
;
;  Support:
;   Rage 128 based    : Not Supported
;   Radeon 7xxx based : Not Supported
;   Radeon 8xxx based : Not Supported
;   Radeon 9xxx based : Not Supported
;   Radeon X800 based : Supported
;
ifndef GL_ATI_texture_compression_3dc
GL_ATI_texture_compression_3dc equ 1

GL_COMPRESSED_LUMINANCE_ALPHA_3DC_ATI equ 08837h

endif ; GL_ATI_texture_compression_3dc

;
; GL_ATI_texture_mirror_once
;
;  Support:
;   Rage 128 based    : Supported
;   Radeon 7xxx based : Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_ATI_texture_mirror_once
GL_ATI_texture_mirror_once  equ 1

GL_MIRROR_CLAMP_ATI         equ 08742h
GL_MIRROR_CLAMP_TO_EDGE_ATI equ 08743h

endif ; GL_ATI_texture_mirror_once

;
; GL_ATI_vertex_streams
;
;  Support:
;   Rage 128 based    : Supported
;   Radeon 7xxx based : Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_ATI_vertex_streams
GL_ATI_vertex_streams                                   equ 1

GL_MAX_VERTEX_STREAMS_ATI                               equ 0876Bh
GL_VERTEX_SOURCE_ATI                                    equ 0876Ch
GL_VERTEX_STREAM0_ATI                                   equ 0876Dh
GL_VERTEX_STREAM1_ATI                                   equ 0876Eh
GL_VERTEX_STREAM2_ATI                                   equ 0876Fh
GL_VERTEX_STREAM3_ATI                                   equ 08770h
GL_VERTEX_STREAM4_ATI                                   equ 08771h
GL_VERTEX_STREAM5_ATI                                   equ 08772h
GL_VERTEX_STREAM6_ATI                                   equ 08773h
GL_VERTEX_STREAM7_ATI                                   equ 08774h

PFNGLCLIENTACTIVEVERTEXSTREAMATIPROC_proto typedef proto :dword 
PFNGLCLIENTACTIVEVERTEXSTREAMATIPROC typedef ptr PFNGLCLIENTACTIVEVERTEXSTREAMATIPROC_proto
PFNGLVERTEXBLENDENVIATIPROC_proto typedef proto :dword , :dword 
PFNGLVERTEXBLENDENVIATIPROC typedef ptr PFNGLVERTEXBLENDENVIATIPROC_proto
PFNGLVERTEXBLENDENVFATIPROC_proto typedef proto :dword , :dword 
PFNGLVERTEXBLENDENVFATIPROC typedef ptr PFNGLVERTEXBLENDENVFATIPROC_proto
PFNGLVERTEXSTREAM2SATIPROC_proto typedef proto :dword , :dword , :dword 
PFNGLVERTEXSTREAM2SATIPROC typedef ptr PFNGLVERTEXSTREAM2SATIPROC_proto
PFNGLVERTEXSTREAM2SVATIPROC_proto typedef proto :dword , :dword 
PFNGLVERTEXSTREAM2SVATIPROC typedef ptr PFNGLVERTEXSTREAM2SVATIPROC_proto
PFNGLVERTEXSTREAM2IATIPROC_proto typedef proto :dword , :dword , :dword 
PFNGLVERTEXSTREAM2IATIPROC typedef ptr PFNGLVERTEXSTREAM2IATIPROC_proto
PFNGLVERTEXSTREAM2IVATIPROC_proto typedef proto :dword , :dword 
PFNGLVERTEXSTREAM2IVATIPROC typedef ptr PFNGLVERTEXSTREAM2IVATIPROC_proto
PFNGLVERTEXSTREAM2FATIPROC_proto typedef proto :dword , :real4, :real4
PFNGLVERTEXSTREAM2FATIPROC typedef ptr PFNGLVERTEXSTREAM2FATIPROC_proto
PFNGLVERTEXSTREAM2FVATIPROC_proto typedef proto :dword , :dword 
PFNGLVERTEXSTREAM2FVATIPROC typedef ptr PFNGLVERTEXSTREAM2FVATIPROC_proto
PFNGLVERTEXSTREAM2DATIPROC_proto typedef proto :dword , :real8 , :real8
PFNGLVERTEXSTREAM2DATIPROC typedef ptr PFNGLVERTEXSTREAM2DATIPROC_proto
PFNGLVERTEXSTREAM2DVATIPROC_proto typedef proto :dword , :dword 
PFNGLVERTEXSTREAM2DVATIPROC typedef ptr PFNGLVERTEXSTREAM2DVATIPROC_proto
PFNGLVERTEXSTREAM3SATIPROC_proto typedef proto :dword , :dword , :dword , :dword 
PFNGLVERTEXSTREAM3SATIPROC typedef ptr PFNGLVERTEXSTREAM3SATIPROC_proto
PFNGLVERTEXSTREAM3SVATIPROC_proto typedef proto :dword , :dword 
PFNGLVERTEXSTREAM3SVATIPROC typedef ptr PFNGLVERTEXSTREAM3SVATIPROC_proto
PFNGLVERTEXSTREAM3IATIPROC_proto typedef proto :dword , :dword , :dword , :dword 
PFNGLVERTEXSTREAM3IATIPROC typedef ptr PFNGLVERTEXSTREAM3IATIPROC_proto
PFNGLVERTEXSTREAM3IVATIPROC_proto typedef proto :dword , :dword 
PFNGLVERTEXSTREAM3IVATIPROC typedef ptr PFNGLVERTEXSTREAM3IVATIPROC_proto
PFNGLVERTEXSTREAM3FATIPROC_proto typedef proto :dword , :real4, :real4 , :real4 
PFNGLVERTEXSTREAM3FATIPROC typedef ptr PFNGLVERTEXSTREAM3FATIPROC_proto
PFNGLVERTEXSTREAM3FVATIPROC_proto typedef proto :dword , :dword 
PFNGLVERTEXSTREAM3FVATIPROC typedef ptr PFNGLVERTEXSTREAM3FVATIPROC_proto
PFNGLVERTEXSTREAM3DATIPROC_proto typedef proto :dword , :real8 , :real8 , :real8
PFNGLVERTEXSTREAM3DATIPROC typedef ptr PFNGLVERTEXSTREAM3DATIPROC_proto
PFNGLVERTEXSTREAM3DVATIPROC_proto typedef proto :dword , :dword 
PFNGLVERTEXSTREAM3DVATIPROC typedef ptr PFNGLVERTEXSTREAM3DVATIPROC_proto
PFNGLVERTEXSTREAM4SATIPROC_proto typedef proto :dword , :dword , :dword , :dword , :dword 
PFNGLVERTEXSTREAM4SATIPROC typedef ptr PFNGLVERTEXSTREAM4SATIPROC_proto
PFNGLVERTEXSTREAM4SVATIPROC_proto typedef proto :dword , :dword 
PFNGLVERTEXSTREAM4SVATIPROC typedef ptr PFNGLVERTEXSTREAM4SVATIPROC_proto
PFNGLVERTEXSTREAM4IATIPROC_proto typedef proto :dword , :dword , :dword , :dword , :dword 
PFNGLVERTEXSTREAM4IATIPROC typedef ptr PFNGLVERTEXSTREAM4IATIPROC_proto
PFNGLVERTEXSTREAM4IVATIPROC_proto typedef proto :dword , :dword 
PFNGLVERTEXSTREAM4IVATIPROC typedef ptr PFNGLVERTEXSTREAM4IVATIPROC_proto
PFNGLVERTEXSTREAM4FATIPROC_proto typedef proto :dword , :real4, :real4 , :real4 , :real4 
PFNGLVERTEXSTREAM4FATIPROC typedef ptr PFNGLVERTEXSTREAM4FATIPROC_proto
PFNGLVERTEXSTREAM4FVATIPROC_proto typedef proto :dword , :dword 
PFNGLVERTEXSTREAM4FVATIPROC typedef ptr PFNGLVERTEXSTREAM4FVATIPROC_proto
PFNGLVERTEXSTREAM4DATIPROC_proto typedef proto :dword , :real8 , :real8 , :real8 , :real8
PFNGLVERTEXSTREAM4DATIPROC typedef ptr PFNGLVERTEXSTREAM4DATIPROC_proto
PFNGLVERTEXSTREAM4DVATIPROC_proto typedef proto :dword , :dword 
PFNGLVERTEXSTREAM4DVATIPROC typedef ptr PFNGLVERTEXSTREAM4DVATIPROC_proto
PFNGLNORMALSTREAM3BATIPROC_proto typedef proto :dword , :dword , :dword , :dword 
PFNGLNORMALSTREAM3BATIPROC typedef ptr PFNGLNORMALSTREAM3BATIPROC_proto
PFNGLNORMALSTREAM3BVATIPROC_proto typedef proto :dword , :dword 
PFNGLNORMALSTREAM3BVATIPROC typedef ptr PFNGLNORMALSTREAM3BVATIPROC_proto
PFNGLNORMALSTREAM3SATIPROC_proto typedef proto :dword , :dword , :dword , :dword 
PFNGLNORMALSTREAM3SATIPROC typedef ptr PFNGLNORMALSTREAM3SATIPROC_proto
PFNGLNORMALSTREAM3SVATIPROC_proto typedef proto :dword , :dword 
PFNGLNORMALSTREAM3SVATIPROC typedef ptr PFNGLNORMALSTREAM3SVATIPROC_proto
PFNGLNORMALSTREAM3IATIPROC_proto typedef proto :dword , :dword , :dword , :dword 
PFNGLNORMALSTREAM3IATIPROC typedef ptr PFNGLNORMALSTREAM3IATIPROC_proto
PFNGLNORMALSTREAM3IVATIPROC_proto typedef proto :dword , :dword 
PFNGLNORMALSTREAM3IVATIPROC typedef ptr PFNGLNORMALSTREAM3IVATIPROC_proto
PFNGLNORMALSTREAM3FATIPROC_proto typedef proto :dword , :real4 , :real4 , :real4
PFNGLNORMALSTREAM3FATIPROC typedef ptr PFNGLNORMALSTREAM3FATIPROC_proto
PFNGLNORMALSTREAM3FVATIPROC_proto typedef proto :dword , :dword 
PFNGLNORMALSTREAM3FVATIPROC typedef ptr PFNGLNORMALSTREAM3FVATIPROC_proto
PFNGLNORMALSTREAM3DATIPROC_proto typedef proto :dword , :real8, :real8 , :real8 
PFNGLNORMALSTREAM3DATIPROC typedef ptr PFNGLNORMALSTREAM3DATIPROC_proto
PFNGLNORMALSTREAM3DVATIPROC_proto typedef proto :dword , :dword 
PFNGLNORMALSTREAM3DVATIPROC typedef ptr PFNGLNORMALSTREAM3DVATIPROC_proto

endif ; GL_ATI_vertex_streams

;
; GL_ATI_point_cull_mode
;
;  Support:
;   Rage 128 based    : Not Supported
;   Radeon 7xxx based : Not Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_ATI_point_cull_mode
GL_ATI_point_cull_mode                      equ 1

GL_POINT_CULL_MODE_ATI                      equ 060b3h
GL_POINT_CULL_CENTER_ATI                    equ 060b4h
GL_POINT_CLIP_ATI                           equ 060b5h

endif ; GL_ATI_point_cull_mode

;
; GL_ATI_vertex_array_object
;
; Support:
;   Rage 128 based    : Not Supported
;   Radeon 7xxx based : Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_ATI_vertex_array_object
GL_ATI_vertex_array_object              equ 1

GL_STATIC_ATI                           equ 08760h
GL_DYNAMIC_ATI                          equ 08761h
GL_PRESERVE_ATI                         equ 08762h
GL_DISCARD_ATI                          equ 08763h

GL_OBJECT_BUFFER_SIZE_ATI               equ 08764h
GL_OBJECT_BUFFER_USAGE_ATI              equ 08765h
GL_ARRAY_OBJECT_BUFFER_ATI              equ 08766h
GL_ARRAY_OBJECT_OFFSET_ATI              equ 08767h

PFNGLNEWOBJECTBUFFERATIPROC_proto typedef proto :dword , :dword , :dword 
PFNGLNEWOBJECTBUFFERATIPROC typedef ptr PFNGLNEWOBJECTBUFFERATIPROC_proto
PFNGLISOBJECTBUFFERATIPROC_proto typedef proto :dword 
PFNGLISOBJECTBUFFERATIPROC typedef ptr PFNGLISOBJECTBUFFERATIPROC_proto
PFNGLUPDATEOBJECTBUFFERATIPROC_proto typedef proto :dword , :dword , :dword , :dword , :dword 
PFNGLUPDATEOBJECTBUFFERATIPROC typedef ptr PFNGLUPDATEOBJECTBUFFERATIPROC_proto
PFNGLGETOBJECTBUFFERFVATIPROC_proto typedef proto :dword , :dword , :dword 
PFNGLGETOBJECTBUFFERFVATIPROC typedef ptr PFNGLGETOBJECTBUFFERFVATIPROC_proto
PFNGLGETOBJECTBUFFERIVATIPROC_proto typedef proto :dword , :dword , :dword 
PFNGLGETOBJECTBUFFERIVATIPROC typedef ptr PFNGLGETOBJECTBUFFERIVATIPROC_proto
PFNGLFREEOBJECTBUFFERATIPROC_proto typedef proto :dword 
PFNGLFREEOBJECTBUFFERATIPROC typedef ptr PFNGLFREEOBJECTBUFFERATIPROC_proto
PFNGLARRAYOBJECTATIPROC_proto typedef proto :dword , :dword , :dword , :dword , :dword , :dword 
PFNGLARRAYOBJECTATIPROC typedef ptr PFNGLARRAYOBJECTATIPROC_proto
PFNGLGETARRAYOBJECTFVATIPROC_proto typedef proto :dword , :dword , :dword 
PFNGLGETARRAYOBJECTFVATIPROC typedef ptr PFNGLGETARRAYOBJECTFVATIPROC_proto
PFNGLGETARRAYOBJECTIVATIPROC_proto typedef proto :dword , :dword , :dword 
PFNGLGETARRAYOBJECTIVATIPROC typedef ptr PFNGLGETARRAYOBJECTIVATIPROC_proto
PFNGLVARIANTARRAYOBJECTATIPROC_proto typedef proto :dword , :dword , :dword , :dword , :dword 
PFNGLVARIANTARRAYOBJECTATIPROC typedef ptr PFNGLVARIANTARRAYOBJECTATIPROC_proto
PFNGLGETVARIANTARRAYOBJECTFVATIPROC_proto typedef proto :dword , :dword , :dword 
PFNGLGETVARIANTARRAYOBJECTFVATIPROC typedef ptr PFNGLGETVARIANTARRAYOBJECTFVATIPROC_proto
PFNGLGETVARIANTARRAYOBJECTIVATIPROC_proto typedef proto :dword , :dword , :dword 
PFNGLGETVARIANTARRAYOBJECTIVATIPROC typedef ptr PFNGLGETVARIANTARRAYOBJECTIVATIPROC_proto

endif  ; GL_ATI_vertex_array_object

;
; GL_ATI_element_array
;
; Support:
;   Rage 128 based    : Not Supported
;   Radeon 7xxx based : Not Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_ATI_element_array
GL_ATI_element_array            equ 1

GL_ELEMENT_ARRAY_ATI            equ 08768h

GL_ELEMENT_ARRAY_TYPE_ATI       equ 08769h
GL_ELEMENT_ARRAY_POINTER_ATI    equ 0876Ah

PFNGLELEMENTPOINTERATIPROC_proto typedef proto :dword , :dword 
PFNGLELEMENTPOINTERATIPROC typedef ptr PFNGLELEMENTPOINTERATIPROC_proto
PFNGLDRAWELEMENTARRAYATIPROC_proto typedef proto :dword , :dword 
PFNGLDRAWELEMENTARRAYATIPROC typedef ptr PFNGLDRAWELEMENTARRAYATIPROC_proto
PFNGLDRAWRANGEELEMENTARRAYATIPROC_proto typedef proto :dword , :dword , :dword , :dword 
PFNGLDRAWRANGEELEMENTARRAYATIPROC typedef ptr PFNGLDRAWRANGEELEMENTARRAYATIPROC_proto

endif ; GL_ATI_element_array

;
; GL_ATI_map_object_buffer
;
; Support:
;   Rage 128 based    : Not Supported
;   Radeon 7xxx based : Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_ATI_map_object_buffer
GL_ATI_map_object_buffer                equ 1

PFNGLMAPOBJECTBUFFERATIPROC_proto typedef proto :dword
PFNGLMAPOBJECTBUFFERATIPROC typedef ptr PFNGLMAPOBJECTBUFFERATIPROC_proto
PFNGLUNMAPOBJECTBUFFERATIPROC_proto typedef proto :dword
PFNGLUNMAPOBJECTBUFFERATIPROC typedef ptr PFNGLUNMAPOBJECTBUFFERATIPROC_proto

endif ; GL_ATI_map_object_buffer

;
; GL_ATI_vertex_attrib_array_object
;
; Support:
;   Rage 128 based    : Not Supported
;   Radeon 7xxx based : Not Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_ATI_vertex_attrib_array_object
GL_ATI_vertex_attrib_array_object equ 1

PFNGLVERTEXATTRIBARRAYOBJECTATIPROC_proto typedef proto :dword , :dword , :dword , :dword , :dword , :dword , :dword 
PFNGLVERTEXATTRIBARRAYOBJECTATIPROC typedef ptr PFNGLVERTEXATTRIBARRAYOBJECTATIPROC_proto
PFNGLGETVERTEXATTRIBARRAYOBJECTFVATIPROC_proto typedef proto :dword , :dword , :dword 
PFNGLGETVERTEXATTRIBARRAYOBJECTFVATIPROC typedef ptr PFNGLGETVERTEXATTRIBARRAYOBJECTFVATIPROC_proto
PFNGLGETVERTEXATTRIBARRAYOBJECTIVATIPROC_proto typedef proto :dword , :dword , :dword 
PFNGLGETVERTEXATTRIBARRAYOBJECTIVATIPROC typedef ptr PFNGLGETVERTEXATTRIBARRAYOBJECTIVATIPROC_proto

endif ; GL_ATI_vertex_attrib_array_object

;
; GL_ATI_visibility_query
;
;  Support:
;   Rage 128 based    : Not Supported
;   Radeon 7xxx based : Not Supported
;   Radeon 8xxx based : Not Supported
;   Radeon 9xxx based : Not Supported
;
ifndef GL_ATI_visibility_query 
GL_ATI_visibility_query equ 1

GL_MAX_VISIBILITY_QUERY_IDS_ATI        equ 08836h

PFNGLGENVISIBILITYQUERIESATIPROC_proto typedef proto :dword , :dword 
PFNGLGENVISIBILITYQUERIESATIPROC typedef ptr PFNGLGENVISIBILITYQUERIESATIPROC_proto
PFNGLDELETEVISIBILITYQUERIESATIPROC_proto typedef proto :dword , :dword 
PFNGLDELETEVISIBILITYQUERIESATIPROC typedef ptr PFNGLDELETEVISIBILITYQUERIESATIPROC_proto
PFNGLBEGINDEFINEVISIBILITYQUERYATIPROC_proto typedef proto :dword 
PFNGLBEGINDEFINEVISIBILITYQUERYATIPROC typedef ptr PFNGLBEGINDEFINEVISIBILITYQUERYATIPROC_proto
PFNGLENDDEFINEVISIBILITYQUERYATIPROC_proto typedef proto
PFNGLENDDEFINEVISIBILITYQUERYATIPROC typedef ptr PFNGLENDDEFINEVISIBILITYQUERYATIPROC_proto
PFNGLBEGINUSEVISIBILITYQUERYATIPROC_proto typedef proto :dword 
PFNGLBEGINUSEVISIBILITYQUERYATIPROC typedef ptr PFNGLBEGINUSEVISIBILITYQUERYATIPROC_proto
PFNGLENDUSEVISIBILITYQUERYATIPROC_proto typedef proto
PFNGLENDUSEVISIBILITYQUERYATIPROC typedef ptr PFNGLENDUSEVISIBILITYQUERYATIPROC_proto

endif ; GL_ATI_visibility_query


;
;  ATIX EXTENSIONS
;

;
; GL_ATIX_texture_env_combine3
;
; Support:
;  Rage 128 based    : Not Supported
;  Radeon 7xxx based : Supported
;  Radeon 8xxx based : Supported
;  Radeon 9xxx based : Supported
;
ifndef GL_ATIX_texture_env_combine3
GL_ATIX_texture_env_combine3			equ 1

GL_MODULATE_ADD_ATIX                            equ 08744h
GL_MODULATE_SIGNED_ADD_ATIX                     equ 08745h
GL_MODULATE_SUBTRACT_ATIX                       equ 08746h

ifndef GL_ATI_texture_env_combine3
GL_ATI_texture_env_combine3			equ 1
GL_MODULATE_ADD_ATI                             equ 08744h
GL_MODULATE_SIGNED_ADD_ATI                      equ 08745h
GL_MODULATE_SUBTRACT_ATI                        equ 08746h
endif

endif ; GL_ATIX_texture_env_combine3

;
; GL_ATIX_texture_env_route
;
; Support
;   Rage 128 based    : Not Supported
;   Radeon 7xxx based : Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_ATIX_texture_env_route
GL_ATIX_texture_env_route equ 1

GL_SECONDARY_COLOR_ATIX                 equ 08747h
GL_TEXTURE_OUTPUT_RGB_ATIX              equ 08748h
GL_TEXTURE_OUTPUT_ALPHA_ATIX            equ 08749h

endif ; GL_ATIX_texture_env_route

;
; GL_ATIX_vertex_shader_output_point_size
;
;  Support:
;   Rage 128 based    : Not Supported
;   Radeon 7xxx based : Not Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_ATIX_vertex_shader_output_point_size
GL_ATIX_vertex_shader_output_point_size equ 1

GL_OUTPUT_POINT_SIZE_ATIX       equ 0610Eh

endif ; GL_ATIX_vertex_shader_output_point_size

;
;  EXT EXTENSIONS
;
;
;  GL_EXT_stencil_wrap
;
; Support:
;   Rage 128 based    : Supported
;   Radeon 7xxx based : Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_EXT_stencil_wrap
GL_EXT_stencil_wrap                                     equ 1

GL_INCR_WRAP_EXT                                        equ 08507h
GL_DECR_WRAP_EXT                                        equ 08508h

endif  ; GL_EXT_stencil_wrap

;
; GL_EXT_abgr
;
;  Support:
;   Rage 128 based    : Supported
;   Radeon 7xxx based : Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_EXT_abgr
GL_EXT_abgr                         equ 1

GL_ABGR_EXT                         equ 08000h

endif ; GL_EXT_abgr


;
; GL_EXT_bgra
;
;  Support:
;   Rage 128 based    : Supported
;   Radeon 7xxx based : Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_EXT_bgra
GL_EXT_bgra                         equ 1

GL_BGR_EXT                          equ 080E0h
GL_BGRA_EXT                         equ 080E1h

endif ; GL_EXT_bgra 

;
; GL_EXT_blend_color
;
; Support:
;   Rage 128 based    : Not Supported
;   Radeon 7xxx based : Not Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_EXT_blend_color
GL_EXT_blend_color              equ 1

GL_CONSTANT_COLOR_EXT           equ 08001h
GL_ONE_MINUS_CONSTANT_COLOR_EXT equ 08002h
GL_CONSTANT_ALPHA_EXT           equ 08003h
GL_ONE_MINUS_CONSTANT_ALPHA_EXT equ 08004h
GL_BLEND_COLOR_EXT              equ 08005h

PFNGLBLENDCOLOREXTPROC_proto typedef proto :real4 , :real4 , :real4 , :real4 
PFNGLBLENDCOLOREXTPROC typedef ptr PFNGLBLENDCOLOREXTPROC_proto

endif  ; GL_EXT_blend_color 

;
; GL_EXT_blend_func_separate
;
; Support:
;   Rage 128 based    : Not Supported
;   Radeon 7xxx based : Not Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_EXT_blend_func_separate
GL_EXT_blend_func_separate  equ 1

GL_BLEND_DST_RGB_EXT    equ 080C8h
GL_BLEND_SRC_RGB_EXT    equ 080C9h
GL_BLEND_DST_ALPHA_EXT  equ 080CAh
GL_BLEND_SRC_ALPHA_EXT  equ 080CBh

PFNGLBLENDFUNCSEPARATEEXTPROC_proto typedef proto :dword , :dword , :dword , :dword 
PFNGLBLENDFUNCSEPARATEEXTPROC typedef ptr PFNGLBLENDFUNCSEPARATEEXTPROC_proto

endif ; GL_EXT_blend_func_separate 

;
; GL_EXT_blend_minmax
;
; Support:
;   Rage 128 based    : Not Supported
;   Radeon 7xxx based : Not Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_EXT_blend_minmax
GL_EXT_blend_minmax     equ 1

GL_FUNC_ADD_EXT         equ 08006h
GL_MIN_EXT              equ 08007h
GL_MAX_EXT              equ 08008h
GL_BLEND_EQUATION_EXT   equ 08009h

PFNGLBLENDEQUATIONEXTPROC_proto typedef proto :dword 
PFNGLBLENDEQUATIONEXTPROC typedef ptr PFNGLBLENDEQUATIONEXTPROC_proto

endif ; GL_EXT_blend_minmax 

;
; GL_EXT_blend_subtract
;
; Support:
;   Rage 128 based    : Not Supported
;   Radeon 7xxx based : Not Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_EXT_blend_subtract
GL_EXT_blend_subtract                1

GL_FUNC_SUBTRACT_EXT                 equ 0800Ah
GL_FUNC_REVERSE_SUBTRACT_EXT         equ 0800Bh

endif ; GL_EXT_blend_subtract 

;
; GL_EXT_clip_volume_hint
;
;  Support:
;   Rage 128 based    : Not Supported
;   Radeon 7xxx based : Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_EXT_clip_volume_hint
GL_EXT_clip_volume_hint             equ 1

GL_CLIP_VOLUME_CLIPPING_HINT_EXT    equ 080F0h

endif ; GL_EXT_clip_volume_hint 

;
; GL_EXT_compiled_vertex_array
;
;  Support:
;   Rage 128 based    : Supported
;   Radeon 7xxx based : Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_EXT_compiled_vertex_array
GL_EXT_compiled_vertex_array        equ 1

GL_ARRAY_ELEMENT_LOCK_FIRST_EXT     equ 081A8h
GL_ARRAY_ELEMENT_LOCK_COUNT_EXT     equ 081A9h

PFNGLLOCKARRAYSEXTPROC_proto typedef proto :dword , :dword 
PFNGLLOCKARRAYSEXTPROC typedef ptr PFNGLLOCKARRAYSEXTPROC_proto
PFNGLUNLOCKARRAYSEXTPROC_proto typedef proto
PFNGLUNLOCKARRAYSEXTPROC typedef ptr PFNGLUNLOCKARRAYSEXTPROC_proto

endif ; GL_EXT_compiled_vertex_array 

;
; GL_EXT_draw_range_elements
;
;  Support:
;   Rage 128 based    : Supported
;   Radeon 7xxx based : Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_EXT_draw_range_elements
GL_EXT_draw_range_elements           equ 1

GL_MAX_ELEMENTS_VERTICES_EXT         equ 080E8h
GL_MAX_ELEMENTS_INDICES_EXT          equ 080E9h

PFNGLDRAWRANGEELEMENTSEXTPROC_proto typedef proto :dword , :dword , :dword , :dword , :dword , :dword 
PFNGLDRAWRANGEELEMENTSEXTPROC typedef ptr PFNGLDRAWRANGEELEMENTSEXTPROC_proto

endif ; GL_EXT_draw_range_elements 

;
; GL_EXT_fog_coord
;
;  Support:
;   Rage 128 based    : Supported
;   Radeon 7xxx based : Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_EXT_fog_coord
GL_EXT_fog_coord                     equ 1

GL_FOG_COORDINATE_SOURCE_EXT         equ 08450h
GL_FOG_COORDINATE_EXT                equ 08451h
GL_FRAGMENT_DEPTH_EXT                equ 08452h
GL_CURRENT_FOG_COORDINATE_EXT        equ 08453h
GL_FOG_COORDINATE_ARRAY_TYPE_EXT     equ 08454h
GL_FOG_COORDINATE_ARRAY_STRIDE_EXT   equ 08455h
GL_FOG_COORDINATE_ARRAY_POINTER_EXT  equ 08456h
GL_FOG_COORDINATE_ARRAY_EXT          equ 08457h

PFNGLFOGCOORDFEXTPROC_proto typedef proto :real4 
PFNGLFOGCOORDFEXTPROC typedef ptr PFNGLFOGCOORDFEXTPROC_proto
PFNGLFOGCOORDDEXTPROC_proto typedef proto :real8 
PFNGLFOGCOORDDEXTPROC typedef ptr PFNGLFOGCOORDDEXTPROC_proto
PFNGLFOGCOORDFVEXTPROC_proto typedef proto :dword 
PFNGLFOGCOORDFVEXTPROC typedef ptr PFNGLFOGCOORDFVEXTPROC_proto
PFNGLFOGCOORDDVEXTPROC_proto typedef proto :dword 
PFNGLFOGCOORDDVEXTPROC typedef ptr PFNGLFOGCOORDDVEXTPROC_proto
PFNGLFOGCOORDPOINTEREXTPROC_proto typedef proto :dword , :dword , :dword 
PFNGLFOGCOORDPOINTEREXTPROC typedef ptr PFNGLFOGCOORDPOINTEREXTPROC_proto

endif ; GL_EXT_fog_coord 

;
; GL_EXT_framebuffer_object
;
;  Support:
;   Rage 128 based    : Not Supported
;   Radeon 7xxx based : Not Supported
;   Radeon 8xxx based : Not Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_EXT_framebuffer_object
GL_EXT_framebuffer_object equ 1

GL_FRAMEBUFFER_EXT equ 08D40h
GL_RENDERBUFFER_EXT equ 08D41h
GL_STENCIL_INDEX1_EXT equ 08D46h
GL_STENCIL_INDEX4_EXT equ 08D47h
GL_STENCIL_INDEX8_EXT equ 08D48h
GL_STENCIL_INDEX16_EXT equ 08D49h
GL_RENDERBUFFER_WIDTH_EXT equ 08D42h
GL_RENDERBUFFER_HEIGHT_EXT equ 08D43h
GL_RENDERBUFFER_INTERNAL_FORMAT_EXT equ 08D44h
GL_RENDERBUFFER_RED_SIZE_EXT equ 08D50h
GL_RENDERBUFFER_GREEN_SIZE_EXT equ 08D51h
GL_RENDERBUFFER_BLUE_SIZE_EXT equ 08D52h
GL_RENDERBUFFER_ALPHA_SIZE_EXT equ 08D53h
GL_RENDERBUFFER_DEPTH_SIZE_EXT equ 08D54h
GL_RENDERBUFFER_STENCIL_SIZE_EXT equ 08D55h
GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE_EXT equ 08CD0h
GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME_EXT equ 08CD1h
GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL_EXT equ 08CD2h
GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE_EXT equ 08CD3h
GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_3D_ZOFFSET_EXT equ 08CD4h
GL_COLOR_ATTACHMENT0_EXT equ 08CE0h
GL_COLOR_ATTACHMENT1_EXT equ 08CE1h
GL_COLOR_ATTACHMENT2_EXT equ 08CE2h
GL_COLOR_ATTACHMENT3_EXT equ 08CE3h
GL_COLOR_ATTACHMENT4_EXT equ 08CE4h
GL_COLOR_ATTACHMENT5_EXT equ 08CE5h
GL_COLOR_ATTACHMENT6_EXT equ 08CE6h
GL_COLOR_ATTACHMENT7_EXT equ 08CE7h
GL_COLOR_ATTACHMENT8_EXT equ 08CE8h
GL_COLOR_ATTACHMENT9_EXT equ 08CE9h
GL_COLOR_ATTACHMENT10_EXT equ 08CEAh
GL_COLOR_ATTACHMENT11_EXT equ 08CEBh
GL_COLOR_ATTACHMENT12_EXT equ 08CECh
GL_COLOR_ATTACHMENT13_EXT equ 08CEDh
GL_COLOR_ATTACHMENT14_EXT equ 08CEEh
GL_COLOR_ATTACHMENT15_EXT equ 08CEFh
GL_DEPTH_ATTACHMENT_EXT equ 08D00h
GL_STENCIL_ATTACHMENT_EXT equ 08D20h
GL_FRAMEBUFFER_COMPLETE_EXT equ 08CD5h
GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT_EXT equ 08CD6h
GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_EXT equ 08CD7h
GL_FRAMEBUFFER_INCOMPLETE_DUPLICATE_ATTACHMENT_EXT equ 08CD8h
GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS_EXT             equ 08CD9h
GL_FRAMEBUFFER_INCOMPLETE_FORMATS_EXT                equ 08CDAh
GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER_EXT            equ 08CDBh
GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER_EXT            equ 08CDCh
GL_FRAMEBUFFER_UNSUPPORTED_EXT                       equ 08CDDh
GL_FRAMEBUFFER_STATUS_ERROR_EXT                      equ 08CDEh
GL_FRAMEBUFFER_BINDING_EXT                           equ 08CA6h
GL_RENDERBUFFER_BINDING_EXT                          equ 08CA7h
GL_MAX_COLOR_ATTACHMENTS_EXT                         equ 08CDFh
GL_MAX_RENDERBUFFER_SIZE_EXT                         equ 084E8h
GL_INVALID_FRAMEBUFFER_OPERATION_EXT                 equ 00506h

PFNGLISRENDERBUFFEREXTPROC_proto typedef proto :dword
PFNGLISRENDERBUFFEREXTPROC typedef ptr PFNGLISRENDERBUFFEREXTPROC_proto

PFNGLBINDRENDERBUFFEREXTPROC_proto typedef proto :dword, :dword
PFNGLBINDRENDERBUFFEREXTPROC typedef ptr PFNGLBINDRENDERBUFFEREXTPROC_proto

PFNGLDELETERENDERBUFFERSEXTPROC_proto typedef proto :dword, :dword
PFNGLDELETERENDERBUFFERSEXTPROC typedef ptr PFNGLDELETERENDERBUFFERSEXTPROC_proto

PFNGLGENRENDERBUFFERSEXTPROC_proto typedef proto :dword, :dword
PFNGLGENRENDERBUFFERSEXTPROC typedef ptr PFNGLGENRENDERBUFFERSEXTPROC_proto

PFNGLRENDERBUFFERSTORAGEEXTPROC_proto typedef proto :dword, :dword, :dword, :dword
PFNGLRENDERBUFFERSTORAGEEXTPROC typedef ptr PFNGLRENDERBUFFERSTORAGEEXTPROC_proto

PFNGLGETRENDERBUFFERPARAMETERIVEXTPROC_proto typedef proto :dword, :dword, :dword
PFNGLGETRENDERBUFFERPARAMETERIVEXTPROC typedef ptr PFNGLGETRENDERBUFFERPARAMETERIVEXTPROC_proto

PFNGLISFRAMEBUFFEREXTPROC_proto typedef proto :dword, :dword
PFNGLISFRAMEBUFFEREXTPROC typedef ptr PFNGLISFRAMEBUFFEREXTPROC_proto

PFNGLBINDFRAMEBUFFEREXTPROC_proto typedef proto :dword, :dword
PFNGLBINDFRAMEBUFFEREXTPROC typedef ptr PFNGLBINDFRAMEBUFFEREXTPROC_proto

PFNGLDELETEFRAMEBUFFERSEXTPROC_proto typedef proto :dword, :dword
PFNGLDELETEFRAMEBUFFERSEXTPROC typedef ptr PFNGLDELETEFRAMEBUFFERSEXTPROC_proto

PFNGLGENFRAMEBUFFERSEXTPROC_proto typedef proto :dword, :dword
PFNGLGENFRAMEBUFFERSEXTPROC typedef ptr PFNGLGENFRAMEBUFFERSEXTPROC_proto

PFNGLCHECKFRAMEBUFFERSTATUSEXTPROC_proto typedef proto :dword
PFNGLCHECKFRAMEBUFFERSTATUSEXTPROC typedef ptr PFNGLCHECKFRAMEBUFFERSTATUSEXTPROC_proto

PFNGLFRAMEBUFFERTEXTURE1DEXTPROC_proto typedef proto :dword, :dword, :dword, :dword, :dword
PFNGLFRAMEBUFFERTEXTURE1DEXTPROC typedef ptr PFNGLFRAMEBUFFERTEXTURE1DEXTPROC_proto

PFNGLFRAMEBUFFERTEXTURE2DEXTPROC_proto typedef proto :dword, :dword, :dword, :dword, :dword
PFNGLFRAMEBUFFERTEXTURE2DEXTPROC typedef ptr PFNGLFRAMEBUFFERTEXTURE2DEXTPROC_proto

PFNGLFRAMEBUFFERTEXTURE3DEXTPROC_proto typedef proto :dword, :dword, :dword, :dword, :dword, :dword
PFNGLFRAMEBUFFERTEXTURE3DEXTPROC typedef ptr PFNGLFRAMEBUFFERTEXTURE3DEXTPROC_proto

PFNGLFRAMEBUFFERRENDERBUFFEREXTPROC_proto typedef proto :dword, :dword, :dword, :dword
PFNGLFRAMEBUFFERRENDERBUFFEREXTPROC typedef ptr PFNGLFRAMEBUFFERRENDERBUFFEREXTPROC_proto

PFNGLGETFRAMEBUFFERATTACHMENTPARAMETERIVEXTPROC_proto typedef proto :dword, :dword, :dword, :ptr dword
PFNGLGETFRAMEBUFFERATTACHMENTPARAMETERIVEXTPROC typedef ptr PFNGLGETFRAMEBUFFERATTACHMENTPARAMETERIVEXTPROC_proto

PFNGLGENERATEMIPMAPEXTPROC_proto typedef proto :dword
PFNGLGENERATEMIPMAPEXTPROC typedef ptr PFNGLGENERATEMIPMAPEXTPROC_proto

endif ; GL_EXT_framebuffer_object

;
; GL_EXT_packed_pixels
;
;  Support:
;   Rage 128 based    : Supported
;   Radeon 7xxx based : Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_EXT_packed_pixels
GL_EXT_packed_pixels                 equ 1

GL_UNSIGNED_BYTE_3_3_2_EXT           equ 08032h
GL_UNSIGNED_SHORT_4_4_4_4_EXT        equ 08033h
GL_UNSIGNED_SHORT_5_5_5_1_EXT        equ 08034h
GL_UNSIGNED_INT_8_8_8_8_EXT          equ 08035h
GL_UNSIGNED_INT_10_10_10_2_EXT       equ 08036h

endif ; GL_EXT_packed_pixels 

;
; GL_EXT_point_parameters
;
;  Support:
;   Rage 128 based    : Not Supported
;   Radeon 7xxx based : Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_EXT_point_parameters
GL_EXT_point_parameters              equ 1

GL_POINT_SIZE_MIN_EXT                equ 08126h
GL_POINT_SIZE_MAX_EXT                equ 08127h
GL_POINT_FADE_THRESHOLD_SIZE_EXT     equ 08128h
GL_DISTANCE_ATTENUATION_EXT          equ 08129h

PFNGLPOINTPARAMETERFEXTPROC_proto typedef proto :dword , :real4
PFNGLPOINTPARAMETERFEXTPROC typedef ptr PFNGLPOINTPARAMETERFEXTPROC_proto
PFNGLPOINTPARAMETERFVEXTPROC_proto typedef proto :dword , :dword 
PFNGLPOINTPARAMETERFVEXTPROC typedef ptr PFNGLPOINTPARAMETERFVEXTPROC_proto
;PFNGLPOINTPARAMETERIEXTPROC_proto typedef proto :dword , :dword 
;PFNGLPOINTPARAMETERIEXTPROC typedef ptr PFNGLPOINTPARAMETERIEXTPROC_proto
;PFNGLPOINTPARAMETERIVEXTPROC_proto typedef proto :dword , :dword 
;PFNGLPOINTPARAMETERIVEXTPROC typedef ptr PFNGLPOINTPARAMETERIVEXTPROC_proto

endif ; GL_EXT_point_parameters 

;
; GL_ARB_point_parameters
;
;  Support:
;   Rage 128 based    : Not Supported
;   Radeon 7xxx based : Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_ARB_point_parameters
GL_ARB_point_parameters              equ 1

GL_POINT_SIZE_MIN_ARB                equ 08126h
GL_POINT_SIZE_MAX_ARB                equ 08127h
GL_POINT_FADE_THRESHOLD_SIZE_ARB     equ 08128h
GL_POINT_DISTANCE_ATTENUATION_ARB    equ 08129h

PFNGLPOINTPARAMETERFARBPROC_proto typedef proto :dword , :real4
PFNGLPOINTPARAMETERFARBPROC typedef ptr PFNGLPOINTPARAMETERFARBPROC_proto
PFNGLPOINTPARAMETERFVARBPROC_proto typedef proto :dword , :dword 
PFNGLPOINTPARAMETERFVARBPROC typedef ptr PFNGLPOINTPARAMETERFVARBPROC_proto
PFNGLPOINTPARAMETERIARBPROC_proto typedef proto :dword , :dword 
PFNGLPOINTPARAMETERIARBPROC typedef ptr PFNGLPOINTPARAMETERIARBPROC_proto
PFNGLPOINTPARAMETERIVARBPROC_proto typedef proto :dword , :dword
PFNGLPOINTPARAMETERIVARBPROC typedef ptr PFNGLPOINTPARAMETERIVARBPROC_proto

endif ; GL_ARB_point_parameters 

;
; GL_ARB_texture_non_power_of_two
;
;  Support:
;   Rage 128 based     : Not Supported
;   Radeon 7xxx based  : Not Supported
;   Radeon 8xxx based  : Not Supported
;   Radeon 97xx based  : Supported
;
ifndef GL_ARB_texture_non_power_of_two
GL_ARB_texture_non_power_of_two equ 1
endif ; GL_ARB_texture_non_power_of_two

;
; GL_EXT_rescale_normal
;
;  Support:
;   Rage 128 based    : Supported
;   Radeon 7xxx based : Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_EXT_rescale_normal
GL_EXT_rescale_normal                equ 1

GL_RESCALE_NORMAL_EXT                equ 0803Ah

endif ; GL_EXT_rescale_normal 

ifdef FGL
;
; GL_EXT_polygon_offset
;
;  Support:
;   Rage 128 based    : Supported
;   Radeon 7xxx based : Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_EXT_polygon_offset
GL_EXT_polygon_offset                equ 1

GL_POLYGON_OFFSET_EXT                equ GL_POLYGON_OFFSET_FILL
GL_POLYGON_OFFSET_FACTOR_EXT         equ GL_POLYGON_OFFSET_FACTOR
GL_POLYGON_OFFSET_BIAS_EXT           equ 08039h

endif ; GL_EXT_polygon_offset
endif ; FGL

;
; GL_EXT_separate_specular_color
;
;  Support:
;   Rage 128 based    : Supported
;   Radeon 7xxx based : Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_EXT_separate_specular_color
GL_EXT_separate_specular_color       equ 1

GL_LIGHT_MODEL_COLOR_CONTROL_EXT     equ 081F8h
GL_SINGLE_COLOR_EXT                  equ 081F9h
GL_SEPARATE_SPECULAR_COLOR_EXT       equ 081FAh

endif ; GL_EXT_separate_specular_color 

;
; GL_EXT_secondary_color
;
;  Support:
;   Rage 128 based    : Supported
;   Radeon 7xxx based : Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_EXT_secondary_color
GL_EXT_secondary_color               equ 1

GL_COLOR_SUM_EXT                     equ 08458h
GL_CURRENT_SECONDARY_COLOR_EXT       equ 08459h
GL_SECONDARY_COLOR_ARRAY_SIZE_EXT    equ 0845Ah
GL_SECONDARY_COLOR_ARRAY_TYPE_EXT    equ 0845Bh
GL_SECONDARY_COLOR_ARRAY_STRIDE_EXT  equ 0845Ch
GL_SECONDARY_COLOR_ARRAY_POINTER_EXT equ 0845Dh
GL_SECONDARY_COLOR_ARRAY_EXT         equ 0845Eh

PFNGLSECONDARYCOLOR3FEXTPROC_proto typedef proto :real4 , :real4 , :real4 
PFNGLSECONDARYCOLOR3FEXTPROC typedef ptr PFNGLSECONDARYCOLOR3FEXTPROC_proto
PFNGLSECONDARYCOLOR3DEXTPROC_proto typedef proto :real8 , :real8 , :real8 
PFNGLSECONDARYCOLOR3DEXTPROC typedef ptr PFNGLSECONDARYCOLOR3DEXTPROC_proto
PFNGLSECONDARYCOLOR3BEXTPROC_proto typedef proto :dword , :dword , :dword 
PFNGLSECONDARYCOLOR3BEXTPROC typedef ptr PFNGLSECONDARYCOLOR3BEXTPROC_proto
PFNGLSECONDARYCOLOR3SEXTPROC_proto typedef proto :dword , :dword , :dword 
PFNGLSECONDARYCOLOR3SEXTPROC typedef ptr PFNGLSECONDARYCOLOR3SEXTPROC_proto
PFNGLSECONDARYCOLOR3IEXTPROC_proto typedef proto :dword , :dword , :dword 
PFNGLSECONDARYCOLOR3IEXTPROC typedef ptr PFNGLSECONDARYCOLOR3IEXTPROC_proto
PFNGLSECONDARYCOLOR3UBEXTPROC_proto typedef proto :dword , :dword , :dword 
PFNGLSECONDARYCOLOR3UBEXTPROC typedef ptr PFNGLSECONDARYCOLOR3UBEXTPROC_proto
PFNGLSECONDARYCOLOR3USEXTPROC_proto typedef proto :dword , :dword , :dword 
PFNGLSECONDARYCOLOR3USEXTPROC typedef ptr PFNGLSECONDARYCOLOR3USEXTPROC_proto
PFNGLSECONDARYCOLOR3UIEXTPROC_proto typedef proto :dword , :dword , :dword 
PFNGLSECONDARYCOLOR3UIEXTPROC typedef ptr PFNGLSECONDARYCOLOR3UIEXTPROC_proto

PFNGLSECONDARYCOLOR3FVEXTPROC_proto typedef proto :dword 
PFNGLSECONDARYCOLOR3FVEXTPROC typedef ptr PFNGLSECONDARYCOLOR3FVEXTPROC_proto
PFNGLSECONDARYCOLOR3DVEXTPROC_proto typedef proto :dword 
PFNGLSECONDARYCOLOR3DVEXTPROC typedef ptr PFNGLSECONDARYCOLOR3DVEXTPROC_proto
PFNGLSECONDARYCOLOR3BVEXTPROC_proto typedef proto :dword 
PFNGLSECONDARYCOLOR3BVEXTPROC typedef ptr PFNGLSECONDARYCOLOR3BVEXTPROC_proto
PFNGLSECONDARYCOLOR3SVEXTPROC_proto typedef proto :dword 
PFNGLSECONDARYCOLOR3SVEXTPROC typedef ptr PFNGLSECONDARYCOLOR3SVEXTPROC_proto
PFNGLSECONDARYCOLOR3IVEXTPROC_proto typedef proto :dword 
PFNGLSECONDARYCOLOR3IVEXTPROC typedef ptr PFNGLSECONDARYCOLOR3IVEXTPROC_proto
PFNGLSECONDARYCOLOR3UBVEXTPROC_proto typedef proto :dword 
PFNGLSECONDARYCOLOR3UBVEXTPROC typedef ptr PFNGLSECONDARYCOLOR3UBVEXTPROC_proto
PFNGLSECONDARYCOLOR3USVEXTPROC_proto typedef proto :dword 
PFNGLSECONDARYCOLOR3USVEXTPROC typedef ptr PFNGLSECONDARYCOLOR3USVEXTPROC_proto
PFNGLSECONDARYCOLOR3UIVEXTPROC_proto typedef proto :dword 
PFNGLSECONDARYCOLOR3UIVEXTPROC typedef ptr PFNGLSECONDARYCOLOR3UIVEXTPROC_proto

PFNGLSECONDARYCOLORPOINTEREXTPROC_proto typedef proto :dword , :dword , :dword , :dword 
PFNGLSECONDARYCOLORPOINTEREXTPROC typedef ptr PFNGLSECONDARYCOLORPOINTEREXTPROC_proto

endif ; GL_EXT_secondary_color 


;
; GL_EXT_texgen_reflection
;
;  Support:
;   Rage 128 based    : Supported
;   Radeon 7xxx based : Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_EXT_texgen_reflection
GL_EXT_texgen_reflection              equ 1

GL_NORMAL_MAP_EXT                     equ 08511h
GL_REFLECTION_MAP_EXT                 equ 08512h

endif ; GL_EXT_texgen_reflection 

;
; GL_EXT_texture_cube_map
;
;  Support:
;   Rage 128 based    : Not Supported
;   Radeon 7xxx based : Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_EXT_texture_cube_map
GL_EXT_texture_cube_map              equ 1

GL_TEXTURE_CUBE_MAP_EXT              equ 08513h
GL_TEXTURE_BINDING_CUBE_MAP_EXT      equ 08514h
GL_TEXTURE_CUBE_MAP_POSITIVE_X_EXT   equ 08515h
GL_TEXTURE_CUBE_MAP_NEGATIVE_X_EXT   equ 08516h
GL_TEXTURE_CUBE_MAP_POSITIVE_Y_EXT   equ 08517h
GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_EXT   equ 08518h
GL_TEXTURE_CUBE_MAP_POSITIVE_Z_EXT   equ 08519h
GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_EXT   equ 0851Ah
GL_PROXY_TEXTURE_CUBE_MAP_EXT        equ 0851Bh
GL_MAX_CUBE_MAP_TEXTURE_SIZE_EXT     equ 0851Ch

endif ; GL_EXT_texture_cube_map 

;
; GL_EXT_texture3D
;
; Support:
;   Rage 128 based    : Supported (software)
;   Radeon 7xxx based : Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_EXT_texture3D
GL_EXT_texture3D                     equ 1

;GL_TEXTURE_BINDING_3D_EXT            equ 0806Ah
GL_PACK_SKIP_IMAGES_EXT              equ 0806Bh
GL_PACK_IMAGE_HEIGHT_EXT             equ 0806Ch
GL_UNPACK_SKIP_IMAGES_EXT            equ 0806Dh
GL_UNPACK_IMAGE_HEIGHT_EXT           equ 0806Eh
GL_TEXTURE_3D_EXT                    equ 0806Fh
GL_PROXY_TEXTURE_3D_EXT              equ 08070h
GL_TEXTURE_DEPTH_EXT                 equ 08071h
GL_TEXTURE_WRAP_R_EXT                equ 08072h
GL_MAX_3D_TEXTURE_SIZE_EXT           equ 08073h


PFNGLTEXIMAGE3DEXTPROC_proto typedef proto :dword , :dword , :dword , :dword , :dword , :dword , :dword , :dword , :dword , :dword 
PFNGLTEXIMAGE3DEXTPROC typedef ptr PFNGLTEXIMAGE3DEXTPROC_proto

PFNGLCOPYTEXSUBIMAGE3DEXTPROC_proto typedef proto :dword , :dword , :dword , :dword , :dword , :dword , :dword , :dword , :dword 
PFNGLCOPYTEXSUBIMAGE3DEXTPROC typedef ptr PFNGLCOPYTEXSUBIMAGE3DEXTPROC_proto

PFNGLTEXSUBIMAGE3DEXTPROC_proto typedef proto :dword , :dword , :dword , :dword , :dword , :dword , :dword , :dword , :dword , :dword , :dword 
PFNGLTEXSUBIMAGE3DEXTPROC typedef ptr PFNGLTEXSUBIMAGE3DEXTPROC_proto

;PFNGLTEXSUBIMAGE3DPROC_proto typedef proto :dword , :dword , :dword , :dword , :dword , :dword , :dword , :dword , :dword , :dword , :dword 
;PFNGLTEXSUBIMAGE3DPROC typedef ptr PFNGLTEXSUBIMAGE3DPROC_proto

;PFNGLCOPYTEXSUBIMAGE3DPROC_proto typedef proto :dword , :dword , :dword , :dword , :dword , :dword , :dword , :dword , :dword 
;PFNGLCOPYTEXSUBIMAGE3DPROC typedef ptr PFNGLCOPYTEXSUBIMAGE3DPROC_proto

endif ; GL_EXT_texture3D 

;
; GL_EXT_texture_compression_s3tc
;
; Support:
;   Rage 128 based    : Not Supported
;   Radeon 7xxx based : Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_EXT_texture_compression_s3tc
GL_EXT_texture_compression_s3tc      equ 1

GL_COMPRESSED_RGB_S3TC_DXT1_EXT      equ 083F0h
GL_COMPRESSED_RGBA_S3TC_DXT1_EXT     equ 083F1h
GL_COMPRESSED_RGBA_S3TC_DXT3_EXT     equ 083F2h
GL_COMPRESSED_RGBA_S3TC_DXT5_EXT     equ 083F3h

endif ; GL_EXT_texture_compression_s3tc 

;
; GL_EXT_texture_edge_clamp
;
;  Support:
;   Rage 128 based    : Supported
;   Radeon 7xxx based : Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_EXT_texture_edge_clamp
GL_EXT_texture_edge_clamp            equ 1

GL_CLAMP_TO_EDGE_EXT                 equ 0812Fh

endif ; GL_EXT_texture_edge_clamp 

;
; GL_EXT_texture_env_add
;
;  Support:
;   Rage 128 based    : Supported
;   Radeon 7xxx based : Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_EXT_texture_env_add
GL_EXT_texture_env_add               equ 1

endif ; GL_EXT_texture_env_add 

;
; GL_EXT_texture_env_combine
;
;  Support:
;   Rage 128 based    : Supported
;   Radeon 7xxx based : Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_EXT_texture_env_combine
GL_EXT_texture_env_combine           equ 1

GL_COMBINE_EXT                       equ 08570h
GL_COMBINE_RGB_EXT                   equ 08571h
GL_COMBINE_ALPHA_EXT                 equ 08572h
GL_SOURCE0_RGB_EXT                   equ 08580h
GL_SOURCE1_RGB_EXT                   equ 08581h
GL_SOURCE2_RGB_EXT                   equ 08582h
GL_SOURCE0_ALPHA_EXT                 equ 08588h
GL_SOURCE1_ALPHA_EXT                 equ 08589h
GL_SOURCE2_ALPHA_EXT                 equ 0858Ah
GL_OPERAND0_RGB_EXT                  equ 08590h
GL_OPERAND1_RGB_EXT                  equ 08591h
GL_OPERAND2_RGB_EXT                  equ 08592h
GL_OPERAND0_ALPHA_EXT                equ 08598h
GL_OPERAND1_ALPHA_EXT                equ 08599h
GL_OPERAND2_ALPHA_EXT                equ 0859Ah
GL_RGB_SCALE_EXT                     equ 08573h
GL_ADD_SIGNED_EXT                    equ 08574h
GL_INTERPOLATE_EXT                   equ 08575h
GL_CONSTANT_EXT                      equ 08576h
GL_PRIMARY_COLOR_EXT                 equ 08577h
GL_PREVIOUS_EXT                      equ 08578h

endif ; GL_EXT_texture_env_combine 

;
; GL_EXT_texture_env_dot3
;
; Support:
;   Rage 128 based    : Not Supported
;   Radeon 7xxx based : Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_EXT_texture_env_dot3
GL_EXT_texture_env_dot3 equ 1

GL_DOT3_RGB_EXT  equ 08740h
GL_DOT3_RGBA_EXT equ 08741h

endif ; GL_EXT_texture_env_dot3 

;
; GL_EXT_texture_lod_bias
;
; Support:
;   Rage 128 based    : Not Supported
;   Radeon 7xxx based : Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_EXT_texture_lod_bias
GL_EXT_texture_lod_bias              equ 1

GL_TEXTURE_FILTER_CONTROL_EXT equ 08500h
GL_TEXTURE_LOD_BIAS_EXT       equ 08501h
GL_MAX_TEXTURE_LOD_BIAS_EXT   equ 084FDh

endif ; GL_EXT_texture_lod_bias 

;
; GL_EXT_texture_mirror_clamp
;
;  Support:
;   Rage 128 based    : Not Supported
;   Radeon 7xxx based : Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_EXT_texture_mirror_clamp
GL_EXT_texture_mirror_clamp equ 1

GL_MIRROR_CLAMP_EXT equ 08742h
GL_MIRROR_CLAMP_TO_EDGE_EXT equ 08743h
GL_MIRROR_CLAMP_TO_BORDER_EXT equ 08912h

endif ; GL_EXT_texture_mirror_clamp

;
; GL_EXT_texture_filter_anisotropic
;
; Support:
;
;   Rage 128 based    : Not Supported
;   Radeon 7xxx based : Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_EXT_texture_filter_anisotropic
GL_EXT_texture_filter_anisotropic    equ 1

GL_TEXTURE_MAX_ANISOTROPY_EXT        equ 084FEh
GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT    equ 084FFh

endif ; GL_EXT_texture_filter_anisotropic 

;
; GL_EXT_texture_object
;
;  Support:
;   Rage 128 based    : Supported
;   Radeon 7xxx based : Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_EXT_texture_object
GL_EXT_texture_object              equ 1

GL_TEXTURE_PRIORITY_EXT            equ 08066h
GL_TEXTURE_RESIDENT_EXT            equ 08067h
GL_TEXTURE_1D_BINDING_EXT          equ 08068h
GL_TEXTURE_2D_BINDING_EXT          equ 08069h
GL_TEXTURE_3D_BINDING_EXT          equ 0806Ah

PFNGLGENTEXTURESEXTPROC_proto typedef proto :dword , :dword 
PFNGLGENTEXTURESEXTPROC typedef ptr PFNGLGENTEXTURESEXTPROC_proto
PFNGLDELETETEXTURESEXTPROC_proto typedef proto :dword , :dword 
PFNGLDELETETEXTURESEXTPROC typedef ptr PFNGLDELETETEXTURESEXTPROC_proto
PFNGLBINDTEXTUREEXTPROC_proto typedef proto :dword , :dword 
PFNGLBINDTEXTUREEXTPROC typedef ptr PFNGLBINDTEXTUREEXTPROC_proto
PFNGLPRIORITIZETEXTURESEXTPROC_proto typedef proto :dword , :dword , :dword 
PFNGLPRIORITIZETEXTURESEXTPROC typedef ptr PFNGLPRIORITIZETEXTURESEXTPROC_proto
PFNGLARETEXTURESRESIDENTEXTPROC_proto typedef proto :dword , :dword , :dword 
PFNGLARETEXTURESRESIDENTEXTPROC typedef ptr PFNGLARETEXTURESRESIDENTEXTPROC_proto
PFNGLISTEXTUREEXTPROC_proto typedef proto :dword 
PFNGLISTEXTUREEXTPROC typedef ptr PFNGLISTEXTUREEXTPROC_proto

endif ; GL_EXT_texture_object 

;
; GL_EXT_texture_rectangle
;
;  Support:
;   Rage 128 based    : Not Supported
;   Radeon 7xxx based : Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_EXT_texture_rectangle
GL_EXT_texture_rectangle            equ 1

GL_TEXTURE_RECTANGLE_EXT            equ 084F5h
GL_TEXTURE_BINDING_RECTANGLE_EXT    equ 084F6h
GL_PROXY_TEXTURE_RECTANGLE_EXT      equ 084F7h
GL_MAX_RECTANGLE_TEXTURE_SIZE_EXT   equ 084F8h

endif ; GL_EXT_texture_rectangle 


;
; GL_EXT_vertex_array
;
;  Support:
;   Rage 128 based    : Supported
;   Radeon 7xxx based : Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_EXT_vertex_array
GL_EXT_vertex_array                 equ 1

GL_VERTEX_ARRAY_EXT                 equ 08074h
GL_NORMAL_ARRAY_EXT                 equ 08075h
GL_COLOR_ARRAY_EXT                  equ 08076h
GL_INDEX_ARRAY_EXT                  equ 08077h
GL_TEXTURE_COORD_ARRAY_EXT          equ 08078h
GL_EDGE_FLAG_ARRAY_EXT              equ 08079h
GL_VERTEX_ARRAY_SIZE_EXT            equ 0807Ah
GL_VERTEX_ARRAY_TYPE_EXT            equ 0807Bh
GL_VERTEX_ARRAY_STRIDE_EXT          equ 0807Ch
GL_VERTEX_ARRAY_COUNT_EXT           equ 0807Dh
GL_NORMAL_ARRAY_TYPE_EXT            equ 0807Eh
GL_NORMAL_ARRAY_STRIDE_EXT          equ 0807Fh
GL_NORMAL_ARRAY_COUNT_EXT           equ 08080h
GL_COLOR_ARRAY_SIZE_EXT             equ 08081h
GL_COLOR_ARRAY_TYPE_EXT             equ 08082h
GL_COLOR_ARRAY_STRIDE_EXT           equ 08083h
GL_COLOR_ARRAY_COUNT_EXT            equ 08084h
GL_INDEX_ARRAY_TYPE_EXT             equ 08085h
GL_INDEX_ARRAY_STRIDE_EXT           equ 08086h
GL_INDEX_ARRAY_COUNT_EXT            equ 08087h
GL_TEXTURE_COORD_ARRAY_SIZE_EXT     equ 08088h
GL_TEXTURE_COORD_ARRAY_TYPE_EXT     equ 08089h
GL_TEXTURE_COORD_ARRAY_STRIDE_EXT   equ 0808Ah
GL_TEXTURE_COORD_ARRAY_COUNT_EXT    equ 0808Bh
GL_EDGE_FLAG_ARRAY_STRIDE_EXT       equ 0808Ch
GL_EDGE_FLAG_ARRAY_COUNT_EXT        equ 0808Dh
GL_VERTEX_ARRAY_POINTER_EXT         equ 0808Eh
GL_NORMAL_ARRAY_POINTER_EXT         equ 0808Fh
GL_COLOR_ARRAY_POINTER_EXT          equ 08090h
GL_INDEX_ARRAY_POINTER_EXT          equ 08091h
GL_TEXTURE_COORD_ARRAY_POINTER_EXT  equ 08092h
GL_EDGE_FLAG_ARRAY_POINTER_EXT      equ 08093h

PFNGLARRAYELEMENTEXTPROC_proto typedef proto :dword 
PFNGLARRAYELEMENTEXTPROC typedef ptr PFNGLARRAYELEMENTEXTPROC_proto
PFNGLCOLORPOINTEREXTPROC_proto typedef proto :dword , :dword , :dword , :dword , :dword 
PFNGLCOLORPOINTEREXTPROC typedef ptr PFNGLCOLORPOINTEREXTPROC_proto
PFNGLDRAWARRAYSEXTPROC_proto typedef proto :dword , :dword , :dword 
PFNGLDRAWARRAYSEXTPROC typedef ptr PFNGLDRAWARRAYSEXTPROC_proto
PFNGLEDGEFLAGPOINTEREXTPROC_proto typedef proto :dword , :dword , :dword 
PFNGLEDGEFLAGPOINTEREXTPROC typedef ptr PFNGLEDGEFLAGPOINTEREXTPROC_proto
PFNGLGETPOINTERVEXTPROC_proto typedef proto :dword , :dword 
PFNGLGETPOINTERVEXTPROC typedef ptr PFNGLGETPOINTERVEXTPROC_proto
PFNGLINDEXPOINTEREXTPROC_proto typedef proto :dword , :dword , :dword , :dword 
PFNGLINDEXPOINTEREXTPROC typedef ptr PFNGLINDEXPOINTEREXTPROC_proto
PFNGLNORMALPOINTEREXTPROC_proto typedef proto :dword , :dword , :dword , :dword 
PFNGLNORMALPOINTEREXTPROC typedef ptr PFNGLNORMALPOINTEREXTPROC_proto
PFNGLTEXCOORDPOINTEREXTPROC_proto typedef proto :dword , :dword , :dword , :dword , :dword 
PFNGLTEXCOORDPOINTEREXTPROC typedef ptr PFNGLTEXCOORDPOINTEREXTPROC_proto
PFNGLVERTEXPOINTEREXTPROC_proto typedef proto :dword , :dword , :dword , :dword , :dword 
PFNGLVERTEXPOINTEREXTPROC typedef ptr PFNGLVERTEXPOINTEREXTPROC_proto

endif ; GL_EXT_vertex_array 

;
; GL_EXT_multi_draw_arrays
;
;  Support:
;   Rage 128 based    : Supported
;   Radeon 7xxx based : Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_EXT_multi_draw_arrays
GL_EXT_multi_draw_arrays				equ 1

PFNGLMULTIDRAWARRAYSEXTPROC_proto typedef proto :dword , :dword , :dword , :dword 
PFNGLMULTIDRAWARRAYSEXTPROC typedef ptr PFNGLMULTIDRAWARRAYSEXTPROC_proto
PFNGLMULTIDRAWELEMENTSEXTPROC_proto typedef proto :dword , :dword , :dword , :dword , :dword
PFNGLMULTIDRAWELEMENTSEXTPROC typedef ptr PFNGLMULTIDRAWELEMENTSEXTPROC_proto

endif ; GL_EXT_multi_draw_arrays 

;
; GL_EXT_vertex_shader
;
;  Support:
;   Rage 128 based    : Not Supported
;   Radeon 7xxx based : Not Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_EXT_vertex_shader
GL_EXT_vertex_shader                               equ 1

GL_VERTEX_SHADER_EXT                               equ 08780h
GL_VERTEX_SHADER_BINDING_EXT                       equ 08781h
GL_OP_INDEX_EXT                                    equ 08782h
GL_OP_NEGATE_EXT                                   equ 08783h
GL_OP_DOT3_EXT                                     equ 08784h
GL_OP_DOT4_EXT                                     equ 08785h
GL_OP_MUL_EXT                                      equ 08786h
GL_OP_ADD_EXT                                      equ 08787h
GL_OP_MADD_EXT                                     equ 08788h
GL_OP_FRAC_EXT                                     equ 08789h
GL_OP_MAX_EXT                                      equ 0878Ah
GL_OP_MIN_EXT                                      equ 0878Bh
GL_OP_SET_GE_EXT                                   equ 0878Ch
GL_OP_SET_LT_EXT                                   equ 0878Dh
GL_OP_CLAMP_EXT                                    equ 0878Eh
GL_OP_FLOOR_EXT                                    equ 0878Fh
GL_OP_ROUND_EXT                                    equ 08790h
GL_OP_EXP_BASE_2_EXT                               equ 08791h
GL_OP_LOG_BASE_2_EXT                               equ 08792h
GL_OP_POWER_EXT                                    equ 08793h
GL_OP_RECIP_EXT                                    equ 08794h
GL_OP_RECIP_SQRT_EXT                               equ 08795h
GL_OP_SUB_EXT                                      equ 08796h
GL_OP_CROSS_PRODUCT_EXT                            equ 08797h
GL_OP_MULTIPLY_MATRIX_EXT                          equ 08798h
GL_OP_MOV_EXT                                      equ 08799h
GL_OUTPUT_VERTEX_EXT                               equ 0879Ah
GL_OUTPUT_COLOR0_EXT                               equ 0879Bh
GL_OUTPUT_COLOR1_EXT                               equ 0879Ch
GL_OUTPUT_TEXTURE_COORD0_EXT                       equ 0879Dh
GL_OUTPUT_TEXTURE_COORD1_EXT                       equ 0879Eh
GL_OUTPUT_TEXTURE_COORD2_EXT                       equ 0879Fh
GL_OUTPUT_TEXTURE_COORD3_EXT                       equ 087A0h
GL_OUTPUT_TEXTURE_COORD4_EXT                       equ 087A1h
GL_OUTPUT_TEXTURE_COORD5_EXT                       equ 087A2h
GL_OUTPUT_TEXTURE_COORD6_EXT                       equ 087A3h
GL_OUTPUT_TEXTURE_COORD7_EXT                       equ 087A4h
GL_OUTPUT_TEXTURE_COORD8_EXT                       equ 087A5h
GL_OUTPUT_TEXTURE_COORD9_EXT                       equ 087A6h
GL_OUTPUT_TEXTURE_COORD10_EXT                      equ 087A7h
GL_OUTPUT_TEXTURE_COORD11_EXT                      equ 087A8h
GL_OUTPUT_TEXTURE_COORD12_EXT                      equ 087A9h
GL_OUTPUT_TEXTURE_COORD13_EXT                      equ 087AAh
GL_OUTPUT_TEXTURE_COORD14_EXT                      equ 087ABh
GL_OUTPUT_TEXTURE_COORD15_EXT                      equ 087ACh
GL_OUTPUT_TEXTURE_COORD16_EXT                      equ 087ADh
GL_OUTPUT_TEXTURE_COORD17_EXT                      equ 087AEh
GL_OUTPUT_TEXTURE_COORD18_EXT                      equ 087AFh
GL_OUTPUT_TEXTURE_COORD19_EXT                      equ 087B0h
GL_OUTPUT_TEXTURE_COORD20_EXT                      equ 087B1h
GL_OUTPUT_TEXTURE_COORD21_EXT                      equ 087B2h
GL_OUTPUT_TEXTURE_COORD22_EXT                      equ 087B3h
GL_OUTPUT_TEXTURE_COORD23_EXT                      equ 087B4h
GL_OUTPUT_TEXTURE_COORD24_EXT                      equ 087B5h
GL_OUTPUT_TEXTURE_COORD25_EXT                      equ 087B6h
GL_OUTPUT_TEXTURE_COORD26_EXT                      equ 087B7h
GL_OUTPUT_TEXTURE_COORD27_EXT                      equ 087B8h
GL_OUTPUT_TEXTURE_COORD28_EXT                      equ 087B9h
GL_OUTPUT_TEXTURE_COORD29_EXT                      equ 087BAh
GL_OUTPUT_TEXTURE_COORD30_EXT                      equ 087BBh
GL_OUTPUT_TEXTURE_COORD31_EXT                      equ 087BCh
GL_OUTPUT_FOG_EXT                                  equ 087BDh
GL_SCALAR_EXT                                      equ 087BEh
GL_VECTOR_EXT                                      equ 087BFh
GL_MATRIX_EXT                                      equ 087C0h
GL_VARIANT_EXT                                     equ 087C1h
GL_INVARIANT_EXT                                   equ 087C2h
GL_LOCAL_CONSTANT_EXT                              equ 087C3h
GL_LOCAL_EXT                                       equ 087C4h
GL_MAX_VERTEX_SHADER_INSTRUCTIONS_EXT              equ 087C5h
GL_MAX_VERTEX_SHADER_VARIANTS_EXT                  equ 087C6h
GL_MAX_VERTEX_SHADER_INVARIANTS_EXT                equ 087C7h
GL_MAX_VERTEX_SHADER_LOCAL_CONSTANTS_EXT           equ 087C8h
GL_MAX_VERTEX_SHADER_LOCALS_EXT                    equ 087C9h
GL_MAX_OPTIMIZED_VERTEX_SHADER_INSTRUCTIONS_EXT    equ 087CAh
GL_MAX_OPTIMIZED_VERTEX_SHADER_VARIANTS_EXT        equ 087CBh
GL_MAX_OPTIMIZED_VERTEX_SHADER_INVARIANTS_EXT      equ 087CCh
GL_MAX_OPTIMIZED_VERTEX_SHADER_LOCAL_CONSTANTS_EXT equ 087CDh
GL_MAX_OPTIMIZED_VERTEX_SHADER_LOCALS_EXT          equ 087CEh
GL_VERTEX_SHADER_INSTRUCTIONS_EXT                  equ 087CFh
GL_VERTEX_SHADER_VARIANTS_EXT                      equ 087D0h
GL_VERTEX_SHADER_INVARIANTS_EXT                    equ 087D1h
GL_VERTEX_SHADER_LOCAL_CONSTANTS_EXT               equ 087D2h
GL_VERTEX_SHADER_LOCALS_EXT                        equ 087D3h
GL_VERTEX_SHADER_OPTIMIZED_EXT                     equ 087D4h
GL_X_EXT                                           equ 087D5h
GL_Y_EXT                                           equ 087D6h
GL_Z_EXT                                           equ 087D7h
GL_W_EXT                                           equ 087D8h
GL_NEGATIVE_X_EXT                                  equ 087D9h
GL_NEGATIVE_Y_EXT                                  equ 087DAh
GL_NEGATIVE_Z_EXT                                  equ 087DBh
GL_NEGATIVE_W_EXT                                  equ 087DCh
GL_ZERO_EXT                                        equ 087DDh
GL_ONE_EXT                                         equ 087DEh
GL_NEGATIVE_ONE_EXT                                equ 087DFh
GL_NORMALIZED_RANGE_EXT                            equ 087E0h
GL_FULL_RANGE_EXT                                  equ 087E1h
GL_CURRENT_VERTEX_EXT                              equ 087E2h
GL_MVP_MATRIX_EXT                                  equ 087E3h
GL_VARIANT_VALUE_EXT                               equ 087E4h
GL_VARIANT_DATATYPE_EXT                            equ 087E5h
GL_VARIANT_ARRAY_STRIDE_EXT                        equ 087E6h
GL_VARIANT_ARRAY_TYPE_EXT                          equ 087E7h
GL_VARIANT_ARRAY_EXT                               equ 087E8h
GL_VARIANT_ARRAY_POINTER_EXT                       equ 087E9h
GL_INVARIANT_VALUE_EXT                             equ 087EAh
GL_INVARIANT_DATATYPE_EXT                          equ 087EBh
GL_LOCAL_CONSTANT_VALUE_EXT                        equ 087ECh
GL_LOCAL_CONSTANT_DATATYPE_EXT                     equ 087EDh

PFNGLBEGINVERTEXSHADEREXTPROC_proto typedef proto
PFNGLBEGINVERTEXSHADEREXTPROC typedef ptr PFNGLBEGINVERTEXSHADEREXTPROC_proto
PFNGLENDVERTEXSHADEREXTPROC_proto typedef proto
PFNGLENDVERTEXSHADEREXTPROC typedef ptr PFNGLENDVERTEXSHADEREXTPROC_proto
PFNGLBINDVERTEXSHADEREXTPROC_proto typedef proto :dword 
PFNGLBINDVERTEXSHADEREXTPROC typedef ptr PFNGLBINDVERTEXSHADEREXTPROC_proto
PFNGLGENVERTEXSHADERSEXTPROC_proto typedef proto :dword 
PFNGLGENVERTEXSHADERSEXTPROC typedef ptr PFNGLGENVERTEXSHADERSEXTPROC_proto
PFNGLDELETEVERTEXSHADEREXTPROC_proto typedef proto :dword 
PFNGLDELETEVERTEXSHADEREXTPROC typedef ptr PFNGLDELETEVERTEXSHADEREXTPROC_proto
PFNGLSHADEROP1EXTPROC_proto typedef proto :dword , :dword , :dword 
PFNGLSHADEROP1EXTPROC typedef ptr PFNGLSHADEROP1EXTPROC_proto
PFNGLSHADEROP2EXTPROC_proto typedef proto :dword , :dword , :dword , :dword 
PFNGLSHADEROP2EXTPROC typedef ptr PFNGLSHADEROP2EXTPROC_proto
PFNGLSHADEROP3EXTPROC_proto typedef proto :dword , :dword , :dword , :dword , :dword 
PFNGLSHADEROP3EXTPROC typedef ptr PFNGLSHADEROP3EXTPROC_proto
PFNGLSWIZZLEEXTPROC_proto typedef proto :dword , :dword , :dword , :dword , :dword , :dword 
PFNGLSWIZZLEEXTPROC typedef ptr PFNGLSWIZZLEEXTPROC_proto
PFNGLWRITEMASKEXTPROC_proto typedef proto :dword , :dword , :dword , :dword , :dword , :dword 
PFNGLWRITEMASKEXTPROC typedef ptr PFNGLWRITEMASKEXTPROC_proto
PFNGLINSERTCOMPONENTEXTPROC_proto typedef proto :dword , :dword , :dword 
PFNGLINSERTCOMPONENTEXTPROC typedef ptr PFNGLINSERTCOMPONENTEXTPROC_proto
PFNGLEXTRACTCOMPONENTEXTPROC_proto typedef proto :dword , :dword , :dword 
PFNGLEXTRACTCOMPONENTEXTPROC typedef ptr PFNGLEXTRACTCOMPONENTEXTPROC_proto
PFNGLGENSYMBOLSEXTPROC_proto typedef proto :dword , :dword , :dword , :dword 
PFNGLGENSYMBOLSEXTPROC typedef ptr PFNGLGENSYMBOLSEXTPROC_proto
PFNGLSETINVARIANTEXTPROC_proto typedef proto :dword , :dword , :dword 
PFNGLSETINVARIANTEXTPROC typedef ptr PFNGLSETINVARIANTEXTPROC_proto
PFNGLSETLOCALCONSTANTEXTPROC_proto typedef proto :dword , :dword , :dword 
PFNGLSETLOCALCONSTANTEXTPROC typedef ptr PFNGLSETLOCALCONSTANTEXTPROC_proto
PFNGLVARIANTBVEXTPROC_proto typedef proto :dword , :dword 
PFNGLVARIANTBVEXTPROC typedef ptr PFNGLVARIANTBVEXTPROC_proto
PFNGLVARIANTSVEXTPROC_proto typedef proto :dword , :dword 
PFNGLVARIANTSVEXTPROC typedef ptr PFNGLVARIANTSVEXTPROC_proto
PFNGLVARIANTIVEXTPROC_proto typedef proto :dword , :dword 
PFNGLVARIANTIVEXTPROC typedef ptr PFNGLVARIANTIVEXTPROC_proto
PFNGLVARIANTFVEXTPROC_proto typedef proto :dword , :dword 
PFNGLVARIANTFVEXTPROC typedef ptr PFNGLVARIANTFVEXTPROC_proto
PFNGLVARIANTDVEXTPROC_proto typedef proto :dword , :dword 
PFNGLVARIANTDVEXTPROC typedef ptr PFNGLVARIANTDVEXTPROC_proto
PFNGLVARIANTUBVEXTPROC_proto typedef proto :dword , :dword 
PFNGLVARIANTUBVEXTPROC typedef ptr PFNGLVARIANTUBVEXTPROC_proto
PFNGLVARIANTUSVEXTPROC_proto typedef proto :dword , :dword 
PFNGLVARIANTUSVEXTPROC typedef ptr PFNGLVARIANTUSVEXTPROC_proto
PFNGLVARIANTUIVEXTPROC_proto typedef proto :dword , :dword 
PFNGLVARIANTUIVEXTPROC typedef ptr PFNGLVARIANTUIVEXTPROC_proto
PFNGLVARIANTPOINTEREXTPROC_proto typedef proto :dword , :dword , :dword , :dword 
PFNGLVARIANTPOINTEREXTPROC typedef ptr PFNGLVARIANTPOINTEREXTPROC_proto
PFNGLENABLEVARIANTCLIENTSTATEEXTPROC_proto typedef proto :dword 
PFNGLENABLEVARIANTCLIENTSTATEEXTPROC typedef ptr PFNGLENABLEVARIANTCLIENTSTATEEXTPROC_proto
PFNGLDISABLEVARIANTCLIENTSTATEEXTPROC_proto typedef proto :dword 
PFNGLDISABLEVARIANTCLIENTSTATEEXTPROC typedef ptr PFNGLDISABLEVARIANTCLIENTSTATEEXTPROC_proto
PFNGLBINDLIGHTPARAMETEREXTPROC_proto typedef proto :dword , :dword 
PFNGLBINDLIGHTPARAMETEREXTPROC typedef ptr PFNGLBINDLIGHTPARAMETEREXTPROC_proto
PFNGLBINDMATERIALPARAMETEREXTPROC_proto typedef proto :dword , :dword 
PFNGLBINDMATERIALPARAMETEREXTPROC typedef ptr PFNGLBINDMATERIALPARAMETEREXTPROC_proto
PFNGLBINDTEXGENPARAMETEREXTPROC_proto typedef proto :dword , :dword , :dword 
PFNGLBINDTEXGENPARAMETEREXTPROC typedef ptr PFNGLBINDTEXGENPARAMETEREXTPROC_proto
PFNGLBINDTEXTUREUNITPARAMETEREXTPROC_proto typedef proto :dword , :dword 
PFNGLBINDTEXTUREUNITPARAMETEREXTPROC typedef ptr PFNGLBINDTEXTUREUNITPARAMETEREXTPROC_proto
PFNGLBINDPARAMETEREXTPROC_proto typedef proto :dword 
PFNGLBINDPARAMETEREXTPROC typedef ptr PFNGLBINDPARAMETEREXTPROC_proto
PFNGLISVARIANTENABLEDEXTPROC_proto typedef proto :dword , :dword 
PFNGLISVARIANTENABLEDEXTPROC typedef ptr PFNGLISVARIANTENABLEDEXTPROC_proto
PFNGLGETVARIANTBOOLEANVEXTPROC_proto typedef proto :dword , :dword , :dword 
PFNGLGETVARIANTBOOLEANVEXTPROC typedef ptr PFNGLGETVARIANTBOOLEANVEXTPROC_proto
PFNGLGETVARIANTINTEGERVEXTPROC_proto typedef proto :dword , :dword , :dword 
PFNGLGETVARIANTINTEGERVEXTPROC typedef ptr PFNGLGETVARIANTINTEGERVEXTPROC_proto
PFNGLGETVARIANTFLOATVEXTPROC_proto typedef proto :dword , :dword , :dword 
PFNGLGETVARIANTFLOATVEXTPROC typedef ptr PFNGLGETVARIANTFLOATVEXTPROC_proto
PFNGLGETVARIANTPOINTERVEXTPROC_proto typedef proto :dword , :dword , :dword
PFNGLGETVARIANTPOINTERVEXTPROC typedef ptr PFNGLGETVARIANTPOINTERVEXTPROC_proto
PFNGLGETINVARIANTBOOLEANVEXTPROC_proto typedef proto :dword , :dword , :dword 
PFNGLGETINVARIANTBOOLEANVEXTPROC typedef ptr PFNGLGETINVARIANTBOOLEANVEXTPROC_proto
PFNGLGETINVARIANTINTEGERVEXTPROC_proto typedef proto :dword , :dword , :dword 
PFNGLGETINVARIANTINTEGERVEXTPROC typedef ptr PFNGLGETINVARIANTINTEGERVEXTPROC_proto
PFNGLGETINVARIANTFLOATVEXTPROC_proto typedef proto :dword , :dword , :dword 
PFNGLGETINVARIANTFLOATVEXTPROC typedef ptr PFNGLGETINVARIANTFLOATVEXTPROC_proto
PFNGLGETLOCALCONSTANTBOOLEANVEXTPROC_proto typedef proto :dword , :dword , :dword 
PFNGLGETLOCALCONSTANTBOOLEANVEXTPROC typedef ptr PFNGLGETLOCALCONSTANTBOOLEANVEXTPROC_proto
PFNGLGETLOCALCONSTANTINTEGERVEXTPROC_proto typedef proto :dword , :dword , :dword 
PFNGLGETLOCALCONSTANTINTEGERVEXTPROC typedef ptr PFNGLGETLOCALCONSTANTINTEGERVEXTPROC_proto
PFNGLGETLOCALCONSTANTFLOATVEXTPROC_proto typedef proto :dword , :dword , :dword 
PFNGLGETLOCALCONSTANTFLOATVEXTPROC typedef ptr PFNGLGETLOCALCONSTANTFLOATVEXTPROC_proto

endif ; GL_EXT_vertex_shader 


;
;  IHV EXTENSIONS
;

;
; GL_NV_occlusion_query
;
; Support:
;
;   Rage 128 based    : Not Supported
;   Radeon 7xxx based : Not Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_NV_occlusion_query
GL_NV_occlusion_query              equ 1

GL_PIXEL_COUNTER_BITS_NV           equ 08864h
GL_CURRENT_OCCLUSION_QUERY_ID_NV   equ 08865h
GL_PIXEL_COUNT_NV                  equ 08866h
GL_PIXEL_COUNT_AVAILABLE_NV        equ 08867h

PFNGLGENOCCLUSIONQUERIESNVPROC_proto typedef proto :dword , :dword 
PFNGLGENOCCLUSIONQUERIESNVPROC typedef ptr PFNGLGENOCCLUSIONQUERIESNVPROC_proto
PFNGLDELETEOCCLUSIONQUERIESNVPROC_proto typedef proto :dword , :dword 
PFNGLDELETEOCCLUSIONQUERIESNVPROC typedef ptr PFNGLDELETEOCCLUSIONQUERIESNVPROC_proto
PFNGLISOCCLUSIONQUERYNVPROC_proto typedef proto :dword 
PFNGLISOCCLUSIONQUERYNVPROC typedef ptr PFNGLISOCCLUSIONQUERYNVPROC_proto
PFNGLBEGINOCCLUSIONQUERYNVPROC_proto typedef proto :dword 
PFNGLBEGINOCCLUSIONQUERYNVPROC typedef ptr PFNGLBEGINOCCLUSIONQUERYNVPROC_proto
PFNGLENDOCCLUSIONQUERYNVPROC_proto typedef proto
PFNGLENDOCCLUSIONQUERYNVPROC typedef ptr PFNGLENDOCCLUSIONQUERYNVPROC_proto
PFNGLGETOCCLUSIONQUERYIVNVPROC_proto typedef proto :dword , :dword , :dword 
PFNGLGETOCCLUSIONQUERYIVNVPROC typedef ptr PFNGLGETOCCLUSIONQUERYIVNVPROC_proto
PFNGLGETOCCLUSIONQUERYUIVNVPROC_proto typedef proto :dword , :dword , :dword 
PFNGLGETOCCLUSIONQUERYUIVNVPROC typedef ptr PFNGLGETOCCLUSIONQUERYUIVNVPROC_proto

endif ; GL_NV_occlusion_query 

;
; GL_NV_texgen_reflection
;
;  Support:
;   Rage 128 based    : Supported
;   Radeon 7xxx based : Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_NV_texgen_reflection
GL_NV_texgen_reflection              equ 1

GL_NORMAL_MAP_NV                     equ 08511h
GL_REFLECTION_MAP_NV                 equ 08512h

endif ; GL_NV_texgen_reflection 

;
; GL_ARB_point_sprite
;
;  Support:
;   Rage 128 based    : Not Supported
;   Radeon 7xxx based : Not Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_ARB_point_sprite
GL_ARB_point_sprite equ 1

GL_POINT_SPRITE_ARB equ 08861h
GL_COORD_REPLACE_ARB equ 08862h

endif ; GL_ARB_point_sprite

;
; GL_NV_point_sprite
;
;  Support:
;   Rage 128 based    : Not Supported
;   Radeon 7xxx based : Not Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_NV_point_sprite
GL_NV_point_sprite                   equ 1

GL_POINT_SPRITE_NV                   equ 08861h
GL_COORD_REPLACE_NV                  equ 08862h
GL_POINT_SPRITE_R_MODE_NV            equ 08863h

PFNGLPOINTPARAMETERINVPROC_proto typedef proto :dword , :dword 
PFNGLPOINTPARAMETERINVPROC typedef ptr PFNGLPOINTPARAMETERINVPROC_proto
PFNGLPOINTPARAMETERIVNVPROC_proto typedef proto :dword , :dword 
PFNGLPOINTPARAMETERIVNVPROC typedef ptr PFNGLPOINTPARAMETERIVNVPROC_proto

endif ; GL_NV_point_sprite 

;
; GL_NV_blend_square
;
;  Support:
;   Radeon    * based : Supported
;   Radeon 8xxx based : Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_NV_blend_square
GL_NV_blend_square                   equ 1

endif ; GL_NV_blend_square 

;
; GL_S3_s3tc
;
;  Support:
;   Rage 128 based    : Not Supported
;   Radeon 7xxx based : Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_S3_s3tc
GL_S3_s3tc                           equ 1

GL_RGB_S3TC                          equ 083A0h
GL_RGB4_S3TC                         equ 083A1h
GL_RGBA_S3TC                         equ 083A2h
GL_RGBA4_S3TC                        equ 083A3h

endif ; GL_S3_s3tc 

;
; GL_SGIS_texture_edge_clamp
;
;  Support:
;   Rage 128 based    : Supported
;   Radeon 7xxx based : Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_SGIS_texture_edge_clamp
GL_SGIS_texture_edge_clamp            equ 1

GL_CLAMP_TO_EDGE_SGIS                 equ 0812Fh

endif ; GL_SGIS_texture_edge_clamp 

;
; GL_SGI_color_matrix
;
;  Support:
;   Rage 128 based    : Supported
;   Radeon 7xxx based : Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_SGI_color_matrix
GL_SGI_color_matrix                     equ 1

GL_COLOR_MATRIX_SGI                     equ 080B1h
GL_COLOR_MATRIX_STACK_DEPTH_SGI         equ 080B2h
GL_MAX_COLOR_MATRIX_STACK_DEPTH_SGI     equ 080B3h
GL_POST_COLOR_MATRIX_RED_SCALE_SGI      equ 080B4h
GL_POST_COLOR_MATRIX_GREEN_SCALE_SGI    equ 080B5h
GL_POST_COLOR_MATRIX_BLUE_SCALE_SGI     equ 080B6h
GL_POST_COLOR_MATRIX_ALPHA_SCALE_SGI    equ 080B7h
GL_POST_COLOR_MATRIX_RED_BIAS_SGI       equ 080B8h
GL_POST_COLOR_MATRIX_GREEN_BIAS_SGI     equ 080B9h
GL_POST_COLOR_MATRIX_BLUE_BIAS_SGI      equ 080BAh
GL_POST_COLOR_MATRIX_ALPHA_BIAS_SGI     equ 080BBh

endif ; GL_SGI_color_matrix 

;
; GL_SGIS_generate_mipmap
;
;  Support:
;   Rage 128 based    : Not supported
;   Radeon 7xxx based : Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_SGIS_generate_mipmap
GL_SGIS_generate_mipmap              equ 1

GL_GENERATE_MIPMAP_SGIS              equ 08191h
GL_GENERATE_MIPMAP_HINT_SGIS	     equ 08192h
;GL_GENERATE_MIPMAP                   equ 08191h
;GL_GENERATE_MIPMAP_HINT_SGIS         equ 08192h
;GL_GENERATE_MIPMAP_HINT              equ 08192h

endif ; GL_SGIS_generate_mipmap 

;
; GL_SGIS_multitexture
;
;  Support:
;   Rage 128 based    : Supported
;   Radeon 7xxx based : Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_SGIS_multitexture
GL_SGIS_multitexture                equ 1

TEXTURE0_SGIS                       equ 0835Eh
TEXTURE1_SGIS                       equ 0835Fh
GL_SELECTED_TEXTURE_SGIS            equ 083C0h
GL_SELECTED_TEXTURE_COORD_SET_SGIS  equ 083C1h
GL_SELECTED_TEXTURE_TRANSFORM_SGIS  equ 083C2h
GL_MAX_TEXTURES_SGIS                equ 083C3h
GL_MAX_TEXTURE_COORD_SETS_SGIS      equ 083C4h
GL_TEXTURE_ENV_COORD_SET_SGIS       equ 083C5h
GL_TEXTURE0_SGIS                    equ 083C6h
GL_TEXTURE1_SGIS                    equ 083C7h
GL_TEXTURE2_SGIS                    equ 083C8h
GL_TEXTURE3_SGIS                    equ 083C9h
GL_TEXTURE4_SGIS                    equ 083CAh
GL_TEXTURE5_SGIS                    equ 083CBh
GL_TEXTURE6_SGIS                    equ 083CCh
GL_TEXTURE7_SGIS                    equ 083CDh
GL_TEXTURE8_SGIS                    equ 083CEh
GL_TEXTURE9_SGIS                    equ 083CFh
GL_TEXTURE10_SGIS                   equ 083D0h
GL_TEXTURE11_SGIS                   equ 083D1h
GL_TEXTURE12_SGIS                   equ 083D2h
GL_TEXTURE13_SGIS                   equ 083D3h
GL_TEXTURE14_SGIS                   equ 083D4h
GL_TEXTURE15_SGIS                   equ 083D5h
GL_TEXTURE16_SGIS                   equ 083D6h
GL_TEXTURE17_SGIS                   equ 083D7h
GL_TEXTURE18_SGIS                   equ 083D8h
GL_TEXTURE19_SGIS                   equ 083D9h
GL_TEXTURE20_SGIS                   equ 083DAh
GL_TEXTURE21_SGIS                   equ 083DBh
GL_TEXTURE22_SGIS                   equ 083DCh
GL_TEXTURE23_SGIS                   equ 083DDh
GL_TEXTURE24_SGIS                   equ 083DEh
GL_TEXTURE25_SGIS                   equ 083DFh
GL_TEXTURE26_SGIS                   equ 083E0h
GL_TEXTURE27_SGIS                   equ 083E1h
GL_TEXTURE28_SGIS                   equ 083E2h
GL_TEXTURE29_SGIS                   equ 083E3h
GL_TEXTURE30_SGIS                   equ 083E4h
GL_TEXTURE31_SGIS                   equ 083E5h

PFNGLSELECTTEXTURESGISPROC_proto typedef proto :dword 
PFNGLSELECTTEXTURESGISPROC typedef ptr PFNGLSELECTTEXTURESGISPROC_proto
PFNGLSELECTTEXTURETRANSFORMSGISPROC_proto typedef proto :dword 
PFNGLSELECTTEXTURETRANSFORMSGISPROC typedef ptr PFNGLSELECTTEXTURETRANSFORMSGISPROC_proto
PFNGLSELECTTEXTURECOORDSETSGISPROC_proto typedef proto :dword 
PFNGLSELECTTEXTURECOORDSETSGISPROC typedef ptr PFNGLSELECTTEXTURECOORDSETSGISPROC_proto
PFNGLMULTITEXCOORD1DSGISPROC_proto typedef proto :dword , :real8
PFNGLMULTITEXCOORD1DSGISPROC typedef ptr PFNGLMULTITEXCOORD1DSGISPROC_proto
PFNGLMULTITEXCOORD1DVSGISPROC_proto typedef proto :dword , :dword 
PFNGLMULTITEXCOORD1DVSGISPROC typedef ptr PFNGLMULTITEXCOORD1DVSGISPROC_proto
PFNGLMULTITEXCOORD1FSGISPROC_proto typedef proto :dword , :real4
PFNGLMULTITEXCOORD1FSGISPROC typedef ptr PFNGLMULTITEXCOORD1FSGISPROC_proto
PFNGLMULTITEXCOORD1FVSGISPROC_proto typedef proto :dword , :dword 
PFNGLMULTITEXCOORD1FVSGISPROC typedef ptr PFNGLMULTITEXCOORD1FVSGISPROC_proto
PFNGLMULTITEXCOORD1ISGISPROC_proto typedef proto :dword , :dword 
PFNGLMULTITEXCOORD1ISGISPROC typedef ptr PFNGLMULTITEXCOORD1ISGISPROC_proto
PFNGLMULTITEXCOORD1IVSGISPROC_proto typedef proto :dword , :dword 
PFNGLMULTITEXCOORD1IVSGISPROC typedef ptr PFNGLMULTITEXCOORD1IVSGISPROC_proto
PFNGLMULTITEXCOORD1SSGISPROC_proto typedef proto :dword , :dword 
PFNGLMULTITEXCOORD1SSGISPROC typedef ptr PFNGLMULTITEXCOORD1SSGISPROC_proto
PFNGLMULTITEXCOORD1SVSGISPROC_proto typedef proto :dword , :dword 
PFNGLMULTITEXCOORD1SVSGISPROC typedef ptr PFNGLMULTITEXCOORD1SVSGISPROC_proto
PFNGLMULTITEXCOORD2DSGISPROC_proto typedef proto :dword , :real8 , :real8
PFNGLMULTITEXCOORD2DSGISPROC typedef ptr PFNGLMULTITEXCOORD2DSGISPROC_proto
PFNGLMULTITEXCOORD2DVSGISPROC_proto typedef proto :dword , :dword 
PFNGLMULTITEXCOORD2DVSGISPROC typedef ptr PFNGLMULTITEXCOORD2DVSGISPROC_proto
PFNGLMULTITEXCOORD2FSGISPROC_proto typedef proto :dword , :real4 , :real4
PFNGLMULTITEXCOORD2FSGISPROC typedef ptr PFNGLMULTITEXCOORD2FSGISPROC_proto
PFNGLMULTITEXCOORD2FVSGISPROC_proto typedef proto :dword , :dword 
PFNGLMULTITEXCOORD2FVSGISPROC typedef ptr PFNGLMULTITEXCOORD2FVSGISPROC_proto
PFNGLMULTITEXCOORD2ISGISPROC_proto typedef proto :dword , :dword , :dword 
PFNGLMULTITEXCOORD2ISGISPROC typedef ptr PFNGLMULTITEXCOORD2ISGISPROC_proto
PFNGLMULTITEXCOORD2IVSGISPROC_proto typedef proto :dword , :dword 
PFNGLMULTITEXCOORD2IVSGISPROC typedef ptr PFNGLMULTITEXCOORD2IVSGISPROC_proto
PFNGLMULTITEXCOORD2SSGISPROC_proto typedef proto :dword , :dword , :dword 
PFNGLMULTITEXCOORD2SSGISPROC typedef ptr PFNGLMULTITEXCOORD2SSGISPROC_proto
PFNGLMULTITEXCOORD2SVSGISPROC_proto typedef proto :dword , :dword 
PFNGLMULTITEXCOORD2SVSGISPROC typedef ptr PFNGLMULTITEXCOORD2SVSGISPROC_proto
PFNGLMULTITEXCOORD3DSGISPROC_proto typedef proto :dword , :real8, :real8 , :real8 
PFNGLMULTITEXCOORD3DSGISPROC typedef ptr PFNGLMULTITEXCOORD3DSGISPROC_proto
PFNGLMULTITEXCOORD3DVSGISPROC_proto typedef proto :dword , :dword 
PFNGLMULTITEXCOORD3DVSGISPROC typedef ptr PFNGLMULTITEXCOORD3DVSGISPROC_proto
PFNGLMULTITEXCOORD3FSGISPROC_proto typedef proto :dword , :real4 , :real4 , :real4 
PFNGLMULTITEXCOORD3FSGISPROC typedef ptr PFNGLMULTITEXCOORD3FSGISPROC_proto
PFNGLMULTITEXCOORD3FVSGISPROC_proto typedef proto :dword , :dword 
PFNGLMULTITEXCOORD3FVSGISPROC typedef ptr PFNGLMULTITEXCOORD3FVSGISPROC_proto
PFNGLMULTITEXCOORD3ISGISPROC_proto typedef proto :dword , :dword , :dword , :dword 
PFNGLMULTITEXCOORD3ISGISPROC typedef ptr PFNGLMULTITEXCOORD3ISGISPROC_proto
PFNGLMULTITEXCOORD3IVSGISPROC_proto typedef proto :dword , :dword 
PFNGLMULTITEXCOORD3IVSGISPROC typedef ptr PFNGLMULTITEXCOORD3IVSGISPROC_proto
PFNGLMULTITEXCOORD3SSGISPROC_proto typedef proto :dword , :dword , :dword , :dword 
PFNGLMULTITEXCOORD3SSGISPROC typedef ptr PFNGLMULTITEXCOORD3SSGISPROC_proto
PFNGLMULTITEXCOORD3SVSGISPROC_proto typedef proto :dword , :dword 
PFNGLMULTITEXCOORD3SVSGISPROC typedef ptr PFNGLMULTITEXCOORD3SVSGISPROC_proto
PFNGLMULTITEXCOORD4DSGISPROC_proto typedef proto :dword , :real8 , :real8 , :real8 , :real8 
PFNGLMULTITEXCOORD4DSGISPROC typedef ptr PFNGLMULTITEXCOORD4DSGISPROC_proto
PFNGLMULTITEXCOORD4DVSGISPROC_proto typedef proto :dword , :dword 
PFNGLMULTITEXCOORD4DVSGISPROC typedef ptr PFNGLMULTITEXCOORD4DVSGISPROC_proto
PFNGLMULTITEXCOORD4FSGISPROC_proto typedef proto :dword , :real4 , :real4 , :real4 , :real4 
PFNGLMULTITEXCOORD4FSGISPROC typedef ptr PFNGLMULTITEXCOORD4FSGISPROC_proto
PFNGLMULTITEXCOORD4FVSGISPROC_proto typedef proto :dword , :dword 
PFNGLMULTITEXCOORD4FVSGISPROC typedef ptr PFNGLMULTITEXCOORD4FVSGISPROC_proto
PFNGLMULTITEXCOORD4ISGISPROC_proto typedef proto :dword , :dword , :dword , :dword , :dword 
PFNGLMULTITEXCOORD4ISGISPROC typedef ptr PFNGLMULTITEXCOORD4ISGISPROC_proto
PFNGLMULTITEXCOORD4IVSGISPROC_proto typedef proto :dword , :dword 
PFNGLMULTITEXCOORD4IVSGISPROC typedef ptr PFNGLMULTITEXCOORD4IVSGISPROC_proto
PFNGLMULTITEXCOORD4SSGISPROC_proto typedef proto :dword , :dword , :dword , :dword , :dword 
PFNGLMULTITEXCOORD4SSGISPROC typedef ptr PFNGLMULTITEXCOORD4SSGISPROC_proto
PFNGLMULTITEXCOORD4SVSGISPROC_proto typedef proto :dword , :dword 
PFNGLMULTITEXCOORD4SVSGISPROC typedef ptr PFNGLMULTITEXCOORD4SVSGISPROC_proto

endif ; GL_SGIS_multitexture 

;
; GL_SGIS_texture_border_clamp
;
;  Support:
;   Rage 128 based    : Supported
;   Radeon 7xxx based : Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_SGIS_texture_border_clamp
GL_SGIS_texture_border_clamp         equ 1

GL_CLAMP_TO_BORDER_SGIS              equ 0812Dh

endif

;
; GL_SGIS_texture_lod
;
;  Support:
;   Rage 128 based    : Supported
;   Radeon 7xxx based : Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_SGIS_texture_lod
GL_SGIS_texture_lod                  equ 1

GL_TEXTURE_MIN_LOD_SGIS              equ 0813Ah
GL_TEXTURE_MAX_LOD_SGIS              equ 0813Bh
GL_TEXTURE_BASE_LEVEL_SGIS           equ 0813Ch
GL_TEXTURE_MAX_LEVEL_SGIS            equ 0813Dh

endif ; GL_SGIS_texture_lod 


;
;  ISV EXTENSIONS
;

;
; GL_KTX_buffer_region
;
;  Support:
;   Rage 128 based    : Supported
;   Radeon 7xxx based : Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_KTX_buffer_region
GL_KTX_buffer_region                 equ 1

GL_KTX_FRONT_REGION                  equ 00h
GL_KTX_BACK_REGION                   equ 01h
GL_KTX_Z_REGION                      equ 02h
GL_KTX_STENCIL_REGION                equ 03h

PFNGLBUFFERREGIONENABLEDEXTPROC_proto typedef proto
PFNGLBUFFERREGIONENABLEDEXTPROC typedef ptr PFNGLBUFFERREGIONENABLEDEXTPROC_proto
PFNGLNEWBUFFERREGIONEXTPROC_proto typedef proto :dword 
PFNGLNEWBUFFERREGIONEXTPROC typedef ptr PFNGLNEWBUFFERREGIONEXTPROC_proto
PFNGLDELETEBUFFERREGIONEXTPROC_proto typedef proto :dword
PFNGLDELETEBUFFERREGIONEXTPROC typedef ptr PFNGLDELETEBUFFERREGIONEXTPROC_proto
PFNGLREADBUFFERREGIONEXTPROC_proto typedef proto :dword , :dword , :dword , :dword , :dword 
PFNGLREADBUFFERREGIONEXTPROC typedef ptr PFNGLREADBUFFERREGIONEXTPROC_proto
PFNGLDRAWBUFFERREGIONEXTPROC_proto typedef proto :dword , :dword , :dword , :dword , :dword , :dword , :dword 
PFNGLDRAWBUFFERREGIONEXTPROC typedef ptr PFNGLDRAWBUFFERREGIONEXTPROC_proto

endif ; GL_KTX_buffer_region 


;
; GL_WIN_swap_hint
;
;  Support:
;   Rage 128 based    : Supported
;   Radeon 7xxx based : Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_WIN_swap_hint
GL_WIN_swap_hint                     equ 1

PFNGLADDSWAPHINTRECTWINPROC_proto typedef proto :dword , :dword , :dword , :dword 
PFNGLADDSWAPHINTRECTWINPROC typedef ptr PFNGLADDSWAPHINTRECTWINPROC_proto

endif ; GL_WIN_swap_hint 


;
; GL_SUN_multi_draw_arrays
;
;  Support:
;   Rage 128 based    : Supported
;   Radeon 7xxx based : Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_SUN_multi_draw_arrays
GL_SUN_multi_draw_arrays			  equ 1

PFNGLMULTIDRAWARRAYSSUNPROC_proto typedef proto :dword , :dword , :dword , :dword 
PFNGLMULTIDRAWARRAYSSUNPROC typedef ptr PFNGLMULTIDRAWARRAYSSUNPROC_proto
PFNGLMULTIDRAWELEMENTSSUNPROC_proto typedef proto :dword , :dword , :dword , :dword , :dword 
PFNGLMULTIDRAWELEMENTSSUNPROC typedef ptr PFNGLMULTIDRAWELEMENTSSUNPROC_proto

endif ; GL_SUN_multi_draw_arrays 

;
; HP_occlusion_test
;
; Support:
;   Rage 128 based    : Not Supported
;   Radeon 7xxx based : Not Supported
;   Radeon 8xxx based : Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_HP_occlusion_test
GL_HP_occlusion_test                 equ 1

GL_OCCLUSION_TEST_HP                 equ 08165h
GL_OCCLUSION_TEST_RESULT_HP          equ 08166h

endif  ; HP_occlusion_test 

ifndef GL_ATI_texture_float
GL_ATI_texture_float                equ 1

GL_RGBA_FLOAT32_ATI                 equ 08814h
GL_RGB_FLOAT32_ATI                  equ 08815h
GL_ALPHA_FLOAT32_ATI                equ 08816h
GL_INTENSITY_FLOAT32_ATI            equ 08817h
GL_LUMINANCE_FLOAT32_ATI            equ 08818h
GL_LUMINANCE_ALPHA_FLOAT32_ATI      equ 08819h
GL_RGBA_FLOAT16_ATI                 equ 0881Ah
GL_RGB_FLOAT16_ATI                  equ 0881Bh
GL_ALPHA_FLOAT16_ATI                equ 0881Ch
GL_INTENSITY_FLOAT16_ATI            equ 0881Dh
GL_LUMINANCE_FLOAT16_ATI            equ 0881Eh
GL_LUMINANCE_ALPHA_FLOAT16_ATI      equ 0881Fh
endif

ifndef GL_ATI_r_rg
GL_ATI_r_rg equ 1
GL_R_FLOAT32_ATI equ 08838h
GL_RG_FLOAT32_ATI equ 08839h
GL_R_FLOAT16_ATI equ 0883Ah
GL_RG_FLOAT16_ATI equ 0883Bh
GL_RG_ATI equ 0883Ch
endif

ifndef GL_ATI_mapped_texture
GL_ATI_mapped_texture equ 1

PFNGLMAPTEXTURE3DPROC_proto typedef proto :dword, :dword
PFNGLMAPTEXTURE3DPROC typedef ptr PFNGLMAPTEXTURE3DPROC_proto

PFNGLUNMAPTEXTURE3DPROC_proto typedef proto
PFNGLUNMAPTEXTURE3DPROC typedef ptr PFNGLUNMAPTEXTURE3DPROC_proto

; This needs to have real enums assigned
GL_MAPPED_TEXTURE_PIXEL_STRIDE_ATI equ 08820h
GL_MAPPED_TEXTURE_ROW_STRIDE_ATI equ 08821h
GL_MAPPED_TEXTURE_LAYER_STRIDE_ATI equ 08822h

endif ; GL_ATI_mapped_texture

ifndef GL_ATI_timestamp
GL_ATI_timestamp equ 1

PFNGLNEWTIMESTAMPPROC_proto typedef proto :dword
PFNGLNEWTIMESTAMPPROC typedef ptr PFNGLNEWTIMESTAMPPROC_proto

PFNGLDELETETIMESTAMPPROC_proto typedef proto :dword
PFNGLDELETETIMESTAMPPROC typedef ptr PFNGLDELETETIMESTAMPPROC_proto

PFNGLSENDTIMESTAMPPROC_proto typedef proto :dword
PFNGLSENDTIMESTAMPPROC typedef ptr PFNGLSENDTIMESTAMPPROC_proto

PFNGLWAITTIMESTAMPPROC_proto typedef proto :dword
PFNGLWAITTIMESTAMPPROC typedef ptr PFNGLWAITTIMESTAMPPROC_proto

endif ; GL_ATI_timestamp

;
; GL_ATI_draw_buffers
;
ifndef GL_ATI_draw_buffers
GL_ATI_draw_buffers     equ 1
;
; requires GL_ARB_fragment_program
;

GL_MAX_DRAW_BUFFERS_ATI equ 08824h
GL_DRAW_BUFFER0_ATI     equ 08825h
GL_DRAW_BUFFER1_ATI     equ 08826h
GL_DRAW_BUFFER2_ATI     equ 08827h
GL_DRAW_BUFFER3_ATI     equ 08828h
GL_DRAW_BUFFER4_ATI     equ 08829h
GL_DRAW_BUFFER5_ATI     equ 0882Ah
GL_DRAW_BUFFER6_ATI     equ 0882Bh
GL_DRAW_BUFFER7_ATI     equ 0882Ch
GL_DRAW_BUFFER8_ATI     equ 0882Dh
GL_DRAW_BUFFER9_ATI     equ 0882Eh
GL_DRAW_BUFFER10_ATI    equ 0882Fh
GL_DRAW_BUFFER11_ATI    equ 08830h
GL_DRAW_BUFFER12_ATI    equ 08831h
GL_DRAW_BUFFER13_ATI    equ 08832h
GL_DRAW_BUFFER14_ATI    equ 08833h
GL_DRAW_BUFFER15_ATI    equ 08834h

PFNGLDRAWBUFFERS_proto typedef proto :dword , :dword
PFNGLDRAWBUFFERS typedef ptr PFNGLDRAWBUFFERS_proto

endif ; GL_ATI_draw_buffers

;
; GL_ARB_draw_buffers
;
ifndef GL_ARB_draw_buffers
GL_ARB_draw_buffers equ 1
;
; requires GL_ARB_fragment_program
;

GL_MAX_DRAW_BUFFERS_ARB equ 08824h
GL_DRAW_BUFFER0_ARB equ 08825h
GL_DRAW_BUFFER1_ARB equ 08826h
GL_DRAW_BUFFER2_ARB equ 08827h
GL_DRAW_BUFFER3_ARB equ 08828h
GL_DRAW_BUFFER4_ARB equ 08829h
GL_DRAW_BUFFER5_ARB equ 0882Ah
GL_DRAW_BUFFER6_ARB equ 0882Bh
GL_DRAW_BUFFER7_ARB equ 0882Ch
GL_DRAW_BUFFER8_ARB equ 0882Dh
GL_DRAW_BUFFER9_ARB equ 0882Eh
GL_DRAW_BUFFER10_ARB equ 0882Fh
GL_DRAW_BUFFER11_ARB equ 08830h
GL_DRAW_BUFFER12_ARB equ 08831h
GL_DRAW_BUFFER13_ARB equ 08832h
GL_DRAW_BUFFER14_ARB equ 08833h
GL_DRAW_BUFFER15_ARB equ 08834h

PFNGLDRAWBUFFERSARBPROC_proto typedef proto :dword , :dword
PFNGLDRAWBUFFERSARBPROC typedef ptr PFNGLDRAWBUFFERSARBPROC_proto

endif ; GL_ARB_draw_buffers

;
; GL_ARB_half_float_pixel
;
ifndef GL_ARB_half_float_pixel
GL_ARB_half_float_pixel equ 1

GL_HALF_FLOAT_ARB equ 0140Bh

endif ; GL_ARB_half_float_pixel

;
; GL_ARB_imaging
;
; Support:
;   Rage 128 based    : Not Supported
;   Radeon 7xxx based : Not Supported
;   Radeon 8xxx based : Not Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_ARB_imaging
GL_ARB_imaging equ 1

GL_CONSTANT_COLOR equ 08001h
GL_ONE_MINUS_CONSTANT_COLOR equ 08002h
GL_CONSTANT_ALPHA equ 08003h
GL_ONE_MINUS_CONSTANT_ALPHA equ 08004h
GL_BLEND_COLOR equ 08005h
GL_FUNC_ADD equ 08006h
GL_MIN equ 08007h
GL_MAX equ 08008h
GL_BLEND_EQUATION equ 08009h
GL_FUNC_SUBTRACT equ 0800Ah
GL_FUNC_REVERSE_SUBTRACT equ 0800Bh
GL_CONVOLUTION_1D equ 08010h
GL_CONVOLUTION_2D equ 08011h
GL_SEPARABLE_2D equ 08012h
GL_CONVOLUTION_BORDER_MODE equ 08013h
GL_CONVOLUTION_FILTER_SCALE equ 08014h
GL_CONVOLUTION_FILTER_BIAS equ 08015h
GL_REDUCE equ 08016h
GL_CONVOLUTION_FORMAT equ 08017h
GL_CONVOLUTION_WIDTH equ 08018h
GL_CONVOLUTION_HEIGHT equ 08019h
GL_MAX_CONVOLUTION_WIDTH equ 0801Ah
GL_MAX_CONVOLUTION_HEIGHT equ 0801Bh
GL_POST_CONVOLUTION_RED_SCALE equ 0801Ch
GL_POST_CONVOLUTION_GREEN_SCALE equ 0801Dh
GL_POST_CONVOLUTION_BLUE_SCALE equ 0801Eh
GL_POST_CONVOLUTION_ALPHA_SCALE equ 0801Fh
GL_POST_CONVOLUTION_RED_BIAS equ 08020h
GL_POST_CONVOLUTION_GREEN_BIAS equ 08021h
GL_POST_CONVOLUTION_BLUE_BIAS equ 08022h
GL_POST_CONVOLUTION_ALPHA_BIAS equ 08023h
GL_HISTOGRAM equ 08024h
GL_PROXY_HISTOGRAM equ 08025h
GL_HISTOGRAM_WIDTH equ 08026h
GL_HISTOGRAM_FORMAT equ 08027h
GL_HISTOGRAM_RED_SIZE equ 08028h
GL_HISTOGRAM_GREEN_SIZE equ 08029h
GL_HISTOGRAM_BLUE_SIZE equ 0802Ah
GL_HISTOGRAM_ALPHA_SIZE equ 0802Bh
GL_HISTOGRAM_LUMINANCE_SIZE equ 0802Ch
GL_HISTOGRAM_SINK equ 0802Dh
GL_MINMAX equ 0802Eh
GL_MINMAX_FORMAT equ 0802Fh
GL_MINMAX_SINK equ 08030h
GL_TABLE_TOO_LARGE equ 08031h
GL_COLOR_MATRIX equ 080B1h
GL_COLOR_MATRIX_STACK_DEPTH equ 080B2h
GL_MAX_COLOR_MATRIX_STACK_DEPTH equ 080B3h
GL_POST_COLOR_MATRIX_RED_SCALE equ 080B4h
GL_POST_COLOR_MATRIX_GREEN_SCALE equ 080B5h
GL_POST_COLOR_MATRIX_BLUE_SCALE equ 080B6h
GL_POST_COLOR_MATRIX_ALPHA_SCALE equ 080B7h
GL_POST_COLOR_MATRIX_RED_BIAS equ 080B8h
GL_POST_COLOR_MATRIX_GREEN_BIAS equ 080B9h
GL_POST_COLOR_MATRIX_BLUE_BIAS equ 080BAh
GL_POST_COLOR_MATRIX_ALPHA_BIAS equ 080BBh
GL_COLOR_TABLE equ 080D0h
GL_POST_CONVOLUTION_COLOR_TABLE equ 080D1h
GL_POST_COLOR_MATRIX_COLOR_TABLE equ 080D2h
GL_PROXY_COLOR_TABLE equ 080D3h
GL_PROXY_POST_CONVOLUTION_COLOR_TABLE equ 080D4h
GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE equ 080D5h
GL_COLOR_TABLE_SCALE equ 080D6h
GL_COLOR_TABLE_BIAS equ 080D7h
GL_COLOR_TABLE_FORMAT equ 080D8h
GL_COLOR_TABLE_WIDTH equ 080D9h
GL_COLOR_TABLE_RED_SIZE equ 080DAh
GL_COLOR_TABLE_GREEN_SIZE equ 080DBh
GL_COLOR_TABLE_BLUE_SIZE equ 080DCh
GL_COLOR_TABLE_ALPHA_SIZE equ 080DDh
GL_COLOR_TABLE_LUMINANCE_SIZE equ 080DEh
GL_COLOR_TABLE_INTENSITY_SIZE equ 080DFh
GL_CONSTANT_BORDER equ 08151h
GL_REPLICATE_BORDER equ 08153h
GL_CONVOLUTION_BORDER_COLOR equ 08154h

PFNGLCOLORTABLE_proto typedef proto :dword, :dword, :dword, :dword
PFNGLCOLORTABLE typedef ptr PFNGLCOLORTABLE_proto

PFNGLCOLORTABLEPARAMETERFV_proto typedef proto :dword, :dword, :dword
PFNGLCOLORTABLEPARAMETERFV typedef ptr PFNGLCOLORTABLEPARAMETERFV_proto

PFNGLCOLORTABLEPARAMETERIV_proto typedef proto :dword, :dword, :dword
PFNGLCOLORTABLEPARAMETERIV typedef ptr PFNGLCOLORTABLEPARAMETERIV_proto

PFNGLCOPYCOLORTABLE_proto typedef proto :dword, :dword, :dword, :dword, :dword
PFNGLCOPYCOLORTABLE typedef ptr PFNGLCOPYCOLORTABLE_proto

PFNGLGETCOLORTABLE_proto typedef proto :dword, :dword, :dword, :dword
PFNGLGETCOLORTABLE typedef ptr PFNGLGETCOLORTABLE_proto

PFNGLGETCOLORTABLEPARAMETERFV_proto typedef proto :dword, :dword, :dword
PFNGLGETCOLORTABLEPARAMETERFV typedef ptr PFNGLGETCOLORTABLEPARAMETERFV_proto

PFNGLGETCOLORTABLEPARAMETERIV_proto typedef proto :dword, :dword, :dword
PFNGLGETCOLORTABLEPARAMETERIV typedef ptr PFNGLGETCOLORTABLEPARAMETERIV_proto

PFNGLCOLORSUBTABLE_proto typedef proto :dword, :dword, :dword, :dword, :dword, :dword
PFNGLCOLORSUBTABLE typedef ptr PFNGLCOLORSUBTABLE_proto

PFNGLCOPYCOLORSUBTABLE_proto typedef proto :dword, :dword, :dword, :dword, :dword
PFNGLCOPYCOLORSUBTABLE typedef ptr PFNGLCOPYCOLORSUBTABLE_proto

PFNGLCONVOLUTIONFILTER1D_proto typedef proto :dword, :dword, :dword, :dword, :dword, :dword
PFNGLCONVOLUTIONFILTER1D typedef ptr PFNGLCOPYCOLORSUBTABLE_proto

PFNGLCONVOLUTIONFILTER2D_proto typedef proto :dword, :dword, :dword, :dword, :dword, :dword, :dword
PFNGLCONVOLUTIONFILTER2D typedef ptr PFNGLCONVOLUTIONFILTER2D_proto

PFNGLCONVOLUTIONPARAMETERF_proto typedef proto :dword, :dword, :real4
PFNGLCONVOLUTIONPARAMETERF typedef ptr PFNGLCONVOLUTIONPARAMETERF_proto

PFNGLCONVOLUTIONPARAMETERFV_proto typedef proto :dword, :dword
PFNGLCONVOLUTIONPARAMETERFV typedef ptr PFNGLCONVOLUTIONPARAMETERFV_proto

PFNGLCONVOLUTIONPARAMETERI_proto typedef proto :dword, :dword, :dword
PFNGLCONVOLUTIONPARAMETERI typedef ptr PFNGLCONVOLUTIONPARAMETERI_proto

PFNGLCONVOLUTIONPARAMETERIV_proto typedef proto :dword, :dword, :dword
PFNGLCONVOLUTIONPARAMETERIV typedef ptr PFNGLCONVOLUTIONPARAMETERIV_proto

PFNGLCOPYCONVOLUTIONFILTER1D_proto typedef proto :dword, :dword, :dword, :dword, :dword
PFNGLCOPYCONVOLUTIONFILTER1D typedef ptr PFNGLCOPYCONVOLUTIONFILTER1D_proto

PFNGLCOPYCONVOLUTIONFILTER2D_proto typedef proto :dword, :dword, :dword, :dword, :dword, :dword
PFNGLCOPYCONVOLUTIONFILTER2D typedef ptr PFNGLCOPYCONVOLUTIONFILTER2D_proto

PFNGLGETCONVOLUTIONFILTER_proto typedef proto :dword, :dword, :dword, :dword
PFNGLGETCONVOLUTIONFILTER typedef ptr PFNGLGETCONVOLUTIONFILTER_proto

PFNGLGETCONVOLUTIONPARAMETERFV_proto typedef proto :dword, :dword, :dword
PFNGLGETCONVOLUTIONPARAMETERFV typedef ptr PFNGLGETCONVOLUTIONPARAMETERFV_proto

PFNGLGETCONVOLUTIONPARAMETERIV_proto typedef proto :dword, :dword, :dword
PFNGLGETCONVOLUTIONPARAMETERIV typedef ptr PFNGLGETCONVOLUTIONPARAMETERIV_proto

PFNGLGETSEPARABLEFILTER_proto typedef proto :dword, :dword, :dword, :dword, :dword, :dword
PFNGLGETSEPARABLEFILTER typedef ptr PFNGLGETSEPARABLEFILTER_proto

PFNGLSEPARABLEFILTER2D_proto typedef proto :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
PFNGLSEPARABLEFILTER2D typedef ptr PFNGLSEPARABLEFILTER2D_proto

PFNGLGETHISTOGRAM_proto typedef proto :dword, :dword, :dword, :dword, :dword
PFNGLGETHISTOGRAM typedef ptr PFNGLGETHISTOGRAM_proto

PFNGLGETHISTOGRAMPARAMETERFV_proto typedef proto :dword, :dword, :dword
PFNGLGETHISTOGRAMPARAMETERFV typedef ptr PFNGLGETHISTOGRAMPARAMETERFV_proto

PFNGLGETHISTOGRAMPARAMETERIV_proto typedef proto :dword, :dword, :dword
PFNGLGETHISTOGRAMPARAMETERIV typedef ptr PFNGLGETHISTOGRAMPARAMETERIV_proto

PFNGLGETMINMAX_proto typedef proto :dword, :dword, :dword, :dword, :dword
PFNGLGETMINMAX typedef ptr PFNGLGETMINMAX_proto

PFNGLGETMINMAXPARAMETERFV_proto typedef proto :dword, :dword, :dword
PFNGLGETMINMAXPARAMETERFV typedef ptr PFNGLGETMINMAXPARAMETERFV_proto

PFNGLGETMINMAXPARAMETERIV_proto typedef proto :dword, :dword, :dword
PFNGLGETMINMAXPARAMETERIV typedef ptr PFNGLGETMINMAXPARAMETERIV_proto

PFNGLHISTOGRAM_proto typedef proto :dword, :dword, :dword, :dword
PFNGLHISTOGRAM typedef ptr PFNGLHISTOGRAM_proto

PFNGLMINMAX_proto typedef proto :dword, :dword, :dword
PFNGLMINMAX typedef ptr PFNGLMINMAX_proto

PFNGLRESETHISTOGRAM_proto typedef proto :dword
PFNGLRESETHISTOGRAM typedef ptr PFNGLRESETHISTOGRAM_proto

PFNGLRESETMINMAX_proto typedef proto :dword
PFNGLRESETMINMAX typedef ptr PFNGLRESETMINMAX_proto

endif ; GL_ARB_imaging

;
; GL_ATI_uber_buffers
;
; Support:
;   Rage 128 based    : Not Supported
;   Radeon 7xxx based : Not Supported
;   Radeon 8xxx based : Not Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_ATI_uber_buffers
GL_ATI_uber_buffers equ 1

GL_COLOR_BUFFER_ATI                 equ 000010000h  ; TEMPORARY VALUE
GL_DEPTH_BUFFER_ATI                 equ 000020000h  ; TEMPORARY VALUE
GL_STENCIL_BUFFER_ATI               equ 000030000h  ; TEMPORARY VALUE
GL_GENERIC_ARRAY_ATI                equ 000040000h  ; TEMPORARY VALUE
GL_ACCUMULATION_BUFFER_ATI          equ 000050000h  ; TEMPORARY VALUE
GL_MIPMAP_ATI                       equ 000060000h  ; TEMPORARY VALUE
GL_BORDER_ATI                       equ 000070000h  ; TEMPORARY VALUE
GL_USAGE_ATI                        equ 000080000h  ; TEMPORARY VALUE
GL_MATCH_SIZE_ATI                   equ 000090000h  ; TEMPORARY VALUE
GL_MATCH_COMPONENT_SET_ATI          equ 0000a0000h  ; TEMPORARY VALUE
GL_MATCH_COMPONENT_SIZE_ATI         equ 0000b0000h  ; TEMPORARY VALUE
GL_MATCH_SAMPLES_ATI                equ 0000c0000h  ; TEMPORARY VALUE
GL_ATTACH_COMPATIBILITY_ATI         equ 0000d0000h  ; TEMPORARY VALUE
GL_VALIDATE_ONLY_ATI                equ 0000e0000h  ; TEMPORARY VALUE
GL_MEMORY_DIMENSIONS_ATI            equ 0000f0000h  ; TEMPORARY VALUE
GL_MEMORY_WIDTH_ATI                 equ 000100000h  ; TEMPORARY VALUE
GL_MEMORY_HEIGHT_ATI                equ 000110000h  ; TEMPORARY VALUE
GL_MEMORY_DEPTH_ATI                 equ 000120000h  ; TEMPORARY VALUE
GL_MEMORY_LEVELS_ATI                equ 000130000h  ; TEMPORARY VALUE
GL_MEMORY_FORMAT_ATI                equ 000140000h  ; TEMPORARY VALUE
GL_SUB_MEM_ATI                      equ 000150000h  ; TEMPORARY VALUE
GL_WS_ALLOCATED_ATI                 equ 000160000h  ; TEMPORARY VALUE
GL_EXACT_ATI                        equ 000170000h  ; TEMPORARY VALUE
GL_MIN_ATI                          equ 000180000h  ; TEMPORARY VALUE
GL_MAX_ATI                          equ 000190000h  ; TEMPORARY VALUE
GL_MIN_ELEMENTS_ATI                 equ 0001a0000h  ; TEMPORARY VALUE
GL_MEMORY_3D_ATI                    equ 0001b0000h  ; TEMPORARY VALUE
GL_FRAMEBUFFER_ATI                  equ 0001c0000h  ; TEMPORARY VALUE
GL_STENCIL_COMPONENT_ATI            equ 0001d0000h  ; TEMPORARY VALUE
GL_STENCIL_COMPONENT8_ATI           equ 0001e0000h  ; TEMPORARY VALUE
GL_PROXY_ATI                        equ 0001f0000h  ; TEMPORARY VALUE
GL_CUBE_MAP_ATI                     equ 000200000h  ; TEMPORARY VALUE
GL_3D_DEPTH_SLICE_ATI               equ 000210000h  ; TEMPORARY VALUE
GL_MATCH_COMPONENT_TYPE_ATI         equ 000220000h  ; TEMPORARY VALUE
GL_IS_BASE_MEM_ATI                  equ 000230000h  ; TEMPORARY VALUE
GL_IMAGES_ATI                       equ 000240000h  ; TEMPORARY VALUE
GL_DRAW_FRAMEBUFFER_ATI             equ 000250000h  ; TEMPORARY VALUE
GL_READ_FRAMEBUFFER_ATI             equ 000260000h  ; TEMPORARY VALUE
GL_SWAP_SRC_FRAMEBUFFER_ATI         equ 000270000h  ; TEMPORARY VALUE
GL_SWAP_DST_FRAMEBUFFER_ATI         equ 000280000h  ; TEMPORARY VALUE
GL_SWAP_PRESERVE_ATI                equ 000290000h  ; TEMPORARY VALUE
GL_SWAP_SYNC_ATI                    equ 0002a0000h  ; TEMPORARY VALUE
GL_SWAP_INTERVAL_ATI                equ 0002b0000h  ; TEMPORARY VALUE
GL_VIDEO_ATI                        equ 0002c0000h  ; TEMPORARY VALUE

GL_BASE_ATI                         equ 000000001h
GL_LEAVES_ATI                       equ 000000002h
GL_MIPMAP_FALSE_ATI                 equ 000000004h
GL_MIPMAP_TRUE_ATI                  equ 000000008h
GL_MIPMAP_EITHER_ATI                equ 00000000ch
GL_CUBE_MAP_FALSE_ATI               equ 000000010h
GL_CUBE_MAP_TRUE_ATI                equ 000000020h
GL_CUBE_MAP_EITHER_ATI              equ 000000030h
GL_3D_DEPTH_SLICE_FALSE_ATI         equ 000000040h
GL_3D_DEPTH_SLICE_TRUE_ATI          equ 000000080h
GL_3D_DEPTH_SLICE_EITHER_ATI        equ 0000000c0h

GL_MAX_SWAP_INTERVAL_ATI            equ 16

PFNGLALLOCMEM3DATIPROC_proto typedef proto :dword, :dword, :dword, :dword, :dword, :dword
PFNGLALLOCMEM3DATIPROC typedef ptr PFNGLALLOCMEM3DATIPROC_proto

PFNGLALLOCMEM2DATIPROC_proto typedef proto :dword, :dword, :dword, :dword, :dword
PFNGLALLOCMEM2DATIPROC typedef ptr PFNGLALLOCMEM2DATIPROC_proto

PFNGLALLOCMEM1DATIPROC_proto typedef proto :dword, :dword, :dword, :dword
PFNGLALLOCMEM1DATIPROC typedef ptr PFNGLALLOCMEM1DATIPROC_proto

PFNGLGETMEMINFOLOGATIPROC_proto typedef proto :dword, :dword, :dword, :dword
PFNGLGETMEMINFOLOGATIPROC typedef ptr PFNGLGETMEMINFOLOGATIPROC_proto

PFNGLCLONEMEMATIPROC_proto typedef proto :dword
PFNGLCLONEMEMATIPROC typedef ptr PFNGLCLONEMEMATIPROC_proto

PFNGLDELETEMEMATIPROC_proto typedef proto :dword
PFNGLDELETEMEMATIPROC typedef ptr PFNGLDELETEMEMATIPROC_proto

PFNGLGETMEMPROPERTYATIPROC_proto typedef proto :dword, :dword
PFNGLGETMEMPROPERTYATIPROC typedef ptr PFNGLGETMEMPROPERTYATIPROC_proto

PFNGLGETSUBMEMATIPROC_proto typedef proto :dword, :dword, :dword
PFNGLGETSUBMEMATIPROC typedef ptr PFNGLGETSUBMEMATIPROC_proto

PFNGLGETBASEMEMATIPROC_proto typedef proto :dword
PFNGLGETBASEMEMATIPROC typedef ptr PFNGLGETBASEMEMATIPROC_proto

PFNGLGETMEMATIPROC_proto typedef proto :dword, :dword
PFNGLGETMEMATIPROC typedef ptr PFNGLGETMEMATIPROC_proto

PFNGLISMEMATIPROC_proto typedef proto :dword
PFNGLISMEMATIPROC typedef ptr PFNGLISMEMATIPROC_proto

PFNGLMEMIMAGEATIPROC_proto typedef proto :dword, :dword, :dword, :dword
PFNGLMEMIMAGEATIPROC typedef ptr PFNGLMEMIMAGEATIPROC_proto

PFNGLCOPYMEMIMAGE2DATIPROC_proto typedef proto :dword, :dword, :dword
PFNGLCOPYMEMIMAGE2DATIPROC typedef ptr PFNGLCOPYMEMIMAGE2DATIPROC_proto

PFNGLCOPYMEMIMAGE1DATIPROC_proto typedef proto :dword, :dword, :dword
PFNGLCOPYMEMIMAGE1DATIPROC typedef ptr PFNGLCOPYMEMIMAGE1DATIPROC_proto

PFNGLMEMSUBIMAGE3DATIPROC_proto typedef proto :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
PFNGLMEMSUBIMAGE3DATIPROC typedef ptr PFNGLMEMSUBIMAGE3DATIPROC_proto

PFNGLMEMSUBIMAGE2DATIPROC_proto typedef proto :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
PFNGLMEMSUBIMAGE2DATIPROC typedef ptr PFNGLMEMSUBIMAGE2DATIPROC_proto

PFNGLMEMSUBIMAGE1DATIPROC_proto typedef proto :dword, :dword, :dword, :dword, :dword, :dword
PFNGLMEMSUBIMAGE1DATIPROC typedef ptr PFNGLMEMSUBIMAGE1DATIPROC_proto

PFNGLCOPYMEMSUBIMAGE2DATIPROC_proto typedef proto :dword, :dword, :dword, :dword, :dword, :dword, :dword
PFNGLCOPYMEMSUBIMAGE2DATIPROC typedef ptr PFNGLCOPYMEMSUBIMAGE2DATIPROC_proto

PFNGLCOPYMEMSUBIMAGE1DATIPROC_proto typedef proto :dword, :dword, :dword, :dword, :dword
PFNGLCOPYMEMSUBIMAGE1DATIPROC typedef ptr PFNGLCOPYMEMSUBIMAGE1DATIPROC_proto

PFNGLMEMCOPY3DATIPROC_proto typedef proto :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
PFNGLMEMCOPY3DATIPROC typedef ptr PFNGLMEMCOPY3DATIPROC_proto

PFNGLMEMCOPY2DATIPROC_proto typedef proto :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
PFNGLMEMCOPY2DATIPROC typedef ptr PFNGLMEMCOPY2DATIPROC_proto

PFNGLMEMCOPY1DATIPROC_proto typedef proto :dword, :dword, :dword, :dword, :dword
PFNGLMEMCOPY1DATIPROC typedef ptr PFNGLMEMCOPY1DATIPROC_proto

PFNGLGETMEMIMAGEATIPROC_proto typedef proto :dword, :dword, :dword, :dword
PFNGLGETMEMIMAGEATIPROC typedef ptr PFNGLMEMCOPY1DATIPROC_proto

PFNGLGETMEMSUBIMAGE3DATIPROC_proto typedef proto :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
PFNGLGETMEMSUBIMAGE3DATIPROC typedef ptr PFNGLGETMEMSUBIMAGE3DATIPROC_proto

PFNGLGETMEMSUBIMAGE2DATIPROC_proto typedef proto :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
PFNGLGETMEMSUBIMAGE2DATIPROC typedef ptr PFNGLGETMEMSUBIMAGE2DATIPROC_proto

PFNGLGETMEMSUBIMAGE1DATIPROC_proto typedef proto :dword, :dword, :dword, :dword, :dword, :dword
PFNGLGETMEMSUBIMAGE1DATIPROC typedef ptr PFNGLGETMEMSUBIMAGE1DATIPROC_proto

PFNGLINVALIDATEMEMATIPROC_proto typedef proto :dword
PFNGLINVALIDATEMEMATIPROC typedef ptr PFNGLINVALIDATEMEMATIPROC_proto

PFNGLATTACHMEMATIPROC_proto typedef proto :dword, :dword, :dword
PFNGLATTACHMEMATIPROC typedef ptr PFNGLATTACHMEMATIPROC_proto

PFNGLDETACHMEMATIPROC_proto typedef proto :dword
PFNGLDETACHMEMATIPROC typedef ptr PFNGLDETACHMEMATIPROC_proto

PFNGLCREATEFRAMEBUFFERATIPROC_proto typedef proto
PFNGLCREATEFRAMEBUFFERATIPROC typedef ptr PFNGLCREATEFRAMEBUFFERATIPROC_proto

PFNGLDELETEFRAMEBUFFERATIPROC_proto typedef proto :dword
PFNGLDELETEFRAMEBUFFERATIPROC typedef ptr PFNGLDELETEFRAMEBUFFERATIPROC_proto

PFNGLBINDFRAMEBUFFERATIPROC_proto typedef proto :dword, :dword
PFNGLBINDFRAMEBUFFERATIPROC typedef ptr PFNGLBINDFRAMEBUFFERATIPROC_proto

PFNGLGETFRAMEBUFFERATIPROC_proto typedef proto :dword
PFNGLGETFRAMEBUFFERATIPROC typedef ptr PFNGLGETFRAMEBUFFERATIPROC_proto

PFNGLISFRAMEBUFFERATIPROC_proto typedef proto :dword
PFNGLISFRAMEBUFFERATIPROC typedef ptr PFNGLISFRAMEBUFFERATIPROC_proto

PFNGLFRAMEBUFFERPARAMETERFATIPROC_proto typedef proto :dword, :dword, :real4
PFNGLFRAMEBUFFERPARAMETERFATIPROC typedef ptr PFNGLFRAMEBUFFERPARAMETERFATIPROC_proto

PFNGLFRAMEBUFFERPARAMETERFVATIPROC_proto typedef proto :dword, :dword, :dword
PFNGLFRAMEBUFFERPARAMETERFVATIPROC typedef ptr PFNGLFRAMEBUFFERPARAMETERFVATIPROC_proto

PFNGLFRAMEBUFFERPARAMETERIATIPROC_proto typedef proto :dword, :dword, :dword
PFNGLFRAMEBUFFERPARAMETERIATIPROC typedef ptr PFNGLFRAMEBUFFERPARAMETERIATIPROC_proto

PFNGLFRAMEBUFFERPARAMETERIVATIPROC_proto typedef proto :dword, :dword, :dword
PFNGLFRAMEBUFFERPARAMETERIVATIPROC typedef ptr PFNGLFRAMEBUFFERPARAMETERIVATIPROC_proto

PFNGLGETFRAMEBUFFERPARAMETERFVATIPROC_proto typedef proto :dword, :dword, :dword
PFNGLGETFRAMEBUFFERPARAMETERFVATIPROC typedef ptr PFNGLGETFRAMEBUFFERPARAMETERFVATIPROC_proto

PFNGLGETFRAMEBUFFERPARAMETERIVATIPROC_proto typedef proto :dword, :dword, :dword
PFNGLGETFRAMEBUFFERPARAMETERIVATIPROC typedef ptr PFNGLGETFRAMEBUFFERPARAMETERIVATIPROC_proto

PFNGLSWAPBUFFERSATIPROC_proto typedef proto
PFNGLSWAPBUFFERSATIPROC typedef ptr PFNGLSWAPBUFFERSATIPROC_proto

PFNGLVERTEXARRAYMEMATIPROC_proto typedef proto :dword, :dword, :dword, :dword
PFNGLVERTEXARRAYMEMATIPROC typedef ptr PFNGLVERTEXARRAYMEMATIPROC_proto

PFNGLVERTEXATTRIBMEMATIPROC_proto typedef proto :dword, :dword, :dword, :dword, :dword
PFNGLVERTEXATTRIBMEMATIPROC typedef ptr PFNGLVERTEXATTRIBMEMATIPROC_proto

PFNGLDRAWMEMELEMENTSATIPROC_proto typedef proto :dword, :dword, :dword, :dword
PFNGLDRAWMEMELEMENTSATIPROC typedef ptr PFNGLDRAWMEMELEMENTSATIPROC_proto

PFNGLMULTIDRAWMEMELEMENTSATIPROC_proto typedef proto :dword, :dword, :dword, :dword, :dword
PFNGLMULTIDRAWMEMELEMENTSATIPROC typedef ptr PFNGLMULTIDRAWMEMELEMENTSATIPROC_proto

endif ; GL_ATI_uber_buffers

;
; GL_ATI_memory_export
;
; Support:
;   R500              : Supported
;   All others        : Not Supported
;
ifndef GL_ATI_memory_export
GL_ATI_memory_export equ 1

GL_EXPORT_STREAM0_ATI                   equ 06110h
GL_EXPORT_STREAM1_ATI                   equ 06111h
GL_EXPORT_STREAM2_ATI                   equ 06112h
GL_EXPORT_STREAM3_ATI                   equ 06113h

GL_EXPORT_STREAM_STRIDE_ATI             equ 06114h
GL_EXPORT_STREAM_OFFSET_ATI             equ 06115h

GL_EXPORT_BUFFER_ATI                    equ 06116h

GL_EXPORT_BUFFER_BINDING_ATI            equ 06117h
GL_EXPORT_STREAM0_BUFFER_BINDING_ATI    equ 06118h
GL_EXPORT_STREAM1_BUFFER_BINDING_ATI    equ 06119h
GL_EXPORT_STREAM2_BUFFER_BINDING_ATI    equ 0611Ah
GL_EXPORT_STREAM3_BUFFER_BINDING_ATI    equ 0611Bh

PFNGLEXPORTSTREAMATIPROC_proto typedef proto :dword, :dword, :dword
PFNGLEXPORTSTREAMATIPROC typedef ptr PFNGLEXPORTSTREAMATIPROC_proto

PFNGLGETEXPORTSTREAMPARAMETERIVATIPROC_proto typedef proto :dword, :dword, :dword
PFNGLGETEXPORTSTREAMPARAMETERIVATIPROC typedef ptr PFNGLGETEXPORTSTREAMPARAMETERIVATIPROC_proto

PFNGLGETEXPORTSTREAMPARAMETERFVATIPROC_proto typedef proto :dword, :dword, :dword
PFNGLGETEXPORTSTREAMPARAMETERFVATIPROC typedef ptr PFNGLGETEXPORTSTREAMPARAMETERFVATIPROC_proto

endif ; GL_ATI_memory_export 

ifdef FGL_DRM

;
; GL_ATI_drm
;
;  Support:
;   Rage 128 based    : Not Supported
;   Radeon 7xxx based : Not Supported
;   Radeon 8xxx based : Not Supported
;   Radeon 9xxx based : Supported
;
ifndef GL_ATI_drm
GL_ATI_drm equ 1

GL_DRM_ENABLED                            equ 000400000h  ; TEMPORARY VALUE
GL_DRM_BUFFERS                            equ 000400001h  ; TEMPORARY VALUE
GL_DRM_BUFFER_SIZE                        equ 000400002h  ; TEMPORARY VALUE
GL_DRM_FLAG_MASK                          equ 00000FFFFh
GL_DRM_FLAG_SHIFT                         0
GL_DRM_VALUE_MASK                         equ 0FFFF0000h
GL_DRM_VALUE_SHIFT                        16
GL_DRM_BUFFER_QUEUE                       equ 000000001h
GL_DRM_SUBMIT_QUEUE                       equ 000000002h
GL_DRM_BURN_BUFFERS                       equ 000000004h
GL_DRM_UNBURN_BUFFERS                     equ 000000008h

PFNGLGETDRMINFOIVATIPROC_proto typedef proto :dword, :dword
PFNGLGETDRMINFOIVATIPROC typedef ptr PFNGLGETDRMINFOIVATIPROC_proto

PFNGLCHECKDRMSUBMITATIPROC_proto typedef proto :dword, :dword
PFNGLCHECKDRMSUBMITATIPROC typedef ptr PFNGLCHECKDRMSUBMITATIPROC_proto

PFNGLCHECKDRMSUBMITATIPROC_proto typedef proto :dword
PFNGLCHECKDRMSUBMITATIPROC typedef ptr PFNGLCHECKDRMSUBMITATIPROC_proto

PFNGLLOCKDRMATIPROC_proto typedef proto
PFNGLLOCKDRMATIPROC typedef ptr PFNGLLOCKDRMATIPROC_proto

PFNGLUNLOCKDRMATIPROC_proto typedef proto
PFNGLUNLOCKDRMATIPROC typedef ptr PFNGLUNLOCKDRMATIPROC_proto

endif ; GL_ATI_drm

endif ; FGL_DRM

;
; GL_ATI_cmm
;
;  Support:
;   Rage 128 based    : Not Supported
;   Radeon 7xxx based : Not Supported
;   Radeon 8xxx based : Not Supported
;   Radeon 9xxx based : Supported
;

ifndef GL_ATI_cmm
GL_ATI_cmm equ 1

GL_CMM_TOTAL_BYTES_FB            equ 000400100h  ; TEMPORARY VALUE
GL_CMM_TOTAL_BYTES_INVISIBLE_FB  equ 000400101h  ; TEMPORARY VALUE
GL_CMM_TOTAL_BYTES_AGP           equ 000400102h  ; TEMPORARY VALUE
GL_CMM_QUERY_SEF_MODE		 equ 000400103h  ; TEMPORARY VALUE	

PFNGLGETCMMINFOATIPROC_proto typedef proto :dword, :dword
PFNGLGETCMMINFOATIPROC typedef ptr PFNGLGETCMMINFOATIPROC_proto

endif ; GL_ATI_cmm

; OpenGL Shading Language Extensions:
;
; GL_ARB_shader_objects
;
; Support
;   Rage 128 based     : Not Supported
;   Radeon 7xxx based  : Not Supported
;   Radeon 8xxx based  : Not Supported
;   Radeon 9xxx based  : Supported
;
ifndef GL_ARB_shader_objects
GL_ARB_shader_objects equ 1

GL_PROGRAM_OBJECT_ARB                       equ 08B40h

GL_OBJECT_TYPE_ARB                          equ 08B4Eh
GL_OBJECT_SUBTYPE_ARB                       equ 08B4Fh
GL_OBJECT_DELETE_STATUS_ARB                 equ 08B80h
GL_OBJECT_COMPILE_STATUS_ARB                equ 08B81h
GL_OBJECT_LINK_STATUS_ARB                   equ 08B82h
GL_OBJECT_VALIDATE_STATUS_ARB               equ 08B83h
GL_OBJECT_INFO_LOG_LENGTH_ARB               equ 08B84h
GL_OBJECT_ATTACHED_OBJECTS_ARB              equ 08B85h
GL_OBJECT_ACTIVE_UNIFORMS_ARB               equ 08B86h
GL_OBJECT_ACTIVE_UNIFORM_MAX_LENGTH_ARB     equ 08B87h
GL_OBJECT_SHADER_SOURCE_LENGTH_ARB          equ 08B88h

GL_SHADER_OBJECT_ARB                        equ 08B48h

GL_FLOAT_VEC2_ARB                           equ 08B50h
GL_FLOAT_VEC3_ARB                           equ 08B51h
GL_FLOAT_VEC4_ARB                           equ 08B52h
GL_INT_VEC2_ARB                             equ 08B53h
GL_INT_VEC3_ARB                             equ 08B54h
GL_INT_VEC4_ARB                             equ 08B55h
GL_BOOL_ARB                                 equ 08B56h
GL_BOOL_VEC2_ARB                            equ 08B57h
GL_BOOL_VEC3_ARB                            equ 08B58h
GL_BOOL_VEC4_ARB                            equ 08B59h
GL_FLOAT_MAT2_ARB                           equ 08B5Ah
GL_FLOAT_MAT3_ARB                           equ 08B5Bh
GL_FLOAT_MAT4_ARB                           equ 08B5Ch
GL_SAMPLER_1D_ARB                           equ 08B5Dh
GL_SAMPLER_2D_ARB                           equ 08B5Eh
GL_SAMPLER_3D_ARB                           equ 08B5Fh
GL_SAMPLER_CUBE_ARB                         equ 08B60h
GL_SAMPLER_1D_SHADOW_ARB                    equ 08B61h
GL_SAMPLER_2D_SHADOW_ARB                    equ 08B62h
GL_SAMPLER_2D_RECT_ARB                      equ 08B63h
GL_SAMPLER_2D_RECT_SHADOW_ARB               equ 08B64h

PFNGLDELETEOBJECTARBPROC_proto typedef proto :dword
PFNGLDELETEOBJECTARBPROC typedef ptr PFNGLDELETEOBJECTARBPROC_proto

PFNGLGETHANDLEARBPROC_proto typedef proto :dword
PFNGLGETHANDLEARBPROC typedef ptr PFNGLGETHANDLEARBPROC_proto

PFNGLDETACHOBJECTARBPROC_proto typedef proto :dword, :dword
PFNGLDETACHOBJECTARBPROC typedef ptr PFNGLDETACHOBJECTARBPROC_proto

PFNGLCREATESHADEROBJECTARBPROC_proto typedef proto :dword
PFNGLCREATESHADEROBJECTARBPROC typedef ptr PFNGLCREATESHADEROBJECTARBPROC_proto

PFNGLSHADERSOURCEARBPROC_proto typedef proto :dword, :dword, :dword, :dword
PFNGLSHADERSOURCEARBPROC typedef ptr PFNGLSHADERSOURCEARBPROC_proto

PFNGLCOMPILESHADERARBPROC_proto typedef proto :dword
PFNGLCOMPILESHADERARBPROC typedef ptr PFNGLCOMPILESHADERARBPROC_proto

PFNGLCREATEPROGRAMOBJECTARBPROC_proto typedef proto
PFNGLCREATEPROGRAMOBJECTARBPROC typedef ptr PFNGLCREATEPROGRAMOBJECTARBPROC_proto

PFNGLATTACHOBJECTARBPROC_proto typedef proto :dword, :dword
PFNGLATTACHOBJECTARBPROC typedef ptr PFNGLATTACHOBJECTARBPROC_proto

PFNGLLINKPROGRAMARBPROC_proto typedef proto :dword
PFNGLLINKPROGRAMARBPROC typedef ptr PFNGLLINKPROGRAMARBPROC_proto

PFNGLUSEPROGRAMOBJECTARBPROC_proto typedef proto :dword
PFNGLUSEPROGRAMOBJECTARBPROC typedef ptr PFNGLUSEPROGRAMOBJECTARBPROC_proto

PFNGLVALIDATEPROGRAMARBPROC_proto typedef proto :dword
PFNGLVALIDATEPROGRAMARBPROC typedef ptr PFNGLVALIDATEPROGRAMARBPROC_proto

PFNGLUNIFORM1FARBPROC_proto typedef proto :dword, :real4
PFNGLUNIFORM1FARBPROC typedef ptr PFNGLUNIFORM1FARBPROC_proto

PFNGLUNIFORM2FARBPROC_proto typedef proto :dword, :real4, :real4
PFNGLUNIFORM2FARBPROC typedef ptr PFNGLUNIFORM2FARBPROC_proto

PFNGLUNIFORM3FARBPROC_proto typedef proto :dword, :real4, :real4, :real4
PFNGLUNIFORM3FARBPROC typedef ptr PFNGLUNIFORM3FARBPROC_proto

PFNGLUNIFORM4FARBPROC_proto typedef proto :dword, :real4, :real4, :real4, :real4
PFNGLUNIFORM4FARBPROC typedef ptr PFNGLUNIFORM4FARBPROC_proto

PFNGLUNIFORM1IARBPROC_proto typedef proto :dword, :dword
PFNGLUNIFORM1IARBPROC typedef ptr PFNGLUNIFORM1IARBPROC_proto

PFNGLUNIFORM2IARBPROC_proto typedef proto :dword, :dword, :dword
PFNGLUNIFORM2IARBPROC typedef ptr PFNGLUNIFORM2IARBPROC_proto

PFNGLUNIFORM3IARBPROC_proto typedef proto :dword, :dword, :dword, :dword
PFNGLUNIFORM3IARBPROC typedef ptr PFNGLUNIFORM3IARBPROC_proto

PFNGLUNIFORM4IARBPROC_proto typedef proto :dword, :dword, :dword, :dword, :dword
PFNGLUNIFORM4IARBPROC typedef ptr PFNGLUNIFORM4IARBPROC_proto

PFNGLUNIFORM1FVARBPROC_proto typedef proto :dword, :dword, :dword
PFNGLUNIFORM1FVARBPROC typedef ptr PFNGLUNIFORM1FVARBPROC_proto

PFNGLUNIFORM2FVARBPROC_proto typedef proto :dword, :dword, :dword
PFNGLUNIFORM2FVARBPROC typedef ptr PFNGLUNIFORM2FVARBPROC_proto

PFNGLUNIFORM3FVARBPROC_proto typedef proto :dword, :dword, :dword
PFNGLUNIFORM3FVARBPROC typedef ptr PFNGLUNIFORM3FVARBPROC_proto

PFNGLUNIFORM4FVARBPROC_proto typedef proto :dword, :dword, :dword
PFNGLUNIFORM4FVARBPROC typedef ptr PFNGLUNIFORM4FVARBPROC_proto

PFNGLUNIFORM1IVARBPROC_proto typedef proto :dword, :dword, :dword
PFNGLUNIFORM1IVARBPROC typedef ptr PFNGLUNIFORM1IVARBPROC_proto

PFNGLUNIFORM2IVARBPROC_proto typedef proto :dword, :dword, :dword
PFNGLUNIFORM2IVARBPROC typedef ptr PFNGLUNIFORM2IVARBPROC_proto

PFNGLUNIFORM3IVARBPROC_proto typedef proto :dword, :dword, :dword
PFNGLUNIFORM3IVARBPROC typedef ptr PFNGLUNIFORM3IVARBPROC_proto

PFNGLUNIFORM4IVARBPROC_proto typedef proto :dword, :dword, :dword
PFNGLUNIFORM4IVARBPROC typedef ptr PFNGLUNIFORM3IVARBPROC_proto

PFNGLUNIFORMMATRIX2FVARBPROC_proto typedef proto :dword, :dword, :dword, :dword
PFNGLUNIFORMMATRIX2FVARBPROC typedef ptr PFNGLUNIFORMMATRIX2FVARBPROC_proto

PFNGLUNIFORMMATRIX3FVARBPROC_proto typedef proto :dword, :dword, :dword, :dword
PFNGLUNIFORMMATRIX3FVARBPROC typedef ptr PFNGLUNIFORMMATRIX3FVARBPROC_proto

PFNGLUNIFORMMATRIX4FVARBPROC_proto typedef proto :dword, :dword, :dword, :dword
PFNGLUNIFORMMATRIX4FVARBPROC typedef ptr PFNGLUNIFORMMATRIX4FVARBPROC_proto

PFNGLGETOBJECTPARAMETERFVARBPROC_proto typedef proto :dword, :dword, :dword
PFNGLGETOBJECTPARAMETERFVARBPROC typedef ptr PFNGLGETOBJECTPARAMETERFVARBPROC_proto

PFNGLGETOBJECTPARAMETERIVARBPROC_proto typedef proto :dword, :dword, :dword
PFNGLGETOBJECTPARAMETERIVARBPROC typedef ptr PFNGLGETOBJECTPARAMETERIVARBPROC_proto

PFNGLGETINFOLOGARBPROC_proto typedef proto :dword, :dword, :dword, :dword
PFNGLGETINFOLOGARBPROC typedef ptr PFNGLGETINFOLOGARBPROC_proto

PFNGLGETATTACHEDOBJECTSARBPROC_proto typedef proto :dword, :dword, :dword, :dword
PFNGLGETATTACHEDOBJECTSARBPROC typedef ptr PFNGLGETATTACHEDOBJECTSARBPROC_proto

PFNGLGETUNIFORMLOCATIONARBPROC_proto typedef proto :dword, :dword
PFNGLGETUNIFORMLOCATIONARBPROC typedef ptr PFNGLGETUNIFORMLOCATIONARBPROC_proto

PFNGLGETACTIVEUNIFORMARBPROC_proto typedef proto :dword, :dword, :dword, :dword, :dword, :dword, :dword
PFNGLGETACTIVEUNIFORMARBPROC typedef ptr PFNGLGETACTIVEUNIFORMARBPROC_proto

PFNGLGETUNIFORMFVARBPROC_proto typedef proto :dword, :dword, :dword
PFNGLGETUNIFORMFVARBPROC typedef ptr PFNGLGETUNIFORMFVARBPROC_proto

PFNGLGETUNIFORMIVARBPROC_proto typedef proto :dword, :dword, :dword
PFNGLGETUNIFORMIVARBPROC typedef ptr PFNGLGETUNIFORMIVARBPROC_proto

PFNGLGETSHADERSOURCEARBPROC_proto typedef proto :dword, :dword, :dword, :dword
PFNGLGETSHADERSOURCEARBPROC typedef ptr PFNGLGETSHADERSOURCEARBPROC_proto

endif ; GL_ARB_shader_objects

;
; GL_ARB_vertex_shader
;
; Support
;   Rage 128 based     : Not Supported
;   Radeon 7xxx based  : Not Supported
;   Radeon 8xxx based  : Not Supported
;   Radeon 9xxx based  : Supported
;
ifndef GL_ARB_vertex_shader
GL_ARB_vertex_shader equ 1

GL_VERTEX_SHADER_ARB                        equ 08B31h

GL_MAX_VERTEX_UNIFORM_COMPONENTS_ARB        equ 08B4Ah
GL_MAX_VARYING_FLOATS_ARB                   equ 08B4Bh
GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS_ARB       equ 08B4Ch
GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS_ARB     equ 08B4Dh

GL_OBJECT_ACTIVE_ATTRIBUTES_ARB             equ 08B89h
GL_OBJECT_ACTIVE_ATTRIBUTE_MAX_LENGTH_ARB   equ 08B8Ah

PFNGLBINDATTRIBLOCATIONARBPROC_proto typedef proto :dword, :dword, :dword
PFNGLBINDATTRIBLOCATIONARBPROC typedef ptr PFNGLBINDATTRIBLOCATIONARBPROC_proto

PFNGLGETACTIVEATTRIBARBPROC_proto typedef proto :dword, :dword, :dword, :dword, :dword, :dword, :dword
PFNGLGETACTIVEATTRIBARBPROC typedef ptr PFNGLGETACTIVEATTRIBARBPROC_proto

PFNGLGETATTRIBLOCATIONARBPROC_proto typedef proto :dword, :dword
PFNGLGETATTRIBLOCATIONARBPROC typedef ptr PFNGLGETATTRIBLOCATIONARBPROC_proto

endif ; GL_ARB_vertex_shader

;
; GL_ARB_fragment_shader
;
; Support
;   Rage 128 based     : Not Supported
;   Radeon 7xxx based  : Not Supported
;   Radeon 8xxx based  : Not Supported
;   Radeon 9xxx based  : Supported
;
ifndef GL_ARB_fragment_shader
GL_ARB_fragment_shader equ 1

GL_FRAGMENT_SHADER_ARB                      equ 08B30h
GL_MAX_FRAGMENT_UNIFORM_COMPONENTS_ARB      equ 08B49h
GL_FRAGMENT_SHADER_DERIVATIVE_HINT_ARB      equ 08B8Bh

endif ; GL_ARB_fragment_shader

;
; GL_ARB_shading_language_100
;
; Support
;   Rage 128 based     : Not Supported
;   Radeon 7xxx based  : Not Supported
;   Radeon 8xxx based  : Not Supported
;   Radeon 9xxx based  : Supported
;
ifndef GL_ARB_shading_language_100
GL_ARB_shading_language_100 equ 1

GL_SHADING_LANGUAGE_VERSION_ARB equ 0x8B8C

endif ; GL_ARB_shading_language_100
