;****************************************************************************
;*
;*  Copyright (C) 1996-2000 Microsoft Corporation.  All Rights Reserved.
;*
;*  File:       dinput.h
;*  Content:    DirectInput include file
;*
;****************************************************************************

;*
;*  To build applications for older versions of DirectInput
;*
;*  DIRECTINPUT_VERSION [ 0x0300 | 0x0500 | 0x0700 ]
;*
;*  before #include <dinput.h>.  By default, #include <dinput.h>
;*  will produce a DirectX 8-compatible header file.
;*
; Converted to asm by Franck Charlet.

ifndef DIRECTINPUT_VERSION
DIRECTINPUT_VERSION equ 0800h
endif

STDMETHOD               MACRO   name,argl:VARARG
                        LOCAL   @tmp_a
                        LOCAL   @tmp_b
@tmp_a                  TYPEDEF PROTO argl
@tmp_b                  TYPEDEF PTR @tmp_a
                        name    @tmp_b ?
                        ENDM

COINVOKE                MACRO   this,func,arglist:VARARG
                        local   Argument
                        
                        IFB     <arglist>
                                mov     eax,[this]
                                mov     eax,[eax]
                                INVOKE  func[eax],this
                        ELSE
                                push    edx
                                mov     edx,[this]
                                mov     edx,[edx]
                                FOR     Argument, <arglist>
                                        IFIDNI <&Argument>, <edx>
                                                .ERR <edx used in parameters>
                                        ENDIF
                                ENDM
                                INVOKE  func[edx],this,arglist
                                pop     edx
                        ENDIF
                        ENDM

SAFE_RELEASE            MACRO   pInterface:REQ
                        .if pInterface != NULL
                                COINVOKE pInterface, IUnknown.Release
                                mov     pInterface, NULL
                        .endif
                        ENDM

DIRECTINPUT_HEADER_VERSION  equ 00800h

IUnknown        struct
STDMETHOD QueryInterface,:PTR,:PTR,:PTR PTR
STDMETHOD AddRef,:PTR
STDMETHOD Release,:PTR 
IUnknown        ends

ifndef DIJ_RINGZERO

;****************************************************************************
;*
;*      Class IDs
;*
;****************************************************************************

CLSID_DirectInput       equ {025E609E0h,0B259h,011CFh,{0BFh,0C7h,044h,045h,053h,054h,000h,000h}}
CLSID_DirectInputDevice equ {025E609E1h,0B259h,011CFh,{0BFh,0C7h,044h,045h,053h,054h,000h,000h}}

CLSID_DirectInput8              equ     {025E609E4h,0B259h,011CFh,{0BFh,0C7h,044h,045h,053h,054h,000h,000h}}
CLSID_DirectInputDevice8        equ     {025E609E5h,0B259h,011CFh,{0BFh,0C7h,044h,045h,053h,054h,000h,000h}}

;****************************************************************************
;*
;*      Interfaces
;*
;****************************************************************************

IID_IDirectInputA       equ     {089521360h,0AA8Ah,011CFh,{0BFh,0C7h,044h,045h,053h,054h,000h,000h}}
IID_IDirectInputW      equ {089521361h,0AA8Ah,011CFh,{0BFh,0C7h,044h,045h,053h,054h,000h,000h}}
IID_IDirectInput2A     equ {05944E662h,0AA8Ah,011CFh,{0BFh,0C7h,044h,045h,053h,054h,000h,000h}}
IID_IDirectInput2W     equ {05944E663h,0AA8Ah,011CFh,{0BFh,0C7h,044h,045h,053h,054h,000h,000h}}
IID_IDirectInput7A     equ {09A4CB684h,0236Dh,011D3h,{08Eh,09Dh,000h,0C0h,04Fh,068h,044h,0AEh}}
IID_IDirectInput7W     equ {09A4CB685h,0236Dh,011D3h,{08Eh,09Dh,000h,0C0h,04Fh,068h,044h,0AEh}}
IID_IDirectInput8A     equ {0BF798030h,0483Ah,04DA2h,{0AAh,099h,05Dh,064h,0EDh,036h,097h,000h}}
IID_IDirectInput8W     equ {0BF798031h,0483Ah,04DA2h,{0AAh,099h,05Dh,064h,0EDh,036h,097h,000h}}
IID_IDirectInputDeviceA  equ {05944E680h,0C92Eh,011CFh,{0BFh,0C7h,044h,045h,053h,054h,000h,000h}}
IID_IDirectInputDeviceW  equ {05944E681h,0C92Eh,011CFh,{0BFh,0C7h,044h,045h,053h,054h,000h,000h}}
IID_IDirectInputDevice2A equ {05944E682h,0C92Eh,011CFh,{0BFh,0C7h,044h,045h,053h,054h,000h,000h}}
IID_IDirectInputDevice2W equ {05944E683h,0C92Eh,011CFh,{0BFh,0C7h,044h,045h,053h,054h,000h,000h}}
IID_IDirectInputDevice7A equ {057D7C6BCh,02356h,011D3h,{08Eh,09Dh,000h,0C0h,04Fh,068h,044h,0AEh}}
IID_IDirectInputDevice7W equ {057D7C6BDh,02356h,011D3h,{08Eh,09Dh,000h,0C0h,04Fh,068h,044h,0AEh}}
IID_IDirectInputDevice8A equ {054D41080h,0DC15h,04833h,{0A4h,01Bh,074h,08Fh,073h,0A3h,081h,079h}}
IID_IDirectInputDevice8W equ {054D41081h,0DC15h,04833h,{0A4h,01Bh,074h,08Fh,073h,0A3h,081h,079h}}
IID_IDirectInputEffect  equ {0E7E1F7C0h,088D2h,011D0h,{09Ah,0D0h,000h,0A0h,0C9h,0A0h,06Eh,035h}}

;****************************************************************************
;*
;*      Predefined object types
;*
;****************************************************************************

GUID_XAxis   equ {0A36D02E0h,0C9F3h,011CFh,{0BFh,0C7h,044h,045h,053h,054h,000h,000}}
GUID_YAxis   equ {0A36D02E1h,0C9F3h,011CFh,{0BFh,0C7h,044h,045h,053h,054h,000h,000}}
GUID_ZAxis   equ {0A36D02E2h,0C9F3h,011CFh,{0BFh,0C7h,044h,045h,053h,054h,000h,000}}
GUID_RxAxis  equ {0A36D02F4h,0C9F3h,011CFh,{0BFh,0C7h,044h,045h,053h,054h,000h,000}}
GUID_RyAxis  equ {0A36D02F5h,0C9F3h,011CFh,{0BFh,0C7h,044h,045h,053h,054h,000h,000}}
GUID_RzAxis  equ {0A36D02E3h,0C9F3h,011CFh,{0BFh,0C7h,044h,045h,053h,054h,000h,000}}
GUID_Slider  equ {0A36D02E4h,0C9F3h,011CFh,{0BFh,0C7h,044h,045h,053h,054h,000h,000}}

GUID_Button  equ {0A36D02F0h,0C9F3h,011CFh,{0BFh,0C7h,044h,045h,053h,054h,000h,000}}
GUID_Key     equ {055728220h,0D33Ch,011CFh,{0BFh,0C7h,044h,045h,053h,054h,000h,000}}

GUID_POV     equ {0A36D02F2h,0C9F3h,011CFh,{0BFh,0C7h,044h,045h,053h,054h,000h,000}}

GUID_Unknown equ {0A36D02F3h,0C9F3h,011CFh,{0BFh,0C7h,044h,045h,053h,054h,000h,000}}

;****************************************************************************
;*
;*      Predefined product GUIDs
;*
;****************************************************************************

GUID_SysMouse   equ {06F1D2B60h,0D5A0h,011CFh,{0BFh,0C7h,044h,045h,053h,054h,000h,000}}
GUID_SysKeyboard equ {06F1D2B61h,0D5A0h,011CFh,{0BFh,0C7h,044h,045h,053h,054h,000h,000}}
GUID_Joystick   equ {06F1D2B70h,0D5A0h,011CFh,{0BFh,0C7h,044h,045h,053h,054h,000h,000}}
GUID_SysMouseEm equ {06F1D2B80h,0D5A0h,011CFh,{0BFh,0C7h,044h,045h,053h,054h,000h,000}}
GUID_SysMouseEm2 equ {06F1D2B81h,0D5A0h,011CFh,{0BFh,0C7h,044h,045h,053h,054h,000h,000}}
GUID_SysKeyboardEm equ {06F1D2B82h,0D5A0h,011CFh,{0BFh,0C7h,044h,045h,053h,054h,000h,000}}
GUID_SysKeyboardEm2 equ {06F1D2B83h,0D5A0h,011CFh,{0BFh,0C7h,044h,045h,053h,054h,000h,000}}

;****************************************************************************
;*
;*      Predefined force feedback effects
;*
;****************************************************************************

GUID_ConstantForce equ {013541C20h,08E33h,011D0h,{09Ah,0D0h,000h,0A0h,0C9h,0A0h,06Eh,035}}
GUID_RampForce     equ {013541C21h,08E33h,011D0h,{09Ah,0D0h,000h,0A0h,0C9h,0A0h,06Eh,035}}
GUID_Square        equ {013541C22h,08E33h,011D0h,{09Ah,0D0h,000h,0A0h,0C9h,0A0h,06Eh,035}}
GUID_Sine          equ {013541C23h,08E33h,011D0h,{09Ah,0D0h,000h,0A0h,0C9h,0A0h,06Eh,035}}
GUID_Triangle      equ {013541C24h,08E33h,011D0h,{09Ah,0D0h,000h,0A0h,0C9h,0A0h,06Eh,035}}
GUID_SawtoothUp    equ {013541C25h,08E33h,011D0h,{09Ah,0D0h,000h,0A0h,0C9h,0A0h,06Eh,035}}
GUID_SawtoothDown  equ {013541C26h,08E33h,011D0h,{09Ah,0D0h,000h,0A0h,0C9h,0A0h,06Eh,035}}
GUID_Spring        equ {013541C27h,08E33h,011D0h,{09Ah,0D0h,000h,0A0h,0C9h,0A0h,06Eh,035}}
GUID_Damper        equ {013541C28h,08E33h,011D0h,{09Ah,0D0h,000h,0A0h,0C9h,0A0h,06Eh,035}}
GUID_Inertia       equ {013541C29h,08E33h,011D0h,{09Ah,0D0h,000h,0A0h,0C9h,0A0h,06Eh,035}}
GUID_Friction      equ {013541C2Ah,08E33h,011D0h,{09Ah,0D0h,000h,0A0h,0C9h,0A0h,06Eh,035}}
GUID_CustomForce   equ {013541C2Bh,08E33h,011D0h,{09Ah,0D0h,000h,0A0h,0C9h,0A0h,06Eh,035}}

endif ; DIJ_RINGZERO

;****************************************************************************
;*
;*      Interfaces and Structures...
;*
;****************************************************************************

if DIRECTINPUT_VERSION ge 00500h

;****************************************************************************
;*
;*      IDirectInputEffect
;*
;****************************************************************************

DIEFT_ALL                   equ 000000000h

DIEFT_CONSTANTFORCE         equ 000000001h
DIEFT_RAMPFORCE             equ 000000002h
DIEFT_PERIODIC              equ 000000003h
DIEFT_CONDITION             equ 000000004h
DIEFT_CUSTOMFORCE           equ 000000005h
DIEFT_HARDWARE              equ 0000000FFh
DIEFT_FFATTACK              equ 000000200h
DIEFT_FFFADE                equ 000000400h
DIEFT_SATURATION            equ 000000800h
DIEFT_POSNEGCOEFFICIENTS    equ 000001000h
DIEFT_POSNEGSATURATION      equ 000002000h
DIEFT_DEADBAND              equ 000004000h
DIEFT_STARTDELAY            equ 000008000h
DIEFT_GETTYPE           MACRO   n:VARARG
                        mov     eax,n
                        and     eax, 0ffh
                        EXITM   <eax>
                        ENDM

DI_DEGREES                  equ 100
DI_FFNOMINALMAX             equ 10000
DI_SECONDS                  equ 1000000

DICONSTANTFORCE struct
lMagnitude dword ?
DICONSTANTFORCE ends
LPDICONSTANTFORCE typedef ptr DICONSTANTFORCE
LPCDICONSTANTFORCE typedef ptr DICONSTANTFORCE

DIRAMPFORCE struct
lStart dword ?
lEnd dword ?
DIRAMPFORCE ends
LPDIRAMPFORCE  typedef ptr DIRAMPFORCE
LPCDIRAMPFORCE typedef ptr DIRAMPFORCE

DIPERIODIC struct
dwMagnitude dword ?
lOffset dword ?
dwPhase dword ?
dwPeriod dword ?
DIPERIODIC ends
LPDIPERIODIC  typedef ptr DIPERIODIC
LPCDIPERIODIC typedef ptr DIPERIODIC

DICONDITION struct
lOffset dword ?
lPositiveCoefficient dword ?
lNegativeCoefficient dword ?
dwPositiveSaturation dword ?
dwNegativeSaturation dword ?
lDeadBand dword ?
DICONDITION ends
LPDICONDITION typedef ptr DICONDITION
LPCDICONDITION typedef ptr DICONDITION

DICUSTOMFORCE struct
cChannels dword ?
dwSamplePeriod dword ?
cSamples dword ?
rglForceData dword ?
DICUSTOMFORCE ends
LPDICUSTOMFORCE typedef ptr DICUSTOMFORCE
LPCDICUSTOMFORCE typedef ptr DICUSTOMFORCE

DIENVELOPE struct
dwSize dword ?          ; sizeof(DIENVELOPE)
dwAttackLevel dword ?
dwAttackTime dword ?             ; Microseconds
dwFadeLevel dword ?
dwFadeTime dword ?               ; Microseconds
DIENVELOPE ends
LPDIENVELOPE typedef ptr DIENVELOPE
LPCDIENVELOPE typedef ptr DIENVELOPE

; This structure is defined for DirectX 5.0 compatibility
DIEFFECT_DX5 struct
dwSizedword dword ?                     ; sizeof(DIEFFECT_DX5)
dwFlags dword ?                 ; DIEFF_*
dwDuration dword ?              ; Microseconds
dwSamplePeriod dword ?          ; Microseconds
dwGain dword ?                  ;
dwTriggerButton dword ?         ; or DIEB_NOTRIGGER
dwTriggerRepeatInterval dword ? ; Microseconds
cAxes dword ?                   ; Number of axes
rgdwAxes dword ?                ; Array of axes
rglDirection dword ?            ; Array of directions
lpEnvelope LPDIENVELOPE ?               ; Optional
cbTypeSpecificParams dword ?    ; Size of params
lpvTypeSpecificParams dword ?   ; Pointer to params
DIEFFECT_DX5 ends
LPDIEFFECT_DX5 typedef ptr DIEFFECT_DX5
LPCDIEFFECT_DX5 typedef ptr DIEFFECT_DX5

DIEFFECT struct
dwSize dword ?                    ; sizeof(DIEFFECT)
dwFlags dword ?                  ; DIEFF_*
dwDuration dword ?               ; Microseconds
dwSamplePeriod dword ?            ; Microseconds
dwGain dword ? 
dwTriggerButton  dword ?          ; or DIEB_NOTRIGGER
dwTriggerRepeatInterval dword ?  ; Microseconds
cAxes  dword ?                    ; Number of axes
rgdwAxes dword ?                ; Array of axes
rglDirection dword ?            ; Array of directions
lpEnvelope LPDIENVELOPE ?        ; Optional
cbTypeSpecificParams dword ?     ; Size of params
lpvTypeSpecificParams dword ?   ; Pointer to params
if DIRECTINPUT_VERSION ge 00600h
dwStartDelay dword ?            ; Microseconds
endif ; DIRECTINPUT_VERSION >= 0x0600
DIEFFECT ends
LPDIEFFECT typedef ptr DIEFFECT
DIEFFECT_DX6 typedef DIEFFECT
LPDIEFFECT_DX6 typedef LPDIEFFECT
LPCDIEFFECT typedef ptr DIEFFECT

if DIRECTINPUT_VERSION ge 00700h
ifndef DIJ_RINGZERO
DIFILEEFFECT struct
dwSize dword ?
GuidEffect GUID <>
lpDiEffect LPCDIEFFECT ?
szFriendlyName db MAX_PATH dup (?)
DIFILEEFFECT ends
LPDIFILEEFFECT typedef ptr DIFILEEFFECT
LPCDIFILEEFFECT typedef ptr DIFILEEFFECT
LPCDIFILEEFFECT typedef ptr DIFILEEFFECT

LPDIENUMEFFECTSINFILECALLBACK_proto typedef proto pascal :dword , :dword 
LPDIENUMEFFECTSINFILECALLBACK typedef ptr LPDIENUMEFFECTSINFILECALLBACK_proto

endif ; DIJ_RINGZERO
endif ; DIRECTINPUT_VERSION >= 0x0700

DIEFF_OBJECTIDS             equ 000000001h
DIEFF_OBJECTOFFSETS         equ 000000002h
DIEFF_CARTESIAN             equ 000000010h
DIEFF_POLAR                 equ 000000020h
DIEFF_SPHERICAL             equ 000000040h

DIEP_DURATION               equ 000000001h
DIEP_SAMPLEPERIOD           equ 000000002h
DIEP_GAIN                   equ 000000004h
DIEP_TRIGGERBUTTON          equ 000000008h
DIEP_TRIGGERREPEATINTERVAL  equ 000000010h
DIEP_AXES                   equ 000000020h
DIEP_DIRECTION              equ 000000040h
DIEP_ENVELOPE               equ 000000080h
DIEP_TYPESPECIFICPARAMS     equ 000000100h
if DIRECTINPUT_VERSION ge 00600h
DIEP_STARTDELAY             equ 000000200h
DIEP_ALLPARAMS_DX5          equ 0000001FFh
DIEP_ALLPARAMS              equ 0000003FFh
else ; DIRECTINPUT_VERSION < equ 00600
DIEP_ALLPARAMS              equ 0000001FFh
endif ; DIRECTINPUT_VERSION < equ 00600
DIEP_START                  equ 020000000h
DIEP_NORESTART              equ 040000000h
DIEP_NODOWNLOAD             equ 080000000h
DIEB_NOTRIGGER              equ 0FFFFFFFFh

DIES_SOLO                   equ 000000001h
DIES_NODOWNLOAD             equ 080000000h

DIEGES_PLAYING              equ 000000001h
DIEGES_EMULATED             equ 000000002h

DIEFFESCAPE struct
dwSize dword ?
dwCommand dword ?
lpvInBuffer dword ?
cbInBuffer dword ?
lpvOutBuffer dword ?
cbOutBuffer dword ?
DIEFFESCAPE ends

ifndef DIJ_RINGZERO

IDirectInputEffect      struct
;*** IUnknown methods ***
STDMETHOD QueryInterface,:PTR,:PTR,:PTR PTR
STDMETHOD AddRef,:PTR
STDMETHOD Release,:PTR 

;*** IDirectInputEffect methods ***
STDMETHOD Initialize,:ptr ,:HINSTANCE,:dword,:dword
STDMETHOD GetEffectGuid,:ptr ,:dword
STDMETHOD GetParameters,:ptr ,:LPDIEFFECT,:dword
STDMETHOD SetParameters,:ptr ,:LPCDIEFFECT,:dword
STDMETHOD Start,:ptr ,:dword,:dword
STDMETHOD Stop,:ptr 
STDMETHOD GetEffectStatus,:ptr , :ptr
STDMETHOD Download,:ptr 
STDMETHOD Unload,:ptr 
STDMETHOD Escape,:ptr , :dword
IDirectInputEffect      ends

LPDIRECTINPUTEFFECT typedef ptr IDirectInputEffect

endif ; DIJ_RINGZERO

endif ; DIRECTINPUT_VERSION >= 0x0500

;****************************************************************************
;*
;*      IDirectInputDevice
;*
;****************************************************************************

if DIRECTINPUT_VERSION le 0700h
DIDEVTYPE_DEVICE        equ 1
DIDEVTYPE_MOUSE         equ 2
DIDEVTYPE_KEYBOARD      equ 3
DIDEVTYPE_JOYSTICK      equ 4

else
DI8DEVCLASS_ALL             equ 0
DI8DEVCLASS_DEVICE          equ 1
DI8DEVCLASS_POINTER         equ 2
DI8DEVCLASS_KEYBOARD        equ 3
DI8DEVCLASS_GAMECTRL        equ 4

DI8DEVTYPE_DEVICE           equ 011h
DI8DEVTYPE_MOUSE            equ 012h
DI8DEVTYPE_KEYBOARD         equ 013h
DI8DEVTYPE_JOYSTICK         equ 014h
DI8DEVTYPE_GAMEPAD          equ 015h
DI8DEVTYPE_DRIVING          equ 016h
DI8DEVTYPE_FLIGHT           equ 017h
DI8DEVTYPE_1STPERSON        equ 018h
DI8DEVTYPE_DEVICECTRL       equ 019h
DI8DEVTYPE_SCREENPOINTER    equ 01Ah
DI8DEVTYPE_REMOTE           equ 01Bh
DI8DEVTYPE_SUPPLEMENTAL     equ 01Ch
endif ; DIRECTINPUT_VERSION <= 0700h

DIDEVTYPE_HID           equ 000010000h

if DIRECTINPUT_VERSION le 0700h
DIDEVTYPEMOUSE_UNKNOWN          equ 1
DIDEVTYPEMOUSE_TRADITIONAL      equ 2
DIDEVTYPEMOUSE_FINGERSTICK      equ 3
DIDEVTYPEMOUSE_TOUCHPAD         equ 4
DIDEVTYPEMOUSE_TRACKBALL        equ 5

DIDEVTYPEKEYBOARD_UNKNOWN       equ 0
DIDEVTYPEKEYBOARD_PCXT          equ 1
DIDEVTYPEKEYBOARD_OLIVETTI      equ 2
DIDEVTYPEKEYBOARD_PCAT          equ 3
DIDEVTYPEKEYBOARD_PCENH         equ 4
DIDEVTYPEKEYBOARD_NOKIA1050     equ 5
DIDEVTYPEKEYBOARD_NOKIA9140     equ 6
DIDEVTYPEKEYBOARD_NEC98         equ 7
DIDEVTYPEKEYBOARD_NEC98LAPTOP   equ 8
DIDEVTYPEKEYBOARD_NEC98106      equ 9
DIDEVTYPEKEYBOARD_JAPAN106     equ 10
DIDEVTYPEKEYBOARD_JAPANAX      equ 11
DIDEVTYPEKEYBOARD_J3100        equ 12

DIDEVTYPEJOYSTICK_UNKNOWN       equ 1
DIDEVTYPEJOYSTICK_TRADITIONAL   equ 2
DIDEVTYPEJOYSTICK_FLIGHTSTICK   equ 3
DIDEVTYPEJOYSTICK_GAMEPAD       equ 4
DIDEVTYPEJOYSTICK_RUDDER        equ 5
DIDEVTYPEJOYSTICK_WHEEL         equ 6
DIDEVTYPEJOYSTICK_HEADTRACKER   equ 7

else
DI8DEVTYPEMOUSE_UNKNOWN                     equ 1
DI8DEVTYPEMOUSE_TRADITIONAL                 equ 2
DI8DEVTYPEMOUSE_FINGERSTICK                 equ 3
DI8DEVTYPEMOUSE_TOUCHPAD                    equ 4
DI8DEVTYPEMOUSE_TRACKBALL                   equ 5
DI8DEVTYPEMOUSE_ABSOLUTE                    equ 6

DI8DEVTYPEKEYBOARD_UNKNOWN                  equ 0
DI8DEVTYPEKEYBOARD_PCXT                     equ 1
DI8DEVTYPEKEYBOARD_OLIVETTI                 equ 2
DI8DEVTYPEKEYBOARD_PCAT                     equ 3
DI8DEVTYPEKEYBOARD_PCENH                    equ 4
DI8DEVTYPEKEYBOARD_NOKIA1050                equ 5
DI8DEVTYPEKEYBOARD_NOKIA9140                equ 6
DI8DEVTYPEKEYBOARD_NEC98                    equ 7
DI8DEVTYPEKEYBOARD_NEC98LAPTOP              equ 8
DI8DEVTYPEKEYBOARD_NEC98106                 equ 9
DI8DEVTYPEKEYBOARD_JAPAN106                equ 10
DI8DEVTYPEKEYBOARD_JAPANAX                 equ 11
DI8DEVTYPEKEYBOARD_J3100                   equ 12

DI8DEVTYPE_LIMITEDGAMESUBTYPE               equ 1

DI8DEVTYPEJOYSTICK_LIMITED                  equ DI8DEVTYPE_LIMITEDGAMESUBTYPE
DI8DEVTYPEJOYSTICK_STANDARD                 equ 2

DI8DEVTYPEGAMEPAD_LIMITED                   equ DI8DEVTYPE_LIMITEDGAMESUBTYPE
DI8DEVTYPEGAMEPAD_STANDARD                  equ 2
DI8DEVTYPEGAMEPAD_TILT                      equ 3

DI8DEVTYPEDRIVING_LIMITED                   equ DI8DEVTYPE_LIMITEDGAMESUBTYPE
DI8DEVTYPEDRIVING_COMBINEDPEDALS            equ 2
DI8DEVTYPEDRIVING_DUALPEDALS                equ 3
DI8DEVTYPEDRIVING_THREEPEDALS               equ 4
DI8DEVTYPEDRIVING_HANDHELD                  equ 5

DI8DEVTYPEFLIGHT_LIMITED                    equ DI8DEVTYPE_LIMITEDGAMESUBTYPE
DI8DEVTYPEFLIGHT_STICK                      equ 2
DI8DEVTYPEFLIGHT_YOKE                       equ 3
DI8DEVTYPEFLIGHT_RC                         equ 4

DI8DEVTYPE1STPERSON_LIMITED                 equ DI8DEVTYPE_LIMITEDGAMESUBTYPE
DI8DEVTYPE1STPERSON_UNKNOWN                 equ 2
DI8DEVTYPE1STPERSON_SIXDOF                  equ 3
DI8DEVTYPE1STPERSON_SHOOTER                 equ 4

DI8DEVTYPESCREENPTR_UNKNOWN                 equ 2
DI8DEVTYPESCREENPTR_LIGHTGUN                equ 3
DI8DEVTYPESCREENPTR_LIGHTPEN                equ 4
DI8DEVTYPESCREENPTR_TOUCH                   equ 5

DI8DEVTYPEREMOTE_UNKNOWN                    equ 2

DI8DEVTYPEDEVICECTRL_UNKNOWN                equ 2
DI8DEVTYPEDEVICECTRL_COMMSSELECTION         equ 3
DI8DEVTYPEDEVICECTRL_COMMSSELECTION_HARDWIRED equ 4

DI8DEVTYPESUPPLEMENTAL_UNKNOWN              equ 2
DI8DEVTYPESUPPLEMENTAL_2NDHANDCONTROLLER    equ 3
DI8DEVTYPESUPPLEMENTAL_HEADTRACKER          equ 4
DI8DEVTYPESUPPLEMENTAL_HANDTRACKER          equ 5
DI8DEVTYPESUPPLEMENTAL_SHIFTSTICKGATE       equ 6
DI8DEVTYPESUPPLEMENTAL_SHIFTER              equ 7
DI8DEVTYPESUPPLEMENTAL_THROTTLE             equ 8
DI8DEVTYPESUPPLEMENTAL_SPLITTHROTTLE        equ 9
DI8DEVTYPESUPPLEMENTAL_COMBINEDPEDALS      equ 10
DI8DEVTYPESUPPLEMENTAL_DUALPEDALS          equ 11
DI8DEVTYPESUPPLEMENTAL_THREEPEDALS         equ 12
DI8DEVTYPESUPPLEMENTAL_RUDDERPEDALS        equ 13
endif ; DIRECTINPUT_VERSION <= 0700h

GET_DIDEVICE_TYPE       MACRO   dwDevType:VARARG
                        mov     eax,dwDevType
                        and     eax, 0ffh
                        EXITM   <eax>
                        ENDM
GET_DIDEVICE_SUBTYPE    MACRO   dwDevType:VARARG
                        mov     eax,dwDevType
                        and     eax, 0ff00h
                        EXITM   <eax>
                        ENDM

if DIRECTINPUT_VERSION ge 00500h
; This structure is defined for DirectX 3.0 compatibility
DIDEVCAPS_DX3 struct
dwSize dword ?
dwFlags dword ?
dwDevType dword ?
dwAxes dword ?
dwButtons dword ?
dwPOVs dword ?
DIDEVCAPS_DX3 ends
endif ; DIRECTINPUT_VERSION >= 0x0500

DIDEVCAPS struct
dwSize dword ?
dwFlags dword ?
dwDevType dword ?
dwAxes dword ?
dwButtons dword ?
dwPOVs dword ?
if DIRECTINPUT_VERSION ge 00500h
dwFFSamplePeriod dword ?
dwFFMinTimeResolution dword ?
dwFirmwareRevision dword ?
dwHardwareRevision dword ?
dwFFDriverVersion dword ?
endif ; DIRECTINPUT_VERSION >= 00500h
DIDEVCAPS ends

DIDC_ATTACHED           equ 000000001h
DIDC_POLLEDDEVICE       equ 000000002h
DIDC_EMULATED           equ 000000004h
DIDC_POLLEDDATAFORMAT   equ 000000008h
if DIRECTINPUT_VERSION ge 00500h
DIDC_FORCEFEEDBACK      equ 000000100h
DIDC_FFATTACK           equ 000000200h
DIDC_FFFADE             equ 000000400h
DIDC_SATURATION         equ 000000800h
DIDC_POSNEGCOEFFICIENTS equ 000001000h
DIDC_POSNEGSATURATION   equ 000002000h
DIDC_DEADBAND           equ 000004000h
endif ; DIRECTINPUT_VERSION >= 00500
DIDC_STARTDELAY         equ 000008000h
if DIRECTINPUT_VERSION ge 0050ah
DIDC_ALIAS              equ 000010000h
DIDC_PHANTOM            equ 000020000h
endif ; DIRECTINPUT_VERSION >= 0050ah
if DIRECTINPUT_VERSION ge 00800h
DIDC_HIDDEN             equ 000040000h
endif ; DIRECTINPUT_VERSION >= 00800h

DIDFT_ALL           equ 000000000h

DIDFT_RELAXIS       equ 000000001h
DIDFT_ABSAXIS       equ 000000002h
DIDFT_AXIS          equ 000000003h

DIDFT_PSHBUTTON     equ 000000004h
DIDFT_TGLBUTTON     equ 000000008h
DIDFT_BUTTON        equ 00000000Ch

DIDFT_POV           equ 000000010h
DIDFT_COLLECTION    equ 000000040h
DIDFT_NODATA        equ 000000080h

DIDFT_ANYINSTANCE   equ 000FFFF00h
DIDFT_INSTANCEMASK  equ DIDFT_ANYINSTANCE

DIDFT_MAKEINSTANCE      MACRO   n:VARARG
                        mov     eax,n
                        and     eax,0ffffh
                        shl     eax, 8
                        EXITM   <eax>
                        ENDM
DIDFT_GETTYPE           MACRO   n:VARARG
                        mov     eax,n
                        and     eax, 0ffh
                        EXITM   <eax>
                        ENDM
DIDFT_GETINSTANCE       MACRO   n:VARARG
                        mov     eax,n
                        shr     eax, 8
                        and     eax, 0xffff
                        EXITM   <eax>
                        ENDM

DIDFT_FFACTUATOR        equ 001000000h
DIDFT_FFEFFECTTRIGGER   equ 002000000h
if DIRECTINPUT_VERSION ge 0050ah
DIDFT_OUTPUT            equ 010000000h
DIDFT_VENDORDEFINED     equ 004000000h
DIDFT_ALIAS             equ 008000000h
endif ; DIRECTINPUT_VERSION >= 0050a
ifndef DIDFT_OPTIONAL
DIDFT_OPTIONAL          equ 080000000h
endif

DIDFT_ENUMCOLLECTION    MACRO   n:VARARG
                        mov     eax,n
                        and     eax,0ffffh
                        shl     eax, 8
                        EXITM   <eax>
                        ENDM
DIDFT_NOCOLLECTION      equ 000FFFF00h

ifndef DIJ_RINGZERO

DIOBJECTDATAFORMAT struct
pguid dword ?
dwOfs dword ?
dwType dword ?
dwFlags dword ?
DIOBJECTDATAFORMAT ends
LPDIOBJECTDATAFORMAT typedef ptr DIOBJECTDATAFORMAT
LPCDIOBJECTDATAFORMAT typedef ptr DIOBJECTDATAFORMAT

DIDATAFORMAT struct
dwSize dword ?
dwObjSize dword ?
dwFlags dword ?
dwDataSize dword ?
dwNumObjs dword ?
rgodf LPDIOBJECTDATAFORMAT ?
DIDATAFORMAT ends
LPDIDATAFORMAT typedef ptr DIDATAFORMAT
LPCDIDATAFORMAT typedef ptr DIDATAFORMAT

DIDF_ABSAXIS            equ 000000001h
DIDF_RELAXIS            equ 000000002h

;extern const DIDATAFORMAT c_dfDIMouse;

;if DIRECTINPUT_VERSION >= 00700h
;extern const DIDATAFORMAT c_dfDIMouse2;
;endif ; DIRECTINPUT_VERSION >= 0x0700

EXTERNDEF C c_dfDIMouse:DIDATAFORMAT
EXTERNDEF C c_dfDIKeyboard:DIDATAFORMAT
EXTERNDEF C c_dfDIJoystick:DIDATAFORMAT
EXTERNDEF C c_dfDIJoystick2:DIDATAFORMAT
;extern const DIDATAFORMAT c_dfDIKeyboard;

;if DIRECTINPUT_VERSION >= 00500h
;extern const DIDATAFORMAT c_dfDIJoystick;
;extern const DIDATAFORMAT c_dfDIJoystick2;
;endif ; DIRECTINPUT_VERSION >= 00500h


if DIRECTINPUT_VERSION gt 00700h

DIACTIONA struct
uAppData dword ?
dwSemantic dword ?
dwFlags dword ?
union
lptszActionName dword ?
uResIdString dword ?
ends
guidInstance GUID <>
dwObjID dword ?
dwHow dword ?
DIACTIONA ends
LPDIACTIONA typedef ptr DIACTIONA
DIACTION equ  <DIACTIONA>
LPDIACTION equ  <LPDIACTIONA>
LPCDIACTION typedef ptr DIACTION


DIA_FORCEFEEDBACK       equ 000000001h
DIA_APPMAPPED           equ 000000002h
DIA_APPNOMAP            equ 000000004h
DIA_NORANGE             equ 000000008h
DIA_APPFIXED            equ 000000010h

DIAH_UNMAPPED           equ 000000000h
DIAH_USERCONFIG         equ 000000001h
DIAH_APPREQUESTED       equ 000000002h
DIAH_HWAPP              equ 000000004h
DIAH_HWDEFAULT          equ 000000008h
DIAH_DEFAULT            equ 000000020h
DIAH_ERROR              equ 080000000h

DIACTIONFORMATA struct
dwSize dword ?
dwActionSize dword ?
dwDataSize dword ?
dwNumActions dword ?
rgoAction dword ?
guidActionMap GUID <>
dwGenre dword ?
dwBufferSize dword ?
lAxisMin dword ?
lAxisMax dword ?
HINSTANCE   hInstString
ftTimeStamp FILETIME <>
dwCRC DWORD ?
tszActionMap byte MAX_PATH dup (?)
DIACTIONFORMATA ends
LPDIACTIONFORMATA typedef ptr DIACTIONFORMATA

DIACTIONFORMAT equ  <DIACTIONFORMATA>
LPDIACTIONFORMAT equ  <LPDIACTIONFORMATA>

LPCDIACTIONFORMATA typedef ptr DIACTIONFORMATA

LPCDIACTIONFORMAT typedef ptr DIACTIONFORMAT
LPCDIACTIONFORMATA typedef ptr DIACTIONFORMAT

DIAFTS_NEWDEVICELOW     equ 0FFFFFFFFh
DIAFTS_NEWDEVICEHIGH    equ 0FFFFFFFFh
DIAFTS_UNUSEDDEVICELOW  equ 000000000h
DIAFTS_UNUSEDDEVICEHIGH equ 000000000h

DIDBAM_DEFAULT          equ 000000000h
DIDBAM_PRESERVE         equ 000000001h
DIDBAM_INITIALIZE       equ 000000002h
DIDBAM_HWDEFAULTS       equ 000000004h

DIDSAM_DEFAULT          equ 000000000h
DIDSAM_NOUSER           equ 000000001h
DIDSAM_FORCESAVE        equ 000000002h

DICD_DEFAULT            equ 000000000h
DICD_EDIT               equ 000000001h

;*
;* The following definition is normally defined in d3dtypes.h
;*
ifndef D3DCOLOR_DEFINED
D3DCOLOR typedef DWORD
D3DCOLOR_DEFINED equ 1
endif

DICOLORSET struct
dwSize dword ?
cTextFore D3DCOLOR ?
cTextHighlight D3DCOLOR ?
cCalloutLine D3DCOLOR ?
cCalloutHighlight D3DCOLOR ?
cBorder D3DCOLOR ?
cControlFill D3DCOLOR ?
cHighlightFill D3DCOLOR ?
cAreaFill D3DCOLOR ?
DICOLORSET ends
LPDICOLORSET typedef ptr DICOLORSET
LPCDICOLORSET typedef ptr DICOLORSET

DICONFIGUREDEVICESPARAMSA struct
dwSize dword ?
dwcUsers dword ?
lptszUserNames dword ?
dwcFormats dword ?
lprgFormats LPDIACTIONFORMATA ?
hwnd HWND ?
dics DICOLORSET <>
lpUnkDDSTargetd dword ?
DICONFIGUREDEVICESPARAMSA ends
LPDICONFIGUREDEVICESPARAMSA typedef ptr DICONFIGUREDEVICESPARAMSA

DICONFIGUREDEVICESPARAMS equ <DICONFIGUREDEVICESPARAMSA>
LPDICONFIGUREDEVICESPARAMS equ <LPDICONFIGUREDEVICESPARAMSA>
LPCDICONFIGUREDEVICESPARAMSA typedef ptr DICONFIGUREDEVICESPARAMSA

DICONFIGUREDEVICESPARAMS equ <DICONFIGUREDEVICESPARAMSA>
LPCDICONFIGUREDEVICESPARAMS equ <LPCDICONFIGUREDEVICESPARAMSA>
LPCDICONFIGUREDEVICESPARAMSA typedef ptr DICONFIGUREDEVICESPARAMSA

DIDIFT_CONFIGURATION    equ 000000001h
DIDIFT_OVERLAY          equ 000000002h

DIDAL_CENTERED      equ 000000000h
DIDAL_LEFTALIGNED   equ 000000001h
DIDAL_RIGHTALIGNED  equ 000000002h
DIDAL_MIDDLE        equ 000000000h
DIDAL_TOPALIGNED    equ 000000004h
DIDAL_BOTTOMALIGNED equ 000000008h

DIDEVICEIMAGEINFOA struct
tszImagePath byte MAX_PATH dup (?)
dwFlags dword ?
; These are valid if DIDIFT_OVERLAY is present in dwFlags.
dwViewID dword ?
rcOverlay     RECT <>
dwObjID dword ?
dwcValidPts dword ?
rgptCalloutLine POINT 5 dup (<>)
rcCalloutRect RECT <>
dwTextAlign dword ?
DIDEVICEIMAGEINFOA ends
LPDIDEVICEIMAGEINFOA typedef ptr DIDEVICEIMAGEINFOA

DIDEVICEIMAGEINFO equ <DIDEVICEIMAGEINFOA>
LPDIDEVICEIMAGEINFO equ <LPDIDEVICEIMAGEINFOA>
LPCDIDEVICEIMAGEINFOA typedef ptr DIDEVICEIMAGEINFOA
DIDEVICEIMAGEINFO equ <DIDEVICEIMAGEINFOA>
LPCDIDEVICEIMAGEINFO equ <LPCDIDEVICEIMAGEINFOA>
LPCDIDEVICEIMAGEINFO typedef ptr DIDEVICEIMAGEINFO

DIDEVICEIMAGEINFOHEADERA struct
dwSize dword ?
dwSizeImageInfo dword ?
dwcViews dword ?
dwcButtons dword ?
dwcAxes dword ?
dwcPOVs dword ?
dwBufferSize dword ?
dwBufferUsed dword ?
lprgImageInfoArray LPDIDEVICEIMAGEINFOA ?
DIDEVICEIMAGEINFOHEADERA ends
LPDIDEVICEIMAGEINFOHEADERA typedef ptr DIDEVICEIMAGEINFOHEADERA

DIDEVICEIMAGEINFOHEADER equ <DIDEVICEIMAGEINFOHEADERA>
LPDIDEVICEIMAGEINFOHEADER equ <LPDIDEVICEIMAGEINFOHEADERA>
LPCDIDEVICEIMAGEINFOHEADERA typedef ptr DIDEVICEIMAGEINFOHEADERA
DIDEVICEIMAGEINFOHEADER equ <DIDEVICEIMAGEINFOHEADERA>
LPCDIDEVICEIMAGEINFOHEADER equ <LPCDIDEVICEIMAGEINFOHEADERA>
LPCDIDEVICEIMAGEINFOHEADER typedef ptr DIDEVICEIMAGEINFOHEADER

endif ; DIRECTINPUT_VERSION > 00700h

if DIRECTINPUT_VERSION ge 00500h
; These structures are defined for DirectX 3.0 compatibility

DIDEVICEOBJECTINSTANCE_DX3A struct
dwSize dword ?
guidType GUID <>
dwOfs dword ?
dwType dword ?
dwFlags dword ?
tszName byte MAX_PATH dup (?)
DIDEVICEOBJECTINSTANCE_DX3A ends
LPDIDEVICEOBJECTINSTANCE_DX3A typedef ptr DIDEVICEOBJECTINSTANCE_DX3A

DIDEVICEOBJECTINSTANCE_DX3 equ <DIDEVICEOBJECTINSTANCE_DX3A>
LPDIDEVICEOBJECTINSTANCE_DX3 equ <LPDIDEVICEOBJECTINSTANCE_DX3A>
LPCDIDEVICEOBJECTINSTANCE_DX3A typedef ptr DIDEVICEOBJECTINSTANCE_DX3A
LPCDIDEVICEOBJECTINSTANCE_DX3 typedef ptr DIDEVICEOBJECTINSTANCE_DX3
endif ; DIRECTINPUT_VERSION >= 00500h

DIDEVICEOBJECTINSTANCEA struct
dwSize dword ?
guidType GUID <>
dwOfs dword ?
dwType dword ?
dwFlags dword ?
tszName byte MAX_PATH dup (?)
if DIRECTINPUT_VERSION ge 00500h
dwFFMaxForce dword ?
dwFFForceResolution dword ?
wCollectionNumber word ?
wDesignatorIndex word ?
wUsagePage word ?
wUsage word ?
dwDimension dword ?
wExponent word ?
wReportId word ?
endif ; DIRECTINPUT_VERSION >= 00500h
DIDEVICEOBJECTINSTANCEA ends
LPDIDEVICEOBJECTINSTANCEA typedef ptr DIDEVICEOBJECTINSTANCEA

DIDEVICEOBJECTINSTANCE equ DIDEVICEOBJECTINSTANCEA
LPDIDEVICEOBJECTINSTANCE equ LPDIDEVICEOBJECTINSTANCEA
LPCDIDEVICEOBJECTINSTANCEA typedef ptr DIDEVICEOBJECTINSTANCEA
LPCDIDEVICEOBJECTINSTANCE typedef ptr DIDEVICEOBJECTINSTANCEA

LPDIENUMDEVICEOBJECTSCALLBACKA_proto typedef proto pascal :dword , :dword 
LPDIENUMDEVICEOBJECTSCALLBACKA typedef ptr LPDIENUMDEVICEOBJECTSCALLBACKA_proto

LPDIENUMDEVICEOBJECTSCALLBACK  equ <LPDIENUMDEVICEOBJECTSCALLBACKA>

if DIRECTINPUT_VERSION ge 00500h
DIDOI_FFACTUATOR        equ 000000001h
DIDOI_FFEFFECTTRIGGER   equ 000000002h
DIDOI_POLLED            equ 000008000h
DIDOI_ASPECTPOSITION    equ 000000100h
DIDOI_ASPECTVELOCITY    equ 000000200h
DIDOI_ASPECTACCEL       equ 000000300h
DIDOI_ASPECTFORCE       equ 000000400h
DIDOI_ASPECTMASK        equ 000000F00h
endif ; DIRECTINPUT_VERSION >= 00500h
if DIRECTINPUT_VERSION ge 0050ah
DIDOI_GUIDISUSAGE       equ 000010000h
endif ; DIRECTINPUT_VERSION >= 0050ah

DIPROPHEADER struct
dwSize dword ?
dwHeaderSize dword ?
dwObj dword ?
dwHow dword ?
DIPROPHEADER ends
LPDIPROPHEADER typedef ptr DIPROPHEADER
LPCDIPROPHEADER typedef ptr DIPROPHEADER

DIPH_DEVICE             equ 0
DIPH_BYOFFSET           equ 1
DIPH_BYID               equ 2
if DIRECTINPUT_VERSION ge 0050ah
DIPH_BYUSAGE            equ 3
endif ; DIRECTINPUT_VERSION >= 0050ah

if DIRECTINPUT_VERSION ge 0050ah
DIMAKEUSAGEDWORD        MACRO   Usage, UsagePage:VARARG
                        mov     eax,UsagePage
                        shl     eax,16
                        or      eax,Usage
                        EXITM   <eax>
                        ENDM
endif ; DIRECTINPUT_VERSION >= 0x050a

DIPROPDWORD struct
diph DIPROPHEADER <>
dwData dword ?
DIPROPDWORD ends
LPDIPROPDWORD typedef ptr DIPROPDWORD
LPCDIPROPDWORD typedef ptr DIPROPDWORD

if DIRECTINPUT_VERSION ge 00800h
DIPROPPOINTER struct
diph DIPROPHEADER <>
uData dword ?
DIPROPPOINTER ends
LPDIPROPPOINTER typedef ptr DIPROPPOINTER
LPCDIPROPPOINTER typedef ptr DIPROPPOINTER
endif ; DIRECTINPUT_VERSION >= 00800h

DIPROPRANGE struct
diph DIPROPHEADER <>
lMin dword ?
lMax dword ?
DIPROPRANGE ends
LPDIPROPRANGE typedef ptr DIPROPRANGE
LPCDIPROPRANGE typedef ptr DIPROPRANGE

DIPROPRANGE_NOMIN       equ 080000000h
DIPROPRANGE_NOMAX       equ 07FFFFFFFh

if DIRECTINPUT_VERSION ge 0050ah
DIPROPCAL struct
diph DIPROPHEADER <>
lMin dword ?
lCenter dword ?
lMax dword ?
DIPROPCAL ends
LPDIPROPCAL typedef ptr DIPROPCAL
LPCDIPROPCAL typedef ptr DIPROPCAL

DIPROPCALPOV struct
diph DIPROPHEADER <>
lMin dword 5 dup (?)
lMax dword 5 dup (?)
DIPROPCALPOV ends
LPDIPROPCALPOV typedef ptr DIPROPCALPOV
LPCDIPROPCALPOV typedef ptr DIPROPCALPOV

DIPROPGUIDANDPATH struct
diph DIPROPHEADER <>
guidClass GUID <>
wszPath WCHAR MAX_PATH dup (?)
DIPROPGUIDANDPATH ends
LPDIPROPGUIDANDPATH typedef ptr DIPROPGUIDANDPATH
LPCDIPROPGUIDANDPATH typedef ptr DIPROPGUIDANDPATH

DIPROPSTRING struct
diph DIPROPHEADER <>
wsz WCHAR MAX_PATH dup (?)
DIPROPSTRING ends
LPDIPROPSTRING typedef ptr DIPROPSTRING
LPCDIPROPSTRING typedef ptr DIPROPSTRING

endif ; DIRECTINPUT_VERSION >= 0050ah

if DIRECTINPUT_VERSION ge 00800h
MAXCPOINTSNUM          equ 8

CPOINT struct
lP dword ?     ; raw value
dwLog dword ?  ; logical_value / max_logical_value * 10000
CPOINT ends
PCPOINT typedef ptr CPOINT

DIPROPCPOINTS struct
diph DIPROPHEADER <>
dwCPointsNum dword ?
cp CPOINT MAXCPOINTSNUM dup (<>)
DIPROPCPOINTS ends
LPDIPROPCPOINTS typedef ptr DIPROPCPOINTS
LPCDIPROPCPOINTS typedef ptr DIPROPCPOINTS

endif ; DIRECTINPUT_VERSION >= 00800

DIPROP_BUFFERSIZE       equ 1

DIPROP_AXISMODE         equ 2

DIPROPAXISMODE_ABS      equ 0
DIPROPAXISMODE_REL      equ 1

DIPROP_GRANULARITY      equ 3

DIPROP_RANGE            equ 4

DIPROP_DEADZONE         equ 5

DIPROP_SATURATION       equ 6

DIPROP_FFGAIN           equ 7

DIPROP_FFLOAD           equ 8

DIPROP_AUTOCENTER       equ 9

DIPROPAUTOCENTER_OFF    equ 0
DIPROPAUTOCENTER_ON     equ 1

DIPROP_CALIBRATIONMODE  equ 10

DIPROPCALIBRATIONMODE_COOKED    equ 0
DIPROPCALIBRATIONMODE_RAW       equ 1

if DIRECTINPUT_VERSION ge 0050ah
DIPROP_CALIBRATION      equ 11

DIPROP_GUIDANDPATH      equ 12

DIPROP_INSTANCENAME     equ 13

DIPROP_PRODUCTNAME      equ 14
endif ; DIRECTINPUT_VERSION >= 0050ah

if DIRECTINPUT_VERSION ge 005b2h
DIPROP_JOYSTICKID       equ 15

DIPROP_GETPORTDISPLAYNAME       equ 16

endif ; DIRECTINPUT_VERSION >= 005b2

if DIRECTINPUT_VERSION ge 00700h
DIPROP_PHYSICALRANGE            equ 18

DIPROP_LOGICALRANGE             equ 19
endif ; DIRECTINPUT_VERSION >= 00700h

if DIRECTINPUT_VERSION ge 00800h
DIPROP_KEYNAME                     equ 20

DIPROP_CPOINTS                 equ 21

DIPROP_APPDATA       equ 22

DIPROP_SCANCODE      equ 23

DIPROP_VIDPID           equ 24

DIPROP_USERNAME         equ 25

DIPROP_TYPENAME         equ 26
endif ; DIRECTINPUT_VERSION >= 00800h

DIDEVICEOBJECTDATA_DX3 struct
dwOfs dword ?
dwData dword ?
dwTimeStamp dword ?
dwSequence dword ?
DIDEVICEOBJECTDATA_DX3 ends
LPDIDEVICEOBJECTDATA_DX3 typedef ptr DIDEVICEOBJECTDATA_DX3
LPCDIDEVICEOBJECTDATA_DX typedef ptr DIDEVICEOBJECTDATA_DX3

DIDEVICEOBJECTDATA struct
dwOfs dword ?
dwData dword ?
dwTimeStamp dword ?
dwSequence dword ?
if DIRECTINPUT_VERSION ge 00800h
uAppData dword ?
endif ; DIRECTINPUT_VERSION >= 00800h
DIDEVICEOBJECTDATA ends
LPDIDEVICEOBJECTDATA typedef ptr DIDEVICEOBJECTDATA
LPCDIDEVICEOBJECTDATA typedef ptr DIDEVICEOBJECTDATA

DIGDD_PEEK          equ 000000001h

;#define DISEQUENCE_COMPARE(dwSequence1, cmp, dwSequence2) \
;                        ((int)((dwSequence1) - (dwSequence2)) cmp 0)
DISCL_EXCLUSIVE     equ 000000001h
DISCL_NONEXCLUSIVE  equ 000000002h
DISCL_FOREGROUND    equ 000000004h
DISCL_BACKGROUND    equ 000000008h
DISCL_NOWINKEY      equ 000000010h

if DIRECTINPUT_VERSION ge 00500h
; These structures are defined for DirectX 3.0 compatibility 

DIDEVICEINSTANCE_DX3A struct
dwSize dword ?
guidInstance GUID <>
guidProduct GUID <>
dwDevType dword ?
tszInstanceName byte MAX_PATH dup (?)
tszProductName byte MAX_PATH dup (?)
DIDEVICEINSTANCE_DX3A ends
LPDIDEVICEINSTANCE_DX3A typedef ptr DIDEVICEINSTANCE_DX3A

DIDEVICEINSTANCE_DX3 equ <DIDEVICEINSTANCE_DX3A>
LPDIDEVICEINSTANCE_DX3 equ <LPDIDEVICEINSTANCE_DX3A>

LPCDIDEVICEINSTANCE_DX3A typedef ptr DIDEVICEINSTANCE_DX3A
LPCDIDEVICEINSTANCE_DX3 typedef ptr DIDEVICEINSTANCE_DX3
endif ; DIRECTINPUT_VERSION >= 0x0500

DIDEVICEINSTANCEA struct
dwSize dword ?
guidInstance GUID <>
guidProduct GUID <>
dwDevType dword ?
tszInstanceName byte MAX_PATH dup (?)
tszProductName byte MAX_PATH dup (?)
if DIRECTINPUT_VERSION ge 00500
guidFFDriver GUID <>
wUsagePage word ?
wUsage word ?
endif ; DIRECTINPUT_VERSION >= 00500h
DIDEVICEINSTANCEA ends
LPDIDEVICEINSTANCEA typedef ptr DIDEVICEINSTANCEA

DIDEVICEINSTANCE equ <DIDEVICEINSTANCEA>
LPDIDEVICEINSTANCE equ <LPDIDEVICEINSTANCEA>

LPCDIDEVICEINSTANCEA typedef ptr DIDEVICEINSTANCEA
LPCDIDEVICEINSTANCE equ <LPCDIDEVICEINSTANCEA>
LPCDIDEVICEINSTANCEA typedef ptr DIDEVICEINSTANCEA

IDirectInputDeviceA     struct
;*** IUnknown methods ***
STDMETHOD QueryInterface,:PTR ,:PTR,:PTR PTR
STDMETHOD AddRef,:PTR 
STDMETHOD Release,:PTR 

;*** IDirectInputDeviceA methods ***/
STDMETHOD GetCapabilities,:ptr ,:dword
STDMETHOD EnumObjects,:ptr ,:dword,:dword,:dword
STDMETHOD GetProperty,:ptr ,:dword,:dword
STDMETHOD SetProperty,:ptr ,:dword,:dword
STDMETHOD Acquire,:ptr 
STDMETHOD Unacquire,:ptr 
STDMETHOD GetDeviceState,:ptr ,:dword,:dword
STDMETHOD GetDeviceData,:ptr ,:dword,:dword,:dword,:dword
STDMETHOD SetDataFormat,:ptr ,:dword
STDMETHOD SetEventNotification,:ptr ,:dword
STDMETHOD SetCooperativeLevel,:ptr ,:dword,:dword
STDMETHOD GetObjectInfo,:ptr ,:dword,:dword,:dword
STDMETHOD GetDeviceInfo,:ptr ,:dword
STDMETHOD RunControlPanel,:ptr ,:dword,:dword
STDMETHOD Initialize,:ptr ,:dword,:dword,:dword
IDirectInputDeviceA     ends

LPDIRECTINPUTDEVICEA typedef ptr IDirectInputDeviceA

IID_IDirectInputDevice equ IID_IDirectInputDeviceA
IDirectInputDevice equ <IDirectInputDeviceA>
IDirectInputDeviceVtbl equ <IDirectInputDeviceAVtbl>
LPDIRECTINPUTDEVICE typedef ptr IDirectInputDevice

endif ; DIJ_RINGZERO


if DIRECTINPUT_VERSION ge 00500h

DISFFC_RESET            equ 000000001h
DISFFC_STOPALL          equ 000000002h
DISFFC_PAUSE            equ 000000004h
DISFFC_CONTINUE         equ 000000008h
DISFFC_SETACTUATORSON   equ 000000010h
DISFFC_SETACTUATORSOFF  equ 000000020h

DIGFFS_EMPTY            equ 000000001h
DIGFFS_STOPPED          equ 000000002h
DIGFFS_PAUSED           equ 000000004h
DIGFFS_ACTUATORSON      equ 000000010h
DIGFFS_ACTUATORSOFF     equ 000000020h
DIGFFS_POWERON          equ 000000040h
DIGFFS_POWEROFF         equ 000000080h
DIGFFS_SAFETYSWITCHON   equ 000000100h
DIGFFS_SAFETYSWITCHOFF  equ 000000200h
DIGFFS_USERFFSWITCHON   equ 000000400h
DIGFFS_USERFFSWITCHOFF  equ 000000800h
DIGFFS_DEVICELOST       equ 080000000h

ifndef DIJ_RINGZERO

DIEFFECTINFOA struct
dwSize dword ?
guid GUID <>
dwEffType dword ?
dwStaticParams dword ?
dwDynamicParams dword ?
tszName byte MAX_PATH dup (?)
DIEFFECTINFOA ends
LPDIEFFECTINFOA typedef ptr DIEFFECTINFOA

DIEFFECTINFO equ <DIEFFECTINFOA>
LPDIEFFECTINFO equ <LPDIEFFECTINFOA>
LPCDIEFFECTINFOA typedef ptr DIEFFECTINFOA
LPCDIEFFECTINFO typedef ptr DIEFFECTINFO

DISDD_CONTINUE          equ 000000001h

LPDIENUMEFFECTSCALLBACKA_proto typedef proto pascal :dword , :dword 
LPDIENUMEFFECTSCALLBACKA typedef ptr LPDIENUMEFFECTSCALLBACKA_proto

LPDIENUMEFFECTSCALLBACK  equ <LPDIENUMEFFECTSCALLBACKA>

LPDIENUMCREATEDEFFECTOBJECTSCALLBACK_proto typedef proto pascal :dword , :dword 
LPDIENUMCREATEDEFFECTOBJECTSCALLBACK typedef ptr LPDIENUMCREATEDEFFECTOBJECTSCALLBACK_proto

IDirectInputDevice2A    struct
;*** IUnknown methods ***
STDMETHOD QueryInterface,:PTR ,:PTR,:PTR PTR
STDMETHOD AddRef,:PTR 
STDMETHOD Release,:PTR 

;*** IDirectInputDeviceA methods ***/
STDMETHOD GetCapabilities,:ptr ,:dword
STDMETHOD EnumObjects,:ptr ,:dword,:dword,:dword
STDMETHOD GetProperty,:ptr ,:dword,:dword
STDMETHOD SetProperty,:ptr ,:dword,:dword
STDMETHOD Acquire,:ptr 
STDMETHOD Unacquire,:ptr 
STDMETHOD GetDeviceState,:ptr ,:dword,:dword
STDMETHOD GetDeviceData,:ptr ,:dword,:dword,:dword,:dword
STDMETHOD SetDataFormat,:ptr ,:dword
STDMETHOD SetEventNotification,:ptr ,:dword
STDMETHOD SetCooperativeLevel,:ptr ,:dword,:dword
STDMETHOD GetObjectInfo,:ptr ,:dword,:dword,:dword
STDMETHOD GetDeviceInfo,:ptr ,:dword
STDMETHOD RunControlPanel,:ptr ,:dword,:dword
STDMETHOD Initialize,:ptr ,:dword,:dword,:dword

;*** IDirectInputDevice2A methods ***
STDMETHOD CreateEffect,:ptr ,:dword,:dword,:dword,:dword
STDMETHOD EnumEffects,:ptr ,:dword,:dword,:dword
STDMETHOD GetEffectInfo,:ptr ,:dword,:dword
STDMETHOD GetForceFeedbackState,:ptr ,:dword
STDMETHOD SendForceFeedbackCommand,:ptr ,:dword
STDMETHOD EnumCreatedEffectObjects,:ptr ,:dword,:dword,:dword
STDMETHOD Escape,:ptr ,:dword
STDMETHOD Poll,:ptr 
STDMETHOD SendDeviceData,:ptr ,:dword,:dword,:dword,:dword
IDirectInputDevice2A    ends

LPDIRECTINPUTDEVICE2A typedef ptr IDirectInputDevice2A

IID_IDirectInputDevice2 equ IID_IDirectInputDevice2A
IDirectInputDevice2 equ <IDirectInputDevice2A>
IDirectInputDevice2Vtbl equ <IDirectInputDevice2AVtbl>
LPDIRECTINPUTDEVICE2 typedef ptr IDirectInputDevice2

endif ; DIJ_RINGZERO

endif ; DIRECTINPUT_VERSION >= 00500h

if DIRECTINPUT_VERSION ge 00700h
DIFEF_DEFAULT               equ 000000000h
DIFEF_INCLUDENONSTANDARD    equ 000000001h
DIFEF_MODIFYIFNEEDED            equ 000000010h

ifndef DIJ_RINGZERO

IDirectInputDevice7A    struct
;*** IUnknown methods ***
STDMETHOD QueryInterface,:PTR ,:PTR,:PTR PTR
STDMETHOD AddRef,:PTR 
STDMETHOD Release,:PTR 

;*** IDirectInputDeviceA methods ***/
STDMETHOD GetCapabilities,:ptr ,:dword
STDMETHOD EnumObjects,:ptr ,:dword,:dword,:dword
STDMETHOD GetProperty,:ptr ,:dword,:dword
STDMETHOD SetProperty,:ptr ,:dword,:dword
STDMETHOD Acquire,:ptr 
STDMETHOD Unacquire,:ptr 
STDMETHOD GetDeviceState,:ptr ,:dword,:dword
STDMETHOD GetDeviceData,:ptr ,:dword,:dword,:dword,:dword
STDMETHOD SetDataFormat,:ptr ,:dword
STDMETHOD SetEventNotification,:ptr ,:dword
STDMETHOD SetCooperativeLevel,:ptr ,:dword,:dword
STDMETHOD GetObjectInfo,:ptr ,:dword,:dword,:dword
STDMETHOD GetDeviceInfo,:ptr ,:dword
STDMETHOD RunControlPanel,:ptr ,:dword,:dword
STDMETHOD Initialize,:ptr ,:dword,:dword,:dword

;*** IDirectInputDevice2A methods ***
STDMETHOD CreateEffect,:ptr ,:dword,:dword,:dword,:dword
STDMETHOD EnumEffects,:ptr ,:dword,:dword,:dword
STDMETHOD GetEffectInfo,:ptr ,:dword,:dword
STDMETHOD GetForceFeedbackState,:ptr ,:dword
STDMETHOD SendForceFeedbackCommand,:ptr ,:dword
STDMETHOD EnumCreatedEffectObjects,:ptr ,:dword,:dword,:dword
STDMETHOD Escape,:ptr ,:dword
STDMETHOD Poll,:ptr 
STDMETHOD SendDeviceData,:ptr ,:dword,:dword,:dword,:dword

;*** IDirectInputDevice7A methods ***
STDMETHOD EnumEffectsInFile,:ptr ,:dword,:dword,:dword,:dword
STDMETHOD WriteEffectToFile,:ptr ,:dword,:dword,:dword,:dword
IDirectInputDevice7A    ends

LPDIRECTINPUTDEVICE7A typedef ptr IDirectInputDevice7A

IID_IDirectInputDevice7 equ IID_IDirectInputDevice7A
IDirectInputDevice7 equ <IDirectInputDevice7A>
IDirectInputDevice7Vtbl equ <IDirectInputDevice7AVtbl>
LPDIRECTINPUTDEVICE7 typedef ptr IDirectInputDevice7

endif ; DIJ_RINGZERO

endif ; DIRECTINPUT_VERSION >= 00700h

if DIRECTINPUT_VERSION ge 00800h

ifndef DIJ_RINGZERO

IDirectInputDevice8A    struct
;*** IUnknown methods ***
STDMETHOD QueryInterface,:PTR ,:PTR,:PTR PTR
STDMETHOD AddRef,:PTR 
STDMETHOD Release,:PTR 

;*** IDirectInputDevice8A methods ***
STDMETHOD GetCapabilities,:PTR ,:dword
STDMETHOD EnumObjects,:PTR ,:dword,:dword,:dword
STDMETHOD GetProperty,:PTR ,:dword,:dword
STDMETHOD SetProperty,:PTR ,:dword,:dword
STDMETHOD Acquire,:PTR 
STDMETHOD Unacquire,:PTR 
STDMETHOD GetDeviceState,:PTR ,:dword,:dword
STDMETHOD GetDeviceData,:PTR ,:dword,:dword,:dword,:dword
STDMETHOD SetDataFormat,:PTR ,:dword
STDMETHOD SetEventNotification,:PTR ,:dword
STDMETHOD SetCooperativeLevel,:PTR ,:dword,:dword
STDMETHOD GetObjectInfo,:PTR ,:dword,:dword,:dword
STDMETHOD GetDeviceInfo,:PTR ,:dword
STDMETHOD RunControlPanel,:PTR ,:dword,:dword
STDMETHOD Initialize,:PTR ,:dword,:dword,:dword
STDMETHOD CreateEffect,:PTR ,:dword,:dword,:dword,:dword
STDMETHOD EnumEffects,:PTR ,:dword,:dword,:dword
STDMETHOD GetEffectInfo,:PTR ,:dword,:dword
STDMETHOD GetForceFeedbackState,:PTR ,:dword
STDMETHOD SendForceFeedbackCommand,:PTR ,:dword
STDMETHOD EnumCreatedEffectObjects,:PTR ,:dword,:dword,:dword
STDMETHOD Escape,:PTR ,:dword
STDMETHOD Poll,:PTR 
STDMETHOD SendDeviceData,:PTR ,:dword,:dword,:dword,:dword
STDMETHOD EnumEffectsInFile,:PTR ,:dword,:dword,:dword,:dword
STDMETHOD WriteEffectToFile,:PTR ,:dword,:dword,:dword,:dword
STDMETHOD BuildActionMap,:PTR ,:dword,:dword,:dword
STDMETHOD SetActionMap,:PTR ,:dword,:dword,:dword
STDMETHOD GetImageInfo,:PTR ,:dword
IDirectInputDevice8A    ends

LPDIRECTINPUTDEVICE8A typedef ptr IDirectInputDevice8A

IID_IDirectInputDevice8 equ IID_IDirectInputDevice8A
IDirectInputDevice8 equ <IDirectInputDevice8A>
IDirectInputDevice8Vtbl equ <IDirectInputDevice8AVtbl>
LPDIRECTINPUTDEVICE8 typedef ptr IDirectInputDevice8

endif ; DIJ_RINGZERO

endif ; DIRECTINPUT_VERSION >= 0x0800

;****************************************************************************
;*
;*      Mouse
;*
;****************************************************************************

ifndef DIJ_RINGZERO

DIMOUSESTATE struct
lX dword ?
lY dword ?
lZ dword ?
rgbButtons byte 4 dup (?)
DIMOUSESTATE ends
LPDIMOUSESTATE typedef ptr DIMOUSESTATE

if DIRECTINPUT_VERSION ge 00700h
DIMOUSESTATE2 struct
lX dword ?
lY dword ?
lZ dword ?
rgbButtons byte 8 dup (?)
DIMOUSESTATE2 ends
LPDIMOUSESTATE2 typedef ptr DIMOUSESTATE2
endif

DIMOFS_X        equ 0
DIMOFS_Y        equ (1 * 4)
DIMOFS_Z        equ (2 * 4)
DIMOFS_BUTTON0 equ (3 * 4) + 0
DIMOFS_BUTTON1 equ (3 * 4) + 1
DIMOFS_BUTTON2 equ (3 * 4) + 2
DIMOFS_BUTTON3 equ (3 * 4) + 3
if DIRECTINPUT_VERSION ge 00700h
DIMOFS_BUTTON4 equ (3 * 4) + 4
DIMOFS_BUTTON5 equ (3 * 4) + 5
DIMOFS_BUTTON6 equ (3 * 4) + 6
DIMOFS_BUTTON7 equ (3 * 4) + 7
endif
endif ; DIJ_RINGZERO

;****************************************************************************
;*
;*      Keyboard
;*
;****************************************************************************

ifndef DIJ_RINGZERO

;****************************************************************************
;*
;*      DirectInput keyboard scan codes
;*
;****************************************************************************
DIK_ESCAPE          equ 001h
DIK_1               equ 002h
DIK_2               equ 003h
DIK_3               equ 004h
DIK_4               equ 005h
DIK_5               equ 006h
DIK_6               equ 007h
DIK_7               equ 008h
DIK_8               equ 009h
DIK_9               equ 00Ah
DIK_0               equ 00Bh
DIK_MINUS           equ 00Ch    ; - on main keyboard
DIK_EQUALS          equ 00Dh
DIK_BACK            equ 00Eh    ; backspace
DIK_TAB             equ 00Fh
DIK_Q               equ 010h
DIK_W               equ 011h
DIK_E               equ 012h
DIK_R               equ 013h
DIK_T               equ 014h
DIK_Y               equ 015h
DIK_U               equ 016h
DIK_I               equ 017h
DIK_O               equ 018h
DIK_P               equ 019h
DIK_LBRACKET        equ 01Ah
DIK_RBRACKET        equ 01Bh
DIK_RETURN          equ 01Ch    ; Enter on main keyboard
DIK_LCONTROL        equ 01Dh
DIK_A               equ 01Eh
DIK_S               equ 01Fh
DIK_D               equ 020h
DIK_F               equ 021h
DIK_G               equ 022h
DIK_H               equ 023h
DIK_J               equ 024h
DIK_K               equ 025h
DIK_L               equ 026h
DIK_SEMICOLON       equ 027h
DIK_APOSTROPHE      equ 028h
DIK_GRAVE           equ 029h    ; accent grave
DIK_LSHIFT          equ 02Ah
DIK_BACKSLASH       equ 02Bh
DIK_Z               equ 02Ch
DIK_X               equ 02Dh
DIK_C               equ 02Eh
DIK_V               equ 02Fh
DIK_B               equ 030h
DIK_N               equ 031h
DIK_M               equ 032h
DIK_COMMA           equ 033h
DIK_PERIOD          equ 034h    ; . on main keyboard
DIK_SLASH           equ 035h    ; / on main keyboard
DIK_RSHIFT          equ 036h
DIK_MULTIPLY        equ 037h    ; * on numeric keypad
DIK_LMENU           equ 038h    ; left Alt
DIK_SPACE           equ 039h
DIK_CAPITAL         equ 03Ah
DIK_F1              equ 03Bh
DIK_F2              equ 03Ch
DIK_F3              equ 03Dh
DIK_F4              equ 03Eh
DIK_F5              equ 03Fh
DIK_F6              equ 040h
DIK_F7              equ 041h
DIK_F8              equ 042h
DIK_F9              equ 043h
DIK_F10             equ 044h
DIK_NUMLOCK         equ 045h
DIK_SCROLL          equ 046h    ; Scroll Lock
DIK_NUMPAD7         equ 047h
DIK_NUMPAD8         equ 048h
DIK_NUMPAD9         equ 049h
DIK_SUBTRACT        equ 04Ah    ; - on numeric keypad
DIK_NUMPAD4         equ 04Bh
DIK_NUMPAD5         equ 04Ch
DIK_NUMPAD6         equ 04Dh
DIK_ADD             equ 04Eh    ; + on numeric keypad
DIK_NUMPAD1         equ 04Fh
DIK_NUMPAD2         equ 050h
DIK_NUMPAD3         equ 051h
DIK_NUMPAD0         equ 052h
DIK_DECIMAL         equ 053h    ; . on numeric keypad
DIK_OEM_102         equ 056h    ; <> or \| on RT 102-key keyboard (Non-U.S.)
DIK_F11             equ 057h
DIK_F12             equ 058h
DIK_F13             equ 064h    ;                     (NEC PC98)
DIK_F14             equ 065h    ;                     (NEC PC98)
DIK_F15             equ 066h    ;                     (NEC PC98)
DIK_KANA            equ 070h    ; (Japanese keyboard)
DIK_ABNT_C1         equ 073h    ; /? on Brazilian keyboard
DIK_CONVERT         equ 079h    ; (Japanese keyboard)
DIK_NOCONVERT       equ 07Bh    ; (Japanese keyboard)
DIK_YEN             equ 07Dh    ; (Japanese keyboard)
DIK_ABNT_C2         equ 07Eh    ; Numpad . on Brazilian keyboard
DIK_NUMPADEQUALS    equ 08Dh    ; = on numeric keypad (NEC PC98)
DIK_PREVTRACK       equ 090h    ; Previous Track (DIK_CIRCUMFLEX on Japanese keyboard)
DIK_AT              equ 091h    ;                     (NEC PC98)
DIK_COLON           equ 092h    ;                     (NEC PC98)
DIK_UNDERLINE       equ 093h    ;                     (NEC PC98)
DIK_KANJI           equ 094h    ; (Japanese keyboard)
DIK_STOP            equ 095h    ;                     (NEC PC98)
DIK_AX              equ 096h    ;                     (Japan AX)
DIK_UNLABELED       equ 097h    ;                        (J3100)
DIK_NEXTTRACK       equ 099h    ; Next Track
DIK_NUMPADENTER     equ 09Ch    ; Enter on numeric keypad
DIK_RCONTROL        equ 09Dh
DIK_MUTE            equ 0A0h    ; Mute
DIK_CALCULATOR      equ 0A1h    ; Calculator
DIK_PLAYPAUSE       equ 0A2h    ; Play / Pause
DIK_MEDIASTOP       equ 0A4h    ; Media Stop
DIK_VOLUMEDOWN      equ 0AEh    ; Volume -
DIK_VOLUMEUP        equ 0B0h    ; Volume +
DIK_WEBHOME         equ 0B2h    ; Web home
DIK_NUMPADCOMMA     equ 0B3h    ; , on numeric keypad (NEC PC98)
DIK_DIVIDE          equ 0B5h    ; / on numeric keypad
DIK_SYSRQ           equ 0B7h
DIK_RMENU           equ 0B8h    ; right Alt
DIK_PAUSE           equ 0C5h    ; Pause
DIK_HOME            equ 0C7h    ; Home on arrow keypad
DIK_UP              equ 0C8h    ; UpArrow on arrow keypad
DIK_PRIOR           equ 0C9h    ; PgUp on arrow keypad
DIK_LEFT            equ 0CBh    ; LeftArrow on arrow keypad
DIK_RIGHT           equ 0CDh    ; RightArrow on arrow keypad
DIK_END             equ 0CFh    ; End on arrow keypad
DIK_DOWN            equ 0D0h    ; DownArrow on arrow keypad
DIK_NEXT            equ 0D1h    ; PgDn on arrow keypad
DIK_INSERT          equ 0D2h    ; Insert on arrow keypad
DIK_DELETE          equ 0D3h    ; Delete on arrow keypad
DIK_LWIN            equ 0DBh    ; Left Windows key
DIK_RWIN            equ 0DCh    ; Right Windows key
DIK_APPS            equ 0DDh    ; AppMenu key
DIK_POWER           equ 0DEh    ; System Power
DIK_SLEEP           equ 0DFh    ; System Sleep
DIK_WAKE            equ 0E3h    ; System Wake
DIK_WEBSEARCH       equ 0E5h    ; Web Search
DIK_WEBFAVORITES    equ 0E6h    ; Web Favorites
DIK_WEBREFRESH      equ 0E7h    ; Web Refresh
DIK_WEBSTOP         equ 0E8h    ; Web Stop
DIK_WEBFORWARD      equ 0E9h    ; Web Forward
DIK_WEBBACK         equ 0EAh    ; Web Back
DIK_MYCOMPUTER      equ 0EBh    ; My Computer
DIK_MAIL            equ 0ECh    ; Mail
DIK_MEDIASELECT     equ 0EDh    ; Media Select

;*
;*  Alternate names for keys, to facilitate transition from DOS.
;*
DIK_BACKSPACE       equ DIK_BACK            ; backspace
DIK_NUMPADSTAR      equ DIK_MULTIPLY        ; * on numeric keypad
DIK_LALT            equ DIK_LMENU           ; left Alt
DIK_CAPSLOCK        equ DIK_CAPITAL         ; CapsLock
DIK_NUMPADMINUS     equ DIK_SUBTRACT        ; - on numeric keypad
DIK_NUMPADPLUS      equ DIK_ADD             ; + on numeric keypad
DIK_NUMPADPERIOD    equ DIK_DECIMAL         ; . on numeric keypad
DIK_NUMPADSLASH     equ DIK_DIVIDE          ; / on numeric keypad
DIK_RALT            equ DIK_RMENU           ; right Alt
DIK_UPARROW         equ DIK_UP              ; UpArrow on arrow keypad
DIK_PGUP            equ DIK_PRIOR           ; PgUp on arrow keypad
DIK_LEFTARROW       equ DIK_LEFT            ; LeftArrow on arrow keypad
DIK_RIGHTARROW      equ DIK_RIGHT           ; RightArrow on arrow keypad
DIK_DOWNARROW       equ DIK_DOWN            ; DownArrow on arrow keypad
DIK_PGDN            equ DIK_NEXT            ; PgDn on arrow keypad

;*
;*  Alternate names for keys originally not used on US keyboards.
;*
DIK_CIRCUMFLEX      equ DIK_PREVTRACK       ; Japanese keyboard

endif ; DIJ_RINGZERO

;****************************************************************************
;*
;*      Joystick
;*
;****************************************************************************

ifndef DIJ_RINGZERO

DIJOYSTATE struct
lX dword ?                     ; x-axis position
lY dword ?                     ; y-axis position
lZ dword ?                     ; z-axis position
lRx dword ?                    ; x-axis rotation
lRy dword ?                    ; y-axis rotation
lRz dword ?                    ; z-axis rotation
rglSlider dd 2 dup (?)           ; extra axes positions
rgdwPOV dd 4 dup (?)             ; POV directions
rgbButtons db 32 dup (?)         ; 32 buttons
DIJOYSTATE ends
LPDIJOYSTATE typedef ptr DIJOYSTATE

DIJOYSTATE2 struct
lX dword ?                     ; x-axis position
lY dword ?                     ; y-axis position
lZ dword ?                     ; z-axis position
lRx dword ?                    ; x-axis rotation
lRy dword ?                    ; y-axis rotation
lRz dword ?                    ; z-axis rotation
rglSlider dword 2 dup (?)          ; extra axes positions
rgdwPOV dword 4 dup (?)          ; POV directions
rgbButtons byte 128 dup (?)       ; 128 buttons
lVX dword ?                    ; x-axis velocity
lVY dword ?                   ; y-axis velocity
lVZ dword ?                    ; z-axis velocity
lVRx dword ?                  ; x-axis angular velocity
lVRy dword ?                   ; y-axis angular velocity
lVRz dword ?                   ; z-axis angular velocity
rglVSlider dword 2 dup (?)          ; extra axes velocities
lAX dword ?                   ; x-axis acceleration
lAY dword ?                   ; y-axis acceleration
lAZ dword ?                   ; z-axis acceleration
lARx dword ?                  ; x-axis angular acceleration
lARy dword ?                  ; y-axis angular acceleration
lARz dword ?                   ; z-axis angular acceleration
rglASlider dword 2 dup (?)          ; extra axes accelerations
lFX dword ?                   ; x-axis force
lFY dword ?                   ; y-axis force
lFZ dword ?                   ; z-axis force
lFRx dword ?                  ; x-axis torque
lFRy dword ?                  ; y-axis torque
lFRz dword ?                  ; z-axis torque
rglFSlider dword 2 dup (?)          ; extra axes forces
DIJOYSTATE2 ends
LPDIJOYSTATE2 typedef ptr DIJOYSTATE2

DIJOFS_X            equ 0
DIJOFS_Y            equ (1 * 4)
DIJOFS_Z            equ (2 * 4)
DIJOFS_RX           equ (3 * 4)
DIJOFS_RY           equ (4 * 4)
DIJOFS_RZ           equ (5 * 4)
DIJOFS_SLIDER1      equ (6 * 4)
DIJOFS_SLIDER2      equ (7 * 4)

DIJOFS_POV1         equ (8 * 4)
DIJOFS_POV2         equ (9 * 4)
DIJOFS_POV3         equ (10 * 4)
DIJOFS_POV4         equ (11 * 4)

DIJOFS_BUTTON0      equ (12 * 4)
DIJOFS_BUTTON1      equ (13 * 4)
DIJOFS_BUTTON2      equ (14 * 4)
DIJOFS_BUTTON3      equ (15 * 4)
DIJOFS_BUTTON4      equ (16 * 4)
DIJOFS_BUTTON5      equ (17 * 4)
DIJOFS_BUTTON6      equ (18 * 4)
DIJOFS_BUTTON7      equ (19 * 4)
DIJOFS_BUTTON8      equ (20 * 4)
DIJOFS_BUTTON9      equ (21 * 4)
DIJOFS_BUTTON10     equ (22 * 4)
DIJOFS_BUTTON11     equ (23 * 4)
DIJOFS_BUTTON12     equ (24 * 4)
DIJOFS_BUTTON13     equ (25 * 4)
DIJOFS_BUTTON14     equ (26 * 4)
DIJOFS_BUTTON15     equ (27 * 4)
DIJOFS_BUTTON16     equ (28 * 4)
DIJOFS_BUTTON17     equ (29 * 4)
DIJOFS_BUTTON18     equ (30 * 4)
DIJOFS_BUTTON19     equ (31 * 4)
DIJOFS_BUTTON20     equ (32 * 4)
DIJOFS_BUTTON21     equ (33 * 4)
DIJOFS_BUTTON22     equ (34 * 4)
DIJOFS_BUTTON23     equ (35 * 4)
DIJOFS_BUTTON24     equ (36 * 4)
DIJOFS_BUTTON25     equ (37 * 4)
DIJOFS_BUTTON26     equ (38 * 4)
DIJOFS_BUTTON27     equ (39 * 4)
DIJOFS_BUTTON28     equ (40 * 4)
DIJOFS_BUTTON29     equ (41 * 4)
DIJOFS_BUTTON30     equ (42 * 4)
DIJOFS_BUTTON31     equ (43 * 4)

endif ; DIJ_RINGZERO

;****************************************************************************
;*
;*  IDirectInput
;*
;****************************************************************************

ifndef DIJ_RINGZERO

DIENUM_STOP             equ 0
DIENUM_CONTINUE         equ 1

LPDIENUMDEVICESCALLBACKA_proto typedef proto pascal :dword , :dword 
LPDIENUMDEVICESCALLBACKA typedef ptr LPDIENUMDEVICESCALLBACKA_proto

LPDIENUMDEVICESCALLBACK  equ <LPDIENUMDEVICESCALLBACKA>

LPDICONFIGUREDEVICESCALLBACK_proto typedef proto pascal :dword , :dword 
LPDICONFIGUREDEVICESCALLBACK typedef ptr LPDICONFIGUREDEVICESCALLBACK_proto

DIEDFL_ALLDEVICES       equ 000000000h
DIEDFL_ATTACHEDONLY     equ 000000001h
if DIRECTINPUT_VERSION ge 00500h
DIEDFL_FORCEFEEDBACK    equ 000000100h
endif ; DIRECTINPUT_VERSION >= 00500h
if DIRECTINPUT_VERSION ge 0050ah
DIEDFL_INCLUDEALIASES   equ 000010000h
DIEDFL_INCLUDEPHANTOMS  equ 000020000h
endif ; DIRECTINPUT_VERSION >= 0050a
if DIRECTINPUT_VERSION ge 00800h
DIEDFL_INCLUDEHIDDEN    equ 000040000h
endif ; DIRECTINPUT_VERSION >= 00800h


if DIRECTINPUT_VERSION ge 00800h
LPDIENUMDEVICESBYSEMANTICSCBA_proto typedef proto pascal :dword, :dword, :dword, :dword, :dword
LPDIENUMDEVICESBYSEMANTICSCBA typedef ptr LPDIENUMDEVICESBYSEMANTICSCBA_proto

LPDIENUMDEVICESBYSEMANTICSCB  equ <LPDIENUMDEVICESBYSEMANTICSCBA>
endif ; DIRECTINPUT_VERSION >= 00800h

if DIRECTINPUT_VERSION ge 00800h
DIEDBS_MAPPEDPRI1         equ 000000001h
DIEDBS_MAPPEDPRI2         equ 000000002h
DIEDBS_RECENTDEVICE       equ 000000010h
DIEDBS_NEWDEVICE          equ 000000020h
endif ; DIRECTINPUT_VERSION >= 00800h

if DIRECTINPUT_VERSION ge 00800h
DIEDBSFL_ATTACHEDONLY       equ 000000000h
DIEDBSFL_THISUSER           equ 000000010h
DIEDBSFL_FORCEFEEDBACK      equ DIEDFL_FORCEFEEDBACK
DIEDBSFL_AVAILABLEDEVICES   equ 000001000h
DIEDBSFL_MULTIMICEKEYBOARDS equ 000002000h
DIEDBSFL_NONGAMINGDEVICES   equ 000004000h
DIEDBSFL_VALID              equ 000007110h
endif ; DIRECTINPUT_VERSION >= 00800h

IDirectInputA   struct
;*** IUnknown methods ***
STDMETHOD QueryInterface,:PTR ,:PTR,:PTR PTR
STDMETHOD AddRef,:PTR 
STDMETHOD Release,:PTR 

;*** IDirectInputA methods ***
STDMETHOD CreateDevice,:PTR ,:dword,:dword,:dword
STDMETHOD EnumDevices,:PTR ,:dword,:dword,:dword,:dword
STDMETHOD GetDeviceStatus,:PTR ,:dword
STDMETHOD RunControlPanel,:PTR ,:dword,:dword
STDMETHOD Initialize,:PTR ,:dword,:dword
IDirectInputA   ends

LPDIRECTINPUTA typedef ptr IDirectInputA

IID_IDirectInput equ IID_IDirectInputA
IDirectInput equ <IDirectInputA>
IDirectInputVtbl equ <IDirectInputAVtbl>
LPDIRECTINPUT typedef ptr IDirectInput

IDirectInput2A  struct
;*** IUnknown methods ***
STDMETHOD QueryInterface,:PTR ,:PTR,:PTR PTR
STDMETHOD AddRef,:PTR 
STDMETHOD Release,:PTR 

;*** IDirectInputA methods ***
STDMETHOD CreateDevice,:PTR ,:dword,:dword,:dword
STDMETHOD EnumDevices,:PTR ,:dword,:dword,:dword,:dword
STDMETHOD GetDeviceStatus,:PTR ,:dword
STDMETHOD RunControlPanel,:PTR ,:dword,:dword
STDMETHOD Initialize,:PTR ,:dword,:dword

;*** IDirectInput2A methods ***
STDMETHOD FindDevice,:PTR ,:dword,:dword,:dword
IDirectInput2A  ends

LPDIRECTINPUT2A typedef ptr IDirectInput2A

IID_IDirectInput2 equ IID_IDirectInput2A
IDirectInput2 equ <IDirectInput2A>
IDirectInput2Vtbl equ <IDirectInput2AVtbl>
LPDIRECTINPUT2 typedef ptr IDirectInput2

IDirectInput7A  struct
;*** IUnknown methods ***
STDMETHOD QueryInterface,:PTR ,:PTR,:PTR PTR
STDMETHOD AddRef,:PTR 
STDMETHOD Release,:PTR 

;*** IDirectInputA methods ***
STDMETHOD CreateDevice,:PTR ,:dword,:dword,:dword
STDMETHOD EnumDevices,:PTR ,:dword,:dword,:dword,:dword
STDMETHOD GetDeviceStatus,:PTR ,:dword
STDMETHOD RunControlPanel,:PTR ,:dword,:dword
STDMETHOD Initialize,:PTR ,:dword,:dword

;*** IDirectInput2A methods ***
STDMETHOD FindDevice,:PTR ,:dword,:dword,:dword

;*** IDirectInput7A methods ***
STDMETHOD CreateDeviceEx,:PTR ,:dword,:dword,:dword,:dword
IDirectInput7A  ends

LPDIRECTINPUT7A typedef ptr IDirectInput7A

IID_IDirectInput7 equ IID_IDirectInput7A
IDirectInput7 equ <IDirectInput7A>
IDirectInput7Vtbl equ <IDirectInput7AVtbl>
LPDIRECTINPUT7 typedef ptr IDirectInput7

if DIRECTINPUT_VERSION ge 00800h

IDirectInput8A  struct
;*** IUnknown methods ***
STDMETHOD QueryInterface,:PTR ,:PTR,:PTR PTR
STDMETHOD AddRef,:PTR 
STDMETHOD Release,:PTR 

;*** IDirectInput8A methods ***
STDMETHOD CreateDevice,:PTR ,:dword,:dword,:dword
STDMETHOD EnumDevices,:PTR ,:dword,:dword,:dword,:dword
STDMETHOD GetDeviceStatus,:PTR ,:dword
STDMETHOD RunControlPanel,:PTR ,:dword,:dword
STDMETHOD Initialize,:PTR ,:dword,:dword
STDMETHOD FindDevice,:PTR ,:dword,:dword,:dword
STDMETHOD EnumDevicesBySemantics,:PTR ,:dword,:dword,:dword,:dword,:dword
STDMETHOD ConfigureDevices,:PTR ,:dword,:dword,:dword,:dword
IDirectInput8A  ends

LPDIRECTINPUT8A typedef ptr IDirectInput8A

IID_IDirectInput8 equ IID_IDirectInput8A
IDirectInput8 equ <IDirectInput8A>
IDirectInput8Vtbl equ <IDirectInput8AVtbl>
LPDIRECTINPUT8 typedef ptr IDirectInput8

endif ; DIRECTINPUT_VERSION >= 00800h

if DIRECTINPUT_VERSION gt 00700h
DirectInput8Create      proto :dword, :dword, :dword, :dword, :dword

else
DirectInputCreateA      proto :dword, :dword, :dword, :dword
DirectInputCreate  equ  <DirectInputCreateA>

DirectInputCreateEx proto :dword, :dword, :dword, :dword, :dword

endif ; DIRECTINPUT_VERSION > 0700h

endif ; DIJ_RINGZERO


;****************************************************************************
;*
;*  Return Codes
;*
;****************************************************************************/

;*
;*  The operation completed successfully.
;*
DI_OK                           equ S_OK

;*
;*  The device exists but is not currently attached.
;*
DI_NOTATTACHED                  equ S_FALSE

;*
;*  The device buffer overflowed.  Some input was lost.
;*
DI_BUFFEROVERFLOW               equ S_FALSE

;*
;*  The change in device properties had no effect.
;*
DI_PROPNOEFFECT                 equ S_FALSE

;*
;*  The operation had no effect.
;*
DI_NOEFFECT                     equ S_FALSE

;*
;*  The device is a polled device.  As a result, device buffering
;*  will not collect any data and event notifications will not be
;*  signalled until GetDeviceState is called.
;*
DI_POLLEDDEVICE                 equ 000000002h

;*
;*  The parameters of the effect were successfully updated by
;*  IDirectInputEffect::SetParameters, but the effect was not
;*  downloaded because the device is not exclusively acquired
;*  or because the DIEP_NODOWNLOAD flag was passed.
;*
DI_DOWNLOADSKIPPED              equ 000000003h

;*
;*  The parameters of the effect were successfully updated by
;*  IDirectInputEffect::SetParameters, but in order to change
;*  the parameters, the effect needed to be restarted.
;*
DI_EFFECTRESTARTED              equ 000000004h

;*
;*  The parameters of the effect were successfully updated by
;*  IDirectInputEffect::SetParameters, but some of them were
;*  beyond the capabilities of the device and were truncated.
;*
DI_TRUNCATED                    equ 000000008h

;*
;*  The settings have been successfully applied but could not be 
;*  persisted. 
;*
DI_SETTINGSNOTSAVED             equ 00000000Bh

;*
;*  Equal to DI_EFFECTRESTARTED | DI_TRUNCATED.
;*
DI_TRUNCATEDANDRESTARTED        equ 00000000Ch

;*
;*  A SUCCESS code indicating that settings cannot be modified.
;*
DI_WRITEPROTECT                 equ 000000013h

;*
;*  The application requires a newer version of DirectInput.
;*
DIERR_OLDDIRECTINPUTVERSION     equ (SEVERITY_ERROR shl 31) or (FACILITY_WIN32 shl 16) or ERROR_OLD_WIN_VERSION

;*
;*  The application was written for an unsupported prerelease version
;*  of DirectInput.
;*
DIERR_BETADIRECTINPUTVERSION    equ (SEVERITY_ERROR shl 31) or (FACILITY_WIN32 shl 16) or ERROR_RMODE_APP

;*
;*  The object could not be created due to an incompatible driver version
;*  or mismatched or incomplete driver components.
;*
DIERR_BADDRIVERVER              equ (SEVERITY_ERROR shl 31) or (FACILITY_WIN32 shl 16) or ERROR_BAD_DRIVER_LEVEL

;*
;* The device or device instance or effect is not registered with DirectInput.
;
DIERR_DEVICENOTREG              equ REGDB_E_CLASSNOTREG

;*
;* The requested object does not exist.
;*
DIERR_NOTFOUND                  equ (SEVERITY_ERROR shl 31) or (FACILITY_WIN32 shl 16) or ERROR_FILE_NOT_FOUND

;*
;* The requested object does not exist.
;*
DIERR_OBJECTNOTFOUND            equ (SEVERITY_ERROR shl 31) or (FACILITY_WIN32 shl 16) or ERROR_FILE_NOT_FOUND

;*
;* An invalid parameter was passed to the returning function,
;* or the object was not in a state that admitted the function
;* to be called.
;*
DIERR_INVALIDPARAM              equ E_INVALIDARG

;*
;* The specified interface is not supported by the object
;*
DIERR_NOINTERFACE               equ E_NOINTERFACE

;*
;* An undetermined error occured inside the DInput subsystem
;*
DIERR_GENERIC                   equ E_FAIL

;*
;* The DInput subsystem couldn't allocate sufficient memory to complete the
;* caller's request.
;*
DIERR_OUTOFMEMORY               equ E_OUTOFMEMORY

;*
;* The function called is not supported at this time
;*
DIERR_UNSUPPORTED               equ E_NOTIMPL

;*
;* This object has not been initialized
;*
DIERR_NOTINITIALIZED            equ (SEVERITY_ERROR shl 31) or (FACILITY_WIN32 shl 16) or ERROR_NOT_READY

;*
;* This object is already initialized
;*
DIERR_ALREADYINITIALIZED        equ (SEVERITY_ERROR shl 31) or (FACILITY_WIN32 shl 16) or ERROR_ALREADY_INITIALIZED

;*
;* This object does not support aggregation
;*
DIERR_NOAGGREGATION             equ CLASS_E_NOAGGREGATION

;*
;* Another app has a higher priority level, preventing this call from
;* succeeding.
;*
DIERR_OTHERAPPHASPRIO           equ E_ACCESSDENIED

;*
;* Access to the device has been lost.  It must be re-acquired.
;*
DIERR_INPUTLOST                 equ (SEVERITY_ERROR shl 31) or (FACILITY_WIN32 shl 16) or ERROR_READ_FAULT

;*
;* The operation cannot be performed while the device is acquired.
;*
DIERR_ACQUIRED                  equ (SEVERITY_ERROR shl 31) or (FACILITY_WIN32 shl 16) or ERROR_BUSY

;*
;* The operation cannot be performed unless the device is acquired.
;*
DIERR_NOTACQUIRED               equ (SEVERITY_ERROR shl 31) or (FACILITY_WIN32 shl 16) or ERROR_INVALID_ACCESS

;*
;* The specified property cannot be changed.
;*
DIERR_READONLY                  equ E_ACCESSDENIED

;*
;* The device already has an event notification associated with it.
;*
DIERR_HANDLEEXISTS              equ E_ACCESSDENIED

;*
;* Data is not yet available.
;*
ifndef E_PENDING
E_PENDING                       equ 08000000Ah
endif

;*
;* Unable to IDirectInputJoyConfig_Acquire because the user
;* does not have sufficient privileges to change the joystick
;* configuration.
;*
DIERR_INSUFFICIENTPRIVS         equ 080040200h

;*
;* The device is full.
;*
DIERR_DEVICEFULL                equ 080040201h

;*
;* Not all the requested information fit into the buffer.
;*
DIERR_MOREDATA                  equ 080040202h

;*
;* The effect is not downloaded.
;*
DIERR_NOTDOWNLOADED             equ 080040203h

;*
;*  The device cannot be reinitialized because there are still effects
;*  attached to it.
;*
DIERR_HASEFFECTS                equ 080040204h

;*
;*  The operation cannot be performed unless the device is acquired
;*  in DISCL_EXCLUSIVE mode.
;*
DIERR_NOTEXCLUSIVEACQUIRED      equ 080040205h

;*
;*  The effect could not be downloaded because essential information
;*  is missing.  For example, no axes have been associated with the
;*  effect, or no type-specific information has been created.
;*
DIERR_INCOMPLETEEFFECT          equ 080040206h

;*
;*  Attempted to read buffered device data from a device that is
;*  not buffered.
;*
DIERR_NOTBUFFERED               equ 080040207h

;*
;*  An attempt was made to modify parameters of an effect while it is
;*  playing.  Not all hardware devices support altering the parameters
;*  of an effect while it is playing.
;*
DIERR_EFFECTPLAYING             equ 080040208h

;*
;*  The operation could not be completed because the device is not
;*  plugged in.
;*
DIERR_UNPLUGGED                 equ 080040209h

;*
;*  SendDeviceData failed because more information was requested
;*  to be sent than can be sent to the device.  Some devices have
;*  restrictions on how much data can be sent to them.  (For example,
;*  there might be a limit on the number of buttons that can be
;*  pressed at once.)
;*
DIERR_REPORTFULL                equ 08004020Ah


;*
;*  A mapper file function failed because reading or writing the user or IHV 
;*  settings file failed.
;*
DIERR_MAPFILEFAIL               equ 08004020Bh

; --- DINPUT Mapper Definitions: New for Dx8 ---

; --- Keyboard Physical Keyboard Device ---
DIKEYBOARD_ESCAPE                       equ 081000401h
DIKEYBOARD_1                            equ 081000402h
DIKEYBOARD_2                            equ 081000403h
DIKEYBOARD_3                            equ 081000404h
DIKEYBOARD_4                            equ 081000405h
DIKEYBOARD_5                            equ 081000406h
DIKEYBOARD_6                            equ 081000407h
DIKEYBOARD_7                            equ 081000408h
DIKEYBOARD_8                            equ 081000409h
DIKEYBOARD_9                            equ 08100040Ah
DIKEYBOARD_0                            equ 08100040Bh
DIKEYBOARD_MINUS                        equ 08100040Ch    ; - on main keyboard
DIKEYBOARD_EQUALS                       equ 08100040Dh
DIKEYBOARD_BACK                         equ 08100040Eh    ; backspace
DIKEYBOARD_TAB                          equ 08100040Fh
DIKEYBOARD_Q                            equ 081000410h
DIKEYBOARD_W                            equ 081000411h
DIKEYBOARD_E                            equ 081000412h
DIKEYBOARD_R                            equ 081000413h
DIKEYBOARD_T                            equ 081000414h
DIKEYBOARD_Y                            equ 081000415h
DIKEYBOARD_U                            equ 081000416h
DIKEYBOARD_I                            equ 081000417h
DIKEYBOARD_O                            equ 081000418h
DIKEYBOARD_P                            equ 081000419h
DIKEYBOARD_LBRACKET                     equ 08100041Ah
DIKEYBOARD_RBRACKET                     equ 08100041Bh
DIKEYBOARD_RETURN                       equ 08100041Ch    ; Enter on main keyboard
DIKEYBOARD_LCONTROL                     equ 08100041Dh
DIKEYBOARD_A                            equ 08100041Eh
DIKEYBOARD_S                            equ 08100041Fh
DIKEYBOARD_D                            equ 081000420h
DIKEYBOARD_F                            equ 081000421h
DIKEYBOARD_G                            equ 081000422h
DIKEYBOARD_H                            equ 081000423h
DIKEYBOARD_J                            equ 081000424h
DIKEYBOARD_K                            equ 081000425h
DIKEYBOARD_L                            equ 081000426h
DIKEYBOARD_SEMICOLON                    equ 081000427h
DIKEYBOARD_APOSTROPHE                   equ 081000428h
DIKEYBOARD_GRAVE                        equ 081000429h    ; accent grave
DIKEYBOARD_LSHIFT                       equ 08100042Ah
DIKEYBOARD_BACKSLASH                    equ 08100042Bh
DIKEYBOARD_Z                            equ 08100042Ch
DIKEYBOARD_X                            equ 08100042Dh
DIKEYBOARD_C                            equ 08100042Eh
DIKEYBOARD_V                            equ 08100042Fh
DIKEYBOARD_B                            equ 081000430h
DIKEYBOARD_N                            equ 081000431h
DIKEYBOARD_M                            equ 081000432h
DIKEYBOARD_COMMA                        equ 081000433h
DIKEYBOARD_PERIOD                       equ 081000434h    ; . on main keyboard
DIKEYBOARD_SLASH                        equ 081000435h    ; / on main keyboard
DIKEYBOARD_RSHIFT                       equ 081000436h
DIKEYBOARD_MULTIPLY                     equ 081000437h    ; * on numeric keypad
DIKEYBOARD_LMENU                        equ 081000438h    ; left Alt
DIKEYBOARD_SPACE                        equ 081000439h
DIKEYBOARD_CAPITAL                      equ 08100043Ah
DIKEYBOARD_F1                           equ 08100043Bh
DIKEYBOARD_F2                           equ 08100043Ch
DIKEYBOARD_F3                           equ 08100043Dh
DIKEYBOARD_F4                           equ 08100043Eh
DIKEYBOARD_F5                           equ 08100043Fh
DIKEYBOARD_F6                           equ 081000440h
DIKEYBOARD_F7                           equ 081000441h
DIKEYBOARD_F8                           equ 081000442h
DIKEYBOARD_F9                           equ 081000443h
DIKEYBOARD_F10                          equ 081000444h
DIKEYBOARD_NUMLOCK                      equ 081000445h
DIKEYBOARD_SCROLL                       equ 081000446h    ; Scroll Lock
DIKEYBOARD_NUMPAD7                      equ 081000447h
DIKEYBOARD_NUMPAD8                      equ 081000448h
DIKEYBOARD_NUMPAD9                      equ 081000449h
DIKEYBOARD_SUBTRACT                     equ 08100044Ah    ; - on numeric keypad
DIKEYBOARD_NUMPAD4                      equ 08100044Bh
DIKEYBOARD_NUMPAD5                      equ 08100044Ch
DIKEYBOARD_NUMPAD6                      equ 08100044Dh
DIKEYBOARD_ADD                          equ 08100044Eh    ; + on numeric keypad
DIKEYBOARD_NUMPAD1                      equ 08100044Fh
DIKEYBOARD_NUMPAD2                      equ 081000450h
DIKEYBOARD_NUMPAD3                      equ 081000451h
DIKEYBOARD_NUMPAD0                      equ 081000452h
DIKEYBOARD_DECIMAL                      equ 081000453h    ; . on numeric keypad
DIKEYBOARD_OEM_102                      equ 081000456h    ; <> or \| on RT 102-key keyboard (Non-U.S.)
DIKEYBOARD_F11                          equ 081000457h
DIKEYBOARD_F12                          equ 081000458h
DIKEYBOARD_F13                          equ 081000464h    ;                     (NEC PC98)
DIKEYBOARD_F14                          equ 081000465h    ;                     (NEC PC98)
DIKEYBOARD_F15                          equ 081000466h    ;                     (NEC PC98)
DIKEYBOARD_KANA                         equ 081000470h    ; (Japanese keyboard)
DIKEYBOARD_ABNT_C1                      equ 081000473h    ; /? on Brazilian keyboard
DIKEYBOARD_CONVERT                      equ 081000479h    ; (Japanese keyboard)
DIKEYBOARD_NOCONVERT                    equ 08100047Bh    ; (Japanese keyboard)
DIKEYBOARD_YEN                          equ 08100047Dh    ; (Japanese keyboard)
DIKEYBOARD_ABNT_C2                      equ 08100047Eh    ; Numpad . on Brazilian keyboard
DIKEYBOARD_NUMPADEQUALS                 equ 08100048Dh    ; = on numeric keypad (NEC PC98)
DIKEYBOARD_PREVTRACK                    equ 081000490h    ; Previous Track (DIK_CIRCUMFLEX on Japanese keyboard)
DIKEYBOARD_AT                           equ 081000491h    ;                     (NEC PC98)
DIKEYBOARD_COLON                        equ 081000492h    ;                     (NEC PC98)
DIKEYBOARD_UNDERLINE                    equ 081000493h    ;                     (NEC PC98)
DIKEYBOARD_KANJI                        equ 081000494h    ; (Japanese keyboard)
DIKEYBOARD_STOP                         equ 081000495h    ;                     (NEC PC98)
DIKEYBOARD_AX                           equ 081000496h    ;                     (Japan AX)
DIKEYBOARD_UNLABELED                    equ 081000497h    ;                        (J3100)
DIKEYBOARD_NEXTTRACK                    equ 081000499h    ; Next Track
DIKEYBOARD_NUMPADENTER                  equ 08100049Ch    ; Enter on numeric keypad
DIKEYBOARD_RCONTROL                     equ 08100049Dh
DIKEYBOARD_MUTE                         equ 0810004A0h    ; Mute
DIKEYBOARD_CALCULATOR                   equ 0810004A1h    ; Calculator
DIKEYBOARD_PLAYPAUSE                    equ 0810004A2h    ; Play / Pause
DIKEYBOARD_MEDIASTOP                    equ 0810004A4h    ; Media Stop
DIKEYBOARD_VOLUMEDOWN                   equ 0810004AEh    ; Volume -
DIKEYBOARD_VOLUMEUP                     equ 0810004B0h    ; Volume +
DIKEYBOARD_WEBHOME                      equ 0810004B2h    ; Web home
DIKEYBOARD_NUMPADCOMMA                  equ 0810004B3h    ; , on numeric keypad (NEC PC98)
DIKEYBOARD_DIVIDE                       equ 0810004B5h    ; / on numeric keypad
DIKEYBOARD_SYSRQ                        equ 0810004B7h
DIKEYBOARD_RMENU                        equ 0810004B8h    ; right Alt
DIKEYBOARD_PAUSE                        equ 0810004C5h    ; Pause
DIKEYBOARD_HOME                         equ 0810004C7h    ; Home on arrow keypad
DIKEYBOARD_UP                           equ 0810004C8h    ; UpArrow on arrow keypad
DIKEYBOARD_PRIOR                        equ 0810004C9h    ; PgUp on arrow keypad
DIKEYBOARD_LEFT                         equ 0810004CBh    ; LeftArrow on arrow keypad
DIKEYBOARD_RIGHT                        equ 0810004CDh    ; RightArrow on arrow keypad
DIKEYBOARD_END                          equ 0810004CFh    ; End on arrow keypad
DIKEYBOARD_DOWN                         equ 0810004D0h    ; DownArrow on arrow keypad
DIKEYBOARD_NEXT                         equ 0810004D1h    ; PgDn on arrow keypad
DIKEYBOARD_INSERT                       equ 0810004D2h    ; Insert on arrow keypad
DIKEYBOARD_DELETE                       equ 0810004D3h    ; Delete on arrow keypad
DIKEYBOARD_LWIN                         equ 0810004DBh    ; Left Windows key
DIKEYBOARD_RWIN                         equ 0810004DCh    ; Right Windows key
DIKEYBOARD_APPS                         equ 0810004DDh    ; AppMenu key
DIKEYBOARD_POWER                        equ 0810004DEh    ; System Power
DIKEYBOARD_SLEEP                        equ 0810004DFh    ; System Sleep
DIKEYBOARD_WAKE                         equ 0810004E3h    ; System Wake
DIKEYBOARD_WEBSEARCH                    equ 0810004E5h    ; Web Search
DIKEYBOARD_WEBFAVORITES                 equ 0810004E6h    ; Web Favorites
DIKEYBOARD_WEBREFRESH                   equ 0810004E7h    ; Web Refresh
DIKEYBOARD_WEBSTOP                      equ 0810004E8h    ; Web Stop
DIKEYBOARD_WEBFORWARD                   equ 0810004E9h    ; Web Forward
DIKEYBOARD_WEBBACK                      equ 0810004EAh    ; Web Back
DIKEYBOARD_MYCOMPUTER                   equ 0810004EBh    ; My Computer
DIKEYBOARD_MAIL                         equ 0810004ECh    ; Mail
DIKEYBOARD_MEDIASELECT                  equ 0810004EDh    ; Media Select
  

; --- MOUSE Physical Mouse Device ---
DIMOUSE_XAXISAB                         equ 082000200h or DIMOFS_X ; X Axis-absolute: Some mice natively report absolute coordinates 
DIMOUSE_YAXISAB                         equ 082000200h or DIMOFS_Y ; Y Axis-absolute: Some mice natively report absolute coordinates
DIMOUSE_XAXIS                           equ 082000300h or DIMOFS_X ; X Axis
DIMOUSE_YAXIS                           equ 082000300h or DIMOFS_Y ; Y Axis
DIMOUSE_WHEEL                           equ 082000300h or DIMOFS_Z ; Z Axis
DIMOUSE_BUTTON0                         equ 082000400h or DIMOFS_BUTTON0 ; Button 0
DIMOUSE_BUTTON1                         equ 082000400h or DIMOFS_BUTTON1 ; Button 1
DIMOUSE_BUTTON2                         equ 082000400h or DIMOFS_BUTTON2 ; Button 2
DIMOUSE_BUTTON3                         equ 082000400h or DIMOFS_BUTTON3 ; Button 3
DIMOUSE_BUTTON4                         equ 082000400h or DIMOFS_BUTTON4 ; Button 4
DIMOUSE_BUTTON5                         equ 082000400h or DIMOFS_BUTTON5 ; Button 5
DIMOUSE_BUTTON6                         equ 082000400h or DIMOFS_BUTTON6 ; Button 6
DIMOUSE_BUTTON7                         equ 082000400h or DIMOFS_BUTTON7 ; Button 7


; --- VOICE Physical Dplay Voice Device ---
DIVOICE_CHANNEL1                        equ 083000401h
DIVOICE_CHANNEL2                        equ 083000402h
DIVOICE_CHANNEL3                        equ 083000403h
DIVOICE_CHANNEL4                        equ 083000404h
DIVOICE_CHANNEL5                        equ 083000405h
DIVOICE_CHANNEL6                        equ 083000406h
DIVOICE_CHANNEL7                        equ 083000407h
DIVOICE_CHANNEL8                        equ 083000408h
DIVOICE_TEAM                            equ 083000409h
DIVOICE_ALL                             equ 08300040Ah
DIVOICE_RECORDMUTE                      equ 08300040Bh
DIVOICE_PLAYBACKMUTE                    equ 08300040Ch
DIVOICE_TRANSMIT                        equ 08300040Dh

DIVOICE_VOICECOMMAND                    equ 083000410h


; --- Driving Simulator - Racing Vehicle control is primary objective ---
DIVIRTUAL_DRIVING_RACE                  equ 001000000h
DIAXIS_DRIVINGR_STEER                   equ 001008A01h ; Steering
DIAXIS_DRIVINGR_ACCELERATE              equ 001039202h ; Accelerate
DIAXIS_DRIVINGR_BRAKE                   equ 001041203h ; Brake-Axis
DIBUTTON_DRIVINGR_SHIFTUP               equ 001000C01h ; Shift to next higher gear
DIBUTTON_DRIVINGR_SHIFTDOWN             equ 001000C02h ; Shift to next lower gear
DIBUTTON_DRIVINGR_VIEW                  equ 001001C03h ; Cycle through view options
DIBUTTON_DRIVINGR_MENU                  equ 0010004FDh ; Show menu options
; --- Priority 2 controls ---

DIAXIS_DRIVINGR_ACCEL_AND_BRAKE         equ 001014A04h ; Some devices combine accelerate and brake in a single axis
DIHATSWITCH_DRIVINGR_GLANCE             equ 001004601h ; Look around
DIBUTTON_DRIVINGR_BRAKE                 equ 001004C04h ; Brake-button
DIBUTTON_DRIVINGR_DASHBOARD             equ 001004405h ; Select next dashboard option
DIBUTTON_DRIVINGR_AIDS                  equ 001004406h ; Driver correction aids
DIBUTTON_DRIVINGR_MAP                   equ 001004407h ; Display Driving Map
DIBUTTON_DRIVINGR_BOOST                 equ 001004408h ; Turbo Boost
DIBUTTON_DRIVINGR_PIT                   equ 001004409h ; Pit stop notification
DIBUTTON_DRIVINGR_ACCELERATE_LINK       equ 00103D4E0h ; Fallback Accelerate button
DIBUTTON_DRIVINGR_STEER_LEFT_LINK       equ 00100CCE4h ; Fallback Steer Left button
DIBUTTON_DRIVINGR_STEER_RIGHT_LINK      equ 00100CCECh ; Fallback Steer Right button
DIBUTTON_DRIVINGR_GLANCE_LEFT_LINK      equ 00107C4E4h ; Fallback Glance Left button
DIBUTTON_DRIVINGR_GLANCE_RIGHT_LINK     equ 00107C4ECh ; Fallback Glance Right button
DIBUTTON_DRIVINGR_DEVICE                equ 0010044FEh ; Show input device and controls
DIBUTTON_DRIVINGR_PAUSE                 equ 0010044FCh ; Start / Pause / Restart game

; --- Driving Simulator - Combat Combat from within a vehicle is primary objective ---
DIVIRTUAL_DRIVING_COMBAT                equ 002000000h
DIAXIS_DRIVINGC_STEER                   equ 002008A01h ; Steering
DIAXIS_DRIVINGC_ACCELERATE              equ 002039202h ; Accelerate
DIAXIS_DRIVINGC_BRAKE                   equ 002041203h ; Brake-axis
DIBUTTON_DRIVINGC_FIRE                  equ 002000C01h ; Fire
DIBUTTON_DRIVINGC_WEAPONS               equ 002000C02h ; Select next weapon
DIBUTTON_DRIVINGC_TARGET                equ 002000C03h ; Select next available target
DIBUTTON_DRIVINGC_MENU                  equ 0020004FDh ; Show menu options
; --- Priority 2 controls ---

DIAXIS_DRIVINGC_ACCEL_AND_BRAKE         equ 002014A04h ; Some devices combine accelerate and brake in a single axis
DIHATSWITCH_DRIVINGC_GLANCE             equ 002004601h ; Look around
DIBUTTON_DRIVINGC_SHIFTUP               equ 002004C04h ; Shift to next higher gear
DIBUTTON_DRIVINGC_SHIFTDOWN             equ 002004C05h ; Shift to next lower gear
DIBUTTON_DRIVINGC_DASHBOARD             equ 002004406h ; Select next dashboard option
DIBUTTON_DRIVINGC_AIDS                  equ 002004407h ; Driver correction aids
DIBUTTON_DRIVINGC_BRAKE                 equ 002004C08h ; Brake-button
DIBUTTON_DRIVINGC_FIRESECONDARY         equ 002004C09h ; Alternative fire button
DIBUTTON_DRIVINGC_ACCELERATE_LINK       equ 00203D4E0h ; Fallback Accelerate button
DIBUTTON_DRIVINGC_STEER_LEFT_LINK       equ 00200CCE4h ; Fallback Steer Left button
DIBUTTON_DRIVINGC_STEER_RIGHT_LINK      equ 00200CCECh ; Fallback Steer Right button
DIBUTTON_DRIVINGC_GLANCE_LEFT_LINK      equ 00207C4E4h ; Fallback Glance Left button
DIBUTTON_DRIVINGC_GLANCE_RIGHT_LINK     equ 00207C4ECh ; Fallback Glance Right button
DIBUTTON_DRIVINGC_DEVICE                equ 0020044FEh ; Show input device and controls
DIBUTTON_DRIVINGC_PAUSE                 equ 0020044FCh ; Start / Pause / Restart game

; --- Driving Simulator - Tank Combat from withing a tank is primary objective ---
DIVIRTUAL_DRIVING_TANK                  equ 003000000h
DIAXIS_DRIVINGT_STEER                   equ 003008A01h ; Turn tank left / right
DIAXIS_DRIVINGT_BARREL                  equ 003010202h ; Raise / lower barrel
DIAXIS_DRIVINGT_ACCELERATE              equ 003039203h ; Accelerate
DIAXIS_DRIVINGT_ROTATE                  equ 003020204h ; Turn barrel left / right
DIBUTTON_DRIVINGT_FIRE                  equ 003000C01h ; Fire
DIBUTTON_DRIVINGT_WEAPONS               equ 003000C02h ; Select next weapon
DIBUTTON_DRIVINGT_TARGET                equ 003000C03h ; Selects next available target
DIBUTTON_DRIVINGT_MENU                  equ 0030004FDh ; Show menu options
; --- Priority 2 controls ---

DIHATSWITCH_DRIVINGT_GLANCE             equ 003004601h ; Look around
DIAXIS_DRIVINGT_BRAKE                   equ 003045205h ; Brake-axis
DIAXIS_DRIVINGT_ACCEL_AND_BRAKE         equ 003014A06h ; Some devices combine accelerate and brake in a single axis
DIBUTTON_DRIVINGT_VIEW                  equ 003005C04h ; Cycle through view options
DIBUTTON_DRIVINGT_DASHBOARD             equ 003005C05h ; Select next dashboard option
DIBUTTON_DRIVINGT_BRAKE                 equ 003004C06h ; Brake-button
DIBUTTON_DRIVINGT_FIRESECONDARY         equ 003004C07h ; Alternative fire button
DIBUTTON_DRIVINGT_ACCELERATE_LINK       equ 00303D4E0h ; Fallback Accelerate button
DIBUTTON_DRIVINGT_STEER_LEFT_LINK       equ 00300CCE4h ; Fallback Steer Left button
DIBUTTON_DRIVINGT_STEER_RIGHT_LINK      equ 00300CCECh ; Fallback Steer Right button
DIBUTTON_DRIVINGT_BARREL_UP_LINK        equ 0030144E0h ; Fallback Barrel up button
DIBUTTON_DRIVINGT_BARREL_DOWN_LINK      equ 0030144E8h ; Fallback Barrel down button
DIBUTTON_DRIVINGT_ROTATE_LEFT_LINK      equ 0030244E4h ; Fallback Rotate left button
DIBUTTON_DRIVINGT_ROTATE_RIGHT_LINK     equ 0030244ECh ; Fallback Rotate right button
DIBUTTON_DRIVINGT_GLANCE_LEFT_LINK      equ 00307C4E4h ; Fallback Glance Left button
DIBUTTON_DRIVINGT_GLANCE_RIGHT_LINK     equ 00307C4ECh ; Fallback Glance Right button
DIBUTTON_DRIVINGT_DEVICE                equ 0030044FEh ; Show input device and controls
DIBUTTON_DRIVINGT_PAUSE                 equ 0030044FCh ; Start / Pause / Restart game

; --- Flight Simulator - Civilian Plane control is the primary objective ---
DIVIRTUAL_FLYING_CIVILIAN               equ 004000000h
DIAXIS_FLYINGC_BANK                     equ 004008A01h ; Roll ship left / right
DIAXIS_FLYINGC_PITCH                    equ 004010A02h ; Nose up / down
DIAXIS_FLYINGC_THROTTLE                 equ 004039203h ; Throttle
DIBUTTON_FLYINGC_VIEW                   equ 004002401h ; Cycle through view options
DIBUTTON_FLYINGC_DISPLAY                equ 004002402h ; Select next dashboard / heads up display option
DIBUTTON_FLYINGC_GEAR                   equ 004002C03h ; Gear up / down
DIBUTTON_FLYINGC_MENU                   equ 0040004FDh ; Show menu options
; --- Priority 2 controls ---

DIHATSWITCH_FLYINGC_GLANCE              equ 004004601h ; Look around
DIAXIS_FLYINGC_BRAKE                    equ 004046A04h ; Apply Brake
DIAXIS_FLYINGC_RUDDER                   equ 004025205h ; Yaw ship left/right
DIAXIS_FLYINGC_FLAPS                    equ 004055A06h ; Flaps
DIBUTTON_FLYINGC_FLAPSUP                equ 004006404h ; Increment stepping up until fully retracted
DIBUTTON_FLYINGC_FLAPSDOWN              equ 004006405h ; Decrement stepping down until fully extended
DIBUTTON_FLYINGC_BRAKE_LINK             equ 004046CE0h ; Fallback brake button
DIBUTTON_FLYINGC_FASTER_LINK            equ 00403D4E0h ; Fallback throttle up button
DIBUTTON_FLYINGC_SLOWER_LINK            equ 00403D4E8h ; Fallback throttle down button
DIBUTTON_FLYINGC_GLANCE_LEFT_LINK       equ 00407C4E4h ; Fallback Glance Left button
DIBUTTON_FLYINGC_GLANCE_RIGHT_LINK      equ 00407C4ECh ; Fallback Glance Right button
DIBUTTON_FLYINGC_GLANCE_UP_LINK         equ 00407C4E0h ; Fallback Glance Up button
DIBUTTON_FLYINGC_GLANCE_DOWN_LINK       equ 00407C4E8h ; Fallback Glance Down button
DIBUTTON_FLYINGC_DEVICE                 equ 0040044FEh ; Show input device and controls
DIBUTTON_FLYINGC_PAUSE                  equ 0040044FCh ; Start / Pause / Restart game

; --- Flight Simulator - Military Aerial combat is the primary objective ---
DIVIRTUAL_FLYING_MILITARY               equ 005000000h
DIAXIS_FLYINGM_BANK                     equ 005008A01h ; Bank - Roll ship left / right
DIAXIS_FLYINGM_PITCH                    equ 005010A02h ; Pitch - Nose up / down
DIAXIS_FLYINGM_THROTTLE                 equ 005039203h ; Throttle - faster / slower
DIBUTTON_FLYINGM_FIRE                   equ 005000C01h ; Fire
DIBUTTON_FLYINGM_WEAPONS                equ 005000C02h ; Select next weapon
DIBUTTON_FLYINGM_TARGET                 equ 005000C03h ; Selects next available target
DIBUTTON_FLYINGM_MENU                   equ 0050004FDh ; Show menu options
; --- Priority 2 controls ---

DIHATSWITCH_FLYINGM_GLANCE              equ 005004601h ; Look around
DIBUTTON_FLYINGM_COUNTER                equ 005005C04h ; Activate counter measures
DIAXIS_FLYINGM_RUDDER                   equ 005024A04h ; Rudder - Yaw ship left/right
DIAXIS_FLYINGM_BRAKE                    equ 005046205h ; Brake-axis
DIBUTTON_FLYINGM_VIEW                   equ 005006405h ; Cycle through view options
DIBUTTON_FLYINGM_DISPLAY                equ 005006406h ; Select next dashboard option
DIAXIS_FLYINGM_FLAPS                    equ 005055206h ; Flaps
DIBUTTON_FLYINGM_FLAPSUP                equ 005005407h ; Increment stepping up until fully retracted
DIBUTTON_FLYINGM_FLAPSDOWN              equ 005005408h ; Decrement stepping down until fully extended
DIBUTTON_FLYINGM_FIRESECONDARY          equ 005004C09h ; Alternative fire button
DIBUTTON_FLYINGM_GEAR                   equ 00500640Ah ; Gear up / down
DIBUTTON_FLYINGM_BRAKE_LINK             equ 0050464E0h ; Fallback brake button
DIBUTTON_FLYINGM_FASTER_LINK            equ 00503D4E0h ; Fallback throttle up button
DIBUTTON_FLYINGM_SLOWER_LINK            equ 00503D4E8h ; Fallback throttle down button
DIBUTTON_FLYINGM_GLANCE_LEFT_LINK       equ 00507C4E4h ; Fallback Glance Left button
DIBUTTON_FLYINGM_GLANCE_RIGHT_LINK      equ 00507C4ECh ; Fallback Glance Right button
DIBUTTON_FLYINGM_GLANCE_UP_LINK         equ 00507C4E0h ; Fallback Glance Up button
DIBUTTON_FLYINGM_GLANCE_DOWN_LINK       equ 00507C4E8h ; Fallback Glance Down button
DIBUTTON_FLYINGM_DEVICE                 equ 0050044FEh ; Show input device and controls
DIBUTTON_FLYINGM_PAUSE                  equ 0050044FCh ; Start / Pause / Restart game

; --- Flight Simulator - Combat Helicopter Combat from helicopter is primary objective ---
DIVIRTUAL_FLYING_HELICOPTER             equ 006000000h
DIAXIS_FLYINGH_BANK                     equ 006008A01h ; Bank - Roll ship left / right
DIAXIS_FLYINGH_PITCH                    equ 006010A02h ; Pitch - Nose up / down
DIAXIS_FLYINGH_COLLECTIVE               equ 006018A03h ; Collective - Blade pitch/power
DIBUTTON_FLYINGH_FIRE                   equ 006001401h ; Fire
DIBUTTON_FLYINGH_WEAPONS                equ 006001402h ; Select next weapon
DIBUTTON_FLYINGH_TARGET                 equ 006001403h ; Selects next available target
DIBUTTON_FLYINGH_MENU                   equ 0060004FDh ; Show menu options
; --- Priority 2 controls ---

DIHATSWITCH_FLYINGH_GLANCE              equ 006004601h ; Look around
DIAXIS_FLYINGH_TORQUE                   equ 006025A04h ; Torque - Rotate ship around left / right axis
DIAXIS_FLYINGH_THROTTLE                 equ 00603DA05h ; Throttle
DIBUTTON_FLYINGH_COUNTER                equ 006005404h ; Activate counter measures
DIBUTTON_FLYINGH_VIEW                   equ 006006405h ; Cycle through view options
DIBUTTON_FLYINGH_GEAR                   equ 006006406h ; Gear up / down
DIBUTTON_FLYINGH_FIRESECONDARY          equ 006004C07h ; Alternative fire button
DIBUTTON_FLYINGH_FASTER_LINK            equ 00603DCE0h ; Fallback throttle up button
DIBUTTON_FLYINGH_SLOWER_LINK            equ 00603DCE8h ; Fallback throttle down button
DIBUTTON_FLYINGH_GLANCE_LEFT_LINK       equ 00607C4E4h ; Fallback Glance Left button
DIBUTTON_FLYINGH_GLANCE_RIGHT_LINK      equ 00607C4ECh ; Fallback Glance Right button
DIBUTTON_FLYINGH_GLANCE_UP_LINK         equ 00607C4E0h ; Fallback Glance Up button
DIBUTTON_FLYINGH_GLANCE_DOWN_LINK       equ 00607C4E8h ; Fallback Glance Down button
DIBUTTON_FLYINGH_DEVICE                 equ 0060044FEh ; Show input device and controls
DIBUTTON_FLYINGH_PAUSE                  equ 0060044FCh ; Start / Pause / Restart game

; --- Space Simulator - Combat Space Simulator with weapons ---
DIVIRTUAL_SPACESIM                      equ 007000000h
DIAXIS_SPACESIM_LATERAL                 equ 007008201h ; Move ship left / right
DIAXIS_SPACESIM_MOVE                    equ 007010202h ; Move ship forward/backward
DIAXIS_SPACESIM_THROTTLE                equ 007038203h ; Throttle - Engine speed
DIBUTTON_SPACESIM_FIRE                  equ 007000401h ; Fire
DIBUTTON_SPACESIM_WEAPONS               equ 007000402h ; Select next weapon
DIBUTTON_SPACESIM_TARGET                equ 007000403h ; Selects next available target
DIBUTTON_SPACESIM_MENU                  equ 0070004FDh ; Show menu options
; --- Priority 2 controls ---

DIHATSWITCH_SPACESIM_GLANCE             equ 007004601h ; Look around
DIAXIS_SPACESIM_CLIMB                   equ 00701C204h ; Climb - Pitch ship up/down
DIAXIS_SPACESIM_ROTATE                  equ 007024205h ; Rotate - Turn ship left/right
DIBUTTON_SPACESIM_VIEW                  equ 007004404h ; Cycle through view options
DIBUTTON_SPACESIM_DISPLAY               equ 007004405h ; Select next dashboard / heads up display option
DIBUTTON_SPACESIM_RAISE                 equ 007004406h ; Raise ship while maintaining current pitch
DIBUTTON_SPACESIM_LOWER                 equ 007004407h ; Lower ship while maintaining current pitch
DIBUTTON_SPACESIM_GEAR                  equ 007004408h ; Gear up / down
DIBUTTON_SPACESIM_FIRESECONDARY         equ 007004409h ; Alternative fire button
DIBUTTON_SPACESIM_LEFT_LINK             equ 00700C4E4h ; Fallback move left button
DIBUTTON_SPACESIM_RIGHT_LINK            equ 00700C4ECh ; Fallback move right button
DIBUTTON_SPACESIM_FORWARD_LINK          equ 0070144E0h ; Fallback move forward button
DIBUTTON_SPACESIM_BACKWARD_LINK         equ 0070144E8h ; Fallback move backwards button
DIBUTTON_SPACESIM_FASTER_LINK           equ 00703C4E0h ; Fallback throttle up button
DIBUTTON_SPACESIM_SLOWER_LINK           equ 00703C4E8h ; Fallback throttle down button
DIBUTTON_SPACESIM_TURN_LEFT_LINK        equ 0070244E4h ; Fallback turn left button
DIBUTTON_SPACESIM_TURN_RIGHT_LINK       equ 0070244ECh ; Fallback turn right button
DIBUTTON_SPACESIM_GLANCE_LEFT_LINK      equ 00707C4E4h ; Fallback Glance Left button
DIBUTTON_SPACESIM_GLANCE_RIGHT_LINK     equ 00707C4ECh ; Fallback Glance Right button
DIBUTTON_SPACESIM_GLANCE_UP_LINK        equ 00707C4E0h ; Fallback Glance Up button
DIBUTTON_SPACESIM_GLANCE_DOWN_LINK      equ 00707C4E8h ; Fallback Glance Down button
DIBUTTON_SPACESIM_DEVICE                equ 0070044FEh ; Show input device and controls
DIBUTTON_SPACESIM_PAUSE                 equ 0070044FCh ; Start / Pause / Restart game

; --- Fighting - First Person Hand to Hand combat is primary objective ---
DIVIRTUAL_FIGHTING_HAND2HAND            equ 008000000h
DIAXIS_FIGHTINGH_LATERAL                equ 008008201h ; Sidestep left/right
DIAXIS_FIGHTINGH_MOVE                   equ 008010202h ; Move forward/backward
DIBUTTON_FIGHTINGH_PUNCH                equ 008000401h ; Punch
DIBUTTON_FIGHTINGH_KICK                 equ 008000402h ; Kick
DIBUTTON_FIGHTINGH_BLOCK                equ 008000403h ; Block
DIBUTTON_FIGHTINGH_CROUCH               equ 008000404h ; Crouch
DIBUTTON_FIGHTINGH_JUMP                 equ 008000405h ; Jump
DIBUTTON_FIGHTINGH_SPECIAL1             equ 008000406h ; Apply first special move
DIBUTTON_FIGHTINGH_SPECIAL2             equ 008000407h ; Apply second special move
DIBUTTON_FIGHTINGH_MENU                 equ 0080004FDh ; Show menu options
; --- Priority 2 controls ---

DIBUTTON_FIGHTINGH_SELECT               equ 008004408h ; Select special move
DIHATSWITCH_FIGHTINGH_SLIDE             equ 008004601h ; Look around
DIBUTTON_FIGHTINGH_DISPLAY              equ 008004409h ; Shows next on-screen display option
DIAXIS_FIGHTINGH_ROTATE                 equ 008024203h ; Rotate - Turn body left/right
DIBUTTON_FIGHTINGH_DODGE                equ 00800440Ah ; Dodge
DIBUTTON_FIGHTINGH_LEFT_LINK            equ 00800C4E4h ; Fallback left sidestep button
DIBUTTON_FIGHTINGH_RIGHT_LINK           equ 00800C4ECh ; Fallback right sidestep button
DIBUTTON_FIGHTINGH_FORWARD_LINK         equ 0080144E0h ; Fallback forward button
DIBUTTON_FIGHTINGH_BACKWARD_LINK        equ 0080144E8h ; Fallback backward button
DIBUTTON_FIGHTINGH_DEVICE               equ 0080044FEh ; Show input device and controls
DIBUTTON_FIGHTINGH_PAUSE                equ 0080044FCh ; Start / Pause / Restart game

; --- Fighting - First Person Shooting Navigation and combat are primary objectives ---
DIVIRTUAL_FIGHTING_FPS                  equ 009000000h
DIAXIS_FPS_ROTATE                       equ 009008201h ; Rotate character left/right
DIAXIS_FPS_MOVE                         equ 009010202h ; Move forward/backward
DIBUTTON_FPS_FIRE                       equ 009000401h ; Fire
DIBUTTON_FPS_WEAPONS                    equ 009000402h ; Select next weapon
DIBUTTON_FPS_APPLY                      equ 009000403h ; Use item
DIBUTTON_FPS_SELECT                     equ 009000404h ; Select next inventory item
DIBUTTON_FPS_CROUCH                     equ 009000405h ; Crouch/ climb down/ swim down
DIBUTTON_FPS_JUMP                       equ 009000406h ; Jump/ climb up/ swim up
DIAXIS_FPS_LOOKUPDOWN                   equ 009018203h ; Look up / down
DIBUTTON_FPS_STRAFE                     equ 009000407h ; Enable strafing while active
DIBUTTON_FPS_MENU                       equ 0090004FDh ; Show menu options
; --- Priority 2 controls ---

DIHATSWITCH_FPS_GLANCE                  equ 009004601h ; Look around
DIBUTTON_FPS_DISPLAY                    equ 009004408h ; Shows next on-screen display option/ map
DIAXIS_FPS_SIDESTEP                     equ 009024204h ; Sidestep
DIBUTTON_FPS_DODGE                      equ 009004409h ; Dodge
DIBUTTON_FPS_GLANCEL                    equ 00900440Ah ; Glance Left
DIBUTTON_FPS_GLANCER                    equ 00900440Bh ; Glance Right
DIBUTTON_FPS_FIRESECONDARY              equ 00900440Ch ; Alternative fire button
DIBUTTON_FPS_ROTATE_LEFT_LINK           equ 00900C4E4h ; Fallback rotate left button
DIBUTTON_FPS_ROTATE_RIGHT_LINK          equ 00900C4ECh ; Fallback rotate right button
DIBUTTON_FPS_FORWARD_LINK               equ 0090144E0h ; Fallback forward button
DIBUTTON_FPS_BACKWARD_LINK              equ 0090144E8h ; Fallback backward button
DIBUTTON_FPS_GLANCE_UP_LINK             equ 00901C4E0h ; Fallback look up button
DIBUTTON_FPS_GLANCE_DOWN_LINK           equ 00901C4E8h ; Fallback look down button
DIBUTTON_FPS_STEP_LEFT_LINK             equ 0090244E4h ; Fallback step left button
DIBUTTON_FPS_STEP_RIGHT_LINK            equ 0090244ECh ; Fallback step right button
DIBUTTON_FPS_DEVICE                     equ 0090044FEh ; Show input device and controls
DIBUTTON_FPS_PAUSE                      equ 0090044FCh ; Start / Pause / Restart game

; --- Fighting - Third Person action Perspective of camera is behind the main character ---
DIVIRTUAL_FIGHTING_THIRDPERSON          equ 00A000000h
DIAXIS_TPS_TURN                         equ 00A020201h ; Turn left/right
DIAXIS_TPS_MOVE                         equ 00A010202h ; Move forward/backward
DIBUTTON_TPS_RUN                        equ 00A000401h ; Run or walk toggle switch
DIBUTTON_TPS_ACTION                     equ 00A000402h ; Action Button
DIBUTTON_TPS_SELECT                     equ 00A000403h ; Select next weapon
DIBUTTON_TPS_USE                        equ 00A000404h ; Use inventory item currently selected
DIBUTTON_TPS_JUMP                       equ 00A000405h ; Character Jumps
DIBUTTON_TPS_MENU                       equ 00A0004FDh ; Show menu options
; --- Priority 2 controls ---

DIHATSWITCH_TPS_GLANCE                  equ 00A004601h ; Look around
DIBUTTON_TPS_VIEW                       equ 00A004406h ; Select camera view
DIBUTTON_TPS_STEPLEFT                   equ 00A004407h ; Character takes a left step
DIBUTTON_TPS_STEPRIGHT                  equ 00A004408h ; Character takes a right step
DIAXIS_TPS_STEP                         equ 00A00C203h ; Character steps left/right
DIBUTTON_TPS_DODGE                      equ 00A004409h ; Character dodges or ducks
DIBUTTON_TPS_INVENTORY                  equ 00A00440Ah ; Cycle through inventory
DIBUTTON_TPS_TURN_LEFT_LINK             equ 00A0244E4h ; Fallback turn left button
DIBUTTON_TPS_TURN_RIGHT_LINK            equ 00A0244ECh ; Fallback turn right button
DIBUTTON_TPS_FORWARD_LINK               equ 00A0144E0h ; Fallback forward button
DIBUTTON_TPS_BACKWARD_LINK              equ 00A0144E8h ; Fallback backward button
DIBUTTON_TPS_GLANCE_UP_LINK             equ 00A07C4E0h ; Fallback look up button
DIBUTTON_TPS_GLANCE_DOWN_LINK           equ 00A07C4E8h ; Fallback look down button
DIBUTTON_TPS_GLANCE_LEFT_LINK           equ 00A07C4E4h ; Fallback glance up button
DIBUTTON_TPS_GLANCE_RIGHT_LINK          equ 00A07C4ECh ; Fallback glance right button
DIBUTTON_TPS_DEVICE                     equ 00A0044FEh ; Show input device and controls
DIBUTTON_TPS_PAUSE                      equ 00A0044FCh ; Start / Pause / Restart game

; --- Strategy - Role Playing Navigation and problem solving are primary actions ---
DIVIRTUAL_STRATEGY_ROLEPLAYING          equ 00B000000h
DIAXIS_STRATEGYR_LATERAL                equ 00B008201h ; sidestep - left/right
DIAXIS_STRATEGYR_MOVE                   equ 00B010202h ; move forward/backward
DIBUTTON_STRATEGYR_GET                  equ 00B000401h ; Acquire item
DIBUTTON_STRATEGYR_APPLY                equ 00B000402h ; Use selected item
DIBUTTON_STRATEGYR_SELECT               equ 00B000403h ; Select nextitem
DIBUTTON_STRATEGYR_ATTACK               equ 00B000404h ; Attack
DIBUTTON_STRATEGYR_CAST                 equ 00B000405h ; Cast Spell
DIBUTTON_STRATEGYR_CROUCH               equ 00B000406h ; Crouch
DIBUTTON_STRATEGYR_JUMP                 equ 00B000407h ; Jump
DIBUTTON_STRATEGYR_MENU                 equ 00B0004FDh ; Show menu options
; --- Priority 2 controls ---

DIHATSWITCH_STRATEGYR_GLANCE            equ 00B004601h ; Look around
DIBUTTON_STRATEGYR_MAP                  equ 00B004408h ; Cycle through map options
DIBUTTON_STRATEGYR_DISPLAY              equ 00B004409h ; Shows next on-screen display option
DIAXIS_STRATEGYR_ROTATE                 equ 00B024203h ; Turn body left/right
DIBUTTON_STRATEGYR_LEFT_LINK            equ 00B00C4E4h ; Fallback sidestep left button
DIBUTTON_STRATEGYR_RIGHT_LINK           equ 00B00C4ECh ; Fallback sidestep right button
DIBUTTON_STRATEGYR_FORWARD_LINK         equ 00B0144E0h ; Fallback move forward button
DIBUTTON_STRATEGYR_BACK_LINK            equ 00B0144E8h ; Fallback move backward button
DIBUTTON_STRATEGYR_ROTATE_LEFT_LINK     equ 00B0244E4h ; Fallback turn body left button
DIBUTTON_STRATEGYR_ROTATE_RIGHT_LINK    equ 00B0244ECh ; Fallback turn body right button
DIBUTTON_STRATEGYR_DEVICE               equ 00B0044FEh ; Show input device and controls
DIBUTTON_STRATEGYR_PAUSE                equ 00B0044FCh ;* Start / Pause / Restart game

; --- Strategy - Turn based Navigation and problem solving are primary actions ---
DIVIRTUAL_STRATEGY_TURN                 equ 00C000000h
DIAXIS_STRATEGYT_LATERAL                equ 00C008201h ; Sidestep left/right
DIAXIS_STRATEGYT_MOVE                   equ 00C010202h ; Move forward/backwards
DIBUTTON_STRATEGYT_SELECT               equ 00C000401h ; Select unit or object
DIBUTTON_STRATEGYT_INSTRUCT             equ 00C000402h ; Cycle through instructions
DIBUTTON_STRATEGYT_APPLY                equ 00C000403h ; Apply selected instruction
DIBUTTON_STRATEGYT_TEAM                 equ 00C000404h ; Select next team / cycle through all
DIBUTTON_STRATEGYT_TURN                 equ 00C000405h ; Indicate turn over
DIBUTTON_STRATEGYT_MENU                 equ 00C0004FDh ; Show menu options
; --- Priority 2 controls ---

DIBUTTON_STRATEGYT_ZOOM                 equ 00C004406h ; Zoom - in / out
DIBUTTON_STRATEGYT_MAP                  equ 00C004407h ; cycle through map options
DIBUTTON_STRATEGYT_DISPLAY              equ 00C004408h ; shows next on-screen display options
DIBUTTON_STRATEGYT_LEFT_LINK            equ 00C00C4E4h ; Fallback sidestep left button
DIBUTTON_STRATEGYT_RIGHT_LINK           equ 00C00C4ECh ; Fallback sidestep right button
DIBUTTON_STRATEGYT_FORWARD_LINK         equ 00C0144E0h ; Fallback move forward button
DIBUTTON_STRATEGYT_BACK_LINK            equ 00C0144E8h ; Fallback move back button
DIBUTTON_STRATEGYT_DEVICE               equ 00C0044FEh ; Show input device and controls
DIBUTTON_STRATEGYT_PAUSE                equ 00C0044FCh ; Start / Pause / Restart game

; --- Sports - Hunting Hunting ---
DIVIRTUAL_SPORTS_HUNTING                equ 00D000000h
DIAXIS_HUNTING_LATERAL                  equ 00D008201h ; sidestep left/right
DIAXIS_HUNTING_MOVE                     equ 00D010202h ; move forward/backwards
DIBUTTON_HUNTING_FIRE                   equ 00D000401h ; Fire selected weapon
DIBUTTON_HUNTING_AIM                    equ 00D000402h ; Select aim/move
DIBUTTON_HUNTING_WEAPON                 equ 00D000403h ; Select next weapon
DIBUTTON_HUNTING_BINOCULAR              equ 00D000404h ; Look through Binoculars
DIBUTTON_HUNTING_CALL                   equ 00D000405h ; Make animal call
DIBUTTON_HUNTING_MAP                    equ 00D000406h ; View Map
DIBUTTON_HUNTING_SPECIAL                equ 00D000407h ; Special game operation
DIBUTTON_HUNTING_MENU                   equ 00D0004FDh ; Show menu options
; --- Priority 2 controls ---

DIHATSWITCH_HUNTING_GLANCE              equ 00D004601h ; Look around
DIBUTTON_HUNTING_DISPLAY                equ 00D004408h ; show next on-screen display option
DIAXIS_HUNTING_ROTATE                   equ 00D024203h ; Turn body left/right
DIBUTTON_HUNTING_CROUCH                 equ 00D004409h ; Crouch/ Climb / Swim down
DIBUTTON_HUNTING_JUMP                   equ 00D00440Ah ; Jump/ Climb up / Swim up
DIBUTTON_HUNTING_FIRESECONDARY          equ 00D00440Bh ; Alternative fire button
DIBUTTON_HUNTING_LEFT_LINK              equ 00D00C4E4h ; Fallback sidestep left button
DIBUTTON_HUNTING_RIGHT_LINK             equ 00D00C4ECh ; Fallback sidestep right button
DIBUTTON_HUNTING_FORWARD_LINK           equ 00D0144E0h ; Fallback move forward button
DIBUTTON_HUNTING_BACK_LINK              equ 00D0144E8h ; Fallback move back button
DIBUTTON_HUNTING_ROTATE_LEFT_LINK       equ 00D0244E4h ; Fallback turn body left button
DIBUTTON_HUNTING_ROTATE_RIGHT_LINK      equ 00D0244ECh ; Fallback turn body right button
DIBUTTON_HUNTING_DEVICE                 equ 00D0044FEh ; Show input device and controls
DIBUTTON_HUNTING_PAUSE                  equ 00D0044FCh ; Start / Pause / Restart game

; --- Sports - Fishing Catching Fish is primary objective ---
DIVIRTUAL_SPORTS_FISHING                equ 00E000000h
DIAXIS_FISHING_LATERAL                  equ 00E008201h ; sidestep left/right
DIAXIS_FISHING_MOVE                     equ 00E010202h ; move forward/backwards
DIBUTTON_FISHING_CAST                   equ 00E000401h ; Cast line
DIBUTTON_FISHING_TYPE                   equ 00E000402h ; Select cast type
DIBUTTON_FISHING_BINOCULAR              equ 00E000403h ; Look through Binocular
DIBUTTON_FISHING_BAIT                   equ 00E000404h ; Select type of Bait
DIBUTTON_FISHING_MAP                    equ 00E000405h ; View Map
DIBUTTON_FISHING_MENU                   equ 00E0004FDh ; Show menu options
; --- Priority 2 controls ---

DIHATSWITCH_FISHING_GLANCE              equ 00E004601h ; Look around
DIBUTTON_FISHING_DISPLAY                equ 00E004406h ; Show next on-screen display option
DIAXIS_FISHING_ROTATE                   equ 00E024203h ; Turn character left / right
DIBUTTON_FISHING_CROUCH                 equ 00E004407h ; Crouch/ Climb / Swim down
DIBUTTON_FISHING_JUMP                   equ 00E004408h ; Jump/ Climb up / Swim up
DIBUTTON_FISHING_LEFT_LINK              equ 00E00C4E4h ; Fallback sidestep left button
DIBUTTON_FISHING_RIGHT_LINK             equ 00E00C4ECh ; Fallback sidestep right button
DIBUTTON_FISHING_FORWARD_LINK           equ 00E0144E0h ; Fallback move forward button
DIBUTTON_FISHING_BACK_LINK              equ 00E0144E8h ; Fallback move back button
DIBUTTON_FISHING_ROTATE_LEFT_LINK       equ 00E0244E4h ; Fallback turn body left button
DIBUTTON_FISHING_ROTATE_RIGHT_LINK      equ 00E0244ECh ; Fallback turn body right button
DIBUTTON_FISHING_DEVICE                 equ 00E0044FEh ; Show input device and controls
DIBUTTON_FISHING_PAUSE                  equ 00E0044FCh ; Start / Pause / Restart game

; --- Sports - Baseball - Batting Batter control is primary objective ---
DIVIRTUAL_SPORTS_BASEBALL_BAT           equ 00F000000h
DIAXIS_BASEBALLB_LATERAL                equ 00F008201h ; Aim left / right
DIAXIS_BASEBALLB_MOVE                   equ 00F010202h ; Aim up / down
DIBUTTON_BASEBALLB_SELECT               equ 00F000401h ; cycle through swing options
DIBUTTON_BASEBALLB_NORMAL               equ 00F000402h ; normal swing
DIBUTTON_BASEBALLB_POWER                equ 00F000403h ; swing for the fence
DIBUTTON_BASEBALLB_BUNT                 equ 00F000404h ; bunt
DIBUTTON_BASEBALLB_STEAL                equ 00F000405h ; Base runner attempts to steal a base
DIBUTTON_BASEBALLB_BURST                equ 00F000406h ; Base runner invokes burst of speed
DIBUTTON_BASEBALLB_SLIDE                equ 00F000407h ; Base runner slides into base
DIBUTTON_BASEBALLB_CONTACT              equ 00F000408h ; Contact swing
DIBUTTON_BASEBALLB_MENU                 equ 00F0004FDh ; Show menu options
; --- Priority 2 controls ---

DIBUTTON_BASEBALLB_NOSTEAL              equ 00F004409h ; Base runner goes back to a base
DIBUTTON_BASEBALLB_BOX                  equ 00F00440Ah ; Enter or exit batting box
DIBUTTON_BASEBALLB_LEFT_LINK            equ 00F00C4E4h ; Fallback sidestep left button
DIBUTTON_BASEBALLB_RIGHT_LINK           equ 00F00C4ECh ; Fallback sidestep right button
DIBUTTON_BASEBALLB_FORWARD_LINK         equ 00F0144E0h ; Fallback move forward button
DIBUTTON_BASEBALLB_BACK_LINK            equ 00F0144E8h ; Fallback move back button
DIBUTTON_BASEBALLB_DEVICE               equ 00F0044FEh ; Show input device and controls
DIBUTTON_BASEBALLB_PAUSE                equ 00F0044FCh ; Start / Pause / Restart game

; --- Sports - Baseball - Pitching Pitcher control is primary objective ---
DIVIRTUAL_SPORTS_BASEBALL_PITCH         equ 010000000h
DIAXIS_BASEBALLP_LATERAL                equ 010008201h ; Aim left / right
DIAXIS_BASEBALLP_MOVE                   equ 010010202h ; Aim up / down
DIBUTTON_BASEBALLP_SELECT               equ 010000401h ; cycle through pitch selections
DIBUTTON_BASEBALLP_PITCH                equ 010000402h ; throw pitch
DIBUTTON_BASEBALLP_BASE                 equ 010000403h ; select base to throw to
DIBUTTON_BASEBALLP_THROW                equ 010000404h ; throw to base
DIBUTTON_BASEBALLP_FAKE                 equ 010000405h ; Fake a throw to a base
DIBUTTON_BASEBALLP_MENU                 equ 0100004FDh ; Show menu options
; --- Priority 2 controls ---

DIBUTTON_BASEBALLP_WALK                 equ 010004406h ; Throw intentional walk / pitch out
DIBUTTON_BASEBALLP_LOOK                 equ 010004407h ; Look at runners on bases
DIBUTTON_BASEBALLP_LEFT_LINK            equ 01000C4E4h ; Fallback sidestep left button
DIBUTTON_BASEBALLP_RIGHT_LINK           equ 01000C4ECh ; Fallback sidestep right button
DIBUTTON_BASEBALLP_FORWARD_LINK         equ 0100144E0h ; Fallback move forward button
DIBUTTON_BASEBALLP_BACK_LINK            equ 0100144E8h ; Fallback move back button
DIBUTTON_BASEBALLP_DEVICE               equ 0100044FEh ; Show input device and controls
DIBUTTON_BASEBALLP_PAUSE                equ 0100044FCh ; Start / Pause / Restart game

; --- Sports - Baseball - Fielding Fielder control is primary objective ---
DIVIRTUAL_SPORTS_BASEBALL_FIELD         equ 011000000h
DIAXIS_BASEBALLF_LATERAL                equ 011008201h ; Aim left / right
DIAXIS_BASEBALLF_MOVE                   equ 011010202h ; Aim up / down
DIBUTTON_BASEBALLF_NEAREST              equ 011000401h ; Switch to fielder nearest to the ball
DIBUTTON_BASEBALLF_THROW1               equ 011000402h ; Make conservative throw
DIBUTTON_BASEBALLF_THROW2               equ 011000403h ; Make aggressive throw
DIBUTTON_BASEBALLF_BURST                equ 011000404h ; Invoke burst of speed
DIBUTTON_BASEBALLF_JUMP                 equ 011000405h ; Jump to catch ball
DIBUTTON_BASEBALLF_DIVE                 equ 011000406h ; Dive to catch ball
DIBUTTON_BASEBALLF_MENU                 equ 0110004FDh ; Show menu options
; --- Priority 2 controls ---

DIBUTTON_BASEBALLF_SHIFTIN              equ 011004407h ; Shift the infield positioning
DIBUTTON_BASEBALLF_SHIFTOUT             equ 011004408h ; Shift the outfield positioning
DIBUTTON_BASEBALLF_AIM_LEFT_LINK        equ 01100C4E4h ; Fallback aim left button
DIBUTTON_BASEBALLF_AIM_RIGHT_LINK       equ 01100C4ECh ; Fallback aim right button
DIBUTTON_BASEBALLF_FORWARD_LINK         equ 0110144E0h ; Fallback move forward button
DIBUTTON_BASEBALLF_BACK_LINK            equ 0110144E8h ; Fallback move back button
DIBUTTON_BASEBALLF_DEVICE               equ 0110044FEh ; Show input device and controls
DIBUTTON_BASEBALLF_PAUSE                equ 0110044FCh ; Start / Pause / Restart game

;--- Sports - Basketball - Offense Offense  ---
DIVIRTUAL_SPORTS_BASKETBALL_OFFENSE     equ 012000000h
DIAXIS_BBALLO_LATERAL                   equ 012008201h ; left / right
DIAXIS_BBALLO_MOVE                      equ 012010202h ; up / down
DIBUTTON_BBALLO_SHOOT                   equ 012000401h ; shoot basket
DIBUTTON_BBALLO_DUNK                    equ 012000402h ; dunk basket
DIBUTTON_BBALLO_PASS                    equ 012000403h ; throw pass
DIBUTTON_BBALLO_FAKE                    equ 012000404h ; fake shot or pass
DIBUTTON_BBALLO_SPECIAL                 equ 012000405h ; apply special move
DIBUTTON_BBALLO_PLAYER                  equ 012000406h ; select next player
DIBUTTON_BBALLO_BURST                   equ 012000407h ; invoke burst
DIBUTTON_BBALLO_CALL                    equ 012000408h ; call for ball / pass to me
DIBUTTON_BBALLO_MENU                    equ 0120004FDh ; Show menu options
; --- Priority 2 controls ---

DIHATSWITCH_BBALLO_GLANCE               equ 012004601h ; scroll view
DIBUTTON_BBALLO_SCREEN                  equ 012004409h ; Call for screen
DIBUTTON_BBALLO_PLAY                    equ 01200440Ah ; Call for specific offensive play
DIBUTTON_BBALLO_JAB                     equ 01200440Bh ; Initiate fake drive to basket
DIBUTTON_BBALLO_POST                    equ 01200440Ch ; Perform post move
DIBUTTON_BBALLO_TIMEOUT                 equ 01200440Dh ; Time Out
DIBUTTON_BBALLO_SUBSTITUTE              equ 01200440Eh ; substitute one player for another
DIBUTTON_BBALLO_LEFT_LINK               equ 01200C4E4h ; Fallback sidestep left button
DIBUTTON_BBALLO_RIGHT_LINK              equ 01200C4ECh ; Fallback sidestep right button
DIBUTTON_BBALLO_FORWARD_LINK            equ 0120144E0h ; Fallback move forward button
DIBUTTON_BBALLO_BACK_LINK               equ 0120144E8h ; Fallback move back button
DIBUTTON_BBALLO_DEVICE                  equ 0120044FEh ; Show input device and controls
DIBUTTON_BBALLO_PAUSE                   equ 0120044FCh ; Start / Pause / Restart game

; --- Sports - Basketball - Defense ---
DIVIRTUAL_SPORTS_BASKETBALL_DEFENSE     equ 013000000h
DIAXIS_BBALLD_LATERAL                   equ 013008201h ; left / right
DIAXIS_BBALLD_MOVE                      equ 013010202h ; up / down
DIBUTTON_BBALLD_JUMP                    equ 013000401h ; jump to block shot
DIBUTTON_BBALLD_STEAL                   equ 013000402h ; attempt to steal ball
DIBUTTON_BBALLD_FAKE                    equ 013000403h ; fake block or steal
DIBUTTON_BBALLD_SPECIAL                 equ 013000404h ; apply special move
DIBUTTON_BBALLD_PLAYER                  equ 013000405h ; select next player
DIBUTTON_BBALLD_BURST                   equ 013000406h ; invoke burst
DIBUTTON_BBALLD_PLAY                    equ 013000407h ; call for specific defensive play
DIBUTTON_BBALLD_MENU                    equ 0130004FDh ; Show menu options
; --- Priority 2 controls ---

DIHATSWITCH_BBALLD_GLANCE               equ 013004601h ; scroll view
DIBUTTON_BBALLD_TIMEOUT                 equ 013004408h ; Time Out
DIBUTTON_BBALLD_SUBSTITUTE              equ 013004409h ; substitute one player for another
DIBUTTON_BBALLD_LEFT_LINK               equ 01300C4E4h ; Fallback sidestep left button
DIBUTTON_BBALLD_RIGHT_LINK              equ 01300C4ECh ; Fallback sidestep right button
DIBUTTON_BBALLD_FORWARD_LINK            equ 0130144E0h ; Fallback move forward button
DIBUTTON_BBALLD_BACK_LINK               equ 0130144E8h ; Fallback move back button
DIBUTTON_BBALLD_DEVICE                  equ 0130044FEh ; Show input device and controls
DIBUTTON_BBALLD_PAUSE                   equ 0130044FCh ; Start / Pause / Restart game

; --- Sports - Football - Play Play selection ---
DIVIRTUAL_SPORTS_FOOTBALL_FIELD         equ 014000000h
DIBUTTON_FOOTBALLP_PLAY                 equ 014000401h ; cycle through available plays
DIBUTTON_FOOTBALLP_SELECT               equ 014000402h ; select play
DIBUTTON_FOOTBALLP_HELP                 equ 014000403h ; Bring up pop-up help
DIBUTTON_FOOTBALLP_MENU                 equ 0140004FDh ; Show menu options
; --- Priority 2 controls ---

DIBUTTON_FOOTBALLP_DEVICE               equ 0140044FEh ; Show input device and controls
DIBUTTON_FOOTBALLP_PAUSE                equ 0140044FCh ; Start / Pause / Restart game

; --- Sports - Football - QB Offense: Quarterback / Kicker ---
DIVIRTUAL_SPORTS_FOOTBALL_QBCK          equ 015000000h
DIAXIS_FOOTBALLQ_LATERAL                equ 015008201h ; Move / Aim: left / right
DIAXIS_FOOTBALLQ_MOVE                   equ 015010202h ; Move / Aim: up / down
DIBUTTON_FOOTBALLQ_SELECT               equ 015000401h ; Select
DIBUTTON_FOOTBALLQ_SNAP                 equ 015000402h ; snap ball - start play
DIBUTTON_FOOTBALLQ_JUMP                 equ 015000403h ; jump over defender
DIBUTTON_FOOTBALLQ_SLIDE                equ 015000404h ; Dive/Slide
DIBUTTON_FOOTBALLQ_PASS                 equ 015000405h ; throws pass to receiver
DIBUTTON_FOOTBALLQ_FAKE                 equ 015000406h ; pump fake pass or fake kick
DIBUTTON_FOOTBALLQ_MENU                 equ 0150004FDh ; Show menu options
; --- Priority 2 controls ---

DIBUTTON_FOOTBALLQ_FAKESNAP             equ 015004407h ; Fake snap
DIBUTTON_FOOTBALLQ_MOTION               equ 015004408h ; Send receivers in motion
DIBUTTON_FOOTBALLQ_AUDIBLE              equ 015004409h ; Change offensive play at line of scrimmage
DIBUTTON_FOOTBALLQ_LEFT_LINK            equ 01500C4E4h ; Fallback sidestep left button
DIBUTTON_FOOTBALLQ_RIGHT_LINK           equ 01500C4ECh ; Fallback sidestep right button
DIBUTTON_FOOTBALLQ_FORWARD_LINK         equ 0150144E0h ; Fallback move forward button
DIBUTTON_FOOTBALLQ_BACK_LINK            equ 0150144E8h ; Fallback move back button
DIBUTTON_FOOTBALLQ_DEVICE               equ 0150044FEh ; Show input device and controls
DIBUTTON_FOOTBALLQ_PAUSE                equ 0150044FCh ; Start / Pause / Restart game

; --- Sports - Football - Offense Offense - Runner ---
DIVIRTUAL_SPORTS_FOOTBALL_OFFENSE       equ 016000000h
DIAXIS_FOOTBALLO_LATERAL                equ 016008201h ; Move / Aim: left / right
DIAXIS_FOOTBALLO_MOVE                   equ 016010202h ; Move / Aim: up / down
DIBUTTON_FOOTBALLO_JUMP                 equ 016000401h ; jump or hurdle over defender
DIBUTTON_FOOTBALLO_LEFTARM              equ 016000402h ; holds out left arm
DIBUTTON_FOOTBALLO_RIGHTARM             equ 016000403h ; holds out right arm
DIBUTTON_FOOTBALLO_THROW                equ 016000404h ; throw pass or lateral ball to another runner
DIBUTTON_FOOTBALLO_SPIN                 equ 016000405h ; Spin to avoid defenders
DIBUTTON_FOOTBALLO_MENU                 equ 0160004FDh ; Show menu options
; --- Priority 2 controls ---

DIBUTTON_FOOTBALLO_JUKE                 equ 016004406h ; Use special move to avoid defenders
DIBUTTON_FOOTBALLO_SHOULDER             equ 016004407h ; Lower shoulder to run over defenders
DIBUTTON_FOOTBALLO_TURBO                equ 016004408h ; Speed burst past defenders
DIBUTTON_FOOTBALLO_DIVE                 equ 016004409h ; Dive over defenders
DIBUTTON_FOOTBALLO_ZOOM                 equ 01600440Ah ; Zoom view in / out
DIBUTTON_FOOTBALLO_SUBSTITUTE           equ 01600440Bh ; substitute one player for another
DIBUTTON_FOOTBALLO_LEFT_LINK            equ 01600C4E4h ; Fallback sidestep left button
DIBUTTON_FOOTBALLO_RIGHT_LINK           equ 01600C4ECh ; Fallback sidestep right button
DIBUTTON_FOOTBALLO_FORWARD_LINK         equ 0160144E0h ; Fallback move forward button
DIBUTTON_FOOTBALLO_BACK_LINK            equ 0160144E8h ; Fallback move back button
DIBUTTON_FOOTBALLO_DEVICE               equ 0160044FEh ; Show input device and controls
DIBUTTON_FOOTBALLO_PAUSE                equ 0160044FCh ; Start / Pause / Restart game

; --- Sports - Football - Defense Defense ---
DIVIRTUAL_SPORTS_FOOTBALL_DEFENSE       equ 017000000h
DIAXIS_FOOTBALLD_LATERAL                equ 017008201h ; Move / Aim: left / right
DIAXIS_FOOTBALLD_MOVE                   equ 017010202h ; Move / Aim: up / down
DIBUTTON_FOOTBALLD_PLAY                 equ 017000401h ; cycle through available plays
DIBUTTON_FOOTBALLD_SELECT               equ 017000402h ; select player closest to the ball
DIBUTTON_FOOTBALLD_JUMP                 equ 017000403h ; jump to intercept or block
DIBUTTON_FOOTBALLD_TACKLE               equ 017000404h ; tackler runner
DIBUTTON_FOOTBALLD_FAKE                 equ 017000405h ; hold down to fake tackle or intercept
DIBUTTON_FOOTBALLD_SUPERTACKLE          equ 017000406h ; Initiate special tackle
DIBUTTON_FOOTBALLD_MENU                 equ 0170004FDh ; Show menu options
; --- Priority 2 controls ---

DIBUTTON_FOOTBALLD_SPIN                 equ 017004407h ; Spin to beat offensive line
DIBUTTON_FOOTBALLD_SWIM                 equ 017004408h ; Swim to beat the offensive line
DIBUTTON_FOOTBALLD_BULLRUSH             equ 017004409h ; Bull rush the offensive line
DIBUTTON_FOOTBALLD_RIP                  equ 01700440Ah ; Rip the offensive line
DIBUTTON_FOOTBALLD_AUDIBLE              equ 01700440Bh ; Change defensive play at the line of scrimmage
DIBUTTON_FOOTBALLD_ZOOM                 equ 01700440Ch ; Zoom view in / out
DIBUTTON_FOOTBALLD_SUBSTITUTE           equ 01700440Dh ; substitute one player for another
DIBUTTON_FOOTBALLD_LEFT_LINK            equ 01700C4E4h ; Fallback sidestep left button
DIBUTTON_FOOTBALLD_RIGHT_LINK           equ 01700C4ECh ; Fallback sidestep right button
DIBUTTON_FOOTBALLD_FORWARD_LINK         equ 0170144E0h ; Fallback move forward button
DIBUTTON_FOOTBALLD_BACK_LINK            equ 0170144E8h ; Fallback move back button
DIBUTTON_FOOTBALLD_DEVICE               equ 0170044FEh ; Show input device and controls
DIBUTTON_FOOTBALLD_PAUSE                equ 0170044FCh ; Start / Pause / Restart game

; --- Sports - Golf ---
DIVIRTUAL_SPORTS_GOLF                   equ 018000000h
DIAXIS_GOLF_LATERAL                     equ 018008201h ; Move / Aim: left / right
DIAXIS_GOLF_MOVE                        equ 018010202h ; Move / Aim: up / down
DIBUTTON_GOLF_SWING                     equ 018000401h ; swing club
DIBUTTON_GOLF_SELECT                    equ 018000402h ; cycle between: club / swing strength / ball arc / ball spin
DIBUTTON_GOLF_UP                        equ 018000403h ; increase selection
DIBUTTON_GOLF_DOWN                      equ 018000404h ; decrease selection
DIBUTTON_GOLF_TERRAIN                   equ 018000405h ; shows terrain detail
DIBUTTON_GOLF_FLYBY                     equ 018000406h ; view the hole via a flyby
DIBUTTON_GOLF_MENU                      equ 0180004FDh ; Show menu options
; --- Priority 2 controls ---

DIHATSWITCH_GOLF_SCROLL                 equ 018004601h ; scroll view
DIBUTTON_GOLF_ZOOM                      equ 018004407h ; Zoom view in / out
DIBUTTON_GOLF_TIMEOUT                   equ 018004408h ; Call for time out
DIBUTTON_GOLF_SUBSTITUTE                equ 018004409h ; substitute one player for another
DIBUTTON_GOLF_LEFT_LINK                 equ 01800C4E4h ; Fallback sidestep left button
DIBUTTON_GOLF_RIGHT_LINK                equ 01800C4ECh ; Fallback sidestep right button
DIBUTTON_GOLF_FORWARD_LINK              equ 0180144E0h ; Fallback move forward button
DIBUTTON_GOLF_BACK_LINK                 equ 0180144E8h ; Fallback move back button
DIBUTTON_GOLF_DEVICE                    equ 0180044FEh ; Show input device and controls
DIBUTTON_GOLF_PAUSE                     equ 0180044FCh ; Start / Pause / Restart game

; --- Sports - Hockey - Offense Offense ---
DIVIRTUAL_SPORTS_HOCKEY_OFFENSE         equ 019000000h
DIAXIS_HOCKEYO_LATERAL                  equ 019008201h ; Move / Aim: left / right
DIAXIS_HOCKEYO_MOVE                     equ 019010202h ; Move / Aim: up / down
DIBUTTON_HOCKEYO_SHOOT                  equ 019000401h ; Shoot
DIBUTTON_HOCKEYO_PASS                   equ 019000402h ; pass the puck
DIBUTTON_HOCKEYO_BURST                  equ 019000403h ; invoke speed burst
DIBUTTON_HOCKEYO_SPECIAL                equ 019000404h ; invoke special move
DIBUTTON_HOCKEYO_FAKE                   equ 019000405h ; hold down to fake pass or kick
DIBUTTON_HOCKEYO_MENU                   equ 0190004FDh ; Show menu options
; --- Priority 2 controls ---

DIHATSWITCH_HOCKEYO_SCROLL              equ 019004601h ; scroll view
DIBUTTON_HOCKEYO_ZOOM                   equ 019004406h ; Zoom view in / out
DIBUTTON_HOCKEYO_STRATEGY               equ 019004407h ; Invoke coaching menu for strategy help
DIBUTTON_HOCKEYO_TIMEOUT                equ 019004408h ; Call for time out
DIBUTTON_HOCKEYO_SUBSTITUTE             equ 019004409h ; substitute one player for another
DIBUTTON_HOCKEYO_LEFT_LINK              equ 01900C4E4h ; Fallback sidestep left button
DIBUTTON_HOCKEYO_RIGHT_LINK             equ 01900C4ECh ; Fallback sidestep right button
DIBUTTON_HOCKEYO_FORWARD_LINK           equ 0190144E0h ; Fallback move forward button
DIBUTTON_HOCKEYO_BACK_LINK              equ 0190144E8h ; Fallback move back button
DIBUTTON_HOCKEYO_DEVICE                 equ 0190044FEh ; Show input device and controls
DIBUTTON_HOCKEYO_PAUSE                  equ 0190044FCh ; Start / Pause / Restart game

; --- Sports - Hockey - Defense Defense ---
DIVIRTUAL_SPORTS_HOCKEY_DEFENSE         equ 01A000000h
DIAXIS_HOCKEYD_LATERAL                  equ 01A008201h ; Move / Aim: left / right
DIAXIS_HOCKEYD_MOVE                     equ 01A010202h ; Move / Aim: up / down
DIBUTTON_HOCKEYD_PLAYER                 equ 01A000401h ; control player closest to the puck
DIBUTTON_HOCKEYD_STEAL                  equ 01A000402h ; attempt steal
DIBUTTON_HOCKEYD_BURST                  equ 01A000403h ; speed burst or body check
DIBUTTON_HOCKEYD_BLOCK                  equ 01A000404h ; block puck
DIBUTTON_HOCKEYD_FAKE                   equ 01A000405h ; hold down to fake tackle or intercept
DIBUTTON_HOCKEYD_MENU                   equ 01A0004FDh ; Show menu options
; --- Priority 2 controls ---

DIHATSWITCH_HOCKEYD_SCROLL              equ 01A004601h ; scroll view
DIBUTTON_HOCKEYD_ZOOM                   equ 01A004406h ; Zoom view in / out
DIBUTTON_HOCKEYD_STRATEGY               equ 01A004407h ; Invoke coaching menu for strategy help
DIBUTTON_HOCKEYD_TIMEOUT                equ 01A004408h ; Call for time out
DIBUTTON_HOCKEYD_SUBSTITUTE             equ 01A004409h ; substitute one player for another
DIBUTTON_HOCKEYD_LEFT_LINK              equ 01A00C4E4h ; Fallback sidestep left button
DIBUTTON_HOCKEYD_RIGHT_LINK             equ 01A00C4ECh ; Fallback sidestep right button
DIBUTTON_HOCKEYD_FORWARD_LINK           equ 01A0144E0h ; Fallback move forward button
DIBUTTON_HOCKEYD_BACK_LINK              equ 01A0144E8h ; Fallback move back button
DIBUTTON_HOCKEYD_DEVICE                 equ 01A0044FEh ; Show input device and controls
DIBUTTON_HOCKEYD_PAUSE                  equ 01A0044FCh ; Start / Pause / Restart game

; --- Sports - Hockey - Goalie Goal tending  ---
DIVIRTUAL_SPORTS_HOCKEY_GOALIE          equ 01B000000h
DIAXIS_HOCKEYG_LATERAL                  equ 01B008201h ; Move / Aim: left / right
DIAXIS_HOCKEYG_MOVE                     equ 01B010202h ; Move / Aim: up / down
DIBUTTON_HOCKEYG_PASS                   equ 01B000401h ; pass puck
DIBUTTON_HOCKEYG_POKE                   equ 01B000402h ; poke / check / hack
DIBUTTON_HOCKEYG_STEAL                  equ 01B000403h ; attempt steal
DIBUTTON_HOCKEYG_BLOCK                  equ 01B000404h ; block puck
DIBUTTON_HOCKEYG_MENU                   equ 01B0004FDh ; Show menu options
; --- Priority 2 controls ---

DIHATSWITCH_HOCKEYG_SCROLL              equ 01B004601h ; scroll view */
DIBUTTON_HOCKEYG_ZOOM                   equ 01B004405h ; Zoom view in / out */
DIBUTTON_HOCKEYG_STRATEGY               equ 01B004406h ; Invoke coaching menu for strategy help */
DIBUTTON_HOCKEYG_TIMEOUT                equ 01B004407h ; Call for time out */
DIBUTTON_HOCKEYG_SUBSTITUTE             equ 01B004408h ; substitute one player for another */
DIBUTTON_HOCKEYG_LEFT_LINK              equ 01B00C4E4h ; Fallback sidestep left button */
DIBUTTON_HOCKEYG_RIGHT_LINK             equ 01B00C4ECh ; Fallback sidestep right button */
DIBUTTON_HOCKEYG_FORWARD_LINK           equ 01B0144E0h ; Fallback move forward button */
DIBUTTON_HOCKEYG_BACK_LINK              equ 01B0144E8h ; Fallback move back button */
DIBUTTON_HOCKEYG_DEVICE                 equ 01B0044FEh ; Show input device and controls 
DIBUTTON_HOCKEYG_PAUSE                  equ 01B0044FCh ; Start / Pause / Restart game

; --- Sports - Mountain Biking ---
DIVIRTUAL_SPORTS_BIKING_MOUNTAIN        equ 01C000000h
DIAXIS_BIKINGM_TURN                     equ 01C008201h ; left / right
DIAXIS_BIKINGM_PEDAL                    equ 01C010202h ; Pedal faster / slower / brake
DIBUTTON_BIKINGM_JUMP                   equ 01C000401h ; jump over obstacle
DIBUTTON_BIKINGM_CAMERA                 equ 01C000402h ; switch camera view
DIBUTTON_BIKINGM_SPECIAL1               equ 01C000403h ; perform first special move
DIBUTTON_BIKINGM_SELECT                 equ 01C000404h ; Select
DIBUTTON_BIKINGM_SPECIAL2               equ 01C000405h ; perform second special move
DIBUTTON_BIKINGM_MENU                   equ 01C0004FDh ; Show menu options
; --- Priority 2 controls ---

DIHATSWITCH_BIKINGM_SCROLL              equ 01C004601h ; scroll view
DIBUTTON_BIKINGM_ZOOM                   equ 01C004406h ; Zoom view in / out
DIAXIS_BIKINGM_BRAKE                    equ 01C044203h ; Brake axis
DIBUTTON_BIKINGM_LEFT_LINK              equ 01C00C4E4h ; Fallback turn left button
DIBUTTON_BIKINGM_RIGHT_LINK             equ 01C00C4ECh ; Fallback turn right button
DIBUTTON_BIKINGM_FASTER_LINK            equ 01C0144E0h ; Fallback pedal faster button
DIBUTTON_BIKINGM_SLOWER_LINK            equ 01C0144E8h ; Fallback pedal slower button
DIBUTTON_BIKINGM_BRAKE_BUTTON_LINK      equ 01C0444E8h ; Fallback brake button
DIBUTTON_BIKINGM_DEVICE                 equ 01C0044FEh ; Show input device and controls
DIBUTTON_BIKINGM_PAUSE                  equ 01C0044FCh ; Start / Pause / Restart game

; --- Sports: Skiing / Snowboarding / Skateboarding ---
DIVIRTUAL_SPORTS_SKIING                 equ 01D000000h
DIAXIS_SKIING_TURN                      equ 01D008201h ; left / right
DIAXIS_SKIING_SPEED                     equ 01D010202h ; faster / slower
DIBUTTON_SKIING_JUMP                    equ 01D000401h ; Jump
DIBUTTON_SKIING_CROUCH                  equ 01D000402h ; crouch down
DIBUTTON_SKIING_CAMERA                  equ 01D000403h ; switch camera view
DIBUTTON_SKIING_SPECIAL1                equ 01D000404h ; perform first special move
DIBUTTON_SKIING_SELECT                  equ 01D000405h ; Select
DIBUTTON_SKIING_SPECIAL2                equ 01D000406h ; perform second special move
DIBUTTON_SKIING_MENU                    equ 01D0004FDh ; Show menu options
; --- Priority 2 controls ---

DIHATSWITCH_SKIING_GLANCE               equ 01D004601h ; scroll view
DIBUTTON_SKIING_ZOOM                    equ 01D004407h ; Zoom view in / out
DIBUTTON_SKIING_LEFT_LINK               equ 01D00C4E4h ; Fallback turn left button
DIBUTTON_SKIING_RIGHT_LINK              equ 01D00C4ECh ; Fallback turn right button
DIBUTTON_SKIING_FASTER_LINK             equ 01D0144E0h ; Fallback increase speed button
DIBUTTON_SKIING_SLOWER_LINK             equ 01D0144E8h ; Fallback decrease speed button
DIBUTTON_SKIING_DEVICE                  equ 01D0044FEh ; Show input device and controls
DIBUTTON_SKIING_PAUSE                   equ 01D0044FCh ; Start / Pause / Restart game

; --- Sports - Soccer - Offense Offense ---
DIVIRTUAL_SPORTS_SOCCER_OFFENSE         equ 01E000000h
DIAXIS_SOCCERO_LATERAL                  equ 01E008201h ; Move / Aim: left / right
DIAXIS_SOCCERO_MOVE                     equ 01E010202h ; Move / Aim: up / down
DIAXIS_SOCCERO_BEND                     equ 01E018203h ; Bend to soccer shot/pass
DIBUTTON_SOCCERO_SHOOT                  equ 01E000401h ; Shoot the ball
DIBUTTON_SOCCERO_PASS                   equ 01E000402h ; Pass
DIBUTTON_SOCCERO_FAKE                   equ 01E000403h ; Fake
DIBUTTON_SOCCERO_PLAYER                 equ 01E000404h ; Select next player
DIBUTTON_SOCCERO_SPECIAL1               equ 01E000405h ; Apply special move
DIBUTTON_SOCCERO_SELECT                 equ 01E000406h ; Select special move
DIBUTTON_SOCCERO_MENU                   equ 01E0004FDh ; Show menu options
; --- Priority 2 controls ---

DIHATSWITCH_SOCCERO_GLANCE              equ 01E004601h ; scroll view
DIBUTTON_SOCCERO_SUBSTITUTE             equ 01E004407h ; Substitute one player for another
DIBUTTON_SOCCERO_SHOOTLOW               equ 01E004408h ; Shoot the ball low
DIBUTTON_SOCCERO_SHOOTHIGH              equ 01E004409h ; Shoot the ball high
DIBUTTON_SOCCERO_PASSTHRU               equ 01E00440Ah ; Make a thru pass
DIBUTTON_SOCCERO_SPRINT                 equ 01E00440Bh ; Sprint / turbo boost
DIBUTTON_SOCCERO_CONTROL                equ 01E00440Ch ; Obtain control of the ball
DIBUTTON_SOCCERO_HEAD                   equ 01E00440Dh ; Attempt to head the ball
DIBUTTON_SOCCERO_LEFT_LINK              equ 01E00C4E4h ; Fallback sidestep left button
DIBUTTON_SOCCERO_RIGHT_LINK             equ 01E00C4ECh ; Fallback sidestep right button
DIBUTTON_SOCCERO_FORWARD_LINK           equ 01E0144E0h ; Fallback move forward button
DIBUTTON_SOCCERO_BACK_LINK              equ 01E0144E8h ; Fallback move back button
DIBUTTON_SOCCERO_DEVICE                 equ 01E0044FEh ; Show input device and controls
DIBUTTON_SOCCERO_PAUSE                  equ 01E0044FCh ; Start / Pause / Restart game

;--- Sports - Soccer - Defense Defense ---
DIVIRTUAL_SPORTS_SOCCER_DEFENSE         equ 01F000000h
DIAXIS_SOCCERD_LATERAL                  equ 01F008201h ; Move / Aim: left / right
DIAXIS_SOCCERD_MOVE                     equ 01F010202h ; Move / Aim: up / down
DIBUTTON_SOCCERD_BLOCK                  equ 01F000401h ; Attempt to block shot
DIBUTTON_SOCCERD_STEAL                  equ 01F000402h ; Attempt to steal ball
DIBUTTON_SOCCERD_FAKE                   equ 01F000403h ; Fake a block or a steal
DIBUTTON_SOCCERD_PLAYER                 equ 01F000404h ; Select next player
DIBUTTON_SOCCERD_SPECIAL                equ 01F000405h ; Apply special move
DIBUTTON_SOCCERD_SELECT                 equ 01F000406h ; Select special move
DIBUTTON_SOCCERD_SLIDE                  equ 01F000407h ; Attempt a slide tackle
DIBUTTON_SOCCERD_MENU                   equ 01F0004FDh ; Show menu options
; --- Priority 2 controls ---

DIHATSWITCH_SOCCERD_GLANCE              equ 01F004601h ; scroll view
DIBUTTON_SOCCERD_FOUL                   equ 01F004408h ; Initiate a foul / hard-foul
DIBUTTON_SOCCERD_HEAD                   equ 01F004409h ; Attempt a Header
DIBUTTON_SOCCERD_CLEAR                  equ 01F00440Ah ; Attempt to clear the ball down the field
DIBUTTON_SOCCERD_GOALIECHARGE           equ 01F00440Bh ; Make the goalie charge out of the box
DIBUTTON_SOCCERD_SUBSTITUTE             equ 01F00440Ch ; Substitute one player for another
DIBUTTON_SOCCERD_LEFT_LINK              equ 01F00C4E4h ; Fallback sidestep left button
DIBUTTON_SOCCERD_RIGHT_LINK             equ 01F00C4ECh ; Fallback sidestep right button
DIBUTTON_SOCCERD_FORWARD_LINK           equ 01F0144E0h ; Fallback move forward button
DIBUTTON_SOCCERD_BACK_LINK              equ 01F0144E8h ; Fallback move back button
DIBUTTON_SOCCERD_DEVICE                 equ 01F0044FEh ; Show input device and controls
DIBUTTON_SOCCERD_PAUSE                  equ 01F0044FCh ; Start / Pause / Restart game

; --- Sports - Racquet Tennis - Table-Tennis - Squash ---
DIVIRTUAL_SPORTS_RACQUET                equ 020000000h
DIAXIS_RACQUET_LATERAL                  equ 020008201h ; Move / Aim: left / right
DIAXIS_RACQUET_MOVE                     equ 020010202h ; Move / Aim: up / down
DIBUTTON_RACQUET_SWING                  equ 020000401h ; Swing racquet
DIBUTTON_RACQUET_BACKSWING              equ 020000402h ; Swing backhand
DIBUTTON_RACQUET_SMASH                  equ 020000403h ; Smash shot
DIBUTTON_RACQUET_SPECIAL                equ 020000404h ; Special shot
DIBUTTON_RACQUET_SELECT                 equ 020000405h ; Select special shot
DIBUTTON_RACQUET_MENU                   equ 0200004FDh ; Show menu options
; --- Priority 2 controls ---

DIHATSWITCH_RACQUET_GLANCE              equ 020004601h ; scroll view
DIBUTTON_RACQUET_TIMEOUT                equ 020004406h ; Call for time out
DIBUTTON_RACQUET_SUBSTITUTE             equ 020004407h ; Substitute one player for another
DIBUTTON_RACQUET_LEFT_LINK              equ 02000C4E4h ; Fallback sidestep left button
DIBUTTON_RACQUET_RIGHT_LINK             equ 02000C4ECh ; Fallback sidestep right button
DIBUTTON_RACQUET_FORWARD_LINK           equ 0200144E0h ; Fallback move forward button
DIBUTTON_RACQUET_BACK_LINK              equ 0200144E8h ; Fallback move back button
DIBUTTON_RACQUET_DEVICE                 equ 0200044FEh ; Show input device and controls
DIBUTTON_RACQUET_PAUSE                  equ 0200044FCh ; Start / Pause / Restart game

; --- Arcade- 2D Side to Side movement ---
DIVIRTUAL_ARCADE_SIDE2SIDE              equ 021000000h
DIAXIS_ARCADES_LATERAL                  equ 021008201h ; left / right
DIAXIS_ARCADES_MOVE                     equ 021010202h ; up / down
DIBUTTON_ARCADES_THROW                  equ 021000401h ; throw object
DIBUTTON_ARCADES_CARRY                  equ 021000402h ; carry object
DIBUTTON_ARCADES_ATTACK                 equ 021000403h ; attack
DIBUTTON_ARCADES_SPECIAL                equ 021000404h ; apply special move
DIBUTTON_ARCADES_SELECT                 equ 021000405h ; select special move
DIBUTTON_ARCADES_MENU                   equ 0210004FDh ; Show menu options
; --- Priority 2 controls ---

DIHATSWITCH_ARCADES_VIEW                equ 021004601h ; scroll view left / right / up / down
DIBUTTON_ARCADES_LEFT_LINK              equ 02100C4E4h ; Fallback sidestep left button
DIBUTTON_ARCADES_RIGHT_LINK             equ 02100C4ECh ; Fallback sidestep right button
DIBUTTON_ARCADES_FORWARD_LINK           equ 0210144E0h ; Fallback move forward button
DIBUTTON_ARCADES_BACK_LINK              equ 0210144E8h ; Fallback move back button
DIBUTTON_ARCADES_VIEW_UP_LINK           equ 02107C4E0h ; Fallback scroll view up button
DIBUTTON_ARCADES_VIEW_DOWN_LINK         equ 02107C4E8h ; Fallback scroll view down button
DIBUTTON_ARCADES_VIEW_LEFT_LINK         equ 02107C4E4h ; Fallback scroll view left button
DIBUTTON_ARCADES_VIEW_RIGHT_LINK        equ 02107C4ECh ; Fallback scroll view right button
DIBUTTON_ARCADES_DEVICE                 equ 0210044FEh ; Show input device and controls
DIBUTTON_ARCADES_PAUSE                  equ 0210044FCh ; Start / Pause / Restart game

; --- Arcade - Platform Game Character moves around on screen ---
DIVIRTUAL_ARCADE_PLATFORM               equ 022000000h
DIAXIS_ARCADEP_LATERAL                  equ 022008201h ; Left / right
DIAXIS_ARCADEP_MOVE                     equ 022010202h ; Up / down
DIBUTTON_ARCADEP_JUMP                   equ 022000401h ; Jump
DIBUTTON_ARCADEP_FIRE                   equ 022000402h ; Fire
DIBUTTON_ARCADEP_CROUCH                 equ 022000403h ; Crouch
DIBUTTON_ARCADEP_SPECIAL                equ 022000404h ; Apply special move
DIBUTTON_ARCADEP_SELECT                 equ 022000405h ; Select special move
DIBUTTON_ARCADEP_MENU                   equ 0220004FDh ; Show menu options
; --- Priority 2 controls ---

DIHATSWITCH_ARCADEP_VIEW                equ 022004601h ; Scroll view
DIBUTTON_ARCADEP_FIRESECONDARY          equ 022004406h ; Alternative fire button
DIBUTTON_ARCADEP_LEFT_LINK              equ 02200C4E4h ; Fallback sidestep left button
DIBUTTON_ARCADEP_RIGHT_LINK             equ 02200C4ECh ; Fallback sidestep right button
DIBUTTON_ARCADEP_FORWARD_LINK           equ 0220144E0h ; Fallback move forward button
DIBUTTON_ARCADEP_BACK_LINK              equ 0220144E8h ; Fallback move back button
DIBUTTON_ARCADEP_VIEW_UP_LINK           equ 02207C4E0h ; Fallback scroll view up button
DIBUTTON_ARCADEP_VIEW_DOWN_LINK         equ 02207C4E8h ; Fallback scroll view down button
DIBUTTON_ARCADEP_VIEW_LEFT_LINK         equ 02207C4E4h ; Fallback scroll view left button
DIBUTTON_ARCADEP_VIEW_RIGHT_LINK        equ 02207C4ECh ; Fallback scroll view right button
DIBUTTON_ARCADEP_DEVICE                 equ 0220044FEh ; Show input device and controls
DIBUTTON_ARCADEP_PAUSE                  equ 0220044FCh ; Start / Pause / Restart game

; --- CAD - 2D Object Control Controls to select and move objects in 2D ---
DIVIRTUAL_CAD_2DCONTROL                 equ 023000000h
DIAXIS_2DCONTROL_LATERAL                equ 023008201h ; Move view left / right
DIAXIS_2DCONTROL_MOVE                   equ 023010202h ; Move view up / down
DIAXIS_2DCONTROL_INOUT                  equ 023018203h ; Zoom - in / out
DIBUTTON_2DCONTROL_SELECT               equ 023000401h ; Select Object
DIBUTTON_2DCONTROL_SPECIAL1             equ 023000402h ; Do first special operation
DIBUTTON_2DCONTROL_SPECIAL              equ 023000403h ; Select special operation
DIBUTTON_2DCONTROL_SPECIAL2             equ 023000404h ; Do second special operation
DIBUTTON_2DCONTROL_MENU                 equ 0230004FDh ; Show menu options
; --- Priority 2 controls ---

DIHATSWITCH_2DCONTROL_HATSWITCH         equ 023004601h ; Hat switch
DIAXIS_2DCONTROL_ROTATEZ                equ 023024204h ; Rotate view clockwise / counterclockwise
DIBUTTON_2DCONTROL_DISPLAY              equ 023004405h ; Shows next on-screen display options
DIBUTTON_2DCONTROL_DEVICE               equ 0230044FEh ; Show input device and controls
DIBUTTON_2DCONTROL_PAUSE                equ 0230044FCh ; Start / Pause / Restart game

; --- CAD - 3D object control Controls to select and move objects within a 3D environment ---
DIVIRTUAL_CAD_3DCONTROL                 equ 024000000h
DIAXIS_3DCONTROL_LATERAL                equ 024008201h ; Move view left / right
DIAXIS_3DCONTROL_MOVE                   equ 024010202h ; Move view up / down
DIAXIS_3DCONTROL_INOUT                  equ 024018203h ; Zoom - in / out
DIBUTTON_3DCONTROL_SELECT               equ 024000401h ; Select Object
DIBUTTON_3DCONTROL_SPECIAL1             equ 024000402h ; Do first special operation
DIBUTTON_3DCONTROL_SPECIAL              equ 024000403h ; Select special operation
DIBUTTON_3DCONTROL_SPECIAL2             equ 024000404h ; Do second special operation
DIBUTTON_3DCONTROL_MENU                 equ 0240004FDh ; Show menu options
; --- Priority 2 controls ---

DIHATSWITCH_3DCONTROL_HATSWITCH         equ 024004601h ; Hat switch
DIAXIS_3DCONTROL_ROTATEX                equ 024034204h ; Rotate view forward or up / backward or down
DIAXIS_3DCONTROL_ROTATEY                equ 02402C205h ; Rotate view clockwise / counterclockwise
DIAXIS_3DCONTROL_ROTATEZ                equ 024024206h ; Rotate view left / right
DIBUTTON_3DCONTROL_DISPLAY              equ 024004405h ; Show next on-screen display options
DIBUTTON_3DCONTROL_DEVICE               equ 0240044FEh ; Show input device and controls
DIBUTTON_3DCONTROL_PAUSE                equ 0240044FCh ; Start / Pause / Restart game

; --- CAD - 3D Navigation - Fly through Controls for 3D modeling ---
DIVIRTUAL_CAD_FLYBY                     equ 025000000h
DIAXIS_CADF_LATERAL                     equ 025008201h ; move view left / right
DIAXIS_CADF_MOVE                        equ 025010202h ; move view up / down
DIAXIS_CADF_INOUT                       equ 025018203h ; in / out
DIBUTTON_CADF_SELECT                    equ 025000401h ; Select Object
DIBUTTON_CADF_SPECIAL1                  equ 025000402h ; do first special operation
DIBUTTON_CADF_SPECIAL                   equ 025000403h ; Select special operation
DIBUTTON_CADF_SPECIAL2                  equ 025000404h ; do second special operation
DIBUTTON_CADF_MENU                      equ 0250004FDh ; Show menu options
; --- Priority 2 controls ---

DIHATSWITCH_CADF_HATSWITCH              equ 025004601h ; Hat switch
DIAXIS_CADF_ROTATEX                     equ 025034204h ; Rotate view forward or up / backward or down
DIAXIS_CADF_ROTATEY                     equ 02502C205h ; Rotate view clockwise / counterclockwise
DIAXIS_CADF_ROTATEZ                     equ 025024206h ; Rotate view left / right
DIBUTTON_CADF_DISPLAY                   equ 025004405h ; shows next on-screen display options
DIBUTTON_CADF_DEVICE                    equ 0250044FEh ; Show input device and controls
DIBUTTON_CADF_PAUSE                     equ 0250044FCh ; Start / Pause / Restart game

; --- CAD - 3D Model Control Controls for 3D modeling ---
DIVIRTUAL_CAD_MODEL                     equ 026000000h
DIAXIS_CADM_LATERAL                     equ 026008201h ; move view left / right
DIAXIS_CADM_MOVE                        equ 026010202h ; move view up / down
DIAXIS_CADM_INOUT                       equ 026018203h ; in / out
DIBUTTON_CADM_SELECT                    equ 026000401h ; Select Object
DIBUTTON_CADM_SPECIAL1                  equ 026000402h ; do first special operation
DIBUTTON_CADM_SPECIAL                   equ 026000403h ; Select special operation
DIBUTTON_CADM_SPECIAL2                  equ 026000404h ; do second special operation
DIBUTTON_CADM_MENU                      equ 0260004FDh ; Show menu options
; --- Priority 2 controls ---

DIHATSWITCH_CADM_HATSWITCH              equ 026004601h ; Hat switch
DIAXIS_CADM_ROTATEX                     equ 026034204h ; Rotate view forward or up / backward or down
DIAXIS_CADM_ROTATEY                     equ 02602C205h ; Rotate view clockwise / counterclockwise
DIAXIS_CADM_ROTATEZ                     equ 026024206h ; Rotate view left / right
DIBUTTON_CADM_DISPLAY                   equ 026004405h ; shows next on-screen display options
DIBUTTON_CADM_DEVICE                    equ 0260044FEh ; Show input device and controls
DIBUTTON_CADM_PAUSE                     equ 0260044FCh ; Start / Pause / Restart game

;--- Control - Media Equipment Remote ---
DIVIRTUAL_REMOTE_CONTROL                equ 027000000h
DIAXIS_REMOTE_SLIDER                    equ 027050201h ; Slider for adjustment: volume / color / bass / etc
DIBUTTON_REMOTE_MUTE                    equ 027000401h ; Set volume on current device to zero
DIBUTTON_REMOTE_SELECT                  equ 027000402h ; Next/previous: channel/ track / chapter / picture / station
DIBUTTON_REMOTE_PLAY                    equ 027002403h ; Start or pause entertainment on current device
DIBUTTON_REMOTE_CUE                     equ 027002404h ; Move through current media
DIBUTTON_REMOTE_REVIEW                  equ 027002405h ; Move through current media
DIBUTTON_REMOTE_CHANGE                  equ 027002406h ; Select next device
DIBUTTON_REMOTE_RECORD                  equ 027002407h ; Start recording the current media
DIBUTTON_REMOTE_MENU                    equ 0270004FDh ; Show menu options
;--- Priority 2 controls ---

DIAXIS_REMOTE_SLIDER2                   equ 027054202h ; Slider for adjustment: volume
DIBUTTON_REMOTE_TV                      equ 027005C08h ; Select TV
DIBUTTON_REMOTE_CABLE                   equ 027005C09h ; Select cable box
DIBUTTON_REMOTE_CD                      equ 027005C0Ah ; Select CD player
DIBUTTON_REMOTE_VCR                     equ 027005C0Bh ; Select VCR
DIBUTTON_REMOTE_TUNER                   equ 027005C0Ch ; Select tuner
DIBUTTON_REMOTE_DVD                     equ 027005C0Dh ; Select DVD player
DIBUTTON_REMOTE_ADJUST                  equ 027005C0Eh ; Enter device adjustment menu
DIBUTTON_REMOTE_DIGIT0                  equ 02700540Fh ; Digit 0
DIBUTTON_REMOTE_DIGIT1                  equ 027005410h ; Digit 1
DIBUTTON_REMOTE_DIGIT2                  equ 027005411h ; Digit 2
DIBUTTON_REMOTE_DIGIT3                  equ 027005412h ; Digit 3
DIBUTTON_REMOTE_DIGIT4                  equ 027005413h ; Digit 4
DIBUTTON_REMOTE_DIGIT5                  equ 027005414h ; Digit 5
DIBUTTON_REMOTE_DIGIT6                  equ 027005415h ; Digit 6
DIBUTTON_REMOTE_DIGIT7                  equ 027005416h ; Digit 7
DIBUTTON_REMOTE_DIGIT8                  equ 027005417h ; Digit 8
DIBUTTON_REMOTE_DIGIT9                  equ 027005418h ; Digit 9
DIBUTTON_REMOTE_DEVICE                  equ 0270044FEh ; Show input device and controls
DIBUTTON_REMOTE_PAUSE                   equ 0270044FCh ; Start / Pause / Restart game

; --- Control- Web Help or Browser ---
DIVIRTUAL_BROWSER_CONTROL               equ 028000000h
DIAXIS_BROWSER_LATERAL                  equ 028008201h ; Move on screen pointer
DIAXIS_BROWSER_MOVE                     equ 028010202h ; Move on screen pointer
DIBUTTON_BROWSER_SELECT                 equ 028000401h ; Select current item
DIAXIS_BROWSER_VIEW                     equ 028018203h ; Move view up/down
DIBUTTON_BROWSER_REFRESH                equ 028000402h ; Refresh
DIBUTTON_BROWSER_MENU                   equ 0280004FDh ; Show menu options
; --- Priority 2 controls ---

DIBUTTON_BROWSER_SEARCH                 equ 028004403h ; Use search tool
DIBUTTON_BROWSER_STOP                   equ 028004404h ; Cease current update
DIBUTTON_BROWSER_HOME                   equ 028004405h ; Go directly to "home" location
DIBUTTON_BROWSER_FAVORITES              equ 028004406h ; Mark current site as favorite
DIBUTTON_BROWSER_NEXT                   equ 028004407h ; Select Next page
DIBUTTON_BROWSER_PREVIOUS               equ 028004408h ; Select Previous page
DIBUTTON_BROWSER_HISTORY                equ 028004409h ; Show/Hide History
DIBUTTON_BROWSER_PRINT                  equ 02800440Ah ; Print current page
DIBUTTON_BROWSER_DEVICE                 equ 0280044FEh ; Show input device and controls
DIBUTTON_BROWSER_PAUSE                  equ 0280044FCh ; Start / Pause / Restart game

;--- Driving Simulator - Giant Walking Robot Walking tank with weapons  ---
DIVIRTUAL_DRIVING_MECHA                 equ 029000000h
DIAXIS_MECHA_STEER                      equ 029008201h ; Turns mecha left/right
DIAXIS_MECHA_TORSO                      equ 029010202h ; Tilts torso forward/backward
DIAXIS_MECHA_ROTATE                     equ 029020203h ; Turns torso left/right
DIAXIS_MECHA_THROTTLE                   equ 029038204h ; Engine Speed
DIBUTTON_MECHA_FIRE                     equ 029000401h ; Fire
DIBUTTON_MECHA_WEAPONS                  equ 029000402h ; Select next weapon group
DIBUTTON_MECHA_TARGET                   equ 029000403h ; Select closest enemy available target
DIBUTTON_MECHA_REVERSE                  equ 029000404h ; Toggles throttle in/out of reverse
DIBUTTON_MECHA_ZOOM                     equ 029000405h ; Zoom in/out targeting reticule
DIBUTTON_MECHA_JUMP                     equ 029000406h ; Fires jump jets
DIBUTTON_MECHA_MENU                     equ 0290004FDh ; Show menu options
;--- Priority 2 controls ---

DIBUTTON_MECHA_CENTER                   equ 029004407h ; Center torso to legs
DIHATSWITCH_MECHA_GLANCE                equ 029004601h ; Look around
DIBUTTON_MECHA_VIEW                     equ 029004408h ; Cycle through view options
DIBUTTON_MECHA_FIRESECONDARY            equ 029004409h ; Alternative fire button
DIBUTTON_MECHA_LEFT_LINK                equ 02900C4E4h ; Fallback steer left button
DIBUTTON_MECHA_RIGHT_LINK               equ 02900C4ECh ; Fallback steer right button
DIBUTTON_MECHA_FORWARD_LINK             equ 0290144E0h ; Fallback tilt torso forward button
DIBUTTON_MECHA_BACK_LINK                equ 0290144E8h ; Fallback tilt toroso backward button
DIBUTTON_MECHA_ROTATE_LEFT_LINK         equ 0290244E4h ; Fallback rotate toroso right button
DIBUTTON_MECHA_ROTATE_RIGHT_LINK        equ 0290244ECh ; Fallback rotate torso left button
DIBUTTON_MECHA_FASTER_LINK              equ 02903C4E0h ; Fallback increase engine speed
DIBUTTON_MECHA_SLOWER_LINK              equ 02903C4E8h ; Fallback decrease engine speed
DIBUTTON_MECHA_DEVICE                   equ 0290044FEh ; Show input device and controls
DIBUTTON_MECHA_PAUSE                    equ 0290044FCh ; Start / Pause / Restart game

;*
;*  "ANY" semantics can be used as a last resort to get mappings for actions 
;*  that match nothing in the chosen virtual genre.  These semantics will be 
;*  mapped at a lower priority that virtual genre semantics.  Also, hardware 
;*  vendors will not be able to provide sensible mappings for these unless 
;*  they provide application specific mappings.
;*
DIAXIS_ANY_X_1                          equ 0FF00C201h
DIAXIS_ANY_X_2                          equ 0FF00C202h 
DIAXIS_ANY_Y_1                          equ 0FF014201h
DIAXIS_ANY_Y_2                          equ 0FF014202h
DIAXIS_ANY_Z_1                          equ 0FF01C201h
DIAXIS_ANY_Z_2                          equ 0FF01C202h
DIAXIS_ANY_R_1                          equ 0FF024201h
DIAXIS_ANY_R_2                          equ 0FF024202h
DIAXIS_ANY_U_1                          equ 0FF02C201h
DIAXIS_ANY_U_2                          equ 0FF02C202h
DIAXIS_ANY_V_1                          equ 0FF034201h
DIAXIS_ANY_V_2                          equ 0FF034202h
DIAXIS_ANY_A_1                          equ 0FF03C201h
DIAXIS_ANY_A_2                          equ 0FF03C202h 
DIAXIS_ANY_B_1                          equ 0FF044201h 
DIAXIS_ANY_B_2                          equ 0FF044202h 
DIAXIS_ANY_C_1                          equ 0FF04C201h 
DIAXIS_ANY_C_2                          equ 0FF04C202h 
DIAXIS_ANY_S_1                          equ 0FF054201h 
DIAXIS_ANY_S_2                          equ 0FF054202h 

DIAXIS_ANY_1                            equ 0FF004201h 
DIAXIS_ANY_2                            equ 0FF004202h 
DIAXIS_ANY_3                            equ 0FF004203h 
DIAXIS_ANY_4                            equ 0FF004204h 

DIPOV_ANY_1                             equ 0FF004601h 
DIPOV_ANY_2                             equ 0FF004602h 
DIPOV_ANY_3                             equ 0FF004603h 
DIPOV_ANY_4                             equ 0FF004604h 

DIBUTTON_ANY            MACRO   instance:VARARG
                        mov     eax,dwDevType
                        or      eax,0FF004400h
                        EXITM   <eax>
                        ENDM

;****************************************************************************
; 
;*  Definitions for non-IDirectInput (VJoyD) features defined more recently
;*  than the current sdk files
;*
;****************************************************************************

ifdef _INC_MMSYSTEM
ifndef MMNOJOY

ifndef __VJOYDX_INCLUDED__
__VJOYDX_INCLUDED__ equ 1

;
; Flag to indicate that the dwReserved2 field of the JOYINFOEX structure
; contains mini-driver specific data to be passed by VJoyD to the mini-
; driver instead of doing a poll.
;
JOY_PASSDRIVERDATA          equ 010000000h

;
; Informs the joystick driver that the configuration has been changed
; and should be reloaded from the registery.
; dwFlags is reserved and should be set to zero
;
joyConfigChanged                proto :dword

ifndef DIJ_RINGZERO
;
; Invoke the joystick control panel directly, using the passed window handle 
; as the parent of the dialog.  This API is only supported for compatibility 
; purposes; new applications should use the RunControlPanel method of a 
; device interface for a game controller.
; The API is called by using the function pointer returned by
; GetProcAddress( hCPL, TEXT("ShowJoyCPL") ) where hCPL is a HMODULE returned 
; by LoadLibrary( TEXT("joy.cpl") ).  The typedef is provided to allow 
; declaration and casting of an appropriately typed variable.
;
ShowJoyCPL                      proto   :HWND
LPFNSHOWJOYCPL                  typedef ptr ShowJoyCPL

endif ; DIJ_RINGZERO


;
; Hardware Setting indicating that the device is a headtracker
;
JOY_HWS_ISHEADTRACKER       equ 002000000h

;
; Hardware Setting indicating that the VxD is used to replace
; the standard analog polling
;
JOY_HWS_ISGAMEPORTDRIVER    equ 004000000h

;
; Hardware Setting indicating that the driver needs a standard
; gameport in order to communicate with the device.
;
JOY_HWS_ISANALOGPORTDRIVER  equ 008000000h

;
; Hardware Setting indicating that VJoyD should not load this
; driver, it will be loaded externally and will register with
; VJoyD of it's own accord.
;
JOY_HWS_AUTOLOAD            equ 010000000h

;
; Hardware Setting indicating that the driver acquires any
; resources needed without needing a devnode through VJoyD.
;
JOY_HWS_NODEVNODE           equ 020000000h


;
; Hardware Setting indicating that the device is a gameport bus
;
JOY_HWS_ISGAMEPORTBUS       equ 080000000h
JOY_HWS_GAMEPORTBUSBUSY     equ 000000001h

;
; Usage Setting indicating that the settings are volatile and
; should be removed if still present on a reboot.
;
JOY_US_VOLATILE             equ 000000008h

endif  ; __VJOYDX_INCLUDED__

endif  ; not MMNOJOY
endif  ; _INC_MMSYSTEM

;****************************************************************************
;*
;*  Definitions for non-IDirectInput (VJoyD) features defined more recently
;*  than the current ddk files
;*
;****************************************************************************

ifndef DIJ_RINGZERO

ifdef _INC_MMDDK
ifndef MMNOJOYDEV

ifndef __VJOYDXD_INCLUDED__
__VJOYDXD_INCLUDED__ equ 1
;
; Poll type in which the do_other field of the JOYOEMPOLLDATA
; structure contains mini-driver specific data passed from an app.
;
JOY_OEMPOLL_PASSDRIVERDATA  equ 7

endif  ; __VJOYDXD_INCLUDED__

endif  ; not MMNOJOYDEV;
endif  ; _INC_MMDDK

endif ; DIJ_RINGZERO

