ifndef                  _TARGA_ASM
_TARGA_ASM              equ     1

; ------------------------------------------------------
; Includes
                        include Files.asm

; ------------------------------------------------------
; Structures
TGA                     struct
Datas                   dword   ?
_Width                  dword   ?
Height                  dword   ?
Bits                    dword   ?
Orig_Width              dword   ?
Orig_Height             dword   ?
TGA                     ends

; ------------------------------------------------------
; Name: Load_TGA
; Desc: Load a 24 or 32 bits TARGA file into memory
Load_TGA                proc    uses ebx esi edi TGA_FName:dword, TGA_Struct:dword, Color_Key:dword
                        local   TGA_Buffer:dword
                        local   FSize:dword

                        mov     esi, TGA_Struct
                        mov     [esi + TGA.Datas], NULL

                        ; Load texture into memory
                        invoke  Load_File, TGA_FName, addr FSize
                        test    eax, eax
                        jz      Err_TGA_Load
                        mov     TGA_Buffer, eax

                        ; Decode the TGA file
                        mov     ebx, eax
                        cmp     byte ptr [ebx + 1], 1                   ; Can't have a colormap
                        je      Err_TGA_Format
                        cmp     byte ptr [ebx + 2], 2                   ; Must be uncompressed, true color
                        jne     Err_TGA_Format
                        movzx   eax, word ptr [ebx + 12]
                        test    eax, eax
                        js      Err_TGA_Format
                        jz      Err_TGA_Format
                        mov     [esi + TGA._Width], eax
                        movzx   eax, word ptr [ebx + 14]
                        test    eax, eax
                        js      Err_TGA_Format
                        jz      Err_TGA_Format
                        mov     [esi + TGA.Height], eax
                        movzx   eax, byte ptr [ebx + 16]
                        mov     [esi + TGA.Bits], eax
                        cmp     eax, 24                                 ; Must be 24 bits (bottom left)
                        je      GoodTextureFormat
                        cmp     eax, 32                                 ; or 32 bits
                        je      GoodTextureFormat
Err_TGA_Format:         FREEMEM TGA_Buffer
Err_TGA_Load:           xor     eax, eax                                ; Not loaded
                        ret
GoodTextureFormat:      mov     eax, [esi + TGA._Width]
                        mov     ecx, [esi + TGA.Height]
                        mov     [esi + TGA.Orig_Width], eax
                        mov     [esi + TGA.Orig_Height], ecx
                        ; Fix the sizes
                        .if     eax > ecx
                                mov     [esi + TGA.Height], eax
                        .endif
                        .if     eax < ecx
                                mov     [esi + TGA._Width], ecx
                        .endif
                        imul    eax, ecx
                        push    eax
                        mov     eax, [esi + TGA._Width]
                        imul    eax, [esi + TGA.Height]
                        shl     eax, 2
                        mov     eax, ALLOCMEM(eax)
                        pop     ecx
                        test    eax, eax
                        jz      Err_TGA_Format
                        mov     [esi + TGA.Datas], eax
                        mov     edi, eax

                        movzx   eax, byte ptr [ebx]                     ; Get the length of the image ID field
                        .if     [esi + TGA.Bits] == 32
                                lea     esi, [ebx + 18 + eax]           ; 32 bits image datas
Copy_32Bits:                    lodsb
                                ror     eax, 8
                                lodsb
                                ror     eax, 8
                                lodsb
                                ror     eax, 8 
                                lodsb
                                bswap   eax
                                and     eax, 000ffffffh
                                mov     edx, Color_Key
                                test    edx,edx
                                js      _No_Set_Alpha_32
                                and     edx, 000ffffffh
                                cmp     edx, eax
                                jne     _No_Set_Alpha_32
                                mov     eax, 0ff000000h                 ; Turn alpha channel on for this color
_No_Set_Alpha_32:               xor     eax, 0ff000000h
                                stosd
                                loop    Copy_32Bits
                        .else
                                lea     esi, [ebx + 18 + eax]           ; 24 bits image datas
Copy_24Bits:                    or      eax, -1
                                lodsb
                                shl     eax, 8
                                lodsb
                                shl     eax, 8
                                lodsb
                                and     eax, 000ffffffh
                                mov     edx, Color_Key
                                test    edx,edx
                                js      _No_Set_Alpha_24
                                and     edx, 000ffffffh
                                cmp     edx, eax
                                jne     _No_Set_Alpha_24
                                mov     eax, 0ff000000h                 ; Turn alpha channel on for this color
_No_Set_Alpha_24:               xor     eax, 0ff000000h
                                stosd
                                loop    Copy_24Bits
                        .endif
                        FREEMEM TGA_Buffer
                        mov     eax, TRUE                               ; Loaded
                        ret
Load_TGA                endp

; ------------------------------------------------------
; Name: Unload_TGA
; Desc: Free an allocated TARGA picture
Unload_TGA              proc    uses esi TGA_Struct:dword
                        mov     esi, TGA_Struct
                        test    esi, esi
                        jz      @F
                        mov     eax, [esi + TGA.Datas]
                        test    eax, eax
                        jz      @F
                        FREEMEM eax
@@:                     ret
Unload_TGA              endp

endif