ifndef                  _ORTHO_MATRICES_ASM
_ORTHO_MATRICES_ASM     equ     1

; ------------------------------------------------------
; Name: Enter_2D_Mode()
; Desc: Set 2d ortho mode
Enter_2D_Mode           proc    _Width:real4, _Height:real4
                        local   __Width:real8
                        local   __Height:real8
                        
                        fld     dword ptr [_Width]
                        fstp    qword ptr [__Width]
                        fld     dword ptr [_Height]
                        fstp    qword ptr [__Height]
                        invoke  glMatrixMode, GL_MODELVIEW
                        invoke  glPushMatrix
                        invoke  glLoadIdentity
                        invoke  glMatrixMode, GL_PROJECTION
                        invoke  glPushMatrix
                        invoke  glLoadIdentity
                        invoke  glOrtho, CDBL(0.0), __Width, __Height, CDBL(0.0), CDBL(0.1), CDBL(100.0)
                        ret
Enter_2D_Mode           endp

; ------------------------------------------------------
; Name: Leave_2d_Mode()
; Desc: Restore previous matrices mode
Leave_2d_Mode           proc
                        invoke  glMatrixMode, GL_PROJECTION
                        invoke  glPopMatrix
                        invoke  glMatrixMode, GL_MODELVIEW
                        invoke  glPopMatrix
                        ret
Leave_2d_Mode           endp

; ------------------------------------------------------
; Name: Draw_2D_Quad()
; Desc: Draw a textured quad
Draw_2D_Quad            proc    X:real4, Y:real4, _Width:real4, TexID:GLuint
                        invoke  glPushMatrix
                                invoke  glTranslatef, X, Y, CFLT(-1.0)
                                invoke  glEnable, GL_TEXTURE_2D
                                invoke  glBindTexture, GL_TEXTURE_2D, TexID
                                invoke  glTexParameteri, GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST
                                invoke  glTexParameteri, GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST
                                invoke  glBegin, GL_QUADS
                                        invoke  glTexCoord2f, CFLT(0.0), CFLT(1.0)
                                        invoke  glVertex3f, CFLT(0.0), CFLT(0.0), CFLT(0.0)
                                        invoke  glTexCoord2f, CFLT(0.0), CFLT(0.0)
                                        invoke  glVertex3f, CFLT(0.0), _Width, CFLT(0.0)
                                        invoke  glTexCoord2f, CFLT(1.0), CFLT(0.0)
                                        invoke  glVertex3f, _Width, _Width, CFLT(0.0)
                                        invoke  glTexCoord2f, CFLT(1.0), CFLT(1.0)
                                        invoke  glVertex3f, _Width, CFLT(0.0), CFLT(0.0)
                                invoke  glEnd
                                invoke  glDisable, GL_TEXTURE_2D
                        invoke  glPopMatrix
                        ret
Draw_2D_Quad            endp

endif